/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.multibroker.Cluster;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.BrokerAddressImpl;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ConsumerIterator;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ProtocolConsumerUIDIterator;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.selector.SelectorFormatException;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class ClusterConsumerInfo {
    private Logger logger = Globals.getLogger();
    private static final long ConsumerVersionUID = 99353142765567461L;
    private Cluster c;
    private Collection consumers = null;
    private Map pendingMsgs = null;
    private boolean cleanup = false;
    private GPacket pkt = null;

    private ClusterConsumerInfo(Collection collection, Cluster cluster) {
        this.consumers = collection;
        this.c = cluster;
    }

    private ClusterConsumerInfo(Consumer consumer, Map map, boolean bl, Cluster cluster) {
        HashSet<Consumer> hashSet = new HashSet<Consumer>();
        hashSet.add(consumer);
        this.consumers = hashSet;
        this.c = cluster;
        this.pendingMsgs = map;
        this.cleanup = bl;
    }

    private ClusterConsumerInfo(GPacket gPacket, Cluster cluster) {
        this.pkt = gPacket;
        this.c = cluster;
    }

    public static ClusterConsumerInfo newInstance(Collection collection, Cluster cluster) {
        return new ClusterConsumerInfo(collection, cluster);
    }

    public static ClusterConsumerInfo newInstance(Consumer consumer, Cluster cluster) {
        return new ClusterConsumerInfo(consumer, null, false, cluster);
    }

    public static ClusterConsumerInfo newInstance(Consumer consumer, Map map, boolean bl, Cluster cluster) {
        return new ClusterConsumerInfo(consumer, map, bl, cluster);
    }

    public static ClusterConsumerInfo newInstance(GPacket gPacket, Cluster cluster) {
        return new ClusterConsumerInfo(gPacket, cluster);
    }

    public GPacket getGPacket(short s) {
        return this.getGPacket(s, -1, null);
    }

    public GPacket getGPacket(short s, int n) {
        return this.getGPacket(s, n, null);
    }

    public GPacket getGPacket(short s, int n, BrokerAddress brokerAddress) {
        Object object;
        Object object2;
        assert (this.consumers != null);
        assert (s == 5 || s == 9);
        if (s == 9) assert (n == 4 || n == 2 || n == 3);
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType(s);
        gPacket.putProp("C", new Integer(this.consumers.size()));
        if (brokerAddress != null && this.pendingMsgs != null && this.pendingMsgs.size() > 0 && (object2 = (List)this.pendingMsgs.get(brokerAddress)) != null) {
            object = new StringBuffer();
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                Object object3 = (SysMessageID)iterator.next();
                ((StringBuffer)object).append(object3).append(" ");
            }
            gPacket.putProp("pendingMessages", new String(((StringBuffer)object).toString()));
        }
        if (this.cleanup) {
            gPacket.putProp("cleanup", new Boolean(true));
        }
        if (this.c != null) {
            this.c.marshalBrokerAddress(this.c.getSelfAddress(), gPacket);
        }
        object2 = new ByteArrayOutputStream();
        object = new DataOutputStream((OutputStream)object2);
        switch (s) {
            case 5: {
                try {
                    for (Object object3 : this.consumers) {
                        gPacket.putProp(String.valueOf(((Consumer)object3).getConsumerUID().longValue()) + ":" + "prefetch", new Integer(((Consumer)object3).getPrefetch()));
                        ClusterConsumerInfo.writeConsumer((Consumer)object3, (DataOutputStream)object);
                    }
                    ((DataOutputStream)object).flush();
                    ((OutputStream)object2).flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                gPacket.setPayload(ByteBuffer.wrap(((ByteArrayOutputStream)object2).toByteArray()));
                break;
            }
            case 9: {
                gPacket.putProp("T", new Integer(n));
                try {
                    for (Object object3 : this.consumers) {
                        ClusterConsumerInfo.writeConsumerUID(((Consumer)object3).getConsumerUID(), (DataOutputStream)object);
                    }
                    ((DataOutputStream)object).flush();
                    ((OutputStream)object2).flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                gPacket.setPayload(ByteBuffer.wrap(((ByteArrayOutputStream)object2).toByteArray()));
            }
        }
        return gPacket;
    }

    public int getConsumerCount() {
        assert (this.pkt != null);
        return (Integer)this.pkt.getProp("C");
    }

    public int getSubtype() {
        assert (this.pkt != null);
        short s = this.pkt.getType();
        assert (s == 9);
        return (Integer)this.pkt.getProp("T");
    }

    public Iterator getConsumers() throws Exception {
        assert (this.pkt != null);
        short s = this.pkt.getType();
        assert (s == 5);
        return new ConsumerIterator(this.pkt, this.pkt.getPayload().array(), this.getConsumerCount(), this.c.unmarshalBrokerAddress(this.pkt));
    }

    public Iterator getConsumerUIDs() throws Exception {
        assert (this.pkt != null);
        short s = this.pkt.getType();
        assert (s == 9);
        return new ProtocolConsumerUIDIterator(this.pkt.getPayload().array(), this.getConsumerCount(), this.c.unmarshalBrokerAddress(this.pkt));
    }

    public Set getPendingMessages() {
        assert (this.pkt != null);
        String string = (String)this.pkt.getProp("pendingMessages");
        if (string == null) {
            return null;
        }
        LinkedHashSet<SysMessageID> linkedHashSet = new LinkedHashSet<SysMessageID>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2 == null || string2.trim().equals("")) continue;
            linkedHashSet.add(SysMessageID.get(string2.trim()));
        }
        return linkedHashSet;
    }

    public boolean isCleanup() {
        assert (this.pkt != null);
        Boolean bl = (Boolean)this.pkt.getProp("cleanup");
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public boolean isConfigSyncResponse() {
        assert (this.pkt != null);
        boolean bl = false;
        if (this.pkt.getProp("M") != null) {
            bl = (Boolean)this.pkt.getProp("M");
        }
        return bl;
    }

    public boolean needReply() {
        assert (this.pkt != null);
        return this.pkt.getBit(1);
    }

    public static void writeConsumer(Consumer consumer, DataOutputStream dataOutputStream) throws IOException {
        String string = consumer.getDestinationUID().getName();
        ConsumerUID consumerUID = consumer.getConsumerUID();
        String string2 = null;
        String string3 = null;
        String string4 = consumer.getSelectorStr();
        boolean bl = consumer.getNoLocal();
        boolean bl2 = consumer.getDestinationUID().isQueue();
        boolean bl3 = true;
        boolean bl4 = false;
        int n = consumer.getLockPosition();
        int n2 = 1;
        if (consumer instanceof Subscription) {
            Subscription subscription = (Subscription)consumer;
            n2 = subscription.getMaxNumActiveConsumers();
            bl4 = true;
            string2 = subscription.getDurableName();
            string3 = subscription.getClientID();
            if (!subscription.isActive()) {
                bl3 = false;
            }
        }
        dataOutputStream.writeLong(99353142765567461L);
        dataOutputStream.writeUTF(string);
        dataOutputStream.writeBoolean(consumerUID != null);
        if (consumerUID != null) {
            ClusterConsumerInfo.writeConsumerUID(consumerUID, dataOutputStream);
        }
        dataOutputStream.writeBoolean(string3 != null);
        if (string3 != null) {
            dataOutputStream.writeUTF(string3);
        }
        dataOutputStream.writeBoolean(string2 != null);
        if (string2 != null) {
            dataOutputStream.writeUTF(string2);
        }
        dataOutputStream.writeBoolean(string4 != null);
        if (string4 != null) {
            dataOutputStream.writeUTF(string4);
        }
        dataOutputStream.writeBoolean(bl2);
        dataOutputStream.writeBoolean(bl);
        dataOutputStream.writeBoolean(bl3);
        dataOutputStream.writeBoolean(bl4);
        if (bl4) {
            dataOutputStream.writeInt(n2);
        }
        dataOutputStream.writeInt(n);
    }

    public static Consumer readConsumer(DataInputStream dataInputStream) throws IOException {
        boolean bl;
        boolean bl2;
        boolean bl3;
        Logger logger = Globals.getLogger();
        ConsumerUID consumerUID = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        long l = dataInputStream.readLong();
        if (l != 99353142765567461L) {
            throw new IOException("Wrong Consumer Version " + l + " expected " + 99353142765567461L);
        }
        string = dataInputStream.readUTF();
        boolean bl4 = dataInputStream.readBoolean();
        if (bl4) {
            consumerUID = ClusterConsumerInfo.readConsumerUID(dataInputStream);
        }
        if (bl3 = dataInputStream.readBoolean()) {
            string2 = dataInputStream.readUTF();
        }
        if (bl2 = dataInputStream.readBoolean()) {
            string3 = dataInputStream.readUTF();
        }
        if (bl = dataInputStream.readBoolean()) {
            string4 = dataInputStream.readUTF();
        }
        boolean bl5 = dataInputStream.readBoolean();
        boolean bl6 = dataInputStream.readBoolean();
        boolean bl7 = dataInputStream.readBoolean();
        boolean bl8 = false;
        int n = 1;
        try {
            bl8 = dataInputStream.readBoolean();
            if (bl8) {
                n = dataInputStream.readInt();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n2 = -1;
        try {
            n2 = dataInputStream.readInt();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            DestinationUID destinationUID = DestinationUID.getUID(string, bl5);
            if (string3 != null) {
                Subscription subscription = Subscription.findCreateDurableSubscription(string2, string3, destinationUID, string4, bl6, false, consumerUID);
                if (subscription != null) {
                    subscription.setMaxNumActiveConsumers(n);
                }
                return subscription;
            }
            if (bl8) {
                Subscription subscription = Subscription.findCreateNonDurableSubscription(string2, string4, destinationUID, bl6, consumerUID);
                if (subscription != null) {
                    subscription.setMaxNumActiveConsumers(n);
                }
                return subscription;
            }
            Consumer consumer = new Consumer(destinationUID, string4, bl6, consumerUID);
            consumer.setLockPosition(n2);
            return consumer;
        }
        catch (SelectorFormatException selectorFormatException) {
            logger.log(8, "Internal Error: Got bad selector[" + string4 + "] ", selectorFormatException);
            throw new IOException("bad selector " + string4);
        }
        catch (BrokerException brokerException) {
            logger.logStack(16, brokerException.getMessage(), brokerException);
            throw new IOException("error creating consumer ");
        }
    }

    public static void writeConsumerUID(ConsumerUID consumerUID, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeLong(consumerUID.longValue());
        dataOutputStream.writeLong(consumerUID.getConnectionUID() == null ? 0L : consumerUID.getConnectionUID().longValue());
        BrokerAddress brokerAddress = consumerUID.getBrokerAddress();
        if (brokerAddress == null) {
            brokerAddress = Globals.getMyAddress();
        }
        if (brokerAddress == null) {
            try {
                brokerAddress = new BrokerAddressImpl();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        brokerAddress.writeBrokerAddress(dataOutputStream);
    }

    public static ConsumerUID readConsumerUID(DataInputStream dataInputStream) throws IOException {
        long l = dataInputStream.readLong();
        ConnectionUID connectionUID = new ConnectionUID(dataInputStream.readLong());
        BrokerAddress brokerAddress = Globals.getMyAddress();
        BrokerAddress brokerAddress2 = (BrokerAddress)brokerAddress.clone();
        brokerAddress2.readBrokerAddress(dataInputStream);
        ConsumerUID consumerUID = new ConsumerUID(l);
        consumerUID.setConnectionUID(connectionUID);
        consumerUID.setBrokerAddress(brokerAddress2);
        return consumerUID;
    }

    public static GPacket getReplyGPacket(short s, int n) {
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType(s);
        gPacket.putProp("S", new Integer(n));
        return gPacket;
    }
}

