/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.FaultInjection;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.persist.HABrokerInfo;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BaseDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BrokerDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.ConsumerStateDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.MessageDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.StoreBeingTakenOverException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

class MessageDAOImpl
extends BaseDAOImpl
implements MessageDAO {
    protected String tableName;
    protected static int msgColumnType = -2147483647;
    protected String insertSQL;
    protected String updateDestinationSQL;
    protected String deleteSQL;
    protected String deleteByDstSQL;
    protected String selectSQL;
    protected String selectMsgsBySessionSQL;
    protected String selectMsgsByBrokerSQL;
    protected String selectMsgIDsAndDstIDsByBrokerSQL;
    protected String selectForUpdateSQL;
    protected String selectBrokerSQL;
    protected String selectCountByDstSQL;
    protected String selectCountByBrokerSQL;
    protected String selectCountByConsumerAckedSQL;
    protected String selectIDsByDstSQL;
    protected String selectExistSQL;
    protected String selectCanInsertSQL;
    private FaultInjection fi = FaultInjection.getInjection();

    MessageDAOImpl() throws BrokerException {
        DBManager dBManager = DBManager.getDBManager();
        this.tableName = dBManager.getTableName("MQMSG41");
        this.insertSQL = new StringBuffer(128).append("INSERT INTO ").append(this.tableName).append(" ( ").append("ID").append(", ").append("MESSAGE_SIZE").append(", ").append("STORE_SESSION_ID").append(", ").append("DESTINATION_ID").append(", ").append("TRANSACTION_ID").append(", ").append("CREATED_TS").append(", ").append("MESSAGE").append(") VALUES ( ?, ?, ?, ?, ?, ?, ? )").toString();
        this.updateDestinationSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("DESTINATION_ID").append(" = ?, ").append("MESSAGE_SIZE").append(" = ?, ").append("MESSAGE").append(" = ?").append(" WHERE ").append("ID").append(" = ?").toString();
        this.deleteSQL = new StringBuffer(128).append("DELETE FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.deleteByDstSQL = new StringBuffer(128).append("DELETE FROM ").append(this.tableName).append(" WHERE ").append("DESTINATION_ID").append(" = ?").append(" AND ").append("STORE_SESSION_ID").append(" IN (SELECT ").append("ID").append(" FROM ").append(dBManager.getTableName("MQSES41")).append(" WHERE ").append("BROKER_ID").append(" = ?)").toString();
        this.selectCountByBrokerSQL = new StringBuffer(128).append("SELECT COUNT(*) FROM ").append(this.tableName).append(" msgTbl, ").append(dBManager.getTableName("MQSES41")).append(" sesTbl").append(" WHERE sesTbl.").append("BROKER_ID").append(" = ?").append(" AND sesTbl.").append("ID").append(" = msgTbl.").append("STORE_SESSION_ID").toString();
        this.selectCountByDstSQL = new StringBuffer(128).append("SELECT totalmsg, totalsize, ").append("ID").append(" FROM ").append(dBManager.getTableName("MQDST41")).append(", (SELECT COUNT(msgTbl.").append("ID").append(") AS totalmsg, SUM(").append("MESSAGE_SIZE").append(") AS totalsize").append(" FROM ").append(this.tableName).append(" msgTbl, ").append(dBManager.getTableName("MQSES41")).append(" sesTbl").append(" WHERE sesTbl.").append("BROKER_ID").append(" = ?").append(" AND sesTbl.").append("ID").append(" = msgTbl.").append("STORE_SESSION_ID").append(" AND ").append("DESTINATION_ID").append(" = ?) msgtable").append(" WHERE ").append("ID").append(" = ?").toString();
        this.selectCountByConsumerAckedSQL = new StringBuffer(128).append("SELECT COUNT(*) AS total, SUM(CASE WHEN ").append("STATE").append(" = ").append(2).append(" THEN 1 ELSE 0 END) AS totalAcked").append(" FROM ").append(dBManager.getTableName("MQCONSTATE41")).append(" WHERE ").append("MESSAGE_ID").append(" = ?").toString();
        this.selectSQL = new StringBuffer(128).append("SELECT ").append("MESSAGE").append(" FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.selectMsgsBySessionSQL = new StringBuffer(128).append("SELECT ").append("MESSAGE").append(" FROM ").append(this.tableName).append(" WHERE ").append("STORE_SESSION_ID").append(" = ?").toString();
        this.selectMsgsByBrokerSQL = new StringBuffer(128).append("SELECT ").append("MESSAGE").append(" FROM ").append(this.tableName).append(" msgTbl, ").append(dBManager.getTableName("MQSES41")).append(" sesTbl").append(" WHERE sesTbl.").append("BROKER_ID").append(" = ?").append(" AND sesTbl.").append("ID").append(" = msgTbl.").append("STORE_SESSION_ID").toString();
        this.selectMsgIDsAndDstIDsByBrokerSQL = new StringBuffer(128).append("SELECT msgTbl.").append("ID").append(", msgTbl.").append("DESTINATION_ID").append(" FROM ").append(this.tableName).append(" msgTbl, ").append(dBManager.getTableName("MQSES41")).append(" sesTbl").append(" WHERE sesTbl.").append("BROKER_ID").append(" = ?").append(" AND sesTbl.").append("ID").append(" = msgTbl.").append("STORE_SESSION_ID").toString();
        this.selectForUpdateSQL = new StringBuffer(128).append(this.selectSQL).append(" FOR UPDATE").toString();
        this.selectBrokerSQL = new StringBuffer(128).append("SELECT ").append("BROKER_ID").append(" FROM ").append(this.tableName).append(" msgTbl, ").append(dBManager.getTableName("MQSES41")).append(" sesTbl").append(" WHERE msgTbl.").append("ID").append(" = ?").append(" AND msgTbl.").append("STORE_SESSION_ID").append(" = sesTbl.").append("ID").toString();
        this.selectIDsByDstSQL = new StringBuffer(128).append("SELECT msgTbl.").append("ID").append(" FROM ").append(this.tableName).append(" msgTbl, ").append(dBManager.getTableName("MQSES41")).append(" sesTbl").append(" WHERE sesTbl.").append("BROKER_ID").append(" = ?").append(" AND sesTbl.").append("ID").append(" = msgTbl.").append("STORE_SESSION_ID").append(" AND ").append("DESTINATION_ID").append(" = ?").toString();
        this.selectExistSQL = new StringBuffer(128).append("SELECT ").append("ID").append(" FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        StringBuffer stringBuffer = new StringBuffer(256).append("SELECT MAX(msgTS), MAX(dstTS), MAX(bkrState) FROM (").append("SELECT ").append("CREATED_TS").append(" AS msgTS, 0 AS dstTS, 0 AS bkrState FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").append(" UNION ").append("SELECT 0 AS msgTS, ").append("CREATED_TS").append(" AS dstTS, 0 AS bkrState FROM ").append(dBManager.getTableName("MQDST41")).append(" WHERE ").append("ID").append(" = ?");
        if (Globals.getHAEnabled()) {
            stringBuffer.append(" UNION ").append("SELECT 0 AS msgTS, 0 AS dstTS, ").append("STATE").append(" AS bkrState FROM ").append(dBManager.getTableName("MQBKR41")).append(" WHERE ").append("ID").append(" = ? AND ").append("STATE").append(" IN (").append(9).append(", ").append(7).append(", ").append(8).append(", ").append(10).append(")");
        }
        stringBuffer.append(") tbl");
        this.selectCanInsertSQL = stringBuffer.toString();
    }

    public final String getTableNamePrefix() {
        return "MQMSG41";
    }

    public String getTableName() {
        return this.tableName;
    }

    public void insert(Connection connection, DestinationUID destinationUID, Packet packet, ConsumerUID[] consumerUIDArray, int[] nArray, long l, long l2, boolean bl) throws BrokerException {
        String string = null;
        if (destinationUID != null) {
            string = destinationUID.toString();
        }
        this.insert(connection, string, packet, consumerUIDArray, nArray, l, l2, bl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void insert(Connection connection, String string, Packet packet, ConsumerUID[] consumerUIDArray, int[] nArray, long l, long l2, boolean bl) throws BrokerException {
        Exception exception;
        PreparedStatement preparedStatement;
        block19: {
            SysMessageID sysMessageID = packet.getSysMessageID();
            String string2 = sysMessageID.getUniqueName();
            int n = packet.getPacketSize();
            long l3 = packet.getTransactionID();
            if (string == null) {
                string = DestinationUID.getUniqueString(packet.getDestination(), packet.getIsQueue());
            }
            boolean bl2 = false;
            preparedStatement = null;
            exception = null;
            try {
                try {
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(false);
                        bl2 = true;
                    }
                    if (bl) {
                        this.canInsertMsg(connection, string2, string, dBManager.getBrokerID());
                    }
                    try {
                        byte[] byArray = packet.getBytes();
                        preparedStatement = connection.prepareStatement(this.insertSQL);
                        preparedStatement.setString(1, string2);
                        preparedStatement.setInt(2, n);
                        preparedStatement.setLong(3, l);
                        preparedStatement.setString(4, string);
                        Util.setLong(preparedStatement, 5, l3 == 0L ? -1L : l3);
                        preparedStatement.setLong(6, l2);
                        Util.setBytes(preparedStatement, 7, byArray);
                        preparedStatement.executeUpdate();
                        if (consumerUIDArray != null) {
                            dBManager.getDAOFactory().getConsumerStateDAO().insert(connection, string, sysMessageID, consumerUIDArray, nArray, false);
                        }
                        if (bl2) {
                            connection.commit();
                        }
                    }
                    catch (Exception exception2) {
                        Exception exception3;
                        exception = exception2;
                        try {
                            if (connection != null && !connection.getAutoCommit()) {
                                connection.rollback();
                            }
                        }
                        catch (SQLException sQLException) {
                            this.logger.log(32, "B4080", sQLException);
                        }
                        if (exception2 instanceof BrokerException) {
                            throw (BrokerException)exception2;
                        }
                        if (exception2 instanceof IOException) {
                            exception3 = DBManager.wrapIOException("[" + this.insertSQL + "]", (IOException)exception2);
                            throw new BrokerException(this.br.getKString("B4004", string2), exception3);
                        }
                        if (exception2 instanceof SQLException) {
                            exception3 = DBManager.wrapSQLException("[" + this.insertSQL + "]", (SQLException)exception2);
                            throw new BrokerException(this.br.getKString("B4004", string2), exception3);
                        }
                        exception3 = exception2;
                        throw new BrokerException(this.br.getKString("B4004", string2), exception3);
                    }
                    Object var23_22 = null;
                    if (!bl2) break block19;
                }
                catch (BrokerException brokerException) {
                    exception = brokerException;
                    throw brokerException;
                }
            }
            catch (Throwable throwable) {
                Object var23_23 = null;
                if (bl2) {
                    Util.close(null, preparedStatement, connection, exception);
                    throw throwable;
                }
                Util.close(null, preparedStatement, null, exception);
                throw throwable;
            }
            Util.close(null, preparedStatement, connection, exception);
            return;
        }
        Util.close(null, preparedStatement, null, exception);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void moveMessage(Connection connection, Packet packet, DestinationUID destinationUID, DestinationUID destinationUID2, ConsumerUID[] consumerUIDArray, int[] nArray) throws IOException, BrokerException {
        Exception exception;
        PreparedStatement preparedStatement;
        block14: {
            SysMessageID sysMessageID = (SysMessageID)packet.getSysMessageID().clone();
            String string = sysMessageID.getUniqueName();
            int n = packet.getPacketSize();
            boolean bl = false;
            preparedStatement = null;
            exception = null;
            try {
                try {
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(false);
                        bl = true;
                    }
                    byte[] byArray = packet.getBytes();
                    preparedStatement = connection.prepareStatement(this.updateDestinationSQL);
                    preparedStatement.setString(1, destinationUID2.toString());
                    preparedStatement.setInt(2, n);
                    Util.setBytes(preparedStatement, 3, byArray);
                    preparedStatement.setString(4, string);
                    if (preparedStatement.executeUpdate() == 0) {
                        throw new BrokerException(this.br.getKString("B3007", string, destinationUID), 404);
                    }
                    ConsumerStateDAO consumerStateDAO = dBManager.getDAOFactory().getConsumerStateDAO();
                    consumerStateDAO.deleteByMessageID(connection, sysMessageID);
                    if (consumerUIDArray != null || nArray != null) {
                        consumerStateDAO.insert(connection, destinationUID2.toString(), sysMessageID, consumerUIDArray, nArray, false);
                    }
                    if (bl) {
                        connection.commit();
                    }
                }
                catch (Exception exception2) {
                    exception = exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080", sQLException);
                    }
                    if (exception2 instanceof BrokerException) {
                        throw (BrokerException)exception2;
                    }
                    Exception exception3 = exception2 instanceof SQLException ? DBManager.wrapSQLException("[" + this.updateDestinationSQL + "]", (SQLException)exception2) : exception2;
                    Object[] objectArray = new Object[]{string, destinationUID, destinationUID2};
                    throw new BrokerException(this.br.getKString("B4187", objectArray), exception3);
                }
                Object var17_20 = null;
                if (!bl) break block14;
            }
            catch (Throwable throwable) {
                Object var17_21 = null;
                if (bl) {
                    Util.close(null, preparedStatement, connection, exception);
                    throw throwable;
                }
                Util.close(null, preparedStatement, null, exception);
                throw throwable;
            }
            Util.close(null, preparedStatement, connection, exception);
            return;
        }
        Util.close(null, preparedStatement, null, exception);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void delete(Connection connection, DestinationUID destinationUID, SysMessageID sysMessageID) throws BrokerException {
        Exception exception;
        PreparedStatement preparedStatement;
        block19: {
            String string = sysMessageID.getUniqueName();
            boolean bl = false;
            preparedStatement = null;
            exception = null;
            try {
                try {
                    Object object;
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(false);
                        bl = true;
                    }
                    dBManager.getDAOFactory().getConsumerStateDAO().deleteByMessageID(connection, sysMessageID);
                    if (this.fi.FAULT_INJECTION) {
                        object = new HashMap<String, String>();
                        ((HashMap)object).put("mqDestinationName", DestinationUID.getUniqueString(destinationUID.getName(), destinationUID.isQueue()));
                        this.fi.checkFaultAndExit("txn.commit.1_8", (Map)object, 2, false);
                    }
                    preparedStatement = connection.prepareStatement(this.deleteSQL);
                    preparedStatement.setString(1, string);
                    if (preparedStatement.executeUpdate() == 0) {
                        throw new BrokerException(this.br.getKString("B3007", string, destinationUID), 404);
                    }
                    if (Globals.getHAEnabled()) {
                        object = dBManager.getBrokerID();
                        BrokerDAO brokerDAO = dBManager.getDAOFactory().getBrokerDAO();
                        if (brokerDAO.isBeingTakenOver(connection, (String)object)) {
                            StoreBeingTakenOverException storeBeingTakenOverException = new StoreBeingTakenOverException(this.br.getKString("B3223"));
                            try {
                                HABrokerInfo hABrokerInfo = brokerDAO.getBrokerInfo(connection, (String)object);
                                this.logger.log(32, this.br.getKString("B4117", hABrokerInfo.toString()), storeBeingTakenOverException);
                                throw storeBeingTakenOverException;
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            throw storeBeingTakenOverException;
                        }
                    }
                    if (bl) {
                        connection.commit();
                    }
                }
                catch (Exception exception2) {
                    Exception exception3;
                    exception = exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080", sQLException);
                    }
                    if (exception2 instanceof BrokerException) {
                        throw (BrokerException)exception2;
                    }
                    if (exception2 instanceof SQLException) {
                        exception3 = DBManager.wrapSQLException("[" + this.deleteSQL + "]", (SQLException)exception2);
                        throw new BrokerException(this.br.getKString("B4033", string), exception3);
                    }
                    exception3 = exception2;
                    throw new BrokerException(this.br.getKString("B4033", string), exception3);
                }
                Object var14_17 = null;
                if (!bl) break block19;
            }
            catch (Throwable throwable) {
                Object var14_18 = null;
                if (bl) {
                    Util.close(null, preparedStatement, connection, exception);
                    throw throwable;
                }
                Util.close(null, preparedStatement, null, exception);
                throw throwable;
            }
            Util.close(null, preparedStatement, connection, exception);
            return;
        }
        Util.close(null, preparedStatement, null, exception);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int deleteByDestination(Connection connection, DestinationUID destinationUID) throws BrokerException {
        int n;
        Exception exception;
        PreparedStatement preparedStatement;
        block13: {
            String string = destinationUID.toString();
            boolean bl = false;
            preparedStatement = null;
            exception = null;
            try {
                try {
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(false);
                        bl = true;
                    }
                    dBManager.getDAOFactory().getDestinationDAO().checkDestination(connection, string);
                    dBManager.getDAOFactory().getConsumerStateDAO().deleteByDestination(connection, destinationUID);
                    preparedStatement = connection.prepareStatement(this.deleteByDstSQL);
                    preparedStatement.setString(1, string);
                    preparedStatement.setString(2, dBManager.getBrokerID());
                    n = preparedStatement.executeUpdate();
                    if (bl) {
                        connection.commit();
                    }
                }
                catch (Exception exception2) {
                    Exception exception3;
                    exception = exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080", sQLException);
                    }
                    if (exception2 instanceof BrokerException) {
                        throw (BrokerException)exception2;
                    }
                    if (exception2 instanceof SQLException) {
                        exception3 = DBManager.wrapSQLException("[" + this.deleteByDstSQL + "]", (SQLException)exception2);
                        throw new BrokerException(this.br.getKString("B4150", string), exception3);
                    }
                    exception3 = exception2;
                    throw new BrokerException(this.br.getKString("B4150", string), exception3);
                }
                Object var11_10 = null;
                if (!bl) break block13;
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                if (bl) {
                    Util.close(null, preparedStatement, connection, exception);
                    throw throwable;
                }
                Util.close(null, preparedStatement, null, exception);
                throw throwable;
            }
            Util.close(null, preparedStatement, connection, exception);
            return n;
        }
        Util.close(null, preparedStatement, null, exception);
        return n;
    }

    public void deleteAll(Connection connection) throws BrokerException {
        String string = null;
        if (Globals.getHAEnabled()) {
            DBManager dBManager = DBManager.getDBManager();
            string = new StringBuffer(128).append("EXISTS (SELECT ").append("ID").append(" FROM ").append(dBManager.getTableName("MQSES41")).append(" WHERE ").append("ID").append(" = ").append(this.tableName).append(".").append("STORE_SESSION_ID").append(" AND ").append("BROKER_ID").append(" = '").append(dBManager.getBrokerID()).append("')").toString();
        }
        this.deleteAll(connection, string, null, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getBroker(Connection connection, DestinationUID destinationUID, String string) throws BrokerException {
        Exception exception;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        String string2;
        block12: {
            string2 = null;
            boolean bl = false;
            preparedStatement = null;
            resultSet = null;
            exception = null;
            try {
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectBrokerSQL);
                    preparedStatement.setString(1, string);
                    resultSet = preparedStatement.executeQuery();
                    if (!resultSet.next()) throw new BrokerException(this.br.getKString("B3007", string, destinationUID), 404);
                    string2 = resultSet.getString(1);
                    Object var12_9 = null;
                    if (!bl) break block12;
                }
                catch (Exception exception2) {
                    Exception exception3;
                    exception = exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080[" + this.selectBrokerSQL + "]", sQLException);
                    }
                    if (exception2 instanceof BrokerException) {
                        throw (BrokerException)exception2;
                    }
                    if (exception2 instanceof SQLException) {
                        exception3 = DBManager.wrapSQLException("[" + this.selectBrokerSQL + "]", (SQLException)exception2);
                        throw new BrokerException(this.br.getKString("B4107", string), exception3);
                    }
                    exception3 = exception2;
                    throw new BrokerException(this.br.getKString("B4107", string), exception3);
                }
            }
            catch (Throwable throwable) {
                Object var12_10 = null;
                if (bl) {
                    Util.close(resultSet, preparedStatement, connection, exception);
                    throw throwable;
                }
                Util.close(resultSet, preparedStatement, null, exception);
                throw throwable;
            }
            Util.close(resultSet, preparedStatement, connection, exception);
            return string2;
        }
        Util.close(resultSet, preparedStatement, null, exception);
        return string2;
    }

    public Packet getMessage(Connection connection, DestinationUID destinationUID, SysMessageID sysMessageID) throws BrokerException {
        return this.getMessage(connection, destinationUID, sysMessageID.toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Packet getMessage(Connection connection, DestinationUID destinationUID, String string) throws BrokerException {
        Packet packet;
        block13: {
            Exception exception;
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block12: {
                packet = null;
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                exception = null;
                try {
                    try {
                        if (connection == null) {
                            connection = DBManager.getDBManager().getConnection(true);
                            bl = true;
                        }
                        preparedStatement = connection.prepareStatement(this.selectSQL);
                        preparedStatement.setString(1, string);
                        resultSet = preparedStatement.executeQuery();
                        packet = (Packet)this.loadData(resultSet, true);
                    }
                    catch (Exception exception2) {
                        Exception exception3;
                        exception = exception2;
                        try {
                            if (connection != null && !connection.getAutoCommit()) {
                                connection.rollback();
                            }
                        }
                        catch (SQLException sQLException) {
                            this.logger.log(32, "B4080[" + this.selectSQL + "]", sQLException);
                        }
                        if (exception2 instanceof BrokerException) {
                            throw (BrokerException)exception2;
                        }
                        if (exception2 instanceof IOException) {
                            exception3 = DBManager.wrapIOException("[" + this.selectSQL + "]", (IOException)exception2);
                            throw new BrokerException(this.br.getKString("B4107", string), exception3);
                        }
                        if (exception2 instanceof SQLException) {
                            exception3 = DBManager.wrapSQLException("[" + this.selectSQL + "]", (SQLException)exception2);
                            throw new BrokerException(this.br.getKString("B4107", string), exception3);
                        }
                        exception3 = exception2;
                        throw new BrokerException(this.br.getKString("B4107", string), exception3);
                    }
                    Object var12_9 = null;
                    if (!bl) break block12;
                }
                catch (Throwable throwable) {
                    Object var12_10 = null;
                    if (bl) {
                        Util.close(resultSet, preparedStatement, connection, exception);
                        throw throwable;
                    }
                    Util.close(resultSet, preparedStatement, null, exception);
                    throw throwable;
                }
                Util.close(resultSet, preparedStatement, connection, exception);
                break block13;
            }
            Util.close(resultSet, preparedStatement, null, exception);
        }
        if (packet != null) return packet;
        throw new BrokerException(this.br.getKString("B3007", string, destinationUID), 404);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List getMessagesByBroker(Connection connection, String string) throws BrokerException {
        Exception exception;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        List list;
        block13: {
            list = Collections.EMPTY_LIST;
            boolean bl = false;
            preparedStatement = null;
            resultSet = null;
            exception = null;
            try {
                try {
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectMsgsByBrokerSQL);
                    preparedStatement.setString(1, string);
                    resultSet = preparedStatement.executeQuery();
                    list = (List)this.loadData(resultSet, false);
                }
                catch (Exception exception2) {
                    Exception exception3;
                    exception = exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080", sQLException);
                    }
                    if (exception2 instanceof BrokerException) {
                        throw (BrokerException)exception2;
                    }
                    if (exception2 instanceof IOException) {
                        exception3 = DBManager.wrapIOException("[" + this.selectMsgsByBrokerSQL + "]", (IOException)exception2);
                        throw new BrokerException(this.br.getKString("B3176", string), exception3);
                    }
                    if (exception2 instanceof SQLException) {
                        exception3 = DBManager.wrapSQLException("[" + this.selectMsgsByBrokerSQL + "]", (SQLException)exception2);
                        throw new BrokerException(this.br.getKString("B3176", string), exception3);
                    }
                    exception3 = exception2;
                    throw new BrokerException(this.br.getKString("B3176", string), exception3);
                }
                Object var11_10 = null;
                if (!bl) break block13;
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                if (bl) {
                    Util.close(resultSet, preparedStatement, connection, exception);
                    throw throwable;
                }
                Util.close(resultSet, preparedStatement, null, exception);
                throw throwable;
            }
            Util.close(resultSet, preparedStatement, connection, exception);
            return list;
        }
        Util.close(resultSet, preparedStatement, null, exception);
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map getMsgIDsAndDstIDsByBroker(Connection connection, String string) throws BrokerException {
        Exception exception;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        HashMap<String, String> hashMap;
        block15: {
            hashMap = new HashMap<String, String>();
            boolean bl = false;
            preparedStatement = null;
            resultSet = null;
            exception = null;
            try {
                try {
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(true);
                        bl = true;
                    }
                    if (string == null) {
                        string = dBManager.getBrokerID();
                    }
                    preparedStatement = connection.prepareStatement(this.selectMsgIDsAndDstIDsByBrokerSQL);
                    preparedStatement.setString(1, string);
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        hashMap.put(resultSet.getString(1), resultSet.getString(2));
                    }
                    Object var11_10 = null;
                    if (!bl) break block15;
                }
                catch (Exception exception2) {
                    Exception exception3;
                    exception = exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080", sQLException);
                    }
                    if (exception2 instanceof BrokerException) {
                        throw (BrokerException)exception2;
                    }
                    if (exception2 instanceof IOException) {
                        exception3 = DBManager.wrapIOException("[" + this.selectMsgIDsAndDstIDsByBrokerSQL + "]", (IOException)exception2);
                        throw new BrokerException(this.br.getKString("B3176", string), exception3);
                    }
                    if (exception2 instanceof SQLException) {
                        exception3 = DBManager.wrapSQLException("[" + this.selectMsgIDsAndDstIDsByBrokerSQL + "]", (SQLException)exception2);
                        throw new BrokerException(this.br.getKString("B3176", string), exception3);
                    }
                    exception3 = exception2;
                    throw new BrokerException(this.br.getKString("B3176", string), exception3);
                }
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                if (bl) {
                    Util.close(resultSet, preparedStatement, connection, exception);
                    throw throwable;
                }
                Util.close(resultSet, preparedStatement, null, exception);
                throw throwable;
            }
            Util.close(resultSet, preparedStatement, connection, exception);
            return hashMap;
        }
        Util.close(resultSet, preparedStatement, null, exception);
        return hashMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List getIDsByDst(Connection connection, Destination destination, String string) throws BrokerException {
        Exception exception;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        ArrayList<String> arrayList;
        block13: {
            arrayList = new ArrayList<String>();
            String string2 = destination.getUniqueName();
            boolean bl = false;
            preparedStatement = null;
            resultSet = null;
            exception = null;
            try {
                try {
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectIDsByDstSQL);
                    preparedStatement.setString(1, string);
                    preparedStatement.setString(2, string2);
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        String string3 = resultSet.getString(1);
                        arrayList.add(string3);
                    }
                    Object var13_15 = null;
                    if (!bl) break block13;
                }
                catch (Exception exception2) {
                    Exception exception3;
                    exception = exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080[" + this.selectIDsByDstSQL + "]", sQLException);
                    }
                    if (exception2 instanceof BrokerException) {
                        throw (BrokerException)exception2;
                    }
                    if (exception2 instanceof SQLException) {
                        exception3 = DBManager.wrapSQLException("[" + this.selectIDsByDstSQL + "]", (SQLException)exception2);
                        throw new BrokerException(this.br.getKString("B4145"), string2, exception3);
                    }
                    exception3 = exception2;
                    throw new BrokerException(this.br.getKString("B4145"), string2, exception3);
                }
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                if (bl) {
                    Util.close(resultSet, preparedStatement, connection, exception);
                    throw throwable;
                }
                Util.close(resultSet, preparedStatement, null, exception);
                throw throwable;
            }
            Util.close(resultSet, preparedStatement, connection, exception);
            return arrayList;
        }
        Util.close(resultSet, preparedStatement, null, exception);
        return arrayList;
    }

    public Enumeration messageEnumeration(Destination destination, String string) throws BrokerException {
        MsgEnumeration msgEnumeration;
        Connection connection = null;
        BrokerException brokerException = null;
        try {
            DBManager dBManager = DBManager.getDBManager();
            connection = dBManager.getConnection(true);
            dBManager.getDAOFactory().getDestinationDAO().checkDestination(connection, destination.getUniqueName());
            Iterator iterator = this.getIDsByDst(connection, destination, string).iterator();
            msgEnumeration = new MsgEnumeration(destination.getDestinationUID(), this, iterator);
            Object var9_9 = null;
        }
        catch (BrokerException brokerException2) {
            try {
                brokerException = brokerException2;
                throw brokerException2;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                Util.close(null, null, connection, brokerException);
                throw throwable;
            }
        }
        Util.close(null, null, connection, brokerException);
        return msgEnumeration;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasMessageBeenAcked(Connection connection, DestinationUID destinationUID, SysMessageID sysMessageID) throws BrokerException {
        int n;
        int n2;
        block13: {
            Exception exception;
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block11: {
                n2 = -1;
                n = -1;
                String string = sysMessageID.getUniqueName();
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                exception = null;
                try {
                    try {
                        if (connection == null) {
                            connection = DBManager.getDBManager().getConnection(true);
                            bl = true;
                        }
                        preparedStatement = connection.prepareStatement(this.selectCountByConsumerAckedSQL);
                        preparedStatement.setString(1, string);
                        resultSet = preparedStatement.executeQuery();
                        if (!resultSet.next()) throw new BrokerException(this.br.getKString("B3007", string, destinationUID), 404);
                        n2 = resultSet.getInt(1);
                        n = resultSet.getInt(2);
                        Object var14_11 = null;
                        if (!bl) break block11;
                    }
                    catch (Exception exception2) {
                        Exception exception3;
                        exception = exception2;
                        try {
                            if (connection != null && !connection.getAutoCommit()) {
                                connection.rollback();
                            }
                        }
                        catch (SQLException sQLException) {
                            this.logger.log(32, "B4080[" + this.selectCountByConsumerAckedSQL + "]", sQLException);
                        }
                        if (exception2 instanceof BrokerException) {
                            throw (BrokerException)exception2;
                        }
                        if (exception2 instanceof SQLException) {
                            exception3 = DBManager.wrapSQLException("[" + this.selectCountByConsumerAckedSQL + "]", (SQLException)exception2);
                            throw new BrokerException(this.br.getKString("B4107", string), exception3);
                        }
                        exception3 = exception2;
                        throw new BrokerException(this.br.getKString("B4107", string), exception3);
                    }
                }
                catch (Throwable throwable) {
                    Object var14_12 = null;
                    if (bl) {
                        Util.close(resultSet, preparedStatement, connection, exception);
                        throw throwable;
                    }
                    Util.close(resultSet, preparedStatement, null, exception);
                    throw throwable;
                }
                Util.close(resultSet, preparedStatement, connection, exception);
                break block13;
            }
            Util.close(resultSet, preparedStatement, null, exception);
        }
        if (n2 <= 0) return false;
        if (n2 != n) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasMessage(Connection connection, String string) throws BrokerException {
        Exception exception;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        boolean bl;
        block13: {
            bl = false;
            boolean bl2 = false;
            preparedStatement = null;
            resultSet = null;
            exception = null;
            try {
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl2 = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectExistSQL);
                    preparedStatement.setString(1, string);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        bl = true;
                    }
                }
                catch (Exception exception2) {
                    Exception exception3;
                    exception = exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080[" + this.selectExistSQL + "]", sQLException);
                    }
                    if (exception2 instanceof BrokerException) {
                        throw (BrokerException)exception2;
                    }
                    if (exception2 instanceof SQLException) {
                        exception3 = DBManager.wrapSQLException("[" + this.selectExistSQL + "]", (SQLException)exception2);
                        throw new BrokerException(this.br.getKString("B4107", string), exception3);
                    }
                    exception3 = exception2;
                    throw new BrokerException(this.br.getKString("B4107", string), exception3);
                }
                Object var11_8 = null;
                if (!bl2) break block13;
            }
            catch (Throwable throwable) {
                Object var11_9 = null;
                if (bl2) {
                    Util.close(resultSet, preparedStatement, connection, exception);
                    throw throwable;
                }
                Util.close(resultSet, preparedStatement, null, exception);
                throw throwable;
            }
            Util.close(resultSet, preparedStatement, connection, exception);
            return bl;
        }
        Util.close(resultSet, preparedStatement, null, exception);
        return bl;
    }

    public void checkMessage(Connection connection, String string, String string2) throws BrokerException {
        if (!this.hasMessage(connection, string2)) {
            try {
                if (connection != null && !connection.getAutoCommit()) {
                    connection.rollback();
                }
            }
            catch (SQLException sQLException) {
                this.logger.log(32, "B4080[checkMessage():" + string2 + ", " + string + "]", sQLException);
            }
            throw new BrokerException(this.br.getKString("B3007", string2, string), 404);
        }
    }

    public HashMap getDebugInfo(Connection connection) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = -1;
        try {
            n = this.getRowCount(null, null);
        }
        catch (Exception exception) {
            this.logger.log(32, exception.getMessage(), exception.getCause());
        }
        hashMap.put("Messages(" + this.tableName + ")", String.valueOf(n));
        return hashMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getMessageCount(Connection connection, String string) throws BrokerException {
        Exception exception;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        int n;
        block13: {
            n = -1;
            boolean bl = false;
            preparedStatement = null;
            resultSet = null;
            exception = null;
            try {
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectCountByBrokerSQL);
                    preparedStatement.setString(1, string);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        n = resultSet.getInt(1);
                    }
                }
                catch (Exception exception2) {
                    Exception exception3;
                    exception = exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080[" + this.selectCountByBrokerSQL + "]", sQLException);
                    }
                    if (exception2 instanceof BrokerException) {
                        throw (BrokerException)exception2;
                    }
                    if (exception2 instanceof SQLException) {
                        exception3 = DBManager.wrapSQLException("[" + this.selectCountByBrokerSQL + "]", (SQLException)exception2);
                        throw new BrokerException(this.br.getKString("B4230", string), exception3);
                    }
                    exception3 = exception2;
                    throw new BrokerException(this.br.getKString("B4230", string), exception3);
                }
                Object var11_8 = null;
                if (!bl) break block13;
            }
            catch (Throwable throwable) {
                Object var11_9 = null;
                if (bl) {
                    Util.close(resultSet, preparedStatement, connection, exception);
                    throw throwable;
                }
                Util.close(resultSet, preparedStatement, null, exception);
                throw throwable;
            }
            Util.close(resultSet, preparedStatement, connection, exception);
            return n;
        }
        Util.close(resultSet, preparedStatement, null, exception);
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap getMessageStorageInfo(Connection connection, Destination destination) throws BrokerException {
        Exception exception;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        HashMap<String, Number> hashMap;
        block12: {
            hashMap = new HashMap<String, Number>(2);
            String string = destination.getUniqueName();
            boolean bl = false;
            preparedStatement = null;
            resultSet = null;
            exception = null;
            try {
                try {
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectCountByDstSQL);
                    preparedStatement.setString(1, dBManager.getBrokerID());
                    preparedStatement.setString(2, string);
                    preparedStatement.setString(3, string);
                    resultSet = preparedStatement.executeQuery();
                    if (!resultSet.next()) throw new BrokerException(this.br.getKString("B3013", string), 404);
                    hashMap.put("numMsgs", new Integer(resultSet.getInt(1)));
                    hashMap.put("totalMsgBytes", new Long(resultSet.getLong(2)));
                    Object var12_11 = null;
                    if (!bl) break block12;
                }
                catch (Exception exception2) {
                    Exception exception3;
                    exception = exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080[" + this.selectCountByDstSQL + "]", sQLException);
                    }
                    if (exception2 instanceof BrokerException) {
                        throw (BrokerException)exception2;
                    }
                    if (exception2 instanceof SQLException) {
                        exception3 = DBManager.wrapSQLException("[" + this.selectCountByDstSQL + "]", (SQLException)exception2);
                        throw new BrokerException(this.br.getKString("B4152", string), exception3);
                    }
                    exception3 = exception2;
                    throw new BrokerException(this.br.getKString("B4152", string), exception3);
                }
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                if (bl) {
                    Util.close(resultSet, preparedStatement, connection, exception);
                    throw throwable;
                }
                Util.close(resultSet, preparedStatement, null, exception);
                throw throwable;
            }
            Util.close(resultSet, preparedStatement, connection, exception);
            return hashMap;
        }
        Util.close(resultSet, preparedStatement, null, exception);
        return hashMap;
    }

    protected Object loadData(ResultSet resultSet, boolean bl) throws IOException, SQLException {
        ArrayList<Packet> arrayList = null;
        if (!bl) {
            arrayList = new ArrayList<Packet>(100);
        }
        while (resultSet.next()) {
            Packet packet = new Packet(false);
            packet.generateTimestamp(false);
            packet.generateSequenceNumber(false);
            InputStream inputStream = null;
            if (this.getMsgColumnType(resultSet, 1) == 2004) {
                Blob blob = resultSet.getBlob(1);
                inputStream = blob.getBinaryStream();
            } else {
                inputStream = resultSet.getBinaryStream(1);
            }
            packet.readPacket(inputStream);
            inputStream.close();
            if (Store.getDEBUG()) {
                this.logger.log(4, "Loaded message from database for " + packet.getMessageID());
            }
            if (bl) {
                return packet;
            }
            arrayList.add(packet);
        }
        return arrayList;
    }

    protected int getMsgColumnType(ResultSet resultSet, int n) throws SQLException {
        if (msgColumnType == -2147483647) {
            msgColumnType = resultSet.getMetaData().getColumnType(n);
        }
        return msgColumnType;
    }

    protected void canInsertMsg(Connection connection, String string, String string2, String string3) throws BrokerException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Exception exception = null;
        try {
            try {
                preparedStatement = connection.prepareStatement(this.selectCanInsertSQL);
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string2);
                if (Globals.getHAEnabled()) {
                    preparedStatement.setString(3, string3);
                }
                if ((resultSet = preparedStatement.executeQuery()).next()) {
                    if (resultSet.getLong(1) > 0L) {
                        throw new BrokerException(this.br.getKString("B3008", string, string2), 409);
                    }
                    if (resultSet.getLong(2) == 0L) {
                        throw new BrokerException(this.br.getKString("B3013", string2), 404);
                    }
                    if (Globals.getHAEnabled() && resultSet.getInt(3) > 0) {
                        StoreBeingTakenOverException storeBeingTakenOverException = new StoreBeingTakenOverException(this.br.getKString("B3223"));
                        try {
                            DBManager dBManager = DBManager.getDBManager();
                            BrokerDAO brokerDAO = dBManager.getDAOFactory().getBrokerDAO();
                            HABrokerInfo hABrokerInfo = brokerDAO.getBrokerInfo(connection, dBManager.getBrokerID());
                            this.logger.log(32, this.br.getKString("B4117", hABrokerInfo.toString()), storeBeingTakenOverException);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        throw storeBeingTakenOverException;
                    }
                } else {
                    throw new BrokerException(this.br.getKString("B4166", this.selectCanInsertSQL));
                }
                Object var13_16 = null;
            }
            catch (Exception exception2) {
                exception = exception2;
                try {
                    if (connection != null && !connection.getAutoCommit()) {
                        connection.rollback();
                    }
                }
                catch (SQLException sQLException) {
                    this.logger.log(32, "B4080[" + this.selectCanInsertSQL + "]", sQLException);
                }
                if (exception2 instanceof BrokerException) {
                    throw (BrokerException)exception2;
                }
                Exception exception3 = exception2 instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectCanInsertSQL + "]", (SQLException)exception2) : exception2;
                throw new BrokerException(this.br.getKString("B4166", this.selectCanInsertSQL), exception3);
            }
        }
        catch (Throwable throwable) {
            Object var13_17 = null;
            Util.close(resultSet, preparedStatement, null, exception);
            throw throwable;
        }
        Util.close(resultSet, preparedStatement, null, exception);
    }

    private static class MsgEnumeration
    implements Enumeration {
        DestinationUID dID = null;
        MessageDAO msgDAO = null;
        Iterator msgIDItr = null;
        Object msgToReturn = null;

        MsgEnumeration(DestinationUID destinationUID, MessageDAO messageDAO, Iterator iterator) {
            this.dID = destinationUID;
            this.msgDAO = messageDAO;
            this.msgIDItr = iterator;
        }

        public boolean hasMoreElements() {
            Packet packet = null;
            while (this.msgIDItr.hasNext()) {
                String string = null;
                try {
                    string = (String)this.msgIDItr.next();
                    packet = this.msgDAO.getMessage(null, this.dID, string);
                    this.msgToReturn = packet;
                    return true;
                }
                catch (Exception exception) {
                    Globals.getLogger().logStack(32, "B4107", string, (Throwable)exception);
                }
            }
            this.msgToReturn = null;
            return false;
        }

        public Object nextElement() {
            if (this.msgToReturn != null) {
                return this.msgToReturn;
            }
            throw new NoSuchElementException();
        }
    }
}

