/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.BrokerState;
import com.sun.messaging.jmq.jmsserver.cluster.ClusterManager;
import com.sun.messaging.jmq.jmsserver.cluster.ClusteredBroker;
import com.sun.messaging.jmq.jmsserver.cluster.ha.HAClusteredBroker;
import com.sun.messaging.jmq.jmsserver.core.BrokerMQAddress;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

public class GetClusterHandler
extends AdminCmdHandler {
    private static boolean DEBUG = GetClusterHandler.getDEBUG();

    public GetClusterHandler(AdminDataHandler adminDataHandler) {
        super(adminDataHandler);
    }

    public static int convertState(BrokerState brokerState) {
        if (brokerState == BrokerState.INITIALIZING) {
            return 0;
        }
        if (brokerState == BrokerState.OPERATING) {
            return 0;
        }
        if (brokerState == BrokerState.QUIESCE_STARTED) {
            return 4;
        }
        if (brokerState == BrokerState.QUIESCE_COMPLETED) {
            return 5;
        }
        if (brokerState == BrokerState.SHUTDOWN_STARTED) {
            return 6;
        }
        if (brokerState == BrokerState.SHUTDOWN_COMPLETE) {
            return 7;
        }
        if (brokerState == BrokerState.SHUTDOWN_FAILOVER) {
            return 7;
        }
        if (brokerState == BrokerState.FAILOVER_PENDING) {
            return 7;
        }
        if (brokerState == BrokerState.FAILOVER_STARTED) {
            return 1;
        }
        if (brokerState == BrokerState.FAILOVER_COMPLETE) {
            return 2;
        }
        if (brokerState == BrokerState.FAILOVER_FAILED) {
            return 3;
        }
        if (brokerState == BrokerState.FAILOVER_PROCESSED) {
            return 2;
        }
        return 7;
    }

    public static Hashtable getBrokerClusterInfo(ClusteredBroker clusteredBroker, Logger logger) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        String string = clusteredBroker.isBrokerIDGenerated() ? "" : clusteredBroker.getBrokerName();
        hashtable.put("ID", string);
        String string2 = clusteredBroker.getInstanceName();
        BrokerMQAddress brokerMQAddress = (BrokerMQAddress)clusteredBroker.getBrokerURL();
        String string3 = brokerMQAddress.getHost().getHostName() + ":" + brokerMQAddress.getPort();
        hashtable.put("Address", string3);
        hashtable.put("Version", String.valueOf(clusteredBroker.getVersion()));
        if (clusteredBroker instanceof HAClusteredBroker) {
            try {
                HAClusteredBroker hAClusteredBroker = (HAClusteredBroker)clusteredBroker;
                hashtable.put("StatusTimestamp", new Long(hAClusteredBroker.getHeartbeat()));
                hashtable.put("TakeoverBrokerID", hAClusteredBroker.getTakeoverBroker());
                int n = Globals.getStore().getMessageCount(string);
                hashtable.put("NumMsgs", new Long(n));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            hashtable.put("State", new Integer(GetClusterHandler.convertState(clusteredBroker.getState())));
        }
        catch (Exception exception) {
            if (logger != null) {
                logger.logStack(8, "B3100", "Converting state", (Throwable)exception);
            }
            hashtable.put("State", new Integer(7));
        }
        return hashtable;
    }

    public boolean handle(IMQConnection iMQConnection, Packet packet, Hashtable hashtable) {
        Object object;
        if (DEBUG) {
            this.logger.log(4, this.getClass().getName() + ": " + "Getting cluster info/state: " + hashtable);
        }
        Vector<Hashtable> vector = new Vector<Hashtable>();
        int n = 200;
        String string = null;
        Properties properties = Globals.getConfig().toProperties();
        ClusterManager clusterManager = Globals.getClusterManager();
        Iterator iterator = clusterManager.getKnownBrokers(true);
        while (iterator.hasNext()) {
            object = (ClusteredBroker)iterator.next();
            Hashtable hashtable2 = GetClusterHandler.getBrokerClusterInfo((ClusteredBroker)object, this.logger);
            vector.add(hashtable2);
        }
        object = new Packet(iMQConnection.useDirectBuffers());
        ((Packet)object).setPacketType(5);
        GetClusterHandler.setProperties((Packet)object, 79, n, string);
        this.setBodyObject((Packet)object, vector);
        this.parent.sendReply(iMQConnection, packet, (Packet)object);
        return true;
    }
}

