/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.jmsserver.FaultInjection;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.config.ConfigListener;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.ConnectionInfo;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBConstants;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.RuntimeFaultInjection;
import com.sun.messaging.jmq.util.SupportUtil;
import com.sun.messaging.jmq.util.log.Logger;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public class DBConnectionPool
implements DBConstants {
    private static boolean DEBUG = false;
    public static final String REAP_INTERVAL_PROP = "imq.persist.jdbc.connection.reaptime";
    public static final int DEFAULT_REAP_INTERVAL = 300;
    public static final String NUM_CONN_PROP = "imq.persist.jdbc.connection.limit";
    public static final String MIN_CONN_PROP = "imq.persist.jdbc.min_connections";
    public static final String MAX_CONN_PROP = "imq.persist.jdbc.max_connections";
    static final int DEFAULT_NUM_CONN = 5;
    public static final String VALIDATION_QUERY_PROP = "imq.persist.jdbc.connection.validationQuery";
    public static final String VALIDATE_ON_GET_PROP = "imq.persist.jdbc.connection.validateOnGet";
    private static int minConnections;
    private static int maxConnections;
    private static boolean initialized;
    private static ReentrantLock lock;
    private static LinkedBlockingQueue<ConnectionInfo> idleConnections;
    private static ConcurrentHashMap<ConnectionInfo, Thread> activeConnections;
    private static Map<Object, ConnectionInfo> connMap;
    private static ConnectionReaperTask connectionReaper;
    private static ConnectionEventListener connectionListener;
    private static long reapInterval;
    private static DBManager dbmgr;
    private static Logger logger;
    protected static BrokerResources br;
    private static String validationQuery;
    private static boolean validateOnGet;
    private static boolean isPoolDataSource;
    private static ConfigListener cfgListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void init(DBManager dBManager) throws BrokerException {
        if (!initialized) {
            lock.lock();
            try {
                long l;
                if (initialized) {
                    Object var7_1 = null;
                    lock.unlock();
                    return;
                }
                dbmgr = dBManager;
                isPoolDataSource = dbmgr.isPoolDataSource();
                validationQuery = Globals.getConfig().getProperty(VALIDATION_QUERY_PROP);
                if (validationQuery != null && validationQuery.trim().length() == 0) {
                    validationQuery = null;
                }
                DBConnectionPool.initValidationQuery();
                if (validationQuery != null) {
                    logger.log(8, "imq.persist.jdbc.connection.validationQuery=" + validationQuery);
                }
                validateOnGet = Globals.getConfig().getBooleanProperty(VALIDATE_ON_GET_PROP, Globals.getHAEnabled());
                logger.log(8, "imq.persist.jdbc.connection.validateOnGet=" + validateOnGet);
                int n = Globals.getConfig().getIntProperty(NUM_CONN_PROP, 5);
                if (n < 1) {
                    n = 5;
                    logger.log(16, "Invalid number of connections specified, set to default of " + n);
                }
                if ((minConnections = Globals.getConfig().getIntProperty(MIN_CONN_PROP, n)) < 1) {
                    minConnections = n;
                    logger.log(16, "Invalid number of minimum connections specified, set to default of " + minConnections);
                }
                if ((maxConnections = Globals.getConfig().getIntProperty(MAX_CONN_PROP, n)) < minConnections) {
                    maxConnections = minConnections;
                    logger.log(16, "Invalid number of maximum connections specified, set to default of " + maxConnections);
                }
                if ((l = Globals.getConfig().getLongProperty(REAP_INTERVAL_PROP, 300L)) < 60L) {
                    l = 300L;
                    logger.log(16, "Invalid reap time interval for pool maintenance thread specified, set to default of " + l);
                }
                reapInterval = l * 1000L;
                if (dbmgr.getCreateDBURL() != null && Globals.getConfig().getBooleanProperty("imq.persist.storecreate.all", false)) {
                    try {
                        Connection connection = dbmgr.connectToCreate();
                        connection.close();
                    }
                    catch (Exception exception) {
                        String string = dbmgr.getCreateDBURL();
                        logger.log(32, "B3073", (Object)string, (Throwable)exception);
                        throw new BrokerException(br.getString("B3073", string, exception));
                    }
                }
                if (connectionListener == null) {
                    connectionListener = new DBConnectionListener();
                }
                logger.log(8, "imq.persist.jdbc.min_connections=" + minConnections);
                logger.log(8, "imq.persist.jdbc.max_connections=" + maxConnections);
                for (int i = 0; i < minConnections; ++i) {
                    ConnectionInfo connectionInfo = DBConnectionPool.createConnection();
                    idleConnections.offer(connectionInfo);
                }
                Globals.getConfig().addListener(MIN_CONN_PROP, cfgListener);
                Globals.getConfig().addListener(MAX_CONN_PROP, cfgListener);
                Globals.getConfig().addListener(REAP_INTERVAL_PROP, cfgListener);
                if (maxConnections > minConnections) {
                    if (connectionReaper != null) {
                        connectionReaper.cancel();
                    }
                    connectionReaper = new ConnectionReaperTask();
                    Globals.getTimer().schedule((TimerTask)connectionReaper, reapInterval, reapInterval);
                }
                initialized = true;
            }
            catch (Throwable throwable) {
                Object var7_3 = null;
                lock.unlock();
                throw throwable;
            }
            Object var7_2 = null;
            lock.unlock();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void close() {
        if (!initialized) {
            return;
        }
        lock.lock();
        try {
            if (connectionReaper != null) {
                connectionReaper.cancel();
                connectionReaper = null;
            }
            Globals.getConfig().removeListener(MIN_CONN_PROP, cfgListener);
            Globals.getConfig().removeListener(MAX_CONN_PROP, cfgListener);
            Globals.getConfig().removeListener(REAP_INTERVAL_PROP, cfgListener);
            for (ConnectionInfo connectionInfo : idleConnections) {
                DBConnectionPool.destroyConnection(connectionInfo);
            }
            idleConnections.clear();
            initialized = false;
            Object var3_2 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reset() throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "DBConnectionPool.reset(): reset connection pool");
        }
        if (!initialized) {
            return;
        }
        ArrayList arrayList = new ArrayList(maxConnections);
        lock.lock();
        try {
            activeConnections.clear();
            idleConnections.drainTo(arrayList);
            for (int i = 0; i < minConnections; ++i) {
                ConnectionInfo connectionInfo = DBConnectionPool.createConnection();
                idleConnections.offer(connectionInfo);
            }
            for (ConnectionInfo connectionInfo : arrayList) {
                DBConnectionPool.destroyConnection(connectionInfo);
            }
            Object var4_4 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            lock.unlock();
            throw throwable;
        }
    }

    private static ConnectionInfo createConnection() throws BrokerException {
        Object object = dbmgr.newConnection();
        ConnectionInfo connectionInfo = new ConnectionInfo(object, connectionListener);
        connMap.put(object, connectionInfo);
        return connectionInfo;
    }

    private static void destroyConnection(ConnectionInfo connectionInfo) {
        connectionInfo.destroy();
        connMap.remove(connectionInfo.getKey());
    }

    static Connection getConnection() throws BrokerException {
        Object object;
        Object object2;
        if (Store.getDEBUG() || DEBUG) {
            logger.log(8, "[" + Thread.currentThread() + "]DBConnectionPool.getConnection()[" + idleConnections.size() + ", " + activeConnections.size() + "]");
        }
        if (DEBUG) {
            object2 = FaultInjection.getInjection();
            if (((FaultInjection)object2).FAULT_INJECTION) {
                ((RuntimeFaultInjection)object2).checkFaultAndSleep("jdbc.getconn.1", null);
            }
        }
        object2 = null;
        boolean bl = false;
        boolean bl2 = false;
        ConnectionInfo connectionInfo = idleConnections.poll();
        if (connectionInfo == null && activeConnections.size() < maxConnections) {
            connectionInfo = DBConnectionPool.createConnection();
            try {
                object2 = connectionInfo.getConnection();
            }
            catch (Exception exception) {
                DBConnectionPool.destroyConnection(connectionInfo);
                throw new BrokerException(connectionInfo + exception.getMessage(), exception);
            }
            if (Store.getDEBUG() || DEBUG) {
                bl = true;
            }
        } else {
            while (connectionInfo == null) {
                try {
                    if ((Store.getDEBUG() || DEBUG) && !bl2) {
                        bl2 = true;
                    }
                    if ((connectionInfo = idleConnections.poll(60L, TimeUnit.SECONDS)) != null) continue;
                    object = new StringBuffer(1024);
                    for (Map.Entry entry : activeConnections.entrySet()) {
                        Thread thread = (Thread)entry.getValue();
                        ((StringBuffer)object).append("\n").append(thread.getName()).append(": using connection: ").append(entry.getKey());
                        StackTraceElement[] stackTraceElementArray = thread.getStackTrace();
                        for (int i = 0; i < stackTraceElementArray.length; ++i) {
                            ((StringBuffer)object).append("\n\tat " + stackTraceElementArray[i]);
                        }
                    }
                    String object32 = br.getKString("B1340", "[" + minConnections + "," + maxConnections + "]", 60) + "\n" + ((StringBuffer)object).toString();
                    logger.log(16, object32);
                    if (!Globals.getStore().closed()) continue;
                    throw new BrokerException(object32);
                }
                catch (Exception exception) {
                    if (exception instanceof BrokerException) {
                        throw (BrokerException)exception;
                    }
                    if (!Store.getDEBUG() && !DEBUG) continue;
                    logger.logStack(8, "DBConnectionPool.getConnection(): " + exception.getMessage(), exception);
                }
            }
            if (!DBConnectionPool.validateConnection(connectionInfo, validateOnGet)) {
                DBConnectionPool.destroyConnection(connectionInfo);
                try {
                    connectionInfo = DBConnectionPool.createConnection();
                    object2 = connectionInfo.getConnection();
                    logger.log(8, br.getString("B1149", "" + connectionInfo, dbmgr.getOpenDBURL()));
                }
                catch (Exception exception) {
                    DBConnectionPool.destroyConnection(connectionInfo);
                    String string = br.getString("B4206", dbmgr.getOpenDBURL());
                    logger.logStack(32, string, exception);
                    throw new BrokerException(string, exception);
                }
            }
            try {
                object2 = connectionInfo.getConnection();
            }
            catch (Exception exception) {
                DBConnectionPool.destroyConnection(connectionInfo);
                throw new BrokerException(connectionInfo + exception.getMessage(), exception);
            }
        }
        object = Thread.currentThread();
        activeConnections.put(connectionInfo, (Thread)object);
        if (Store.getDEBUG() || DEBUG) {
            logger.log(8, "DBConnectionPool.getConnection()[" + bl + "," + bl2 + "]: " + ((Thread)object).getName() + " [" + new Date() + "]: check out connection: 0x" + object2.hashCode() + connectionInfo);
        }
        return object2;
    }

    static void freeConnection(Connection connection, Throwable throwable) {
        if (Store.getDEBUG() || DEBUG) {
            logger.log(8, "DBConnectionPool.freeConnection(): connection: 0x" + connection.hashCode() + (throwable == null ? "" : ", ex=" + throwable));
        }
        if (isPoolDataSource) {
            try {
                connection.close();
            }
            catch (Exception exception) {
                logger.log(16, br.getKString("B2229", "0x" + connection.hashCode(), exception.toString()));
            }
            return;
        }
        ConnectionInfo connectionInfo = connMap.get(connection);
        if (connectionInfo == null) {
            logger.log(16, br.getKString("B2230", "0x" + connection.hashCode()));
            try {
                connection.close();
            }
            catch (Exception exception) {
                logger.log(16, br.getKString("B2229", "0x" + connection.hashCode(), exception.toString()));
            }
            return;
        }
        connectionInfo.setException(throwable);
        DBConnectionPool.returnConnection(connectionInfo, throwable);
    }

    static void returnConnection(ConnectionInfo connectionInfo, Throwable throwable) {
        Thread thread;
        if (Store.getDEBUG() || DEBUG) {
            logger.log(8, "DBConnectionPool.returnConnection(): connection: " + connectionInfo + (throwable == null ? "" : ", ex=" + throwable));
        }
        if ((thread = activeConnections.remove(connectionInfo)) == null) {
            if (Store.getDEBUG() || DEBUG) {
                logger.log(16, "DBConnectionPool.returnConnection(" + connectionInfo + (throwable == null ? "" : ", ex=" + throwable) + "): not found in connection pool\n" + SupportUtil.getStackTrace(""));
            } else {
                logger.log(16, br.getKString("B2228", "" + connectionInfo + "[" + (throwable == null ? "" : ", ex=" + throwable) + "]"));
            }
            DBConnectionPool.destroyConnection(connectionInfo);
        } else {
            if (throwable != null && !DBConnectionPool.validateConnection(connectionInfo, throwable instanceof SQLException || throwable.getCause() instanceof SQLException)) {
                DBConnectionPool.destroyConnection(connectionInfo);
                return;
            }
            idleConnections.offer(connectionInfo);
        }
    }

    private static void initValidationQuery() {
        if (dbmgr.isMysql()) {
            validationQuery = "/* ping */";
        } else if (dbmgr.isOracle()) {
            validationQuery = "SELECT 1 FROM DUAL";
        } else if (validationQuery == null && dbmgr.isStoreInited()) {
            try {
                validationQuery = "SELECT 1 FROM " + dbmgr.getDAOFactory().getVersionDAO().getTableName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean validateConnection(ConnectionInfo connectionInfo, boolean bl) {
        Object object;
        ResultSet resultSet;
        Statement statement;
        Connection connection;
        block41: {
            block40: {
                block39: {
                    block37: {
                        block38: {
                            connection = null;
                            statement = null;
                            resultSet = null;
                            connectionInfo.setValidating(true);
                            object = connectionInfo.getKey();
                            if (!(object instanceof Connection)) break block37;
                            if (!((Connection)object).isClosed()) break block38;
                            boolean bl2 = false;
                            Object var20_14 = null;
                            connectionInfo.setValidating(false);
                            connectionInfo.setException(null);
                            return bl2;
                        }
                        if (Util.isConnectionError(connectionInfo.getException(), dbmgr)) {
                            boolean bl3 = false;
                            Object var20_15 = null;
                            connectionInfo.setValidating(false);
                            connectionInfo.setException(null);
                            return bl3;
                        }
                        break block39;
                    }
                    if (connectionInfo.getException() == null) break block39;
                    boolean bl4 = false;
                    Object var20_16 = null;
                    connectionInfo.setValidating(false);
                    connectionInfo.setException(null);
                    return bl4;
                }
                if (bl) break block40;
                boolean bl5 = true;
                Object var20_17 = null;
                connectionInfo.setValidating(false);
                connectionInfo.setException(null);
                return bl5;
            }
            connection = connectionInfo.getConnection();
            if (connection != null) break block41;
            boolean bl6 = false;
            Object var20_18 = null;
            connectionInfo.setValidating(false);
            connectionInfo.setException(null);
            return bl6;
        }
        try {
            int n;
            Boolean bl7;
            block44: {
                bl7 = null;
                try {
                    Object object2;
                    block42: {
                        statement = connection.createStatement();
                        n = statement.getQueryTimeout();
                        if (dbmgr.isJDBC4()) {
                            try {
                                object2 = Connection.class;
                                Method method = ((Class)object2).getMethod("isValid", Integer.TYPE);
                                long l = System.currentTimeMillis();
                                boolean bl8 = (Boolean)method.invoke((Object)connection, new Integer(n));
                                if (!bl8) {
                                    if (System.currentTimeMillis() < l + (long)(n * 1000)) {
                                        bl7 = false;
                                    }
                                } else {
                                    bl7 = bl8;
                                }
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                                dbmgr.setJDBC4(false);
                            }
                            catch (Throwable throwable) {
                                if (!Store.getDEBUG() && !DEBUG) break block42;
                                logger.logStack(8, "Exception in invoking Connection.isValid(" + n + ")", throwable);
                            }
                        }
                    }
                    object2 = null;
                    if (bl7 == null && (object2 = validationQuery) == null) {
                        bl7 = true;
                    }
                    if (bl7 == null) {
                        try {
                            resultSet = statement.executeQuery((String)object2);
                            bl7 = resultSet.next() ? Boolean.valueOf(true) : Boolean.valueOf(false);
                            Object var14_29 = null;
                        }
                        catch (Throwable throwable) {
                            Object var14_30 = null;
                            try {
                                if (!connection.getAutoCommit()) {
                                    connection.rollback();
                                }
                            }
                            catch (Exception exception) {
                                logger.log(16, br.getKString("B2226", "[" + (String)object2 + "]" + connectionInfo, exception.toString()));
                                bl7 = false;
                            }
                            throw throwable;
                        }
                        try {
                            if (!connection.getAutoCommit()) {
                                connection.rollback();
                            }
                        }
                        catch (Exception exception) {
                            logger.log(16, br.getKString("B2226", "[" + (String)object2 + "]" + connectionInfo, exception.toString()));
                            bl7 = false;
                        }
                    }
                    Object var17_34 = null;
                    if (resultSet == null) break block44;
                }
                catch (Throwable throwable) {
                    Object var17_35 = null;
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                    if (object instanceof PooledConnection) {
                        try {
                            connection.close();
                        }
                        catch (Exception exception) {
                            logger.log(16, br.getKString("B2226", "" + connectionInfo + "[0x" + connection.hashCode() + "]", exception.toString()));
                            bl7 = false;
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (object instanceof PooledConnection) {
                try {
                    connection.close();
                }
                catch (Exception exception) {
                    logger.log(16, br.getKString("B2226", "" + connectionInfo + "[0x" + connection.hashCode() + "]", exception.toString()));
                    bl7 = false;
                }
            }
            if (bl7 == null) {
                bl7 = false;
            }
            n = bl7.booleanValue() ? 1 : 0;
            Object var20_19 = null;
            connectionInfo.setValidating(false);
            connectionInfo.setException(null);
            return n != 0;
        }
        catch (Exception exception) {
            try {
                logger.logStack(16, br.getKString("B2226", connectionInfo.toString(), exception.getMessage()), exception);
                boolean bl9 = false;
                Object var20_20 = null;
                connectionInfo.setValidating(false);
                connectionInfo.setException(null);
                return bl9;
            }
            catch (Throwable throwable) {
                Object var20_21 = null;
                connectionInfo.setValidating(false);
                connectionInfo.setException(null);
                throw throwable;
            }
        }
    }

    static void reapExcessConnection() {
        int n = idleConnections.size();
        int n2 = activeConnections.size();
        if (Store.getDEBUG()) {
            logger.log(4, "DBConnectionPool.reapExcessConnection(): pool size: min=" + minConnections + ", max=" + maxConnections + ", active=" + n2 + ", idle=" + n);
        }
        while (n > 0 && n2 + n > minConnections) {
            ConnectionInfo connectionInfo = idleConnections.poll();
            DBConnectionPool.destroyConnection(connectionInfo);
            n = idleConnections.size();
            n2 = activeConnections.size();
        }
    }

    static boolean validate(Connection connection) {
        try {
            connection.getMetaData();
        }
        catch (Exception exception) {
            logger.log(4, "DBConnectionPool.validate(): Lost database connection to " + dbmgr.getOpenDBURL(), exception);
            return false;
        }
        return true;
    }

    static boolean handleException(Connection connection, Throwable throwable) {
        if (DBConnectionPool.validate(connection)) {
            logger.log(4, "connection is good; return false (no need to retry)");
            return false;
        }
        return true;
    }

    static {
        initialized = false;
        lock = new ReentrantLock();
        idleConnections = new LinkedBlockingQueue();
        activeConnections = new ConcurrentHashMap();
        connMap = Collections.synchronizedMap(new HashMap());
        connectionReaper = null;
        connectionListener = null;
        dbmgr = null;
        logger = Globals.getLogger();
        br = Globals.getBrokerResources();
        validationQuery = null;
        validateOnGet = false;
        isPoolDataSource = false;
        cfgListener = new ConfigListener(){

            public void validate(String string, String string2) throws PropertyUpdateException {
                if (string.equals(DBConnectionPool.MIN_CONN_PROP)) {
                    int n = 0;
                    try {
                        n = Integer.parseInt(string2);
                    }
                    catch (Exception exception) {
                        throw new PropertyUpdateException(2, br.getString("B4027", string + "=" + string2), exception);
                    }
                    if (n < 1) {
                        throw new PropertyUpdateException(2, "A minimum value of 1 connection is required");
                    }
                    if (n > maxConnections) {
                        throw new PropertyUpdateException(2, "Minimum connections " + n + " is greater than maximum connections " + maxConnections);
                    }
                } else if (string.equals(DBConnectionPool.MAX_CONN_PROP)) {
                    int n = 0;
                    try {
                        n = Integer.parseInt(string2);
                    }
                    catch (Exception exception) {
                        throw new PropertyUpdateException(2, br.getString("B4027", string + "=" + string2), exception);
                    }
                    if (n < minConnections) {
                        throw new PropertyUpdateException(2, "Maximum connections " + n + " is less than minimum connections " + minConnections);
                    }
                } else if (string.equals(DBConnectionPool.REAP_INTERVAL_PROP)) {
                    int n = 0;
                    try {
                        n = Integer.parseInt(string2);
                    }
                    catch (Exception exception) {
                        throw new PropertyUpdateException(2, br.getString("B4027", string + "=" + string2), exception);
                    }
                    if (n < 60) {
                        throw new PropertyUpdateException(2, "A minimum value of 60 seconds is required for reap time interval");
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean update(String string, String string2) {
                BrokerConfig brokerConfig = Globals.getConfig();
                lock.lock();
                try {
                    if (string.equals(DBConnectionPool.MAX_CONN_PROP)) {
                        maxConnections = brokerConfig.getIntProperty(DBConnectionPool.MAX_CONN_PROP);
                    } else if (string.equals(DBConnectionPool.MIN_CONN_PROP)) {
                        minConnections = brokerConfig.getIntProperty(DBConnectionPool.MIN_CONN_PROP);
                    } else if (string.equals(DBConnectionPool.REAP_INTERVAL_PROP)) {
                        reapInterval = brokerConfig.getLongProperty(DBConnectionPool.REAP_INTERVAL_PROP) * 1000L;
                    }
                    Object var5_4 = null;
                    lock.unlock();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    lock.unlock();
                    throw throwable;
                }
                if (maxConnections > minConnections) {
                    if (connectionReaper != null) {
                        connectionReaper.cancel();
                    }
                    connectionReaper = new ConnectionReaperTask();
                    Globals.getTimer().schedule((TimerTask)connectionReaper, reapInterval, reapInterval);
                }
                return true;
            }
        };
    }

    static class DBConnectionListener
    implements ConnectionEventListener {
        public void connectionClosed(ConnectionEvent connectionEvent) {
            PooledConnection pooledConnection = (PooledConnection)connectionEvent.getSource();
            ConnectionInfo connectionInfo = (ConnectionInfo)connMap.get(pooledConnection);
            if (connectionInfo == null) {
                throw new IllegalStateException("No mapping for PooledConnection 0x" + pooledConnection.hashCode() + "[" + pooledConnection.getClass().getName() + "]");
            }
            if (!connectionInfo.inValidating()) {
                DBConnectionPool.returnConnection(connectionInfo, connectionInfo.getException());
            }
        }

        public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
            PooledConnection pooledConnection = (PooledConnection)connectionEvent.getSource();
            pooledConnection.removeConnectionEventListener(this);
            ConnectionInfo connectionInfo = (ConnectionInfo)connMap.get(pooledConnection);
            if (connectionInfo == null) {
                throw new IllegalStateException("connectionErrorOccurred: No mapping for PooledConnection 0x" + pooledConnection.hashCode() + "[" + pooledConnection.getClass().getName() + "]");
            }
            SQLException sQLException = connectionEvent.getSQLException();
            Logger logger = logger;
            logger;
            logger.log(16, br.getKString("B2231", "" + connectionInfo, "" + sQLException));
            if (sQLException == null) {
                sQLException = new SQLException();
            }
            connectionInfo.setException(sQLException);
        }
    }

    static class ConnectionReaperTask
    extends TimerTask {
        private volatile boolean canceled = false;

        ConnectionReaperTask() {
        }

        public boolean cancel() {
            this.canceled = true;
            return super.cancel();
        }

        public void run() {
            if (this.canceled) {
                return;
            }
            try {
                DBConnectionPool.reapExcessConnection();
            }
            catch (Exception exception) {
                Globals.getLogger().logStack(32, "B3177", exception);
            }
        }
    }
}

