/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class TransactionWorkMessage {
    private DestinationUID destUID;
    private Packet message;
    private ConsumerUID[] storedInterests;
    private PacketReference packetRef;

    public TransactionWorkMessage(DestinationUID destinationUID, Packet packet, ConsumerUID[] consumerUIDArray) {
        this.destUID = destinationUID;
        this.message = packet;
        this.storedInterests = consumerUIDArray;
    }

    public TransactionWorkMessage() {
    }

    public DestinationUID getDestUID() {
        return this.destUID;
    }

    public void setDestUID(DestinationUID destinationUID) {
        this.destUID = destinationUID;
    }

    public Packet getMessage() {
        return this.message;
    }

    public PacketReference getPacketReference() {
        return this.packetRef;
    }

    public void setPacketReference(PacketReference packetReference) {
        this.packetRef = packetReference;
        this.message = packetReference.getPacket();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("sysMessageID=").append(this.message.getMessageID());
        stringBuffer.append(" destUID=").append(this.destUID);
        stringBuffer.append(" dest=").append(this.message.getDestination());
        return stringBuffer.toString();
    }

    public ConsumerUID[] getStoredInterests() {
        return this.storedInterests;
    }

    public void setStoredInterests(ConsumerUID[] consumerUIDArray) {
        this.storedInterests = consumerUIDArray;
    }

    public void writeWork(DataOutputStream dataOutputStream) throws IOException {
        byte[] byArray = this.getMessage().getBytes();
        dataOutputStream.write(byArray);
        ConsumerUID[] consumerUIDArray = this.getStoredInterests();
        if (consumerUIDArray == null) {
            dataOutputStream.writeInt(0);
        } else {
            dataOutputStream.writeInt(consumerUIDArray.length);
            for (int i = 0; i < consumerUIDArray.length; ++i) {
                dataOutputStream.writeLong(consumerUIDArray[i].longValue());
            }
        }
    }

    public void readWork(DataInputStream dataInputStream) throws IOException, BrokerException {
        this.message = new Packet(false);
        this.message.generateTimestamp(false);
        this.message.generateSequenceNumber(false);
        this.message.readPacket(dataInputStream);
        int n = dataInputStream.readInt();
        this.storedInterests = new ConsumerUID[n];
        for (int i = 0; i < n; ++i) {
            long l = dataInputStream.readLong();
            this.storedInterests[i] = new ConsumerUID(l);
        }
        this.destUID = DestinationUID.getUID(this.message.getDestination(), this.message.getIsQueue());
    }
}

