/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.BrokerState;
import com.sun.messaging.jmq.jmsserver.cluster.ClusterManager;
import com.sun.messaging.jmq.jmsserver.cluster.ClusteredBroker;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;

public class InfoRequestHandler
extends PacketHandler {
    private Logger logger = Globals.getLogger();
    private BrokerResources rb = Globals.getBrokerResources();
    public static final int REQUEST_STATUS_INFO = 1;
    public static final int REQUEST_CLUSTER_INFO = 2;
    static final int INITIALIZING = 1;
    static final int RUNNING = 2;
    static final int QUIESCE_STARTED = 3;
    static final int QUIESCE_COMPLETE = 4;
    static final int FAILOVER_STARTED = 5;
    static final int FAILOVER_COMPLETE = 6;
    static final int SHUTDOWN_STARTED = 7;
    static final int SHUTDOWN_COMPLETE = 8;

    public boolean handle(IMQConnection iMQConnection, Packet packet) throws BrokerException {
        Hashtable hashtable = null;
        try {
            hashtable = packet.getProperties();
        }
        catch (Exception exception) {
            this.logger.log(8, "Internal Error: error  retrieving properties from INFO_REQUEST message ", exception);
            hashtable = new Hashtable();
        }
        Integer n = (Integer)hashtable.get("JMQRequestType");
        if (n == null) {
            this.logger.log(8, "No JMQRequestType set ");
            n = new Integer(-1);
        }
        InfoRequestHandler.sendInfoPacket(n, iMQConnection, packet.getConsumerID());
        return true;
    }

    public static void sendInfoPacket(int n, IMQConnection iMQConnection, long l) {
        Object object;
        Object object2;
        Logger logger = Globals.getLogger();
        ClusterManager clusterManager = Globals.getClusterManager();
        String string = null;
        int n2 = 200;
        Packet packet = new Packet(iMQConnection.useDirectBuffers());
        packet.setPacketType(73);
        packet.setConsumerID(l);
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Hashtable hashtable2 = null;
        if (clusterManager == null) {
            n2 = 500;
            string = "Internal Error: NOT VALID CLUSTER ";
            logger.log(8, string);
        } else if (n == 1) {
            object2 = clusterManager.getLocalBroker();
            hashtable2 = InfoRequestHandler.getInfo((ClusteredBroker)object2);
            try {
                if (object2.getState() == BrokerState.SHUTDOWN_STARTED) {
                    long l2 = Globals.getBrokerStateHandler().getShutdownRemaining();
                    hashtable2.put("ShutdownMS", new Long(l2));
                }
            }
            catch (BrokerException brokerException) {
                logger.logStack(8, "Internal Error: setting timeout ", brokerException);
            }
        } else if (n == 2) {
            hashtable2 = InfoRequestHandler.getAllInfo();
        } else {
            n2 = 400;
            string = "Internal Error: Bad JMQRequestType set " + n;
            logger.log(8, string);
        }
        object2 = null;
        if (clusterManager != null) {
            Iterator iterator = clusterManager.getKnownBrokers(true);
            object = new HashSet();
            while (iterator.hasNext()) {
                ClusteredBroker clusteredBroker = (ClusteredBroker)iterator.next();
                object.add(clusteredBroker.getBrokerURL().toString());
            }
            iterator = object.iterator();
            while (iterator.hasNext()) {
                if (object2 == null) {
                    object2 = iterator.next().toString();
                    continue;
                }
                object2 = (String)object2 + "," + iterator.next().toString();
            }
            if (object2 != null) {
                hashtable.put("JMQBrokerList", object2);
            }
        }
        if (hashtable2 != null) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                object = new ObjectOutputStream(byteArrayOutputStream);
                ((ObjectOutputStream)object).writeObject(hashtable2);
                ((ObjectOutputStream)object).flush();
                byteArrayOutputStream.flush();
                packet.setMessageBody(byteArrayOutputStream.toByteArray());
                byteArrayOutputStream.close();
            }
            catch (Exception exception) {
                logger.log(16, "XXX-L10N Internal Error  sending back broker data", exception);
            }
        }
        hashtable.put("JMQRequestType", new Integer(n));
        hashtable.put("JMQStatus", new Integer(n2));
        if (string != null) {
            hashtable.put("JMQReason", string);
        }
        packet.setProperties(hashtable);
        iMQConnection.sendControlMessage(packet);
    }

    static Hashtable getAllInfo() {
        ClusterManager clusterManager = Globals.getClusterManager();
        if (clusterManager == null) {
            return null;
        }
        Iterator iterator = clusterManager.getKnownBrokers(true);
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        String string = "";
        while (iterator.hasNext()) {
            ClusteredBroker clusteredBroker = (ClusteredBroker)iterator.next();
            string = string.length() == 0 ? clusteredBroker.getBrokerName() : string + "," + clusteredBroker.getBrokerName();
            hashtable.put(clusteredBroker.getBrokerName(), InfoRequestHandler.getInfo(clusteredBroker));
        }
        hashtable.put("BrokerIDs", string);
        return hashtable;
    }

    static Hashtable getInfo(ClusteredBroker clusteredBroker) {
        BrokerState brokerState = null;
        Logger logger = Globals.getLogger();
        ClusterManager clusterManager = Globals.getClusterManager();
        try {
            brokerState = clusteredBroker.getState();
        }
        catch (BrokerException brokerException) {
            logger.log(8, "L10N-XXX Internal Error  unable to retrieve state", brokerException);
            brokerState = BrokerState.INITIALIZING;
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("BrokerID", clusteredBroker.getBrokerName());
        hashtable.put("brokerURL", clusteredBroker.getBrokerURL().toString());
        hashtable.put("State", new Integer(InfoRequestHandler.mapStateToInt(brokerState)));
        hashtable.put("StateString", brokerState.toString());
        hashtable.put("isLocal", clusteredBroker.isLocalBroker());
        return hashtable;
    }

    static int mapStateToInt(BrokerState brokerState) {
        if (brokerState == BrokerState.INITIALIZING) {
            return 1;
        }
        if (brokerState == BrokerState.OPERATING) {
            return 2;
        }
        if (brokerState == BrokerState.QUIESCE_STARTED) {
            return 3;
        }
        if (brokerState == BrokerState.QUIESCE_COMPLETED) {
            return 4;
        }
        if (brokerState == BrokerState.SHUTDOWN_STARTED) {
            return 7;
        }
        if (brokerState == BrokerState.SHUTDOWN_FAILOVER) {
            return 8;
        }
        if (brokerState == BrokerState.SHUTDOWN_COMPLETE) {
            return 8;
        }
        if (brokerState == BrokerState.FAILOVER_PENDING) {
            return 5;
        }
        if (brokerState == BrokerState.FAILOVER_STARTED) {
            return 5;
        }
        if (brokerState == BrokerState.FAILOVER_COMPLETE) {
            return 6;
        }
        if (brokerState == BrokerState.FAILOVER_FAILED) {
            return 6;
        }
        return 0;
    }
}

