/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.FaultInjection;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.Producer;
import com.sun.messaging.jmq.jmsserver.core.ProducerUID;
import com.sun.messaging.jmq.jmsserver.core.Session;
import com.sun.messaging.jmq.jmsserver.core.SessionUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.ResetMetricsHandler;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.service.ServiceManager;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQBasicConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQService;
import com.sun.messaging.jmq.util.DebugPrinter;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.SupportUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class DebugHandler
extends AdminCmdHandler {
    private static boolean DEBUG = DebugHandler.getDEBUG();

    public DebugHandler(AdminDataHandler adminDataHandler) {
        super(adminDataHandler);
    }

    /*
     * Unable to fully structure code
     */
    public boolean handle(IMQConnection var1_1, Packet var2_2, Hashtable var3_3) {
        block152: {
            var4_4 = 200;
            var5_5 = null;
            var6_6 = false;
            if (DebugHandler.DEBUG) {
                this.logger.log(4, this.getClass().getName() + ": " + var3_3);
            }
            var7_7 = (String)var3_3.get("JMQCommand");
            var8_8 = (String)var3_3.get("JMQCommandArg");
            var9_9 = (String)var3_3.get("JMQTarget");
            var10_10 = (String)var3_3.get("JMQTargetType");
            var11_11 = (Properties)this.getBodyObject(var2_2);
            if (DebugHandler.DEBUG) {
                this.logger.log(4, "DEBUG message received:");
                this.logger.log(4, "\tJMQCommand: " + var7_7);
                this.logger.log(4, "\tJMQCommandArg: " + var8_8);
                this.logger.log(4, "\tJMQTarget: " + var9_9);
                this.logger.log(4, "\tOptional Properties: " + var11_11);
            }
            var12_12 = null;
            var13_13 = var11_11.getProperty("file");
            var14_14 = new Packet(var1_1.useDirectBuffers());
            var14_14.setPacketType(5);
            if (var7_7 == null || var8_8 == null) {
                var4_4 = 400;
                var5_5 = "Null/Missing values for JMQCommand and/or JMQCommandArg properties.";
                DebugHandler.setProperties(var14_14, 73, var4_4, var5_5);
                this.parent.sendReply(var1_1, var2_2, var14_14);
                return true;
            }
            if (var7_7.equals("update") && var8_8.equals("bkr")) {
                var15_15 = Globals.getConfig();
                try {
                    var15_15.updateProperties(var11_11, true);
                }
                catch (PropertyUpdateException var16_44) {
                    var4_4 = 400;
                    var5_5 = var16_44.getMessage();
                    this.logger.log(16, var5_5);
                }
                catch (IOException var16_45) {
                    var4_4 = 500;
                    var5_5 = var16_45.toString();
                    this.logger.log(16, var5_5);
                }
                DebugHandler.setProperties(var14_14, 73, var4_4, var5_5);
                this.parent.sendReply(var1_1, var2_2, var14_14);
                return true;
            }
            if (var7_7.equals("dump") || var7_7.equals("query")) {
                if (var7_7.equals("dump")) {
                    var6_6 = true;
                    if (var13_13 == null) {
                        var13_13 = "dumpOutput";
                    }
                }
                try {
                    var12_12 = this.getDebugInfo(var8_8, var9_9, var10_10, var11_11);
                }
                catch (Exception var15_16) {
                    var4_4 = 500;
                    var5_5 = "Error " + var7_7 + "ing " + var8_8 + " because " + var15_16.getMessage();
                    this.logger.logStack(8, var5_5, var15_16);
                }
            } else if (var7_7.equals("list")) {
                var12_12 = new Hashtable<String, String>();
                if (var8_8.equals("dst")) {
                    var15_17 = Destination.getAllDestinations();
                    while (var15_17.hasNext()) {
                        var16_46 = (Destination)var15_17.next();
                        var12_12.put(var16_46.getDestinationUID().toString(), DestType.toString(var16_46.getType()) + ":" + (var16_46.isStored() != false ? "stored" : "not stored"));
                    }
                } else if (var8_8.equals("con")) {
                    var12_12 = new Hashtable<String, String>();
                    if (var9_9 == null) {
                        var15_18 = Consumer.getAllConsumers();
                        if (!var15_18.hasNext()) {
                            var4_4 = 500;
                            var5_5 = "No consumers on the broker";
                        }
                        while (var15_18.hasNext()) {
                            var16_47 = (Consumer)var15_18.next();
                            if (var16_47 == null) continue;
                            var17_63 = (IMQConnection)Globals.getConnectionManager().getConnection(var16_47.getConnectionUID());
                            var18_80 = var16_47.getConsumerUID();
                            var19_90 = var16_47.getConnectionUID();
                            var12_12.put(String.valueOf(var18_80 == null ? 0L : var18_80.longValue()), (var17_63 == null ? "none" : var17_63.getRemoteConnectionString()) + " [" + String.valueOf(var19_90 == null ? 0L : var19_90.longValue()) + "]");
                        }
                    } else if (var10_10 == null) {
                        var5_5 = "Please supply targetType if you are supplying a target ";
                        var4_4 = 500;
                    } else if (var10_10.equals("t") || var10_10.equals("q")) {
                        try {
                            var15_19 = false;
                            if (var10_10.equals("q")) {
                                var15_19 = true;
                            }
                            var16_48 = null;
                            var17_64 = null;
                            if (var4_4 != 500) {
                                var16_48 = DestinationUID.getUID(var9_9, var15_19);
                                var17_64 = Destination.getDestination(var16_48);
                            }
                            if (var4_4 != 500 && var17_64 == null) {
                                var4_4 = 500;
                                var5_5 = "Error listing consumers on destination  " + var9_9 + " unknown destination";
                            }
                            if (var4_4 == 500) ** GOTO lbl468
                            var18_81 = var17_64.getConsumers();
                            if (!var18_81.hasNext()) {
                                var4_4 = 500;
                                var5_5 = "No consumers on destination  " + var9_9;
                            }
                            while (var18_81.hasNext()) {
                                var19_91 = (Consumer)var18_81.next();
                                var20_97 = (IMQConnection)Globals.getConnectionManager().getConnection(var19_91.getConnectionUID());
                                var12_12.put(String.valueOf(var19_91.getConsumerUID().longValue()), (var20_97 == null ? "" : var20_97.getRemoteConnectionString()) + " [" + String.valueOf(var19_91.getConnectionUID().longValue()) + "]");
                            }
                        }
                        catch (Exception var15_20) {
                            var4_4 = 500;
                            var5_5 = "Error listing consumers on connection  " + var9_9 + " because " + var15_20.toString();
                            this.logger.logStack(8, var5_5, var15_20);
                        }
                    } else if (var10_10.equals("ses")) {
                        try {
                            var15_21 = new SessionUID(Long.parseLong(var9_9));
                            var16_49 = Session.getSession(var15_21);
                            if (var16_49 == null) {
                                var4_4 = 500;
                                var5_5 = "Error listing consumers on session  " + var9_9 + " unknown sessionUID";
                            }
                            var17_65 = var16_49.getConsumers();
                            if (!var17_65.hasNext()) {
                                var4_4 = 500;
                                var5_5 = "No consumers on session  " + var9_9;
                            }
                            while (var16_49 != null && var17_65.hasNext()) {
                                var18_82 = (Consumer)var17_65.next();
                                if (!var15_21.equals(var18_82.getConnectionUID())) continue;
                                var12_12.put(String.valueOf(var18_82.getConsumerUID().longValue()), var18_82.getDestinationUID().toString());
                            }
                        }
                        catch (Exception var15_22) {
                            var4_4 = 500;
                            var5_5 = "Error listing consumers on connection  " + var9_9 + " because " + var15_22.toString();
                            this.logger.logStack(8, var5_5, var15_22);
                        }
                    } else if (var10_10.equals("cxn")) {
                        try {
                            var15_23 = new ConnectionUID(Long.parseLong(var9_9));
                            var16_50 = (IMQConnection)Globals.getConnectionManager().getConnection(var15_23);
                            if (var16_50 == null) {
                                var4_4 = 500;
                                var5_5 = "Error listing consumers on connection  " + var9_9 + " unknown connectionUID";
                            }
                            var17_66 = Consumer.getAllConsumers();
                            while (var16_50 != null && var17_66.hasNext()) {
                                var18_83 = (Consumer)var17_66.next();
                                if (!var15_23.equals(var18_83.getConnectionUID())) continue;
                                var12_12.put(String.valueOf(var18_83.getConsumerUID().longValue()), var18_83.getDestinationUID().toString());
                            }
                        }
                        catch (Exception var15_24) {
                            var4_4 = 500;
                            var5_5 = "Error listing consumers on connection  " + var9_9 + " because " + var15_24.toString();
                            this.logger.logStack(8, var5_5, var15_24);
                        }
                    } else {
                        var4_4 = 500;
                        var5_5 = "Unknown targetType (-t) " + var9_9 + "\n Valid formats are of the form: " + "[q|t|ses|cxn]";
                    }
                } else if (var8_8.equals("prd")) {
                    var12_12 = new Hashtable<K, V>();
                    if (var9_9 == null) {
                        var15_25 = Producer.getAllProducers();
                        while (var15_25.hasNext()) {
                            var16_51 = (Producer)var15_25.next();
                            var17_67 = (IMQConnection)Globals.getConnectionManager().getConnection(var16_51.getConnectionUID());
                            var12_12.put(String.valueOf(var16_51.getProducerUID().longValue()), var17_67.getRemoteConnectionString() + " [" + String.valueOf(var16_51.getConnectionUID().longValue()) + "]");
                        }
                    } else if (var10_10 == null) {
                        var5_5 = "Please supply targetType if you are supplying a target ";
                        var4_4 = 500;
                    } else if (var10_10.equals("t") || var10_10.equals("q")) {
                        var15_26 = false;
                        if (var10_10.equals("q")) {
                            var15_26 = true;
                        }
                        try {
                            var16_52 = DestinationUID.getUID(var9_9, var15_26);
                            var17_68 = Destination.getDestination(var16_52);
                            if (var17_68 == null) {
                                var4_4 = 500;
                                var5_5 = "Error listing producers on destination  " + var9_9 + " unknown destination";
                            }
                            var18_84 = var17_68.getProducers();
                            while (var18_84.hasNext()) {
                                var19_92 = (Producer)var18_84.next();
                                var20_98 = (IMQConnection)Globals.getConnectionManager().getConnection(var19_92.getConnectionUID());
                                var12_12.put(String.valueOf(var19_92.getProducerUID().longValue()), var20_98.getRemoteConnectionString() + " [" + String.valueOf(var19_92.getConnectionUID().longValue()) + "]");
                            }
                        }
                        catch (Exception var16_53) {
                            var4_4 = 500;
                            var5_5 = "Error listing producers on connection  " + var9_9 + " because " + var16_53.toString();
                            this.logger.logStack(8, var5_5, var16_53);
                        }
                    } else if (var10_10.equals("cxn")) {
                        try {
                            var15_27 = new ConnectionUID(Long.parseLong(var9_9));
                            var16_54 = (IMQConnection)Globals.getConnectionManager().getConnection(var15_27);
                            if (var16_54 == null) {
                                var4_4 = 500;
                                var5_5 = "Error listing producers on connection  " + var9_9 + " unknown connectionUID";
                            }
                            var17_69 = Producer.getAllProducers();
                            while (var16_54 != null && var17_69.hasNext()) {
                                var18_85 = (Producer)var17_69.next();
                                if (!var15_27.equals(var18_85.getConnectionUID())) continue;
                                var12_12.put(String.valueOf(var18_85.getProducerUID().longValue()), var18_85.getDestinationUID().toString());
                            }
                        }
                        catch (Exception var15_28) {
                            var4_4 = 500;
                            var5_5 = "Error listing producers on connection  " + var9_9 + " because " + var15_28.toString();
                            this.logger.logStack(8, var5_5, var15_28);
                        }
                    } else {
                        var4_4 = 500;
                        var5_5 = "Unknown targetType (-t) " + var10_10 + "\n Valid formats are of the form: " + "[t|q|cxn]";
                    }
                } else {
                    var4_4 = 500;
                    var5_5 = "Unknown argument " + var8_8;
                }
            } else if (var7_7.equals("debug")) {
                var15_29 = (String)var11_11.get("enable");
                if (var15_29 != null && !var15_29.equalsIgnoreCase("true") && !var15_29.equalsIgnoreCase("false")) {
                    var4_4 = 500;
                    var5_5 = "bad enable flag setting " + var15_29 + " defauling to false";
                }
                v0 = var16_55 = var15_29 == null ? true : Boolean.valueOf(var15_29);
                if (var8_8.equals("reset")) {
                    if (var10_10 == null) {
                        var5_5 = "Please supply targetType (-t)\n Valid formats are of the form: [metrics|jdbcconnpool]";
                        var4_4 = 500;
                    } else if (var10_10.equalsIgnoreCase("jdbcconnpool")) {
                        try {
                            if (Globals.getStore().isJDBCStore()) {
                                DBManager.getDBManager().resetConnectionPool();
                                break block152;
                            }
                            var4_4 = 500;
                            var5_5 = "Operation is not applicable for a file-based data store.";
                        }
                        catch (Exception var17_70) {
                            var4_4 = 500;
                            var5_5 = "Error resetting JDBC connection pool because " + var17_70.toString();
                            this.logger.logStack(8, var5_5, var17_70);
                        }
                    } else if (var10_10.equalsIgnoreCase("metrics")) {
                        ResetMetricsHandler.resetAllMetrics();
                    }
                } else if (var8_8.equals("fault")) {
                    var17_71 = (String)var11_11.get("name");
                    if (var17_71 == null) {
                        var17_71 = var9_9;
                    }
                    var18_86 = (String)var11_11.get("selector");
                    var19_93 = FaultInjection.getInjection();
                    var20_99 = true;
                    if (var15_29 != null && var15_29.equalsIgnoreCase("false")) {
                        if (var17_71 == null) {
                            var19_93.setFaultInjection(false);
                        } else {
                            var19_93.unsetFault(var17_71);
                        }
                    } else {
                        var19_93.setFaultInjection(true);
                        if (var17_71 != null) {
                            try {
                                var19_93.setFault(var17_71, var18_86, var11_11);
                            }
                            catch (Exception var21_103) {
                                var4_4 = 500;
                                var5_5 = "Bad Selector " + var18_86;
                            }
                        }
                    }
                } else if (var8_8.equals("gc")) {
                    this.logger.log(8, "GC'ing the system");
                    Broker.runGC();
                    var17_72 = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                    var5_5 = "Used memory is " + var17_72 / 1024L + "k, " + " this is " + var17_72 * 100L / Runtime.getRuntime().maxMemory() + "% of " + Runtime.getRuntime().maxMemory() / 1024L + "k";
                    this.logger.log(8, var5_5);
                    if (var12_12 == null) {
                        var12_12 = new Hashtable<K, V>();
                    }
                    var12_12.put("Memory", var5_5);
                    var12_12.put("Used", var17_72 / 1024L + "k");
                    var12_12.put("Total", Runtime.getRuntime().totalMemory() / 1024L + "k");
                    var12_12.put("Free", Runtime.getRuntime().freeMemory() / 1024L + "k");
                    var12_12.put("Max", Runtime.getRuntime().maxMemory() / 1024L + "k");
                } else if (var8_8.equals("threads")) {
                    try {
                        var12_12 = new Hashtable<K, V>();
                        var12_12.put("threads", "dumped to log");
                    }
                    catch (Exception var17_73) {
                        var4_4 = 500;
                        var5_5 = "Error " + var7_7 + "ing " + var8_8 + " because " + var17_73.getMessage() + "";
                        this.logger.logStack(8, var5_5, var17_73);
                    }
                    this.logger.log(8, "Dumping threads:\n" + SupportUtil.getAllStackTraces("\t"));
                } else if (var8_8.equals("pkt")) {
                    IMQBasicConnection.dumpPacket(var16_55);
                } else if (var8_8.equals("pktin")) {
                    IMQBasicConnection.dumpInPacket(var16_55);
                } else if (var8_8.equals("pktout")) {
                    IMQBasicConnection.dumpOutPacket(var16_55);
                } else if (var8_8.equals("class")) {
                    try {
                        var17_74 = Class.forName(var9_9);
                        var18_87 = var17_74.getDeclaredFields();
                        var19_94 = false;
                        for (var20_100 = 0; var20_100 < var18_87.length; ++var20_100) {
                            if (!var18_87[var20_100].getName().equals("DEBUG")) continue;
                            var18_87[var20_100].setAccessible(true);
                            var18_87[var20_100].setBoolean(null, var16_55);
                            var19_94 = true;
                            break;
                        }
                        if (!var19_94) {
                            throw new NoSuchFieldException("DEBUG");
                        }
                    }
                    catch (Exception var17_75) {
                        var4_4 = 500;
                        var5_5 = "Unable to set DEBUG on class " + var9_9 + " because " + var17_75.toString();
                        this.logger.logStack(8, var5_5, var17_75);
                    }
                } else {
                    var4_4 = 500;
                    var5_5 = "Unknown debug argument " + var8_8;
                }
            } else if (var7_7.equals("resume")) {
                if (var8_8.equals("prd")) {
                    try {
                        var15_30 = new ProducerUID(Long.parseLong(var9_9));
                        var16_56 = Producer.getProducer(var15_30);
                        var17_76 = Destination.getDestination(var16_56.getDestinationUID());
                        this.logger.log(8, "Resuming " + var16_56);
                        var17_76.forceResumeFlow(var16_56);
                    }
                    catch (Exception var15_31) {
                        var4_4 = 500;
                        var5_5 = "Error resuming flow from producer  " + var9_9 + " because " + var15_31.toString();
                        this.logger.logStack(8, var5_5, var15_31);
                    }
                } else if (var8_8.equals("cxn")) {
                    try {
                        var15_32 = new ConnectionUID(Long.parseLong(var9_9));
                        var16_57 = (IMQConnection)Globals.getConnectionManager().getConnection(var15_32);
                        var16_57.resumeFlow(-1);
                    }
                    catch (Exception var15_33) {
                        var4_4 = 500;
                        var5_5 = "Error resuming flow on connection  " + var9_9 + " because " + var15_33.toString();
                        this.logger.logStack(8, var5_5, var15_33);
                    }
                } else if (var8_8.equals("con")) {
                    try {
                        var15_34 = new ConsumerUID(Long.parseLong(var9_9));
                        var16_58 = Consumer.getConsumer(var15_34);
                        var16_58.resume("admin debug");
                    }
                    catch (Exception var15_35) {
                        var4_4 = 500;
                        var5_5 = "Error resuming flow to consumer  " + var9_9 + " because " + var15_35.toString();
                        this.logger.logStack(8, var5_5, var15_35);
                    }
                } else if (var8_8.equals("ses")) {
                    try {
                        var15_36 = new SessionUID(Long.parseLong(var9_9));
                        var16_59 = Session.getSession(var15_36);
                        var16_59.resume("admin debug");
                    }
                    catch (Exception var15_37) {
                        var4_4 = 500;
                        var5_5 = "Error resuming flow to session  " + var9_9 + " because " + var15_37.toString();
                        this.logger.logStack(8, var5_5, var15_37);
                    }
                } else {
                    var4_4 = 500;
                    var5_5 = "Unknown resume argument " + var8_8;
                }
            } else if (var7_7.equals("send")) {
                if (var8_8.equals("cxn")) {
                    try {
                        if (var9_9 == null) {
                            var4_4 = 500;
                            var5_5 = "Missing connectionUID ";
                            break block152;
                        }
                        var15_38 = new ConnectionUID(Long.parseLong(var9_9));
                        var16_60 = (IMQConnection)Globals.getConnectionManager().getConnection(var15_38);
                        if (var16_60 == null) {
                            var4_4 = 500;
                            var5_5 = "Unknown connectionUID " + var15_38;
                            break block152;
                        }
                        var17_77 = new Packet(false);
                        var17_77.setPacketType(74);
                        var18_88 = new Hashtable<K, V>(var3_3);
                        var19_95 = new ByteArrayOutputStream();
                        var20_101 = new ObjectOutputStream(var19_95);
                        var20_101.writeObject(var11_11);
                        var20_101.flush();
                        var19_95.flush();
                        var17_77.setMessageBody(var19_95.toByteArray());
                        var17_77.setProperties(var18_88);
                        var16_60.sendControlMessage(var17_77);
                    }
                    catch (Exception var15_39) {
                        var4_4 = 500;
                        var5_5 = "Error notifying consumer  " + var9_9 + " because " + var15_39.toString();
                        this.logger.logStack(8, var5_5, var15_39);
                    }
                } else if (var8_8.equals("bkr") || var8_8.equals("svc")) {
                    var15_40 = null;
                    if (var9_9 != null && (var15_40 = Globals.getServiceManager().getService(var9_9)) == null) {
                        var5_5 = "Unknown service " + var9_9;
                        var4_4 = 500;
                    }
                    var16_61 = Globals.getConnectionManager().getConnectionList(var15_40).iterator();
                    try {
                        while (var16_61.hasNext()) {
                            var17_78 = (IMQConnection)var16_61.next();
                            var18_89 = new Packet(false);
                            var18_89.setPacketType(74);
                            var19_96 = new Hashtable<K, V>(var3_3);
                            var20_102 = new ByteArrayOutputStream();
                            var21_104 = new ObjectOutputStream(var20_102);
                            var21_104.writeObject(var11_11);
                            var21_104.flush();
                            var20_102.flush();
                            var18_89.setMessageBody(var20_102.toByteArray());
                            var18_89.setProperties(var19_96);
                            var17_78.sendControlMessage(var18_89);
                        }
                    }
                    catch (Exception var17_79) {
                        var4_4 = 500;
                        var5_5 = "Error notifying consumer  " + var9_9 + " because " + var17_79.toString();
                        this.logger.logStack(8, var5_5, var17_79);
                    }
                } else {
                    var4_4 = 500;
                    var5_5 = "Unknown send argument " + var8_8;
                }
            } else if (var7_7.equals("kill")) {
                if (var8_8.equals("cxn")) {
                    try {
                        var15_41 = new ConnectionUID(Long.parseLong(var9_9));
                        var16_62 = (IMQConnection)Globals.getConnectionManager().getConnection(var15_41);
                        var16_62.destroyConnection(true, 3, "kill cnx");
                    }
                    catch (Exception var15_42) {
                        var4_4 = 500;
                        var5_5 = "Error killing connection  " + var9_9 + " because " + var15_42.toString();
                        this.logger.logStack(8, var5_5, var15_42);
                    }
                } else {
                    var4_4 = 500;
                    var5_5 = "Unknown kill argument " + var8_8;
                }
            }
        }
        if (var13_13 != null && var12_12 != null) {
            var15_43 = new DebugPrinter(2);
            var15_43.setHashtable(var12_12);
            var15_43.setFile(var13_13);
            var15_43.println();
            var15_43.close();
            if (var4_4 == 200) {
                var5_5 = "Data logged at file " + var13_13;
            }
            if (var6_6) {
                var12_12 = new Hashtable<K, V>();
                var12_12.put("logfile", var13_13);
            }
        }
        if (var5_5 != null) {
            this.logger.log(8, var5_5);
        }
        DebugHandler.setProperties(var14_14, 73, var4_4, var5_5);
        if (var12_12 != null) {
            this.setBodyObject(var14_14, var12_12);
        }
        this.parent.sendReply(var1_1, var2_2, var14_14);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Hashtable getDebugInfo(String string, String string2, String string3, Properties properties) throws Exception {
        if (string.equals("cxn")) {
            if (string2 == null) {
                return this.getAllCxnInfo(null);
            }
            ConnectionUID connectionUID = new ConnectionUID(Long.parseLong(string2));
            return this.getCxnInfo(connectionUID);
        }
        if (string.equals("config")) {
            return this.getConfig();
        }
        if (string.equals("memory")) {
            return this.getMemory();
        }
        if (string.equals("dst")) {
            if (string2 == null) {
                return Destination.getAllDebugState();
            }
            boolean bl = false;
            if (string3 == null) {
                throw new Exception("topic or queue not specified with -t [t|q]");
            }
            if (string3.equals("t")) {
                bl = false;
            } else {
                if (!string3.equals("q")) throw new Exception("Unknown -t argument " + string3 + " expected t or q");
                bl = true;
            }
            DestinationUID destinationUID = DestinationUID.getUID(string2, bl);
            return this.getDestinationInfo(destinationUID);
        }
        if (string.equals("ses")) {
            if (string2 == null) {
                return Session.getAllDebugState();
            }
            SessionUID sessionUID = new SessionUID(Long.parseLong(string2));
            return this.getSession(sessionUID);
        }
        if (string.equals("prd")) {
            if (string2 == null) {
                return Producer.getAllDebugState();
            }
            ProducerUID producerUID = new ProducerUID(Long.parseLong(string2));
            return this.getProducerInfo(producerUID);
        }
        if (string.equals("con")) {
            if (string2 == null) {
                return Consumer.getAllDebugState();
            }
            ConsumerUID consumerUID = new ConsumerUID(Long.parseLong(string2));
            return this.getConInfo(consumerUID);
        }
        if (string.equals("svc")) {
            if (string2 != null) return this.getSvcInfo(string2);
            this.logger.log(8, "XXX - target of null not implemented for " + string);
        } else {
            if (string.equals("db")) {
                return this.getDBInfo();
            }
            if (string.equals("trans")) {
                if (string2 == null) {
                    return this.getTransactionInfo(null);
                }
                TransactionUID transactionUID = new TransactionUID(Long.parseLong(string2));
                return this.getTransactionInfo(transactionUID);
            }
            if (string.equals("pool")) {
                if (string2 != null) return this.getThreadPoolInfo(string2);
                this.logger.log(8, "XXX - target of null not implemented for " + string);
            } else {
                if (string.equals("threads")) {
                    return SupportUtil.getAllStackTracesAsMap();
                }
                if (string.equals("cls")) {
                    return this.getClusterInfo();
                }
                if (string.equals("bkr")) {
                    return this.getBrokerInfo();
                }
                if (string.equals("pkt")) {
                    String string4 = properties.getProperty("full");
                    boolean bl = false;
                    if (string4 == null || !string4.equalsIgnoreCase("True")) return this.getPktInfo(string2, string3, bl);
                    bl = true;
                    return this.getPktInfo(string2, string3, bl);
                }
            }
        }
        this.logger.log(8, "Unknown dump arg " + string);
        return null;
    }

    private Hashtable getPktInfo(String string, String string2, boolean bl) throws Exception {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        if (string2 == null || string2.length() == 0 || string2.equals("bkr")) {
            Hashtable<String, Hashtable> hashtable2 = new Hashtable<String, Hashtable>();
            Iterator iterator = Destination.getAllDestinations();
            while (iterator.hasNext()) {
                Destination destination = (Destination)iterator.next();
                hashtable2.put(destination.getDestinationUID().toString(), destination.getDebugMessages(bl));
            }
            hashtable.put("Destinations", hashtable2);
        } else if (string2.equals("q") || string2.equals("t")) {
            boolean bl2 = false;
            if (string2.equals("t")) {
                bl2 = false;
            } else if (string2.equals("q")) {
                bl2 = true;
            }
            DestinationUID destinationUID = DestinationUID.getUID(string, bl2);
            Destination destination = Destination.getDestination(destinationUID);
            if (destination == null) {
                throw new Exception("Unknown destination " + destinationUID);
            }
            hashtable.putAll(destination.getDebugMessages(bl));
        } else if (string2.equals("con")) {
            if (string == null) {
                throw new Exception("Please specify consumerUID");
            }
            ConsumerUID consumerUID = new ConsumerUID(Long.parseLong(string));
            Consumer consumer = Consumer.getConsumer(consumerUID);
            if (consumer == null) {
                throw new Exception("Unknown consumer " + consumerUID);
            }
            hashtable.put(consumerUID.toString(), consumer.getDebugMessages(bl));
        } else if (string2.equals("cxn")) {
            if (string == null) {
                throw new Exception("Please specify connectionUID");
            }
            ConnectionUID connectionUID = new ConnectionUID(Long.parseLong(string));
            IMQConnection iMQConnection = (IMQConnection)Globals.getConnectionManager().getConnection(connectionUID);
            if (iMQConnection == null) {
                throw new Exception("Can not find connection " + connectionUID);
            }
            hashtable.put(string, iMQConnection.getDebugMessages(bl));
        } else if (string2.equals("ses")) {
            hashtable.put("Dump acks ", string);
            if (string == null) {
                throw new Exception("Please specify SessionUID");
            }
            SessionUID sessionUID = new SessionUID(Long.parseLong(string));
            Session session = Session.getSession(sessionUID);
            if (session == null) {
                throw new Exception("Can not find session " + sessionUID);
            }
            hashtable.put(string, session.getDebugMessages(bl));
        } else {
            hashtable.put("Error", "Unknown pkt type " + string2);
        }
        return hashtable;
    }

    private Hashtable getAllCxnInfo(String string) throws Exception {
        Service service = null;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        if (string != null) {
            service = Globals.getServiceManager().getService(string);
            hashtable.put("threadPool", this.getThreadPoolInfo(string));
            hashtable.put("threads", SupportUtil.getAllStackTraces(""));
        }
        for (IMQConnection iMQConnection : Globals.getConnectionManager().getConnectionList(service)) {
            hashtable.put(iMQConnection.getRemoteConnectionString(), iMQConnection.getDebugState());
        }
        return hashtable;
    }

    private Hashtable getCxnInfo(ConnectionUID connectionUID) throws Exception {
        IMQConnection iMQConnection = (IMQConnection)Globals.getConnectionManager().getConnection(connectionUID);
        if (iMQConnection == null) {
            throw new Exception("Can not find uid " + connectionUID);
        }
        return iMQConnection.getDebugState();
    }

    private Hashtable getConInfo(ConsumerUID consumerUID) throws Exception {
        Consumer consumer = Consumer.getConsumer(consumerUID);
        if (consumer == null) {
            throw new Exception("Can not find consumer " + consumerUID);
        }
        return consumer.getDebugState();
    }

    private Hashtable getSession(SessionUID sessionUID) throws Exception {
        Session session = Session.getSession(sessionUID);
        if (session == null) {
            throw new Exception("Can not find session " + sessionUID);
        }
        return session.getDebugState();
    }

    private Hashtable getSvcInfo(String string) throws Exception {
        if (string == null) {
            Hashtable<String, Hashtable> hashtable = new Hashtable<String, Hashtable>();
            Globals.getServiceManager();
            List list = ServiceManager.getAllActiveServiceNames();
            for (String string2 : list) {
                hashtable.put(string2, this.getSvcInfo(string2));
            }
            return hashtable;
        }
        Service service = Globals.getServiceManager().getService(string);
        if (service == null) {
            throw new Exception("unknown service " + string);
        }
        return service.getDebugState();
    }

    private Hashtable getProducerInfo(ProducerUID producerUID) throws Exception {
        Producer producer = Producer.getProducer(producerUID);
        if (producer == null) {
            throw new Exception("Can not find producer " + producerUID);
        }
        return producer.getDebugState();
    }

    private Hashtable getDBInfo() throws Exception {
        return Globals.getStore().getDebugState();
    }

    private Hashtable getTransactionInfo(TransactionUID transactionUID) throws Exception {
        TransactionList transactionList = Globals.getTransactionList();
        Hashtable hashtable = null;
        hashtable = transactionUID == null ? transactionList.getDebugState() : transactionList.getDebugState(transactionUID);
        return hashtable;
    }

    private Hashtable getDestinationInfo(DestinationUID destinationUID) throws Exception {
        Destination destination = Destination.getDestination(destinationUID);
        if (destination == null) {
            throw new Exception("Can not find Destination " + destinationUID);
        }
        return destination.getDebugState();
    }

    private Hashtable getThreadPoolInfo(String string) throws Exception {
        if (string == null) {
            Hashtable<String, Hashtable> hashtable = new Hashtable<String, Hashtable>();
            Globals.getServiceManager();
            List list = ServiceManager.getAllActiveServiceNames();
            for (String string2 : list) {
                hashtable.put(string2, this.getThreadPoolInfo(string2));
            }
            return hashtable;
        }
        Service service = Globals.getServiceManager().getService(string);
        if (service == null) {
            throw new Exception("unknown service " + string);
        }
        return ((IMQService)service).getPoolDebugState();
    }

    private Hashtable getClusterInfo() {
        Hashtable<String, Hashtable> hashtable = new Hashtable<String, Hashtable>();
        hashtable.put("Cluster Service", Globals.getClusterBroadcast().getAllDebugState());
        return hashtable;
    }

    private Hashtable getBrokerInfo() throws Exception {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        try {
            hashtable.put("Destinations", Destination.getAllDebugState());
        }
        catch (Exception exception) {
            this.logger.logStack(8, "getBrokerInfo:", exception);
            hashtable.put("Destinations", "Error retrieving state " + exception);
        }
        try {
            hashtable.put("Producers", Producer.getAllDebugState());
        }
        catch (Exception exception) {
            this.logger.logStack(8, "getBrokerInfo:", exception);
            hashtable.put("Producers", "Error retrieving state " + exception);
        }
        try {
            hashtable.put("Consumers", Consumer.getAllDebugState());
        }
        catch (Exception exception) {
            this.logger.logStack(8, "getBrokerInfo:", exception);
            hashtable.put("Consumers", "Error retrieving state " + exception);
        }
        try {
            hashtable.put("Sessions", Session.getAllDebugState());
        }
        catch (Exception exception) {
            this.logger.logStack(8, "getBrokerInfo:", exception);
            hashtable.put("Sessions", "Error retrieving state " + exception);
        }
        try {
            hashtable.put("Connections[jms]", this.getAllCxnInfo("jms"));
        }
        catch (Exception exception) {
            this.logger.logStack(8, "getBrokerInfo:", exception);
            hashtable.put("Connections[jms]", "Error retrieving state " + exception);
        }
        try {
            hashtable.put("Connections[admin]", this.getAllCxnInfo("admin"));
        }
        catch (Exception exception) {
            this.logger.logStack(8, "getBrokerInfo:", exception);
            hashtable.put("Connections[admin]", "Error retrieving state " + exception);
        }
        try {
            hashtable.put("Config", this.getConfig());
        }
        catch (Exception exception) {
            this.logger.logStack(8, "getBrokerInfo:", exception);
            hashtable.put("Config", "Error retrieving state " + exception);
        }
        try {
            hashtable.put("Memory", this.getMemory());
        }
        catch (Exception exception) {
            this.logger.logStack(8, "getBrokerInfo:", exception);
            hashtable.put("Memory", "Error retrieving state " + exception);
        }
        try {
            hashtable.put("DB", this.getDBInfo());
        }
        catch (Exception exception) {
            this.logger.logStack(8, "getBrokerInfo:", exception);
            hashtable.put("DB", "Error retrieving state " + exception);
        }
        try {
            hashtable.put("Transactions", this.getTransactionInfo(null));
        }
        catch (Exception exception) {
            this.logger.logStack(8, "getBrokerInfo:", exception);
            hashtable.put("Transactions", "Error retrieving state " + exception);
        }
        try {
            hashtable.put("Cluster", this.getClusterInfo());
        }
        catch (Exception exception) {
            this.logger.logStack(8, "getBrokerInfo:", exception);
            hashtable.put("Cluster", "Error retrieving state " + exception);
        }
        try {
            hashtable.put("Service[jms]", this.getSvcInfo("jms"));
        }
        catch (Exception exception) {
            this.logger.logStack(8, "getBrokerInfo:", exception);
            hashtable.put("Service[jms]", "Error retrieving state " + exception);
        }
        try {
            hashtable.put("Service[admin]", this.getSvcInfo("admin"));
        }
        catch (Exception exception) {
            this.logger.logStack(8, "getBrokerInfo:", exception);
            hashtable.put("Service[admin]", "Error retrieving state " + exception);
        }
        try {
            hashtable.put("threads", SupportUtil.getAllStackTraces(""));
        }
        catch (Exception exception) {
            this.logger.logStack(8, "getBrokerInfo:", exception);
            hashtable.put("threads", "Error retrieving state " + exception);
        }
        return hashtable;
    }

    private Hashtable getMemory() throws Exception {
        return Globals.getMemManager().getDebugState();
    }

    private Hashtable getConfig() throws Exception {
        Hashtable<Object, String> hashtable = new Hashtable<Object, String>();
        for (Object object : Globals.getConfig().keySet()) {
            hashtable.put(object, Globals.getConfig().get(object).toString());
        }
        return hashtable;
    }
}

