/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.multibroker.MessageBusCallback;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterConsumerInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterSubscriptionInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.GPacketHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ProtocolGlobals;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.RaptorProtocol;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.ConsumerAlreadyAddedException;
import java.io.IOException;

public class NewInterestHandler
extends GPacketHandler {
    private static boolean DEBUG = false;

    public NewInterestHandler(RaptorProtocol raptorProtocol) {
        super(raptorProtocol);
    }

    public void handle(MessageBusCallback messageBusCallback, BrokerAddress brokerAddress, GPacket gPacket) {
        if (DEBUG) {
            this.logger.log(4, "NewInterestHandler");
        }
        if (gPacket.getType() == 5) {
            this.handleNewInterest(messageBusCallback, brokerAddress, gPacket);
        } else if (gPacket.getType() == 6) {
            this.handleNewInterestAck(brokerAddress, gPacket);
        } else if (gPacket.getType() == 35) {
            this.handleAttachDurable(messageBusCallback, brokerAddress, gPacket);
        } else if (gPacket.getType() == 36) {
            this.handleAttachDurableReply(brokerAddress, gPacket);
        } else {
            this.logger.log(16, "MessageDataHandler Internal error : Cannot handle this packet :" + gPacket.toLongString());
        }
    }

    public boolean ignoreNewInterest(ClusterConsumerInfo clusterConsumerInfo, GPacket gPacket) {
        ClusterConsumerInfo clusterConsumerInfo2 = clusterConsumerInfo;
        if (clusterConsumerInfo2 == null) {
            clusterConsumerInfo2 = ClusterConsumerInfo.newInstance(gPacket, this.c);
        }
        if (!this.p.getConfigSyncComplete() && !clusterConsumerInfo2.isConfigSyncResponse()) {
            if (DEBUG) {
                this.logger.log(8, "Ignore " + ProtocolGlobals.getPacketTypeDisplayString(gPacket.getType()) + ", not ready yet");
            }
            return true;
        }
        return false;
    }

    public void handleNewInterest(MessageBusCallback messageBusCallback, BrokerAddress brokerAddress, GPacket gPacket) {
        Object object;
        ClusterConsumerInfo clusterConsumerInfo;
        if (DEBUG) {
            this.logger.log(8, "handleNewInterest from : " + brokerAddress);
        }
        if (this.ignoreNewInterest(clusterConsumerInfo = ClusterConsumerInfo.newInstance(gPacket, this.c), gPacket)) {
            return;
        }
        int n = clusterConsumerInfo.getConsumerCount();
        if (DEBUG) {
            this.logger.log(8, "handleNewInterest count : " + n);
        }
        try {
            object = clusterConsumerInfo.getConsumers();
            while (object.hasNext()) {
                Consumer consumer = (Consumer)object.next();
                DestinationUID destinationUID = consumer.getDestinationUID();
                if (!destinationUID.isWildcard()) {
                    int n2 = destinationUID.isQueue() ? 1 : 2;
                    Destination destination = Destination.getDestination(destinationUID.getName(), n2, true, true);
                }
                messageBusCallback.interestCreated(consumer);
                if (!DEBUG) continue;
                this.logger.log(8, "Added newInterest(" + n + ")" + consumer + " from " + brokerAddress);
            }
        }
        catch (Exception exception) {
            this.logger.logStack(4, "Exception processing packet ", exception);
        }
        if (clusterConsumerInfo.needReply()) {
            object = ClusterConsumerInfo.getReplyGPacket((short)6, 200);
            try {
                this.c.unicast(brokerAddress, (GPacket)object);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void handleNewInterestAck(BrokerAddress brokerAddress, GPacket gPacket) {
        this.logger.log(4, "MessageBus: Received G_NEW_INTEREST_REPLY from {0} : STATUS = {1}", (Object)brokerAddress, (Integer)gPacket.getProp("S"));
    }

    public void handleAttachDurable(MessageBusCallback messageBusCallback, BrokerAddress brokerAddress, GPacket gPacket) {
        Object object;
        ClusterSubscriptionInfo clusterSubscriptionInfo;
        block15: {
            if (DEBUG) {
                this.logger.log(8, "handleAttachDurable from : " + brokerAddress);
            }
            clusterSubscriptionInfo = ClusterSubscriptionInfo.newInstance(gPacket, this.c);
            try {
                boolean bl;
                object = clusterSubscriptionInfo.getDurableName();
                String string = clusterSubscriptionInfo.getClientID();
                Boolean bl2 = clusterSubscriptionInfo.allowsNonDurable();
                boolean bl3 = bl = bl2 == null ? false : bl2;
                if (string == null || !bl && object == null) {
                    this.logger.log(8, "Internal Error in handleAttachDurable : " + (String)object + ":" + string);
                    return;
                }
                Consumer consumer = clusterSubscriptionInfo.getConsumer();
                Subscription subscription = null;
                if (object == null) {
                    DestinationUID destinationUID = consumer.getDestinationUID();
                    String string2 = consumer.getSelectorStr();
                    subscription = Subscription.findNonDurableSubscription(string, destinationUID, string2);
                } else {
                    subscription = Subscription.findDurableSubscription(string, (String)object);
                }
                if (DEBUG) {
                    this.logger.log(8, "handleAttachDurable:dname=" + (String)object + ", subscription=" + subscription + ", consumer=" + consumer + " from " + brokerAddress);
                }
                if (subscription == null) {
                    this.logger.log(8, "Internal Error in handleAttachDurable.  Subscription not found : " + (String)object + ":" + string);
                    return;
                }
                try {
                    subscription.attachConsumer(consumer);
                    messageBusCallback.interestCreated(consumer);
                }
                catch (Exception exception) {
                    if (exception instanceof ConsumerAlreadyAddedException) {
                        this.logger.log(8, exception.getMessage() + " (" + ProtocolGlobals.getPacketTypeDisplayString(gPacket.getType()) + ")");
                        break block15;
                    }
                    if (exception instanceof BrokerException && ((BrokerException)exception).getStatusCode() == 409) {
                        this.logger.log(16, Globals.getBrokerResources().getKString("B2211", exception.getMessage()));
                        break block15;
                    }
                    this.logger.log(32, Globals.getBrokerResources().getKString("B2211", exception.getMessage()), exception);
                }
            }
            catch (Exception exception) {
                this.logger.logStack(4, "Exception processing packet ", exception);
            }
        }
        if (clusterSubscriptionInfo.needReply()) {
            object = ClusterSubscriptionInfo.getReplyGPacket((short)36, 200);
            try {
                this.c.unicast(brokerAddress, (GPacket)object);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void handleAttachDurableReply(BrokerAddress brokerAddress, GPacket gPacket) {
        this.logger.log(4, "MessageBus: Received G_DURABLE_ATTACH_REPLY from {0} : STATUS = {1}", (Object)brokerAddress, (Integer)gPacket.getProp("S"));
    }
}

