/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.util.DestType;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;

public class GetMessagesHandler
extends AdminCmdHandler {
    private static boolean DEBUG = GetMessagesHandler.getDEBUG();

    public GetMessagesHandler(AdminDataHandler adminDataHandler) {
        super(adminDataHandler);
    }

    public boolean handle(IMQConnection iMQConnection, Packet packet, Hashtable hashtable) {
        Object object;
        String string;
        int n;
        Vector<HashMap> vector;
        block14: {
            if (DEBUG) {
                this.logger.log(4, this.getClass().getName() + ": " + "Getting messages: " + hashtable);
            }
            vector = new Vector<HashMap>();
            n = 200;
            string = null;
            String string2 = (String)hashtable.get("JMQDestination");
            Integer n2 = (Integer)hashtable.get("JMQDestType");
            Long l = (Long)hashtable.get("JMQStartMessageIndex");
            Long l2 = (Long)hashtable.get("JMQMaxNumMsgsRetrieved");
            Boolean bl = (Boolean)hashtable.get("JMQGetMessageBody");
            String string3 = (String)hashtable.get("JMQMessageID");
            HashMap hashMap = new HashMap();
            if (string2 == null || n2 == null) {
                string = "Destination name and type not specified";
                this.logger.log(32, string);
                n = 500;
            }
            if (bl == null) {
                bl = Boolean.FALSE;
            }
            if (string2 != null) {
                try {
                    object = Destination.getDestination(string2, DestType.isQueue(n2));
                    if (object != null) {
                        if (DEBUG) {
                            ((Destination)object).debug();
                        }
                        if (string3 != null) {
                            ((Destination)object).load();
                            SysMessageID sysMessageID = SysMessageID.get(string3);
                            PacketReference packetReference = GetMessagesHandler.getPacketReference(sysMessageID);
                            if (packetReference != null) {
                                HashMap hashMap2 = this.constructMessageInfo(sysMessageID, bl, hashMap);
                                vector.add(hashMap2);
                            } else {
                                string = "Could not locate message " + string3 + " in destination " + string2;
                                n = 404;
                            }
                        } else {
                            SysMessageID[] sysMessageIDArray = ((Destination)object).getSysMessageIDs(l, l2);
                            for (int i = 0; i < sysMessageIDArray.length; ++i) {
                                HashMap hashMap3 = this.constructMessageInfo(sysMessageIDArray[i], bl, hashMap);
                                vector.add(hashMap3);
                            }
                        }
                    } else {
                        string = this.rb.getString("B4017", string2);
                        n = 404;
                    }
                }
                catch (Exception exception) {
                    this.logger.log(32, "Internal Error ", exception);
                    exception.printStackTrace();
                    n = 500;
                    if ($assertionsDisabled) break block14;
                    throw new AssertionError();
                }
            }
        }
        object = new Packet(iMQConnection.useDirectBuffers());
        ((Packet)object).setPacketType(5);
        GetMessagesHandler.setProperties((Packet)object, 87, n, string);
        this.setBodyObject((Packet)object, vector);
        this.parent.sendReply(iMQConnection, packet, (Packet)object);
        return true;
    }

    public HashMap constructMessageInfo(SysMessageID sysMessageID, boolean bl, HashMap hashMap) {
        Hashtable hashtable;
        String string;
        Object object;
        Object object2;
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        PacketReference packetReference = GetMessagesHandler.getPacketReference(sysMessageID);
        Packet packet = packetReference.getPacket();
        HashMap hashMap3 = packetReference.getHeaders();
        Destination destination = packetReference.getDestination();
        String string2 = packet.getCorrelationID();
        int n = 1;
        byte[] byArray = null;
        hashMap2.put("CorrelationID", string2);
        if (string2 != null) {
            try {
                byArray = string2.getBytes("UTF8");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        hashMap2.put("CorrelationIDAsBytes", byArray);
        hashMap2.put("DeliveryMode", packet.getPersistent() ? new Integer(2) : new Integer(1));
        hashMap2.put("DestinationName", packet.getDestination());
        n = packet.getIsQueue() ? 1 : 2;
        hashMap2.put("DestinationType", new Integer(n));
        hashMap2.put("Expiration", new Long(packet.getExpiration()));
        hashMap2.put("MessageID", hashMap3.get("JMSMessageID"));
        hashMap2.put("Priority", new Integer(packet.getPriority()));
        hashMap2.put("Redelivered", new Boolean(packet.getRedelivered()));
        String string3 = packet.getReplyTo();
        if (string3 != null) {
            boolean bl2 = false;
            boolean bl3 = true;
            if (hashMap != null && (object2 = (Boolean)hashMap.get(string3)) != null) {
                bl3 = (Boolean)object2;
                bl2 = true;
            }
            if (!bl2) {
                try {
                    object = Destination.findDestination(string3, true);
                    object2 = Destination.findDestination(string3, false);
                    if (object != null && object2 != null) {
                        string = "Cannot determine type of ReplyTo destination. There is a topic and queue with the name: " + string3;
                        this.logger.log(16, string);
                    } else if (object != null) {
                        bl2 = true;
                        bl3 = true;
                    } else if (object2 != null) {
                        bl2 = true;
                        bl3 = false;
                    }
                    if (bl2) {
                        hashMap.put(string3, new Boolean(bl3));
                    }
                }
                catch (Exception exception) {
                    string = "Caught exception while determining ReplyTo destination type";
                    this.logger.log(16, string, exception);
                }
            }
            hashMap2.put("ReplyToDestinationName", string3);
            if (bl2) {
                n = bl3 ? 1 : 2;
                hashMap2.put("ReplyToDestinationType", new Integer(n));
            }
        }
        hashMap2.put("Timestamp", new Long(packet.getTimestamp()));
        hashMap2.put("Type", packet.getMessageType());
        try {
            hashtable = packetReference.getProperties();
        }
        catch (Exception exception) {
            hashtable = null;
        }
        hashMap2.put("MessageProperties", hashtable);
        int n2 = packetReference.getPacket().getPacketType();
        hashMap2.put("MessageBodyType", new Integer(n2));
        if (bl) {
            object2 = packetReference.getPacket().getMessageBodyByteBuffer();
            object = null;
            if (((ByteBuffer)object2).hasArray()) {
                object = ((ByteBuffer)object2).array();
            }
            switch (n2) {
                case 1: {
                    try {
                        String string4 = new String((byte[])object, "UTF8");
                        hashMap2.put("MessageBody", string4);
                    }
                    catch (Exception exception) {
                        string = "Caught exception while creating text message body";
                        this.logger.log(32, string, exception);
                    }
                    break;
                }
                case 2: {
                    hashMap2.put("MessageBody", object);
                    break;
                }
                case 3: {
                    try {
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);
                        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                        HashMap hashMap4 = (HashMap)objectInputStream.readObject();
                        hashMap2.put("MessageBody", hashMap4);
                    }
                    catch (Exception exception) {
                        string = "Caught exception while creating map message body";
                        this.logger.log(32, string, exception);
                    }
                    break;
                }
                case 4: {
                    hashMap2.put("MessageBody", object);
                    break;
                }
                case 5: {
                    try {
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);
                        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                        Serializable serializable = (Serializable)objectInputStream.readObject();
                        hashMap2.put("MessageBody", serializable);
                    }
                    catch (Exception exception) {
                        string = "Caught exception while creating object message body";
                        this.logger.log(32, string, exception);
                    }
                    break;
                }
                default: {
                    string = "Unsupported message type for GET_MESSAGES handler: " + n2;
                    this.logger.log(32, string);
                }
            }
        }
        return hashMap2;
    }

    public static PacketReference getPacketReference(SysMessageID sysMessageID) {
        return Destination.get(sysMessageID);
    }
}

