/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service;

import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.PortMapperEntry;
import com.sun.messaging.jmq.io.PortMapperTable;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.FaultInjection;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.BrokerState;
import com.sun.messaging.jmq.jmsserver.cluster.BrokerStatus;
import com.sun.messaging.jmq.jmsserver.cluster.ClusterListener;
import com.sun.messaging.jmq.jmsserver.cluster.ClusterManager;
import com.sun.messaging.jmq.jmsserver.cluster.ClusteredBroker;
import com.sun.messaging.jmq.jmsserver.cluster.ha.HAClusteredBroker;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.BrokerMQAddress;
import com.sun.messaging.jmq.jmsserver.core.ClusterBroadcast;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.data.AutoRollbackType;
import com.sun.messaging.jmq.jmsserver.data.RollbackReason;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.handlers.TransactionHandler;
import com.sun.messaging.jmq.jmsserver.persist.HABrokerInfo;
import com.sun.messaging.jmq.jmsserver.persist.TakeoverLockException;
import com.sun.messaging.jmq.jmsserver.persist.TakeoverStoreInfo;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.service.TakingoverTracker;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.StoreBeingTakenOverException;
import com.sun.messaging.jmq.jmsservice.BrokerEvent;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.timer.MQTimer;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.Vector;

public class HAMonitorService
implements ClusterListener {
    private static boolean DEBUG_HA;
    private static boolean DEBUG;
    private Logger logger = Globals.getLogger();
    private static final String MONITOR_THRESHOLD_PROP = "imq.cluster.monitor.threshold";
    private static final String MONITOR_INTERVAL_PROP = "imq.cluster.monitor.interval";
    private int MAX_MONITOR_DEFAULT = 3;
    private int MAX_MONITOR = Globals.getConfig().getIntProperty("imq.cluster.monitor.threshold", this.MAX_MONITOR_DEFAULT);
    private int MONITOR_TIMEOUT_DEFAULT = 30;
    private int MONITOR_TIMEOUT = Globals.getConfig().getIntProperty("imq.cluster.monitor.interval", this.MONITOR_TIMEOUT_DEFAULT) * 1000;
    private int MAX_HEARTBEAT = Globals.getConfig().getIntProperty("imq.cluster.heartbeat.threshold", 30);
    private int reaperTimeout = Globals.getConfig().getIntProperty("imq.cluster.reaptime", 300) * 1000;
    ClusterManager clusterconfig = null;
    String mybrokerid = null;
    private HAMonitorTask haMonitor = null;
    Map indoubtBrokers = Collections.synchronizedMap(new LinkedHashMap());
    volatile int heartbeatMissedCnt = 0;
    FaultInjection fi = null;
    Runnable takeoverRunnable = null;
    Object takeoverRunnableLock = new Object();
    boolean monitorBusy = false;
    private Vector takingoverTargets = new Vector();

    public HAMonitorService(String string, MQAddress mQAddress, boolean bl) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        DEBUG = DEBUG || this.logger.getLevel() <= 4;
        this.fi = FaultInjection.getInjection();
        this.clusterconfig = Globals.getClusterManager();
        this.clusterconfig.addEventListener(this);
        this.mybrokerid = this.clusterconfig.getLocalBroker().getBrokerName();
        this.logger.log(8, "B1206", (Object)this.mybrokerid, mQAddress);
        this.logger.log(8, "imq.cluster.monitor.interval=" + this.MONITOR_TIMEOUT / 1000);
        this.logger.log(8, "imq.cluster.monitor.threshold=" + this.MAX_MONITOR);
        if (!string.equals(this.clusterconfig.getClusterId())) {
            this.logger.log(32, "B3201", (Object)string, this.clusterconfig.getClusterId());
            throw new IllegalStateException("Bad Cluster ID " + string);
        }
        HAClusteredBroker hAClusteredBroker = (HAClusteredBroker)this.clusterconfig.getLocalBroker();
        MQAddress mQAddress2 = hAClusteredBroker.getBrokerURL();
        if (!mQAddress2.equals(mQAddress)) {
            this.logger.log(8, "B1207", (Object)this.mybrokerid, mQAddress);
            try {
                object4 = String.valueOf(101) + "\n";
                object3 = new PortMapperTable();
                object2 = new Socket(mQAddress2.getHostName(), mQAddress2.getPort());
                InputStream inputStream = ((Socket)object2).getInputStream();
                object = ((Socket)object2).getOutputStream();
                try {
                    ((OutputStream)object).write(((String)object4).getBytes());
                    ((OutputStream)object).flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                ((PortMapperTable)object3).read(inputStream);
                inputStream.close();
                ((OutputStream)object).close();
                ((Socket)object2).close();
                PortMapperEntry portMapperEntry = ((PortMapperTable)object3).get("portmapper");
                String string2 = portMapperEntry.getProperty("brokerid");
                if (this.mybrokerid.equals(string2)) {
                    this.logger.log(32, "B3202", this.mybrokerid);
                    Broker.getBroker().exit(1, Globals.getBrokerResources().getKString("B3202", this.mybrokerid), BrokerEvent.Type.FATAL_ERROR);
                }
            }
            catch (IOException iOException) {
                this.logger.log(4, "Unable to reach old remote broker associated with " + this.mybrokerid);
            }
            hAClusteredBroker.setBrokerURL(mQAddress);
        }
        hAClusteredBroker.updateHeartbeat(true);
        object4 = this.clusterconfig.getConfigBrokers();
        while (object4.hasNext()) {
            object3 = (HAClusteredBroker)object4.next();
            object2 = object3.getTakeoverBroker();
            if (object2 == null || !((String)object2).equals(this.mybrokerid) || object3.getState() != BrokerState.FAILOVER_PENDING && object3.getState() != BrokerState.FAILOVER_STARTED) continue;
            this.logger.log(8, "B1209", object3.getBrokerName());
            object3.setState(BrokerState.FAILOVER_COMPLETE);
        }
        if (bl) {
            this.logger.log(8, Globals.getBrokerResources().getKString("B1335"));
            return;
        }
        object3 = hAClusteredBroker.getState();
        object2 = hAClusteredBroker.getTakeoverBroker();
        if (object3 == BrokerState.FAILOVER_STARTED || object3 == BrokerState.FAILOVER_PENDING) {
            this.logger.log(16, "B2134", (Object)this.mybrokerid, object2);
            long l = Globals.getConfig().getLongProperty("imq.cluster.ha.takeoverWaitTimeout", 300L);
            long l2 = l * 1000L;
            long l3 = 10000L;
            long l4 = System.currentTimeMillis();
            long l5 = l4 + l2;
            long l6 = l2 > l3 ? l3 : l2;
            do {
                this.logger.log(8, "B1208");
                try {
                    Thread.currentThread();
                    Thread.sleep(l6);
                }
                catch (InterruptedException interruptedException) {
                    throw new BrokerException("Waiting for taking over of this broker to complete is interrupted: " + interruptedException.getMessage());
                }
                hAClusteredBroker.updateHeartbeat(true);
                object3 = hAClusteredBroker.getState();
                l4 = System.currentTimeMillis();
                l6 = l5 - l4;
                if (l6 <= l3) continue;
                l6 = l3;
            } while ((object3 == BrokerState.FAILOVER_STARTED || object3 == BrokerState.FAILOVER_PENDING) && l4 < l5);
            if (l4 >= l5 && (object3 == BrokerState.FAILOVER_STARTED || object3 == BrokerState.FAILOVER_PENDING)) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B2225", String.valueOf(l)));
            }
        }
        try {
            hAClusteredBroker.resetTakeoverBrokerReadyOperating();
        }
        catch (Exception exception) {
            object3 = hAClusteredBroker.getState();
            if (object3 == BrokerState.FAILOVER_STARTED || object3 == BrokerState.FAILOVER_PENDING) {
                object = Globals.getBrokerResources().getKString("B3187");
                this.logger.logStack(32, (String)object, exception);
                throw new StoreBeingTakenOverException((String)object, 409);
            }
            throw exception;
        }
        Globals.setStoreSession(hAClusteredBroker.getStoreSessionUID());
        this.logger.log(8, "B1193", (Object)String.valueOf(hAClusteredBroker.getStoreSessionUID().longValue()), String.valueOf(hAClusteredBroker.getBrokerSessionUID().longValue()));
        if (this.MONITOR_TIMEOUT * this.MAX_MONITOR < 90000 && DBManager.getDBManager().isHADB()) {
            this.MAX_MONITOR = this.MAX_MONITOR_DEFAULT;
            this.MONITOR_TIMEOUT = this.MONITOR_TIMEOUT_DEFAULT * 1000;
            this.logger.log(16, "The HA Monitor Service takes over a failed broker when the total monitor time (the product of imq.cluster.monitor.interval and imq.cluster.monitor.threshhold) exceeds a set value. Due to HADB limitations, that value must be at least 90 seconds. Otherwise, the broker might not reliably take over messages from a failed broker. The total current interval is lower than 90 seconds; therefore, we are resetting the default value of imq.cluster.monitor.interval to 30, and the imq.cluster.monitor.threshhold value to 3.");
        }
        this.haMonitor = new HAMonitorTask();
        try {
            new HATimerThread("HAMonitor", this.haMonitor, this.MONITOR_TIMEOUT, this.MONITOR_TIMEOUT);
        }
        catch (Exception exception) {
            this.logger.log(16, "B3100", (Object)"Unable to start monitor Timeout", (Throwable)exception);
        }
    }

    public int getMonitorInterval() {
        return this.MONITOR_TIMEOUT / 1000;
    }

    public UID getStoreSession() {
        return ((HAClusteredBroker)this.clusterconfig.getLocalBroker()).getStoreSessionUID();
    }

    public String toString() {
        return "HAMonitorService[" + this.clusterconfig.getLocalBroker() + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void monitor() {
        Object object;
        Object object2;
        Object object3;
        HAClusteredBroker hAClusteredBroker = (HAClusteredBroker)this.clusterconfig.getLocalBroker();
        if (DEBUG) {
            this.logger.log(8, "HAMonitor is updating heartbeat timestamp of [" + this.mybrokerid + "]" + this.MONITOR_TIMEOUT);
        }
        try {
            if (this.fi.FAULT_INJECTION) {
                this.fi.checkFaultAndThrowBrokerException("hb.sharedb", null);
            }
            hAClusteredBroker.updateHeartbeat();
            this.heartbeatMissedCnt = 0;
        }
        catch (BrokerException brokerException) {
            ++this.heartbeatMissedCnt;
            if (this.heartbeatMissedCnt < this.MAX_HEARTBEAT) {
                this.logger.logStack(16, Globals.getBrokerResources().getKString("B2192", brokerException.getMessage()), brokerException);
            }
            object3 = Globals.getBrokerResources().getKString("B3230", this.MAX_HEARTBEAT);
            this.logger.logStack(32, (String)object3, brokerException);
            Broker.getBroker().exit(BrokerStateHandler.getRestartCode(), (String)object3, BrokerEvent.Type.RESTART, brokerException, true, false, false);
        }
        try {
            object2 = hAClusteredBroker.getState();
            if (object2 == BrokerState.QUIESCE_STARTED || object2 == BrokerState.QUIESCE_COMPLETED || object2 == BrokerState.FAILOVER_PENDING || object2 == BrokerState.FAILOVER_FAILED || object2 == BrokerState.SHUTDOWN_STARTED || object2 == BrokerState.SHUTDOWN_FAILOVER || object2 == BrokerState.SHUTDOWN_COMPLETE) {
                return;
            }
        }
        catch (BrokerException brokerException) {
            this.logger.logStack(16, "B4117", brokerException.getMessage(), (Throwable)brokerException);
        }
        if (this.indoubtBrokers.size() > 0) {
            this.logger.log(8, "B1210", String.valueOf(this.indoubtBrokers.size()));
        }
        object2 = null;
        object3 = new HashSet(this.indoubtBrokers.keySet());
        Object object4 = this.takeoverRunnableLock;
        synchronized (object4) {
            this.monitorBusy = true;
        }
        try {
            object4 = object3.iterator();
            while (object4.hasNext()) {
                Object e = object4.next();
                indoubtData indoubtData2 = (indoubtData)this.indoubtBrokers.get(e);
                try {
                    HAClusteredBroker hAClusteredBroker2 = (HAClusteredBroker)this.clusterconfig.getBroker(indoubtData2.brokerid);
                    BrokerState brokerState = hAClusteredBroker2.getState();
                    long l = hAClusteredBroker2.getHeartbeat();
                    if (brokerState == BrokerState.SHUTDOWN_COMPLETE) {
                        this.logger.log(8, "B1211", indoubtData2.brokerid);
                        hAClusteredBroker2.setBrokerIsUp(false, indoubtData2.brokerSession, null);
                        this.indoubtBrokers.remove(e);
                        object4.remove();
                        continue;
                    }
                    if (brokerState == BrokerState.FAILOVER_STARTED || brokerState == BrokerState.FAILOVER_COMPLETE) {
                        this.logger.log(8, "B1212", indoubtData2.brokerid);
                        hAClusteredBroker2.setBrokerIsUp(false, indoubtData2.brokerSession, null);
                        this.indoubtBrokers.remove(e);
                        object4.remove();
                        continue;
                    }
                    if (l > indoubtData2.lastts && brokerState != BrokerState.FAILOVER_PENDING) {
                        this.logger.log(8, "B1213", hAClusteredBroker2.getBrokerName());
                        hAClusteredBroker2.setBrokerInDoubt(false, indoubtData2.brokerSession);
                        this.indoubtBrokers.remove(e);
                        object4.remove();
                        continue;
                    }
                    ++indoubtData2.monitorCnt;
                    if (indoubtData2.monitorCnt >= this.MAX_MONITOR || brokerState == BrokerState.SHUTDOWN_FAILOVER) {
                        this.logger.log(8, "B1214", hAClusteredBroker2.getBrokerName());
                        if (this.takeoverRunnable != null) {
                            this.logger.log(8, "B1296", hAClusteredBroker2.getBrokerName());
                            continue;
                        }
                        if (object2 == null) {
                            object2 = new ArrayList();
                        }
                        downBroker downBroker2 = new downBroker();
                        downBroker2.cb = hAClusteredBroker2;
                        downBroker2.lastts = indoubtData2.lastts;
                        downBroker2.brokerSession = indoubtData2.brokerSession;
                        downBroker2.storeSession = hAClusteredBroker2.getStoreSessionUID();
                        ((ArrayList)object2).add(downBroker2);
                        hAClusteredBroker2.setBrokerIsUp(false, indoubtData2.brokerSession, null);
                        object4.remove();
                        this.indoubtBrokers.remove(e);
                        continue;
                    }
                    this.logger.log(8, "B1215", hAClusteredBroker2.getBrokerName());
                }
                catch (Exception exception) {
                    this.logger.logStack(8, "B3100", "Unable to monitor broker " + indoubtData2.brokerid, (Throwable)exception);
                }
            }
            if (object2 != null) break block32;
            Object var13_15 = null;
            object = this.takeoverRunnableLock;
        }
        catch (Throwable throwable) {
            Object var13_18 = null;
            Object object5 = this.takeoverRunnableLock;
            synchronized (object5) {
                this.monitorBusy = false;
                this.takeoverRunnableLock.notify();
            }
            throw throwable;
        }
        synchronized (object) {
            this.monitorBusy = false;
            this.takeoverRunnableLock.notify();
        }
        {
            block32: {
                return;
            }
            if (this.takeoverRunnable == null) break block33;
            this.logger.log(32, "B3100", Globals.getBrokerResources().getString("B1296", object2));
        }
        Object var13_16 = null;
        Object object6 = this.takeoverRunnableLock;
        synchronized (object6) {
            this.monitorBusy = false;
            this.takeoverRunnableLock.notify();
        }
        {
            block33: {
                return;
            }
            this.takeoverRunnable = new TakeoverThread((ArrayList)object2, false, false);
        }
        Object var13_17 = null;
        Object object7 = this.takeoverRunnableLock;
        synchronized (object7) {
            this.monitorBusy = false;
            this.takeoverRunnableLock.notify();
        }
        object4 = new Thread(this.takeoverRunnable, "Takeover");
        ((Thread)object4).start();
    }

    public void brokerDown(BrokerAddress brokerAddress) throws BrokerException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean inTakeover() {
        Object object = this.takeoverRunnableLock;
        synchronized (object) {
            return this.takeoverRunnable != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void takeoverBroker(HAClusteredBroker hAClusteredBroker, boolean bl) throws BrokerException {
        downBroker downBroker2 = new downBroker();
        downBroker2.cb = hAClusteredBroker;
        downBroker2.lastts = hAClusteredBroker.getHeartbeat();
        downBroker2.brokerSession = hAClusteredBroker.getBrokerSessionUID();
        downBroker2.storeSession = hAClusteredBroker.getStoreSessionUID();
        ArrayList<downBroker> arrayList = new ArrayList<downBroker>();
        arrayList.add(downBroker2);
        Object object = this.takeoverRunnableLock;
        synchronized (object) {
            while (this.monitorBusy || this.takeoverRunnable != null) {
                try {
                    this.takeoverRunnableLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.takeoverRunnable = new TakeoverThread(arrayList, bl, true);
        }
        try {
            ((TakeoverThread)this.takeoverRunnable).doTakeover();
        }
        catch (Exception exception) {
            if (exception instanceof BrokerException) {
                throw (BrokerException)exception;
            }
            throw new BrokerException(exception.getMessage(), exception, 500);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkTakingoverDestination(Destination destination) {
        if (this.takingoverTargets.size() == 0) {
            return false;
        }
        TakingoverTracker takingoverTracker2 = null;
        Iterator iterator = null;
        Vector vector = this.takingoverTargets;
        synchronized (vector) {
            for (TakingoverTracker takingoverTracker2 : this.takingoverTargets) {
                if (!takingoverTracker2.containDestination(destination)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkTakingoverMessage(Packet packet) {
        TakingoverTracker takingoverTracker2 = null;
        Iterator iterator = null;
        Vector vector = this.takingoverTargets;
        synchronized (vector) {
            for (TakingoverTracker takingoverTracker2 : this.takingoverTargets) {
                if (!takingoverTracker2.containMessage(packet)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void watchBroker(String string, UID uID) throws BrokerException {
        Map map = this.indoubtBrokers;
        synchronized (map) {
            if (this.indoubtBrokers.get(string) != null) {
                return;
            }
            indoubtData indoubtData2 = new indoubtData();
            indoubtData2.brokerid = string;
            indoubtData2.lastts = ((HAClusteredBroker)this.clusterconfig.getBroker(string)).getHeartbeat();
            indoubtData2.monitorCnt = 0;
            indoubtData2.brokerSession = uID;
            this.indoubtBrokers.put(string, indoubtData2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopWatchingBroker(String string) {
        Map map = this.indoubtBrokers;
        synchronized (map) {
            this.indoubtBrokers.remove(string);
        }
    }

    public void clusterPropertyChanged(String string, String string2) {
    }

    public void brokerAdded(ClusteredBroker clusteredBroker, UID uID) {
    }

    public void brokerRemoved(ClusteredBroker clusteredBroker, UID uID) {
    }

    public void masterBrokerChanged(ClusteredBroker clusteredBroker, ClusteredBroker clusteredBroker2) {
    }

    public void brokerStatusChanged(String string, int n, int n2, UID uID, Object object) {
        this.logger.log(4, "brokerStatusChanged " + string + ":" + "\n\t" + BrokerStatus.toString(n) + "\n\t" + BrokerStatus.toString(n2) + "\n\t" + object);
        if (BrokerStatus.getBrokerInDoubt(n2) && BrokerStatus.getBrokerIsUp(n2)) {
            ClusteredBroker clusteredBroker = this.clusterconfig.getBroker(string);
            if (clusteredBroker.isLocalBroker()) {
                return;
            }
            try {
                BrokerState brokerState = clusteredBroker.getState();
                if (brokerState == BrokerState.SHUTDOWN_COMPLETE || brokerState == BrokerState.FAILOVER_COMPLETE) {
                    this.logger.log(8, "B1213", clusteredBroker.getBrokerName());
                    clusteredBroker.setBrokerIsUp(false, uID, null);
                    return;
                }
                this.logger.log(8, "B1288", string);
                this.watchBroker(string, uID);
            }
            catch (Exception exception) {
                this.logger.logStack(8, "B3100", "Unable to monitor broker " + string, (Throwable)exception);
            }
        } else if (BrokerStatus.getBrokerInDoubt(n) && BrokerStatus.getBrokerIsUp(n2)) {
            this.stopWatchingBroker(string);
        }
    }

    public void brokerStateChanged(String string, BrokerState brokerState, BrokerState brokerState2) {
        ClusteredBroker clusteredBroker = this.clusterconfig.getBroker(string);
        if (clusteredBroker.isLocalBroker() && (brokerState2 == BrokerState.SHUTDOWN_COMPLETE || brokerState2 == BrokerState.SHUTDOWN_FAILOVER)) {
            this.haMonitor.cancel();
            this.clusterconfig.removeEventListener(this);
        }
    }

    public void brokerVersionChanged(String string, int n, int n2) {
    }

    public void brokerURLChanged(String string, MQAddress mQAddress, MQAddress mQAddress2) {
    }

    static {
        DEBUG = DEBUG_HA = Globals.getConfig().getBooleanProperty("imq.ha.debug");
    }

    class TakeoverThread
    implements Runnable {
        ArrayList downBkrs = null;
        boolean force = false;
        boolean throwex = false;

        public TakeoverThread(ArrayList arrayList, boolean bl, boolean bl2) {
            this.downBkrs = arrayList;
            this.force = bl;
            this.throwex = bl2;
        }

        public void run() {
            try {
                this.doTakeover();
            }
            catch (Exception exception) {
                Logger logger = HAMonitorService.this.logger;
                HAMonitorService.this.logger;
                logger.log(16, "Unexpected exception " + exception.getMessage());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void doTakeover() throws Exception {
            Object object;
            try {
                ClusterBroadcast clusterBroadcast = Globals.getClusterBroadcast();
                while (clusterBroadcast == null) {
                    HAMonitorService.this.logger.log(8, "B1264");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    clusterBroadcast = Globals.getClusterBroadcast();
                }
                Iterator iterator = this.downBkrs.iterator();
                while (iterator.hasNext()) {
                    Object var23_32;
                    downBroker downBroker2 = (downBroker)iterator.next();
                    HAClusteredBroker hAClusteredBroker = downBroker2.cb;
                    HAMonitorService.this.logger.log(8, "B1216", hAClusteredBroker.getBrokerName());
                    boolean bl = false;
                    TakingoverTracker takingoverTracker = new TakingoverTracker(hAClusteredBroker.getBrokerName(), Thread.currentThread());
                    takingoverTracker.setBrokerSessionUID(downBroker2.brokerSession);
                    takingoverTracker.setDownStoreSessionUID(downBroker2.storeSession);
                    takingoverTracker.setLastHeartbeat(downBroker2.lastts);
                    HAMonitorService.this.takingoverTargets.add(takingoverTracker);
                    try {
                        Object object2;
                        Object object3;
                        Object object4;
                        try {
                            Object[] objectArray;
                            Object object5;
                            TransactionState transactionState;
                            Externalizable externalizable;
                            clusterBroadcast.preTakeover(hAClusteredBroker.getBrokerName(), takingoverTracker.getDownStoreSessionUID(), ((BrokerMQAddress)hAClusteredBroker.getBrokerURL()).getHost().getHostAddress(), takingoverTracker.getBrokerSessionUID());
                            TakeoverStoreInfo takeoverStoreInfo = hAClusteredBroker.takeover(this.force, takingoverTracker);
                            takingoverTracker.setStage_BEFORE_PROCESSING();
                            bl = true;
                            HAMonitorService.this.logger.log(8, "B1217", takingoverTracker.getBrokerID());
                            object4 = takeoverStoreInfo.getMessageMap();
                            object3 = takeoverStoreInfo.getTransactionList();
                            object2 = takeoverStoreInfo.getRemoteTransactionList();
                            HAMonitorService.this.logger.log(8, "B1218", (Object)takingoverTracker.getBrokerID(), String.valueOf(object3 == null ? 0 : object3.size()));
                            HAMonitorService.this.logger.log(8, "B1297", (Object)takingoverTracker.getBrokerID(), String.valueOf(object2 == null ? 0 : object2.size()));
                            Destination.remoteCheckTakeoverMsgs((Map)object4, takingoverTracker.getBrokerID());
                            ArrayList<Externalizable> arrayList = new ArrayList<Externalizable>();
                            Iterator iterator2 = object3.iterator();
                            while (iterator2.hasNext()) {
                                boolean bl2 = false;
                                externalizable = (TransactionUID)iterator2.next();
                                transactionState = Globals.getStore().getTransactionState((TransactionUID)externalizable);
                                if (transactionState == null) {
                                    iterator2.remove();
                                    continue;
                                }
                                object5 = transactionState.getType();
                                int n = transactionState.getState();
                                if (n == 7) {
                                    HAMonitorService.this.logger.log(8, "XXX - DEBUG Rolling back  transaction " + externalizable);
                                    arrayList.add(externalizable);
                                    continue;
                                }
                                if (n == 6) {
                                    HAMonitorService.this.logger.log(8, "XXX - DEBUG Committing  transaction " + externalizable);
                                    arrayList.add(externalizable);
                                    continue;
                                }
                                if (object5 == AutoRollbackType.ALL) {
                                    Object[] objectArray2 = new String[3];
                                    objectArray2[0] = takingoverTracker.getBrokerID();
                                    objectArray2[1] = String.valueOf(((UID)((Object)externalizable)).longValue());
                                    objectArray2[2] = TransactionState.toString(transactionState.getState());
                                    objectArray = objectArray2;
                                    HAMonitorService.this.logger.log(8, "B1220", objectArray);
                                    transactionState.setState(7);
                                    try {
                                        Globals.getStore().updateTransactionState((TransactionUID)externalizable, transactionState, Destination.PERSIST_SYNC);
                                    }
                                    catch (IOException iOException) {
                                        throw new BrokerException(null, iOException);
                                    }
                                    arrayList.add(externalizable);
                                    continue;
                                }
                                if (transactionState.getType() == AutoRollbackType.NOT_PREPARED && transactionState.getState() < 5) {
                                    String[] stringArray = new String[3];
                                    stringArray[0] = takingoverTracker.getBrokerID();
                                    stringArray[1] = String.valueOf(((UID)((Object)externalizable)).longValue());
                                    stringArray[2] = TransactionState.toString(transactionState.getState());
                                    objectArray = stringArray;
                                    HAMonitorService.this.logger.log(8, "B1219", objectArray);
                                    transactionState.setState(7);
                                    try {
                                        Globals.getStore().updateTransactionState((TransactionUID)externalizable, transactionState, Destination.PERSIST_SYNC);
                                    }
                                    catch (IOException iOException) {
                                        throw new BrokerException(null, iOException);
                                    }
                                    arrayList.add(externalizable);
                                    continue;
                                }
                                String[] stringArray = new String[3];
                                stringArray[0] = takingoverTracker.getBrokerID();
                                stringArray[1] = String.valueOf(((UID)((Object)externalizable)).longValue());
                                stringArray[2] = TransactionState.toString(transactionState.getState());
                                objectArray = stringArray;
                                HAMonitorService.this.logger.log(8, "B1298", objectArray);
                            }
                            TransactionUID transactionUID = null;
                            externalizable = null;
                            transactionState = null;
                            object5 = Globals.getTransactionList();
                            iterator2 = object2.iterator();
                            while (iterator2.hasNext()) {
                                transactionUID = (TransactionUID)iterator2.next();
                                try {
                                    externalizable = Globals.getStore().getTransactionState(transactionUID);
                                }
                                catch (Exception exception) {
                                    Logger logger = HAMonitorService.this.logger;
                                    HAMonitorService.this.logger;
                                    logger.log(16, "Unable to get transaction state " + transactionUID + " for takenover broker " + takingoverTracker.getBrokerID());
                                    continue;
                                }
                                if (externalizable == null) continue;
                                try {
                                    if (((TransactionState)externalizable).getState() >= 5 || ((TransactionList)object5).retrieveState(transactionUID) == null || !((TransactionList)object5).isClusterTransactionBroker(transactionUID, takingoverTracker.getStoreSessionUID()) || (transactionState = ((TransactionList)object5).retrieveState(transactionUID)) == null) continue;
                                    transactionState = new TransactionState(transactionState);
                                    ((TransactionList)object5).updateState(transactionUID, transactionState.nextState(48, null), transactionState.getState(), true);
                                    Logger logger = HAMonitorService.this.logger;
                                    HAMonitorService.this.logger;
                                    logger.log(8, "Remote transaction " + transactionUID + "(" + TransactionState.toString(((TransactionState)externalizable).getState()) + ") from takenover broker " + takingoverTracker + " will be rolledback");
                                }
                                catch (Exception exception) {
                                    Logger logger = HAMonitorService.this.logger;
                                    HAMonitorService.this.logger;
                                    logger.log(16, "Unable to set ROLLBACK state to transaction " + transactionUID + ":" + exception.getMessage() + " for takenover broker " + takingoverTracker.getBrokerID());
                                }
                            }
                            TakeoverReaper takeoverReaper = new TakeoverReaper(takingoverTracker.getBrokerID(), arrayList);
                            objectArray = Globals.getTransactionList().loadTakeoverTxns((List)object3, (List)object2, (Map)object4);
                            HAMonitorService.this.logger.log(8, "B1221", (Object)takingoverTracker.getBrokerID(), String.valueOf(object4 == null ? 0 : object4.size()));
                            Destination.loadTakeoverMsgs((Map)object4, (List)object3, (Map)objectArray);
                            takingoverTracker.setStage_AFTER_PROCESSING();
                            HAMonitorService.this.takingoverTargets.remove(takingoverTracker);
                            Globals.getTransactionList().unlockTakeoverTxns((List)object3);
                            boolean bl3 = takeoverReaper.processTxns();
                            MQTimer mQTimer = Globals.getTimer();
                            try {
                                if (!bl3) {
                                    mQTimer.schedule((TimerTask)takeoverReaper, HAMonitorService.this.reaperTimeout, (long)HAMonitorService.this.reaperTimeout);
                                }
                            }
                            catch (IllegalStateException illegalStateException) {
                                HAMonitorService.this.logger.logStack(16, "B3100", "Unable to start takeover-transaction reaper", (Throwable)illegalStateException);
                            }
                            Logger logger = HAMonitorService.this.logger;
                            HAMonitorService.this.logger;
                            logger.log(8, "B1338", takingoverTracker.toString());
                            hAClusteredBroker.setBrokerIsUp(false, takingoverTracker.getBrokerSessionUID(), takingoverTracker.getStoreSessionUID());
                            hAClusteredBroker.setStateFailoverProcessed(takingoverTracker.getStoreSessionUID());
                            Logger logger2 = HAMonitorService.this.logger;
                            HAMonitorService.this.logger;
                            logger2.log(8, "B1223", takingoverTracker.toString());
                            iterator.remove();
                        }
                        catch (Exception exception) {
                            if (exception instanceof TakeoverLockException) {
                                object4 = null;
                                object3 = null;
                                object2 = ((TakeoverLockException)exception).getBrokerInfo();
                                if (object2 == null) {
                                    try {
                                        object4 = hAClusteredBroker.getState();
                                        object3 = hAClusteredBroker.getTakeoverBroker();
                                    }
                                    catch (BrokerException brokerException) {}
                                } else {
                                    object4 = BrokerState.getState(((HABrokerInfo)object2).getState());
                                    object3 = ((HABrokerInfo)object2).getTakeoverBrokerID();
                                }
                                if (object4 == BrokerState.FAILOVER_STARTED || object4 == BrokerState.FAILOVER_PENDING || object4 == BrokerState.FAILOVER_COMPLETE) {
                                    if (object3 != null) {
                                        HAMonitorService.this.logger.log(8, "B3231", (Object)hAClusteredBroker.getBrokerName(), "Broker is being taken over by " + (String)object3);
                                    } else {
                                        HAMonitorService.this.logger.log(32, "B1191");
                                    }
                                } else {
                                    HAMonitorService.this.logger.log(32, "B3231", hAClusteredBroker.getBrokerName(), "Takeover lock error (state=" + object4 + ", takeoverBroker=" + (String)object3 + ")", exception);
                                }
                                try {
                                    hAClusteredBroker.setStateFailoverFailed(downBroker2.brokerSession);
                                }
                                catch (Exception exception2) {
                                    HAMonitorService.this.logger.logStack(32, "B3044", exception2);
                                }
                            } else if (exception instanceof BrokerException && ((BrokerException)exception).getStatusCode() == 409) {
                                HAMonitorService.this.logger.log(8, exception.getMessage());
                            } else if (takingoverTracker != null && takingoverTracker.getStage() >= 4) {
                                HAMonitorService.this.logger.logStack(32, Globals.getBrokerResources().getKString("B3244", takingoverTracker.toString()), exception);
                            } else {
                                HAMonitorService.this.logger.logStack(32, "B3231", hAClusteredBroker.getBrokerName(), exception.getMessage(), exception);
                            }
                            hAClusteredBroker.setBrokerIsUp(false, downBroker2.brokerSession, null);
                            if (this.throwex) {
                                throw exception;
                            }
                            var23_32 = null;
                            clusterBroadcast.postTakeover(takingoverTracker.getBrokerID(), takingoverTracker.getStoreSessionUID(), !bl);
                            if (takingoverTracker.getStage() >= 4) continue;
                            HAMonitorService.this.takingoverTargets.remove(takingoverTracker);
                            continue;
                        }
                        var23_32 = null;
                        clusterBroadcast.postTakeover(takingoverTracker.getBrokerID(), takingoverTracker.getStoreSessionUID(), !bl);
                        if (takingoverTracker.getStage() >= 4) continue;
                        HAMonitorService.this.takingoverTargets.remove(takingoverTracker);
                    }
                    catch (Throwable throwable) {
                        var23_32 = null;
                        clusterBroadcast.postTakeover(takingoverTracker.getBrokerID(), takingoverTracker.getStoreSessionUID(), !bl);
                        if (takingoverTracker.getStage() >= 4) throw throwable;
                        HAMonitorService.this.takingoverTargets.remove(takingoverTracker);
                        throw throwable;
                    }
                }
                Object var25_34 = null;
                object = HAMonitorService.this.takeoverRunnableLock;
            }
            catch (Throwable throwable) {
                Object var25_35 = null;
                Object object6 = HAMonitorService.this.takeoverRunnableLock;
                synchronized (object6) {
                    HAMonitorService.this.takeoverRunnable = null;
                    HAMonitorService.this.takeoverRunnableLock.notify();
                    throw throwable;
                }
            }
            synchronized (object) {
                HAMonitorService.this.takeoverRunnable = null;
                HAMonitorService.this.takeoverRunnableLock.notify();
                return;
            }
        }
    }

    class TakeoverReaper
    extends TimerTask {
        List txns = null;
        String id = null;
        long time = 0L;

        public TakeoverReaper(String string, List list) {
            this.txns = list;
            this.id = string;
            Logger logger = HAMonitorService.this.logger;
            HAMonitorService.this.logger;
            logger.log(4, "monitoring " + list.size() + " transactions");
        }

        public void run() {
            boolean bl = this.processTxns();
            if (bl) {
                this.cancel();
            }
        }

        public boolean processTxns() {
            try {
                Iterator iterator = this.txns.iterator();
                while (iterator.hasNext()) {
                    Object object;
                    TransactionState transactionState;
                    TransactionUID transactionUID;
                    block9: {
                        transactionUID = (TransactionUID)iterator.next();
                        transactionState = null;
                        try {
                            transactionState = Globals.getStore().getTransactionState(transactionUID);
                            if (transactionState != null && transactionState.getState() == 6) {
                                Globals.getTransactionList().reapTakeoverCommittedTransaction(transactionUID);
                                iterator.remove();
                            }
                            break block9;
                        }
                        catch (BrokerException brokerException) {
                            Globals.getTransactionList().removeTransactionAck(transactionUID);
                            Globals.getTransactionList().removeTransactionID(transactionUID);
                            iterator.remove();
                        }
                        continue;
                    }
                    int n = transactionState.getState();
                    int n2 = 0;
                    int n3 = 0;
                    try {
                        object = Globals.getStore().getTransactionUsageInfo(transactionUID);
                        n2 = object[0];
                        n3 = object[1];
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (n != 7 && n != 5 && n != 6 || n2 == 0 && n3 == 0) {
                        HAMonitorService.this.logger.log(DEBUG ? 8 : 4, "Removing finished transaction " + transactionUID);
                        object = (TransactionHandler)Globals.getPacketRouter(0).getHandler(48);
                        ((TransactionHandler)object).doRollback(transactionUID, null, null, transactionState, null, null, RollbackReason.TAKEOVER_CLEANUP);
                        iterator.remove();
                        continue;
                    }
                    if (n != 7) continue;
                }
            }
            catch (Exception exception) {
                HAMonitorService.this.logger.logStack(16, "B3100", "removing reaped destinations", (Throwable)exception);
            }
            return this.txns.size() == 0;
        }
    }

    class HATimerThread
    implements Runnable {
        long nexttime = 0L;
        long repeatItr = 0L;
        Thread thr = null;
        Runnable child = null;

        public HATimerThread(String string, Runnable runnable, int n, int n2) {
            this.nexttime = (long)n + System.currentTimeMillis();
            this.repeatItr = n2;
            this.child = runnable;
            this.thr = new Thread((Runnable)this, string);
            this.thr.setPriority(10);
            this.thr.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                long l = System.currentTimeMillis();
                HATimerThread hATimerThread = this;
                synchronized (hATimerThread) {
                    if (l < this.nexttime) {
                        try {
                            this.wait(this.nexttime - l);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        continue;
                    }
                    this.child.run();
                }
                if (this.repeatItr == 0L) break;
                this.nexttime += this.repeatItr;
            }
        }
    }

    class HAMonitorTask
    implements Runnable {
        boolean valid = true;

        public void cancel() {
            this.valid = false;
        }

        public void run() {
            if (!this.valid) {
                return;
            }
            HAMonitorService.this.monitor();
        }
    }

    class downBroker {
        HAClusteredBroker cb = null;
        long lastts = 0L;
        UID brokerSession = null;
        UID storeSession = null;

        downBroker() {
        }
    }

    class indoubtData {
        String brokerid;
        long lastts = 0L;
        int monitorCnt = 0;
        UID brokerSession = null;

        indoubtData() {
        }
    }
}

