/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.objmgr;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.ConnectionFactory;
import com.sun.messaging.Queue;
import com.sun.messaging.QueueConnectionFactory;
import com.sun.messaging.Topic;
import com.sun.messaging.TopicConnectionFactory;
import com.sun.messaging.XAConnectionFactory;
import com.sun.messaging.XAQueueConnectionFactory;
import com.sun.messaging.XATopicConnectionFactory;
import com.sun.messaging.jmq.admin.resources.AdminResources;
import com.sun.messaging.jmq.admin.util.Globals;
import com.sun.messaging.jmq.util.MultiColumnPrinter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class ObjMgrPrinter
extends MultiColumnPrinter {
    private static AdminResources ar = Globals.getAdminResources();

    public ObjMgrPrinter(int n, int n2, String string, int n3, boolean bl) {
        super(n, n2, string, n3, bl);
    }

    public ObjMgrPrinter(int n, int n2, String string, int n3) {
        super(n, n2, string, n3);
    }

    public ObjMgrPrinter(int n, int n2, String string) {
        super(n, n2, string);
    }

    public ObjMgrPrinter(int n, int n2) {
        super(n, n2);
    }

    public ObjMgrPrinter(Hashtable hashtable, int n, int n2) {
        super(n, n2);
        Object[] objectArray = new String[2];
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)hashtable.get(string);
            objectArray[0] = string;
            objectArray[1] = string2;
            this.add(objectArray);
        }
    }

    public void printJMSObject(Object object) {
        if (object instanceof Topic) {
            Globals.stdOutPrintln(ar.getString("A1046"));
        } else if (object instanceof Queue) {
            Globals.stdOutPrintln(ar.getString("A1047"));
        } else if (object instanceof XATopicConnectionFactory) {
            Globals.stdOutPrintln(ar.getString("A1078"));
        } else if (object instanceof XAQueueConnectionFactory) {
            Globals.stdOutPrintln(ar.getString("A1079"));
        } else if (object instanceof XAConnectionFactory) {
            Globals.stdOutPrintln(ar.getString("A1080"));
        } else if (object instanceof TopicConnectionFactory) {
            Globals.stdOutPrintln(ar.getString("A1048"));
        } else if (object instanceof QueueConnectionFactory) {
            Globals.stdOutPrintln(ar.getString("A1049"));
        } else if (object instanceof ConnectionFactory) {
            Globals.stdOutPrintln(ar.getString("A1081"));
        }
        if (object instanceof AdministeredObject) {
            this.printObjPropertiesFromObj((AdministeredObject)object);
        }
    }

    public void printObjPropertiesFromObj(AdministeredObject administeredObject) {
        Properties properties = administeredObject.getConfiguration();
        Enumeration enumeration = administeredObject.enumeratePropertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            try {
                if (administeredObject.isPropertyHidden(string)) {
                    continue;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            String string2 = properties.getProperty(string);
            String string3 = "";
            try {
                string3 = administeredObject.getPropertyLabel(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String string4 = string + " [" + string3 + "]";
            String string5 = string2;
            Object[] objectArray = new String[]{string4, string5};
            this.add(objectArray);
        }
        this.print();
    }

    public void printObjPropertiesFromProp(Properties properties, AdministeredObject administeredObject) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2 = (String)enumeration.nextElement();
            String string3 = properties.getProperty(string2);
            try {
                string = administeredObject.getPropertyLabel(string2);
            }
            catch (Exception exception) {
                string = "";
            }
            String string4 = string2 + " [" + string + "]";
            Object[] objectArray = new String[]{string4, string3};
            this.add(objectArray);
        }
        this.print();
    }

    public static void printReadOnly(String string) {
        if (string != null) {
            Globals.stdOutPrintln(ar.getString("A1113", string));
        } else {
            Globals.stdOutPrintln(ar.getString("A1113", Boolean.FALSE.toString()));
        }
    }

    public static void printReadOnly(boolean bl) {
        if (bl) {
            Globals.stdOutPrintln(ar.getString("A1113", Boolean.TRUE.toString()));
        } else {
            Globals.stdOutPrintln(ar.getString("A1113", Boolean.FALSE.toString()));
        }
    }

    public void doPrint(String string) {
        Globals.stdOutPrint(string);
    }

    public void doPrintln(String string) {
        Globals.stdOutPrintln(string);
    }
}

