/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient.protocol;

import com.sun.messaging.jmq.io.ReadWritePacket;
import com.sun.messaging.jmq.jmsclient.ConnectionHandler;
import com.sun.messaging.jmq.jmsclient.Debug;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

public abstract class SocketConnectionHandler
implements ConnectionHandler {
    private static String defaultBufferSize = "2048";
    private boolean debug = Debug.debug;
    private InputStream is = null;
    private OutputStream os = null;

    protected abstract void closeSocket() throws IOException;

    public boolean isDirectMode() {
        return false;
    }

    public ReadWritePacket readPacket() throws IOException {
        ReadWritePacket readWritePacket = new ReadWritePacket();
        readWritePacket.readPacket(this.is);
        return readWritePacket;
    }

    public void writePacket(ReadWritePacket readWritePacket) throws IOException {
        readWritePacket.writePacket(this.os);
    }

    public void configure(Properties properties) throws IOException {
        int n;
        String string;
        String string2 = this.getProperty(properties, "imqOutputBuffer", "true");
        if (string2.equals("true")) {
            string = this.getProperty(properties, "imqOutputBufferSize", defaultBufferSize);
            n = Integer.parseInt(string);
            this.os = new BufferedOutputStream(this.getOutputStream(), n);
            if (this.debug) {
                Debug.println("buffered output stream, buffer size: " + n);
            }
        } else {
            this.os = this.getOutputStream();
        }
        string2 = this.getProperty(properties, "imqInputBuffer", "true");
        if (string2.equals("true")) {
            string = this.getProperty(properties, "imqInputBufferSize", "2048");
            n = Integer.parseInt(string);
            this.is = new BufferedInputStream(this.getInputStream(), n);
            if (this.debug) {
                Debug.println("buffered input stream, buffer size: " + n);
            }
        } else {
            this.is = this.getInputStream();
        }
    }

    private String getProperty(Properties properties, String string, String string2) {
        String string3 = (String)properties.get(string);
        if (string3 == null) {
            string3 = System.getProperty(string);
        }
        return string3 == null ? string2 : string3;
    }

    public void close() throws IOException {
        this.getInputStream().close();
        this.is.close();
        this.os.close();
        this.closeSocket();
    }
}

