/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.FaultInjection;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.Producer;
import com.sun.messaging.jmq.jmsserver.core.ProducerUID;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQBasicConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.selector.SelectorFormatException;
import java.io.IOException;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class DataHandler
extends PacketHandler {
    TransactionList translist = null;
    private static boolean DEBUG = false;
    private int msgProcessCnt = 0;
    private FaultInjection fi = null;

    public DataHandler(TransactionList transactionList) {
        this.translist = transactionList;
        this.fi = FaultInjection.getInjection();
    }

    public boolean handle(IMQConnection iMQConnection, Packet packet) throws BrokerException {
        boolean bl = false;
        return this.handle(iMQConnection, packet, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean handle(IMQConnection var1_1, Packet var2_2, boolean var3_3) throws BrokerException {
        block44: {
            if (DataHandler.DEBUG) {
                this.logger.log(1, "DataHandler: handle() [ Received JMS  Message] {0} ", var2_2.toString());
            }
            var4_4 = null;
            if (!var3_3 && this.fi.FAULT_INJECTION) {
                ++this.msgProcessCnt;
                try {
                    var4_4 = var2_2.getProperties();
                }
                catch (Exception var5_5) {
                    var4_4 = new Properties();
                }
            } else {
                this.msgProcessCnt = 0;
            }
            var5_6 = var2_2.getSendAcknowledge();
            var6_7 = var2_2.getConsumerID();
            (IMQBasicConnection)var1_1;
            if (IMQBasicConnection.getDumpPacket()) ** GOTO lbl-1000
            (IMQBasicConnection)var1_1;
            if (IMQBasicConnection.getDumpOutPacket()) lbl-1000:
            // 2 sources

            {
                v0 = var2_2.getSysMessageID().toString();
            } else {
                v0 = "";
            }
            var8_8 = v0;
            var9_9 = var2_2.getIndempotent();
            var10_10 = null;
            var11_11 = null;
            var12_12 = 200;
            var13_13 = false;
            var14_14 = null;
            var15_15 = false;
            var16_16 = null;
            var17_17 = false;
            try {
                var16_16 = this.checkFlow(var2_2, var1_1);
                v1 = var17_17 = var2_2.getTransactionID() != 0L;
                if (!var3_3 && this.fi.FAULT_INJECTION) {
                    var18_18 = new HashMap<K, V>();
                    if (var4_4 != null) {
                        var18_18.putAll(var4_4);
                    }
                    var18_18.put("mqMsgCount", new Integer(this.msgProcessCnt));
                    var18_18.put("mqIsTransacted", var17_17);
                    this.fi.checkFaultAndExit("msg.send.1", (Map)var18_18, 2, false);
                }
                var18_18 = DestinationUID.getUID(var2_2.getDestination(), var2_2.getIsQueue());
                var19_24 = Destination.findMatchingIDs((DestinationUID)var18_18);
                var20_30 = false;
                if (var19_24.size() == 0) {
                    var15_15 = false;
                    break block44;
                }
                var21_33 = var19_24.iterator();
                while (var21_33.hasNext()) {
                    block47: {
                        block46: {
                            block45: {
                                var22_34 = null;
                                var23_35 = null;
                                var24_36 = false;
                                var25_37 = (DestinationUID)var21_33.next();
                                var24_36 = var21_33.hasNext() == false;
                                var26_38 = Destination.getDestination(var25_37);
                                try {
                                    try {
                                        if (var26_38 == null) {
                                            throw new BrokerException("Unknown Destination:" + var2_2.getDestination());
                                        }
                                        if (var18_18.isWildcard() && var26_38.isTemporary()) {
                                            this.logger.log(4, "L10N-XXX: Wildcard production with destination name of " + var18_18 + " to temporary destination " + var26_38.getUniqueName() + " is not supported, ignoring");
                                            var29_41 = null;
                                            if (var16_16 != null) {
                                                this.pauseProducer(var26_38, var25_37, var16_16, var1_1);
                                                var16_16 = null;
                                            }
                                            if (!var24_36 || var23_35 == null) continue;
                                            throw var23_35;
                                        }
                                        if (var18_18.isWildcard() && var26_38.isInternal()) {
                                            this.logger.log(4, "L10N-XXX: Wildcard production with destination name of " + var18_18 + " to internal destination " + var26_38.getUniqueName() + " is not supported, ignoring");
                                            break block45;
                                        }
                                        if (var18_18.isWildcard() && var26_38.isDMQ()) {
                                            this.logger.log(4, "L10N-XXX: Wildcard production with destination name of " + var18_18 + " to the DeadMessageQueue" + var26_38.getUniqueName() + " is not supported, ignoring");
                                            break block46;
                                        }
                                        if (var16_16 != null) {
                                            this.pauseProducer(var26_38, var25_37, var16_16, var1_1);
                                            var16_16 = null;
                                        }
                                        if (var20_30) {
                                            var27_39 = new Packet();
                                            var27_39.fill(var2_2);
                                            var27_39.generateSequenceNumber(true);
                                            var27_39.generateTimestamp(true);
                                            var27_39.prepareToSend();
                                            var27_39.generateSequenceNumber(false);
                                            var27_39.generateTimestamp(false);
                                            var2_2 = var27_39;
                                        }
                                        var20_30 = true;
                                        var22_34 = this.createReference(var2_2, var25_37, var1_1, var3_3);
                                        if (var24_36 && (var15_15 |= this.queueMessage(var26_38, (PacketReference)var22_34, var17_17)) && var5_6 && !var22_34.isPersistent()) {
                                            this.sendAcknowledge(var8_8, var6_7, var12_12, var1_1, var10_10, var4_4, var17_17);
                                            var5_6 = false;
                                        }
                                        if ((var27_39 = this.routeMessage(var17_17, (PacketReference)var22_34, var15_15, var26_38)) != null && !var27_39.isEmpty()) {
                                            if (var14_14 == null) {
                                                var14_14 = new HashMap<Object, Object>();
                                            }
                                            var14_14.put(var22_34, var27_39);
                                        }
                                        this.pauseProducer(var26_38, var25_37, var16_16, var1_1);
                                        break block47;
                                    }
                                    catch (Exception var27_40) {
                                        if (var22_34 != null) {
                                            if (var11_11 == null) {
                                                var11_11 = new ArrayList<Set>();
                                            }
                                            var11_11.add((Set)var22_34);
                                        }
                                        var23_35 = var27_40;
                                        this.logger.log(4, "B2011", (Object)var1_1.toString(), (Throwable)var27_40);
                                        var29_41 = null;
                                        if (var16_16 != null) {
                                            this.pauseProducer(var26_38, var25_37, var16_16, var1_1);
                                            var16_16 = null;
                                        }
                                        if (!var24_36 || var23_35 == null) continue;
                                        throw var23_35;
                                    }
                                }
                                catch (Throwable var28_42) {
                                    var29_41 = null;
                                    if (var16_16 != null) {
                                        this.pauseProducer(var26_38, var25_37, var16_16, var1_1);
                                        var16_16 = null;
                                    }
                                    if (!var24_36 || var23_35 == null) throw var28_42;
                                    throw var23_35;
                                }
                            }
                            var29_41 = null;
                            if (var16_16 != null) {
                                this.pauseProducer(var26_38, var25_37, var16_16, var1_1);
                                var16_16 = null;
                            }
                            if (!var24_36 || var23_35 == null) continue;
                            throw var23_35;
                        }
                        var29_41 = null;
                        if (var16_16 != null) {
                            this.pauseProducer(var26_38, var25_37, var16_16, var1_1);
                            var16_16 = null;
                        }
                        if (!var24_36 || var23_35 == null) continue;
                        throw var23_35;
                    }
                    var29_41 = null;
                    if (var16_16 != null) {
                        this.pauseProducer(var26_38, var25_37, var16_16, var1_1);
                        var16_16 = null;
                    }
                    if (!var24_36 || var23_35 == null) continue;
                    throw var23_35;
                }
            }
            catch (BrokerException var18_19) {
                var19_25 = var9_9 != false && var18_19.getStatusCode() == 304 ? 4 : 16;
                this.logger.log(var19_25, "B2011", (Object)var1_1.toString(), (Throwable)var18_19);
                var10_10 = var18_19.getMessage();
                var12_12 = var18_19.getStatusCode();
            }
            catch (IOException var18_20) {
                this.logger.log(16, "B2011", (Object)var1_1.toString(), (Throwable)var18_20);
                var10_10 = var18_20.getMessage();
                var12_12 = 500;
            }
            catch (SecurityException var18_21) {
                this.logger.log(16, "B2011", (Object)var1_1.toString(), (Throwable)var18_21);
                var10_10 = var18_21.getMessage();
                var12_12 = 403;
            }
            catch (OutOfMemoryError var18_22) {
                this.logger.logStack(16, "B2011", var1_1.toString() + ":" + var2_2.getPacketSize(), (Throwable)var18_22);
                var10_10 = var18_22.getMessage();
                var12_12 = 500;
            }
            catch (Exception var18_23) {
                this.logger.logStack(16, "B2011", var1_1.toString(), (Throwable)var18_23);
                var10_10 = var18_23.getMessage();
                var12_12 = 500;
            }
        }
        if (var12_12 == 500 && var11_11 != null) {
            for (PacketReference var19_27 : var11_11) {
                var20_31 = Destination.getDestination(var19_27.getDestinationUID());
                if (var20_31 == null) continue;
                this.cleanupOnError(var20_31, var19_27);
            }
        }
        if (var5_6) {
            this.sendAcknowledge(var8_8, var6_7, var12_12, var1_1, var10_10, var4_4, var17_17);
        }
        if (!var15_15 || var14_14 == null) return var3_3;
        for (PacketReference var19_29 : var14_14.keySet()) {
            var20_32 = var19_29.getDestinationUID();
            var21_33 = Destination.getDestination(var20_32);
            var22_34 = (Set)var14_14.get(var19_29);
            this.forwardMessage((Destination)var21_33, var19_29, (Set)var22_34);
        }
        return var3_3;
    }

    public void sendAcknowledge(String string, long l, int n, IMQConnection iMQConnection, String string2, Hashtable hashtable, boolean bl) {
        Hashtable<String, Object> hashtable2;
        Object object;
        block9: {
            block8: {
                if (!iMQConnection.isAdminConnection() && this.fi.FAULT_INJECTION) {
                    object = new HashMap();
                    if (hashtable != null) {
                        object.putAll(hashtable);
                    }
                    object.put("mqMsgCount", new Integer(this.msgProcessCnt));
                    object.put("mqIsTransacted", bl);
                    this.fi.checkFaultAndExit("msg.send.2", (Map)object, 2, false);
                }
                object = new Packet(iMQConnection.useDirectBuffers());
                ((Packet)object).setPacketType(9);
                ((Packet)object).setConsumerID(l);
                hashtable2 = new Hashtable<String, Object>();
                hashtable2.put("JMQStatus", new Integer(n));
                if (string2 != null) {
                    hashtable2.put("JMQReason", string2);
                }
                IMQBasicConnection cfr_ignored_0 = (IMQBasicConnection)iMQConnection;
                if (IMQBasicConnection.getDumpPacket()) break block8;
                IMQBasicConnection cfr_ignored_1 = (IMQBasicConnection)iMQConnection;
                if (!IMQBasicConnection.getDumpOutPacket()) break block9;
            }
            hashtable2.put("JMQReqID", string);
        }
        ((Packet)object).setProperties(hashtable2);
        iMQConnection.sendControlMessage((Packet)object);
        if (!iMQConnection.isAdminConnection() && this.fi.FAULT_INJECTION) {
            HashMap<String, Constable> hashMap = new HashMap<String, Constable>();
            if (hashtable != null) {
                hashMap.putAll(hashtable);
            }
            hashMap.put("mqMsgCount", new Integer(this.msgProcessCnt));
            hashMap.put("mqIsTransacted", Boolean.valueOf(bl));
            this.fi.checkFaultAndExit("msg.send.3", hashMap, 2, false);
        }
    }

    public Producer checkFlow(Packet packet, IMQConnection iMQConnection) {
        long l;
        ProducerUID producerUID;
        Producer producer;
        Producer producer2 = null;
        if (packet.getFlowPaused()) {
            iMQConnection.flowPaused(0L);
            packet.setFlowPaused(false);
        }
        if ((producer = Producer.getProducer(producerUID = new ProducerUID(l = packet.getProducerID()))) != null) {
            producer.addMsg();
        }
        if (packet.getConsumerFlow()) {
            producer2 = producer;
            if (producer2 == null) {
                this.logger.log(8, "Internal Error: Unknown ProducerUID " + producerUID);
            } else if (producer2.getConnectionUID() != iMQConnection.getConnectionUID()) {
                this.logger.log(8, "Internal Error: Producer " + producer2 + " not on this connection " + iMQConnection.getConnectionUID());
            }
            packet.setConsumerFlow(false);
        }
        return producer2;
    }

    public PacketReference createReference(Packet packet, DestinationUID destinationUID, IMQConnection iMQConnection, boolean bl) throws BrokerException {
        PacketReference packetReference = PacketReference.createReference(packet, destinationUID, iMQConnection);
        if (bl) {
            packetReference.overridePersistence(false);
        }
        return packetReference;
    }

    public boolean queueMessage(Destination destination, PacketReference packetReference, boolean bl) throws BrokerException {
        return destination.queueMessage(packetReference, bl);
    }

    public Set routeMessage(boolean bl, PacketReference packetReference, boolean bl2, Destination destination) throws BrokerException, SelectorFormatException {
        String string = null;
        int n = 200;
        Set set = null;
        if (bl) {
            try {
                packetReference.store();
                this.translist.addMessage(packetReference.getTransactionID(), packetReference.getSysMessageID());
            }
            catch (Exception exception) {
                packetReference.destroy();
                this.logger.logStack(BrokerStateHandler.shuttingDown ? 4 : 16, "B3100", "transaction failed", (Throwable)exception);
                string = "transaction failed: " + exception.getMessage();
                n = 500;
                throw new BrokerException(string, n);
            }
        } else if (bl2) {
            set = destination.routeNewMessage(packetReference);
        }
        return set;
    }

    public void cleanupOnError(Destination destination, PacketReference packetReference) {
        try {
            destination.removeMessage(packetReference.getSysMessageID(), null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void forwardMessage(Destination destination, PacketReference packetReference, Set set) throws BrokerException {
        destination.forwardMessage(set, packetReference);
    }

    public void pauseProducer(Destination destination, Producer producer, IMQConnection iMQConnection) {
        this.pauseProducer(destination, destination.getDestinationUID(), producer, iMQConnection);
    }

    public void pauseProducer(Destination destination, DestinationUID destinationUID, Producer producer, IMQConnection iMQConnection) {
        if (producer != null) {
            if (destination != null) {
                destination.producerFlow(iMQConnection, producer);
            } else if (destinationUID != null) {
                producer.sendResumeFlow(destinationUID);
            }
        }
    }
}

