/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.Destination;
import com.sun.messaging.jmq.Version;
import com.sun.messaging.jmq.auth.api.client.AuthenticationProtocolHandler;
import com.sun.messaging.jmq.auth.handlers.BasicAuthenticationHandler;
import com.sun.messaging.jmq.auth.handlers.DigestAuthenticationHandler;
import com.sun.messaging.jmq.io.PacketType;
import com.sun.messaging.jmq.io.ReadOnlyPacket;
import com.sun.messaging.jmq.io.ReadWritePacket;
import com.sun.messaging.jmq.io.Status;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsclient.AckQueue;
import com.sun.messaging.jmq.jmsclient.BytesMessageImpl;
import com.sun.messaging.jmq.jmsclient.ConnectionConsumerImpl;
import com.sun.messaging.jmq.jmsclient.ConnectionHandler;
import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.Consumer;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.ExceptionHandler;
import com.sun.messaging.jmq.jmsclient.MapMessageImpl;
import com.sun.messaging.jmq.jmsclient.MessageConsumerImpl;
import com.sun.messaging.jmq.jmsclient.MessageImpl;
import com.sun.messaging.jmq.jmsclient.MessageProducerImpl;
import com.sun.messaging.jmq.jmsclient.ObjectMessageImpl;
import com.sun.messaging.jmq.jmsclient.PacketDispatcher;
import com.sun.messaging.jmq.jmsclient.ReadChannel;
import com.sun.messaging.jmq.jmsclient.RemoteAcknowledgeException;
import com.sun.messaging.jmq.jmsclient.SessionImpl;
import com.sun.messaging.jmq.jmsclient.StreamMessageImpl;
import com.sun.messaging.jmq.jmsclient.TemporaryDestination;
import com.sun.messaging.jmq.jmsclient.TextMessageImpl;
import com.sun.messaging.jmq.jmsclient.auth.JMQAdminKeyAuthenticationHandler;
import com.sun.messaging.jmq.jmsclient.auth.UnsupportedAuthTypeException;
import com.sun.messaging.jmq.jmsclient.protocol.direct.DirectConnectionHandler;
import com.sun.messaging.jmq.jmsclient.runtime.impl.BrokerInstanceImpl;
import com.sun.messaging.jmq.jmsclient.validation.ValidatorFactory;
import com.sun.messaging.jmq.jmsclient.validation.XMLValidator;
import com.sun.messaging.jmq.net.IPAddress;
import com.sun.messaging.jmq.util.JMQXid;
import com.sun.messaging.jms.InvalidClientIDException;
import com.sun.messaging.jms.InvalidDestinationException;
import com.sun.messaging.jms.InvalidSelectorException;
import com.sun.messaging.jms.JMSSecurityException;
import com.sun.messaging.jms.ResourceAllocationException;
import com.sun.messaging.jms.TransactionRolledBackException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.lang.constant.Constable;
import java.net.InetAddress;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import javax.security.auth.login.LoginException;

public class ProtocolHandler {
    private volatile boolean sentSetClientID = false;
    private volatile boolean hasConnectionConsumer = false;
    private static final Version version = ConnectionImpl.version;
    public static final String REQUEST_META_DATA = "requestMetaData";
    public static final int ACK_MESSAGE_BODY_SIZE = 36;
    private static final int DIRECT_ACK_TIMEOUT = 60000;
    protected int timeout = 0;
    public static final int SERVER_OK = 200;
    public static final long MIN_ACK_ID = 0L;
    private long nextAckID = 0L;
    private byte[] ipAddress = null;
    private byte[] macAddress = null;
    private int localPort = 0;
    private ConnectionImpl connection = null;
    protected Hashtable requestMetaData = null;
    private ConnectionHandler connectionHandler = null;
    private boolean ackEnabled = true;
    private boolean ackEnabledFlag = false;
    private boolean produceAck = false;
    private boolean debug = Debug.debug;
    private boolean isClosed = false;
    protected int stoppedCount = 0;
    private Object incObj = new Object();
    private boolean ackAck = true;
    protected boolean authenticated = false;
    protected Thread recoverThread = null;
    private boolean setJMSXAppID = false;
    private boolean setJMSXUserID = false;
    private boolean setJMSXRcvTimestamp = false;
    private String jmsxAppID = null;
    private String jmsxUserID = null;
    private static final String AUTHTYPE_JMQADMINKEY = "jmqadminkey";
    private static final String AUTHTYPE_JMQBASIC = "basic";
    private static final String AUTHTYPE_JMQDIGEST = "digest";
    private boolean timeToPing = false;
    private long nonRespPingTimeStamp = 0L;
    private Object nonResponsiveSyncObj = new Object();
    private Object nextAckIDSyncObj = new Object();
    private boolean isPingTimeStampSet = false;
    private boolean imqAbortOnTimeout = false;
    private boolean enableZip = Boolean.getBoolean("imq.zip.enable");
    public static final String INBOUND_PACKET_LOGGING_NAME = "com.sun.messaging.jms.pkt.in";
    public static final String OUTBOUND_PACKET_LOGGING_NAME = "com.sun.messaging.jms.pkt.out";
    private boolean debugInboundPkt = false;
    private boolean debugOutboundPkt = false;
    private String pktFilter = null;
    private static Logger inpktLogger = null;
    private static Logger outpktLogger = null;
    private Logger connLogger = ConnectionImpl.connectionLogger;
    protected boolean twoPhaseCommitFlag = false;
    private static boolean turnOffXMLValidation = Boolean.getBoolean("imq.xml.validation.disabled");
    private Hashtable xmlValidationTable = new Hashtable();
    private boolean isDirectMode = false;
    private Object getNextAckIDMutex = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long getNextAckID() {
        Long l;
        Object object = this.getNextAckIDMutex;
        synchronized (object) {
            ++this.nextAckID;
            if (this.nextAckID == Long.MAX_VALUE) {
                this.nextAckID = 1L;
            }
            l = new Long(this.nextAckID);
        }
        return l;
    }

    protected void setTimeToPing(boolean bl) {
        this.timeToPing = bl;
    }

    protected boolean getTimeToPing() {
        return this.timeToPing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPingTimeStamp() {
        Object object = this.nonResponsiveSyncObj;
        synchronized (object) {
            this.isPingTimeStampSet = true;
            if (this.nonRespPingTimeStamp == 0L) {
                this.nonRespPingTimeStamp = System.currentTimeMillis();
                if (this.debug) {
                    Debug.println("*** ping time stamp: " + this.nonRespPingTimeStamp);
                }
            } else {
                long l = System.currentTimeMillis();
                long l2 = l - this.nonRespPingTimeStamp;
                if (l2 > (long)this.timeout) {
                    this.connection.readChannel.setBrokerNonResponsive();
                    if (this.debug) {
                        Debug.println("*** timeout on ping.  wait time: " + l2);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetPingTimeStamp() {
        Object object = this.nonResponsiveSyncObj;
        synchronized (object) {
            this.isPingTimeStampSet = false;
            this.nonRespPingTimeStamp = 0L;
            if (this.debug) {
                Debug.println("*** ping time stamp reset to 0 ...");
            }
        }
    }

    private void findLocalHostIP() throws Exception {
        String string = System.getProperty("imq.useMac", "true");
        try {
            this.ipAddress = InetAddress.getLocalHost().getAddress();
            if (string.equalsIgnoreCase("true")) {
                this.macAddress = IPAddress.getRandomMac();
            }
            this.localPort = this.connectionHandler.getLocalPort();
        }
        catch (Exception exception) {
            ExceptionHandler.logCaughtException(exception);
            this.ipAddress = null;
            this.localPort = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePacketNoAck(ReadWritePacket readWritePacket) throws JMSException {
        this.checkConnectionState(readWritePacket);
        try {
            ProtocolHandler protocolHandler = this;
            synchronized (protocolHandler) {
                if (this.macAddress == null) {
                    readWritePacket.setIP(this.getIPAddress());
                } else {
                    readWritePacket.setIP(this.getIPAddress(), this.getMacAddress());
                }
                readWritePacket.setPort(this.getLocalPort());
                this.connectionHandler.writePacket(readWritePacket);
                this.setTimeToPing(false);
                if (this.debugOutboundPkt) {
                    Debug.matchAndPrintPacket(readWritePacket, this.pktFilter, " -------writing packet----->");
                } else if (this.debug) {
                    Debug.println(new Date().toString() + " ---> writing packet: " + readWritePacket);
                    Debug.printWritePacket(readWritePacket);
                }
                if (this.connLogger.isLoggable(Level.FINEST)) {
                    Object[] objectArray = new Object[]{readWritePacket, this.connection};
                    this.connLogger.log(Level.FINEST, "I106", objectArray);
                }
                if (outpktLogger.isLoggable(Level.FINEST)) {
                    outpktLogger.log(Level.FINEST, "sent packet ... " + readWritePacket, readWritePacket);
                }
            }
        }
        catch (Exception exception) {
            ExceptionHandler.handleException(exception, "C4001", true);
        }
    }

    private ReadOnlyPacket writePacketWithReply(ReadWritePacket readWritePacket, int n) throws JMSException {
        ReadOnlyPacket readOnlyPacket = this.writePacketWithAck(readWritePacket);
        this.checkReplyType(readOnlyPacket, n);
        return readOnlyPacket;
    }

    private ReadOnlyPacket writePacketWithReply(ReadWritePacket readWritePacket, int n, int n2) throws JMSException {
        ReadOnlyPacket readOnlyPacket = this.writePacketWithAck(readWritePacket);
        int n3 = readOnlyPacket.getPacketType();
        if (n3 != n && n3 != n2) {
            if (this.debug) {
                Debug.println("expected pkt type: " + n);
                Debug.println("alt expected pkt type: " + n2);
                Debug.println("pkt type: " + n3);
            }
            String string = AdministeredObject.cr.getKString("C4000") + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException(new com.sun.messaging.jms.JMSException(string, "C4000"));
        }
        return readOnlyPacket;
    }

    private ReadOnlyPacket writePacketWithReply2(ReadWritePacket readWritePacket, int n, int n2) throws JMSException {
        ReadOnlyPacket readOnlyPacket = this.writePacketWithAck(readWritePacket, true, n);
        if (readOnlyPacket.getPacketType() != n2) {
            if (this.debug) {
                Debug.println("expected pkt type: " + n2);
                Debug.println("pkt type: " + readOnlyPacket.getPacketType());
            }
            String string = AdministeredObject.cr.getKString("C4000") + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException(new com.sun.messaging.jms.JMSException(string, "C4000"));
        }
        return readOnlyPacket;
    }

    private void writePacketWithAck(ReadWritePacket readWritePacket, int n) throws JMSException {
        ReadOnlyPacket readOnlyPacket = this.writePacketWithReply(readWritePacket, n);
        int n2 = ProtocolHandler.getReplyStatus(readOnlyPacket);
        if (n2 != 200) {
            this.throwServerErrorException(readOnlyPacket);
        }
    }

    private ReadOnlyPacket writePacketWithAck(ReadWritePacket readWritePacket) throws JMSException {
        return this.writePacketWithAck(readWritePacket, false, -1);
    }

    private ReadOnlyPacket writePacketWithAck(ReadWritePacket readWritePacket, boolean bl, int n) throws JMSException {
        boolean bl2;
        Object object = null;
        Long l = this.getNextAckID();
        readWritePacket.setConsumerID(l);
        readWritePacket.setSendAcknowledge(true);
        AckQueue ackQueue = null;
        boolean bl3 = bl2 = this.isDirectModeTwoThreadWithSyncReplies() && readWritePacket.getPacketType() != 22;
        if (!bl2) {
            ackQueue = bl ? new AckQueue(true, 2) : new AckQueue(true, 1);
            this.connection.addToAckQTable(l, ackQueue);
        }
        this.addMetaData(readWritePacket);
        this.writePacketNoAck(readWritePacket);
        object = bl2 ? (ReadOnlyPacket)((DirectConnectionHandler)this.connectionHandler).fetchReply() : ((this.connection.connectionIsBroken || this.connection.recoverInProcess) && ackQueue.isEmpty() ? null : (ReadOnlyPacket)ackQueue.dequeueWait(this.connection, readWritePacket, this.timeout));
        if (bl && object != null) {
            try {
                Object object2;
                int n2 = (Integer)((ReadOnlyPacket)object).getProperties().get("JMQStatus");
                int n3 = ((ReadOnlyPacket)object).getPacketType();
                if (n3 != n) {
                    object2 = AdministeredObject.cr.getKString("C4000") + this.getUserBrokerInfo();
                    ExceptionHandler.throwJMSException(new com.sun.messaging.jms.JMSException((String)object2, "C4000"));
                }
                if (n3 == 11) {
                    if (n2 == 503) {
                        object2 = AdministeredObject.cr.getKString("C4037") + this.getUserBrokerInfo();
                        ExceptionHandler.throwJMSException(new ResourceAllocationException((String)object2, "C4037"));
                    } else if (n2 == 408) {
                        object2 = AdministeredObject.cr.getKString("C4099") + this.getUserBrokerInfo();
                        ExceptionHandler.throwJMSException(new ResourceAllocationException((String)object2, "C4099"));
                    } else if (n2 == 301) {
                        object2 = AdministeredObject.cr.getKString("C4100") + this.getUserBrokerInfo();
                        ExceptionHandler.throwJMSException(new ResourceAllocationException((String)object2, "C4100"));
                    }
                    object2 = (Long)((ReadOnlyPacket)object).getProperties().get("JMQBrokerSessionID");
                    if (object2 != null) {
                        this.connection.setBrokerSessionID((Long)object2);
                    }
                }
                if (n2 != 200) {
                    this.throwServerErrorException((ReadOnlyPacket)object);
                }
                object = this.isDirectModeTwoThreadWithSyncReplies() ? (ReadOnlyPacket)((DirectConnectionHandler)this.connectionHandler).fetchReply() : ((this.connection.connectionIsBroken || this.connection.recoverInProcess) && ackQueue.isEmpty() ? null : (ReadOnlyPacket)ackQueue.dequeueWait(this.connection, readWritePacket, this.timeout));
            }
            catch (IOException iOException) {
                ExceptionHandler.handleException(iOException, "C4000", true);
            }
            catch (ClassNotFoundException classNotFoundException) {
                ExceptionHandler.handleException(classNotFoundException, "C4000", true);
            }
        }
        this.connection.removeFromAckQTable(l);
        if (object == null) {
            String string = AdministeredObject.cr.getKString("C4000") + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException(new com.sun.messaging.jms.JMSException(string, "C4000"));
        }
        return object;
    }

    protected void addMetaData(ReadWritePacket readWritePacket) throws JMSException {
        int n = readWritePacket.getPacketType();
        if (n == 14 || n == 26 || n == 18) {
            try {
                Hashtable hashtable = readWritePacket.getProperties();
                Object v = hashtable.get(REQUEST_META_DATA);
                hashtable.remove(REQUEST_META_DATA);
                Long l = new Long(readWritePacket.getConsumerID());
                this.requestMetaData.put(l, v);
            }
            catch (IOException iOException) {
                ExceptionHandler.handleException(iOException, "C4000", true);
            }
            catch (ClassNotFoundException classNotFoundException) {
                ExceptionHandler.handleException(classNotFoundException, "C4000", true);
            }
        }
    }

    private void checkConnectionState(ReadWritePacket readWritePacket) throws JMSException {
        if (this.connection.imqReconnect && this.connection.reconnecting && Thread.currentThread() != this.recoverThread && Thread.currentThread() != this.connection.readChannel.readChannelThread) {
            this.connection.checkReconnecting(readWritePacket);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init(boolean bl) throws JMSException {
        this.isClosed = false;
        try {
            block9: {
                try {
                    this.connectionHandler = bl ? this.connection.initiator.reconnect() : this.connection.initiator.createConnection();
                    this.setTimeout();
                    if (this.isDirectModeTwoThread()) {
                        this.setAckAck(false);
                        this.enableWriteAcknowledge(false);
                    }
                    this.connectionHandler.configure(this.connection.getConfiguration());
                    this.findLocalHostIP();
                    this.setJMSXAppID = this.connection.connectionMetaData.setJMSXAppID;
                    if (this.setJMSXAppID) {
                        this.jmsxAppID = InetAddress.getLocalHost().getHostAddress() + "-" + this.getLocalPort() + "-" + System.currentTimeMillis();
                    }
                    this.setJMSXUserID = this.connection.connectionMetaData.setJMSXUserID;
                    if (this.setJMSXUserID) {
                        this.jmsxUserID = this.connection.getUserName();
                    }
                    this.setJMSXRcvTimestamp = this.connection.connectionMetaData.setJMSXRcvTimestamp;
                    String string = this.connection.getProperty("imqAbortOnTimeout", "false");
                    if ("true".equals(string)) {
                        this.imqAbortOnTimeout = true;
                    }
                    this.nonRespPingTimeStamp = 0L;
                    this.isPingTimeStampSet = false;
                    if (!this.debug) break block9;
                    Debug.println("*** Connected to broker: " + this.getUserBrokerInfo());
                }
                catch (JMSException jMSException) {
                    throw jMSException;
                }
                catch (Exception exception) {
                    ExceptionHandler.handleException(exception, "C4038", true);
                    Object var4_6 = null;
                }
            }
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            throw throwable;
        }
    }

    public void hello(String string, String string2) throws JMSException {
        this.hello(string, string2, null);
    }

    public void hello(String string, String string2, Long l) throws JMSException {
        this.authenticated = false;
        ReadWritePacket readWritePacket = new ReadWritePacket();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(1);
        hashtable.put("JMQRBufferSize", new Integer(this.connection.flowControlMsgSize));
        hashtable.put("JMQProtocolLevel", new Integer(this.connection.getBrokerProtocolLevel()));
        hashtable.put("JMQVersion", version.getProductVersion());
        hashtable.put("JMQUserAgent", version.getUserAgent());
        if (this.connection.isAdminKeyUsed()) {
            hashtable.put("JMQAuthType", AUTHTYPE_JMQADMINKEY);
        }
        hashtable.put("JMQReconnectable", this.connection.imqReconnect);
        if (l != null) {
            hashtable.put("JMQConnectionID", l);
        }
        hashtable.put("JMQHAClient", this.connection.isHAEnabled());
        if (this.connection.JMQClusterID != null) {
            hashtable.put("JMQClusterID", this.connection.JMQClusterID);
        }
        if (this.connection.JMQStoreSession != null) {
            hashtable.put("JMQStoreSession", this.connection.JMQStoreSession);
        }
        readWritePacket.setProperties(hashtable);
        readWritePacket.setPacketType(10);
        ReadOnlyPacket readOnlyPacket = this.writePacketWithReply2(readWritePacket, 11, 38);
        Integer n = null;
        try {
            n = (Integer)readOnlyPacket.getProperties().get("JMQStatus");
        }
        catch (IOException iOException) {
            ExceptionHandler.handleException(iOException, "C4005", true);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ExceptionHandler.handleException(classNotFoundException, "C4005", true);
        }
        if (n != null) {
            String string3;
            if (n == 403) {
                string3 = AdministeredObject.cr.getKString("C4035") + this.getUserBrokerInfo();
                ExceptionHandler.throwJMSException(new JMSSecurityException(string3, "C4035"));
            }
            if (n == 503) {
                string3 = AdministeredObject.cr.getKString("C4037") + this.getUserBrokerInfo();
                ExceptionHandler.throwJMSException(new ResourceAllocationException(string3, "C4037"));
            }
            if (n != 200) {
                this.throwServerErrorException(readOnlyPacket);
            }
        }
        this.authenticate(readOnlyPacket, string, string2);
        this.authenticated = true;
        if (this.debug) {
            Debug.println("got hello reply ...");
        }
    }

    private void authenticate(ReadOnlyPacket readOnlyPacket, String string, String string2) throws JMSException {
        Properties properties = this.connection.getConfiguration();
        AuthenticationProtocolHandler authenticationProtocolHandler = null;
        ReadWritePacket readWritePacket = (ReadWritePacket)readOnlyPacket;
        try {
            String string3;
            String string4;
            String string5 = (String)readWritePacket.getProperties().get("JMQAuthType");
            Boolean bl = (Boolean)readWritePacket.getProperties().get("JMQChallenge");
            if (bl != null && bl.booleanValue()) {
                this.checkAdminKeyAuth(string5);
                authenticationProtocolHandler = this.getAuthHandlerInstance(string5);
                authenticationProtocolHandler.init(string, string2, properties);
                this.connection.setAuthenticationHandler(authenticationProtocolHandler);
            } else {
                authenticationProtocolHandler = this.connection.getAuthenticationHandler();
            }
            if (authenticationProtocolHandler == null) {
                string4 = AdministeredObject.cr.getKString("C4034") + this.getUserBrokerInfo();
                ExceptionHandler.throwJMSException(new JMSSecurityException(string4, "C4034"));
            }
            while (readWritePacket.getPacketType() != 13) {
                if (!authenticationProtocolHandler.getType().equals(string5)) {
                    string4 = AdministeredObject.cr.getKString("C4033", authenticationProtocolHandler.getType(), string5) + this.getUserBrokerInfo();
                    ExceptionHandler.throwJMSException(new JMSSecurityException(string4, "C4033"));
                }
                byte[] byArray = readWritePacket.getMessageBody();
                byte[] byArray2 = authenticationProtocolHandler.handleRequest(byArray, readOnlyPacket.getSequence());
                ReadWritePacket readWritePacket2 = new ReadWritePacket();
                readWritePacket2.setPacketType(12);
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                hashtable.put("JMQAuthType", authenticationProtocolHandler.getType());
                readWritePacket2.setProperties(hashtable);
                readWritePacket2.setMessageBody(byArray2);
                readWritePacket = (ReadWritePacket)this.writePacketWithReply(readWritePacket2, 13, 38);
                string5 = (String)readWritePacket.getProperties().get("JMQAuthType");
            }
            int n = (Integer)readWritePacket.getProperties().get("JMQStatus");
            if (n == 403) {
                string3 = AdministeredObject.cr.getKString("C4084", this.getUserBrokerInfo());
                ExceptionHandler.throwJMSException(new JMSSecurityException(string3, "C4084"));
            }
            if (n == 413) {
                string3 = AdministeredObject.cr.getKString("C4060", this.getUserBrokerInfo());
                ExceptionHandler.throwJMSException(new JMSSecurityException(string3, "C4060"));
            }
            if (n == 503) {
                string3 = AdministeredObject.cr.getKString("C4037") + this.getUserBrokerInfo();
                ExceptionHandler.throwJMSException(new ResourceAllocationException(string3, "C4037"));
            }
            if (n != 200) {
                this.throwServerErrorException(readWritePacket);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            ExceptionHandler.handleException(classNotFoundException, "C4005", true);
        }
        catch (UnsupportedAuthTypeException unsupportedAuthTypeException) {
            ExceptionHandler.handleException((Exception)unsupportedAuthTypeException, "C4038");
        }
        catch (LoginException loginException) {
            ExceptionHandler.handleException((Exception)loginException, "C4038");
        }
        catch (IOException iOException) {
            ExceptionHandler.handleException((Exception)iOException, "C4038");
        }
    }

    private void checkAdminKeyAuth(String string) throws JMSException {
        Object object;
        if (this.connection.isAdminKeyUsed() && !string.equals(AUTHTYPE_JMQADMINKEY)) {
            object = AdministeredObject.cr.getKString("C4033", AUTHTYPE_JMQADMINKEY, string) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException(new JMSSecurityException((String)object, "C4033"));
        }
        if (!this.connection.isAdminKeyUsed() && string.equals(AUTHTYPE_JMQADMINKEY)) {
            object = new JMSSecurityException(string + this.getUserBrokerInfo());
            ((JMSException)object).setLinkedException(new UnsupportedAuthTypeException(string));
            ExceptionHandler.throwJMSException((JMSException)object);
        }
    }

    private AuthenticationProtocolHandler getAuthHandlerInstance(String string) throws UnsupportedAuthTypeException {
        if (string == null) {
            throw new UnsupportedAuthTypeException("authType is null" + this.getUserBrokerInfo());
        }
        if (string.equals(AUTHTYPE_JMQBASIC)) {
            return new BasicAuthenticationHandler();
        }
        if (string.equals(AUTHTYPE_JMQDIGEST)) {
            return new DigestAuthenticationHandler();
        }
        if (string.equals(AUTHTYPE_JMQADMINKEY)) {
            return new JMQAdminKeyAuthenticationHandler();
        }
        String string2 = this.connection.getProperty("JMQAuthClass." + string, "");
        if (string2 == null || string2.trim().equals("") || string2.trim().equals(AUTHTYPE_JMQADMINKEY)) {
            throw new UnsupportedAuthTypeException(string + ": " + string2 + this.getUserBrokerInfo());
        }
        try {
            return (AuthenticationProtocolHandler)Class.forName(string2).newInstance();
        }
        catch (Exception exception) {
            ExceptionHandler.logCaughtException(exception);
            throw new UnsupportedAuthTypeException(string + " " + exception.getMessage() + this.getUserBrokerInfo());
        }
    }

    public void resumeFlow(int n) throws JMSException {
        ReadWritePacket readWritePacket = new ReadWritePacket();
        readWritePacket.setPacketType(52);
        this.writePacketNoAck(readWritePacket);
    }

    public void resumeConsumerFlow(Consumer consumer, int n) throws JMSException {
        ReadWritePacket readWritePacket = new ReadWritePacket();
        readWritePacket.setPacketType(52);
        Hashtable<String, Number> hashtable = new Hashtable<String, Number>(1);
        if (this.debug && n == 0) {
            Debug.getPrintStream().println("\n\n######## SENDING RESUME_FLOW WITH JMQSIZE = 0. (POTENTIAL PROBLEM) ########");
        }
        hashtable.put("JMQConsumerID", consumer.getInterestId());
        hashtable.put("JMQSize", new Integer(n));
        readWritePacket.setProperties(hashtable);
        this.writePacketNoAck(readWritePacket);
    }

    public void createMessageProducer(MessageProducerImpl messageProducerImpl) throws JMSException {
        Destination destination = (Destination)messageProducerImpl.getDestination();
        this.createMessageProducer(messageProducerImpl, destination);
    }

    public void createMessageProducer(MessageProducerImpl messageProducerImpl, javax.jms.Destination destination) throws JMSException {
        Object object;
        Destination destination2 = (Destination)destination;
        this.createDestination(destination2);
        ReadWritePacket readWritePacket = new ReadWritePacket();
        readWritePacket.setPacketType(18);
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("JMQDestination", destination2.getName());
        Integer n = this.getDestinationType(destination2);
        hashtable.put("JMQDestType", n);
        hashtable.put("JMQSessionID", new Long(messageProducerImpl.getSession().getBrokerSessionID()));
        messageProducerImpl.addProducerDest = destination2;
        hashtable.put(REQUEST_META_DATA, messageProducerImpl);
        readWritePacket.setProperties(hashtable);
        ReadOnlyPacket readOnlyPacket = this.writePacketWithReply(readWritePacket, 19);
        int n2 = -1;
        try {
            object = readOnlyPacket.getProperties();
            n2 = (Integer)((Hashtable)object).get("JMQStatus");
        }
        catch (IOException iOException) {
            ExceptionHandler.handleException(iOException, "C4000", true);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ExceptionHandler.handleException(classNotFoundException, "C4000", true);
        }
        if (n2 == 404) {
            object = AdministeredObject.cr.getKString("C4019", destination2.getName()) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException(new InvalidDestinationException((String)object, "C4019"));
        }
        if (n2 == 403) {
            object = AdministeredObject.cr.getKString("C4076", destination2.getName()) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException(new JMSSecurityException((String)object, "C4076"));
        }
        if (n2 == 405) {
            object = AdministeredObject.cr.getString(destination2.isQueue() ? "L0950" : "L0951");
            String string = AdministeredObject.cr.getKString("C4088", object, destination2.getName()) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException(new ResourceAllocationException(string, "C4088"));
        }
        if (n2 != 200) {
            this.throwServerErrorException(readOnlyPacket);
        }
        if (this.debug) {
            Debug.println("got create producer reply ...");
        }
    }

    public void deleteMessageProducer(long l) throws JMSException {
        ReadWritePacket readWritePacket = new ReadWritePacket();
        readWritePacket.setPacketType(66);
        Hashtable<String, Long> hashtable = new Hashtable<String, Long>(1);
        hashtable.put("JMQProducerID", new Long(l));
        readWritePacket.setProperties(hashtable);
        ReadOnlyPacket readOnlyPacket = this.writePacketWithReply(readWritePacket, 67);
        int n = ProtocolHandler.getReplyStatus(readOnlyPacket);
        if (n != 200) {
            this.throwServerErrorException(readOnlyPacket);
        }
        if (this.debug) {
            Debug.println("got delete producer reply ...");
        }
    }

    public void createDestination(javax.jms.Destination destination) throws JMSException {
        String string;
        Object object;
        Destination destination2 = (Destination)destination;
        if (destination2.isTemporary() && !((TemporaryDestination)(object = (TemporaryDestination)destination2)).checkSendCreateDest(destination2, this.connection)) {
            return;
        }
        object = new ReadWritePacket();
        ((ReadWritePacket)object).setPacketType(34);
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(2);
        hashtable.put("JMQDestination", destination2.getName());
        Integer n = this.getDestinationType(destination2);
        hashtable.put("JMQDestType", n);
        ((ReadWritePacket)object).setProperties(hashtable);
        ReadOnlyPacket readOnlyPacket = this.writePacketWithReply((ReadWritePacket)object, 35);
        int n2 = ProtocolHandler.getReplyStatus(readOnlyPacket);
        if (n2 == 404) {
            string = AdministeredObject.cr.getKString("C4019", destination2.getName()) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException(new InvalidDestinationException(string, "C4019"));
        }
        if (n2 == 403) {
            string = AdministeredObject.cr.getKString("C4077", destination2.getName()) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException(new JMSSecurityException(string, "C4077"));
        }
        if (n2 != 200 && n2 != 409) {
            this.throwServerErrorException(readOnlyPacket);
        }
        this.setXMLValidation(destination2, readOnlyPacket);
        if (this.debug) {
            Debug.println("got create destination reply ...");
        }
    }

    public void deleteDestination(javax.jms.Destination destination) throws JMSException {
        Destination destination2 = (Destination)destination;
        ReadWritePacket readWritePacket = new ReadWritePacket();
        readWritePacket.setPacketType(36);
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(2);
        hashtable.put("JMQDestination", destination2.getName());
        Integer n = this.getDestinationType(destination2);
        hashtable.put("JMQDestType", n);
        readWritePacket.setProperties(hashtable);
        ReadOnlyPacket readOnlyPacket = this.writePacketWithReply(readWritePacket, 37);
        int n2 = ProtocolHandler.getReplyStatus(readOnlyPacket);
        if (n2 != 200 && n2 != 404) {
            this.throwServerErrorException(readOnlyPacket);
        }
        if (this.debug) {
            Debug.println("got delete destination reply ...");
        }
    }

    public Integer getDestinationType(Destination destination) {
        int n = 0;
        n = destination.isQueue() ? 1 : 2;
        if (destination.isTemporary()) {
            n |= 0x10;
        }
        return new Integer(n);
    }

    protected void getIPFromPacket(ReadOnlyPacket readOnlyPacket) throws JMSException {
        try {
            Hashtable hashtable = readOnlyPacket.getProperties();
            Object v = hashtable.get("JMQIPAddr");
            this.ipAddress = (byte[])v;
            v = hashtable.get("JMQPort");
            this.localPort = (Integer)v;
        }
        catch (Exception exception) {
            ExceptionHandler.handleException(exception, "C4005", true);
        }
    }

    public ProtocolHandler(ConnectionImpl connectionImpl) throws JMSException {
        this.connection = connectionImpl;
        this.requestMetaData = connectionImpl.requestMetaData;
        inpktLogger = Logger.getLogger(INBOUND_PACKET_LOGGING_NAME);
        outpktLogger = Logger.getLogger(OUTBOUND_PACKET_LOGGING_NAME);
        this.init(false);
    }

    public void enableWriteAcknowledge(boolean bl) {
        this.ackEnabled = bl;
        this.ackEnabledFlag = true;
        if (this.debug) {
            Debug.println("Producer ack required: " + this.ackEnabled);
        }
    }

    public boolean getAckEnabled() {
        return this.ackEnabled;
    }

    public void setAckAck(boolean bl) {
        this.ackAck = bl;
        if (this.debug) {
            Debug.println("Auto/Client acknowledge require ack from broker: " + this.ackAck);
        }
    }

    public boolean getAckAck() {
        return this.ackAck;
    }

    protected void setTimeout() {
        String string = this.connection.getTrimmedProperty("imqAckTimeout");
        if (string != null) {
            this.timeout = Integer.parseInt(string);
        }
        if (this.isDirectMode() && this.timeout == 0) {
            this.timeout = 60000;
        }
        if (this.debug) {
            Debug.println("Ack timeout: " + this.timeout);
        }
    }

    protected void setTimeOut(int n) {
        this.timeout = n;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public byte[] getIPAddress() {
        return this.ipAddress;
    }

    public byte[] getMacAddress() {
        return this.macAddress;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incStoppedCount() {
        Object object = this.incObj;
        synchronized (object) {
            ++this.stoppedCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decStoppedCount() {
        Object object = this.incObj;
        synchronized (object) {
            --this.stoppedCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStoppedCount() {
        Object object = this.incObj;
        synchronized (object) {
            return this.stoppedCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws JMSException {
        try {
            Object object = this.incObj;
            synchronized (object) {
                if (this.stoppedCount == 0) {
                    ReadWritePacket readWritePacket = new ReadWritePacket();
                    readWritePacket.setPacketType(20);
                    this.writePacketNoAck(readWritePacket);
                }
            }
        }
        catch (Exception exception) {
            ExceptionHandler.handleException(exception, "C4001", true);
        }
    }

    public void resumeSession(long l) throws JMSException {
        ReadWritePacket readWritePacket = new ReadWritePacket();
        readWritePacket.setPacketType(20);
        Hashtable<String, Long> hashtable = new Hashtable<String, Long>(1);
        hashtable.put("JMQSessionID", new Long(l));
        readWritePacket.setProperties(hashtable);
        this.writePacketNoAck(readWritePacket);
    }

    public void stop() throws JMSException {
        ReadWritePacket readWritePacket = new ReadWritePacket();
        readWritePacket.setPacketType(22);
        this.writePacketWithAck(readWritePacket, 23);
    }

    public void stopSession(long l) throws JMSException {
        ReadWritePacket readWritePacket = new ReadWritePacket();
        readWritePacket.setPacketType(22);
        Hashtable<String, Long> hashtable = new Hashtable<String, Long>(1);
        hashtable.put("JMQSessionID", new Long(l));
        readWritePacket.setProperties(hashtable);
        this.writePacketWithAck(readWritePacket, 23);
    }

    public void goodBye(boolean bl) throws JMSException {
        try {
            ReadWritePacket readWritePacket = new ReadWritePacket();
            readWritePacket.setPacketType(28);
            Hashtable<String, Comparable<Boolean>> hashtable = new Hashtable<String, Comparable<Boolean>>();
            boolean bl2 = this.sentSetClientID || this.hasConnectionConsumer;
            hashtable.put("JMQBlock", Boolean.valueOf(bl2));
            hashtable.put("JMQConnectionID", this.connection.connectionID);
            readWritePacket.setProperties(hashtable);
            if (bl) {
                this.writePacketWithAck(readWritePacket, 29);
            } else {
                this.writePacketNoAck(readWritePacket);
            }
        }
        catch (Exception exception) {
            ExceptionHandler.handleException(exception, "C4001", true);
        }
    }

    public ReadWritePacket readPacket() throws JMSException {
        ReadWritePacket readWritePacket = null;
        try {
            readWritePacket = this.connectionHandler.readPacket();
            this.setTimeToPing(false);
            if (this.isPingTimeStampSet) {
                this.resetPingTimeStamp();
            }
            if (this.debugInboundPkt) {
                Debug.matchAndPrintPacket(readWritePacket, this.pktFilter, " <------reading packet------");
            } else if (this.debug) {
                Debug.println(new Date().toString() + " <--- read packet: " + readWritePacket);
                Debug.printReadPacket(readWritePacket);
            }
            if (this.connLogger.isLoggable(Level.FINEST)) {
                Object[] objectArray = new Object[]{readWritePacket, this.connection};
                this.connLogger.log(Level.FINEST, "I105", objectArray);
            }
            if (inpktLogger.isLoggable(Level.FINEST)) {
                inpktLogger.log(Level.FINEST, "read packet ... " + readWritePacket, readWritePacket);
            }
        }
        catch (Exception exception) {
            if (!this.isClosed) {
                ExceptionHandler.handleException(exception, "C4002", true);
            }
            throw new JMSException("ProtocolHandler is closed");
        }
        return readWritePacket;
    }

    public void writeJMSMessage(Message message) throws JMSException {
        Object object;
        ReadWritePacket readWritePacket = null;
        MessageImpl messageImpl = null;
        messageImpl = (MessageImpl)message;
        long l = message.getJMSExpiration();
        if (l != 0L) {
            message.setJMSExpiration(l += System.currentTimeMillis());
        }
        if (this.setJMSXAppID) {
            message.setStringProperty("JMSXAppID", this.jmsxAppID);
        }
        if (this.setJMSXUserID) {
            message.setStringProperty("JMSXUserID", this.jmsxUserID);
        }
        messageImpl.setMessageBodyToPacket();
        if (this.enableZip) {
            messageImpl.compress();
        } else if (messageImpl.shouldCompress) {
            messageImpl.compress();
        } else {
            messageImpl.getPacket().setFlag(1024, false);
        }
        messageImpl.setPropertiesToPacket();
        messageImpl.resetJMSMessageID();
        readWritePacket = messageImpl.getPacket();
        Destination destination = (Destination)messageImpl.getJMSDestination();
        if (this.xmlValidationTable.containsKey(destination)) {
            if (readWritePacket.getPacketType() == 1) {
                if (this.debug) {
                    Debug.println("*** Validating xml message ....");
                }
                object = (XMLValidator)this.xmlValidationTable.get(destination);
                String string = ((TextMessage)message).getText();
                ((XMLValidator)object).validate(string);
                if (this.debug) {
                    Debug.println("*** xml message validated against xsd at URI: " + ((XMLValidator)object).getURIList());
                }
            }
        } else if (this.debug) {
            Debug.println("***** no validation for message ... on dest: " + destination.getName());
        }
        readWritePacket.setDestination(destination.getName());
        readWritePacket.setDestinationClass(destination.getClass().getName());
        readWritePacket.setIsQueue(destination.isQueue());
        if (message.getJMSReplyTo() != null) {
            object = (Destination)message.getJMSReplyTo();
            readWritePacket.setReplyTo(((Destination)object).getName());
            readWritePacket.setReplyToClass(object.getClass().getName());
        }
        if (this.ackEnabledFlag) {
            this.produceAck = this.ackEnabled;
        } else if (message.getJMSDeliveryMode() == 2) {
            this.produceAck = true;
            if (readWritePacket.getTransactionID() != 0L && SessionImpl.noBlockUntilTxnCompletes) {
                this.produceAck = false;
            }
        } else {
            this.produceAck = false;
        }
        if (this.produceAck) {
            object = this.writePacketWithReply(readWritePacket, 9);
            int n = ProtocolHandler.getReplyStatus((ReadOnlyPacket)object);
            if (n != 200) {
                if (n == 403) {
                    String string = AdministeredObject.cr.getKString("C4078", destination.getName()) + this.getUserBrokerInfo();
                    ExceptionHandler.throwJMSException(new JMSSecurityException(string, "C4078"));
                } else if (n == 404) {
                    String string = AdministeredObject.cr.getKString("C4094", destination.getName()) + this.getUserBrokerInfo();
                    ExceptionHandler.throwJMSException(new com.sun.messaging.jms.JMSException(string, "C4094"));
                } else if (n == 423) {
                    String string = AdministeredObject.cr.getKString("C4095", destination.getName()) + this.getUserBrokerInfo();
                    ExceptionHandler.throwJMSException(new com.sun.messaging.jms.JMSException(string, "C4095"));
                } else if (n == 414) {
                    String string = AdministeredObject.cr.getKString("C4096", destination.getName()) + this.getUserBrokerInfo();
                    ExceptionHandler.throwJMSException(new ResourceAllocationException(string, "C4096"));
                } else {
                    this.throwServerErrorException((ReadOnlyPacket)object);
                }
            }
        } else {
            readWritePacket.setSendAcknowledge(false);
            this.writePacketNoAck(readWritePacket);
        }
    }

    public MessageImpl getJMSMessage(ReadOnlyPacket readOnlyPacket) throws JMSException {
        MessageImpl messageImpl = null;
        switch (readOnlyPacket.getPacketType()) {
            case 1: {
                messageImpl = new TextMessageImpl();
                break;
            }
            case 2: {
                messageImpl = new BytesMessageImpl();
                break;
            }
            case 4: {
                messageImpl = new StreamMessageImpl();
                break;
            }
            case 3: {
                messageImpl = new MapMessageImpl();
                break;
            }
            case 5: {
                messageImpl = new ObjectMessageImpl();
                break;
            }
            case 6: {
                messageImpl = new MessageImpl();
                break;
            }
            default: {
                throw new com.sun.messaging.jms.JMSException("not implemented.");
            }
        }
        ((ReadWritePacket)readOnlyPacket).setTransactionID(0L);
        messageImpl.setPacket((ReadWritePacket)readOnlyPacket);
        messageImpl.getPropertiesFromPacket();
        messageImpl.getMessageBodyFromPacket();
        if (this.setJMSXRcvTimestamp) {
            messageImpl.setStringProperty("JMSXRcvTimestamp", String.valueOf(System.currentTimeMillis()));
        }
        messageImpl.setMessageReadMode(true);
        messageImpl.setPropertiesReadMode(true);
        messageImpl.setMessageID(readOnlyPacket.getSysMessageID());
        messageImpl.setInterestID(readOnlyPacket.getConsumerID());
        return messageImpl;
    }

    public ReadWritePacket createReadWritePacket() {
        return new ReadWritePacket();
    }

    public long getInterestId(ReadWritePacket readWritePacket) {
        return readWritePacket.getConsumerID();
    }

    public void resetClientID() throws JMSException {
        if (this.sentSetClientID) {
            this.setClientID(this.connection.clientID);
        }
    }

    public void unsetClientID() throws JMSException {
        ReadWritePacket readWritePacket = new ReadWritePacket();
        readWritePacket.setPacketType(50);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (this.connection.useNamespace()) {
            hashtable.put("JMQNamespace", this.connection.getRANamespaceUID());
        }
        readWritePacket.setProperties(hashtable);
        ReadOnlyPacket readOnlyPacket = this.writePacketWithReply(readWritePacket, 51);
        int n = ProtocolHandler.getReplyStatus(readOnlyPacket);
        if (n != 200) {
            this.throwServerErrorException(readOnlyPacket);
        }
        this.sentSetClientID = false;
    }

    public void setClientID(String string) throws JMSException {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        ReadWritePacket readWritePacket = new ReadWritePacket();
        readWritePacket.setPacketType(50);
        hashtable.put("JMQClientID", string);
        if (this.connection.useNamespace()) {
            hashtable.put("JMQNamespace", this.connection.getRANamespaceUID());
        }
        hashtable.put("JMQShare", this.connection.imqEnableSharedClientID);
        readWritePacket.setProperties(hashtable);
        ReadOnlyPacket readOnlyPacket = this.writePacketWithReply(readWritePacket, 51);
        int n = ProtocolHandler.getReplyStatus(readOnlyPacket);
        if (n != 200) {
            if (n == 409) {
                String string2 = AdministeredObject.cr.getKString("C4052", string) + this.getUserBrokerInfo();
                ExceptionHandler.throwJMSException(new InvalidClientIDException(string2, "C4052"));
            } else if (n == 400) {
                String string3 = AdministeredObject.cr.getKString("C4087", string) + this.getUserBrokerInfo();
                ExceptionHandler.throwJMSException(new InvalidClientIDException(string3, "C4087"));
            } else {
                this.throwServerErrorException(readOnlyPacket);
            }
        }
        this.sentSetClientID = true;
    }

    public void requestConsumerInfo(Destination destination, boolean bl) throws JMSException {
        ReadWritePacket readWritePacket = new ReadWritePacket();
        readWritePacket.setPacketType(72);
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("JMQDestination", destination.getName());
        hashtable.put("JMQDestType", this.getDestinationType(destination));
        hashtable.put("JMQRequestType", 3);
        hashtable.put("JMQRequestOff", bl);
        readWritePacket.setProperties(hashtable);
        this.writePacketNoAck(readWritePacket);
    }

    public void addInterest(Consumer consumer) throws JMSException {
        Object object;
        Destination destination = (Destination)consumer.getDestination();
        this.createDestination(destination);
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        ReadWritePacket readWritePacket = new ReadWritePacket();
        readWritePacket.setPacketType(14);
        if (consumer.getDurable()) {
            hashtable.put("JMQDurableName", consumer.getDurableName());
            hashtable.put("JMQShare", this.connection.imqEnableSharedClientID);
        } else {
            hashtable.put("JMQShare", this.connection.imqEnableSharedSubscriptions);
        }
        hashtable.put("JMQDestination", destination.getName());
        Integer n = this.getDestinationType(destination);
        hashtable.put("JMQDestType", n);
        if (consumer.getMessageSelector() != null) {
            hashtable.put("JMQSelector", consumer.getMessageSelector());
        }
        hashtable.put("JMQNoLocal", consumer.getNoLocal());
        hashtable.put("JMQReconnect", Boolean.FALSE);
        if (consumer.acknowledgeMode > 0) {
            hashtable.put("JMQAckMode", new Integer(consumer.acknowledgeMode));
        }
        hashtable.put(REQUEST_META_DATA, consumer);
        hashtable.put("JMQSize", new Integer(consumer.getPrefetchMaxMsgCount()));
        if (consumer instanceof MessageConsumerImpl) {
            hashtable.put("JMQSessionID", new Long(((MessageConsumerImpl)consumer).getSession().getBrokerSessionID()));
        } else if (consumer instanceof ConnectionConsumerImpl) {
            this.hasConnectionConsumer = true;
        }
        if (consumer.getInterestId() != null) {
            hashtable.put("JMQOldConsumerID", consumer.getInterestId());
        }
        readWritePacket.setProperties(hashtable);
        ReadOnlyPacket readOnlyPacket = this.writePacketWithReply(readWritePacket, 15);
        int n2 = -1;
        try {
            object = readOnlyPacket.getProperties();
            n2 = (Integer)((Hashtable)object).get("JMQStatus");
        }
        catch (IOException iOException) {
            ExceptionHandler.handleException(iOException, "C4000", true);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ExceptionHandler.handleException(classNotFoundException, "C4000", true);
        }
        if (n2 == 400 && consumer.getMessageSelector() != null) {
            object = AdministeredObject.cr.getKString("C4022", consumer.getMessageSelector()) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException(new InvalidSelectorException((String)object, "C4022"));
        }
        if (n2 == 404) {
            object = AdministeredObject.cr.getKString("C4019", destination.getName()) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException(new InvalidDestinationException((String)object, "C4019"));
        }
        if (n2 == 403) {
            object = AdministeredObject.cr.getKString("C4079", destination.getName()) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException(new JMSSecurityException((String)object, "C4079"));
        }
        if (n2 == 405) {
            object = AdministeredObject.cr.getKString("C4020", destination.getName()) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException(new com.sun.messaging.jms.JMSException((String)object, "C4020"));
        }
        if (n2 == 409) {
            object = AdministeredObject.cr.getString(destination.isQueue() ? "L0950" : "L0951");
            String string = AdministeredObject.cr.getKString("C4073", object, destination.getName()) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException(new ResourceAllocationException(string, "C4073"));
        }
        if (n2 != 200) {
            this.throwServerErrorException(readOnlyPacket);
        }
        if (this.debug) {
            Debug.println("added interest, JMQConsumerID: " + consumer.getInterestId());
        }
    }

    public void removeInterest(Consumer consumer) throws JMSException {
        Object object;
        Object object2;
        Cloneable cloneable;
        Hashtable<String, Constable> hashtable = new Hashtable<String, Constable>();
        ReadWritePacket readWritePacket = new ReadWritePacket();
        readWritePacket.setPacketType(16);
        hashtable.put("JMQConsumerID", consumer.getInterestId());
        hashtable.put("JMQBlock", Boolean.TRUE);
        if (consumer instanceof MessageConsumerImpl) {
            cloneable = ((MessageConsumerImpl)consumer).getLastDeliveredID();
            if (cloneable != null) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(36);
                object2 = new DataOutputStream(byteArrayOutputStream);
                try {
                    ((SysMessageID)cloneable).writeID((DataOutput)object2);
                    ((DataOutputStream)object2).flush();
                    object = byteArrayOutputStream.toByteArray();
                    ((FilterOutputStream)object2).close();
                    byteArrayOutputStream.close();
                    readWritePacket.setMessageBody((byte[])object);
                    hashtable.put("JMQBodyType", new Integer(3));
                }
                catch (IOException iOException) {
                    ExceptionHandler.handleException((Exception)iOException, "C4038");
                }
            } else {
                hashtable.put("JMQBodyType", new Integer(0));
                hashtable.put("JMQRedeliverAll", Boolean.TRUE);
            }
        }
        readWritePacket.setProperties(hashtable);
        if (this.debug) {
            Debug.println("removing interest ....");
        }
        cloneable = this.writePacketWithReply(readWritePacket, 17);
        int n = ProtocolHandler.getReplyStatus((ReadOnlyPacket)cloneable);
        if (n == 403) {
            object2 = AdministeredObject.cr.getKString("C4080", consumer.getInterestId()) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException(new JMSSecurityException((String)object2, "C4080"));
        }
        if (n == 404) {
            object2 = consumer.getInterestId().toString();
            object = AdministeredObject.cr.getKString("C4085", object2) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException(new InvalidDestinationException((String)object, "C4085"));
        }
        if (n == 409 && consumer.getDurable()) {
            object2 = AdministeredObject.cr.getKString("C4007", consumer.getDurableName()) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException(new InvalidDestinationException((String)object2, "C4007"));
        }
        if (n != 200) {
            this.throwServerErrorException((ReadOnlyPacket)cloneable);
        }
        if (this.debug) {
            Debug.println("interest removed: " + consumer.getInterestId());
        }
    }

    public void unsubscribe(String string) throws JMSException {
        String string2;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        ReadWritePacket readWritePacket = new ReadWritePacket();
        readWritePacket.setPacketType(16);
        hashtable.put("JMQDurableName", string);
        readWritePacket.setProperties(hashtable);
        ReadOnlyPacket readOnlyPacket = this.writePacketWithReply(readWritePacket, 17);
        int n = ProtocolHandler.getReplyStatus(readOnlyPacket);
        if (n == 403) {
            string2 = AdministeredObject.cr.getKString("C4081", string) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException(new JMSSecurityException(string2, "C4081"));
        }
        if (n == 409) {
            string2 = AdministeredObject.cr.getKString("C4007", string) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException(new InvalidDestinationException(string2, "C4007"));
        }
        if (n == 404) {
            string2 = AdministeredObject.cr.getKString("C4086", string) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException(new InvalidDestinationException(string2, "C4086"));
        }
        if (n != 200) {
            this.throwServerErrorException(readOnlyPacket);
        }
    }

    public synchronized void close() throws JMSException {
        if (this.isClosed) {
            return;
        }
        try {
            this.isClosed = true;
            this.connectionHandler.close();
            this.xmlValidationTable.clear();
        }
        catch (Exception exception) {
            ExceptionHandler.handleException(exception, "C4004", true);
        }
        if (this.debug) {
            Debug.println("ConnectionHandler closed ...");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledgeUndeliverable(ReadWritePacket readWritePacket, boolean bl) throws JMSException {
        try {
            Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
            if (bl) {
                hashtable.put("JMQAckType", new Integer(2));
            } else {
                hashtable.put("JMQAckType", new Integer(1));
            }
            readWritePacket.setProperties(hashtable);
            readWritePacket.setPacketType(24);
            if (readWritePacket.getSendAcknowledge() && this.ackAck) {
                this.writePacketWithAck(readWritePacket, 25);
            } else {
                readWritePacket.setSendAcknowledge(false);
                this.writePacketNoAck(readWritePacket);
            }
            Object var5_4 = null;
            readWritePacket.reset();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            readWritePacket.reset();
            throw throwable;
        }
    }

    public void acknowledge(ReadWritePacket readWritePacket) throws JMSException {
        readWritePacket.setPacketType(24);
        if (readWritePacket.getSendAcknowledge() && this.ackAck) {
            ReadOnlyPacket readOnlyPacket = this.writePacketWithReply(readWritePacket, 25);
            int n = ProtocolHandler.getReplyStatus(readOnlyPacket);
            if (n == 200) {
                return;
            }
            this.checkRemoteFailedStatus(n, readOnlyPacket);
            this.throwServerErrorException(readOnlyPacket);
        } else {
            readWritePacket.setSendAcknowledge(false);
            this.writePacketNoAck(readWritePacket);
        }
    }

    public void redeliver(ReadWritePacket readWritePacket, boolean bl, boolean bl2) throws JMSException {
        long l;
        readWritePacket.setPacketType(32);
        Hashtable<String, Comparable<Boolean>> hashtable = new Hashtable<String, Comparable<Boolean>>(1);
        hashtable.put("JMQSetRedelivered", Boolean.valueOf(bl));
        if (bl2 && (l = readWritePacket.getTransactionID()) > 0L) {
            hashtable.put("JMQTransactionID", Long.valueOf(l));
        }
        readWritePacket.setProperties(hashtable);
        this.writePacketNoAck(readWritePacket);
    }

    public long startTransaction(long l, int n, JMQXid jMQXid) throws JMSException {
        return this.startTransaction(l, n, jMQXid, false, 0L);
    }

    public long startTransaction(long l, int n, JMQXid jMQXid, long l2) throws JMSException {
        return this.startTransaction(l, n, jMQXid, true, l2);
    }

    public long startTransaction(long l, int n, JMQXid jMQXid, boolean bl, long l2) throws JMSException {
        Object object;
        ReadWritePacket readWritePacket = new ReadWritePacket();
        ByteArrayOutputStream byteArrayOutputStream = null;
        DataOutputStream dataOutputStream = null;
        byte[] byArray = null;
        readWritePacket.setPacketType(44);
        Hashtable<String, Number> hashtable = new Hashtable<String, Number>(1);
        if (bl) {
            hashtable.put("JMQSessionID", new Long(l2));
        }
        if (this.twoPhaseCommitFlag) {
            hashtable.put("JMQAutoRollback", new Integer(2));
        }
        if (n != -1) {
            hashtable.put("JMQXAFlags", new Integer(n));
            if (jMQXid != null) {
                try {
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                    jMQXid.write(dataOutputStream);
                    dataOutputStream.flush();
                    byArray = byteArrayOutputStream.toByteArray();
                    dataOutputStream.close();
                    byteArrayOutputStream.close();
                    readWritePacket.setMessageBody(byArray);
                }
                catch (IOException iOException) {
                    ExceptionHandler.handleException((Exception)iOException, "C4038");
                }
            }
        }
        readWritePacket.setProperties(hashtable);
        int n2 = -1;
        ReadOnlyPacket readOnlyPacket = this.writePacketWithReply(readWritePacket, 45);
        try {
            object = readOnlyPacket.getProperties();
            Integer n3 = (Integer)((Hashtable)object).get("JMQStatus");
            n2 = n3;
            Long l3 = (Long)((Hashtable)object).get("JMQTransactionID");
            if (l3 != null) {
                l = l3;
            }
        }
        catch (IOException iOException) {
            ExceptionHandler.handleException(iOException, "C4000", true);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ExceptionHandler.handleException(classNotFoundException, "C4000", true);
        }
        if (n2 == 409) {
            object = AdministeredObject.cr.getKString("C4028", new Long(l)) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException(new com.sun.messaging.jms.JMSException((String)object, "C4028"));
        }
        if (n2 != 200) {
            this.throwServerErrorException(readOnlyPacket);
        }
        return l;
    }

    public void endTransaction(long l, int n, JMQXid jMQXid) throws JMSException {
        ReadWritePacket readWritePacket = new ReadWritePacket();
        ByteArrayOutputStream byteArrayOutputStream = null;
        DataOutputStream dataOutputStream = null;
        byte[] byArray = null;
        readWritePacket.setPacketType(58);
        Hashtable<String, Number> hashtable = new Hashtable<String, Number>(1);
        if (l != 0L) {
            hashtable.put("JMQTransactionID", new Long(l));
        }
        if (n != -1) {
            hashtable.put("JMQXAFlags", new Integer(n));
            if (jMQXid != null) {
                try {
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                    jMQXid.write(dataOutputStream);
                    dataOutputStream.flush();
                    byArray = byteArrayOutputStream.toByteArray();
                    dataOutputStream.close();
                    byteArrayOutputStream.close();
                    readWritePacket.setMessageBody(byArray);
                }
                catch (IOException iOException) {
                    ExceptionHandler.handleException((Exception)iOException, "C4038");
                }
            }
        }
        readWritePacket.setProperties(hashtable);
        int n2 = -1;
        ReadOnlyPacket readOnlyPacket = this.writePacketWithReply(readWritePacket, 59);
        try {
            Hashtable hashtable2 = readOnlyPacket.getProperties();
            Integer n3 = (Integer)hashtable2.get("JMQStatus");
            n2 = n3;
        }
        catch (IOException iOException) {
            ExceptionHandler.handleException(iOException, "C4000", true);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ExceptionHandler.handleException(classNotFoundException, "C4000", true);
        }
        if (n2 != 200) {
            this.throwServerErrorException(readOnlyPacket);
        }
    }

    public JMQXid[] recover(int n) throws JMSException {
        JMQXid[] jMQXidArray;
        Object object;
        ReadWritePacket readWritePacket = new ReadWritePacket();
        readWritePacket.setPacketType(60);
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>(1);
        hashtable.put("JMQXAFlags", new Integer(n));
        readWritePacket.setProperties(hashtable);
        int n2 = -1;
        int n3 = 0;
        ReadOnlyPacket readOnlyPacket = this.writePacketWithReply(readWritePacket, 61);
        try {
            object = readOnlyPacket.getProperties();
            jMQXidArray = (JMQXid[])((Hashtable)object).get("JMQStatus");
            n2 = jMQXidArray.intValue();
            jMQXidArray = (Integer)((Hashtable)object).get("JMQQuantity");
            n3 = jMQXidArray.intValue();
        }
        catch (IOException iOException) {
            ExceptionHandler.handleException(iOException, "C4000", true);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ExceptionHandler.handleException(classNotFoundException, "C4000", true);
        }
        if (n2 != 200) {
            this.throwServerErrorException(readOnlyPacket);
        }
        if ((object = (Object)((ReadWritePacket)readOnlyPacket).getMessageBody()) == null || ((Object)object).length == 0) {
            jMQXidArray = new JMQXid[]{};
        } else {
            int n4 = ((Object)object).length / JMQXid.size();
            if (((Object)object).length % JMQXid.size() != 0 || n4 != n3) {
                ExceptionHandler.handleException(new StreamCorruptedException(), "C4002", true);
            }
            jMQXidArray = new JMQXid[n3];
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream((byte[])object));
            for (int i = 0; i < n3; ++i) {
                try {
                    jMQXidArray[i] = JMQXid.read(dataInputStream);
                    continue;
                }
                catch (IOException iOException) {
                    ExceptionHandler.handleException(iOException, "C4002", true);
                }
            }
        }
        return jMQXidArray;
    }

    public void endHATransaction(long l) throws JMSException {
        ReadWritePacket readWritePacket = new ReadWritePacket();
        readWritePacket.setPacketType(58);
        Hashtable<String, Number> hashtable = new Hashtable<String, Number>(1);
        if (l != 0L) {
            hashtable.put("JMQTransactionID", new Long(l));
        }
        hashtable.put("JMQXAFlags", new Integer(0x4000000));
        readWritePacket.setProperties(hashtable);
        ReadOnlyPacket readOnlyPacket = this.writePacketWithReply(readWritePacket, 59);
        int n = -1;
        Hashtable hashtable2 = ProtocolHandler.getReplyProperties(readOnlyPacket);
        Integer n2 = (Integer)hashtable2.get("JMQStatus");
        if (n2 != null) {
            n = n2;
        }
        if (n != 200 && n != 304) {
            String string = AdministeredObject.cr.getKString("C4104", String.valueOf(l), String.valueOf(n)) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException(new com.sun.messaging.jms.JMSException(string, "C4104"));
        }
    }

    public void prepareHATransaction(long l) throws JMSException {
        int n = -1;
        ReadWritePacket readWritePacket = new ReadWritePacket();
        readWritePacket.setPacketType(56);
        Hashtable<String, Long> hashtable = new Hashtable<String, Long>(1);
        hashtable.put("JMQTransactionID", new Long(l));
        readWritePacket.setProperties(hashtable);
        ReadOnlyPacket readOnlyPacket = this.writePacketWithReply(readWritePacket, 57);
        Hashtable hashtable2 = ProtocolHandler.getReplyProperties(readOnlyPacket);
        Integer n2 = (Integer)hashtable2.get("JMQStatus");
        if (n2 != null) {
            n = n2;
        }
        if (n != 200 && n != 304) {
            this.checkRemoteFailedStatus(n, readOnlyPacket);
            String string = AdministeredObject.cr.getKString("C4101", String.valueOf(l), String.valueOf(n)) + this.getUserBrokerInfo();
            JMSException jMSException = null;
            jMSException = n == 408 ? new TransactionRolledBackException(string, "C4101") : new com.sun.messaging.jms.JMSException(string, "C4101");
            ExceptionHandler.throwJMSException(jMSException);
        }
    }

    public void commitHATransaction(long l) throws JMSException {
        int n = -1;
        ReadWritePacket readWritePacket = new ReadWritePacket();
        readWritePacket.setPacketType(46);
        Hashtable<String, Long> hashtable = new Hashtable<String, Long>(1);
        hashtable.put("JMQTransactionID", new Long(l));
        readWritePacket.setProperties(hashtable);
        ReadOnlyPacket readOnlyPacket = null;
        readOnlyPacket = this.writePacketWithReply(readWritePacket, 47);
        n = ProtocolHandler.getReplyStatus(readOnlyPacket);
        switch (n) {
            case 200: {
                return;
            }
            case 408: {
                ExceptionHandler.throwJMSException(new TransactionRolledBackException("Timeout"));
            }
            case 410: {
                this.checkRemoteFailedStatus(n, readOnlyPacket);
            }
        }
        Debug.getPrintStream().println("**** Tranaction ERROR, statusCode " + n);
        this.throwServerErrorException(readOnlyPacket);
    }

    public int verifyHATransaction(long l, int n) throws JMSException {
        return this.verifyHATransaction(l, n, null);
    }

    public int verifyHATransaction(long l, int n, JMQXid jMQXid) throws JMSException {
        Hashtable hashtable;
        Integer n2;
        ReadWritePacket readWritePacket = new ReadWritePacket();
        ByteArrayOutputStream byteArrayOutputStream = null;
        DataOutputStream dataOutputStream = null;
        byte[] byArray = null;
        readWritePacket.setPacketType(78);
        Hashtable<String, Long> hashtable2 = new Hashtable<String, Long>(1);
        hashtable2.put("JMQTransactionID", new Long(l));
        if (jMQXid != null) {
            try {
                byteArrayOutputStream = new ByteArrayOutputStream();
                dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                jMQXid.write(dataOutputStream);
                dataOutputStream.flush();
                byArray = byteArrayOutputStream.toByteArray();
                dataOutputStream.close();
                byteArrayOutputStream.close();
                readWritePacket.setMessageBody(byArray);
            }
            catch (IOException iOException) {
                ExceptionHandler.handleException((Exception)iOException, "C4038");
            }
        }
        readWritePacket.setProperties(hashtable2);
        int n3 = -1;
        int n4 = -1;
        ReadOnlyPacket readOnlyPacket = this.writePacketWithReply(readWritePacket, 79);
        Hashtable hashtable3 = ProtocolHandler.getReplyProperties(readOnlyPacket);
        Integer n5 = (Integer)hashtable3.get("JMQStatus");
        n3 = n5;
        if (n3 == 200 && (n2 = (Integer)(hashtable = ReadChannel.getHashtableFromMessageBody(readOnlyPacket)).get("State")) != null) {
            n4 = n2;
        }
        if (n3 == 404) {
            if (n == 1) {
                n4 = 8;
            } else if (n == 2) {
                n4 = 7;
            }
        } else if (n3 != 200) {
            this.throwServerErrorException(readOnlyPacket);
        }
        if (this.debug) {
            Debug.println(new Date().toString() + " transaction state: " + n4);
        }
        return n4;
    }

    public void prepare(long l, JMQXid jMQXid) throws JMSException {
        this.prepare(l, jMQXid, false);
    }

    public void prepare(long l, JMQXid jMQXid, boolean bl) throws JMSException {
        ReadWritePacket readWritePacket = new ReadWritePacket();
        ByteArrayOutputStream byteArrayOutputStream = null;
        DataOutputStream dataOutputStream = null;
        byte[] byArray = null;
        readWritePacket.setPacketType(56);
        Hashtable<String, Constable> hashtable = null;
        if (l != 0L) {
            hashtable = new Hashtable<String, Constable>(1);
            hashtable.put("JMQTransactionID", new Long(l));
        }
        if (bl) {
            if (hashtable == null) {
                hashtable = new Hashtable(1);
            }
            hashtable.put("JMQXAOnePhase", Boolean.TRUE);
        }
        if (hashtable != null) {
            readWritePacket.setProperties(hashtable);
        }
        if (jMQXid != null) {
            try {
                byteArrayOutputStream = new ByteArrayOutputStream();
                dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                jMQXid.write(dataOutputStream);
                dataOutputStream.flush();
                byArray = byteArrayOutputStream.toByteArray();
                dataOutputStream.close();
                byteArrayOutputStream.close();
                readWritePacket.setMessageBody(byArray);
            }
            catch (IOException iOException) {
                ExceptionHandler.handleException((Exception)iOException, "C4038");
            }
        }
        int n = -1;
        ReadOnlyPacket readOnlyPacket = this.writePacketWithReply(readWritePacket, 57);
        try {
            Hashtable hashtable2 = readOnlyPacket.getProperties();
            Integer n2 = (Integer)hashtable2.get("JMQStatus");
            n = n2;
        }
        catch (IOException iOException) {
            ExceptionHandler.handleException(iOException, "C4000", true);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ExceptionHandler.handleException(classNotFoundException, "C4000", true);
        }
        if (n != 200) {
            this.checkRemoteFailedStatus(n, readOnlyPacket);
            this.throwServerErrorException(readOnlyPacket);
        }
    }

    public Hashtable getLicense() throws JMSException {
        Hashtable hashtable = null;
        ReadWritePacket readWritePacket = new ReadWritePacket();
        readWritePacket.setPacketType(76);
        int n = -1;
        ReadOnlyPacket readOnlyPacket = this.writePacketWithReply(readWritePacket, 77);
        try {
            hashtable = readOnlyPacket.getProperties();
            Integer n2 = (Integer)hashtable.get("JMQStatus");
            n = n2;
        }
        catch (IOException iOException) {
            ExceptionHandler.handleException(iOException, "C4000", true);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ExceptionHandler.handleException(classNotFoundException, "C4000", true);
        }
        if (n != 200) {
            this.throwServerErrorException(readOnlyPacket);
        }
        return hashtable;
    }

    public long generateUID() throws JMSException {
        Object object;
        Object object2;
        long l = 0L;
        ReadWritePacket readWritePacket = new ReadWritePacket();
        readWritePacket.setPacketType(62);
        int n = -1;
        ReadOnlyPacket readOnlyPacket = this.writePacketWithReply(readWritePacket, 63);
        try {
            object2 = readOnlyPacket.getProperties();
            object = (Integer)((Hashtable)object2).get("JMQQuantity");
            object = (Integer)((Hashtable)object2).get("JMQStatus");
            n = (Integer)object;
        }
        catch (IOException iOException) {
            ExceptionHandler.handleException(iOException, "C4000", true);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ExceptionHandler.handleException(classNotFoundException, "C4000", true);
        }
        if (n != 200) {
            this.throwServerErrorException(readOnlyPacket);
        }
        object2 = ((ReadWritePacket)readOnlyPacket).getMessageBody();
        object = new DataInputStream(new ByteArrayInputStream((byte[])object2));
        try {
            l = ((DataInputStream)object).readLong();
        }
        catch (IOException iOException) {
            ExceptionHandler.handleException(iOException, "C4002", true);
        }
        return l;
    }

    public void rollback(long l, JMQXid jMQXid) throws JMSException {
        this._rollbackXA(l, jMQXid, false, false);
    }

    public void rollback(long l, JMQXid jMQXid, boolean bl) throws JMSException {
        this._rollbackXA(l, jMQXid, bl, false);
    }

    public void rollback(long l, JMQXid jMQXid, boolean bl, boolean bl2) throws JMSException {
        this._rollbackXA(l, jMQXid, bl, bl2);
    }

    private void _rollbackXA(long l, JMQXid jMQXid, boolean bl, boolean bl2) throws JMSException {
        ReadWritePacket readWritePacket = new ReadWritePacket();
        ByteArrayOutputStream byteArrayOutputStream = null;
        DataOutputStream dataOutputStream = null;
        byte[] byArray = null;
        Hashtable<String, Constable> hashtable = null;
        readWritePacket.setPacketType(48);
        if (bl2) {
            readWritePacket.setIndempotent(true);
        }
        if (l != 0L || bl) {
            hashtable = new Hashtable<String, Constable>(l != 0L && bl ? 2 : 1);
            if (l != 0L) {
                hashtable.put("JMQTransactionID", new Long(l));
            }
            if (bl) {
                hashtable.put("JMQRedeliver", Boolean.valueOf(bl));
            }
            readWritePacket.setProperties(hashtable);
        }
        if (jMQXid != null) {
            try {
                byteArrayOutputStream = new ByteArrayOutputStream();
                dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                jMQXid.write(dataOutputStream);
                dataOutputStream.flush();
                byArray = byteArrayOutputStream.toByteArray();
                dataOutputStream.close();
                byteArrayOutputStream.close();
                readWritePacket.setMessageBody(byArray);
            }
            catch (IOException iOException) {
                ExceptionHandler.handleException((Exception)iOException, "C4038");
            }
        }
        ReadOnlyPacket readOnlyPacket = this.writePacketWithReply(readWritePacket, 49);
        int n = ProtocolHandler.getReplyStatus(readOnlyPacket);
        if (n == 400) {
            String string = AdministeredObject.cr.getKString("C4027", new Long(l)) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException(new com.sun.messaging.jms.JMSException(string, "C4027"));
        }
        if (n != 200) {
            this.throwServerErrorException(readOnlyPacket);
        }
    }

    public long commit(long l, int n, JMQXid jMQXid) throws JMSException {
        return this.commit(l, n, jMQXid, false);
    }

    public long commit(long l, int n, JMQXid jMQXid, boolean bl) throws JMSException {
        long l2 = -1L;
        ReadWritePacket readWritePacket = new ReadWritePacket();
        ByteArrayOutputStream byteArrayOutputStream = null;
        DataOutputStream dataOutputStream = null;
        byte[] byArray = null;
        readWritePacket.setPacketType(46);
        Hashtable<String, Constable> hashtable = new Hashtable<String, Constable>(1);
        if (l != 0L) {
            hashtable.put("JMQTransactionID", new Long(l));
        }
        if (bl) {
            hashtable.put("JMQXAOnePhase", Boolean.TRUE);
        }
        if (SessionImpl.autoStartTxn) {
            hashtable.put("JMQStartNextTransaction", Boolean.TRUE);
        }
        if (jMQXid != null) {
            hashtable.put("JMQXAFlags", new Integer(n));
            try {
                byteArrayOutputStream = new ByteArrayOutputStream();
                dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                jMQXid.write(dataOutputStream);
                dataOutputStream.flush();
                byArray = byteArrayOutputStream.toByteArray();
                dataOutputStream.close();
                byteArrayOutputStream.close();
                readWritePacket.setMessageBody(byArray);
            }
            catch (IOException iOException) {
                ExceptionHandler.handleException((Exception)iOException, "C4038");
            }
        }
        readWritePacket.setProperties(hashtable);
        ReadOnlyPacket readOnlyPacket = this.writePacketWithReply(readWritePacket, 47);
        int n2 = ProtocolHandler.getReplyStatus(readOnlyPacket);
        l2 = ProtocolHandler.getNextTransactionID(readOnlyPacket);
        if (n2 == 200) {
            return l2;
        }
        if (n2 == 400) {
            String string = AdministeredObject.cr.getKString("C4027", new Long(l)) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException(new com.sun.messaging.jms.JMSException(string, "C4027"));
        }
        this.checkRemoteFailedStatus(n2, readOnlyPacket);
        this.throwServerErrorException(readOnlyPacket);
        return l2;
    }

    public void rollback(long l) throws JMSException {
        ReadWritePacket readWritePacket = new ReadWritePacket();
        readWritePacket.setPacketType(48);
        Hashtable<String, Long> hashtable = new Hashtable<String, Long>(1);
        hashtable.put("JMQTransactionID", new Long(l));
        readWritePacket.setProperties(hashtable);
        this.writePacketNoAck(readWritePacket);
    }

    protected void verifyDestination(javax.jms.Destination destination, String string, boolean bl) throws JMSException {
        Object object;
        Destination destination2 = (Destination)destination;
        ReadWritePacket readWritePacket = new ReadWritePacket();
        readWritePacket.setPacketType(40);
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(3);
        hashtable.put("JMQDestination", destination2.getName());
        hashtable.put("JMQDestType", this.getDestinationType(destination2));
        if (string != null) {
            hashtable.put("JMQSelector", string);
        }
        readWritePacket.setProperties(hashtable);
        ReadOnlyPacket readOnlyPacket = this.writePacketWithReply(readWritePacket, 41);
        int n = -1;
        try {
            Boolean bl2;
            object = readOnlyPacket.getProperties();
            n = (Integer)((Hashtable)object).get("JMQStatus");
            if (bl && n == 404 && (bl2 = (Boolean)((Hashtable)object).get("JMQCanCreate")) != null && bl2.booleanValue()) {
                return;
            }
        }
        catch (IOException iOException) {
            ExceptionHandler.handleException(iOException, "C4000", true);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ExceptionHandler.handleException(classNotFoundException, "C4000", true);
        }
        if (n == 400 && string != null) {
            object = AdministeredObject.cr.getKString("C4022", string) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException(new InvalidSelectorException((String)object, "C4022"));
        }
        if (n == 404) {
            object = AdministeredObject.cr.getKString("C4019", destination2.getName()) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException(new InvalidDestinationException((String)object, "C4019"));
        }
        if (n == 403) {
            object = AdministeredObject.cr.getKString("C4082", destination2.getName()) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException(new JMSSecurityException((String)object, "C4082"));
        }
        if (n != 200) {
            this.throwServerErrorException(readOnlyPacket);
        }
    }

    protected SysMessageID[] browse(Consumer consumer) throws JMSException {
        SysMessageID[] sysMessageIDArray;
        Object object;
        Destination destination = (Destination)consumer.getDestination();
        String string = consumer.getMessageSelector();
        ReadWritePacket readWritePacket = new ReadWritePacket();
        readWritePacket.setPacketType(26);
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(2);
        hashtable.put("JMQDestination", destination.getName());
        hashtable.put("JMQDestType", this.getDestinationType(destination));
        if (string != null) {
            hashtable.put("JMQSelector", string);
        }
        hashtable.put(REQUEST_META_DATA, consumer);
        readWritePacket.setProperties(hashtable);
        ReadOnlyPacket readOnlyPacket = this.writePacketWithReply(readWritePacket, 27);
        int n = -1;
        try {
            object = readOnlyPacket.getProperties();
            n = (Integer)((Hashtable)object).get("JMQStatus");
            if (n == 404 && (sysMessageIDArray = (SysMessageID[])((Hashtable)object).get("JMQCanCreate")) != null && sysMessageIDArray.booleanValue()) {
                return new SysMessageID[0];
            }
        }
        catch (IOException iOException) {
            ExceptionHandler.handleException(iOException, "C4000", true);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ExceptionHandler.handleException(classNotFoundException, "C4000", true);
        }
        if (n == 400 && string != null) {
            object = AdministeredObject.cr.getKString("C4022", string) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException(new InvalidSelectorException((String)object, "C4022"));
        }
        if (n == 404) {
            object = AdministeredObject.cr.getKString("C4019", destination.getName()) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException(new InvalidDestinationException((String)object, "C4019"));
        }
        if (n == 403) {
            object = AdministeredObject.cr.getKString("C4083", destination.getName()) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException(new JMSSecurityException((String)object, "C4083"));
        }
        if (n != 200) {
            this.throwServerErrorException(readOnlyPacket);
        }
        if ((object = (Object)((ReadWritePacket)readOnlyPacket).getMessageBody()) == null || ((Object)object).length == 0) {
            sysMessageIDArray = new SysMessageID[]{};
        } else {
            if (((Object)object).length % 32 != 0) {
                ExceptionHandler.handleException(new StreamCorruptedException(), "C4002", true);
            }
            int n2 = ((Object)object).length / 32;
            sysMessageIDArray = new SysMessageID[n2];
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream((byte[])object));
            for (int i = 0; i < n2; ++i) {
                sysMessageIDArray[i] = new SysMessageID();
                try {
                    sysMessageIDArray[i].readID(dataInputStream);
                    continue;
                }
                catch (IOException iOException) {
                    ExceptionHandler.handleException(iOException, "C4002", true);
                }
            }
        }
        return sysMessageIDArray;
    }

    protected boolean deliver(ByteArrayOutputStream byteArrayOutputStream, Consumer consumer) throws JMSException {
        ReadWritePacket readWritePacket = new ReadWritePacket();
        readWritePacket.setMessageBody(byteArrayOutputStream.toByteArray());
        readWritePacket.setPacketType(42);
        Hashtable<String, Long> hashtable = new Hashtable<String, Long>(1);
        hashtable.put("JMQConsumerID", consumer.getInterestId());
        readWritePacket.setProperties(hashtable);
        ReadOnlyPacket readOnlyPacket = this.writePacketWithReply(readWritePacket, 43);
        int n = ProtocolHandler.getReplyStatus(readOnlyPacket);
        if (n == 404) {
            return false;
        }
        if (n == 200) {
            return true;
        }
        this.throwServerErrorException(readOnlyPacket);
        return false;
    }

    public void suspendMessageDelivery() throws JMSException {
        this.stop();
    }

    public void resumeMessageDelivery() throws JMSException {
        this.start();
    }

    public void createSession(SessionImpl sessionImpl) throws JMSException {
        Cloneable cloneable;
        ReadWritePacket readWritePacket = new ReadWritePacket();
        readWritePacket.setPacketType(68);
        if (!sessionImpl.isTransacted) {
            cloneable = new Hashtable(1);
            ((Hashtable)cloneable).put("JMQAckMode", new Integer(sessionImpl.acknowledgeMode));
            readWritePacket.setProperties((Hashtable)cloneable);
        }
        cloneable = this.writePacketWithReply(readWritePacket, 69);
        int n = -1;
        long l = -1L;
        try {
            Hashtable hashtable = ((ReadOnlyPacket)cloneable).getProperties();
            n = (Integer)hashtable.get("JMQStatus");
            Long l2 = (Long)hashtable.get("JMQSessionID");
            if (l2 != null) {
                l = l2;
            }
        }
        catch (IOException iOException) {
            ExceptionHandler.handleException(iOException, "C4000", true);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ExceptionHandler.handleException(classNotFoundException, "C4000", true);
        }
        if (n != 200) {
            this.throwServerErrorException((ReadOnlyPacket)cloneable);
        }
        sessionImpl.setBrokerSessionID(l);
        if (this.debug) {
            Debug.println("Added session, JMQSessionID: " + sessionImpl.getBrokerSessionID());
        }
    }

    public void deleteSession(SessionImpl sessionImpl) throws JMSException {
        ReadWritePacket readWritePacket = new ReadWritePacket();
        readWritePacket.setPacketType(70);
        Hashtable<String, Long> hashtable = new Hashtable<String, Long>(1);
        hashtable.put("JMQSessionID", new Long(sessionImpl.getBrokerSessionID()));
        readWritePacket.setProperties(hashtable);
        ReadOnlyPacket readOnlyPacket = this.writePacketWithReply(readWritePacket, 71);
        int n = ProtocolHandler.getReplyStatus(readOnlyPacket);
        if (n != 200) {
            this.throwServerErrorException(readOnlyPacket);
        }
    }

    protected static long getNextTransactionID(ReadOnlyPacket readOnlyPacket) throws JMSException {
        long l = -1L;
        Hashtable hashtable = ProtocolHandler.getReplyProperties(readOnlyPacket);
        Long l2 = (Long)hashtable.get("JMQNextTransactionID");
        if (l2 != null) {
            l = l2;
        }
        return l;
    }

    protected static int getReplyStatus(ReadOnlyPacket readOnlyPacket) throws JMSException {
        int n = -1;
        Hashtable hashtable = ProtocolHandler.getReplyProperties(readOnlyPacket);
        Integer n2 = (Integer)hashtable.get("JMQStatus");
        n = n2;
        return n;
    }

    protected static Hashtable getReplyProperties(ReadOnlyPacket readOnlyPacket) throws JMSException {
        Hashtable hashtable = null;
        try {
            hashtable = readOnlyPacket.getProperties();
        }
        catch (IOException iOException) {
            ExceptionHandler.handleException(iOException, "C4005", true);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ExceptionHandler.handleException(classNotFoundException, "C4005", true);
        }
        return hashtable;
    }

    protected void checkReplyType(ReadOnlyPacket readOnlyPacket, int n) throws JMSException {
        int n2 = readOnlyPacket.getPacketType();
        if (n2 != n) {
            String string = AdministeredObject.cr.getKString("C4093", PacketType.getString(n), PacketType.getString(n2)) + this.getUserBrokerInfo();
            ExceptionHandler.throwJMSException(new com.sun.messaging.jms.JMSException(string, "C4093"));
        }
    }

    public void throwServerErrorException(ReadOnlyPacket readOnlyPacket) throws JMSException {
        Serializable serializable;
        com.sun.messaging.jms.JMSException jMSException;
        String string;
        block5: {
            string = AdministeredObject.cr.getKString("C4036");
            jMSException = null;
            try {
                serializable = ProtocolHandler.getReplyProperties(readOnlyPacket);
                String string2 = (String)((Hashtable)serializable).get("JMQReason");
                Integer n = (Integer)((Hashtable)serializable).get("JMQStatus");
                if (string2 != null) {
                    int n2 = readOnlyPacket.getPacketType();
                    String string3 = PacketType.getString(n2);
                    string = "[" + string3 + "] " + string + " :[" + n + "] " + string2;
                }
                string = string + this.getUserBrokerInfo();
                if (n != null) {
                    jMSException = new com.sun.messaging.jms.JMSException(string, Status.getString(n));
                }
            }
            catch (Exception exception) {
                if (!this.debug) break block5;
                Debug.printStackTrace(exception);
            }
        }
        serializable = new com.sun.messaging.jms.JMSException(string, "C4036");
        if (jMSException != null) {
            ((com.sun.messaging.jms.JMSException)serializable).setLinkedException(jMSException);
        }
        ExceptionHandler.throwJMSException((JMSException)serializable);
    }

    public void checkRemoteFailedStatus(int n, ReadOnlyPacket readOnlyPacket) throws JMSException {
        if (n != 410) {
            return;
        }
        Hashtable hashtable = ProtocolHandler.getReplyProperties(readOnlyPacket);
        if (hashtable == null) {
            return;
        }
        Boolean bl = (Boolean)hashtable.get("JMQRemote");
        if (bl != null && bl.booleanValue()) {
            String string = AdministeredObject.cr.getKString("C4110");
            RemoteAcknowledgeException remoteAcknowledgeException = new RemoteAcknowledgeException(string, "C4110");
            remoteAcknowledgeException.setProperties(hashtable);
            ExceptionHandler.throwJMSException(remoteAcknowledgeException);
        }
    }

    public void abort() {
        try {
            this.connectionHandler.close();
        }
        catch (Exception exception) {
            ExceptionHandler.logCaughtException(exception);
            Debug.printStackTrace(exception);
        }
    }

    public void ping() throws JMSException {
        ReadWritePacket readWritePacket = new ReadWritePacket();
        readWritePacket.setPacketType(54);
        if (this.imqAbortOnTimeout && this.timeout > 0) {
            readWritePacket.setFlag(16, true);
            this.setPingTimeStamp();
        }
        this.writePacketNoAck(readWritePacket);
    }

    public void pingReply(ReadOnlyPacket readOnlyPacket) throws JMSException {
        ReadWritePacket readWritePacket = new ReadWritePacket();
        readWritePacket.setPacketType(55);
        long l = readOnlyPacket.getConsumerID();
        readWritePacket.setConsumerID(l);
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>(1);
        hashtable.put("JMQStatus", new Integer(200));
        readWritePacket.setProperties(hashtable);
        this.writePacketNoAck(readWritePacket);
    }

    public ConnectionHandler getConnectionHandler() {
        return this.connectionHandler;
    }

    protected String getUserBrokerInfo() {
        String string = this.connection.getUserName();
        if (string == null) {
            string = "null";
        } else if (string.length() == 0) {
            string = "empty/blank";
        }
        String string2 = null;
        string2 = this.connectionHandler == null ? "unavailable" : this.connectionHandler.getBrokerAddress();
        return " user=" + string + ", broker=" + string2;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void redirect(String string) throws JMSException {
        block4: {
            if (this.debug) {
                Debug.info("ProtocolHandler: redirect connection to the URL : " + string);
            }
            try {
                this.close();
            }
            catch (Exception exception) {
                ExceptionHandler.logCaughtException(exception);
                if (!this.debug) break block4;
                Debug.printStackTrace(exception);
            }
        }
        this.connection.initiator.setRedirectURL(string);
        this.init(true);
        if (this.debug) {
            Debug.info("*** ProtocolHandler: connection redirected to the URL: " + string);
        }
    }

    public void resend(ReadWritePacket readWritePacket) throws JMSException {
        readWritePacket.setFlag(2048, true);
        this.writePacketNoAck(readWritePacket);
    }

    public void setDebugInboundPkt(boolean bl) {
        this.debugInboundPkt = bl;
    }

    public void setDebugOutboundPkt(boolean bl) {
        this.debugOutboundPkt = bl;
    }

    public void setPktFilter(String string) {
        this.pktFilter = string;
    }

    protected boolean isClientIDsent() {
        return this.sentSetClientID;
    }

    public boolean isDirectMode() {
        return this.connectionHandler.isDirectMode();
    }

    public boolean isDirectModeTwoThread() {
        return this.isDirectMode() && BrokerInstanceImpl.isTwoThread;
    }

    public boolean isDirectModeTwoThreadWithSyncReplies() {
        return this.isDirectModeTwoThread() && BrokerInstanceImpl.isTwoThreadSyncReplies;
    }

    public String toString() {
        return this.connectionHandler.toString();
    }

    private void setXMLValidation(Destination destination, ReadOnlyPacket readOnlyPacket) throws JMSException {
        if (turnOffXMLValidation) {
            return;
        }
        try {
            Hashtable hashtable = ProtocolHandler.getReplyProperties(readOnlyPacket);
            Object v = hashtable.get("JMQValidateXMLSchema");
            boolean bl = false;
            if (v != null) {
                bl = (Boolean)v;
            }
            if (bl) {
                XMLValidator xMLValidator = null;
                String string = null;
                Object v2 = hashtable.get("JMQXMLSchemaURIList");
                if (v2 != null) {
                    string = (String)v2;
                    xMLValidator = ValidatorFactory.newValidator(string);
                    Object v3 = hashtable.get("JMQReloadXMLSchemaOnFailure");
                    if (v3 != null) {
                        boolean bl2 = (Boolean)v3;
                        xMLValidator.setReloadOnFailure(bl2);
                    }
                } else {
                    xMLValidator = ValidatorFactory.newValidator();
                }
                if (!this.xmlValidationTable.containsKey(destination)) {
                    this.xmlValidationTable.put(destination, xMLValidator);
                    if (this.debug) {
                        Debug.println("Adding xml validation entry for destination: " + destination.getName() + ", uriList: " + string);
                    }
                }
            }
        }
        catch (Exception exception) {
            ExceptionHandler.handleException(exception, "C4005", true);
        }
    }

    public void setReplyDispatcher(PacketDispatcher packetDispatcher) {
        if (this.isDirectModeTwoThread()) {
            ((DirectConnectionHandler)this.connectionHandler).setReplyDispatcher(packetDispatcher);
        }
    }

    public long getConnID() {
        if (this.isDirectMode()) {
            return this.connection.getConnectionID();
        }
        return this.getLocalPort();
    }
}

