/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util.synchronizer;

import com.sun.messaging.jmq.util.synchronizer.CloseInProgressCallback;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CloseInProgressSynchronizer {
    private static final long WAIT_INTERVAL = 15000L;
    private boolean closed = false;
    private Object closedLock = new Object();
    private int inprogressCount = 0;
    private Object inprogressLock = new Object();
    private Object logger = null;

    public CloseInProgressSynchronizer(Object object) {
        this.logger = object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.closedLock;
        synchronized (object) {
            this.closed = true;
            this.closedLock.notifyAll();
        }
        object = this.inprogressLock;
        synchronized (object) {
            this.inprogressCount = 0;
            this.inprogressLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClosedAndWait(CloseInProgressCallback closeInProgressCallback, String string) {
        Object object = this.closedLock;
        synchronized (object) {
            this.closed = true;
        }
        if (closeInProgressCallback != null) {
            closeInProgressCallback.beforeWaitAfterSetClosed();
        }
        object = this.inprogressLock;
        synchronized (object) {
            long l;
            this.inprogressLock.notifyAll();
            if (this.inprogressCount == 0) {
                return;
            }
            this.logInfo(string);
            long l2 = l = System.currentTimeMillis();
            while (this.inprogressCount > 0) {
                try {
                    if (l - l2 >= 15000L) {
                        this.logInfo(string);
                        l2 = l;
                    }
                    this.inprogressLock.wait(15000L);
                    if (this.inprogressCount <= 0) continue;
                    l = System.currentTimeMillis();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClosedAndWaitWithTimeout(CloseInProgressCallback closeInProgressCallback, int n, String string) throws InterruptedException, TimeoutException {
        long l;
        if (n <= 0) {
            this.setClosedAndWait(closeInProgressCallback, string);
            return;
        }
        Object object = this.closedLock;
        synchronized (object) {
            this.closed = true;
        }
        if (closeInProgressCallback != null) {
            closeInProgressCallback.beforeWaitAfterSetClosed();
        }
        long l2 = l = (long)n * 1000L;
        Object object2 = this.inprogressLock;
        synchronized (object2) {
            long l3;
            this.inprogressLock.notifyAll();
            if (this.inprogressCount == 0) {
                return;
            }
            this.logInfo(string);
            long l4 = l3 = System.currentTimeMillis();
            long l5 = 0L;
            long l6 = 0L;
            while (this.inprogressCount > 0 && l2 > 0L) {
                if (l3 - l5 > 15000L) {
                    this.logInfo(string);
                    l5 = l3;
                }
                this.inprogressLock.wait(l2);
                l4 = l3;
                l3 = System.currentTimeMillis();
                l6 += l3 - l4 > 0L ? l3 - l4 : 0L;
                if (this.inprogressCount <= 0) continue;
                l2 = l - l6;
            }
            if (this.inprogressCount > 0) {
                throw new TimeoutException("timeout");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkClosedAndSetInProgress() throws IllegalAccessException {
        Object object = this.closedLock;
        synchronized (object) {
            if (this.closed) {
                throw new IllegalAccessException("closed");
            }
            this.setInProgress(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInProgress(boolean bl) {
        Object object = this.inprogressLock;
        synchronized (object) {
            this.inprogressCount = bl ? ++this.inprogressCount : --this.inprogressCount;
            if (this.inprogressCount == 0) {
                this.inprogressLock.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkClosedAndSetInProgressWithWait(int n, String string) throws IllegalStateException, InterruptedException, TimeoutException {
        Object object = this.closedLock;
        synchronized (object) {
            if (this.closed) {
                throw new IllegalStateException("closed");
            }
            this.setInProgressWithWait(n, string);
        }
    }

    private void setInProgressWithWait(int n, String string) throws IllegalStateException, InterruptedException, TimeoutException {
        Object object = this.inprogressLock;
        synchronized (object) {
            long l;
            if (this.inprogressCount == 0) {
                ++this.inprogressCount;
                return;
            }
            long l2 = (long)n * 1000L;
            long l3 = l2 <= 0L || l2 > 15000L ? 15000L : l2;
            this.logInfo(string);
            long l4 = l = System.currentTimeMillis();
            long l5 = 0L;
            long l6 = 0L;
            while (this.inprogressCount > 0 && !this.closed && l3 > 0L) {
                if (l - l5 > 15000L) {
                    this.logInfo(string);
                    l5 = l;
                }
                this.inprogressLock.wait(l3);
                l4 = l;
                l = System.currentTimeMillis();
                l6 += l - l4 > 0L ? l - l4 : 0L;
                if (this.inprogressCount > 0) {
                    long l7 = l3 = l2 <= 0L ? 15000L : l2 - l6;
                }
                if (l3 <= 15000L) continue;
                l3 = 15000L;
            }
            if (this.closed) {
                throw new IllegalStateException("closed");
            }
            if (this.inprogressCount == 0) {
                ++this.inprogressCount;
                return;
            }
            throw new TimeoutException("timeout");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = this.closedLock;
        synchronized (object) {
            return this.closed;
        }
    }

    private void logInfo(String string) {
        if (this.logger instanceof com.sun.messaging.jmq.util.log.Logger) {
            ((com.sun.messaging.jmq.util.log.Logger)this.logger).log(8, string);
        } else if (this.logger instanceof Logger) {
            ((Logger)this.logger).log(Level.INFO, string);
        } else {
            System.out.println("INFO: " + string);
        }
    }
}

