/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.sharecc;

import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.UID;
import java.util.List;

public abstract class ShareConfigChangeStore {
    private static boolean DEBUG = false;
    public static final String STORE_TYPE_PROP = "imq.cluster.ccsharestore";
    public static final String CREATE_STORE_PROP = "imq.cluster.ccsharestoreCreate";
    public static final boolean CREATE_STORE_PROP_DEFAULT = false;
    private static final String CLASS_PROP_SUFFIX = ".class";
    private static final String DEFAULT_STORE_TYPE = "jdbc";
    private static final String DEFAULT_JDBCSTORE_CLASS = "com.sun.messaging.jmq.jmsserver.persist.jdbc.sharecc.JDBCShareConfigChangeStore";
    private static ShareConfigChangeStore store = null;

    public static boolean getDEBUG() {
        return DEBUG;
    }

    public static synchronized ShareConfigChangeStore getStore() throws BrokerException {
        if (store != null) {
            return store;
        }
        if (BrokerStateHandler.shuttingDown) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4140"), "B4140");
        }
        BrokerConfig brokerConfig = Globals.getConfig();
        String string = brokerConfig.getProperty(STORE_TYPE_PROP, DEFAULT_STORE_TYPE);
        if (!string.toLowerCase().equals(DEFAULT_STORE_TYPE)) {
            throw new BrokerException("Not supportedimq.cluster.ccsharestore=" + string);
        }
        String string2 = "imq.cluster.ccsharestore." + string + CLASS_PROP_SUFFIX;
        String string3 = brokerConfig.getProperty(string2);
        if (string3 == null || string3.equals("")) {
            string3 = DEFAULT_JDBCSTORE_CLASS;
        } else if (!string3.equals(DEFAULT_JDBCSTORE_CLASS)) {
            throw new BrokerException("Not supported " + string2 + "=" + string3);
        }
        try {
            store = (ShareConfigChangeStore)Class.forName(string3).newInstance();
        }
        catch (Exception exception) {
            throw new BrokerException("XXXI18N Open share configure change store failed");
        }
        return store;
    }

    public static synchronized void releaseStore(boolean bl) {
        if (store != null) {
            store.close();
        }
        store = null;
    }

    public void storeChangeRecord(UID uID, byte[] byArray, long l, boolean bl) throws BrokerException {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    public List getChangeRecordsSince(long l) throws BrokerException {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    public List getAllChangeRecords() throws BrokerException {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    public void clearAllChangeRecords(boolean bl) throws BrokerException {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    public abstract void close();
}

