/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.mbeans;

import com.sun.messaging.jmq.Version;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.ConfigListener;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.ResetMetricsHandler;
import com.sun.messaging.jmq.jmsserver.management.agent.Agent;
import com.sun.messaging.jmq.jmsserver.management.mbeans.MQMBeanReadWrite;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import javax.management.AttributeChangeNotification;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;

public class BrokerConfig
extends MQMBeanReadWrite
implements ConfigListener {
    private Properties brokerProps = null;
    private static MBeanAttributeInfo[] attrs;
    private static MBeanParameterInfo[] shutdownSignature;
    private static MBeanParameterInfo[] takeoverSignature;
    private static MBeanParameterInfo[] getPropertySignature;
    private static MBeanOperationInfo[] ops;
    private static String[] attrChangeTypes;
    private static MBeanNotificationInfo[] notifs;

    public BrokerConfig() {
        this.initProps();
        com.sun.messaging.jmq.jmsserver.config.BrokerConfig brokerConfig = Globals.getConfig();
        brokerConfig.addListener("imq.portmapper.port", this);
    }

    public String getBrokerID() {
        return Globals.getBrokerID();
    }

    public String getInstanceName() {
        return this.brokerProps.getProperty("imq.instancename");
    }

    public String getHost() {
        return Globals.getBrokerHostName();
    }

    public Integer getPort() throws MBeanException {
        String string = this.brokerProps.getProperty("imq.portmapper.port");
        Integer n = null;
        try {
            n = new Integer(string);
        }
        catch (Exception exception) {
            this.handleGetterException("Port", exception);
        }
        return n;
    }

    public void setPort(Integer n) throws MBeanException {
        Integer n2 = this.getPort();
        Properties properties = new Properties();
        properties.setProperty("imq.portmapper.port", n.toString());
        try {
            com.sun.messaging.jmq.jmsserver.config.BrokerConfig brokerConfig = Globals.getConfig();
            brokerConfig.updateProperties(properties, true);
        }
        catch (Exception exception) {
            this.handleSetterException("Port", exception);
        }
    }

    public String getVersion() {
        return this.brokerProps.getProperty("imq.product.version");
    }

    public void quiesce() throws MBeanException {
        BrokerStateHandler brokerStateHandler = Globals.getBrokerStateHandler();
        this.logger.log(8, "Quiesce request received by MBean " + this.getMBeanName());
        try {
            brokerStateHandler.quiesce();
        }
        catch (BrokerException brokerException) {
            this.handleOperationException("quiesce", brokerException);
        }
    }

    public void resetMetrics() {
        this.logger.log(8, "Reset metrics request received by MBean " + this.getMBeanName());
        ResetMetricsHandler.resetAllMetrics();
    }

    public void restart() {
        if (Broker.isInProcess()) {
            String string = rb.getString("B3253");
            this.logger.log(16, "BrokerConfig MBean: " + string);
            return;
        }
        BrokerStateHandler brokerStateHandler = Globals.getBrokerStateHandler();
        this.logger.log(8, "Restart request received by MBean " + this.getMBeanName());
        brokerStateHandler.initiateShutdown("jmx", 0L, true, brokerStateHandler.getRestartCode(), true, Broker.isInProcess(), false);
    }

    public void shutdown() {
        this.shutdown(Boolean.FALSE, new Long(0L));
    }

    public void shutdown(Boolean bl, Long l) {
        BrokerStateHandler brokerStateHandler = Globals.getBrokerStateHandler();
        boolean bl2 = bl == null ? true : bl == false;
        this.logger.log(8, "Shutdown request received by MBean " + this.getMBeanName());
        brokerStateHandler.initiateShutdown("jmx", (l == null ? 0L : l) * 1000L, bl2, 0, true, Broker.isInProcess(), false);
    }

    public void takeover(String string) throws MBeanException {
        BrokerStateHandler brokerStateHandler = Globals.getBrokerStateHandler();
        this.logger.log(8, "Request to takeover broker " + string + " received by MBean " + this.getMBeanName());
        try {
            brokerStateHandler.takeoverBroker(string, true);
        }
        catch (BrokerException brokerException) {
            this.handleOperationException("takeover", brokerException);
        }
    }

    public void unquiesce() throws MBeanException {
        BrokerStateHandler brokerStateHandler = Globals.getBrokerStateHandler();
        this.logger.log(8, "Unquiesce request received by MBean " + this.getMBeanName());
        try {
            brokerStateHandler.stopQuiesce();
        }
        catch (BrokerException brokerException) {
            this.handleOperationException("unquiesce", brokerException);
        }
    }

    public String getProperty(String string) {
        return Globals.getConfig().getProperty(string);
    }

    public String getMBeanName() {
        return "BrokerConfig";
    }

    public String getMBeanDescription() {
        return mbr.getString("MB1027");
    }

    public MBeanAttributeInfo[] getMBeanAttributeInfo() {
        return attrs;
    }

    public MBeanOperationInfo[] getMBeanOperationInfo() {
        return ops;
    }

    public MBeanNotificationInfo[] getMBeanNotificationInfo() {
        return notifs;
    }

    public void validate(String string, String string2) throws PropertyUpdateException {
    }

    public boolean update(String string, String string2) {
        Integer n = null;
        Integer n2 = null;
        if (string.equals("imq.portmapper.port")) {
            try {
                n = Integer.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.logger.log(16, "BrokerConfig MBean: cannot parse internal value of Port: " + numberFormatException);
                n = null;
            }
            try {
                n2 = this.getPort();
            }
            catch (MBeanException mBeanException) {
                n2 = null;
            }
            this.notifyAttrChange("Port", n, n2);
            Agent agent = Globals.getAgent();
            if (agent != null) {
                agent.portMapperPortUpdated(n2, n);
            }
        }
        this.initProps();
        return true;
    }

    public void notifyAttrChange(String string, Object object, Object object2) {
        this.sendNotification(new AttributeChangeNotification(this, this.sequenceNumber++, new Date().getTime(), "Attribute change", string, object == null ? "" : object.getClass().getName(), object2, object));
    }

    private void initProps() {
        this.brokerProps = Globals.getConfig().toProperties();
        Version version = Globals.getVersion();
        this.brokerProps.putAll((Map<?, ?>)version.getProps());
    }

    static {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[5];
        mBeanAttributeInfoArray[0] = new MBeanAttributeInfo("BrokerID", String.class.getName(), mbr.getString("MB1028"), true, false, false);
        mBeanAttributeInfoArray[1] = new MBeanAttributeInfo("InstanceName", String.class.getName(), mbr.getString("MB1030"), true, false, false);
        mBeanAttributeInfoArray[2] = new MBeanAttributeInfo("Host", String.class.getName(), mbr.getString("MB1268"), true, false, false);
        mBeanAttributeInfoArray[3] = new MBeanAttributeInfo("Port", Integer.class.getName(), mbr.getString("MB1031"), true, true, false);
        mBeanAttributeInfoArray[4] = new MBeanAttributeInfo("Version", String.class.getName(), mbr.getString("MB1032"), true, false, false);
        attrs = mBeanAttributeInfoArray;
        MBeanParameterInfo[] mBeanParameterInfoArray = new MBeanParameterInfo[2];
        mBeanParameterInfoArray[0] = new MBeanParameterInfo("noFailover", Boolean.class.getName(), mbr.getString("MB1039"));
        mBeanParameterInfoArray[1] = new MBeanParameterInfo("time", Long.class.getName(), mbr.getString("MB1040"));
        shutdownSignature = mBeanParameterInfoArray;
        MBeanParameterInfo[] mBeanParameterInfoArray2 = new MBeanParameterInfo[1];
        mBeanParameterInfoArray2[0] = new MBeanParameterInfo("brokerID", String.class.getName(), mbr.getString("MB1041"));
        takeoverSignature = mBeanParameterInfoArray2;
        MBeanParameterInfo[] mBeanParameterInfoArray3 = new MBeanParameterInfo[1];
        mBeanParameterInfoArray3[0] = new MBeanParameterInfo("propertyName", String.class.getName(), mbr.getString("MB1241"));
        getPropertySignature = mBeanParameterInfoArray3;
        MBeanOperationInfo[] mBeanOperationInfoArray = new MBeanOperationInfo[8];
        mBeanOperationInfoArray[0] = new MBeanOperationInfo("getProperty", mbr.getString("MB1240"), getPropertySignature, String.class.getName(), 0);
        mBeanOperationInfoArray[1] = new MBeanOperationInfo("quiesce", mbr.getString("MB1033"), null, Void.TYPE.getName(), 1);
        mBeanOperationInfoArray[2] = new MBeanOperationInfo("resetMetrics", mbr.getString("MB1034"), null, Void.TYPE.getName(), 1);
        mBeanOperationInfoArray[3] = new MBeanOperationInfo("restart", mbr.getString("MB1035"), null, Void.TYPE.getName(), 1);
        mBeanOperationInfoArray[4] = new MBeanOperationInfo("shutdown", mbr.getString("MB1036"), null, Void.TYPE.getName(), 1);
        mBeanOperationInfoArray[5] = new MBeanOperationInfo("shutdown", mbr.getString("MB1036"), shutdownSignature, Void.TYPE.getName(), 1);
        mBeanOperationInfoArray[6] = new MBeanOperationInfo("takeover", mbr.getString("MB1037"), takeoverSignature, Void.TYPE.getName(), 1);
        mBeanOperationInfoArray[7] = new MBeanOperationInfo("unquiesce", mbr.getString("MB1038"), null, Void.TYPE.getName(), 1);
        ops = mBeanOperationInfoArray;
        attrChangeTypes = new String[]{"jmx.attribute.change"};
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[1];
        mBeanNotificationInfoArray[0] = new MBeanNotificationInfo(attrChangeTypes, AttributeChangeNotification.class.getName(), mbr.getString("MB1025"));
        notifs = mBeanNotificationInfoArray;
    }
}

