/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.multibroker.ChangeRecordCallback;
import com.sun.messaging.jmq.jmsserver.multibroker.DestinationUpdateChangeRecord;
import com.sun.messaging.jmq.jmsserver.multibroker.InterestUpdateChangeRecord;
import com.sun.messaging.jmq.jmsserver.multibroker.MessageBusCallback;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterDestInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterSubscriptionInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ProtocolGlobals;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.RaptorProtocol;
import com.sun.messaging.jmq.jmsserver.persist.ChangeRecordInfo;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsservice.BrokerEvent;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeRecord {
    public static final int TYPE_RESET_PERSISTENCE = 31;
    public static final String UUID_PROPERTY = "UUID";
    private GPacket gp;
    private boolean discard = false;
    protected int operation = 31;

    public static ChangeRecord makeChangeRecord(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        GPacket gPacket = GPacket.getInstance();
        gPacket.read(byteArrayInputStream);
        ChangeRecord changeRecord = null;
        if (gPacket.getType() == 5 || gPacket.getType() == 7) {
            changeRecord = new InterestUpdateChangeRecord(gPacket);
        } else if (gPacket.getType() == 13 || gPacket.getType() == 15) {
            changeRecord = new DestinationUpdateChangeRecord(gPacket);
        } else if (gPacket.getType() == 31) {
            changeRecord = new ChangeRecord();
        }
        changeRecord.gp = gPacket;
        changeRecord.discard = false;
        return changeRecord;
    }

    public byte[] getBytes() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.gp.write(byteArrayOutputStream);
            byteArrayOutputStream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    public String getUniqueKey() {
        return "???";
    }

    public boolean isAddOp() {
        return false;
    }

    public int getOperation() {
        return this.operation;
    }

    public boolean isDiscard() {
        return this.discard;
    }

    public void setDiscard(boolean bl) {
        this.discard = bl;
    }

    public String toString() {
        return this.getUniqueKey() + ", isAddOp() = " + this.isAddOp();
    }

    public static synchronized void syncChangeRecord(ChangeRecordCallback changeRecordCallback, MessageBusCallback messageBusCallback, RaptorProtocol raptorProtocol, boolean bl) throws BrokerException {
        Long l = null;
        String string = null;
        if (bl) {
            l = ChangeRecord.retrieveLastSeq();
            string = ChangeRecord.retrieveLastResetUUID();
        } else if (changeRecordCallback.getLastSyncedChangeRecord() != null) {
            l = changeRecordCallback.getLastSyncedChangeRecord().getSeq();
            string = changeRecordCallback.getLastSyncedChangeRecord().getResetUUID();
        }
        List<ChangeRecordInfo> list = null;
        try {
            list = Globals.getStore().getShareConfigChangeStore().getChangeRecordsSince(l, string, bl);
        }
        catch (BrokerException brokerException) {
            if (brokerException.getStatusCode() == 412) {
                Globals.getLogger().logStack(32, brokerException.getMessage(), brokerException);
                Broker broker = Broker.getBroker();
                Globals.getBrokerStateHandler();
                broker.exit(BrokerStateHandler.getRestartCode(), brokerException.getMessage(), BrokerEvent.Type.RESTART, null, false, true, false);
            }
            throw brokerException;
        }
        ChangeRecord.processChangeRecords(list, changeRecordCallback, messageBusCallback, raptorProtocol, bl);
    }

    private static void storeLastSeq(Long l) {
        try {
            Globals.getStore().updateProperty("ShareConfigRecord.lastSequenceNumber", l, true);
        }
        catch (Exception exception) {
            Globals.getLogger().logStack(16, Globals.getBrokerResources().getKString("B2239", String.valueOf(l), exception.getMessage()), exception);
        }
    }

    private static void storeLastResetUUID(String string) {
        try {
            Globals.getStore().updateProperty("ShareConfigRecord.lastResetUUID", string, true);
        }
        catch (Exception exception) {
            Globals.getLogger().logStack(16, Globals.getBrokerResources().getKString("B2240", string, exception.getMessage()), exception);
        }
    }

    private static Long retrieveLastSeq() {
        Long l = null;
        try {
            l = (Long)Globals.getStore().getProperty("ShareConfigRecord.lastSequenceNumber");
        }
        catch (Exception exception) {
            Logger logger = Globals.getLogger();
            Globals.getLogger();
            logger.log(16, "Unable to retrieve property ShareConfigRecord.lastSequenceNumber");
        }
        return l;
    }

    private static String retrieveLastResetUUID() {
        String string = null;
        try {
            string = (String)Globals.getStore().getProperty("ShareConfigRecord.lastResetUUID");
        }
        catch (Exception exception) {
            Logger logger = Globals.getLogger();
            Globals.getLogger();
            logger.log(16, "Unable to retrieve property ShareConfigRecord.lastResetUUID");
        }
        return string;
    }

    public static synchronized void recordUpdateDestination(Destination destination, ChangeRecordCallback changeRecordCallback) throws BrokerException {
        ClusterDestInfo clusterDestInfo = ClusterDestInfo.newInstance(destination);
        GPacket gPacket = clusterDestInfo.getGPacket((short)13, true);
        ChangeRecordInfo changeRecordInfo = ChangeRecord.storeChangeRecord(gPacket, changeRecordCallback);
        destination.setCurrentChangeRecordInfo(13, changeRecordInfo);
    }

    public static void recordRemoveDestination(Destination destination, ChangeRecordCallback changeRecordCallback) throws BrokerException {
        ClusterDestInfo clusterDestInfo = ClusterDestInfo.newInstance(destination);
        GPacket gPacket = clusterDestInfo.getGPacket((short)15, true);
        ChangeRecordInfo changeRecordInfo = ChangeRecord.storeChangeRecord(gPacket, changeRecordCallback);
        destination.setCurrentChangeRecordInfo(13, changeRecordInfo);
    }

    public static void recordCreateSubscription(Subscription subscription, ChangeRecordCallback changeRecordCallback) throws BrokerException {
        ClusterSubscriptionInfo clusterSubscriptionInfo = ClusterSubscriptionInfo.newInstance(subscription);
        GPacket gPacket = clusterSubscriptionInfo.getGPacket((short)5, true);
        ChangeRecordInfo changeRecordInfo = ChangeRecord.storeChangeRecord(gPacket, changeRecordCallback);
        subscription.setCurrentChangeRecordInfo(5, changeRecordInfo);
    }

    public static void recordUnsubscribe(Subscription subscription, ChangeRecordCallback changeRecordCallback) throws BrokerException {
        ClusterSubscriptionInfo clusterSubscriptionInfo = ClusterSubscriptionInfo.newInstance(subscription);
        GPacket gPacket = clusterSubscriptionInfo.getGPacket((short)7, true);
        ChangeRecordInfo changeRecordInfo = ChangeRecord.storeChangeRecord(gPacket, changeRecordCallback);
        subscription.setCurrentChangeRecordInfo(7, changeRecordInfo);
    }

    public static void storeResetRecordIfNecessary(ChangeRecordCallback changeRecordCallback) throws BrokerException {
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType((short)31);
        ChangeRecord.storeChangeRecord(gPacket, changeRecordCallback);
    }

    private static synchronized ChangeRecordInfo storeChangeRecord(GPacket gPacket, ChangeRecordCallback changeRecordCallback) throws BrokerException {
        String string = UUID.randomUUID().toString();
        gPacket.putProp(UUID_PROPERTY, string);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            gPacket.write(byteArrayOutputStream);
            byteArrayOutputStream.flush();
        }
        catch (Exception exception) {
            throw new BrokerException(exception.toString(), exception);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        ChangeRecordInfo changeRecordInfo = new ChangeRecordInfo(null, string, byArray, gPacket.getType(), System.currentTimeMillis());
        if (gPacket.getType() == 31) {
            Globals.getStore().getShareConfigChangeStore().storeResetRecord(changeRecordInfo, true);
            return null;
        }
        String string2 = null;
        if (changeRecordCallback.getLastSyncedChangeRecord() != null) {
            string2 = changeRecordCallback.getLastSyncedChangeRecord().getResetUUID();
        }
        if (string2 == null && changeRecordCallback.getLastStoredChangeRecord() != null) {
            string2 = changeRecordCallback.getLastStoredChangeRecord().getResetUUID();
        }
        changeRecordInfo.setResetUUID(string2);
        changeRecordInfo = Globals.getStore().getShareConfigChangeStore().storeChangeRecord(changeRecordInfo, true);
        changeRecordCallback.setLastStoredChangeRecord(changeRecordInfo);
        return changeRecordInfo;
    }

    private static void processChangeRecords(List<ChangeRecordInfo> list, ChangeRecordCallback changeRecordCallback, MessageBusCallback messageBusCallback, RaptorProtocol raptorProtocol, boolean bl) throws BrokerException {
        Globals.getLogger().log(8, Globals.getBrokerResources().getKString("B1361", list.size()));
        boolean bl2 = false;
        if (list.size() > 0 && list.get(0).isSelectAll()) {
            bl2 = true;
        }
        String string = null;
        try {
            ArrayList<GPacket> arrayList = new ArrayList<GPacket>();
            for (int i = 0; i < list.size(); ++i) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(list.get(i).getRecord());
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                GPacket gPacket = GPacket.getInstance();
                gPacket.read(dataInputStream);
                if (gPacket.getType() != list.get(i).getType()) {
                    throw new BrokerException(Globals.getBrokerResources().getKString("B4318", ProtocolGlobals.getPacketTypeString(gPacket.getType()), list.get(i).toString()));
                }
                if (gPacket.getType() == 31) {
                    String string2 = list.get(i).getUUID();
                    if (string != null && !string.equals(string2)) {
                        throw new BrokerException(Globals.getBrokerResources().getKString("B4319", ProtocolGlobals.getPacketTypeString(31), "[" + string + ", " + string2 + "]"));
                    }
                    if (string == null) {
                        string = string2;
                    }
                }
                if (bl2) {
                    arrayList.add(gPacket);
                    continue;
                }
                raptorProtocol.handleGPacket(messageBusCallback, Globals.getMyAddress(), gPacket);
            }
            if (bl2) {
                raptorProtocol.applyPersistentStateChanges(Globals.getMyAddress(), arrayList);
            }
            if (list.size() > 0) {
                ChangeRecordInfo changeRecordInfo = list.get(list.size() - 1);
                changeRecordCallback.setLastSyncedChangeRecord(changeRecordInfo);
                ChangeRecord.storeLastSeq(changeRecordInfo.getSeq());
                if (bl2 && string != null) {
                    changeRecordInfo.setResetUUID(string);
                    ChangeRecord.storeLastResetUUID(string);
                }
            }
        }
        catch (Throwable throwable) {
            Globals.getLogger().logStack(32, Globals.getBrokerResources().getKString("B3254", throwable.getMessage()), throwable);
            if (throwable instanceof BrokerException) {
                throw (BrokerException)throwable;
            }
            throw new BrokerException(throwable.getMessage(), throwable);
        }
    }
}

