/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.file;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.data.BaseTransaction;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionWorkMessage;
import com.sun.messaging.jmq.jmsserver.data.TransactionWorkMessageAck;
import com.sun.messaging.jmq.jmsserver.persist.ChangeRecordInfo;
import com.sun.messaging.jmq.jmsserver.persist.LoadException;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.TransactionInfo;
import com.sun.messaging.jmq.jmsserver.persist.file.BaseTransactionManager;
import com.sun.messaging.jmq.jmsserver.persist.file.ConfigChangeRecord;
import com.sun.messaging.jmq.jmsserver.persist.file.DestinationList;
import com.sun.messaging.jmq.jmsserver.persist.file.InterestStore;
import com.sun.messaging.jmq.jmsserver.persist.file.MsgStore;
import com.sun.messaging.jmq.jmsserver.persist.file.PropertiesFile;
import com.sun.messaging.jmq.jmsserver.persist.file.TidList;
import com.sun.messaging.jmq.jmsserver.persist.file.TransactionLogManager;
import com.sun.messaging.jmq.jmsserver.persist.file.TxnConversionUtil;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.FileUtil;
import com.sun.messaging.jmq.util.SizeString;
import com.sun.messaging.jmq.util.selector.SelectorFormatException;
import com.sun.messaging.jmq.util.timer.MQTimer;
import com.sun.messaging.jmq.util.txnlog.CheckPointListener;
import com.sun.messaging.jmq.util.txnlog.TransactionLogRecord;
import com.sun.messaging.jmq.util.txnlog.TransactionLogWriter;
import com.sun.messaging.jmq.util.txnlog.file.FileTransactionLogWriter;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TimerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileStore
extends Store
implements CheckPointListener {
    public static final int OLD_STORE_VERSION_200 = 200;
    public static final int OLD_STORE_VERSION = 350;
    public static final int STORE_VERSION = 370;
    static final String FILE_PROP_PREFIX = "imq.persist.file.";
    static final String SYNC_ENABLED_PROP = "imq.persist.file.sync.enabled";
    static final String SYNC_ALL_PROP = "imq.persist.file.sync.all";
    static final boolean DEFAULT_SYNC_ENABLED = false;
    static final boolean DEFAULT_SYNC_ALL = false;
    static final String TXNLOG_FILE_SIZE_PROP = "imq.persist.file.txnLog.file.size";
    static final long DEFAULT_TXNLOG_FILE_SIZE = 10240L;
    static final String FILESTORE_BASENAME = "fs";
    static final String FILESTORE_TOP = "fs370";
    static final String FILESTORE350_TOP = "fs350";
    static final String FILESTORE200_TOP = "filestore";
    static final String VERSIONFILE = "version";
    static final boolean syncEnabled = config.getBooleanProperty("imq.persist.file.sync.enabled", false);
    static final boolean syncAll = config.getBooleanProperty("imq.persist.file.sync.all", false);
    static final String NO_SYNC_FOR_DELIVERY_STATE_UPDATE = "imq.persist.file.noSyncForDeliveryStateUpdate";
    static final boolean noSyncForDeliveryStateUpdate = config.getBooleanProperty("imq.persist.file.noSyncForDeliveryStateUpdate", false);
    private File rootDir = null;
    private MsgStore msgStore = null;
    private InterestStore intStore = null;
    private DestinationList dstList = null;
    private TidList tidList = null;
    private ConfigChangeRecord configStore = null;
    private PropertiesFile propFile = null;
    private TransactionLogManager txnLogManager = null;
    static final String MSG_LOG_FILENAME = "txnlogmsg";
    static final String ACK_LOG_FILENAME = "txnlogack";
    boolean txnLoggerInited = false;
    private TransactionLogWriter msgLogWriter = null;
    private TransactionLogWriter ackLogWriter = null;
    private static final ConsumerUID[] emptyiid = new ConsumerUID[0];
    private static final int[] emptystate = new int[0];
    private static FilenameFilter storeFilter = new FilenameFilter(){

        public boolean accept(File file, String string) {
            return new File(file, string).isDirectory() && string.startsWith(FileStore.FILESTORE_BASENAME);
        }
    };

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FileStore() throws BrokerException {
        String string = Globals.JMQ_INSTANCES_HOME + File.separator + Globals.getConfigName() + File.separator;
        logger.logToAll(8, br.getString("B1141", string));
        if (Store.getDEBUG()) {
            logger.log(4, "imq.persist.file.sync.enabled=" + syncEnabled);
        }
        if (Store.getDEBUG()) {
            logger.log(4, "imq.persist.file.sync.all=" + syncAll);
        }
        if (Store.getDEBUG()) {
            logger.log(4, "imq.persist.file.noSyncForDeliveryStateUpdate=" + noSyncForDeliveryStateUpdate);
        }
        String string2 = Globals.JMQ_INSTANCES_HOME + File.separator + Globals.getConfigName() + File.separator;
        File file = new File(string2);
        int n = this.checkFileStore(file);
        this.rootDir = new File(file, FILESTORE_TOP);
        if (this.removeStore) {
            try {
                FileUtil.removeFiles(this.rootDir, true);
                return;
            }
            catch (IOException iOException) {
                logger.log(32, "B3120", (Object)this.rootDir, (Throwable)iOException);
                throw new BrokerException(br.getString("B3120", this.rootDir), iOException);
            }
        }
        if (!this.rootDir.exists() && !this.rootDir.mkdirs()) {
            logger.log(32, "B3017", this.rootDir);
            throw new BrokerException(br.getString("B3017", this.rootDir));
        }
        if (n > 0) {
            File file2 = null;
            try {
                Object[] objectArray = new Object[]{new Integer(370), FILESTORE_TOP};
                logger.logToAll(8, "B1105", objectArray);
                if (this.resetMessage) {
                    logger.logToAll(8, "B1101");
                    logger.logToAll(8, "B1102");
                } else if (this.resetInterest) {
                    logger.logToAll(8, "B1103");
                    logger.logToAll(8, "B1102");
                }
                if (n == 350) {
                    file2 = new File(file, FILESTORE350_TOP);
                    try {
                        FileUtil.copyDirectory(file2, this.rootDir);
                        FileUtil.removeFiles(new File(this.rootDir, "txn"), false);
                        FileUtil.removeFiles(new File(this.rootDir, "txnack"), false);
                    }
                    catch (IOException iOException) {
                        String string3 = "Failed to copy old persistent data under " + file2 + " to " + this.rootDir;
                        logger.log(32, string3, iOException);
                        throw new BrokerException(string3, iOException);
                    }
                    this.dstList = new DestinationList(this, this.rootDir, false);
                    this.msgStore = new MsgStore(this, this.rootDir, this.resetMessage);
                    this.intStore = new InterestStore(this.rootDir, this.resetInterest);
                    this.tidList = new TidList(this, this.rootDir, file2);
                    this.configStore = new ConfigChangeRecord(this.rootDir, false);
                    this.propFile = new PropertiesFile(this.rootDir, false);
                } else {
                    file2 = new File(file, FILESTORE200_TOP);
                    this.dstList = new DestinationList(this, this.rootDir, file2);
                    this.msgStore = new MsgStore(this, this.rootDir, file2, this.resetMessage);
                    this.intStore = new InterestStore(this, this.rootDir, file2, this.resetInterest);
                    this.tidList = new TidList(this.rootDir, true);
                    this.propFile = new PropertiesFile(this, this.rootDir, file2);
                    this.configStore = new ConfigChangeRecord(this, this.rootDir, file2);
                }
                if (Store.getDEBUG()) {
                    logger.log(4, "FileStore upgraded successfully.");
                }
                if (this.upgradeNoBackup) {
                    try {
                        FileUtil.removeFiles(file2, true);
                    }
                    catch (IOException iOException) {
                        logger.log(32, "B3120", (Object)file2, (Throwable)iOException);
                    }
                }
                logger.logToAll(8, "B1106");
                if (this.upgradeNoBackup) return;
                logger.logToAll(8, "B1099", file2);
                return;
            }
            catch (BrokerException brokerException) {
                logger.log(8, "B1110", this.rootDir);
                try {
                    FileUtil.removeFiles(this.rootDir, true);
                    throw brokerException;
                }
                catch (IOException iOException) {
                    logger.log(32, "B3120", (Object)this.rootDir, (Throwable)brokerException);
                }
                throw brokerException;
            }
        }
        this.dstList = new DestinationList(this, this.rootDir, this.resetStore);
        this.msgStore = new MsgStore(this, this.rootDir, this.resetStore || this.resetMessage);
        this.intStore = new InterestStore(this.rootDir, this.resetStore || this.resetInterest);
        if (this.resetStore) {
            TxnConversionUtil.resetAllTransactionState(this.rootDir);
        }
        boolean bl = config.getBooleanProperty("imq.persist.file.newTxnLog.enabled", true);
        TxnConversionUtil.checkForIncompleteTxnConversion(this.rootDir, bl);
        if (!bl || TxnConversionUtil.isTxnConversionRequired()) {
            this.tidList = new TidList(this.rootDir, this.resetStore);
        }
        if (bl || TxnConversionUtil.isTxnConversionRequired()) {
            this.txnLogManager = new TransactionLogManager(this, this.msgStore, this.rootDir, this.resetStore);
        }
        this.configStore = new ConfigChangeRecord(this.rootDir, this.resetStore);
        this.propFile = new PropertiesFile(this.rootDir, this.resetStore);
        if (!Store.getDEBUG()) return;
        logger.log(4, "FileStore instantiated successfully.");
    }

    void closeTidList() {
        if (this.tidList != null) {
            this.tidList.close(true);
        }
    }

    void closeTxnLogManager() {
        this.txnLogManager.close();
    }

    @Override
    public void convertTxnFormats(TransactionList transactionList) throws BrokerException, IOException {
        TxnConversionUtil.convertTxnFormats(this, this.rootDir, transactionList);
    }

    @Override
    public void init() throws BrokerException {
        if (this.txnLogManager != null) {
            this.txnLogManager.startup();
        }
    }

    public FileStore(String string, boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "imq.persist.file.sync.enabled=" + syncEnabled);
        }
        if (Store.getDEBUG()) {
            logger.log(4, "imq.persist.file.sync.all=" + syncAll);
        }
        logger.log(8, br.getString("B1141", string));
        this.rootDir = new File(string, FILESTORE_TOP);
        if (bl) {
            try {
                FileUtil.removeFiles(this.rootDir, false);
                return;
            }
            catch (IOException iOException) {
                logger.log(32, "B3120", (Object)this.rootDir, (Throwable)iOException);
                throw new BrokerException(br.getString("B3120", this.rootDir), iOException);
            }
        }
        if (!this.rootDir.exists() && !this.rootDir.mkdirs()) {
            logger.log(32, "B3017", this.rootDir.toString());
            throw new BrokerException(br.getString("B3017", this.rootDir.toString()));
        }
        this.dstList = new DestinationList(this, this.rootDir, false);
        this.msgStore = new MsgStore(this, this.rootDir, false);
        this.intStore = new InterestStore(this.rootDir, false);
        this.tidList = new TidList(this.rootDir, false);
        this.configStore = new ConfigChangeRecord(this.rootDir, false);
        this.propFile = new PropertiesFile(this.rootDir, false);
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore instantiated successfully.");
        }
    }

    @Override
    public LoadException getLoadDestinationException() {
        return this.dstList.getLoadException();
    }

    @Override
    public LoadException getLoadConsumerException() {
        return this.intStore.getLoadException();
    }

    @Override
    public LoadException getLoadPropertyException() {
        return this.propFile.getLoadException();
    }

    @Override
    public LoadException getLoadTransactionException() {
        return this.tidList.getLoadException();
    }

    @Override
    public LoadException getLoadTransactionAckException() {
        return this.tidList.getLoadTransactionAckException();
    }

    @Override
    public void close(boolean bl) {
        super.setClosedAndWait();
        this.dstList.close(bl);
        if (this.tidList != null) {
            this.tidList.close(bl);
        }
        this.configStore.close(bl);
        this.propFile.close(bl);
        this.intStore.close(bl);
        this.msgStore.close(bl);
        try {
            if (this.msgLogWriter != null) {
                this.msgLogWriter.close();
            }
            if (this.ackLogWriter != null) {
                this.ackLogWriter.close();
            }
        }
        catch (IOException iOException) {
            logger.logStack(32, "B3100", "Got IOException while closing transaction log file", (Throwable)iOException);
        }
        if (config.getBooleanProperty("imq.persist.file.transaction.memorymappedfile.enabled", true)) {
            for (int i = 0; i < 3; ++i) {
                Broker.runGC();
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (this.txnLogManager != null) {
            this.txnLogManager.close();
        }
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.close(" + bl + ") done.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAll(boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.clearAll() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            this.msgStore.clearAll(bl);
            this.intStore.clearAll(bl);
            this.dstList.clearAll(bl, false);
            if (this.tidList != null) {
                this.tidList.clearAll(bl);
            }
            this.configStore.clearAll(bl);
            this.propFile.clearAll(bl);
            try {
                if (this.msgLogWriter != null) {
                    this.msgLogWriter.reset();
                }
                if (this.ackLogWriter != null) {
                    this.ackLogWriter.reset();
                }
            }
            catch (IOException iOException) {
                logger.log(32, "B3100", (Object)"Got IOException while resetting transaction log file", (Throwable)iOException);
            }
            if (Store.getDEBUG()) {
                logger.log(4, "File store cleared");
            }
            Object var4_3 = null;
            super.setInProgress(false);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            super.setInProgress(false);
            throw throwable;
        }
    }

    @Override
    public List<BaseTransaction> getIncompleteTransactions(int n) {
        BaseTransactionManager baseTransactionManager = this.txnLogManager.getTransactionManager(n);
        return baseTransactionManager.getAllIncompleteTransactions();
    }

    @Override
    public void rollbackAllTransactions() {
        this.txnLogManager.rollbackAllTransactions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeMessage(DestinationUID destinationUID, Packet packet, ConsumerUID[] consumerUIDArray, int[] nArray, boolean bl) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.storeMessage() with interests called for " + packet.getSysMessageID() + " sync= " + bl);
        }
        super.checkClosedAndSetInProgress();
        try {
            if (destinationUID == null || packet == null || consumerUIDArray == null || nArray == null) {
                throw new NullPointerException();
            }
            if (consumerUIDArray.length == 0 || consumerUIDArray.length != nArray.length) {
                throw new BrokerException(br.getString("B3085"));
            }
            this.msgStore.storeMessage(destinationUID, packet, consumerUIDArray, nArray, bl);
            Object var7_6 = null;
            super.setInProgress(false);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            super.setInProgress(false);
            throw throwable;
        }
    }

    @Override
    public final int getStoreVersion() {
        return 370;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeMessage(DestinationUID destinationUID, Packet packet, boolean bl) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.storeMessage() called for " + packet.getSysMessageID() + " sync=" + bl);
        }
        super.checkClosedAndSetInProgress();
        try {
            long l;
            if (Globals.isNewTxnLogEnabled() && (l = packet.getTransactionID()) != 0L) {
                if (Store.getDEBUG()) {
                    logger.log(4, "isNewTxnLogEnabled and msg is transacted so NOT storing now " + packet.getSysMessageID());
                }
                Object var7_5 = null;
                super.setInProgress(false);
                return;
            }
            this.msgStore.storeMessage(destinationUID, packet, emptyiid, emptystate, bl);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            super.setInProgress(false);
            throw throwable;
        }
        Object var7_6 = null;
        super.setInProgress(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMessage(DestinationUID destinationUID, SysMessageID sysMessageID, boolean bl, boolean bl2) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.removeMessage() called for " + destinationUID + ";" + sysMessageID + " sync=" + bl + " onRollback=" + bl2);
        }
        if (Globals.isNewTxnLogEnabled() && bl2) {
            return;
        }
        if (sysMessageID == null) {
            throw new NullPointerException();
        }
        super.checkClosedAndSetInProgress();
        try {
            if (Globals.isNewTxnLogEnabled()) {
                this.txnLogManager.getLoggedMessageHelper().preMessageRemoved(destinationUID, sysMessageID);
            }
            this.msgStore.removeMessage(destinationUID, sysMessageID, bl);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                if (Globals.isNewTxnLogEnabled()) {
                    this.txnLogManager.getLoggedMessageHelper().postMessageRemoved(destinationUID, sysMessageID);
                }
                Object var8_9 = null;
                super.setInProgress(false);
            }
            catch (Throwable throwable2) {
                Object var8_10 = null;
                super.setInProgress(false);
                throw throwable2;
            }
            throw throwable;
        }
        try {
            if (Globals.isNewTxnLogEnabled()) {
                this.txnLogManager.getLoggedMessageHelper().postMessageRemoved(destinationUID, sysMessageID);
            }
            Object var8_7 = null;
            super.setInProgress(false);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            super.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveMessage(Packet packet, DestinationUID destinationUID, DestinationUID destinationUID2, ConsumerUID[] consumerUIDArray, int[] nArray, boolean bl) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.moveMessage() called for: " + packet.getSysMessageID() + " from " + destinationUID + " to " + destinationUID2);
        }
        if (packet == null || destinationUID == null || destinationUID2 == null) {
            throw new NullPointerException();
        }
        if (consumerUIDArray == null) {
            consumerUIDArray = emptyiid;
            nArray = emptystate;
        }
        super.checkClosedAndSetInProgress();
        try {
            this.msgStore.moveMessage(packet, destinationUID, destinationUID2, consumerUIDArray, nArray, bl);
            Object var8_7 = null;
            super.setInProgress(false);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            super.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllMessages(Destination destination, boolean bl) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.removeAllMessages(Destination) called");
        }
        super.checkClosedAndSetInProgress();
        try {
            this.msgStore.removeAllMessages(destination.getDestinationUID(), bl);
            Object var4_3 = null;
            super.setInProgress(false);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            super.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration messageEnumeration(Destination destination) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.messageEnumeration(Destination) called");
        }
        super.checkClosedAndSetInProgress();
        try {
            Enumeration enumeration = this.msgStore.messageEnumeration(destination.getDestinationUID());
            Object var4_3 = null;
            super.setInProgress(false);
            return enumeration;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            super.setInProgress(false);
            throw throwable;
        }
    }

    @Override
    public Packet getMessage(DestinationUID destinationUID, String string) throws BrokerException {
        return this.getMessage(destinationUID, SysMessageID.get(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Packet getMessage(DestinationUID destinationUID, SysMessageID sysMessageID) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.getMessage() called");
        }
        if (sysMessageID == null) {
            throw new NullPointerException();
        }
        super.checkClosedAndSetInProgress();
        try {
            Packet packet = this.msgStore.getMessage(destinationUID, sysMessageID);
            Object var5_4 = null;
            super.setInProgress(false);
            return packet;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            super.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeInterestStates(DestinationUID destinationUID, SysMessageID sysMessageID, ConsumerUID[] consumerUIDArray, int[] nArray, boolean bl, Packet packet) throws BrokerException {
        if (Store.getDEBUG()) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < nArray.length; ++i) {
                stringBuffer.append(nArray[i]).append(",");
            }
            logger.log(4, "FileStore.storeInterestStates() called." + stringBuffer);
        }
        super.checkClosedAndSetInProgress();
        try {
            if (sysMessageID == null || consumerUIDArray == null || nArray == null) {
                throw new NullPointerException();
            }
            if (consumerUIDArray.length == 0 || consumerUIDArray.length != nArray.length) {
                throw new BrokerException(br.getString("B3085"));
            }
            if (Globals.isNewTxnLogEnabled() && packet != null) {
                try {
                    if (Store.getDEBUG()) {
                        logger.log(4, "FileStore.storeInterestStates() REALLY storing");
                    }
                    this.msgStore.storeMessage(destinationUID, packet, consumerUIDArray, nArray, false);
                }
                catch (IOException iOException) {
                    throw new BrokerException(iOException.toString(), iOException);
                }
            } else {
                this.msgStore.storeInterestStates(destinationUID, sysMessageID, consumerUIDArray, nArray, bl);
            }
            Object var10_10 = null;
            super.setInProgress(false);
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            super.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateInterestState(DestinationUID destinationUID, SysMessageID sysMessageID, ConsumerUID consumerUID, int n, boolean bl, TransactionUID transactionUID, boolean bl2) throws BrokerException {
        if (Store.getDEBUG()) {
            String string = "FileStore.updateInterestState() called. mid=" + sysMessageID + " state= " + n + " sync=" + bl + " txid=" + transactionUID + " isLastAck= " + bl2;
            logger.log(4, string);
        }
        super.checkClosedAndSetInProgress();
        try {
            if (sysMessageID == null || consumerUID == null) {
                throw new NullPointerException();
            }
            if (Globals.isNewTxnLogEnabled() && n == 2) {
                boolean bl3 = false;
                if (transactionUID != null) {
                    bl3 = true;
                } else if (TransactionLogManager.logNonTransactedMsgAck) {
                    TransactionWorkMessageAck transactionWorkMessageAck = new TransactionWorkMessageAck(destinationUID, sysMessageID, consumerUID);
                    this.txnLogManager.logNonTxnMessageAck(transactionWorkMessageAck);
                    bl3 = true;
                    bl = false;
                }
                if (bl3 && bl2) {
                    this.txnLogManager.loggedMessageHelper.lastAckLogged(destinationUID, sysMessageID);
                } else {
                    this.msgStore.updateInterestState(destinationUID, sysMessageID, consumerUID, n, false);
                }
            } else {
                boolean bl4 = bl;
                if (n == 1 && noSyncForDeliveryStateUpdate) {
                    bl4 = false;
                }
                this.msgStore.updateInterestState(destinationUID, sysMessageID, consumerUID, n, bl4);
            }
            Object var11_12 = null;
            super.setInProgress(false);
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            super.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInterestState(DestinationUID destinationUID, SysMessageID sysMessageID, ConsumerUID consumerUID) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.getInterestState() called");
        }
        if (sysMessageID == null || consumerUID == null) {
            throw new NullPointerException();
        }
        super.checkClosedAndSetInProgress();
        try {
            int n = this.msgStore.getInterestState(destinationUID, sysMessageID, consumerUID);
            Object var6_5 = null;
            super.setInProgress(false);
            return n;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            super.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap getInterestStates(DestinationUID destinationUID, SysMessageID sysMessageID) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.getInterestStates() called");
        }
        if (sysMessageID == null) {
            throw new NullPointerException();
        }
        super.checkClosedAndSetInProgress();
        try {
            HashMap hashMap = this.msgStore.getInterestStates(destinationUID, sysMessageID);
            Object var5_4 = null;
            super.setInProgress(false);
            return hashMap;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            super.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConsumerUID[] getConsumerUIDs(DestinationUID destinationUID, SysMessageID sysMessageID) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.getConsumerUIDs() called");
        }
        if (sysMessageID == null) {
            throw new NullPointerException();
        }
        super.checkClosedAndSetInProgress();
        try {
            ConsumerUID[] consumerUIDArray = this.msgStore.getConsumerUIDs(destinationUID, sysMessageID);
            Object var5_4 = null;
            super.setInProgress(false);
            return consumerUIDArray;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            super.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasMessageBeenAcked(DestinationUID destinationUID, SysMessageID sysMessageID) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.hasMessageBeenAcked() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            boolean bl = this.msgStore.hasMessageBeenAcked(destinationUID, sysMessageID);
            Object var5_4 = null;
            super.setInProgress(false);
            return bl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            super.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeInterest(Consumer consumer, boolean bl) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.storeInterest() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            this.intStore.storeInterest(consumer, bl);
            Object var4_3 = null;
            super.setInProgress(false);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            super.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeInterest(Consumer consumer, boolean bl) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.removeInterest() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            this.intStore.removeInterest(consumer, bl);
            Object var4_3 = null;
            super.setInProgress(false);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            super.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Consumer[] getAllInterests() throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.getAllInterests() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            Consumer[] consumerArray = this.intStore.getAllInterests();
            Object var3_2 = null;
            super.setInProgress(false);
            return consumerArray;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            super.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeDestination(Destination destination, boolean bl) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.storeDestination() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            if (destination == null) {
                throw new NullPointerException();
            }
            this.dstList.storeDestination(destination, bl);
            Object var4_3 = null;
            super.setInProgress(false);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            super.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDestination(Destination destination, boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.updateDestination() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            if (destination == null) {
                throw new NullPointerException();
            }
            this.dstList.updateDestination(destination, bl);
            Object var4_3 = null;
            super.setInProgress(false);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            super.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDestination(Destination destination, boolean bl) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.removeDestination() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            if (destination == null) {
                throw new NullPointerException();
            }
            this.dstList.removeDestination(destination, bl);
            Object var4_3 = null;
            super.setInProgress(false);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            super.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Destination getDestination(DestinationUID destinationUID) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.getDestination() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            if (destinationUID == null) {
                throw new NullPointerException();
            }
            Destination destination = this.dstList.getDestination(destinationUID);
            Object var4_3 = null;
            super.setInProgress(false);
            return destination;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            super.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Destination[] getAllDestinations() throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.getAllDestinations() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            Destination[] destinationArray = this.dstList.getAllDestinations();
            Object var3_2 = null;
            super.setInProgress(false);
            return destinationArray;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            super.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeTransaction(TransactionUID transactionUID, TransactionState transactionState, boolean bl) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.storeTransaction() called");
        }
        if (Globals.isNewTxnLogEnabled()) {
            if (Store.getDEBUG()) {
                logger.log(4, "FileStore.storeTransaction() isFastLogTransactions true so returning");
            }
            return;
        }
        super.checkClosedAndSetInProgress();
        try {
            if (transactionUID == null || transactionState == null) {
                throw new NullPointerException();
            }
            this.tidList.storeTransaction(transactionUID, transactionState, bl);
            Object var5_4 = null;
            super.setInProgress(false);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            super.setInProgress(false);
            throw throwable;
        }
    }

    @Override
    public void removeTransaction(TransactionUID transactionUID, boolean bl) throws IOException, BrokerException {
        this.removeTransaction(transactionUID, false, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTransaction(TransactionUID transactionUID, boolean bl, boolean bl2) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.removeTransaction() called");
        }
        if (Globals.isNewTxnLogEnabled()) {
            return;
        }
        super.checkClosedAndSetInProgress();
        try {
            if (transactionUID == null) {
                throw new NullPointerException();
            }
            if (bl) {
                this.tidList.removeTransactionAck(transactionUID, bl2);
            }
            this.tidList.removeTransaction(transactionUID, bl2);
            Object var5_4 = null;
            super.setInProgress(false);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            super.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTransactionState(TransactionUID transactionUID, TransactionState transactionState, boolean bl) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.updateTransactionState( id=" + transactionUID + ", ts=" + transactionState.getState() + ") called");
        }
        super.checkClosedAndSetInProgress();
        try {
            if (transactionUID == null) {
                throw new NullPointerException();
            }
            if (!Globals.isNewTxnLogEnabled()) {
                this.tidList.updateTransactionState(transactionUID, transactionState.getState(), bl);
            }
            Object var5_4 = null;
            super.setInProgress(false);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            super.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap getAllTransactionStates() throws IOException, BrokerException {
        block4: {
            if (Store.getDEBUG()) {
                logger.log(4, "FileStore.getAllTransactionStates() called");
            }
            super.checkClosedAndSetInProgress();
            try {
                if (!Globals.isNewTxnLogEnabled() || TxnConversionUtil.convertingToTxnLog) break block4;
                HashMap hashMap = this.txnLogManager.getAllTransactionStates();
                Object var3_3 = null;
                super.setInProgress(false);
                return hashMap;
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                super.setInProgress(false);
                throw throwable;
            }
        }
        HashMap hashMap = this.tidList.getAllTransactionStates();
        Object var3_4 = null;
        super.setInProgress(false);
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeTransactionAck(TransactionUID transactionUID, TransactionAcknowledgement transactionAcknowledgement, boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.storeTransactionAck() called");
        }
        if (Globals.isNewTxnLogEnabled()) {
            return;
        }
        super.checkClosedAndSetInProgress();
        try {
            if (transactionUID == null || transactionAcknowledgement == null) {
                throw new NullPointerException();
            }
            this.tidList.storeTransactionAck(transactionUID, transactionAcknowledgement, bl);
            Object var5_4 = null;
            super.setInProgress(false);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            super.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTransactionAck(TransactionUID transactionUID, boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.removeTransactionAck() called");
        }
        if (Globals.isNewTxnLogEnabled()) {
            return;
        }
        super.checkClosedAndSetInProgress();
        try {
            if (transactionUID == null) {
                throw new NullPointerException();
            }
            this.tidList.removeTransactionAck(transactionUID, bl);
            Object var4_3 = null;
            super.setInProgress(false);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            super.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactionAcknowledgement[] getTransactionAcks(TransactionUID transactionUID) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.getTransactionAcks() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            if (transactionUID == null) {
                throw new NullPointerException();
            }
            TransactionAcknowledgement[] transactionAcknowledgementArray = this.tidList.getTransactionAcks(transactionUID);
            Object var4_3 = null;
            super.setInProgress(false);
            return transactionAcknowledgementArray;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            super.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap getAllTransactionAcks() throws BrokerException {
        block4: {
            if (Store.getDEBUG()) {
                logger.log(4, "FileStore.getAllTransactionAcks() called");
            }
            super.checkClosedAndSetInProgress();
            try {
                if (!Globals.isNewTxnLogEnabled() || TxnConversionUtil.convertingToTxnLog) break block4;
                HashMap hashMap = new HashMap();
                Object var3_3 = null;
                super.setInProgress(false);
                return hashMap;
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                super.setInProgress(false);
                throw throwable;
            }
        }
        HashMap hashMap = this.tidList.getAllTransactionAcks();
        Object var3_4 = null;
        super.setInProgress(false);
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeTransaction(TransactionUID transactionUID, TransactionInfo transactionInfo, boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.storeTransaction() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            this.tidList.storeTransaction(transactionUID, transactionInfo, bl);
            Object var5_4 = null;
            super.setInProgress(false);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            super.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeClusterTransaction(TransactionUID transactionUID, TransactionState transactionState, TransactionBroker[] transactionBrokerArray, boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.storeClusterTransaction() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            if (!Globals.isNewTxnLogEnabled()) {
                this.tidList.storeClusterTransaction(transactionUID, transactionState, transactionBrokerArray, bl);
            }
            Object var6_5 = null;
            super.setInProgress(false);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            super.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateClusterTransaction(TransactionUID transactionUID, TransactionBroker[] transactionBrokerArray, boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.updateClusterTransaction() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            this.tidList.updateClusterTransaction(transactionUID, transactionBrokerArray, bl);
            Object var5_4 = null;
            super.setInProgress(false);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            super.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactionBroker[] getClusterTransactionBrokers(TransactionUID transactionUID) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.updateClusterTransactionBrokerState() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            TransactionBroker[] transactionBrokerArray = this.tidList.getClusterTransactionBrokers(transactionUID);
            Object var4_3 = null;
            super.setInProgress(false);
            return transactionBrokerArray;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            super.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateClusterTransactionBrokerState(TransactionUID transactionUID, int n, TransactionBroker transactionBroker, boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.updateClusterTransactionBrokerState() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            if (Globals.isNewTxnLogEnabled()) {
                this.txnLogManager.getClusterTransactionManager().updateTransactionBrokerState(transactionUID, n, transactionBroker, bl);
            } else {
                this.tidList.updateTransactionBrokerState(transactionUID, n, transactionBroker, bl);
            }
            Object var6_5 = null;
            super.setInProgress(false);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            super.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeRemoteTransaction(TransactionUID transactionUID, TransactionState transactionState, TransactionAcknowledgement[] transactionAcknowledgementArray, BrokerAddress brokerAddress, boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.storeRemoteTransaction() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            if (Globals.isNewTxnLogEnabled()) {
                throw new UnsupportedOperationException("storeRemoteTransaction not supported for isFastLogTransactions");
            }
            this.tidList.storeRemoteTransaction(transactionUID, transactionState, transactionAcknowledgementArray, brokerAddress, bl);
            Object var7_6 = null;
            super.setInProgress(false);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            super.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BrokerAddress getRemoteTransactionHomeBroker(TransactionUID transactionUID) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.getRemoteTransactionHomeBroker() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            BrokerAddress brokerAddress = this.tidList.getRemoteTransactionHomeBroker(transactionUID);
            Object var4_3 = null;
            super.setInProgress(false);
            return brokerAddress;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            super.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap getAllRemoteTransactionStates() throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.getAllRemoteTransactionStates() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            HashMap hashMap = this.tidList.getAllRemoteTransactionStates();
            Object var3_2 = null;
            super.setInProgress(false);
            return hashMap;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            super.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactionState getTransactionState(TransactionUID transactionUID) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.getTransactionState() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            TransactionState transactionState = this.tidList.getTransactionState(transactionUID);
            Object var4_3 = null;
            super.setInProgress(false);
            return transactionState;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            super.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactionInfo getTransactionInfo(TransactionUID transactionUID) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.getTransactionInfo() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            TransactionInfo transactionInfo = this.tidList.getTransactionInfo(transactionUID);
            Object var4_3 = null;
            super.setInProgress(false);
            return transactionInfo;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            super.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection getTransactions(String string) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.getTransactions() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            Collection collection = this.tidList.getAllTransactions();
            Object var4_3 = null;
            super.setInProgress(false);
            return collection;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            super.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateProperty(String string, Object object, boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.updateProperty() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            if (string == null) {
                throw new NullPointerException();
            }
            this.propFile.updateProperty(string, object, bl);
            Object var5_4 = null;
            super.setInProgress(false);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            super.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getProperty(String string) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.getProperty() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            if (string == null) {
                throw new NullPointerException();
            }
            Object object = this.propFile.getProperty(string);
            Object var4_3 = null;
            super.setInProgress(false);
            return object;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            super.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getPropertyNames() throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.getPropertyNames() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            String[] stringArray = this.propFile.getPropertyNames();
            Object var3_2 = null;
            super.setInProgress(false);
            return stringArray;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            super.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties getAllProperties() throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.getAllProperties() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            Properties properties = this.propFile.getProperties();
            Object var3_2 = null;
            super.setInProgress(false);
            return properties;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            super.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeConfigChangeRecord(long l, byte[] byArray, boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.storeConfigChangeRecord() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            if (l <= 0L) {
                logger.log(32, "B3074", new Long(l));
                throw new BrokerException(br.getString("B3074", new Long(l)));
            }
            if (byArray == null) {
                throw new NullPointerException();
            }
            this.configStore.storeConfigChangeRecord(l, byArray, bl);
            Object var6_4 = null;
            super.setInProgress(false);
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            super.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<ChangeRecordInfo> getConfigChangeRecordsSince(long l) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.getConfigChangeRecordsSince() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            ArrayList<ChangeRecordInfo> arrayList = this.configStore.getConfigChangeRecordsSince(l);
            Object var5_3 = null;
            super.setInProgress(false);
            return arrayList;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            super.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ChangeRecordInfo> getAllConfigRecords() throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.getAllConfigRecords() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            List<ChangeRecordInfo> list = this.configStore.getAllConfigRecords();
            Object var3_2 = null;
            super.setInProgress(false);
            return list;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            super.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAllConfigChangeRecords(boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.clearAllConfigChangeRecords() called");
        }
        super.checkClosedAndSetInProgress();
        try {
            this.configStore.clearAll(bl);
            Object var3_2 = null;
            super.setInProgress(false);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            super.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap getMessageStorageInfo(Destination destination) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.getMessageStorageInfo(Destination) called");
        }
        super.checkClosedAndSetInProgress();
        try {
            DestinationUID destinationUID = destination.getDestinationUID();
            HashMap<String, Number> hashMap = new HashMap<String, Number>(2);
            hashMap.put("numMsgs", new Integer(this.msgStore.getMessageCount(destinationUID)));
            hashMap.put("totalMsgBytes", new Long(this.msgStore.getByteCount(destinationUID)));
            HashMap<String, Number> hashMap2 = hashMap;
            Object var6_5 = null;
            super.setInProgress(false);
            return hashMap2;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            super.setInProgress(false);
            throw throwable;
        }
    }

    @Override
    public String getStoreType() {
        return "file";
    }

    @Override
    public boolean isJDBCStore() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap getStorageInfo(Destination destination) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.getStorageInfo(" + destination + ") called");
        }
        super.checkClosedAndSetInProgress();
        try {
            HashMap hashMap = this.msgStore.getStorageInfo(destination);
            Object var4_3 = null;
            super.setInProgress(false);
            return hashMap;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            super.setInProgress(false);
            throw throwable;
        }
    }

    @Override
    public Hashtable getDebugState() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("File-based store", this.rootDir.getPath());
        hashtable.put("Store version", String.valueOf(370));
        hashtable.putAll(this.dstList.getDebugState());
        hashtable.putAll(this.msgStore.getDebugState());
        hashtable.putAll(this.intStore.getDebugState());
        if (this.tidList != null) {
            hashtable.putAll(this.tidList.getDebugState());
        }
        hashtable.putAll(this.propFile.getDebugState());
        hashtable.putAll(this.configStore.getDebugState());
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compactDestination(Destination destination) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.compactDestination(" + destination + ") called");
        }
        super.checkClosedAndSetInProgress();
        try {
            this.msgStore.compactDestination(destination);
            Object var3_2 = null;
            super.setInProgress(false);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            super.setInProgress(false);
            throw throwable;
        }
    }

    @Override
    public void syncDestination(Destination destination) throws BrokerException {
        if (destination == null) {
            try {
                Destination[] destinationArray = this.dstList.getAllDestinations();
                int n = destinationArray.length;
                for (int i = 0; i < n; ++i) {
                    this.msgStore.sync(destinationArray[i].getDestinationUID());
                }
            }
            catch (IOException iOException) {
                logger.logStack(32, "B3100", "Failed to synchronize message stores", (Throwable)iOException);
                throw new BrokerException("B4031", iOException);
            }
        } else {
            this.msgStore.sync(destination.getDestinationUID());
        }
    }

    @Override
    public void syncTransaction(TransactionUID transactionUID) throws BrokerException {
        if (!Globals.isNewTxnLogEnabled()) {
            this.tidList.sync(transactionUID);
            this.tidList.syncTransactionAck(transactionUID);
        }
    }

    @Override
    public void logTxn(int n, byte[] byArray) throws IOException {
        if (!this.txnLoggerInited) {
            return;
        }
        if (n == 1) {
            TransactionLogRecord transactionLogRecord = this.msgLogWriter.newTransactionLogRecord();
            transactionLogRecord.setType(n);
            transactionLogRecord.setBody(byArray);
            this.msgLogWriter.write(transactionLogRecord);
        } else {
            TransactionLogRecord transactionLogRecord = this.ackLogWriter.newTransactionLogRecord();
            transactionLogRecord.setType(n);
            transactionLogRecord.setBody(byArray);
            this.ackLogWriter.write(transactionLogRecord);
        }
    }

    public void logNonTxnMessage(TransactionWorkMessage transactionWorkMessage) throws BrokerException {
        this.txnLogManager.logNonTxnMessage(transactionWorkMessage);
    }

    @Override
    public void logTxn(BaseTransaction baseTransaction) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "logTxn " + baseTransaction);
        }
        this.txnLogManager.logTxn(baseTransaction);
    }

    @Override
    public void logTxnCompletion(TransactionUID transactionUID, int n, int n2) throws BrokerException {
        this.txnLogManager.logTxnCompletion(transactionUID, n, n2);
    }

    @Override
    public void loggedCommitWrittenToMessageStore(TransactionUID transactionUID, int n) {
        if (Store.getDEBUG()) {
            logger.log(4, "loggedCommitWrittenToMessageStore " + transactionUID);
        }
        this.txnLogManager.loggedCommitWrittenToMessageStore(transactionUID, n);
    }

    MsgStore getMsgStore() {
        return this.msgStore;
    }

    DestinationList getDstStore() {
        return this.dstList;
    }

    private int checkFileStore(File file) throws BrokerException {
        String[] stringArray;
        int n = 0;
        if (Store.getDEBUG()) {
            logger.log(4, "topDir=" + file);
        }
        if ((stringArray = file.list(storeFilter)) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals(FILESTORE_TOP) || stringArray[i].equals(FILESTORE350_TOP)) continue;
                File file2 = new File(file, stringArray[i]);
                logger.log(32, "B3129", file2);
                throw new BrokerException(br.getString("B3129", file2));
            }
        }
        File file3 = new File(file, FILESTORE_TOP);
        File file4 = new File(file, FILESTORE350_TOP);
        File file5 = new File(file, FILESTORE200_TOP);
        boolean bl = file5.exists();
        boolean bl2 = file4.exists();
        int n2 = 200;
        File file6 = file5;
        if (bl2) {
            n2 = 350;
            file6 = file4;
        } else if (bl) {
            this.checkOldVersion(new File(file6, VERSIONFILE), n2);
        }
        if (file3.exists()) {
            if (!this.removeStore) {
                if (bl2) {
                    logger.logToAll(8, "B1107", file6);
                } else if (bl) {
                    logger.logToAll(8, "B1107", file6);
                }
            }
        } else if (bl || bl2) {
            if (this.removeStore) {
                logger.logToAll(8, "B1104", file6);
            } else if (this.resetStore) {
                logger.logToAll(8, "B1100", file6);
                logger.logToAll(8, "B1114");
                try {
                    FileUtil.removeFiles(file6, true);
                }
                catch (IOException iOException) {
                    logger.log(32, "B3117", (Object)file6, (Throwable)iOException);
                    throw new BrokerException(br.getString("B3117", file6), iOException);
                }
            } else {
                logger.logToAll(8, "B1109", new Integer(n2));
                if (this.upgradeNoBackup && !Broker.getBroker().force) {
                    this.getConfirmation();
                }
                n = n2;
            }
        }
        return n;
    }

    private void checkOldVersion(File file, int n) throws BrokerException {
        if (!file.exists()) {
            logger.log(32, "B3126", file);
            throw new BrokerException(br.getString("B3126", file));
        }
        RandomAccessFile randomAccessFile = null;
        int n2 = 0;
        try {
            randomAccessFile = new RandomAccessFile(file, "r");
            String string = randomAccessFile.readLine();
            randomAccessFile.close();
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                logger.log(32, "B3125", string, Integer.toString(n), numberFormatException);
                throw new BrokerException(br.getString("B3125", string, Integer.toString(n)), numberFormatException);
            }
            if (n2 != n) {
                logger.log(32, "B3125", (Object)string, Integer.toString(n));
                throw new BrokerException(br.getString("B3125", string, Integer.toString(n)));
            }
        }
        catch (IOException iOException) {
            logger.log(32, "B4114", iOException);
            throw new BrokerException(br.getString("B4114"), iOException);
        }
    }

    @Override
    public boolean initTxnLogger() throws BrokerException {
        Object object;
        boolean bl = false;
        if (this.removeStore || !Globals.txnLogEnabled()) {
            return bl;
        }
        logger.log(8, "B1269");
        String string = null;
        try {
            object = config.getSizeProperty(TXNLOG_FILE_SIZE_PROP, 10240L);
            string = MSG_LOG_FILENAME;
            this.msgLogWriter = new FileTransactionLogWriter(this.rootDir, string, ((SizeString)object).getBytes());
            this.msgLogWriter.setCheckPointListener(this);
            string = ACK_LOG_FILENAME;
            this.ackLogWriter = new FileTransactionLogWriter(this.rootDir, string, ((SizeString)object).getBytes());
            this.ackLogWriter.setCheckPointListener(this);
            if (this.resetMessage || this.resetStore) {
                this.msgLogWriter.reset();
                this.ackLogWriter.reset();
                this.txnLoggerInited = true;
                return bl;
            }
        }
        catch (IOException iOException) {
            logger.logStack(32, "B3225", string, (Throwable)iOException);
            throw new BrokerException(br.getString("B3225", string), iOException);
        }
        try {
            TransactionUID transactionUID;
            int n;
            String string2;
            long l;
            DataInputStream dataInputStream;
            ByteArrayInputStream byteArrayInputStream;
            byte[] byArray;
            int n2;
            Object object22;
            int n3;
            HashSet hashSet = new HashSet();
            if (this.msgLogWriter.playBackRequired()) {
                bl = true;
                logger.log(64, "B1270");
                Destination.init();
                Subscription.initSubscriptions();
                n3 = 0;
                object22 = this.msgLogWriter.iterator();
                while (object22.hasNext()) {
                    ++n3;
                    object = (TransactionLogRecord)object22.next();
                    n2 = object.getType();
                    if (n2 != 1) {
                        logger.log(32, "B3226", (Object)String.valueOf(object.getSequence()), "record type " + n2 + " is invalid");
                        continue;
                    }
                    byArray = object.getBody();
                    byteArrayInputStream = new ByteArrayInputStream(byArray);
                    dataInputStream = new DataInputStream(byteArrayInputStream);
                    l = dataInputStream.readLong();
                    string2 = String.valueOf(l);
                    logger.log(64, "B1272", (Object)string2, String.valueOf(n2));
                    this.processTxnRecMsgPart(dataInputStream, hashSet);
                    if (l > 0L && (n = this.tidList.getTransactionStateValue(transactionUID = new TransactionUID(l))) != -1 && n != 6) {
                        logger.log(64, "B1273", string2);
                        this.tidList.updateTransactionState(transactionUID, 6, false);
                    }
                    dataInputStream.close();
                    byteArrayInputStream.close();
                }
                logger.log(64, "B1274", String.valueOf(n3));
                logger.flush();
            }
            if (this.ackLogWriter.playBackRequired()) {
                bl = true;
                logger.log(64, "B1271");
                Destination.init();
                Subscription.initSubscriptions();
                n3 = 0;
                object22 = this.ackLogWriter.iterator();
                while (object22.hasNext()) {
                    ++n3;
                    object = (TransactionLogRecord)object22.next();
                    n2 = object.getType();
                    if (n2 != 2 && n2 != 4) {
                        logger.log(32, "B3226", (Object)String.valueOf(object.getSequence()), "record type " + n2 + " is invalid");
                        continue;
                    }
                    byArray = object.getBody();
                    byteArrayInputStream = new ByteArrayInputStream(byArray);
                    dataInputStream = new DataInputStream(byteArrayInputStream);
                    l = dataInputStream.readLong();
                    string2 = String.valueOf(l);
                    logger.log(64, "B1272", (Object)string2, String.valueOf(n2));
                    if (n2 == 4) {
                        this.processTxnRecMsgPart(dataInputStream, hashSet);
                    }
                    this.processTxnRecAckPart(dataInputStream, hashSet);
                    transactionUID = new TransactionUID(l);
                    n = this.tidList.getTransactionStateValue(transactionUID);
                    if (n != -1 && n != 6) {
                        logger.log(64, "B1273", string2);
                        this.tidList.updateTransactionState(transactionUID, 6, false);
                    }
                    dataInputStream.close();
                    byteArrayInputStream.close();
                }
                logger.log(64, "B1275", String.valueOf(n3));
                logger.flush();
            }
            if (bl) {
                for (Object object22 : hashSet) {
                    ((Destination)object22).sync();
                    ((Destination)object22).unload(true);
                }
                hashSet = null;
                this.tidList.sync(null);
                this.tidList.syncTransactionAck(null);
                this.msgLogWriter.reset();
                this.ackLogWriter.reset();
                logger.log(64, "B1280");
                logger.flush();
            }
        }
        catch (Throwable throwable) {
            logger.logStack(32, "B3228", throwable);
            throw new BrokerException(br.getString("B3228"), throwable);
        }
        this.txnLoggerInited = true;
        return bl;
    }

    @Override
    public int doCheckpoint(boolean bl) {
        int n = 0;
        if (Globals.isNewTxnLogEnabled()) {
            if (bl) {
                this.txnLogManager.doCheckpoint();
            } else {
                this.txnLogManager.checkpoint();
            }
        } else if (bl) {
            StoreSyncTask storeSyncTask = new StoreSyncTask();
            storeSyncTask.run();
        } else {
            this.checkpoint();
        }
        return n;
    }

    @Override
    public final void checkpoint() {
        MQTimer mQTimer = Globals.getTimer();
        mQTimer.schedule((TimerTask)new StoreSyncTask(), 1000L);
    }

    private void processTxnRecMsgPart(DataInputStream dataInputStream, Set set) throws IOException, BrokerException {
        int n = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            MsgStore msgStore;
            Packet packet = new Packet(false);
            packet.generateTimestamp(false);
            packet.generateSequenceNumber(false);
            packet.readPacket(dataInputStream);
            SysMessageID sysMessageID = packet.getSysMessageID();
            Destination destination = Destination.getDestination(packet.getDestination(), packet.getIsQueue() ? 1 : 2, true, true);
            DestinationUID destinationUID = destination.getDestinationUID();
            if (!set.contains(destination)) {
                destination.load();
                set.add(destination);
            }
            if ((msgStore = this.getMsgStore()).containsMessage(destinationUID, sysMessageID)) {
                logger.log(64, "B1276", sysMessageID);
                msgStore.removeMessage(destinationUID, sysMessageID, false);
            } else {
                logger.log(64, "B1277", sysMessageID);
            }
            PacketReference packetReference = PacketReference.createReference(packet, destinationUID, null);
            try {
                destination.routeNewMessage(packetReference);
                continue;
            }
            catch (SelectorFormatException selectorFormatException) {
                throw new BrokerException(br.getString("B3227", sysMessageID), selectorFormatException);
            }
        }
    }

    private void processTxnRecAckPart(DataInputStream dataInputStream, Set set) throws IOException, BrokerException {
        int n = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            String string = dataInputStream.readUTF();
            DestinationUID destinationUID = new DestinationUID(string);
            SysMessageID sysMessageID = new SysMessageID();
            sysMessageID.readID(dataInputStream);
            ConsumerUID consumerUID = new ConsumerUID(dataInputStream.readLong());
            Destination destination = Destination.getDestination(destinationUID.getName(), destinationUID.isQueue() ? 1 : 2, true, true);
            if (!set.contains(destination)) {
                destination.load();
                set.add(destination);
            }
            if (this.msgStore.containsMessage(destinationUID, sysMessageID)) {
                logger.log(64, "B1278", (Object)consumerUID, sysMessageID);
                if (destination.isQueue() && consumerUID.longValue() != 0L) {
                    this.msgStore.updateInterestState(destinationUID, sysMessageID, PacketReference.getQueueUID(), 2, false);
                    continue;
                }
                this.msgStore.updateInterestState(destinationUID, sysMessageID, consumerUID, 2, false);
                continue;
            }
            logger.log(64, "B1279", (Object)consumerUID, sysMessageID);
        }
    }

    public TransactionLogManager getTxnLogManager() {
        return this.txnLogManager;
    }

    @Override
    public boolean isTxnConversionRequired() {
        return TxnConversionUtil.isTxnConversionRequired();
    }

    private class StoreSyncTask
    extends TimerTask {
        private StoreSyncTask() {
        }

        public void run() {
            try {
                TransactionLogWriter[] transactionLogWriterArray = new TransactionLogWriter[]{FileStore.this.msgLogWriter, FileStore.this.ackLogWriter};
                FileStore.this.syncStore(transactionLogWriterArray);
            }
            catch (Throwable throwable) {
                Store.logger.logStack(32, "B3100", "Failed to synchronize persistence store for transaction log checkpoint", throwable);
            }
        }
    }
}

