/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.auth.AccessController;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.service.ConnectionClosedListener;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public abstract class Connection {
    private static int clockSkewTime = Globals.getConfig().getIntProperty("imq.clock.skew.interval", 300);
    private static int clockSkewCheck = Globals.getConfig().getIntProperty("imq.clock.skew.checkCnt", 0);
    private int skewCheckCounter = 0;
    private long lastAccess = 0L;
    private long lastResponse = 0L;
    protected final Logger logger = Globals.getLogger();
    public static final int UNKNOWN_PROTOCOL = -1;
    public static final int SWIFT_PROTOCOL = 200;
    public static final int HUMMINGBIRD_PROTOCOL = 201;
    public static final int FALCON_PROTOCOL = 300;
    public static final int RAPTOR_PROTOCOL = 350;
    public static final int SHRIKE_PROTOCOL = 360;
    public static final int SHRIKE4_PROTOCOL = 364;
    public static final int HAWK_PROTOCOL = 400;
    public static final int V45_PROTOCOL = 450;
    public static final int STATE_UNAVAILABLE = -1;
    public static final int STATE_CONNECTED = 0;
    public static final int STATE_INITIALIZED = 1;
    public static final int STATE_AUTH_REQUESTED = 2;
    public static final int STATE_AUTH_RESPONSED = 3;
    public static final int STATE_AUTHENTICATED = 4;
    public static final int STATE_CLEANED = 5;
    public static final int STATE_CLOSED = 6;
    public static final int STATE_DESTROYING = 7;
    public static final int STATE_DESTROYED = 8;
    protected int state = -1;
    protected Service service = null;
    protected AccessController accessController = null;
    protected ConnectionUID conId = null;
    protected long reconnectInterval = 0L;
    protected int clientProtocolVersion = -1;
    protected Hashtable clientData = null;
    protected boolean isadmin = false;
    protected List consumerInfoRequests = Collections.synchronizedList(new ArrayList());
    protected List connCloseListeners = new ArrayList();

    public Connection(Service service) throws BrokerException {
        this.setService(service);
        this.isadmin = service.getServiceType() == 1;
    }

    public Hashtable getDebugState() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("uid", String.valueOf(this.conId.longValue()));
        hashtable.put("service", this.service.toString());
        hashtable.put("state", Connection.getConnectionStateString(this.state));
        if (this.clientData != null) {
            hashtable.put("clientData", this.clientData);
        } else {
            hashtable.put("clientData", "none");
        }
        hashtable.put("clientProtocol", String.valueOf(this.clientProtocolVersion));
        hashtable.put("reconnectInterval", String.valueOf(this.reconnectInterval));
        hashtable.put("lastAccess", String.valueOf(this.lastAccess));
        hashtable.put("lastResponse", String.valueOf(this.lastResponse));
        return hashtable;
    }

    public void setReconnectInterval(long l) {
        this.reconnectInterval = l;
    }

    public long getReconnectInterval() {
        return this.reconnectInterval;
    }

    public boolean isAdminConnection() {
        return this.isadmin;
    }

    public static int getHighestSupportedProtocol() {
        return 450;
    }

    public abstract void startConnection();

    public abstract void stopConnection();

    public abstract void cleanupConnection();

    public abstract void closeConnection(boolean var1, int var2, String var3);

    public abstract void shutdownConnection(String var1);

    public void destroyConnection(boolean bl, int n, String string) {
        this.service.removeConnection(this.conId, n, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyConnectionClosed() {
        Connection connection = this;
        synchronized (connection) {
            Iterator iterator = this.connCloseListeners.iterator();
            ConnectionClosedListener connectionClosedListener = null;
            while (iterator.hasNext()) {
                connectionClosedListener = (ConnectionClosedListener)iterator.next();
                connectionClosedListener.connectionClosed(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionClosedListener(ConnectionClosedListener connectionClosedListener) {
        Connection connection = this;
        synchronized (connection) {
            this.connCloseListeners.add(connectionClosedListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionClosedListener(ConnectionClosedListener connectionClosedListener) {
        Connection connection = this;
        synchronized (connection) {
            this.connCloseListeners.remove(connectionClosedListener);
        }
    }

    public abstract void logConnectionInfo(boolean var1);

    public abstract String getRemoteConnectionString();

    public ConnectionUID getConnectionUID() {
        return this.conId;
    }

    public void setConnectionUID(ConnectionUID connectionUID) {
        this.conId = connectionUID;
    }

    protected void setService(Service service) {
        this.service = service;
    }

    public Service getService() {
        return this.service;
    }

    public void setClientProtocolVersion(int n) {
        this.clientProtocolVersion = n;
    }

    public int getClientProtocolVersion() {
        return this.clientProtocolVersion;
    }

    public AccessController getAccessController() {
        return this.accessController;
    }

    public Principal getAuthenticatedName() throws BrokerException {
        return this.accessController.getAuthenticatedName();
    }

    public boolean setConnectionState(int n) {
        if (n >= 8) {
            return true;
        }
        this.state = n;
        return false;
    }

    public static String getConnectionStateString(int n) {
        switch (n) {
            case -1: {
                return "UNAVAILABLE";
            }
            case 0: {
                return "CONNECTED";
            }
            case 1: {
                return "INITIALIZED";
            }
            case 2: {
                return "AUTHENTICATION REQUESTED";
            }
            case 3: {
                return "AUTHENTICATION RESPONSED";
            }
            case 4: {
                return "AUTHENTICATED";
            }
            case 6: {
                return "CLOSED";
            }
            case 5: {
                return "CLEANED";
            }
            case 7: {
                return "DESTROYING";
            }
            case 8: {
                return "DESTROYED";
            }
        }
        return "UNKNOWN";
    }

    public int getConnectionState() {
        return this.state;
    }

    public void addClientData(String string, Object object) {
        if (this.clientData == null) {
            this.clientData = new Hashtable();
        }
        this.clientData.put(string, object);
    }

    public void removeClientData(String string) {
        if (this.clientData == null) {
            return;
        }
        this.clientData.remove(string);
    }

    public Object getClientData(String string) {
        if (this.clientData == null) {
            return null;
        }
        return this.clientData.get(string);
    }

    public void updateAccessTime(boolean bl) {
        this.lastAccess = System.currentTimeMillis();
        if (bl) {
            this.lastResponse = this.lastAccess;
        }
    }

    public long getAccessTime() {
        return this.lastAccess;
    }

    public long getLastResponseTime() {
        return this.lastResponse;
    }

    public void checkClockSkew(long l, long l2, long l3) {
        if (clockSkewCheck < 0) {
            return;
        }
        if (clockSkewCheck == 0 && this.skewCheckCounter > 0) {
            return;
        }
        ++this.skewCheckCounter;
        if (clockSkewCheck > 0 && this.skewCheckCounter % clockSkewCheck != 0) {
            return;
        }
        long l4 = Math.abs(l2 - l);
        long l5 = l4 / 1000L;
        long l6 = l3 == 0L ? 0L : (l > l2 ? l3 - l2 : 0L);
        long l7 = l6 / 1000L;
        if (l5 > (long)clockSkewTime) {
            String string = "B2102";
            if (l2 < l) {
                string = "B2103";
            }
            this.logger.log(16, string, (Object)this.getRemoteConnectionString(), String.valueOf(clockSkewTime));
        } else if (l6 != 0L && l7 < (long)clockSkewTime && l6 < 2L * l4) {
            this.logger.log(16, "B2104", this.getRemoteConnectionString());
        }
    }

    protected abstract void sayGoodbye(int var1, String var2);

    protected abstract void flushConnection(long var1);

    protected abstract void checkConnection();

    public abstract void cleanupMemory(boolean var1);

    public void debug(String string) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendConsumerInfo(int n, DestinationUID destinationUID, int n2, int n3, boolean bl) {
        DestinationUID destinationUID22 = null;
        List list = this.consumerInfoRequests;
        synchronized (list) {
            for (DestinationUID destinationUID22 : this.consumerInfoRequests) {
                if (!destinationUID22.isWildcard()) {
                    if (!destinationUID.equals(destinationUID22)) continue;
                    this.sendConsumerInfo(n, destinationUID22.getName(), n2, n3);
                    break;
                }
                if (destinationUID.isWildcard() && destinationUID22.getName().equals(destinationUID.getName()) && destinationUID.isQueue() == destinationUID22.isQueue()) {
                    this.sendConsumerInfo(n, destinationUID22.getName(), n2, n3);
                    break;
                }
                if (!DestinationUID.match(destinationUID, destinationUID22)) continue;
                if (bl) {
                    this.sendConsumerInfo(n, destinationUID22.getName(), n2, n3);
                    continue;
                }
                Globals.getConnectionManager().getConsumerInfoNotifyManager().consumerInfoRequested(this, destinationUID22, n2, n3);
            }
        }
    }

    protected abstract void sendConsumerInfo(int var1, String var2, int var3, int var4);

    public void addConsumerInfoRequest(DestinationUID destinationUID) {
        this.consumerInfoRequests.add(destinationUID);
    }

    public void removeConsumerInfoRequest(DestinationUID destinationUID) {
        this.consumerInfoRequests.remove(destinationUID);
    }
}

