/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.RemoteAcknowledgeException;
import com.sun.messaging.jmq.jmsclient.SessionImpl;
import com.sun.messaging.jmq.jmsclient.XAResourceForJMQ;
import com.sun.messaging.jmq.jmsclient.XAResourceForMC;
import com.sun.messaging.jmq.jmsclient.XASessionImpl;
import com.sun.messaging.jmq.util.JMQXid;
import com.sun.messaging.jmq.util.XidImpl;
import com.sun.messaging.jms.ra.OnMessageRunner;
import com.sun.messaging.jms.ra.ResourceAdapter;
import com.sun.messaging.jms.ra.util.XAResourceMapForRAMC;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XAResourceForRA
implements XAResource,
XAResourceForJMQ {
    private ConnectionImpl epConnection;
    private long resourceManagerId = 0L;
    private int transactionTimeout = 0;
    private OnMessageRunner omr;
    private int id;
    private long transactionID = -1L;
    private JMQXid jmqXid = null;
    protected boolean started = false;
    private boolean setRollback = false;
    private Exception rollbackCause = null;
    public static final int CREATED = 0;
    public static final int STARTED = 1;
    public static final int FAILED = 2;
    public static final int INCOMPLETE = 3;
    public static final int COMPLETE = 4;
    public static final int PREPARED = 5;
    private int resourceState = 0;
    private static Hashtable xaTable = new Hashtable();
    public static final Integer XA_START = 0;
    public static final Integer XA_END = 1;
    public static final Integer XA_PREPARE = 2;
    public static boolean turnOffXATracking = Boolean.getBoolean("imq.ra.turnOffXATracking");
    public static boolean XATracking = !turnOffXATracking;
    private static final transient String _className = "com.sun.messaging.jmq.jmsclient.XAResourceForRA";
    private static final transient String _lgrName = "com.sun.messaging.jmq.jmsclient.XAResourceForRA";
    private static final transient Logger _logger = Logger.getLogger("com.sun.messaging.jmq.jmsclient.XAResourceForRA");
    private static final transient String _lgrMIDPrefix = "MQJMSRA_XARMC";
    private static final transient String _lgrMID_EET = "MQJMSRA_XARMC1001: ";
    private static final transient String _lgrMID_INF = "MQJMSRA_XARMC1101: ";
    private static final transient String _lgrMID_WRN = "MQJMSRA_XARMC2001: ";
    private static final transient String _lgrMID_ERR = "MQJMSRA_XARMC3001: ";
    private static final transient String _lgrMID_EXC = "MQJMSRA_XARMC4001: ";

    public XAResourceForRA(OnMessageRunner onMessageRunner, ConnectionImpl connectionImpl, ConnectionImpl connectionImpl2) throws JMSException {
        this.omr = onMessageRunner;
        this.id = onMessageRunner.getId();
        this.epConnection = connectionImpl2;
        if (connectionImpl == null) {
            System.err.println("MQRA:XARFRA:constr:raConnectionNull:unable to acquire RMId:assuming distinct");
        } else if (connectionImpl._isClosed()) {
            System.err.println("MQRA:XARFRA:constr:raConnectionClosed:unable to acquire RMId:assuming distinct");
        } else {
            try {
                this.resourceManagerId = connectionImpl.getProtocolHandler().generateUID();
            }
            catch (Exception exception) {
                System.err.println("MQRA:XARFRA:constr:Exc acquiring RMId:assuming distinct");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void commit(Xid xid, boolean bl) throws XAException {
        JMQXid jMQXid;
        boolean bl2;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("MQJMSRA_XARMC1101: XAResourceForMC (" + this.hashCode() + ") Commit  " + this.printXid(xid) + " (onePhase=" + bl + ")");
        }
        JMQXid jMQXid2 = new JMQXid(xid);
        if (bl && this.setRollback) {
            Debug.printStackTrace(this.rollbackCause);
            XAException xAException = new XAException(-7);
            xAException.initCause(this.rollbackCause);
            throw xAException;
        }
        try {
            try {
                if (this.epConnection._isClosed()) {
                    System.err.println("MQRA:XARFRA:commit:ConnectionClosed:throw XAExc txn:1p=" + bl + ":xid=" + jMQXid2.toString());
                    XAException xAException = new XAException(-7);
                    throw xAException;
                }
                if (bl) {
                    if (this.epConnection.isConnectedToHABroker()) {
                        this.HAOnePhaseCommit(xid, jMQXid2);
                    } else {
                        this.epConnection.getProtocolHandler().commit(0L, 0x40000000, jMQXid2);
                    }
                } else if (this.epConnection.isConnectedToHABroker()) {
                    this.HATwoPhaseCommit(jMQXid2);
                } else {
                    this.epConnection.getProtocolHandler().commit(0L, 0, jMQXid2);
                }
                Object var8_7 = null;
                bl2 = false;
                jMQXid = this.jmqXid;
            }
            catch (Exception exception) {
                Exception exception2;
                if (exception instanceof RemoteAcknowledgeException) {
                    exception2 = (RemoteAcknowledgeException)exception;
                    XASessionImpl xASessionImpl = (XASessionImpl)this.omr.getEndpointConsumer().getXASession();
                    xASessionImpl.notifyRemoteAcknowledgeException((RemoteAcknowledgeException)exception2);
                }
                this.epConnection.waitForReconnecting(exception);
                Debug.printStackTrace(exception);
                exception2 = new XAException(-7);
                exception2.initCause(exception);
                throw exception2;
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            boolean bl3 = false;
            JMQXid jMQXid3 = this.jmqXid;
            XAResourceForJMQ[] xAResourceForJMQArray = XAResourceMapForRAMC.getXAResources((XidImpl)this.jmqXid, (boolean)bl3);
            int i = 0;
            while (true) {
                if (i >= xAResourceForJMQArray.length) {
                    XAResourceMapForRAMC.unregister((XidImpl)jMQXid3);
                    throw throwable;
                }
                XAResourceForJMQ xAResourceForJMQ = xAResourceForJMQArray[i];
                xAResourceForJMQ.clearTransactionInfo();
                ++i;
            }
        }
        XAResourceForJMQ[] xAResourceForJMQArray = XAResourceMapForRAMC.getXAResources((XidImpl)this.jmqXid, (boolean)bl2);
        for (int i = 0; i < xAResourceForJMQArray.length; ++i) {
            XAResourceForJMQ xAResourceForJMQ = xAResourceForJMQArray[i];
            xAResourceForJMQ.clearTransactionInfo();
        }
        XAResourceMapForRAMC.unregister((XidImpl)jMQXid);
        this.removeXid(jMQXid2);
    }

    public synchronized void end(Xid xid, int n) throws XAException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("MQJMSRA_XARMC1101: XAResourceForRA (" + this.hashCode() + ") End     " + this.printXid(xid) + this.printFlags(n));
        }
        JMQXid jMQXid = new JMQXid(xid);
        if (this.epConnection._isClosed()) {
            XAException xAException = new XAException(-7);
            throw xAException;
        }
        this.resourceState = this.isFail(n) ? 2 : (this.isSuspend(n) ? 3 : 4);
        if (ResourceAdapter.isRevert6882044()) {
            this.sendEndToBroker(n, jMQXid);
        } else if (this.resourceState == 4) {
            boolean bl = true;
            XAResourceForJMQ[] xAResourceForJMQArray = XAResourceMapForRAMC.getXAResources((XidImpl)jMQXid, (boolean)true);
            for (int i = 0; i < xAResourceForJMQArray.length; ++i) {
                XAResourceForJMQ xAResourceForJMQ = xAResourceForJMQArray[i];
                if (xAResourceForJMQ.isComplete()) continue;
                bl = false;
            }
            if (bl) {
                this.sendEndToBroker(n, jMQXid);
            }
        } else if (this.resourceState == 2) {
            this.sendEndToBroker(n, jMQXid);
        } else if (this.resourceState == 3) {
            // empty if block
        }
        this.started = false;
        if (this.isXATracking()) {
            xaTable.put(jMQXid, XA_END);
        }
    }

    private void sendEndToBroker(int n, JMQXid jMQXid) throws XAException {
        try {
            this.epConnection.getProtocolHandler().endTransaction(0L, n, jMQXid);
        }
        catch (JMSException jMSException) {
            Debug.printStackTrace(jMSException);
            XAException xAException = new XAException(-7);
            xAException.initCause(jMSException);
            throw xAException;
        }
    }

    public synchronized void _endLocal() throws XAException {
        try {
            this.epConnection.getProtocolHandler().commit(this.transactionID, 0, null);
        }
        catch (JMSException jMSException) {
            Debug.printStackTrace(jMSException);
            XAException xAException = new XAException(-7);
            xAException.initCause(jMSException);
            throw xAException;
        }
        this.started = false;
    }

    public void forget(Xid xid) throws XAException {
        XidImpl xidImpl = new XidImpl(xid);
        XAResourceMapForRAMC.unregister((XidImpl)xidImpl);
        if (this.jmqXid != null && this.jmqXid.equals(xidImpl)) {
            this.clearTransactionInfo();
        }
    }

    public int getTransactionTimeout() throws XAException {
        return this.transactionTimeout;
    }

    public boolean isSameRM(XAResource xAResource) throws XAException {
        if (xAResource instanceof XAResourceForMC || xAResource instanceof XAResourceForRA) {
            return this.isSameJMQRM((XAResourceForJMQ)((Object)xAResource));
        }
        return false;
    }

    public boolean isSameJMQRM(XAResourceForJMQ xAResourceForJMQ) {
        boolean bl = ResourceAdapter.isSameRMAllowed() ? this.getBrokerSessionID() != 0L && this.getBrokerSessionID() == xAResourceForJMQ.getBrokerSessionID() : false;
        return bl;
    }

    public long getBrokerSessionID() {
        return this.epConnection.getBrokerSessionID();
    }

    public synchronized int prepare(Xid xid, boolean bl) throws XAException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("MQJMSRA_XARMC1101: XAResourceForRA (" + this.hashCode() + ") Prepare     " + this.printXid(xid));
        }
        int n = 0;
        JMQXid jMQXid = new JMQXid(xid);
        if (this.setRollback) {
            Debug.printStackTrace(this.rollbackCause);
            XAException xAException = new XAException(-7);
            xAException.initCause(this.rollbackCause);
            throw xAException;
        }
        try {
            if (this.epConnection._isClosed()) {
                XAException xAException = new XAException(-7);
                throw xAException;
            }
            this.epConnection.getProtocolHandler().prepare(0L, jMQXid, bl);
        }
        catch (Exception exception) {
            Exception exception2;
            if (exception instanceof RemoteAcknowledgeException) {
                exception2 = (RemoteAcknowledgeException)exception;
                ((XASessionImpl)this.omr.getEndpointConsumer().getXASession()).notifyRemoteAcknowledgeException((RemoteAcknowledgeException)exception2);
            }
            Debug.printStackTrace(exception);
            exception2 = new XAException(-7);
            exception2.initCause(exception);
            throw exception2;
        }
        this.resourceState = 5;
        return n;
    }

    public synchronized int prepare(Xid xid) throws XAException {
        int n = 0;
        try {
            this.prepare(xid, false);
        }
        catch (XAException xAException) {
            if (this.epConnection.isConnectedToHABroker) {
                this.checkPrepareStatus(xAException, this.jmqXid);
            }
            throw xAException;
        }
        if (this.isXATracking()) {
            xaTable.put(this.jmqXid, XA_PREPARE);
        }
        return n;
    }

    private void HAOnePhaseCommit(Xid xid, JMQXid jMQXid) throws JMSException, XAException {
        int n = 1;
        try {
            this.prepare(xid, true);
            n = 2;
            if (this.isXATracking()) {
                xaTable.put(jMQXid, XA_PREPARE);
            }
            this.epConnection.getProtocolHandler().commit(0L, 0, jMQXid, true);
        }
        catch (Exception exception) {
            this.checkCommitStatus(exception, n, jMQXid, true);
        }
        this.removeXid(jMQXid);
    }

    private void HATwoPhaseCommit(JMQXid jMQXid) throws JMSException, XAException {
        try {
            this.epConnection.getProtocolHandler().commit(0L, 0, jMQXid);
        }
        catch (JMSException jMSException) {
            if (this.isXATracking()) {
                Integer n = (Integer)xaTable.get(jMQXid);
                if (n != null && n == 2) {
                    this.checkCommitStatus(jMSException, 2, jMQXid, false);
                }
            }
            throw jMSException;
        }
        this.removeXid(jMQXid);
    }

    private void checkPrepareStatus(XAException xAException, JMQXid jMQXid) throws XAException {
        if (!this.epConnection.imqReconnect) {
            throw xAException;
        }
        try {
            SessionImpl.yield();
            this.epConnection.checkReconnecting(null);
            if (this.epConnection.isCloseCalled || this.epConnection.connectionIsBroken) {
                throw xAException;
            }
            this.verifyPrepare(jMQXid);
        }
        catch (XAException xAException2) {
            throw xAException2;
        }
        catch (Exception exception) {
            XAException xAException3 = new XAException(-7);
            xAException3.initCause(exception);
            throw xAException3;
        }
    }

    private void verifyPrepare(JMQXid jMQXid) throws XAException, JMSException {
        SessionImpl.sessionLogger.log(Level.INFO, "XA verifyPrepare(), jmqXid: " + jMQXid);
        int n = this.epConnection.protocolHandler.verifyHATransaction(0L, 1, jMQXid);
        switch (n) {
            case 6: {
                SessionImpl.sessionLogger.log(Level.INFO, "transaction in prepared state: " + this.transactionID);
                return;
            }
        }
        XAException xAException = new XAException(100);
        throw xAException;
    }

    private void checkCommitStatus(Exception exception, int n, JMQXid jMQXid, boolean bl) throws JMSException, XAException {
        try {
            this.doCheckCommitStatus(exception, n, jMQXid, bl);
        }
        catch (Exception exception2) {
            if (exception2 instanceof JMSException) {
                throw (JMSException)exception2;
            }
            if (exception2 instanceof XAException) {
                throw (XAException)exception2;
            }
            XAException xAException = new XAException(-7);
            xAException.initCause(exception2);
            throw xAException;
        }
    }

    private void doCheckCommitStatus(Exception exception, int n, JMQXid jMQXid, boolean bl) throws Exception {
        if (!this.epConnection.imqReconnect) {
            throw exception;
        }
        SessionImpl.yield();
        this.epConnection.checkReconnecting(null);
        if (this.epConnection.isCloseCalled || this.epConnection.connectionIsBroken) {
            throw exception;
        }
        this.verifyTransaction(n, jMQXid, bl);
    }

    private void verifyTransaction(int n, JMQXid jMQXid, boolean bl) throws JMSException, XAException {
        int n2 = this.epConnection.protocolHandler.verifyHATransaction(0L, n, jMQXid);
        switch (n2) {
            case 7: {
                return;
            }
            case 6: {
                try {
                    SessionImpl.sessionLogger.log(Level.INFO, "XA verifyTransaction(): transaction is in prepred state, committing the transaction: " + this.transactionID);
                    this.epConnection.getProtocolHandler().commit(0L, 0, jMQXid, bl);
                    SessionImpl.sessionLogger.log(Level.INFO, "XA verifyTransaction(): prepared transaction committed successfully: " + this.transactionID);
                    return;
                }
                catch (JMSException jMSException) {
                    SessionImpl.yield();
                    this.epConnection.checkReconnecting(null);
                    throw jMSException;
                }
            }
        }
        XAException xAException = new XAException(100);
        throw xAException;
    }

    public Xid[] recover(int n) throws XAException {
        Xid[] xidArray = null;
        try {
            if (this.epConnection._isClosed()) {
                XAException xAException = new XAException(-7);
                throw xAException;
            }
            xidArray = this.epConnection.getProtocolHandler().recover(n);
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            XAException xAException = new XAException(-7);
            xAException.initCause(exception);
            throw xAException;
        }
        return xidArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void rollback(Xid xid) throws XAException {
        JMQXid jMQXid;
        boolean bl;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("MQJMSRA_XARMC1101: XAResourceForMC (" + this.hashCode() + ") Rollback  " + this.printXid(xid) + ")");
        }
        JMQXid jMQXid2 = new JMQXid(xid);
        try {
            try {
                if (this.epConnection._isClosed()) {
                    XAException xAException = new XAException(-7);
                    throw xAException;
                }
                if (this.epConnection.isConnectedToHABroker()) {
                    this.HARollback(jMQXid2);
                } else {
                    this.epConnection.getProtocolHandler().rollback(0L, jMQXid2, true);
                }
                Object var6_5 = null;
                bl = false;
                jMQXid = this.jmqXid;
            }
            catch (JMSException jMSException) {
                Debug.printStackTrace(jMSException);
                XAException xAException = new XAException(-7);
                xAException.initCause(jMSException);
                throw xAException;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            boolean bl2 = false;
            JMQXid jMQXid3 = this.jmqXid;
            XAResourceForJMQ[] xAResourceForJMQArray = XAResourceMapForRAMC.getXAResources((XidImpl)this.jmqXid, (boolean)bl2);
            int i = 0;
            while (true) {
                if (i >= xAResourceForJMQArray.length) {
                    XAResourceMapForRAMC.unregister((XidImpl)jMQXid3);
                    throw throwable;
                }
                XAResourceForJMQ xAResourceForJMQ = xAResourceForJMQArray[i];
                xAResourceForJMQ.clearTransactionInfo();
                ++i;
            }
        }
        XAResourceForJMQ[] xAResourceForJMQArray = XAResourceMapForRAMC.getXAResources((XidImpl)this.jmqXid, (boolean)bl);
        for (int i = 0; i < xAResourceForJMQArray.length; ++i) {
            XAResourceForJMQ xAResourceForJMQ = xAResourceForJMQArray[i];
            xAResourceForJMQ.clearTransactionInfo();
        }
        XAResourceMapForRAMC.unregister((XidImpl)jMQXid);
        this.removeXid(jMQXid2);
    }

    private void HARollback(JMQXid jMQXid) throws JMSException, XAException {
        try {
            this.epConnection.getProtocolHandler().rollback(0L, jMQXid, true);
        }
        catch (JMSException jMSException) {
            SessionImpl.yield();
            this.epConnection.checkReconnecting(null);
            if (this.epConnection.isCloseCalled || this.epConnection.connectionIsBroken) {
                throw jMSException;
            }
            this.retryRollBack(jMQXid);
        }
        this.removeXid(jMQXid);
    }

    private void retryRollBack(JMQXid jMQXid) throws JMSException, XAException {
        try {
            this.epConnection.getProtocolHandler().rollback(0L, jMQXid, true, true);
        }
        catch (JMSException jMSException) {
            if (this.isXATracking()) {
                Integer n = (Integer)xaTable.get(jMQXid);
                if (n != null && n != 2) {
                    ConnectionImpl.connectionLogger.log(Level.WARNING, jMSException.toString());
                }
                throw jMSException;
            }
            throw jMSException;
        }
    }

    public boolean setTransactionTimeout(int n) throws XAException {
        return false;
    }

    public synchronized void start(Xid xid, int n) throws XAException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("MQJMSRA_XARMC1101: XAResourceForRA (" + this.hashCode() + ") Start   " + this.printXid(xid) + this.printFlags(n));
        }
        JMQXid jMQXid = new JMQXid(xid);
        if (!this.isResume(n) || ResourceAdapter.isRevert6882044()) {
            try {
                if (this.epConnection._isClosed()) {
                    XAException xAException = new XAException(-7);
                    throw xAException;
                }
                this.transactionID = this.epConnection.getProtocolHandler().startTransaction(this.transactionID, n, jMQXid);
                this.jmqXid = jMQXid;
            }
            catch (JMSException jMSException) {
                Debug.printStackTrace(jMSException);
                XAException xAException = new XAException(-7);
                xAException.initCause(jMSException);
                throw xAException;
            }
            XAResourceMapForRAMC.register((XidImpl)jMQXid, (XAResourceForJMQ)this, (boolean)this.isJoin(n));
        }
        this.started = true;
        this.resourceState = 1;
        if (this.isXATracking()) {
            xaTable.put(jMQXid, XA_START);
        }
    }

    public synchronized void _startLocal() throws XAException {
        try {
            this.transactionID = this.epConnection.protocolHandler.startTransaction(-1L, 0, null);
        }
        catch (JMSException jMSException) {
            Debug.printStackTrace(jMSException);
            XAException xAException = new XAException(-7);
            xAException.initCause(jMSException);
            throw xAException;
        }
        this.started = true;
    }

    public int getId() {
        return this.id;
    }

    public synchronized long getTransactionID() {
        return this.transactionID;
    }

    public boolean started() {
        return this.started;
    }

    public long getResourceManagerId() {
        return this.resourceManagerId;
    }

    public void setRollback(boolean bl, Exception exception) {
        this.setRollback = bl;
        this.rollbackCause = exception;
    }

    public boolean isComplete() {
        return this.resourceState == 4;
    }

    public void clearTransactionInfo() {
        this.resourceState = 0;
    }

    private boolean isXATracking() {
        return this.epConnection.isConnectedToHABroker() && XATracking;
    }

    private void removeXid(JMQXid jMQXid) {
        if (this.isXATracking()) {
            xaTable.remove(jMQXid);
        }
    }

    private boolean isJoin(int n) {
        return (n & 0x200000) == 0x200000;
    }

    private boolean isResume(int n) {
        return (n & 0x8000000) == 0x8000000;
    }

    private boolean isFail(int n) {
        return (n & 0x20000000) == 0x20000000;
    }

    private boolean isSuspend(int n) {
        return (n & 0x2000000) == 0x2000000;
    }

    private String printXid(Xid xid) {
        return "(GlobalTransactionID=" + xid.getGlobalTransactionId() + ", BranchQualifier=" + xid.getBranchQualifier() + ") ";
    }

    private String printFlags(int n) {
        String string = "(Flags: ";
        if (this.isJoin(n)) {
            string = string + "JOIN ";
        }
        if (this.isNoFlags(n)) {
            string = string + "TMNOFLAGS ";
        }
        if (this.isFail(n)) {
            string = string + "TMFAIL ";
        }
        if (this.isOnePhase(n)) {
            string = string + "TMONEPHASE ";
        }
        if (this.isResume(n)) {
            string = string + "TMRESUME ";
        }
        if (this.isSuccess(n)) {
            string = string + "TMSUCCESS ";
        }
        if (this.isSuspend(n)) {
            string = string + "TMSUSPEND ";
        }
        if (this.isTMENDRSCAN(n)) {
            string = string + "TMENDRSCAN ";
        }
        if (this.TMSTARTRSCAN(n)) {
            string = string + "TMSTARTRSCAN ";
        }
        string = string + ")";
        return string;
    }

    private boolean isNoFlags(int n) {
        return (n & 0) == 0;
    }

    private boolean isOnePhase(int n) {
        return (n & 0x40000000) == 0x40000000;
    }

    private boolean isSuccess(int n) {
        return (n & 0x4000000) == 0x4000000;
    }

    private boolean isTMENDRSCAN(int n) {
        return (n & 0x800000) == 0x800000;
    }

    private boolean TMSTARTRSCAN(int n) {
        return (n & 0x1000000) == 0x1000000;
    }
}

