/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.auth.jaas;

import com.sun.messaging.jmq.auth.api.server.model.UserRepository;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.auth.jaas.CallbackHandlerImpl;
import com.sun.messaging.jmq.jmsserver.auth.jaas.SubjectHelper;
import com.sun.messaging.jmq.util.StringUtil;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.Destroyable;
import javax.security.auth.Refreshable;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class UserRepositoryImpl
implements UserRepository {
    private static boolean DEBUG = false;
    public static final String TYPE = "jaas";
    public static final String PROP_NAME_SUFFIX = ".name";
    public static final String SUBJECT_HELPER_SUFFIX = ".subjectHelperClass";
    public static final String SUBJECT_HELPER_PROPS_SUFFIX = ".subjectHelperClass.props";
    public static final String SUBJECT_HELPER_EMBEDDED_PROP = "imq.embedded";
    public static final String SUBJECT_HELPER_JMSRA_MANAGED_PROP = "imq.jmsra.managed";
    private Logger logger = Globals.getLogger();
    private String authType = null;
    private Properties authProps = null;
    private String name = null;
    private SubjectHelper subjectHelper = null;
    private LoginContext lc = null;
    private Object lock = new Object();
    private boolean login = false;
    private boolean logout = false;

    public String getType() {
        return TYPE;
    }

    public void open(String string, Properties properties, Refreshable refreshable) throws LoginException {
        this.authType = string;
        this.authProps = properties;
        String string2 = this.authProps.getProperty("imq.authentication." + string + ".user_repository");
        if (string2 == null) {
            throw new LoginException(Globals.getBrokerResources().getKString("B4041", string));
        }
        if (!string2.equals(TYPE)) {
            Object[] objectArray = new String[]{string2, TYPE, this.getClass().getName()};
            throw new LoginException(Globals.getBrokerResources().getKString("B4070", objectArray));
        }
        String string3 = "imq.user_repository." + string2;
        this.name = this.authProps.getProperty(string3 + PROP_NAME_SUFFIX);
        if (this.name == null) {
            throw new LoginException(Globals.getBrokerResources().getKString("B4211"));
        }
        String string4 = this.authProps.getProperty(string3 + SUBJECT_HELPER_SUFFIX);
        if (string4 != null) {
            try {
                this.subjectHelper = (SubjectHelper)Class.forName(string4).newInstance();
                Properties properties2 = null;
                String string5 = this.authProps.getProperty(string3 + SUBJECT_HELPER_PROPS_SUFFIX);
                if (string5 != null) {
                    properties2 = StringUtil.toProperties(string5);
                }
                if (properties2 == null) {
                    properties2 = new Properties();
                }
                if (Broker.isInProcess()) {
                    properties2.setProperty(SUBJECT_HELPER_EMBEDDED_PROP, "true");
                }
                if (Globals.isJMSRAManagedBroker()) {
                    properties2.setProperty(SUBJECT_HELPER_JMSRA_MANAGED_PROP, "true");
                }
                this.subjectHelper.init(this.name, properties2, null);
            }
            catch (Exception exception) {
                this.logger.logStack(32, "Unable to instantiate class " + string4, exception);
                throw new LoginException(exception.getMessage());
            }
        }
        if (DEBUG) {
            this.logger.log(8, "Using JAAS authentication " + this.name + (string4 == null ? "" : " with subject helper class " + string4));
        }
    }

    public Subject findMatch(String string, Object object, Object object2, String string2) throws LoginException {
        if (string2 != null && string2.equals("basic")) {
            return this.basicFindMatch(string, (String)object);
        }
        String string3 = string2 == null ? "null" : string2;
        Object[] objectArray = new String[]{string3, this.authType, this.getType(), "basic"};
        throw new LoginException(Globals.getBrokerResources().getKString("B4079", objectArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Subject basicFindMatch(String string, String string2) throws LoginException {
        if (DEBUG) {
            this.logger.log(4, "Authentication type basic - " + string + ":" + string2);
        }
        CallbackHandlerImpl callbackHandlerImpl = new CallbackHandlerImpl(this.authProps, string, string2);
        Subject subject = null;
        if (this.subjectHelper != null) {
            try {
                subject = this.subjectHelper.makeSubject(string, string2);
            }
            catch (Exception exception) {
                String string3 = "Failed to make subject of user " + string;
                this.logger.logStack(32, string3, exception);
                LoginException loginException = new LoginException(string3);
                loginException.initCause(exception);
                throw loginException;
            }
        }
        this.lc = new LoginContext(this.name, subject, callbackHandlerImpl);
        Object object = this.lock;
        synchronized (object) {
            if (this.logout) {
                throw new LoginException(Globals.getBrokerResources().getKString("B4108"));
            }
            this.lc.login();
            this.login = true;
            callbackHandlerImpl.destroy();
            Subject subject2 = this.lc.getSubject();
            Set<Object> set = subject2.getPrivateCredentials();
            Iterator<Object> iterator = set.iterator();
            Object object2 = null;
            while (iterator.hasNext()) {
                try {
                    object2 = iterator.next();
                    if (object2 == null || !(object2 instanceof Destroyable) || ((Destroyable)object2).isDestroyed()) continue;
                    ((Destroyable)object2).destroy();
                }
                catch (Exception exception) {
                    this.logger.log(16, "XXX Unable to destroy private credential:" + object2.getClass().getName() + " for " + string);
                }
            }
            return subject2;
        }
    }

    public Refreshable getCacheData() {
        if (this.subjectHelper == null) {
            return null;
        }
        return this.subjectHelper.getCacheData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws LoginException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.logout && this.login) {
                this.lc.logout();
                this.logout = true;
            }
        }
    }
}

