/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.bridge.service.DupKeyException;
import com.sun.messaging.bridge.service.KeyNotFoundException;
import com.sun.messaging.bridge.service.UpdateOpaqueDataCallback;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.BrokerState;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.persist.ChangeRecordInfo;
import com.sun.messaging.jmq.jmsserver.persist.HABrokerInfo;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.TakeoverLockException;
import com.sun.messaging.jmq.jmsserver.persist.TakeoverStoreInfo;
import com.sun.messaging.jmq.jmsserver.persist.TransactionInfo;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BrokerDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DAOFactory;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBConstants;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBTool;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DestinationDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.MessageEnumeration;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.StoreSessionDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.UpgradeStore;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.VersionDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.comm.BaseDAO;
import com.sun.messaging.jmq.jmsserver.service.TakingoverTracker;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimerTask;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCStore
extends Store
implements DBConstants {
    private static boolean DEBUG = JDBCStore.getDEBUG();
    public static final String LOCK_STORE_PROP = "imq.persist.jdbc.lockstore.enabled";
    private static final String MSG_ENUM_USE_CURSOR_PROP = "imq.persist.jdbc.msgEnumUseResultSetCursor";
    public static final int OLD_STORE_VERSION_350 = 350;
    public static final int OLD_STORE_VERSION_370 = 370;
    public static final int OLD_STORE_VERSION_400 = 400;
    public static final int STORE_VERSION = 410;
    DBManager dbmgr;
    DAOFactory daoFactory;
    private HashMap pendingDeleteDsts;
    private HashMap takeoverLockMap;
    private StoreSessionReaperTask sessionReaper;
    private boolean msgEnumUseCursor;
    private List<Enumeration> dataEnums;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JDBCStore() throws BrokerException {
        BrokerException brokerException;
        Connection connection;
        block16: {
            block15: {
                String string;
                this.pendingDeleteDsts = new HashMap(5);
                this.takeoverLockMap = new HashMap();
                this.sessionReaper = null;
                this.msgEnumUseCursor = true;
                this.dataEnums = Collections.synchronizedList(new ArrayList());
                this.dbmgr = DBManager.getDBManager();
                this.daoFactory = this.dbmgr.getDAOFactory();
                String string2 = this.dbmgr.getOpenDBURL();
                if (string2 == null) {
                    string2 = "not specified";
                }
                if ((string = this.dbmgr.getUser()) == null) {
                    string = "not specified";
                }
                Object[] objectArray = new String[]{String.valueOf(410), this.dbmgr.getBrokerID(), string2, string};
                logger.logToAll(8, br.getString("B1067", objectArray));
                if (this.createStore) {
                    logger.log(8, "B1170");
                } else {
                    logger.log(8, "B1171");
                }
                this.msgEnumUseCursor = config.getBooleanProperty(MSG_ENUM_USE_CURSOR_PROP, !this.dbmgr.isHADB());
                connection = null;
                brokerException = null;
                try {
                    try {
                        connection = this.dbmgr.getConnection(true);
                        if (!this.checkStore(connection)) {
                            this.closeDB(false);
                            Object var11_6 = null;
                            break block15;
                        }
                        if (Globals.getHAEnabled()) {
                            try {
                                long l = 86400000L;
                                long l2 = 60000L + (long)(Math.random() * 240000.0);
                                this.sessionReaper = new StoreSessionReaperTask(this);
                                Globals.getTimer().schedule((TimerTask)this.sessionReaper, l2, l);
                                if (DEBUG) {
                                    logger.log(4, "Store session reaper task has been successfully scheduled [delay=" + l2 + ", period=" + l + "]");
                                }
                                break block16;
                            }
                            catch (IllegalStateException illegalStateException) {
                                logger.log(8, "B3100", (Object)"Cannot schedule inactive store session reaper task, the broker is probably shutting down", (Throwable)illegalStateException);
                            }
                            break block16;
                        }
                        if (config.getBooleanProperty(LOCK_STORE_PROP, true)) {
                            DBManager.lockTables(connection, true);
                        }
                        break block16;
                    }
                    catch (BrokerException brokerException2) {
                        brokerException = brokerException2;
                        throw brokerException2;
                    }
                }
                catch (Throwable throwable) {
                    Object var11_8 = null;
                    Util.close(null, null, connection, brokerException);
                    throw throwable;
                }
            }
            Util.close(null, null, connection, brokerException);
            return;
        }
        Object var11_7 = null;
        Util.close(null, null, connection, brokerException);
        this.dbmgr.setStoreInited(true);
        if (DEBUG) {
            logger.log(4, "JDBCStore instantiated.");
        }
    }

    @Override
    public final int getStoreVersion() {
        return 410;
    }

    @Override
    public void storeMessage(DestinationUID destinationUID, Packet packet, ConsumerUID[] consumerUIDArray, int[] nArray, boolean bl) throws BrokerException {
        if (packet == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.storeMessage() called with message: " + packet.getSysMessageID().getUniqueName());
        }
        if (consumerUIDArray.length == 0 || consumerUIDArray.length != nArray.length) {
            throw new BrokerException(br.getKString("B3085"));
        }
        this.storeMessage(destinationUID, packet, consumerUIDArray, nArray, this.getStoreSession(), true);
    }

    @Override
    public void storeMessage(DestinationUID destinationUID, Packet packet, boolean bl) throws BrokerException {
        if (packet == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.storeMessage() called with message: " + packet.getSysMessageID().getUniqueName());
        }
        this.storeMessage(destinationUID, packet, null, null, this.getStoreSession(), true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void storeMessage(DestinationUID destinationUID, Packet packet, ConsumerUID[] consumerUIDArray, int[] nArray, long l, boolean bl) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getMessageDAO().insert(null, destinationUID, packet, consumerUIDArray, nArray, l, packet.getTimestamp(), bl);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var11_8 = null;
                this.setInProgress(false);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var11_9 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    @Override
    public void moveMessage(Packet packet, DestinationUID destinationUID, DestinationUID destinationUID2, ConsumerUID[] consumerUIDArray, int[] nArray, boolean bl) throws IOException, BrokerException {
        if (packet == null || destinationUID == null || destinationUID2 == null) {
            throw new NullPointerException();
        }
        if (Store.getDEBUG()) {
            logger.log(4, "JDBCStore.moveMessage() called for message: " + packet.getSysMessageID().getUniqueName() + " from " + destinationUID + " to " + destinationUID2);
        }
        super.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getMessageDAO().moveMessage(null, packet, destinationUID, destinationUID2, consumerUIDArray, nArray);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var10_8 = null;
                super.setInProgress(false);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            super.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void removeMessage(DestinationUID destinationUID, SysMessageID sysMessageID, boolean bl, boolean bl2) throws BrokerException {
        if (sysMessageID == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.removeMessage() called with message: " + sysMessageID.getUniqueName());
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getMessageDAO().delete(null, destinationUID, sysMessageID);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var8_6 = null;
                this.setInProgress(false);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void removeAllMessages(Destination destination, boolean bl) throws IOException, BrokerException {
        if (destination == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.removeAllMessages() for destination: " + destination.getUniqueName());
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getMessageDAO().deleteByDestination(null, destination.getDestinationUID());
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var6_4 = null;
                this.setInProgress(false);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    @Override
    public Enumeration messageEnumeration(Destination destination) throws BrokerException {
        return this.messageEnumeration(destination, this.dbmgr.getBrokerID());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Enumeration messageEnumeration(Destination destination, String string) throws BrokerException {
        if (destination == null) {
            throw new NullPointerException();
        }
        if (Store.getDEBUG()) {
            logger.log(4, "JDBCStore.messageEnumeration() called for destination: " + destination.getUniqueName());
        }
        this.checkClosedAndSetInProgress();
        if (!this.msgEnumUseCursor) {
            try {
                Util.RetryStrategy retryStrategy = null;
                while (true) {
                    Enumeration enumeration;
                    try {
                        enumeration = this.daoFactory.getMessageDAO().messageEnumeration(destination, string);
                    }
                    catch (Exception exception) {
                        if (retryStrategy == null) {
                            retryStrategy = new Util.RetryStrategy();
                        }
                        retryStrategy.assertShouldRetry(exception);
                        continue;
                    }
                    Object var6_9 = null;
                    this.setInProgress(false);
                    return enumeration;
                }
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                this.setInProgress(false);
                throw throwable;
            }
        }
        Enumeration enumeration = null;
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    enumeration = this.daoFactory.getMessageDAO().messageEnumerationCursor(destination, string);
                    this.dataEnums.add(enumeration);
                    return enumeration;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            try {
                if (enumeration != null) {
                    this.dataEnums.remove(enumeration);
                    ((MessageEnumeration)enumeration).close();
                }
                if (!(throwable instanceof BrokerException)) throw new BrokerException(throwable.toString(), throwable);
                throw (BrokerException)throwable;
            }
            catch (Throwable throwable2) {
                Object var8_14 = null;
                this.setInProgress(false);
                throw throwable2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeEnumeration(Enumeration enumeration) {
        if (!(enumeration instanceof MessageEnumeration)) {
            return;
        }
        try {
            this.dataEnums.remove(enumeration);
            ((MessageEnumeration)enumeration).close();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.setInProgress(false);
            throw throwable;
        }
        this.setInProgress(false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getMessageCount(String string) throws BrokerException {
        if (string == null) {
            throw new NullPointerException();
        }
        if (Store.getDEBUG()) {
            logger.log(4, "JDBCStore.getMessageCount() called for broker: " + string);
        }
        super.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                int n;
                try {
                    n = this.daoFactory.getMessageDAO().getMessageCount(null, string);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var5_5 = null;
                this.setInProgress(false);
                return n;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public HashMap getMessageStorageInfo(Destination destination) throws BrokerException {
        if (destination == null) {
            throw new NullPointerException();
        }
        if (Store.getDEBUG()) {
            logger.log(4, "JDBCStore.getMessageStorageInfo() called for destination: " + destination.getUniqueName());
        }
        super.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                HashMap hashMap;
                try {
                    hashMap = this.daoFactory.getMessageDAO().getMessageStorageInfo(null, destination);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var5_5 = null;
                this.setInProgress(false);
                return hashMap;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    @Override
    public Packet getMessage(DestinationUID destinationUID, SysMessageID sysMessageID) throws BrokerException {
        if (sysMessageID == null) {
            throw new NullPointerException();
        }
        return this.getMessage(destinationUID, sysMessageID.toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Packet getMessage(DestinationUID destinationUID, String string) throws BrokerException {
        if (string == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.getMessage() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                Packet packet;
                try {
                    packet = this.daoFactory.getMessageDAO().getMessage(null, destinationUID, string);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var6_6 = null;
                this.setInProgress(false);
                return packet;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void storeInterestStates(DestinationUID destinationUID, SysMessageID sysMessageID, ConsumerUID[] consumerUIDArray, int[] nArray, boolean bl, Packet packet) throws BrokerException {
        if (sysMessageID == null) throw new NullPointerException();
        if (consumerUIDArray == null) throw new NullPointerException();
        if (nArray == null) {
            throw new NullPointerException();
        }
        if (consumerUIDArray.length == 0) throw new BrokerException(br.getKString("B3085"));
        if (consumerUIDArray.length != nArray.length) {
            throw new BrokerException(br.getKString("B3085"));
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.storeInterestStates() called with message: " + sysMessageID.getUniqueName());
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getConsumerStateDAO().insert(null, destinationUID.toString(), sysMessageID, consumerUIDArray, nArray, true);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var10_8 = null;
                this.setInProgress(false);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void updateInterestState(DestinationUID destinationUID, SysMessageID sysMessageID, ConsumerUID consumerUID, int n, boolean bl, TransactionUID transactionUID, boolean bl2) throws BrokerException {
        if (sysMessageID == null) throw new NullPointerException();
        if (consumerUID == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.updateInterestState() called with message: " + sysMessageID.getUniqueName() + ", consumer: " + consumerUID.getUniqueName() + ", state=" + n);
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getConsumerStateDAO().updateState(null, destinationUID, sysMessageID, consumerUID, n);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var11_9 = null;
                this.setInProgress(false);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void updateInterestState(DestinationUID destinationUID, SysMessageID sysMessageID, ConsumerUID consumerUID, int n, int n2) throws BrokerException {
        if (sysMessageID == null) throw new NullPointerException();
        if (consumerUID == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.updateInterestState() called with message: " + sysMessageID.getUniqueName() + ", consumer: " + consumerUID.getUniqueName() + ", state=" + n + ", expected: " + n2);
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getConsumerStateDAO().updateState(null, destinationUID, sysMessageID, consumerUID, n, n2);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var9_7 = null;
                this.setInProgress(false);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    @Override
    public int getInterestState(DestinationUID destinationUID, SysMessageID sysMessageID, ConsumerUID consumerUID) throws BrokerException {
        if (sysMessageID == null) throw new NullPointerException();
        if (destinationUID == null) throw new NullPointerException();
        if (consumerUID == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.getInterestState() called with message: " + sysMessageID.getUniqueName());
        }
        this.checkClosedAndSetInProgress();
        Connection connection = null;
        BrokerException brokerException = null;
        try {
            try {
                connection = this.dbmgr.getConnection(true);
                Util.RetryStrategy retryStrategy = null;
                while (true) {
                    int n;
                    try {
                        this.daoFactory.getMessageDAO().checkMessage(connection, destinationUID.toString(), sysMessageID.getUniqueName());
                        n = this.daoFactory.getConsumerStateDAO().getState(connection, sysMessageID, consumerUID);
                    }
                    catch (Exception exception) {
                        if (retryStrategy == null) {
                            retryStrategy = new Util.RetryStrategy();
                        }
                        retryStrategy.assertShouldRetry(exception);
                        continue;
                    }
                    Object var9_10 = null;
                    try {
                        Util.close(null, null, connection, brokerException);
                        Object var11_12 = null;
                        this.setInProgress(false);
                        return n;
                    }
                    catch (Throwable throwable) {
                        Object var11_13 = null;
                        this.setInProgress(false);
                        throw throwable;
                    }
                    break;
                }
            }
            catch (BrokerException brokerException2) {
                brokerException = brokerException2;
                throw brokerException2;
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            try {}
            catch (Throwable throwable2) {
                Object var11_15 = null;
                this.setInProgress(false);
                throw throwable2;
            }
            Util.close(null, null, connection, brokerException);
            Object var11_14 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public HashMap getInterestStates(DestinationUID var1_1, SysMessageID var2_2) throws BrokerException {
        block16: {
            if (var2_2 == null) throw new NullPointerException();
            if (var1_1 == null) {
                throw new NullPointerException();
            }
            if (JDBCStore.DEBUG) {
                JDBCStore.logger.log(4, "JDBCStore.getInterestStates() called with message: " + var2_2.getUniqueName());
            }
            this.checkClosedAndSetInProgress();
            var3_3 = null;
            var4_4 = null;
            try {
                try {
                    var3_3 = this.dbmgr.getConnection(true);
                    var5_5 = null;
                    while (true) {
                        try {
                            var6_8 = this.daoFactory.getConsumerStateDAO().getStates(var3_3, var2_2);
                            ** break;
                        }
                        catch (Exception var6_7) {
                            if (var5_5 == null) {
                                var5_5 = new Util.RetryStrategy();
                            }
                            var5_5.assertShouldRetry(var6_7);
                            continue;
                        }
                        break;
                    }
lbl23:
                    // 1 sources

                    var8_9 = null;
                }
                catch (BrokerException var5_6) {
                    var4_4 = var5_6;
                    throw var5_6;
                }
            }
            catch (Throwable var7_15) {
                var8_10 = null;
                try {
                    Util.close(null, null, var3_3, var4_4);
                    v0 = null;
                }
                catch (Throwable var9_12) {
                    v0 = null;
                }
                var10_14 = v0;
                this.setInProgress(false);
                throw var7_15;
            }
            ** try [egrp 3[TRYBLOCK] [5 : 139->153)] { 
lbl43:
            // 1 sources

            Util.close(null, null, var3_3, var4_4);
            v1 = null;
            break block16;
lbl46:
            // 1 sources

            catch (Throwable var9_11) {
                v1 = null;
            }
        }
        var10_13 = v1;
        this.setInProgress(false);
        return var6_8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    @Override
    public ConsumerUID[] getConsumerUIDs(DestinationUID destinationUID, SysMessageID sysMessageID) throws BrokerException {
        if (sysMessageID == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.getConsumerUIDs() called with message: " + sysMessageID.getUniqueName());
        }
        this.checkClosedAndSetInProgress();
        Connection connection = null;
        BrokerException brokerException = null;
        try {
            try {
                connection = this.dbmgr.getConnection(true);
                Util.RetryStrategy retryStrategy = null;
                while (true) {
                    ConsumerUID[] consumerUIDArray;
                    try {
                        this.daoFactory.getMessageDAO().checkMessage(connection, destinationUID.toString(), sysMessageID.getUniqueName());
                        consumerUIDArray = this.daoFactory.getConsumerStateDAO().getConsumerUIDs(connection, sysMessageID).toArray(new ConsumerUID[0]);
                    }
                    catch (Exception exception) {
                        if (retryStrategy == null) {
                            retryStrategy = new Util.RetryStrategy();
                        }
                        retryStrategy.assertShouldRetry(exception);
                        continue;
                    }
                    Object var8_9 = null;
                    try {
                        Util.close(null, null, connection, brokerException);
                        Object var10_11 = null;
                        this.setInProgress(false);
                        return consumerUIDArray;
                    }
                    catch (Throwable throwable) {
                        Object var10_12 = null;
                        this.setInProgress(false);
                        throw throwable;
                    }
                    break;
                }
            }
            catch (BrokerException brokerException2) {
                brokerException = brokerException2;
                throw brokerException2;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {}
            catch (Throwable throwable2) {
                Object var10_14 = null;
                this.setInProgress(false);
                throw throwable2;
            }
            Util.close(null, null, connection, brokerException);
            Object var10_13 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void storeInterest(Consumer consumer, boolean bl) throws IOException, BrokerException {
        if (consumer == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.storeInterest() called with interest: " + consumer.getConsumerUID().getUniqueName());
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getConsumerDAO().insert(null, consumer, System.currentTimeMillis());
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var6_4 = null;
                this.setInProgress(false);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void removeInterest(Consumer consumer, boolean bl) throws IOException, BrokerException {
        if (consumer == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.removeInterest() called with interest: " + consumer.getConsumerUID().getUniqueName());
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getConsumerDAO().delete(null, consumer);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var6_4 = null;
                this.setInProgress(false);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Consumer[] getAllInterests() throws IOException, BrokerException {
        if (DEBUG) {
            logger.log(4, "JDBCStore.getAllInterests() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                Consumer[] consumerArray;
                try {
                    consumerArray = this.daoFactory.getConsumerDAO().getAllConsumers(null).toArray(new Consumer[0]);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var4_4 = null;
                this.setInProgress(false);
                return consumerArray;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    @Override
    public void storeDestination(Destination destination, boolean bl) throws BrokerException {
        this.storeDestination(destination, this.getStoreSession());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void storeDestination(Destination destination, long l) throws BrokerException {
        if (destination == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.storeDestination() called with destination: " + destination.getUniqueName());
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getDestinationDAO().insert(null, destination, l, 0L, System.currentTimeMillis());
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var7_4 = null;
                this.setInProgress(false);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void updateDestination(Destination destination, boolean bl) throws BrokerException {
        if (destination == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.updateDestination() called with destination: " + destination.getUniqueName());
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getDestinationDAO().update(null, destination);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var6_4 = null;
                this.setInProgress(false);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void removeDestination(Destination destination, boolean bl) throws IOException, BrokerException {
        if (destination == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.removeDestination() called with destination: " + destination.getUniqueName());
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                block12: {
                    try {
                        boolean bl2 = this.daoFactory.getDestinationDAO().delete(null, destination);
                        if (!destination.isAutoCreated() || !Globals.getHAEnabled()) break block12;
                        DestinationUID destinationUID = destination.getDestinationUID();
                        HashMap hashMap = this.pendingDeleteDsts;
                        synchronized (hashMap) {
                            if (bl2) {
                                this.pendingDeleteDsts.remove(destinationUID);
                            } else {
                                this.pendingDeleteDsts.put(destinationUID, destination.getType());
                            }
                        }
                    }
                    catch (Exception exception) {
                        if (retryStrategy == null) {
                            retryStrategy = new Util.RetryStrategy();
                        }
                        retryStrategy.assertShouldRetry(exception);
                        continue;
                    }
                    {
                    }
                }
                Object var9_8 = null;
                this.setInProgress(false);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void reapAutoCreatedDestinations() throws BrokerException {
        if (DEBUG) {
            logger.log(4, "JDBCStore.reapAutoCreatedDestinations() called");
        }
        if (!Globals.getHAEnabled()) {
            return;
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    HashMap hashMap = this.pendingDeleteDsts;
                    synchronized (hashMap) {
                        if (!this.pendingDeleteDsts.isEmpty()) {
                            DestinationDAO destinationDAO = this.daoFactory.getDestinationDAO();
                            Iterator iterator = this.pendingDeleteDsts.entrySet().iterator();
                            while (iterator.hasNext()) {
                                int n;
                                Map.Entry entry = iterator.next();
                                DestinationUID destinationUID = (DestinationUID)entry.getKey();
                                if (!destinationDAO.delete(null, destinationUID, n = ((Integer)entry.getValue()).intValue())) continue;
                                logger.log(4, "Auto-created destination " + destinationUID + " has been removed from HA Store");
                                iterator.remove();
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                {
                }
                Object var10_9 = null;
                this.setInProgress(false);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Destination getDestination(DestinationUID destinationUID) throws BrokerException {
        if (destinationUID == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.getDestination() called with destination ID: " + destinationUID.toString());
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                Destination destination;
                try {
                    destination = this.daoFactory.getDestinationDAO().getDestination(null, destinationUID.toString());
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var5_5 = null;
                this.setInProgress(false);
                return destination;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    @Override
    public Destination[] getAllDestinations() throws IOException, BrokerException {
        return this.getAllDestinations(this.dbmgr.getBrokerID());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Destination[] getAllDestinations(String string) throws IOException, BrokerException {
        if (DEBUG) {
            logger.log(4, "JDBCStore.getAllDestinations() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                Destination[] destinationArray;
                try {
                    destinationArray = this.daoFactory.getDestinationDAO().getAllDestinations(null, string).toArray(new Destination[0]);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var5_5 = null;
                this.setInProgress(false);
                return destinationArray;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void storeTransaction(TransactionUID transactionUID, TransactionState transactionState, boolean bl) throws BrokerException {
        if (transactionUID == null) throw new NullPointerException();
        if (transactionState == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.storeTransaction() called with txn: " + transactionUID.longValue());
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getTransactionDAO().insert(null, transactionUID, transactionState, this.getStoreSession());
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var7_5 = null;
                this.setInProgress(false);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    @Override
    public void removeTransaction(TransactionUID transactionUID, boolean bl) throws IOException, BrokerException {
        this.removeTransaction(transactionUID, false, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void removeTransaction(TransactionUID transactionUID, boolean bl, boolean bl2) throws IOException, BrokerException {
        if (transactionUID == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.removeTransaction() called with id=" + transactionUID.longValue() + ", removeAcks=" + bl);
        }
        this.checkClosedAndSetInProgress();
        Connection connection = null;
        BrokerException brokerException = null;
        try {
            try {
                connection = this.dbmgr.getConnection(false);
                Util.RetryStrategy retryStrategy = null;
                while (true) {
                    try {
                        if (bl) {
                            this.daoFactory.getConsumerStateDAO().clearTransaction(connection, transactionUID);
                        }
                        this.daoFactory.getTransactionDAO().delete(connection, transactionUID);
                        connection.commit();
                    }
                    catch (Exception exception) {
                        if (retryStrategy == null) {
                            retryStrategy = new Util.RetryStrategy();
                        }
                        retryStrategy.assertShouldRetry(exception);
                        continue;
                    }
                    Object var9_8 = null;
                    try {
                        Util.close(null, null, connection, brokerException);
                        Object var11_10 = null;
                        this.setInProgress(false);
                        return;
                    }
                    catch (Throwable throwable) {
                        Object var11_11 = null;
                        this.setInProgress(false);
                        throw throwable;
                    }
                    break;
                }
            }
            catch (BrokerException brokerException2) {
                brokerException = brokerException2;
                throw brokerException2;
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            try {}
            catch (Throwable throwable2) {
                Object var11_13 = null;
                this.setInProgress(false);
                throw throwable2;
            }
            Util.close(null, null, connection, brokerException);
            Object var11_12 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void updateTransactionState(TransactionUID transactionUID, TransactionState transactionState, boolean bl) throws IOException, BrokerException {
        if (transactionUID == null) throw new NullPointerException();
        if (transactionState == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.updateTransactionState called with id=" + transactionUID.longValue() + ", ts=" + transactionState.getState());
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getTransactionDAO().updateTransactionState(null, transactionUID, transactionState);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var7_5 = null;
                this.setInProgress(false);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public HashMap getAllTransactionStates() throws IOException, BrokerException {
        if (DEBUG) {
            logger.log(4, "JDBCStore.getAllTransactionStates() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                HashMap hashMap;
                try {
                    hashMap = this.daoFactory.getTransactionDAO().getTransactionStatesByBroker(null, this.dbmgr.getBrokerID());
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var4_4 = null;
                this.setInProgress(false);
                return hashMap;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public HashMap getAllRemoteTransactionStates() throws IOException, BrokerException {
        if (DEBUG) {
            logger.log(4, "JDBCStore.getAllRemoteTransactionStates() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                HashMap hashMap;
                try {
                    hashMap = this.daoFactory.getTransactionDAO().getRemoteTransactionStatesByBroker(null, this.dbmgr.getBrokerID());
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var4_4 = null;
                this.setInProgress(false);
                return hashMap;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void storeTransactionAck(TransactionUID transactionUID, TransactionAcknowledgement transactionAcknowledgement, boolean bl) throws BrokerException {
        if (transactionUID == null) throw new NullPointerException();
        if (transactionAcknowledgement == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.storeTransactionAck() called with txn: " + transactionUID.longValue());
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getConsumerStateDAO().updateTransaction(null, transactionAcknowledgement.getSysMessageID(), transactionAcknowledgement.getStoredConsumerUID(), transactionUID);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var7_5 = null;
                this.setInProgress(false);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void removeTransactionAck(TransactionUID transactionUID, boolean bl) throws BrokerException {
        if (transactionUID == null) {
            throw new NullPointerException();
        }
        if (DEBUG && DEBUG) {
            logger.log(4, "JDBCStore.removeTransactionAck() called with txn: " + transactionUID.longValue());
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getConsumerStateDAO().clearTransaction(null, transactionUID);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var6_4 = null;
                this.setInProgress(false);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public HashMap getAllTransactionAcks() throws BrokerException {
        if (DEBUG) {
            logger.log(4, "JDBCStore.getAllTransactionAcks() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                HashMap hashMap;
                try {
                    hashMap = this.daoFactory.getConsumerStateDAO().getAllTransactionAcks(null);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var4_4 = null;
                this.setInProgress(false);
                return hashMap;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public TransactionAcknowledgement[] getTransactionAcks(TransactionUID transactionUID) throws BrokerException {
        if (transactionUID == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.getTransactionAcks() called with txn: " + transactionUID.longValue());
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                TransactionAcknowledgement[] transactionAcknowledgementArray;
                try {
                    transactionAcknowledgementArray = this.daoFactory.getConsumerStateDAO().getTransactionAcks(null, transactionUID).toArray(new TransactionAcknowledgement[0]);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var5_5 = null;
                this.setInProgress(false);
                return transactionAcknowledgementArray;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    @Override
    public void storeTransaction(TransactionUID transactionUID, TransactionInfo transactionInfo, boolean bl) throws BrokerException {
        this.storeTransaction(transactionUID, transactionInfo, this.getStoreSession());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void storeTransaction(TransactionUID transactionUID, TransactionInfo transactionInfo, long l) throws BrokerException {
        if (transactionUID == null) throw new NullPointerException();
        if (transactionInfo == null) {
            throw new NullPointerException();
        }
        int n = 0;
        BrokerAddress brokerAddress = null;
        TransactionBroker[] transactionBrokerArray = null;
        if (transactionInfo.isCluster()) {
            n = 2;
            transactionBrokerArray = transactionInfo.getTransactionBrokers();
        } else if (transactionInfo.isRemote()) {
            n = 3;
            brokerAddress = transactionInfo.getTransactionHomeBroker();
        } else {
            if (!transactionInfo.isLocal()) {
                String string = "Illegal transaction type: " + transactionInfo.getType();
                logger.log(32, "B3100", string);
                throw new BrokerException(br.getKString("B3100", string));
            }
            n = 1;
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getTransactionDAO().insert(null, transactionUID, transactionInfo.getTransactionState(), brokerAddress, transactionBrokerArray, n, l);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var11_9 = null;
                this.setInProgress(false);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void storeClusterTransaction(TransactionUID transactionUID, TransactionState transactionState, TransactionBroker[] transactionBrokerArray, boolean bl) throws BrokerException {
        if (transactionUID == null) throw new NullPointerException();
        if (transactionState == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.storeClusterTransaction() called with txn: " + transactionUID.longValue());
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getTransactionDAO().insert(null, transactionUID, transactionState, null, transactionBrokerArray, 2, this.getStoreSession());
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var8_6 = null;
                this.setInProgress(false);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void updateClusterTransaction(TransactionUID transactionUID, TransactionBroker[] transactionBrokerArray, boolean bl) throws BrokerException {
        if (transactionUID == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.updateClusterTransaction() called with txn: " + transactionUID.longValue());
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getTransactionDAO().updateTransactionBrokers(null, transactionUID, transactionBrokerArray);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var7_5 = null;
                this.setInProgress(false);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void updateClusterTransactionBrokerState(TransactionUID transactionUID, int n, TransactionBroker transactionBroker, boolean bl) throws BrokerException {
        if (transactionUID == null) {
            throw new NullPointerException();
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.updateClusterTransactionBrokerState() called with txn: " + transactionUID.longValue());
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getTransactionDAO().updateTransactionBrokerState(null, transactionUID, n, transactionBroker);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var8_6 = null;
                this.setInProgress(false);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void updateRemoteTransaction(TransactionUID transactionUID, TransactionAcknowledgement[] transactionAcknowledgementArray, BrokerAddress brokerAddress, boolean bl) throws BrokerException {
        if (transactionUID == null) {
            throw new NullPointerException();
        }
        if (!Globals.getHAEnabled()) {
            throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store in non-HA mode");
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.updateRemoteTransaction() called with txn: " + transactionUID.longValue());
        }
        this.checkClosedAndSetInProgress();
        Connection connection = null;
        BrokerException brokerException = null;
        try {
            try {
                connection = this.dbmgr.getConnection(false);
                Util.RetryStrategy retryStrategy = null;
                while (true) {
                    try {
                        if (transactionAcknowledgementArray != null && transactionAcknowledgementArray.length > 0) {
                            for (TransactionAcknowledgement transactionAcknowledgement : transactionAcknowledgementArray) {
                                if (!transactionAcknowledgement.shouldStore()) continue;
                                this.daoFactory.getConsumerStateDAO().updateTransaction(connection, transactionAcknowledgement.getSysMessageID(), transactionAcknowledgement.getStoredConsumerUID(), transactionUID);
                            }
                        }
                        this.daoFactory.getTransactionDAO().updateTransactionHomeBroker(connection, transactionUID, brokerAddress);
                        connection.commit();
                    }
                    catch (Exception exception) {
                        if (retryStrategy == null) {
                            retryStrategy = new Util.RetryStrategy();
                        }
                        retryStrategy.assertShouldRetry(exception);
                        continue;
                    }
                    Object var12_13 = null;
                    try {
                        Util.close(null, null, connection, brokerException);
                        Object var14_15 = null;
                        this.setInProgress(false);
                        return;
                    }
                    catch (Throwable throwable) {
                        Object var14_16 = null;
                        this.setInProgress(false);
                        throw throwable;
                    }
                    break;
                }
            }
            catch (BrokerException brokerException2) {
                brokerException = brokerException2;
                throw brokerException2;
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            try {}
            catch (Throwable throwable2) {
                Object var14_18 = null;
                this.setInProgress(false);
                throw throwable2;
            }
            Util.close(null, null, connection, brokerException);
            Object var14_17 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void storeRemoteTransaction(TransactionUID transactionUID, TransactionState transactionState, TransactionAcknowledgement[] transactionAcknowledgementArray, BrokerAddress brokerAddress, boolean bl) throws BrokerException {
        if (transactionUID == null) {
            throw new NullPointerException();
        }
        if (Globals.getHAEnabled()) {
            throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store in HA mode");
        }
        if (DEBUG) {
            logger.log(4, "JDBCStore.storeRemoteTransaction() called with txn: " + transactionUID.longValue());
        }
        this.checkClosedAndSetInProgress();
        Connection connection = null;
        BrokerException brokerException = null;
        try {
            try {
                connection = this.dbmgr.getConnection(false);
                Util.RetryStrategy retryStrategy = null;
                while (true) {
                    try {
                        this.daoFactory.getTransactionDAO().insert(connection, transactionUID, transactionState, brokerAddress, null, 3, this.getStoreSession());
                        if (transactionAcknowledgementArray != null && transactionAcknowledgementArray.length > 0) {
                            for (TransactionAcknowledgement transactionAcknowledgement : transactionAcknowledgementArray) {
                                if (!transactionAcknowledgement.shouldStore()) continue;
                                this.daoFactory.getConsumerStateDAO().updateTransaction(connection, transactionAcknowledgement.getSysMessageID(), transactionAcknowledgement.getStoredConsumerUID(), transactionUID);
                            }
                        }
                        connection.commit();
                    }
                    catch (Exception exception) {
                        if (retryStrategy == null) {
                            retryStrategy = new Util.RetryStrategy();
                        }
                        retryStrategy.assertShouldRetry(exception);
                        continue;
                    }
                    Object var13_14 = null;
                    try {
                        Util.close(null, null, connection, brokerException);
                        Object var15_16 = null;
                        this.setInProgress(false);
                        return;
                    }
                    catch (Throwable throwable) {
                        Object var15_17 = null;
                        this.setInProgress(false);
                        throw throwable;
                    }
                    break;
                }
            }
            catch (BrokerException brokerException2) {
                brokerException = brokerException2;
                throw brokerException2;
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            try {}
            catch (Throwable throwable2) {
                Object var15_19 = null;
                this.setInProgress(false);
                throw throwable2;
            }
            Util.close(null, null, connection, brokerException);
            Object var15_18 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void updateProperty(String string, Object object, boolean bl) throws BrokerException {
        if (string == null) {
            throw new NullPointerException();
        }
        if (Store.getDEBUG()) {
            logger.log(4, "JDBCStore.updateProperty() called with name: " + string);
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getPropertyDAO().update(null, string, object);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var7_5 = null;
                this.setInProgress(false);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object getProperty(String string) throws BrokerException {
        if (string == null) {
            throw new NullPointerException();
        }
        if (Store.getDEBUG()) {
            logger.log(4, "JDBCStore.getProperty() called with name: " + string);
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                Object object;
                try {
                    object = this.daoFactory.getPropertyDAO().getProperty(null, string);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var5_5 = null;
                this.setInProgress(false);
                return object;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String[] getPropertyNames() throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "JDBCStore.getPropertyNames() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                String[] stringArray;
                try {
                    stringArray = this.daoFactory.getPropertyDAO().getPropertyNames(null).toArray(new String[0]);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var4_4 = null;
                this.setInProgress(false);
                return stringArray;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Properties getAllProperties() throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "JDBCStore.getAllProperties() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                Properties properties;
                try {
                    properties = this.daoFactory.getPropertyDAO().getProperties(null);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var4_4 = null;
                this.setInProgress(false);
                return properties;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void storeConfigChangeRecord(long l, byte[] byArray, boolean bl) throws BrokerException {
        if (DEBUG) {
            logger.log(4, "JDBCStore.storeConfigChangeRecord() called");
        }
        if (l <= 0L) {
            String string = String.valueOf(l);
            logger.log(32, "B3074", string);
            throw new BrokerException(br.getKString("B3074", string));
        }
        if (byArray == null) {
            throw new NullPointerException();
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getConfigRecordDAO().insert(null, byArray, l);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var8_6 = null;
                this.setInProgress(false);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ArrayList<ChangeRecordInfo> getConfigChangeRecordsSince(long l) throws BrokerException {
        if (DEBUG) {
            logger.log(4, "JDBCStore.getConfigChangeRecordsSince() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                ArrayList arrayList;
                try {
                    arrayList = (ArrayList)this.daoFactory.getConfigRecordDAO().getRecordsSince(null, l);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var6_5 = null;
                this.setInProgress(false);
                return arrayList;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<ChangeRecordInfo> getAllConfigRecords() throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "JDBCStore.getAllConfigRecords() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                List<ChangeRecordInfo> list;
                try {
                    list = this.daoFactory.getConfigRecordDAO().getAllRecords(null);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var4_4 = null;
                this.setInProgress(false);
                return list;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void clearAllConfigChangeRecords(boolean bl) throws BrokerException {
        if (DEBUG) {
            logger.log(4, "JDBCStore.clearAllConfigChangeRecords() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getConfigRecordDAO().deleteAll(null);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var5_3 = null;
                this.setInProgress(false);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void clearAll(boolean bl) throws BrokerException {
        if (DEBUG) {
            logger.log(4, "JDBCStore.clearAll() called");
        }
        this.checkClosedAndSetInProgress();
        Connection connection = null;
        Exception exception = null;
        try {
            try {
                connection = this.dbmgr.getConnection(false);
                Util.RetryStrategy retryStrategy = null;
                while (true) {
                    try {
                        if (Globals.getHAEnabled()) {
                            this.daoFactory.getTransactionDAO().deleteAll(connection);
                            this.daoFactory.getDestinationDAO().deleteAll(connection);
                            this.daoFactory.getConsumerStateDAO().deleteAll(connection);
                            this.daoFactory.getMessageDAO().deleteAll(connection);
                            this.daoFactory.getTMLogRecordDAOJMSBG().deleteAll(connection);
                            this.daoFactory.getJMSBGDAO().deleteAll(connection);
                        } else {
                            List list = this.daoFactory.getAllDAOs();
                            for (BaseDAO baseDAO : list) {
                                if (baseDAO instanceof VersionDAO || baseDAO instanceof BrokerDAO || baseDAO instanceof StoreSessionDAO) continue;
                                baseDAO.deleteAll(connection);
                            }
                        }
                        connection.commit();
                    }
                    catch (Exception exception2) {
                        if (retryStrategy == null) {
                            retryStrategy = new Util.RetryStrategy();
                        }
                        retryStrategy.assertShouldRetry(exception2);
                        continue;
                    }
                    Object var9_10 = null;
                    try {
                        Util.close(null, null, connection, exception);
                        Object var11_12 = null;
                        this.setInProgress(false);
                        return;
                    }
                    catch (Throwable throwable) {
                        Object var11_13 = null;
                        this.setInProgress(false);
                        throw throwable;
                    }
                    break;
                }
            }
            catch (Exception exception3) {
                exception = exception3;
                throw new BrokerException(br.getKString("B4081"), exception3);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            try {}
            catch (Throwable throwable2) {
                Object var11_15 = null;
                this.setInProgress(false);
                throw throwable2;
            }
            Util.close(null, null, connection, exception);
            Object var11_14 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    @Override
    public void close(boolean bl) {
        this.setClosedAndWait();
        this.closeDB(true);
        this.dbmgr.setStoreInited(false);
        if (DEBUG) {
            logger.log(4, "JDBCStore.close(" + bl + ") done.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void beforeWaitOnClose() {
        Iterator<Enumeration> iterator = null;
        List<Enumeration> list = this.dataEnums;
        synchronized (list) {
            iterator = this.dataEnums.iterator();
            Enumeration enumeration = null;
            while (iterator.hasNext()) {
                enumeration = iterator.next();
                if (!(enumeration instanceof MessageEnumeration)) continue;
                ((MessageEnumeration)enumeration).cancel();
            }
        }
        if (this.dbmgr != null) {
            this.dbmgr.setIsClosing();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getBrokerHeartbeat(String string) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                long l;
                try {
                    l = this.daoFactory.getBrokerDAO().getHeartbeat(null, string);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var6_5 = null;
                this.setInProgress(false);
                return l;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public HashMap getAllBrokerHeartbeats() throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                HashMap hashMap;
                try {
                    hashMap = this.daoFactory.getBrokerDAO().getAllHeartbeats(null);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var4_4 = null;
                this.setInProgress(false);
                return hashMap;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Long updateBrokerHeartbeat(String string) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                Long l;
                try {
                    l = this.daoFactory.getBrokerDAO().updateHeartbeat(null, string);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(this.dbmgr, 2000L, 4);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var5_5 = null;
                this.setInProgress(false);
                return l;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Long updateBrokerHeartbeat(String string, long l) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                Long l2;
                try {
                    l2 = this.daoFactory.getBrokerDAO().updateHeartbeat(null, string, l);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(this.dbmgr, 2000L, 4);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var7_6 = null;
                this.setInProgress(false);
                return l2;
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void addBrokerInfo(String string, String string2, BrokerState brokerState, int n, long l, long l2) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getBrokerDAO().insert(null, string, null, string2, n, brokerState.intValue(), l, l2);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var12_8 = null;
                this.setInProgress(false);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var12_9 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addBrokerInfo(HABrokerInfo hABrokerInfo, boolean bl) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getBrokerDAO().insert(null, hABrokerInfo.getId(), hABrokerInfo.getTakeoverBrokerID(), hABrokerInfo.getUrl(), hABrokerInfo.getVersion(), hABrokerInfo.getState(), -1L, hABrokerInfo.getHeartbeat());
                    List list = hABrokerInfo.getAllSessions();
                    if (list != null && !list.isEmpty()) {
                        StoreSessionDAO storeSessionDAO = this.daoFactory.getStoreSessionDAO();
                        for (HABrokerInfo.StoreSession storeSession : list) {
                            storeSessionDAO.insert(null, storeSession.getBrokerID(), storeSession.getID(), storeSession.getIsCurrent(), storeSession.getCreatedBy(), storeSession.getCreatedTS());
                        }
                    }
                    Object var9_9 = null;
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.setInProgress(false);
            throw throwable;
        }
        this.setInProgress(false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public UID updateBrokerInfo(String string, int n, Object object, Object object2) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                UID uID;
                try {
                    uID = this.daoFactory.getBrokerDAO().update(null, string, n, object, object2);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var8_8 = null;
                this.setInProgress(false);
                return uID;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public HABrokerInfo getBrokerInfo(String string) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                HABrokerInfo hABrokerInfo;
                try {
                    hABrokerInfo = this.daoFactory.getBrokerDAO().getBrokerInfo(null, string);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var5_5 = null;
                this.setInProgress(false);
                return hABrokerInfo;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public HashMap getAllBrokerInfos(boolean bl) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                HashMap hashMap;
                try {
                    hashMap = this.daoFactory.getBrokerDAO().getAllBrokerInfos(null, bl);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var5_5 = null;
                this.setInProgress(false);
                return hashMap;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public HashMap getAllBrokerInfoByState(BrokerState brokerState) throws BrokerException {
        if (brokerState == null) {
            throw new NullPointerException();
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                HashMap hashMap;
                try {
                    hashMap = this.daoFactory.getBrokerDAO().getAllBrokerInfosByState(null, brokerState);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var5_5 = null;
                this.setInProgress(false);
                return hashMap;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getStoreSessionOwner(long l) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                String string;
                try {
                    string = this.daoFactory.getStoreSessionDAO().getStoreSessionOwner(null, l);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var6_5 = null;
                this.setInProgress(false);
                return string;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean ifOwnStoreSession(long l, String string) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                boolean bl;
                try {
                    bl = this.daoFactory.getStoreSessionDAO().ifOwnStoreSession(null, l, string);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var7_6 = null;
                this.setInProgress(false);
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getStoreSessionCreator(long l) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                String string;
                try {
                    string = this.daoFactory.getStoreSessionDAO().getStoreSessionCreator(null, l);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var6_5 = null;
                this.setInProgress(false);
                return string;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean updateBrokerState(String string, BrokerState brokerState, BrokerState brokerState2, boolean bl) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                boolean bl2;
                try {
                    bl2 = this.daoFactory.getBrokerDAO().updateState(null, string, brokerState, brokerState2, bl);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(this.dbmgr, 2000L, 5);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var8_8 = null;
                this.setInProgress(false);
                return bl2;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BrokerState getBrokerState(String string) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                BrokerState brokerState;
                try {
                    brokerState = this.daoFactory.getBrokerDAO().getState(null, string);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var5_5 = null;
                this.setInProgress(false);
                return brokerState;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object[] getAllBrokerStates() throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                Object[] objectArray;
                try {
                    objectArray = this.daoFactory.getBrokerDAO().getAllStates(null);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var4_4 = null;
                this.setInProgress(false);
                return objectArray;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void getTakeOverLock(String string, String string2, long l, BrokerState brokerState, long l2, BrokerState brokerState2, boolean bl, TakingoverTracker takingoverTracker) throws TakeoverLockException, BrokerException {
        this.checkClosedAndSetInProgress();
        takingoverTracker.setStage_BEFORE_GET_LOCK();
        Connection connection = null;
        BrokerException brokerException = null;
        try {
            try {
                HashMap hashMap = this.takeoverLockMap;
                // MONITORENTER : hashMap
                TakeoverStoreInfo takeoverStoreInfo = (TakeoverStoreInfo)this.takeoverLockMap.get(string2);
                if (takeoverStoreInfo != null) {
                    logger.logToAll(16, "B2109", string2);
                    // MONITOREXIT : hashMap
                    Object var22_14 = null;
                    try {
                        Util.close(null, null, connection, brokerException);
                        Object var24_17 = null;
                        this.setInProgress(false);
                        return;
                    }
                    catch (Throwable throwable) {
                        Object var24_18 = null;
                        this.setInProgress(false);
                        throw throwable;
                    }
                }
                connection = this.dbmgr.getConnection(true);
                Util.RetryStrategy retryStrategy = null;
                while (true) {
                    try {
                        HABrokerInfo hABrokerInfo = this.daoFactory.getBrokerDAO().takeover(connection, string, string2, l, brokerState, l2, brokerState2);
                        hABrokerInfo.setTakeoverTimestamp(l2);
                        takingoverTracker.setStage_AFTER_GET_LOCK();
                        long l3 = System.currentTimeMillis();
                        logger.logToAll(8, "B1168", string2, String.valueOf(l3));
                        takeoverStoreInfo = new TakeoverStoreInfo(string2, hABrokerInfo, l3);
                        this.takeoverLockMap.put(string2, takeoverStoreInfo);
                        Map map = this.daoFactory.getMessageDAO().getMsgIDsAndDstIDsByBroker(connection, string2);
                        takingoverTracker.setMessageMap(map);
                        // MONITOREXIT : hashMap
                    }
                    catch (Exception exception) {
                        if (retryStrategy == null) {
                            retryStrategy = new Util.RetryStrategy();
                        }
                        retryStrategy.assertShouldRetry(exception);
                        continue;
                    }
                    Object var22_15 = null;
                    try {}
                    catch (Throwable throwable) {
                        Object var24_20 = null;
                        this.setInProgress(false);
                        throw throwable;
                    }
                    Util.close(null, null, connection, brokerException);
                    Object var24_19 = null;
                    this.setInProgress(false);
                    return;
                }
            }
            catch (BrokerException brokerException2) {
                brokerException = brokerException2;
                throw brokerException2;
            }
        }
        catch (Throwable throwable) {
            Object var22_16 = null;
            try {}
            catch (Throwable throwable2) {
                Object var24_22 = null;
                this.setInProgress(false);
                throw throwable2;
            }
            Util.close(null, null, connection, brokerException);
            Object var24_21 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public TakeoverStoreInfo takeOverBrokerStore(String var1_1, String var2_2, TakingoverTracker var3_3) throws BrokerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 31[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void updateTransactionAccessedTime(TransactionUID transactionUID, long l) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getTransactionDAO().updateAccessedTime(null, transactionUID, l);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var7_4 = null;
                this.setInProgress(false);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public TransactionState getTransactionState(TransactionUID transactionUID) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                TransactionState transactionState;
                try {
                    transactionState = this.daoFactory.getTransactionDAO().getTransactionState(null, transactionUID);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var5_5 = null;
                this.setInProgress(false);
                return transactionState;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BrokerAddress getRemoteTransactionHomeBroker(TransactionUID transactionUID) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                BrokerAddress brokerAddress;
                try {
                    brokerAddress = this.daoFactory.getTransactionDAO().getTransactionHomeBroker(null, transactionUID);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var5_5 = null;
                this.setInProgress(false);
                return brokerAddress;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public TransactionBroker[] getClusterTransactionBrokers(TransactionUID transactionUID) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                TransactionBroker[] transactionBrokerArray;
                try {
                    transactionBrokerArray = this.daoFactory.getTransactionDAO().getTransactionBrokers(null, transactionUID);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var5_5 = null;
                this.setInProgress(false);
                return transactionBrokerArray;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getTransactionAccessedTime(TransactionUID transactionUID) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                long l;
                try {
                    l = this.daoFactory.getTransactionDAO().getAccessedTime(null, transactionUID);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var6_5 = null;
                this.setInProgress(false);
                return l;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public TransactionInfo getTransactionInfo(TransactionUID transactionUID) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                TransactionInfo transactionInfo;
                try {
                    transactionInfo = this.daoFactory.getTransactionDAO().getTransactionInfo(null, transactionUID);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var5_5 = null;
                this.setInProgress(false);
                return transactionInfo;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Collection getTransactions(String string) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                List list;
                try {
                    list = this.daoFactory.getTransactionDAO().getTransactionsByBroker(null, string);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var5_5 = null;
                this.setInProgress(false);
                return list;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int[] getTransactionUsageInfo(TransactionUID transactionUID) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                int[] nArray;
                try {
                    nArray = this.daoFactory.getTransactionDAO().getTransactionUsageInfo(null, transactionUID);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var5_5 = null;
                this.setInProgress(false);
                return nArray;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getDestinationConnectedTime(Destination destination) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                long l;
                try {
                    l = this.daoFactory.getDestinationDAO().getDestinationConnectedTime(null, destination.getUniqueName());
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var6_5 = null;
                this.setInProgress(false);
                return l;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasMessageBeenAcked(DestinationUID destinationUID, SysMessageID sysMessageID) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                boolean bl;
                try {
                    bl = this.daoFactory.getMessageDAO().hasMessageBeenAcked(null, destinationUID, sysMessageID);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var6_6 = null;
                this.setInProgress(false);
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void updateDestinationConnectedTime(Destination destination, long l) throws BrokerException {
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getDestinationDAO().updateConnectedTime(null, destination, l);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var7_4 = null;
                this.setInProgress(false);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void closeDB(boolean bl) {
        block9: {
            Exception exception;
            Connection connection;
            block8: {
                connection = null;
                exception = null;
                if (!bl) break block8;
                connection = this.dbmgr.getConnection(true);
                if (Globals.getHAEnabled() || !config.getBooleanProperty(LOCK_STORE_PROP, true)) break block8;
                DBManager.lockTables(connection, false);
            }
            Object var6_4 = null;
            try {
                Util.close(null, null, connection, exception);
            }
            catch (Exception exception2) {}
            break block9;
            {
                catch (Exception exception3) {
                    exception = exception3;
                    logger.log(16, "B4103", exception3);
                    Object var6_5 = null;
                    try {
                        Util.close(null, null, connection, exception);
                    }
                    catch (Exception exception4) {}
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                try {
                    Util.close(null, null, connection, exception);
                }
                catch (Exception exception5) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        this.dbmgr.close();
    }

    @Override
    public String getStoreType() {
        return "jdbc";
    }

    @Override
    public HashMap getStorageInfo(Destination destination) throws BrokerException {
        throw new BrokerException(br.getKString("B3136"));
    }

    @Override
    public Hashtable getDebugState() throws BrokerException {
        String string = this.dbmgr.getOpenDBURL();
        String string2 = "(" + this.dbmgr.getBrokerID() + ")";
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("JDBC-based store", string + string2);
        hashtable.put("Store version", String.valueOf(410));
        Connection connection = null;
        BrokerException brokerException = null;
        try {
            try {
                connection = this.dbmgr.getConnection(true);
                Iterator iterator = this.daoFactory.getAllDAOs().iterator();
                while (iterator.hasNext()) {
                    hashtable.putAll(((BaseDAO)iterator.next()).getDebugInfo(connection));
                }
                Object var8_8 = null;
            }
            catch (BrokerException brokerException2) {
                brokerException = brokerException2;
                throw brokerException2;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            Util.close(null, null, connection, brokerException);
            throw throwable;
        }
        Util.close(null, null, connection, brokerException);
        hashtable.put(this.dbmgr.toString(), this.dbmgr.getDebugState());
        return hashtable;
    }

    @Override
    public void compactDestination(Destination destination) throws BrokerException {
        throw new BrokerException(br.getKString("B3136"));
    }

    private boolean checkStore(Connection connection) throws BrokerException {
        boolean bl = true;
        int n = -1;
        if (this.checkOldStoreVersion(connection, this.dbmgr.getTableName("MQVER40"), "STORE_VERSION", 400)) {
            n = 400;
        } else if (this.checkOldStoreVersion(connection, "IMQSV37" + this.dbmgr.getBrokerID(), "STOREVERSION", 370)) {
            n = 370;
        } else if (this.checkOldStoreVersion(connection, "IMQSV35" + this.dbmgr.getBrokerID(), "STOREVERSION", 350)) {
            n = 350;
        }
        boolean bl2 = false;
        int n2 = 0;
        try {
            n2 = this.daoFactory.getVersionDAO().getStoreVersion(connection);
        }
        catch (BrokerException brokerException) {
            logger.log(16, brokerException.getMessage(), brokerException.getCause());
        }
        if (n2 > 0) {
            boolean bl3 = bl2 = n2 == 410;
            if (bl2) {
                DBTool.updateStoreVersion410IfNecessary(connection);
                if (this.dbmgr.checkStoreExists(connection) == -1) {
                    logger.log(32, "B3213");
                    throw new BrokerException(br.getKString("B3213"));
                }
            } else {
                String string = String.valueOf(n2);
                String string2 = String.valueOf(410);
                logger.log(32, "B3092", (Object)string, string2);
                throw new BrokerException(br.getKString("B3092", string, string2));
            }
            if (n > 0 && !this.removeStore) {
                logger.logToAll(8, "B1111");
            }
        }
        if (bl2) {
            if (this.removeStore) {
                try {
                    DBTool.dropTables(connection, null);
                }
                catch (SQLException sQLException) {
                    throw new BrokerException(br.getKString("B3121", this.dbmgr.getOpenDBURL()), sQLException);
                }
                bl = false;
            } else if (this.resetStore) {
                this.clearAll(true);
            }
        } else {
            boolean bl4 = false;
            if (this.createStore) {
                bl4 = true;
            }
            boolean bl5 = false;
            String string = null;
            if (n > 0) {
                if (this.removeStore) {
                    bl5 = true;
                    string = "B1112";
                } else if (this.resetStore) {
                    bl4 = true;
                    bl5 = true;
                    string = "B1113";
                } else {
                    logger.logToAll(8, "B1109", new Integer(n));
                    if (this.upgradeNoBackup && !Broker.getBroker().force) {
                        this.getConfirmation();
                    }
                    if (!Globals.getHAEnabled()) {
                        new UpgradeStore(this, n).upgradeStore(connection);
                        return bl;
                    }
                }
            }
            if (!bl4) {
                logger.log(32, "B3132");
                throw new BrokerException(br.getKString("B3132"));
            }
            if (bl5) {
                logger.logToAll(8, string);
                try {
                    DBTool.dropTables(connection, this.dbmgr.getTableNames(n));
                }
                catch (Exception exception) {
                    logger.logToAll(32, "B3133", exception);
                    throw new BrokerException(br.getKString("B3133"), exception);
                }
            }
            if (bl4) {
                logger.logToAll(8, "B1114");
                try {
                    DBTool.createTables(connection);
                }
                catch (Exception exception) {
                    String string3 = this.dbmgr.getCreateDBURL();
                    if (string3 == null || string3.length() == 0) {
                        string3 = this.dbmgr.getOpenDBURL();
                    }
                    String string4 = br.getKString("B3073", string3);
                    logger.logToAll(32, string4, exception);
                    throw new BrokerException(string4, exception);
                }
            }
        }
        return bl;
    }

    private long getStoreSession() throws BrokerException {
        if (Globals.getHAEnabled()) {
            return Globals.getStoreSession().longValue();
        }
        StoreSessionDAO storeSessionDAO = this.daoFactory.getStoreSessionDAO();
        return storeSessionDAO.getStoreSession(null, this.dbmgr.getBrokerID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkOldStoreVersion(Connection connection, String string, String string2, int n) throws BrokerException {
        try {
            boolean bl;
            String string3 = "SELECT " + string2 + " FROM " + string;
            Statement statement = null;
            ResultSet resultSet = null;
            SQLException sQLException = null;
            try {
                try {
                    statement = connection.createStatement();
                    resultSet = statement.executeQuery(string3);
                    if (!resultSet.next()) {
                        logger.log(32, "B3131", string);
                        throw new BrokerException(br.getKString("B3131", string));
                    }
                    int n2 = resultSet.getInt(1);
                    if (n2 != n) {
                        String string4 = String.valueOf(n2);
                        String string5 = String.valueOf(n);
                        logger.log(32, "B3125", (Object)string4, string5);
                        throw new BrokerException(br.getKString("B3125", string4, string5));
                    }
                    bl = true;
                    Object var13_14 = null;
                }
                catch (SQLException sQLException2) {
                    sQLException = sQLException2;
                    logger.log(4, "Assume old store does not exist because : " + sQLException2.getMessage());
                    Object var13_15 = null;
                    Util.close(resultSet, statement, null, sQLException);
                    return false;
                }
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                Util.close(resultSet, statement, null, sQLException);
                throw throwable;
            }
            Util.close(resultSet, statement, null, sQLException);
            return bl;
        }
        catch (Exception exception) {
            logger.log(32, "B4114", exception);
            throw new BrokerException(br.getKString("B4114"), exception);
        }
    }

    boolean resetMessage() {
        return this.resetMessage;
    }

    boolean resetInterest() {
        return this.resetInterest;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void storeTMLogRecord(String string, byte[] byArray, String string2, boolean bl, java.util.logging.Logger logger) throws DupKeyException, Exception {
        if (string == null) {
            throw new IllegalArgumentException("null xid");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("null logRecord");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("null name");
        }
        if (DEBUG) {
            JDBCStore.logger.log(4, "JDBCStore.storeTMLogRecord(" + string + ")");
            Util.logExt(logger, Level.FINE, "JDBCStore.storeTMLogRecord(" + string + ")", null);
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getTMLogRecordDAOJMSBG().insert(null, string, byArray, string2, logger);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var9_7 = null;
                this.setInProgress(false);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateTMLogRecord(String string, byte[] byArray, UpdateOpaqueDataCallback updateOpaqueDataCallback, String string2, boolean bl, boolean bl2, java.util.logging.Logger logger) throws Exception {
        if (string == null) {
            throw new IllegalArgumentException("null xid");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("null logRecord");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("null name");
        }
        if (updateOpaqueDataCallback == null) {
            throw new IllegalArgumentException("null callback");
        }
        if (DEBUG) {
            JDBCStore.logger.log(4, "JDBCStore.updateTMLogRecord(" + string + ")");
            Util.logExt(logger, Level.FINE, "JDBCStore.updateTMLogRecord(" + string + ")", null);
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getTMLogRecordDAOJMSBG().updateLogRecord(null, string, byArray, string2, updateOpaqueDataCallback, bl, logger);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var11_9 = null;
                this.setInProgress(false);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void removeTMLogRecord(String string, String string2, boolean bl, java.util.logging.Logger logger) throws KeyNotFoundException, Exception {
        if (string == null) {
            throw new IllegalArgumentException("null xid");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("null name");
        }
        if (DEBUG) {
            JDBCStore.logger.log(4, "JDBCStore.removeTMLogRecord(" + string + ")");
            Util.logExt(logger, Level.FINE, "JDBCStore.removeTMLogRecord(" + string + ")", null);
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getTMLogRecordDAOJMSBG().delete(null, string, string2, logger);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var8_6 = null;
                this.setInProgress(false);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getTMLogRecord(String string, String string2, java.util.logging.Logger logger) throws Exception {
        if (string == null) {
            throw new IllegalArgumentException("null xid");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("null name");
        }
        if (DEBUG) {
            JDBCStore.logger.log(4, "JDBCStore.getTMLogRecord(" + string + ")");
            Util.logExt(logger, Level.FINE, "JDBCStore.getTMLogRecord(" + string + ")", null);
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                byte[] byArray;
                try {
                    byArray = this.daoFactory.getTMLogRecordDAOJMSBG().getLogRecord(null, string, string2, logger);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var7_7 = null;
                this.setInProgress(false);
                return byArray;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getTMLogRecordUpdatedTime(String string, String string2, java.util.logging.Logger logger) throws KeyNotFoundException, Exception {
        if (string == null) {
            throw new IllegalArgumentException("null xid");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("null name");
        }
        if (DEBUG) {
            JDBCStore.logger.log(4, "JDBCStore.getTMLogRecordUpdatedTime(" + string + ")");
            Util.logExt(logger, Level.FINE, "JDBCStore.getTMLogRecordUpdatedTime(" + string + ")", null);
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                long l;
                try {
                    l = this.daoFactory.getTMLogRecordDAOJMSBG().getUpdatedTime(null, string, string2, logger);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var8_7 = null;
                this.setInProgress(false);
                return l;
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getTMLogRecordCreatedTime(String string, String string2, java.util.logging.Logger logger) throws KeyNotFoundException, Exception {
        if (string == null) {
            throw new IllegalArgumentException("null xid");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("null name");
        }
        if (DEBUG) {
            JDBCStore.logger.log(4, "JDBCStore.getTMLogRecordCreatedTime(" + string + ")");
            Util.logExt(logger, Level.FINE, "JDBCStore.getTMLogRecordcreatedTime(" + string + ")", null);
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                long l;
                try {
                    l = this.daoFactory.getTMLogRecordDAOJMSBG().getCreatedTime(null, string, string2, logger);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var8_7 = null;
                this.setInProgress(false);
                return l;
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    @Override
    public List getTMLogRecordsByName(String string, java.util.logging.Logger logger) throws Exception {
        return this.getLogRecordsByNameByBroker(string, this.dbmgr.getBrokerID(), logger);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List getLogRecordsByNameByBroker(String string, String string2, java.util.logging.Logger logger) throws Exception {
        if (string == null) {
            throw new IllegalArgumentException("null name");
        }
        if (DEBUG) {
            JDBCStore.logger.log(4, "JDBCStore.getTMLogRecordsByNameByBroker(" + string + ", " + string2 + ")");
            Util.logExt(logger, Level.FINE, "JDBCStore.getTMLogRecordsByNameByBroker(" + string + ", " + string2 + ")", null);
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                List list;
                try {
                    list = this.daoFactory.getTMLogRecordDAOJMSBG().getLogRecordsByNameByBroker(null, string, string2, logger);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var7_7 = null;
                this.setInProgress(false);
                return list;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List getNamesByBroker(String string, java.util.logging.Logger logger) throws Exception {
        if (string == null) {
            throw new IllegalArgumentException("null brokerID");
        }
        if (DEBUG) {
            JDBCStore.logger.log(4, "JDBCStore.getTMNamesByBroker(" + string + ")");
            Util.logExt(logger, Level.FINE, "JDBCStore.getTMNamesByBroker(" + string + ")", null);
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                List list;
                try {
                    list = this.daoFactory.getTMLogRecordDAOJMSBG().getNamesByBroker(null, string, logger);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var6_6 = null;
                this.setInProgress(false);
                return list;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void addJMSBridge(String string, boolean bl, java.util.logging.Logger logger) throws DupKeyException, Exception {
        if (string == null) {
            throw new IllegalArgumentException("null name");
        }
        if (DEBUG) {
            JDBCStore.logger.log(4, "JDBCStore.addJMSBridge(" + string + ")");
            Util.logExt(logger, Level.FINE, "JDBCStore.addJMSBridge(" + string + ")", null);
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    this.daoFactory.getJMSBGDAO().insert(null, string, logger);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var7_5 = null;
                this.setInProgress(false);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    @Override
    public List getJMSBridges(java.util.logging.Logger logger) throws Exception {
        return this.getJMSBridgesByBroker(this.dbmgr.getBrokerID(), logger);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List getJMSBridgesByBroker(String string, java.util.logging.Logger logger) throws Exception {
        if (DEBUG) {
            JDBCStore.logger.log(4, "JDBCStore.getJMSBridgesByBroker(" + string + ")");
            Util.logExt(logger, Level.FINE, "JDBCStore.getJMSBridges(" + string + ")", null);
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                List list;
                try {
                    list = this.daoFactory.getJMSBGDAO().getNamesByBroker(null, string, logger);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var6_6 = null;
                this.setInProgress(false);
                return list;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getJMSBridgeUpdatedTime(String string, java.util.logging.Logger logger) throws KeyNotFoundException, Exception {
        if (string == null) {
            throw new IllegalArgumentException("null name");
        }
        if (DEBUG) {
            JDBCStore.logger.log(4, "JDBCStore.getJMSBridgeUpdatedTime(" + string + ")");
            Util.logExt(logger, Level.FINE, "JDBCStore.getJMSBridgeUpdatedTime(" + string + ")", null);
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                long l;
                try {
                    l = this.daoFactory.getJMSBGDAO().getUpdatedTime(null, string, logger);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var7_6 = null;
                this.setInProgress(false);
                return l;
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getJMSBridgeCreatedTime(String string, java.util.logging.Logger logger) throws KeyNotFoundException, Exception {
        if (string == null) {
            throw new IllegalArgumentException("null name");
        }
        if (DEBUG) {
            JDBCStore.logger.log(4, "JDBCStore.getJMSbridgeCreatedTime(" + string + ")");
            Util.logExt(logger, Level.FINE, "JDBCStore.getJMSBridgeCreatedTime(" + string + ")", null);
        }
        this.checkClosedAndSetInProgress();
        try {
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                long l;
                try {
                    l = this.daoFactory.getJMSBGDAO().getCreatedTime(null, string, logger);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy();
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                Object var7_6 = null;
                this.setInProgress(false);
                return l;
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.setInProgress(false);
            throw throwable;
        }
    }

    @Override
    public void closeJMSBridgeStore() throws Exception {
    }

    static class StoreSessionReaperTask
    extends TimerTask {
        private boolean canceled = false;
        Logger logger = Globals.getLogger();
        JDBCStore store = null;

        public StoreSessionReaperTask(JDBCStore jDBCStore) {
            this.store = jDBCStore;
        }

        public synchronized boolean cancel() {
            this.canceled = true;
            return super.cancel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = this;
            synchronized (object) {
                if (this.canceled) {
                    return;
                }
            }
            try {
                object = this.store.daoFactory.getStoreSessionDAO();
                object.deleteInactiveStoreSession(null);
            }
            catch (Exception exception) {
                this.logger.logStack(32, "B3177", exception);
            }
        }
    }
}

