/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.core;

import com.sun.messaging.jmq.io.DestMetricsCounters;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.config.ConfigListener;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.BrokerMonitor;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.ExpirationInfo;
import com.sun.messaging.jmq.jmsserver.core.LowPriorityComparator;
import com.sun.messaging.jmq.jmsserver.core.OldestComparator;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.Producer;
import com.sun.messaging.jmq.jmsserver.core.ProducerUID;
import com.sun.messaging.jmq.jmsserver.core.Queue;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.core.Topic;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.handlers.RefCompare;
import com.sun.messaging.jmq.jmsserver.license.LicenseBase;
import com.sun.messaging.jmq.jmsserver.management.agent.Agent;
import com.sun.messaging.jmq.jmsserver.persist.ChangeRecordInfo;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.service.ConnectionManager;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.service.HAMonitorService;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQBasicConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.ConflictException;
import com.sun.messaging.jmq.jmsserver.util.ConsumerAlreadyAddedException;
import com.sun.messaging.jmq.jmsserver.util.DestinationNotFoundException;
import com.sun.messaging.jmq.jmsserver.util.FeatureUnavailableException;
import com.sun.messaging.jmq.jmsserver.util.TransactionAckExistException;
import com.sun.messaging.jmq.jmsserver.util.lists.AddReason;
import com.sun.messaging.jmq.jmsserver.util.lists.RemoveReason;
import com.sun.messaging.jmq.jmsservice.BrokerEvent;
import com.sun.messaging.jmq.util.DestLimitBehavior;
import com.sun.messaging.jmq.util.DestState;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.GoodbyeReason;
import com.sun.messaging.jmq.util.SizeString;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.lists.EventListener;
import com.sun.messaging.jmq.util.lists.EventType;
import com.sun.messaging.jmq.util.lists.Filter;
import com.sun.messaging.jmq.util.lists.OutOfLimitsException;
import com.sun.messaging.jmq.util.lists.Reason;
import com.sun.messaging.jmq.util.lists.SimpleNFLHashMap;
import com.sun.messaging.jmq.util.lists.Sized;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.selector.SelectorFormatException;
import com.sun.messaging.jmq.util.timer.MQTimer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.Vector;

public abstract class Destination
implements Serializable,
EventListener {
    protected String INITIALIZEBY = "";
    private static boolean DEBUG_CLUSTER = Globals.getConfig().getBooleanProperty("imq.cluster.debug.ha") || Globals.getConfig().getBooleanProperty("imq.cluster.debug.txn") || Globals.getConfig().getBooleanProperty("imq.cluster.debug.msg");
    public static String DEBUG_LISTS_PROP = "imq.lists.debug";
    public static boolean DEBUG_LISTS = Globals.getConfig().getBooleanProperty(DEBUG_LISTS_PROP);
    public static final int LOAD_COUNT = Globals.getConfig().getIntProperty("imq.destination.verbose.cnt", 10000);
    static final long serialVersionUID = 4399175316523022128L;
    public static final boolean PERSIST_SYNC = Globals.getConfig().getBooleanProperty("imq.persist.file.sync.enabled", false);
    private static boolean DEBUG = DEBUG_CLUSTER;
    public static final boolean EXPIRE_DELIVERED_MSG = Globals.getConfig().getBooleanProperty("imq.destination.expireDeliveredMessages", false);
    public static final boolean PURGE_DELIVERED_MSG = Globals.getConfig().getBooleanProperty("imq.destination.purgeDeliveredMessages", false);
    public static final boolean NO_PRODUCER_FLOW = Globals.getConfig().getBooleanProperty("imq.noProducerFlow", false);
    public static final int DEFAULT_MAX_PRODUCER_BATCH = 1000;
    public static final int DEFAULT_DESTINATION_SIZE = 100000;
    public static final int DEFAULT_MAX_PRODUCERS = 100;
    public static final int DEFAULT_PREFETCH = 1000;
    public static final int ALL_DESTINATIONS_MASK = 0;
    public static final int TEMP_DESTINATIONS_MASK = 16;
    public static final int UNLIMITED = -1;
    public static final int NONE = 0;
    private static final String AUTO_QUEUE_STR = "imq.autocreate.queue";
    private static final String AUTO_TOPIC_STR = "imq.autocreate.topic";
    private static final String DST_REAP_STR = "imq.autocreate.reaptime";
    private static final String MSG_REAP_STR = "imq.message.expiration.interval";
    private static final long DEFAULT_TIME = 120L;
    private static boolean ALLOW_QUEUE_AUTOCREATE = Globals.getConfig().getBooleanProperty("imq.autocreate.queue", true);
    private static boolean ALLOW_TOPIC_AUTOCREATE = Globals.getConfig().getBooleanProperty("imq.autocreate.topic", true);
    public static long AUTOCREATE_EXPIRE = Globals.getConfig().getLongProperty("imq.autocreate.reaptime", 120L) * 1000L;
    public static long MESSAGE_EXPIRE = Globals.getConfig().getLongProperty("imq.message.expiration.interval", 120L) * 1000L;
    public static final int MAX_PRODUCER_BATCH = Globals.getConfig().getIntProperty("imq.producer.maxBatch", 1000);
    public static final int MAX_PRODUCER_BYTES_BATCH = -1;
    protected transient boolean destvalid = true;
    protected transient boolean startedDestroy = false;
    transient Set BehaviorSet = null;
    protected transient Logger logger = Globals.getLogger();
    protected transient BrokerResources br = Globals.getBrokerResources();
    protected transient BrokerMonitor bm = null;
    protected transient boolean stored = false;
    protected transient boolean neverStore = false;
    protected transient SimpleNFLHashMap destMessages = null;
    private boolean dest_inited = false;
    private transient int refCount = 0;
    private static boolean CAN_MONITOR_DEST = false;
    private static boolean CAN_USE_LOCAL_DEST = false;
    protected int expiredCnt = 0;
    protected int purgedCnt = 0;
    protected int ackedCnt = 0;
    protected int discardedCnt = 0;
    protected int overflowCnt = 0;
    protected int errorCnt = 0;
    protected int rollbackCnt = 0;
    transient int size = 0;
    transient int remoteSize = 0;
    transient long bytes = 0L;
    transient long remoteBytes = 0L;
    transient boolean loaded = false;
    protected transient SimpleNFLHashMap consumers = new SimpleNFLHashMap();
    protected transient SimpleNFLHashMap producers = new SimpleNFLHashMap();
    private static MQTimer timer;
    transient DestReaperTask destReaper = null;
    protected DestinationUID uid = null;
    protected int type = -1;
    protected transient int state = -1;
    protected int scope = 1;
    protected int limit = 2;
    protected ConnectionUID id = null;
    protected SizeString msgSizeLimit = null;
    protected int countLimit = 0;
    protected SizeString memoryLimit = null;
    private static final String AUTO_MAX_NUM_MSGS = "imq.autocreate.destination.maxNumMsgs";
    private static final String AUTO_MAX_TOTAL_BYTES = "imq.autocreate.destination.maxTotalMsgBytes";
    private static final String AUTO_MAX_BYTES_MSG = "imq.autocreate.destination.maxBytesPerMsg";
    public static final String AUTO_MAX_NUM_PRODUCERS = "imq.autocreate.destination.maxNumProducers";
    private static final String AUTO_LOCAL_ONLY = "imq.autocreate.destination.isLocalOnly";
    private static final String AUTO_LIMIT_BEHAVIOR = "imq.autocreate.destination.limitBehavior";
    protected static int defaultMaxMsgCnt;
    protected static int defaultProducerCnt;
    private static final long _defbytes = 0xA00000L;
    protected static SizeString defaultMaxMsgBytes;
    private static final long _defMbytes = 10240L;
    protected static SizeString defaultMaxBytesPerMsg;
    protected static boolean defaultIsLocal;
    protected static int defaultLimitBehavior;
    protected int maxConsumerLimit = -1;
    protected int maxProducerLimit = defaultProducerCnt;
    protected int maxPrefetch = 1000;
    protected transient int producerMsgBatchSize = MAX_PRODUCER_BATCH;
    protected transient long producerMsgBatchBytes = -1L;
    private long clientReconnectInterval = 0L;
    private transient ReconnectReaperTask reconnectReaper = null;
    private static int reconnectMultiplier;
    private transient ProducerFlow producerFlow = new ProducerFlow();
    public static final String USE_DMQ_STR = "imq.autocreate.destination.useDMQ";
    public static final String TRUNCATE_BODY_STR = "imq.destination.DMQ.truncateBody";
    public static final String LOG_MSGS_STR = "imq.destination.logDeadMsgs";
    public static boolean defaultUseDMQ;
    public static final boolean defaultTruncateBody;
    public static final boolean defaultVerbose;
    private static Queue deadMessageQueue;
    private boolean unloadMessagesAtStore = false;
    public static final String DMQ_NAME = "mq.sys.dmq";
    private static boolean autocreateUseDMQ;
    boolean useDMQ = autocreateUseDMQ;
    static boolean storeBodyWithDMQ;
    static boolean verbose;
    boolean isDMQ = false;
    boolean validateXMLSchemaEnabled = false;
    String XMLSchemaUriList = null;
    boolean reloadXMLSchemaOnFailure = false;
    private transient boolean clusterNotifyFlag = false;
    private transient Map<Integer, ChangeRecordInfo> currentChangeRecordInfo = Collections.synchronizedMap(new HashMap());
    public static final String TEMP_CNT = "JMQ_SUN_JMSQ_TempRedeliverCnt";
    public int seqCnt = 0;
    transient Object behaviorListener = null;
    transient MsgExpirationReaper expireReaper = new MsgExpirationReaper();
    protected transient Filter filter = new DestFilter();
    protected transient DestMetricsCounters dmc = new DestMetricsCounters();
    transient long lastMetricsTime;
    transient int msgsIn = 0;
    transient int msgsOut = 0;
    transient int lastMsgsIn = 0;
    transient int lastMsgsOut = 0;
    transient long msgBytesIn = 0L;
    transient long msgBytesOut = 0L;
    transient long lastMsgBytesIn = 0L;
    transient long lastMsgBytesOut = 0L;
    public static final String SCOPE_PROPERTY = "scope";
    public static final String MAX_CONSUMERS = "max_consumers";
    public static final String MAX_PRODUCERS = "max_producers";
    public static final String MAX_PREFETCH = "max_prefetch";
    public static final String MAX_MESSAGES = "max_messages";
    public static final String MAX_BYTES = "max_bytes";
    public static final String MAX_MSG_BYTES = "max_msg_bytes";
    public static final String BEHAVIOUR = "behaviour";
    public static final String STATE = "state";
    public static final String NAME = "name";
    public static final String IS_QUEUE = "queue";
    public static final String IS_INTERNAL = "internal";
    public static final String IS_AUTOCREATED = "autocreated";
    public static final String IS_TEMPORARY = "temporary";
    public static final String IS_ADMIN = "admin";
    public static final String IS_LOCAL = "local";
    public static final String REAL_TYPE = "type";
    public static final String USE_DMQ = "useDMQ";
    public static final String VALIDATE_XML_SCHEMA_ENABLED = "validateXMLSchemaEnabled";
    public static final String XML_SCHEMA_URI_LIST = "XMLSchemaUriList";
    public static final String RELOAD_XML_SCHEMA_ON_FAILURE = "reloadXMLSchemaOnFailure";
    transient Filter unloadfilter = new UnloadFilter();
    boolean overrideP = false;
    boolean overridePvalue = false;
    boolean overrideTTL = false;
    long overrideTTLvalue = 0L;
    private static Map destinationList;
    static boolean destsLoaded;
    protected static boolean valid;
    private static SizeString individual_max_size;
    private static SizeString max_size;
    private static long message_max_count;
    private static long totalbytes;
    private static int totalcnt;
    private static int totalcntNonPersist;
    private static Map packetlist;
    public static final String SYSTEM_MAX_SIZE = "imq.system.max_size";
    public static final String SYSTEM_MAX_COUNT = "imq.system.max_count";
    public static final String MAX_MESSAGE_SIZE = "imq.message.max_size";
    private static ConfigListener cl;
    private static boolean inited;
    static final int DEST_PAUSE = 0;
    static final int DEST_RESUME = 1;
    static final int DEST_UPDATE = 2;
    static final int DEST_BEHAVIOR_CHANGE = 3;

    public ChangeRecordInfo getCurrentChangeRecordInfo(int n) {
        return this.currentChangeRecordInfo.get(n);
    }

    public void setCurrentChangeRecordInfo(int n, ChangeRecordInfo changeRecordInfo) {
        this.currentChangeRecordInfo.put(n, changeRecordInfo);
    }

    public PacketReference peekNext() {
        return null;
    }

    public void setUseDMQ(boolean bl) throws BrokerException {
        if (bl && this.isDMQ) {
            throw new BrokerException(this.br.getKString("B4189"));
        }
        Boolean bl2 = this.useDMQ;
        this.useDMQ = bl;
        this.notifyAttrUpdated(16384, bl2, this.useDMQ);
    }

    public boolean getUseDMQ() {
        return this.useDMQ;
    }

    public static void storeBodyInDMQ(boolean bl) {
        storeBodyWithDMQ = bl;
    }

    public static boolean getStoreBodyInDMQ() {
        return storeBodyWithDMQ;
    }

    public static void setVerbose(boolean bl) {
        verbose = bl;
    }

    public static boolean getVerbose() {
        return verbose;
    }

    public static Queue getDMQ() {
        return deadMessageQueue;
    }

    protected Destination(DestinationUID destinationUID) {
        this.uid = destinationUID;
    }

    private static synchronized Queue createDMQ() throws BrokerException, IOException {
        DestinationUID destinationUID = DestinationUID.getUID(DMQ_NAME, true);
        Queue queue = null;
        queue = (Queue)destinationList.get(destinationUID);
        try {
            if (queue == null) {
                Globals.getLogger().log(8, "B1144");
                queue = (Queue)Destination.createDestination(DMQ_NAME, 4097, true, false, null, false, false);
                queue.maxProducerLimit = 0;
                queue.scope = Globals.getHAEnabled() ? 1 : 0;
                queue.msgSizeLimit = null;
                queue.setLimitBehavior(1);
                queue.memoryLimit = new SizeString(10240L);
                queue.countLimit = 1000;
                queue.setCapacity(1000);
                queue.maxPrefetch = 1000;
                queue.isDMQ = true;
                queue.useDMQ = false;
                queue.update();
            }
        }
        catch (BrokerException brokerException) {
            if (brokerException.getStatusCode() == 409) {
                Globals.getLogger().log(4, "Another broker has created the DMQ, reloading");
                queue = (Queue)Globals.getStore().getDestination(destinationUID);
            }
            throw brokerException;
        }
        queue.load(true, null, null);
        return queue;
    }

    public void removeDeadMessage(PacketReference packetReference) throws IOException, BrokerException {
        this.removeDeadMessage(packetReference, packetReference.getDeadComment(), packetReference.getDeadException(), packetReference.getDeadDeliverCnt(), packetReference.getDeadReason(), packetReference.getDeadBroker());
    }

    public static void removeDeadMessage(SysMessageID sysMessageID, String string, Throwable throwable, int n, Reason reason, String string2) throws IOException, BrokerException {
        PacketReference packetReference = Destination.get(sysMessageID);
        Destination destination = packetReference.getDestination();
        destination.removeDeadMessage(packetReference, string, throwable, n, reason, string2);
    }

    public void removeDeadMessage(PacketReference packetReference, String string, Throwable throwable, int n, Reason reason, String string2) throws IOException, BrokerException {
        if (DEBUG) {
            this.logger.log(4, "Calling removeDeadMessage on " + packetReference + " [" + string + "," + throwable + "," + n + "," + reason + "]");
        }
        if (packetReference.isInvalid()) {
            this.logger.log(4, "Internal Error: message is already dead");
            return;
        }
        Destination destination = packetReference.getDestination();
        if (destination == deadMessageQueue) {
            throw new RuntimeException("Already dead");
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        if (string != null) {
            hashtable.put("JMS_SUN_DMQ_UNDELIVERED_COMMENT", string);
        }
        if (n != -1) {
            hashtable.put(TEMP_CNT, new Integer(n));
        }
        if (throwable != null) {
            hashtable.put("JMS_SUN_DMQ_UNDELIVERED_EXCEPTION", throwable);
        }
        if (string2 != null) {
            hashtable.put("JMS_SUN_DMQ_DEAD_BROKER", string2);
        } else {
            hashtable.put("JMS_SUN_DMQ_DEAD_BROKER", Globals.getMyAddress().toString());
        }
        if (reason == null) {
            reason = RemoveReason.ERROR;
        }
        this.removeMessage(packetReference.getSysMessageID(), reason, hashtable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void markDead(PacketReference packetReference, Reason reason, Hashtable hashtable) throws BrokerException {
        Object[] objectArray;
        PacketReference packetReference2;
        long l;
        long l2;
        long l3;
        boolean bl;
        boolean bl2;
        block48: {
            Integer n;
            boolean bl3;
            Hashtable hashtable2;
            Packet packet;
            block47: {
                block51: {
                    Object v;
                    block46: {
                        block50: {
                            block45: {
                                block49: {
                                    packet = packetReference.getPacket();
                                    if (packet == null) {
                                        this.logger.log(4, "Internal Error: null packet for DMQ");
                                        return;
                                    }
                                    hashtable2 = null;
                                    try {
                                        hashtable2 = packet.getProperties();
                                        if (hashtable2 == null) {
                                            hashtable2 = new Hashtable();
                                        }
                                    }
                                    catch (Exception exception) {
                                        this.logger.logStack(4, "could not get props ", exception);
                                        hashtable2 = new Hashtable();
                                    }
                                    bl2 = false;
                                    v = hashtable2.get("JMS_SUN_LOG_DEAD_MESSAGES");
                                    if (v == null) break block49;
                                    if (v instanceof Boolean) {
                                        bl2 = (Boolean)v;
                                        break block45;
                                    } else if (v instanceof String) {
                                        bl2 = Boolean.valueOf((String)v);
                                        break block45;
                                    } else {
                                        this.logger.log(16, "B3100", "Unknown type for verbose " + v.getClass());
                                        bl2 = verbose;
                                    }
                                    break block45;
                                }
                                bl2 = verbose;
                            }
                            if (this.isDMQ) {
                                if (!DEBUG) {
                                    if (!bl2) return;
                                }
                                this.logger.log(8, "B1145", (Object)packetReference.getSysMessageID(), DestinationUID.getUID(packet.getDestination(), packet.getIsQueue()).toString());
                                return;
                            }
                            bl = false;
                            v = hashtable2.get("JMS_SUN_PRESERVE_UNDELIVERED");
                            if (v == null) break block50;
                            if (v instanceof Boolean) {
                                bl = (Boolean)v;
                                break block46;
                            } else if (v instanceof String) {
                                bl = Boolean.valueOf((String)v);
                                break block46;
                            } else {
                                this.logger.log(16, "B3100", "Unknown type for preserve undelivered " + v.getClass());
                                bl = this.useDMQ;
                            }
                            break block46;
                        }
                        bl = this.useDMQ;
                    }
                    l3 = packetReference.getTime();
                    l2 = packetReference.getTimestamp();
                    l = packetReference.getExpireTime();
                    if (!bl) {
                        if (DEBUG || bl2) {
                            Object[] objectArray2 = new String[]{packetReference.getSysMessageID().toString(), packetReference.getDestinationUID().toString(), this.lookupReasonString(reason, l3, l, l2)};
                            this.logger.log(8, "B1146", objectArray2);
                        }
                        if (packetReference.isLocal()) return;
                        Globals.getClusterBroadcast().acknowledgeMessage(packetReference.getAddress(), packetReference.getSysMessageID(), packetReference.getQueueUID(), 7, hashtable, true);
                        return;
                    }
                    bl3 = false;
                    v = hashtable2.get("JMS_SUN_TRUNCATE_MSG_BODY");
                    if (v == null) break block51;
                    if (v instanceof Boolean) {
                        bl3 = (Boolean)v;
                        break block47;
                    } else if (v instanceof String) {
                        bl3 = Boolean.valueOf((String)v);
                        break block47;
                    } else {
                        this.logger.log(16, "B3100", "Unknown type for preserve undelivered " + v.getClass());
                        bl3 = !storeBodyWithDMQ;
                    }
                    break block47;
                }
                boolean bl4 = bl3 = !storeBodyWithDMQ;
            }
            if (hashtable == null) {
                hashtable = new Hashtable();
            }
            if ((n = (Integer)hashtable.remove(TEMP_CNT)) != null) {
                hashtable.put("JMSXDeliveryCount", n);
            }
            if (packetReference.isLocal()) {
                hashtable.putAll(hashtable2);
            } else {
                hashtable.put("REASON", new Integer(reason.intValue()));
            }
            if (hashtable.get("JMS_SUN_DMQ_UNDELIVERED_COMMENT") == null) {
                hashtable.put("JMS_SUN_DMQ_UNDELIVERED_COMMENT", this.lookupReasonString(reason, l3, l, l2));
            }
            hashtable.put("JMS_SUN_DMQ_UNDELIVERED_TIMESTAMP", new Long(System.currentTimeMillis()));
            hashtable.put("JMS_SUN_DMQ_BODY_TRUNCATED", bl3);
            Object var17_16 = null;
            if (reason == RemoveReason.EXPIRED) {
                hashtable.put("JMS_SUN_DMQ_UNDELIVERED_REASON", "EXPIRED");
            } else if (reason == RemoveReason.REMOVED_LOW_PRIORITY) {
                hashtable.put("JMS_SUN_DMQ_UNDELIVERED_REASON", "LOW_PRIORITY");
            } else if (reason == RemoveReason.REMOVED_OLDEST) {
                hashtable.put("JMS_SUN_DMQ_UNDELIVERED_REASON", "OLDEST");
            } else if (reason == RemoveReason.UNDELIVERABLE) {
                hashtable.put("JMS_SUN_DMQ_UNDELIVERED_REASON", "UNDELIVERABLE");
            } else {
                hashtable.put("JMS_SUN_DMQ_UNDELIVERED_REASON", "ERROR");
            }
            if (packetReference.getAddress() != null) {
                hashtable.put("JMS_SUN_DMQ_PRODUCING_BROKER", packetReference.getAddress().toString());
            } else {
                hashtable.put("JMS_SUN_DMQ_PRODUCING_BROKER", Globals.getMyAddress().toString());
            }
            String string = (String)hashtable2.get("JMS_SUN_DMQ_DEAD_BROKER");
            if (string != null) {
                hashtable.put("JMS_SUN_DMQ_DEAD_BROKER", string);
            } else {
                hashtable.put("JMS_SUN_DMQ_DEAD_BROKER", Globals.getMyAddress().toString());
            }
            if (!packetReference.isLocal()) {
                Globals.getClusterBroadcast().acknowledgeMessage(packetReference.getAddress(), packetReference.getSysMessageID(), packetReference.getQueueUID(), 7, hashtable, true);
                return;
            }
            Packet packet2 = new Packet();
            boolean bl5 = false;
            packetReference2 = null;
            try {
                packet2.generateSequenceNumber(false);
                packet2.generateTimestamp(false);
                packet2.fill(packet);
                packet2.setProperties(hashtable);
                if (bl3) {
                    packet2.setMessageBody(new byte[0]);
                }
                packetReference2 = PacketReference.createReference(packet2, deadMessageQueue.getDestinationUID(), null);
                packetReference2.overrideExpireTime(0L);
                packetReference2.clearExpirationInfo();
                packetReference2.setTimestamp(System.currentTimeMillis());
                objectArray = deadMessageQueue;
                // MONITORENTER : deadMessageQueue
                packetReference2.setSequence(Destination.deadMessageQueue.seqCnt++);
                // MONITOREXIT : objectArray
                Destination.routeMoveAndForwardMessage(packetReference, packetReference2, deadMessageQueue);
            }
            catch (Exception exception) {
                if (reason == RemoveReason.UNDELIVERABLE || reason == RemoveReason.ERROR) {
                    if (!(exception instanceof BrokerException)) throw new BrokerException(this.br.getKString("B4190"), exception);
                    throw (BrokerException)exception;
                }
                if (!DEBUG && !bl2) break block48;
                this.logger.logStack(16, "B2090", packetReference.getSysMessageID().toString(), (Throwable)exception);
            }
        }
        if ((DEBUG || bl2) && bl) {
            objectArray = new String[]{packetReference.getSysMessageID().toString(), packetReference.getDestinationUID().toString(), this.lookupReasonString(reason, l3, l, l2)};
            this.logger.log(8, "B1147", objectArray);
        }
        packetReference2.unload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PacketReference _replaceMessage(SysMessageID sysMessageID, Hashtable hashtable, byte[] byArray) throws BrokerException, IOException {
        PacketReference packetReference = Destination.get(sysMessageID);
        long l = packetReference.byteSize();
        ArrayList<Consumer> arrayList = new ArrayList<Consumer>();
        Consumer consumer = null;
        Iterator iterator = this.getConsumers();
        while (iterator.hasNext()) {
            consumer = (Consumer)iterator.next();
            if (!(consumer instanceof Subscription) || !consumer.unrouteMessage(packetReference)) continue;
            arrayList.add(consumer);
        }
        SysMessageID sysMessageID2 = packetReference.replacePacket(hashtable, byArray);
        this.destMessages.remove(sysMessageID);
        this.destMessages.put(sysMessageID2, packetReference);
        Class<?> serializable2 = this.getClass();
        synchronized (serializable2) {
            totalbytes += packetReference.byteSize() - l;
        }
        Destination.removePacketList(sysMessageID, packetReference.getDestinationUID());
        Destination.packetlistAdd(sysMessageID2, packetReference.getDestinationUID());
        Object var11_11 = null;
        for (Subscription subscription : arrayList) {
            subscription.routeMessage(packetReference, false);
        }
        return packetReference;
    }

    public SysMessageID replaceMessage(SysMessageID sysMessageID, Hashtable hashtable, byte[] byArray) throws BrokerException, IOException {
        return this._replaceMessage(sysMessageID, hashtable, byArray).getSysMessageID();
    }

    public String replaceMessageString(SysMessageID sysMessageID, Hashtable hashtable, byte[] byArray) throws BrokerException, IOException {
        return this._replaceMessage(sysMessageID, hashtable, byArray).getSysMessageIDString();
    }

    public static void routeMoveAndForwardMessage(PacketReference packetReference, PacketReference packetReference2, Destination destination) throws IOException, BrokerException {
        Set set;
        boolean bl = destination.queueMessage(packetReference2, false);
        if (bl && (set = destination.routeAndMoveMessage(packetReference, packetReference2)) != null) {
            destination.forwardMessage(set, packetReference2);
        }
    }

    public abstract Set routeAndMoveMessage(PacketReference var1, PacketReference var2) throws IOException, BrokerException;

    public void setReconnectInterval(long l) {
        this.clientReconnectInterval = l * (long)reconnectMultiplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clientReconnect() {
        Destination destination = this;
        synchronized (destination) {
            if (this.reconnectReaper != null) {
                this.reconnectReaper.cancel();
                this.reconnectReaper = null;
            }
        }
    }

    private void updateProducerBatch(boolean bl) {
        int n = this.producerMsgBatchSize;
        long l = this.producerMsgBatchBytes;
        boolean bl2 = bl = bl && this.limit == 0;
        if (this.limit == 0) {
            this.producerMsgBatchSize = Destination.calcProducerBatchCnt(this.destMessages.capacity(), this.maxProducerLimit);
            this.producerMsgBatchBytes = Destination.calcProducerBatchBytes(this.destMessages.byteCapacity(), this.maxProducerLimit);
        } else {
            this.producerMsgBatchSize = MAX_PRODUCER_BATCH;
            this.producerMsgBatchBytes = -1L;
        }
        if (bl && (n != this.producerMsgBatchSize || l != this.producerMsgBatchBytes)) {
            this.producerFlow.updateAllProducers(2, "update batch");
        }
    }

    private static int calcProducerBatchCnt(int n, int n2) {
        int n3;
        if (n == -1) {
            return MAX_PRODUCER_BATCH;
        }
        int n4 = n2;
        if (n4 <= 0) {
            n4 = 100;
        }
        if ((n3 = n / n4) <= 0) {
            n3 = 1;
        }
        if (n3 > MAX_PRODUCER_BATCH) {
            return MAX_PRODUCER_BATCH;
        }
        return n3;
    }

    private static long calcProducerBatchBytes(long l, int n) {
        long l2;
        if (l == -1L) {
            return -1L;
        }
        int n2 = n;
        if (n2 <= 0) {
            n2 = 100;
        }
        if ((l2 = l / (long)n2) <= 0L) {
            l2 = 1L;
        }
        return l2;
    }

    private boolean sendClusterUpdate() {
        return !this.isInternal() && !this.isAdmin();
    }

    protected void handleLimitBehavior(int n) {
        if (n == 0) {
            this.destMessages.enforceLimits(false);
            FlowListener flowListener = new FlowListener();
            if (this.behaviorListener != null) {
                this.destMessages.removeEventListener(this.behaviorListener);
                this.behaviorListener = null;
            }
            this.behaviorListener = this.destMessages.addEventListener(flowListener, EventType.FULL, null);
            this.producerFlow.updateAllProducers(3, "behavior change");
        } else if (n == 1) {
            Set set = this.destMessages.subSet(new OldestComparator());
            RemoveBehaviorListener removeBehaviorListener = new RemoveBehaviorListener(set, RemoveReason.REMOVED_OLDEST);
            if (this.behaviorListener != null) {
                this.destMessages.removeEventListener(this.behaviorListener);
                this.behaviorListener = null;
            }
            this.behaviorListener = this.destMessages.addEventListener(removeBehaviorListener, EventType.SET_CHANGED_REQUEST, null);
            this.destMessages.enforceLimits(false);
        } else if (n == 2) {
            this.destMessages.enforceLimits(true);
            if (this.behaviorListener != null) {
                this.destMessages.removeEventListener(this.behaviorListener);
                this.behaviorListener = null;
            }
        } else if (n == 3) {
            this.destMessages.enforceLimits(false);
            Set set = this.destMessages.subSet(new LowPriorityComparator());
            RemoveBehaviorListener removeBehaviorListener = new RemoveBehaviorListener(set, RemoveReason.REMOVED_LOW_PRIORITY);
            if (this.behaviorListener != null) {
                this.destMessages.removeEventListener(this.behaviorListener);
                this.behaviorListener = null;
            }
            this.behaviorListener = this.destMessages.addEventListener(removeBehaviorListener, EventType.SET_CHANGED_REQUEST, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initialize() {
        block5: {
            try {
                if (!this.stored) break block5;
                int n = this.size;
                long l = this.bytes;
                HashMap hashMap = Globals.getStore().getMessageStorageInfo(this);
                this.size = (Integer)hashMap.get("numMsgs");
                this.bytes = (Long)hashMap.get("totalMsgBytes");
                this.size += this.remoteSize;
                this.bytes += this.remoteBytes;
                if (this.isAdmin() || !this.getIsDMQ() && this.isInternal()) break block5;
                Class<?> clazz = this.getClass();
                synchronized (clazz) {
                    totalcnt = totalcnt - n + this.size;
                    totalbytes = totalbytes - l + this.bytes;
                }
            }
            catch (Exception exception) {
                this.logger.logStack(8, "B3044", exception);
            }
        }
        this.dest_inited = true;
    }

    public void initializeOldDestination() {
        this.overridePersistence(true);
        this.stored = true;
        this.dest_inited = false;
        this.loaded = false;
    }

    public boolean getIsDMQ() {
        return this.isDMQ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.logger = Globals.getLogger();
        this.br = Globals.getBrokerResources();
        this.currentChangeRecordInfo = Collections.synchronizedMap(new HashMap());
        this.producerFlow = new ProducerFlow();
        this.isDMQ = DestType.isDMQ(this.type);
        if (!this.isDMQ) {
            this.expireReaper = new MsgExpirationReaper();
        }
        this.dest_inited = false;
        this.loaded = false;
        this.destvalid = true;
        this.destMessages = new SimpleNFLHashMap();
        this.consumers = new SimpleNFLHashMap();
        this.producers = new SimpleNFLHashMap();
        if (this.maxConsumerLimit > -1) {
            this.consumers.setCapacity(this.maxConsumerLimit);
        }
        if (this.maxProducerLimit > -1) {
            this.producers.setCapacity(this.maxProducerLimit);
        }
        this.filter = new DestFilter();
        this.unloadfilter = new UnloadFilter();
        this.dmc = new DestMetricsCounters();
        this.stored = true;
        this.setMaxPrefetch(this.maxPrefetch);
        this.handleLimitBehavior(this.limit);
        if (this.memoryLimit != null) {
            this.setByteCapacity(this.memoryLimit);
        }
        if (this.countLimit > 0) {
            this.setCapacity(this.countLimit);
        }
        if (this.msgSizeLimit != null) {
            this.setMaxByteSize(this.msgSizeLimit);
        }
        this.updateProducerBatch(false);
        if (this.clientReconnectInterval > 0L) {
            Destination destination = this;
            synchronized (destination) {
                if (this.clientReconnectInterval > 0L) {
                    this.reconnectReaper = new ReconnectReaperTask(this.getDestinationUID(), this.clientReconnectInterval);
                    try {
                        timer.schedule((TimerTask)this.reconnectReaper, this.clientReconnectInterval);
                    }
                    catch (IllegalStateException illegalStateException) {
                        this.logger.log(8, "B3100", (Object)"Can not reschedule task, timer has been canceled, the broker is probably shutting down", (Throwable)illegalStateException);
                    }
                }
            }
        }
        this.logger.log(4, "Loading Stored destination " + this + " connectionUID=" + this.id);
    }

    protected void initMonitor() throws IOException {
        if (DestType.isInternal(this.type) && !DestType.destNameIsInternalLogging(this.getDestinationName())) {
            if (!CAN_MONITOR_DEST) {
                throw new IOException(Globals.getBrokerResources().getKString("B4180", Globals.getBrokerResources().getKString("B0048"), this.getName()));
            }
            try {
                this.bm = new BrokerMonitor(this);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.logger.log(8, "B3100", (Object)("Unknown Monitor destination " + this.getDestinationName()), (Throwable)illegalArgumentException);
            }
            catch (BrokerException brokerException) {
                this.logger.log(8, "B3100", (Object)("Monitor destination Error  " + this.getDestinationName()), (Throwable)brokerException);
            }
        }
    }

    protected void initVar() {
    }

    protected Destination(String string, int n, boolean bl, ConnectionUID connectionUID, boolean bl2) throws FeatureUnavailableException, BrokerException, IOException {
        int n2;
        this.uid = new DestinationUID(string, DestType.isQueue(n));
        this.initVar();
        if (this.uid.isWildcard()) {
            throw new RuntimeException("Do not create wildcards");
        }
        this.id = connectionUID;
        this.producers.setCapacity(this.maxProducerLimit);
        this.consumers.setCapacity(this.maxConsumerLimit);
        this.destMessages = new SimpleNFLHashMap();
        this.destMessages.enforceLimits(true);
        if (bl2) {
            if (!DestType.isAdmin(n)) {
                if (defaultMaxMsgCnt > 0) {
                    this.setCapacity(defaultMaxMsgCnt);
                }
                this.setByteCapacity(defaultMaxMsgBytes);
                this.setMaxByteSize(defaultMaxBytesPerMsg);
                this.setLimitBehavior(defaultLimitBehavior);
                if (defaultIsLocal) {
                    this.setScope(0);
                }
            }
            if (!(DestType.isAdmin(n) || Destination.canAutoCreate(DestType.isQueue(n), n) || BrokerMonitor.isInternal(string))) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B2083", this.getName()), "B2083", null, 403);
            }
            n2 = DestType.isAdmin(n) ? 4 : 8;
            this.logger.log(n2, "B1132", this.getName());
            this.type = n | 0x20;
        } else {
            n2 = DestType.isAdmin(n) ? 4 : 8;
            this.type = n;
            if ((n & 0x10) == 16) {
                this.logger.log(n2, "B1160", (Object)(connectionUID == null ? "<none>" : connectionUID.toString()), this.getName());
            } else {
                this.logger.log(n2, "B1158", this.getName());
            }
        }
        if ((n & 0x1000) == 0 && BrokerMonitor.isInternal(string)) {
            if (DestType.isQueue(n)) {
                throw new BrokerException("Internal Exception: Only topics are supported for monitoring");
            }
            this.type = n | 0x40;
            this.setScope(this.scope);
            try {
                if (!DestType.destNameIsInternalLogging(this.getDestinationName())) {
                    if (!CAN_MONITOR_DEST) {
                        throw new BrokerException(this.br.getKString("B4180", Globals.getBrokerResources().getKString("B0048"), this.getName()), "B4180", null, 403);
                    }
                    this.bm = new BrokerMonitor(this);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new BrokerException(this.br.getKString("B2084", this.getName()), "B2084", illegalArgumentException, 400);
            }
        }
        this.loaded = true;
        if (!bl) {
            this.neverStore = true;
            this.overridePersistence(false);
        }
        Iterator iterator = Consumer.getWildcardConsumers();
        while (iterator.hasNext()) {
            ConsumerUID consumerUID = (ConsumerUID)iterator.next();
            Consumer consumer = Consumer.getConsumer(consumerUID);
            if (consumer == null) {
                this.logger.log(8, "Consumer [" + consumerUID + "] for destination [" + this.getName() + "] already destroyed.");
                continue;
            }
            DestinationUID destinationUID = consumer.getDestinationUID();
            if (!DestinationUID.match(this.getDestinationUID(), destinationUID)) continue;
            try {
                if (consumer.getSubscription() != null) {
                    this.addConsumer(consumer.getSubscription(), false);
                    continue;
                }
                consumer.attachToDestination(this);
            }
            catch (SelectorFormatException selectorFormatException) {}
        }
        this.handleLimitBehavior(this.limit);
        this.updateProducerBatch(false);
        this.state = 0;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public DestinationUID getDestinationUID() {
        return this.uid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseDestination(int n) {
        Object object;
        assert (n != -1);
        assert (n != 0);
        assert (n <= 3);
        assert (this.state == 0);
        int n2 = this.state;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (n2 == n) {
            return;
        }
        if (n2 == 0) {
            if (n == 2 || n == 3) {
                bl2 = true;
            }
            if (n == 1 || n == 3) {
                bl = true;
            }
        } else if (n2 == 3) {
            if (n == 1) {
                bl4 = true;
            } else if (n == 2) {
                bl3 = true;
            }
        } else if (n2 == 1) {
            if (n == 3) {
                bl2 = true;
            } else if (n == 2) {
                bl3 = true;
                bl2 = true;
            }
        } else if (n2 == 2) {
            if (n == 3) {
                bl = true;
            } else if (n == 1) {
                bl = true;
                bl4 = true;
            }
        }
        this.state = n;
        if (bl4) {
            this.producerFlow.updateAllProducers(1, "Destination is resumed");
        }
        if (bl3) {
            object = this.consumers;
            synchronized (object) {
                for (Consumer consumer : this.consumers.values()) {
                    consumer.resume("Destination.RESUME");
                }
            }
        }
        if (bl2) {
            this.producerFlow.updateAllProducers(0, "Destination is paused");
        }
        if (bl) {
            object = this.consumers;
            synchronized (object) {
                Iterator iterator = this.consumers.values().iterator();
                while (iterator.hasNext()) {
                    Consumer consumer;
                    Consumer consumer2 = consumer = iterator.next();
                    consumer2.pause("Destination PAUSE");
                }
            }
        }
        if ((object = Globals.getAgent()) != null) {
            ((Agent)object).notifyDestinationPause(this, n);
        }
    }

    public boolean isPaused() {
        return this.state > 0 && this.state <= 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeDestination() {
        Object object;
        assert (this.state > 0 && this.state <= 3);
        int n = this.state;
        this.state = 0;
        if (n == 2 || n == 3) {
            this.producerFlow.updateAllProducers(1, "Destination is resumed");
        }
        if (n == 1 || n == 3) {
            object = this.consumers;
            synchronized (object) {
                for (Consumer consumer : this.consumers.values()) {
                    consumer.resume("Destination.RESUME");
                }
            }
        }
        if ((object = Globals.getAgent()) != null) {
            ((Agent)object).notifyDestinationResume(this);
        }
    }

    public void compact() throws BrokerException {
        Globals.getStore().compactDestination(this);
        Agent agent = Globals.getAgent();
        if (agent != null) {
            agent.notifyDestinationCompact(this);
        }
    }

    public static void resetAllMetrics() {
        Iterator iterator = Destination.getAllDestinations();
        while (iterator.hasNext()) {
            Destination destination = (Destination)iterator.next();
            destination.resetMetrics();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetMetrics() {
        DestMetricsCounters destMetricsCounters = this.dmc;
        synchronized (destMetricsCounters) {
            this.expiredCnt = 0;
            this.purgedCnt = 0;
            this.ackedCnt = 0;
            this.discardedCnt = 0;
            this.overflowCnt = 0;
            this.errorCnt = 0;
            this.msgsIn = 0;
            this.msgsOut = 0;
            this.lastMsgsIn = 0;
            this.lastMsgsOut = 0;
            this.msgBytesIn = 0L;
            this.msgBytesOut = 0L;
            this.lastMsgBytesIn = 0L;
            this.lastMsgBytesOut = 0L;
            this.destMessages.reset();
            this.consumers.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DestMetricsCounters getMetrics() {
        DestMetricsCounters destMetricsCounters = this.dmc;
        synchronized (destMetricsCounters) {
            long l = System.currentTimeMillis();
            long l2 = (l - this.lastMetricsTime) / 1000L;
            this.dmc.timeStamp = l;
            this.dmc.setMessagesIn(this.msgsIn);
            this.dmc.setMessagesOut(this.msgsOut);
            this.dmc.setHighWaterMessages(this.destMessages.highWaterCount());
            this.dmc.setHighWaterMessageBytes(this.destMessages.highWaterBytes());
            this.dmc.setHighWaterLargestMsgBytes(this.destMessages.highWaterLargestMessageBytes());
            this.dmc.setActiveConsumers(this.consumers.size());
            this.dmc.setNumConsumers(this.consumers.size());
            this.dmc.setFailoverConsumers(0);
            this.dmc.setHWActiveConsumers(this.consumers.highWaterCount());
            this.dmc.setHWNumConsumers(this.consumers.highWaterCount());
            this.dmc.setHWFailoverConsumers(0);
            this.dmc.setAvgActiveConsumers((int)this.consumers.averageCount());
            this.dmc.setAvgNumConsumers((int)this.consumers.averageCount());
            this.dmc.setAvgFailoverConsumers(0);
            this.dmc.setMessageBytesIn(this.msgBytesIn);
            this.dmc.setMessageBytesOut(this.msgBytesOut);
            this.dmc.setCurrentMessages(this.destMessages.size());
            this.dmc.setCurrentMessageBytes(this.destMessages.byteSize());
            this.dmc.setAverageMessages((int)this.destMessages.averageCount());
            this.dmc.setAverageMessageBytes((long)this.destMessages.averageBytes());
            if (this.isStored()) {
                try {
                    if (Globals.getStore().getStoreType().equals("file")) {
                        HashMap hashMap = Globals.getStore().getStorageInfo(this);
                        Object var7_6 = null;
                        Object v = hashMap.get("diskReserved");
                        var7_6 = v;
                        if (v != null) {
                            this.dmc.setDiskReserved((Long)var7_6);
                        }
                        Object v2 = hashMap.get("diskUsed");
                        var7_6 = v2;
                        if (v2 != null) {
                            this.dmc.setDiskUsed((Long)var7_6);
                        }
                        Object v3 = hashMap.get("diskUtilizationRatio");
                        var7_6 = v3;
                        if (v3 != null) {
                            this.dmc.setUtilizationRatio((Integer)var7_6);
                        }
                    }
                }
                catch (BrokerException brokerException) {
                    this.logger.log(32, brokerException.getMessage(), brokerException);
                }
            }
            this.dmc.setExpiredMsgCnt(this.expiredCnt);
            this.dmc.setPurgedMsgCnt(this.purgedCnt);
            this.dmc.setAckedMsgCnt(this.ackedCnt);
            this.dmc.setDiscardedMsgCnt(this.discardedCnt);
            this.dmc.setRejectedMsgCnt(this.overflowCnt + this.errorCnt);
            this.dmc.setRollbackMsgCnt(this.rollbackCnt);
            this.lastMetricsTime = l;
            this.lastMsgsIn = this.msgsIn;
            this.lastMsgsOut = this.msgsOut;
            this.lastMsgBytesIn = this.msgBytesIn;
            this.lastMsgBytesOut = this.msgBytesOut;
            return this.dmc;
        }
    }

    public int getState() {
        return this.state;
    }

    protected void setState(int n) {
        this.state = n;
    }

    public void setIsLocal(boolean bl) throws BrokerException {
        int n = 0;
        n = bl ? 0 : 1;
        this.setScope(n);
    }

    public void setScope(int n) throws BrokerException {
        if (!CAN_USE_LOCAL_DEST && n == 0) {
            throw new BrokerException(this.br.getKString("B4180", Globals.getBrokerResources().getKString("B0049"), this.getName()), "B4180", null, 403);
        }
        this.scope = n;
    }

    public int getScope() {
        return this.scope;
    }

    public boolean getIsLocal() {
        return this.scope == 0;
    }

    public void setLimitBehavior(int n) throws BrokerException {
        if (this.isDMQ && n == 0) {
            throw new BrokerException(this.br.getKString("B4191"));
        }
        Integer n2 = new Integer(this.limit);
        this.limit = n;
        this.handleLimitBehavior(this.limit);
        this.notifyAttrUpdated(64, n2, new Integer(this.limit));
    }

    public int getLimitBehavior() {
        return this.limit;
    }

    public void setClusterDeliveryPolicy(int n) {
        throw new UnsupportedOperationException(" cluster delivery policy not supported for this type of destination ");
    }

    public int getClusterDeliveryPolicy() {
        return 0;
    }

    public boolean isStored() {
        return !this.neverStore || this.stored;
    }

    public synchronized boolean store() throws BrokerException, IOException {
        if (this.neverStore || this.stored) {
            return false;
        }
        Globals.getStore().storeDestination(this, PERSIST_SYNC);
        this.stored = true;
        return this.stored;
    }

    public boolean shouldSync() {
        return PERSIST_SYNC;
    }

    public void update() throws BrokerException, IOException {
        this.update(true);
    }

    public void update(boolean bl) throws BrokerException, IOException {
        boolean bl2;
        boolean bl3 = bl2 = !this.getIsDMQ() && bl && this.sendClusterUpdate() && !this.isTemporary();
        if (bl2) {
            Globals.getClusterBroadcast().recordUpdateDestination(this);
        }
        if (!this.neverStore && this.stored) {
            Globals.getStore().updateDestination(this, PERSIST_SYNC);
        }
        this.updateProducerBatch(true);
        if (bl2) {
            Globals.getClusterBroadcast().updateDestination(this);
        }
    }

    public HashMap getDestinationProperties() {
        HashMap hashMap = new HashMap();
        this.getDestinationProps(hashMap);
        return hashMap;
    }

    protected void getDestinationProps(Map map) {
        map.put(NAME, this.getDestinationName());
        map.put(IS_QUEUE, this.isQueue());
        map.put(IS_INTERNAL, this.isInternal());
        map.put(IS_AUTOCREATED, this.isAutoCreated());
        map.put(IS_TEMPORARY, this.isTemporary());
        map.put(IS_ADMIN, this.isAdmin());
        map.put(IS_LOCAL, this.getIsLocal());
        map.put(REAL_TYPE, new Integer(this.type));
        map.put(SCOPE_PROPERTY, new Integer(this.scope));
        map.put(MAX_CONSUMERS, new Integer(this.maxConsumerLimit));
        map.put(MAX_PRODUCERS, new Integer(this.maxProducerLimit));
        map.put(MAX_PREFETCH, new Integer(this.maxPrefetch));
        map.put(MAX_MESSAGES, new Integer(this.countLimit));
        map.put(USE_DMQ, this.useDMQ);
        if (this.memoryLimit != null) {
            map.put(MAX_BYTES, new Long(this.memoryLimit.getBytes()));
        }
        if (this.msgSizeLimit != null) {
            map.put(MAX_MSG_BYTES, new Long(this.msgSizeLimit.getBytes()));
        }
        map.put(BEHAVIOUR, new Integer(this.limit));
        map.put(STATE, new Integer(this.scope));
        map.put(VALIDATE_XML_SCHEMA_ENABLED, this.validateXMLSchemaEnabled);
        if (this.XMLSchemaUriList != null) {
            map.put(XML_SCHEMA_URI_LIST, this.XMLSchemaUriList);
        }
        map.put(RELOAD_XML_SCHEMA_ON_FAILURE, this.reloadXMLSchemaOnFailure);
    }

    public void setDestinationProperties(Map map) throws BrokerException {
        SizeString sizeString;
        if (DEBUG) {
            this.logger.log(4, "Setting destination properties for " + this + " to " + map);
        }
        if (map.get(MAX_CONSUMERS) != null) {
            try {
                this.setMaxConsumers((Integer)map.get(MAX_CONSUMERS));
            }
            catch (BrokerException brokerException) {
                this.logger.log(8, "B3044", brokerException);
            }
        }
        if (map.get(MAX_PRODUCERS) != null) {
            try {
                this.setMaxProducers((Integer)map.get(MAX_PRODUCERS));
            }
            catch (BrokerException brokerException) {
                this.logger.log(8, "B3044", brokerException);
            }
        }
        if (map.get(MAX_PREFETCH) != null) {
            this.setMaxPrefetch((Integer)map.get(MAX_PREFETCH));
        }
        if (map.get(MAX_MESSAGES) != null) {
            this.setCapacity((Integer)map.get(MAX_MESSAGES));
        }
        if (map.get(MAX_BYTES) != null) {
            sizeString = new SizeString();
            sizeString.setBytes((Long)map.get(MAX_BYTES));
            this.setByteCapacity(sizeString);
        }
        if (map.get(MAX_MSG_BYTES) != null) {
            sizeString = new SizeString();
            sizeString.setBytes((Long)map.get(MAX_MSG_BYTES));
            this.setMaxByteSize(sizeString);
        }
        if (map.get(BEHAVIOUR) != null) {
            this.setLimitBehavior((Integer)map.get(BEHAVIOUR));
        }
        if (map.get(IS_LOCAL) != null) {
            this.setIsLocal((Boolean)map.get(IS_LOCAL));
        }
        if (map.get(USE_DMQ) != null) {
            this.setUseDMQ((Boolean)map.get(USE_DMQ));
        }
        try {
            this.update(false);
        }
        catch (Exception exception) {
            this.logger.log(16, "B3100", (Object)("Unable to update destination " + this.getName()), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable getAllDebugState() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("TABLE", "All Destinations");
        hashtable.put("maxMsgSize", individual_max_size == null ? "null" : individual_max_size.toString());
        hashtable.put("maxTotalSize", max_size == null ? "null" : max_size.toString());
        hashtable.put("maxCount", String.valueOf(message_max_count));
        hashtable.put("totalBytes", String.valueOf(totalbytes));
        hashtable.put("totalCnt", String.valueOf(totalcnt));
        hashtable.put("totalCntNonPersist", String.valueOf(totalcntNonPersist));
        hashtable.put("sync", String.valueOf(PERSIST_SYNC));
        hashtable.put("allProducerFlow", String.valueOf(!NO_PRODUCER_FLOW));
        hashtable.put("autoCreateTopics", String.valueOf(ALLOW_TOPIC_AUTOCREATE));
        hashtable.put("autoCreateQueue", String.valueOf(ALLOW_QUEUE_AUTOCREATE));
        hashtable.put("messageExpiration", String.valueOf(MESSAGE_EXPIRE));
        hashtable.put("producerBatch", String.valueOf(MAX_PRODUCER_BATCH));
        hashtable.put("QueueSpecific", Queue.getAllDebugState());
        hashtable.put("msgCnt", packetlist == null ? "null" : String.valueOf(packetlist.size()));
        Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
        if (destinationList != null) {
            ArrayList arrayList = null;
            Map map = destinationList;
            synchronized (map) {
                arrayList = new ArrayList(destinationList.keySet());
            }
            hashtable.put("destinationCnt", String.valueOf(arrayList.size()));
            for (DestinationUID destinationUID : arrayList) {
                Destination destination = Destination.getDestination(destinationUID);
                if (destination == null) {
                    hashtable2.put(destinationUID.getLocalizedName(), "Unknown");
                    continue;
                }
                hashtable2.put(destinationUID.getLocalizedName(), destination.getDebugState());
            }
        } else {
            hashtable.put("destinationCnt", "null");
        }
        hashtable.put("destinations", hashtable2);
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getDebugState() {
        Serializable serializable;
        Serializable serializable2;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("TABLE", "Destination[" + this.uid.toString() + "]");
        this.getDestinationProps(hashtable);
        hashtable.putAll(this.getMetrics());
        hashtable.put("Consumers", String.valueOf(this.consumers.size()));
        Iterator<Object> iterator = this.consumers.values().iterator();
        ArrayList arrayList = null;
        Serializable serializable3 = this.destMessages;
        synchronized (serializable3) {
            arrayList = new ArrayList(this.destMessages.values());
        }
        while (iterator.hasNext()) {
            serializable3 = (Consumer)iterator.next();
            serializable2 = ((Consumer)serializable3).getConsumerUID();
            serializable = ((Consumer)serializable3).getStoredConsumerUID();
            int n = arrayList.size();
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            for (int i = 0; i < n; ++i) {
                PacketReference packetReference = (PacketReference)arrayList.get(i);
                if (!packetReference.matches((ConsumerUID)serializable)) continue;
                ++n2;
                if (packetReference.isAcknowledged((ConsumerUID)serializable)) {
                    ++n4;
                }
                if (!packetReference.isDelivered((ConsumerUID)serializable)) continue;
                ++n3;
            }
            String string = n2 + " of " + n + "[ d=" + n3 + ", a=" + n4 + "]";
            hashtable.put("Consumer[" + String.valueOf(((UID)serializable2).longValue()) + "]", string);
        }
        serializable3 = null;
        serializable2 = this.producers;
        synchronized (serializable2) {
            serializable3 = new HashSet(this.producers.keySet());
        }
        iterator = serializable3.iterator();
        serializable2 = new Vector();
        while (iterator.hasNext()) {
            serializable = (ProducerUID)iterator.next();
            ((Vector)serializable2).add(String.valueOf(serializable.longValue()));
        }
        hashtable.put("Producers", serializable2);
        hashtable.put("_stored", String.valueOf(this.stored));
        hashtable.put("_neverStore", String.valueOf(this.neverStore));
        hashtable.put("_destvalid", String.valueOf(this.destvalid));
        hashtable.put("_loaded", String.valueOf(this.loaded));
        hashtable.put("_state", DestState.toString(this.state));
        hashtable.put("producerMsgBatchSize", String.valueOf(this.producerMsgBatchSize));
        hashtable.put("producerMsgBatchBytes", String.valueOf(this.producerMsgBatchBytes));
        if (this.reconnectReaper != null) {
            hashtable.put("_reconnectReaper", this.reconnectReaper.toString());
        }
        hashtable.put("_clientReconnectInterval", String.valueOf(this.clientReconnectInterval));
        hashtable.put("TrueType", DestType.toString(this.type));
        if (this.id != null) {
            hashtable.put("ConnectionUID", String.valueOf(this.id.longValue()));
        }
        hashtable.put("activeProducerCount", String.valueOf(this.producerFlow.activeProducerCnt()));
        hashtable.put("pausedProducerCount", String.valueOf(this.producerFlow.pausedProducerCnt()));
        hashtable.put("pausedProducerSet", this.producerFlow.getDebugPausedProducers());
        hashtable.put("activeProducerSet", this.producerFlow.getDebugActiveProducers());
        serializable = null;
        hashtable.put("size", this.size);
        hashtable.put("bytes", this.bytes);
        hashtable.put("remoteSize", Long.valueOf(this.remoteSize));
        hashtable.put("remoteBytes", this.remoteBytes);
        Object object = this.destMessages;
        synchronized (object) {
            if (this.destMessages != null) {
                hashtable.put("destMessagesSize", String.valueOf(this.destMessages.size()));
                serializable = new ArrayList(this.destMessages.keySet());
            }
        }
        if (serializable != null) {
            iterator = serializable.iterator();
            serializable2 = new Vector();
            object = null;
            String string = "null";
            while (iterator.hasNext()) {
                SysMessageID sysMessageID = (SysMessageID)iterator.next();
                object = (PacketReference)this.destMessages.get(sysMessageID);
                string = "null";
                if (object != null) {
                    string = "local=" + ((PacketReference)object).isLocal() + ",invalid=" + ((PacketReference)object).isInvalid() + ",destroyed=" + ((PacketReference)object).isDestroyed() + ",overrided=" + ((PacketReference)object).isOverrided() + ",overriding=" + ((PacketReference)object).isOverriding() + ",locked=" + (((PacketReference)object).checkLock(false) == null);
                }
                ((Vector)serializable2).add(sysMessageID.toString() + "  ref=" + string);
            }
            hashtable.put("Messages", serializable2);
        }
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getDebugMessages(boolean bl) {
        Object object;
        if (!this.loaded) {
            try {
                this.load();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Vector<Hashtable> vector = new Vector<Hashtable>();
        try {
            object = null;
            Object object2 = this.destMessages;
            synchronized (object2) {
                object = new HashSet(this.destMessages.values()).iterator();
            }
            while (object.hasNext()) {
                object2 = (PacketReference)object.next();
                Hashtable hashtable = ((PacketReference)object2).getDebugState();
                hashtable.put("ID", ((PacketReference)object2).getSysMessageID().toString());
                if (bl) {
                    hashtable.put("PACKET", ((PacketReference)object2).getPacket().dumpPacketString("        "));
                }
                vector.add(hashtable);
            }
        }
        catch (Throwable throwable) {
            this.logger.log(4, "Error getting debugMessages ", throwable);
        }
        object = new Hashtable<String, Vector<Hashtable>>();
        ((Hashtable)object).put("  ", vector);
        return object;
    }

    public SysMessageID[] getSysMessageIDs() throws BrokerException {
        return this.getSysMessageIDs(null, null);
    }

    public SysMessageID[] getSysMessageIDs(Long l, Long l2) throws BrokerException {
        long l3;
        SysMessageID[] sysMessageIDArray = new SysMessageID[]{};
        if (!this.loaded) {
            this.load();
        }
        if ((l3 = (long)this.destMessages.size()) == 0L) {
            return sysMessageIDArray;
        }
        if (l == null) {
            l = new Long(0L);
        } else if (l < 0L || l > l3 - 1L) {
            String string = " Start message index needs to be in between 0 and " + (l3 - 1L);
            throw new BrokerException(string);
        }
        if (l2 == null) {
            l2 = new Long(l3 - l);
        } else if (l2 < 0L) {
            String string = " Max number of messages retrieved value needs to be greater than 0.";
            throw new BrokerException(string);
        }
        long l4 = l + l2;
        TreeSet<PacketReference> treeSet = new TreeSet<PacketReference>(new RefCompare());
        try {
            for (PacketReference packetReference : new HashSet(this.destMessages.values())) {
                treeSet.add(packetReference);
            }
        }
        catch (Throwable throwable) {
            this.logger.log(4, "Error getting msg IDs ", throwable);
        }
        ArrayList arrayList = new ArrayList();
        long l5 = 0L;
        for (PacketReference packetReference : treeSet) {
            if (l5 >= l && l5 < l4) {
                SysMessageID sysMessageID = packetReference.getSysMessageID();
                arrayList.add(sysMessageID);
            }
            if (l5 >= l4) break;
            ++l5;
        }
        sysMessageIDArray = arrayList.toArray(sysMessageIDArray);
        return sysMessageIDArray;
    }

    public String getName() {
        return this.uid.getLocalizedName();
    }

    public String getDestinationName() {
        return this.uid.getName();
    }

    public ConnectionUID getConnectionUID() {
        return this.id;
    }

    public boolean isAutoCreated() {
        return (this.type & 0x20) > 0;
    }

    public boolean isTemporary() {
        return (this.type & 0x10) > 0;
    }

    public boolean isQueue() {
        return (this.type & 1) > 0;
    }

    public int getType() {
        return this.type;
    }

    public Collection getAllMessages() throws UnsupportedOperationException {
        return this.destMessages.values();
    }

    public void purgeDestination() throws BrokerException {
        this.purgeDestination(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeDestination(boolean bl) throws BrokerException {
        if (!this.loaded) {
            this.load(bl);
        }
        try {
            HashSet hashSet = null;
            SimpleNFLHashMap simpleNFLHashMap = this.destMessages;
            synchronized (simpleNFLHashMap) {
                hashSet = new HashSet(this.destMessages.keySet());
            }
            long l = 0L;
            long l2 = 0L;
            RemoveMessageReturnInfo removeMessageReturnInfo = null;
            SysMessageID sysMessageID2 = null;
            for (SysMessageID sysMessageID2 : hashSet) {
                removeMessageReturnInfo = this._removeMessage(sysMessageID2, RemoveReason.PURGED, null, null);
                if (removeMessageReturnInfo.removed) {
                    ++l;
                    continue;
                }
                if (!removeMessageReturnInfo.indelivery) continue;
                ++l2;
            }
            this.logger.log(8, this.br.getKString("B1387", l, this.uid.getLocalizedName()));
            this.logger.log(8, this.br.getKString("B1388", l2, this.uid.getLocalizedName()));
            Agent agent = Globals.getAgent();
            if (agent != null) {
                agent.notifyDestinationPurge(this);
            }
        }
        catch (Exception exception) {
            if (BrokerStateHandler.shuttingDown) {
                this.logger.log(8, "B3232", (Object)this.getName(), (Throwable)exception);
            } else {
                this.logger.logStack(16, "B3232", this.getName(), (Throwable)exception);
            }
            if (exception instanceof BrokerException) {
                throw (BrokerException)exception;
            }
            throw new BrokerException(this.br.getKString("B3232", this.getName()), exception);
        }
    }

    public void purgeDestination(Filter filter) throws BrokerException {
        if (!this.loaded) {
            this.load();
        }
        Map map = this.destMessages.getAll(filter);
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            try {
                this.removeMessage((SysMessageID)iterator.next(), RemoveReason.PURGED);
            }
            catch (Exception exception) {
                this.logger.logStack(8, "B3232", this.getName(), (Throwable)exception);
            }
        }
    }

    public Map getAll(Filter filter) {
        if (!this.loaded) {
            try {
                this.load();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.destMessages.getAll(filter);
    }

    public int size() throws UnsupportedOperationException {
        if (!this.loaded) {
            return this.size;
        }
        return this.destMessages.size();
    }

    public long byteSize() throws UnsupportedOperationException {
        if (!this.loaded) {
            return this.bytes;
        }
        return this.destMessages.byteSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRemoteSize() {
        int n = 0;
        HashSet hashSet = null;
        SimpleNFLHashMap simpleNFLHashMap = this.destMessages;
        synchronized (simpleNFLHashMap) {
            hashSet = new HashSet(this.destMessages.values());
        }
        for (PacketReference packetReference : hashSet) {
            if (packetReference.isLocal()) continue;
            ++n;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRemoteBytes() {
        long l = 0L;
        HashSet hashSet = null;
        SimpleNFLHashMap simpleNFLHashMap = this.destMessages;
        synchronized (simpleNFLHashMap) {
            hashSet = new HashSet(this.destMessages.values());
        }
        for (PacketReference packetReference : hashSet) {
            if (packetReference.isLocal()) continue;
            l += packetReference.getSize();
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int txnSize() {
        HashSet hashSet = null;
        Object object = this.destMessages;
        synchronized (object) {
            hashSet = new HashSet(this.destMessages.values());
        }
        object = hashSet.iterator();
        int n = 0;
        TransactionList transactionList = Globals.getTransactionList();
        while (object.hasNext()) {
            PacketReference packetReference = (PacketReference)object.next();
            TransactionUID transactionUID = packetReference.getTransactionID();
            if (transactionUID == null || transactionList.retrieveState(transactionUID) == null) continue;
            ++n;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long txnByteSize() {
        HashSet hashSet = null;
        Object object = this.destMessages;
        synchronized (object) {
            hashSet = new HashSet(this.destMessages.values());
        }
        object = hashSet.iterator();
        long l = 0L;
        TransactionList transactionList = Globals.getTransactionList();
        while (object.hasNext()) {
            PacketReference packetReference = (PacketReference)object.next();
            TransactionUID transactionUID = packetReference.getTransactionID();
            if (transactionUID == null || transactionList.retrieveState(transactionUID) == null) continue;
            l += packetReference.getSize();
        }
        return l;
    }

    public abstract int getUnackSize();

    public long getHighWaterBytes() {
        return this.destMessages.highWaterBytes();
    }

    public int getHighWaterCount() {
        return this.destMessages.highWaterCount();
    }

    public long highWaterLargestMessageBytes() {
        return this.destMessages.highWaterLargestMessageBytes();
    }

    public double getAverageBytes() {
        return this.destMessages.averageBytes();
    }

    public float getAverageCount() {
        return this.destMessages.averageCount();
    }

    public double averageMessageBytes() {
        return this.destMessages.averageMessageBytes();
    }

    public SizeString getMaxByteSize() {
        return this.msgSizeLimit;
    }

    public int getCapacity() {
        return this.countLimit;
    }

    public SizeString getByteCapacity() {
        return this.memoryLimit;
    }

    public void setMaxByteSize(SizeString sizeString) throws UnsupportedOperationException {
        Long l;
        if (DEBUG) {
            this.logger.log(4, "attempting to set Message Size Limit to " + sizeString + " for destination " + this);
        }
        if ((l = this.msgSizeLimit == null ? new Long(-1L) : new Long(this.msgSizeLimit.getBytes())) == 0L) {
            l = new Long(-1L);
        }
        this.msgSizeLimit = sizeString;
        long l2 = 0L;
        l2 = sizeString == null ? -1L : sizeString.getBytes();
        if (l2 == 0L) {
            l2 = -1L;
        }
        this.destMessages.setMaxByteSize(l2);
        this.notifyAttrUpdated(16, l, new Long(l2));
    }

    public void setCapacity(int n) throws UnsupportedOperationException {
        if (DEBUG) {
            this.logger.log(4, "attempting to set Message Count Limit to " + n + " for destination " + this);
        }
        Long l = new Long(this.countLimit);
        if (n == 0) {
            n = -1;
        }
        this.countLimit = n;
        this.destMessages.setCapacity(n);
        this.updateProducerBatch(false);
        this.notifyAttrUpdated(4, l, new Long(this.countLimit));
    }

    public void setByteCapacity(SizeString sizeString) throws UnsupportedOperationException {
        Long l;
        if (DEBUG) {
            this.logger.log(4, "attempting to set Message Bytes Limit to " + sizeString + " for destination " + this);
        }
        if ((l = this.memoryLimit == null ? new Long(-1L) : new Long(this.memoryLimit.getBytes())) == 0L) {
            l = new Long(-1L);
        }
        this.memoryLimit = sizeString;
        long l2 = 0L;
        l2 = sizeString == null ? -1L : sizeString.getBytes();
        if (l2 == 0L) {
            l2 = -1L;
        }
        this.destMessages.setByteCapacity(l2);
        this.updateProducerBatch(false);
        this.notifyAttrUpdated(8, l, new Long(l2));
    }

    public int getMaxActiveConsumers() {
        return -1;
    }

    public int getMaxFailoverConsumers() {
        return 0;
    }

    public void setMaxProducers(int n) throws BrokerException {
        if (this.isDMQ) {
            throw new BrokerException(this.br.getKString("B4192"));
        }
        if (n == 0) {
            throw new BrokerException(this.br.getKString("B4178", this.getName()), "B4178", null, 500);
        }
        Integer n2 = new Integer(this.maxProducerLimit);
        this.maxProducerLimit = n < -1 ? -1 : n;
        this.producers.setCapacity(this.maxProducerLimit);
        this.notifyAttrUpdated(2048, n2, new Integer(this.maxProducerLimit));
    }

    public int getMaxProducers() {
        return this.maxProducerLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAllActiveConsumerCount() {
        int n = 0;
        SimpleNFLHashMap simpleNFLHashMap = this.consumers;
        synchronized (simpleNFLHashMap) {
            if (this.consumers.size() == 0) {
                return 0;
            }
            Iterator iterator = this.consumers.values().iterator();
            Consumer consumer = null;
            while (iterator.hasNext()) {
                consumer = (Consumer)iterator.next();
                if (consumer instanceof Subscription) {
                    n += ((Subscription)consumer).getChildConsumers().size();
                    continue;
                }
                ++n;
            }
        }
        return n;
    }

    public int getActiveConsumerCount() {
        return this.getConsumerCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getActiveConsumers() {
        HashSet<Consumer> hashSet = new HashSet<Consumer>();
        SimpleNFLHashMap simpleNFLHashMap = this.consumers;
        synchronized (simpleNFLHashMap) {
            for (Consumer consumer : this.consumers.values()) {
                hashSet.add(consumer);
            }
        }
        return hashSet;
    }

    public Set getFailoverConsumers() {
        return new HashSet();
    }

    public int getFailoverConsumerCount() {
        return 0;
    }

    public void setMaxConsumers(int n) throws BrokerException {
        if (n == 0) {
            throw new BrokerException(this.br.getKString("B4179", this.getName()), "B4179", null, 500);
        }
        this.maxConsumerLimit = n < -1 ? -1 : n;
        this.consumers.setCapacity(this.maxConsumerLimit);
    }

    public void setMaxActiveConsumers(int n) throws BrokerException {
        throw new UnsupportedOperationException("setting max active consumers not supported on this destination type");
    }

    public void setMaxFailoverConsumers(int n) throws BrokerException {
        throw new UnsupportedOperationException("setting max failover consumers not supported on this destination type");
    }

    public int hashCode() {
        return this.uid.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof Destination) {
            if (this.uid == ((Destination)object).uid) {
                return true;
            }
            return this.uid.equals(((Destination)object).uid);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean queueMessage(PacketReference packetReference, boolean bl) throws BrokerException {
        if (!valid) {
            throw new BrokerException(this.br.getKString("B1157", this.getName()));
        }
        Destination destination = this;
        synchronized (destination) {
            ++this.msgsIn;
            this.msgBytesIn += packetReference.byteSize();
        }
        try {
            boolean bl2 = !this.isAdmin() && !this.isInternal();
            boolean bl3 = Destination.addNewMessage(bl2, packetReference);
            if (!bl3 && !this.isDMQ) {
                if (!this.isInternal()) {
                    packetReference.setDestination(this);
                    this.markDead(packetReference, RemoveReason.EXPIRED, null);
                    Destination.removePacketList(packetReference.getSysMessageID(), this.getDestinationUID());
                }
                return false;
            }
        }
        catch (BrokerException brokerException) {
            packetReference.destroy();
            throw brokerException;
        }
        packetReference.setDestination(this);
        try {
            if (!valid) {
                packetReference.destroy();
                throw new BrokerException(this.br.getKString("B1157", this.getName()));
            }
            this.putMessage(packetReference, AddReason.QUEUED);
            if (this.overrideP) {
                packetReference.overridePersistence(this.overridePvalue);
            }
            if (!(this.isAdmin() || this.isDMQ() || this.isInternal() || packetReference.isPersistent())) {
                Class<?> clazz = this.getClass();
                synchronized (clazz) {
                    ++totalcntNonPersist;
                }
            }
            if (this.overrideTTL) {
                packetReference.overrideExpireTime(System.currentTimeMillis() + this.overrideTTLvalue);
            }
            ExpirationInfo expirationInfo = packetReference.getExpiration();
            if (this.expireReaper != null && expirationInfo != null) {
                if (!valid) {
                    RuntimeException runtimeException = new RuntimeException("Destination " + this + " destroyed");
                    runtimeException.fillInStackTrace();
                    this.logger.logStack(4, "Removing message to invalid dst", runtimeException);
                    this.removeMessage(packetReference.getSysMessageID(), null);
                    throw runtimeException;
                }
                if (this.expireReaper == null) {
                    RuntimeException runtimeException = new RuntimeException("No Reaper");
                    runtimeException.fillInStackTrace();
                    this.logger.logStack(8, "Internal Error, Unknown  destination " + this + " isValid= " + this.isValid(), runtimeException);
                    return true;
                }
                this.expireReaper.addExpiringMessage(expirationInfo);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw new BrokerException(this.br.getKString("B4212", packetReference.getSysMessageID(), this.toString()), "B4212", illegalStateException, 304);
        }
        catch (OutOfLimitsException outOfLimitsException) {
            this.removeMessage(packetReference.getSysMessageID(), RemoveReason.OVERFLOW);
            Object object = outOfLimitsException.getLimit();
            boolean bl4 = false;
            if (object != null) {
                if (object instanceof Integer) {
                    bl4 = (Integer)outOfLimitsException.getLimit() <= 0;
                } else if (object instanceof Long) {
                    bl4 = (Long)outOfLimitsException.getLimit() <= 0L;
                }
            }
            Object[] objectArray = new String[]{packetReference.getSysMessageID().toString(), this.getName(), bl4 ? this.br.getString("B0012") : outOfLimitsException.getLimit().toString(), outOfLimitsException.getValue().toString()};
            String string = "B4117";
            int n = 414;
            switch (outOfLimitsException.getType()) {
                case 0: {
                    string = "B4120";
                    break;
                }
                case 1: {
                    string = "B4121";
                    break;
                }
                case 2: {
                    string = "B4122";
                    n = 423;
                }
            }
            throw new BrokerException(this.br.getKString(string, objectArray), string, outOfLimitsException, n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.removeMessage(packetReference.getSysMessageID(), RemoveReason.ERROR);
            throw illegalArgumentException;
        }
        return true;
    }

    public abstract ConsumerUID[] calculateStoredInterests(PacketReference var1) throws BrokerException, SelectorFormatException;

    public abstract Set routeNewMessage(PacketReference var1) throws BrokerException, SelectorFormatException;

    public abstract void forwardOrphanMessage(PacketReference var1, ConsumerUID var2) throws BrokerException;

    public abstract void forwardOrphanMessages(Collection var1, ConsumerUID var2) throws BrokerException;

    public abstract void forwardMessage(Set var1, PacketReference var2) throws BrokerException;

    protected abstract ConsumerUID[] routeLoadedTransactionMessage(PacketReference var1) throws BrokerException, SelectorFormatException;

    public abstract void unrouteLoadedTransactionAckMessage(PacketReference var1, ConsumerUID var2) throws BrokerException;

    public void putMessage(PacketReference packetReference, Reason reason) {
        this.putMessage(packetReference, reason, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putMessage(PacketReference packetReference, Reason reason, boolean bl) throws IndexOutOfBoundsException, IllegalArgumentException, IllegalStateException {
        if (!bl) {
            this.destMessages.put(packetReference.getSysMessageID(), packetReference, reason, bl);
            this._messageAdded(packetReference.byteSize(), reason, !packetReference.isLocal(), false);
            return;
        }
        boolean bl2 = false;
        SimpleNFLHashMap simpleNFLHashMap = this.destMessages;
        synchronized (simpleNFLHashMap) {
            PacketReference packetReference2 = (PacketReference)this.destMessages.get(packetReference.getSysMessageID());
            if (packetReference2 != null && packetReference2 != packetReference && !packetReference2.isLocal()) {
                packetReference2.overrided();
                packetReference.overriding();
                bl2 = true;
            }
            this.destMessages.put(packetReference.getSysMessageID(), packetReference, reason, bl);
        }
        this._messageAdded(packetReference.byteSize(), reason, !packetReference.isLocal(), bl2);
    }

    private void unputMessage(PacketReference packetReference, Reason reason) throws IndexOutOfBoundsException, IllegalArgumentException {
        Object object = this.destMessages.remove((Object)packetReference.getSysMessageID(), reason);
        this._messageRemoved(packetReference, packetReference.byteSize(), reason, object != null);
    }

    public boolean removeRemoteMessage(SysMessageID sysMessageID, Reason reason, PacketReference packetReference) throws BrokerException {
        RemoveMessageReturnInfo removeMessageReturnInfo = this._removeMessage(sysMessageID, reason, null, packetReference);
        return removeMessageReturnInfo.removed;
    }

    public boolean removeMessage(SysMessageID sysMessageID, Reason reason) throws BrokerException {
        RemoveMessageReturnInfo removeMessageReturnInfo = this._removeMessage(sysMessageID, reason, null, null);
        return removeMessageReturnInfo.removed;
    }

    public boolean removeMessage(SysMessageID sysMessageID, Reason reason, Hashtable hashtable) throws BrokerException {
        RemoveMessageReturnInfo removeMessageReturnInfo = this._removeMessage(sysMessageID, reason, hashtable, null);
        return removeMessageReturnInfo.removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemoveMessageReturnInfo _removeMessage(SysMessageID sysMessageID, Reason reason, Hashtable hashtable, PacketReference packetReference) throws BrokerException {
        RemoveMessageReturnInfo removeMessageReturnInfo = new RemoveMessageReturnInfo();
        PacketReference packetReference2 = null;
        if (!this.loaded) {
            this.load();
        }
        if ((packetReference2 = (PacketReference)this.destMessages.get(sysMessageID)) == null) {
            Destination.removePacketList(sysMessageID, this.getDestinationUID());
            this.logger.log(4, "Reference already gone for " + sysMessageID);
            return removeMessageReturnInfo;
        }
        if (packetReference != null && packetReference != packetReference2) {
            this.logger.log(DEBUG_CLUSTER || DEBUG ? 8 : 4, "Reference for " + sysMessageID + " is overrided, not remove");
            packetReference.setInvalid();
            return removeMessageReturnInfo;
        }
        ExpirationInfo expirationInfo = packetReference2.getExpiration();
        if (!(reason != RemoveReason.EXPIRED && reason != RemoveReason.PURGED || packetReference2.checkDeliveryAndSetInRemoval())) {
            if (reason == RemoveReason.EXPIRED && !EXPIRE_DELIVERED_MSG) {
                this.logger.log(DEBUG_CLUSTER || DEBUG ? 8 : 4, "Message " + packetReference2.getSysMessageID() + " is not " + reason + " because it has been delivered to client");
                if (expirationInfo != null) {
                    expirationInfo.clearReapCount();
                }
                removeMessageReturnInfo.indelivery = true;
                return removeMessageReturnInfo;
            }
            if (reason == RemoveReason.PURGED && !PURGE_DELIVERED_MSG) {
                this.logger.log(DEBUG_CLUSTER || DEBUG ? 8 : 4, "Message " + packetReference2.getSysMessageID() + " is not " + reason + " because it has been delivered to client");
                removeMessageReturnInfo.indelivery = true;
                return removeMessageReturnInfo;
            }
        }
        PacketReference packetReference3 = packetReference2;
        synchronized (packetReference3) {
            if (packetReference2.getLBitSet()) {
                packetReference2.setInvalid();
                if (reason == RemoveReason.EXPIRED && expirationInfo != null) {
                    expirationInfo.clearReapCount();
                }
                this.logger.log(4, "LBit set for " + sysMessageID);
                return removeMessageReturnInfo;
            }
        }
        boolean bl = false;
        if (!(this.isInternal() || reason != RemoveReason.EXPIRED && reason != RemoveReason.REMOVED_LOW_PRIORITY && reason != RemoveReason.REMOVED_OLDEST && reason != RemoveReason.ERROR && reason != RemoveReason.UNDELIVERABLE)) {
            assert (packetReference == null);
            this.markDead(packetReference2, reason, hashtable);
        }
        packetReference2.setInvalid();
        packetReference2 = (PacketReference)this.destMessages.remove((Object)sysMessageID, reason);
        assert (packetReference2 != null);
        if (packetReference2 == null) {
            this.logger.log(DEBUG_CLUSTER || DEBUG ? 8 : 4, "Reference has already gone for " + sysMessageID);
            return removeMessageReturnInfo;
        }
        long l = packetReference2.byteSize();
        this._messageRemoved(packetReference2, packetReference2.byteSize(), reason, true);
        packetReference2.destroy();
        Destination destination = this;
        synchronized (destination) {
            ++this.msgsOut;
            this.msgBytesOut += packetReference2.byteSize();
            if (expirationInfo != null && reason != RemoveReason.EXPIRED && expirationInfo != null && this.expireReaper != null) {
                this.expireReaper.removeMessage(expirationInfo);
            }
        }
        removeMessageReturnInfo.removed = true;
        return removeMessageReturnInfo;
    }

    public String lookupReasonString(Reason reason, long l, long l2, long l3) {
        String string = null;
        if (reason == RemoveReason.EXPIRED) {
            Object[] objectArray = new String[]{this.getDestinationUID().toString(), new Long(l2).toString(), new Long(l).toString(), new Long(l3).toString()};
            string = l != 0L && l2 != 0L && l2 <= l ? this.br.getKString("B0065", objectArray) : this.br.getKString("B0053", objectArray);
        } else if (reason == RemoveReason.REMOVED_LOW_PRIORITY || reason == RemoveReason.REMOVED_OLDEST) {
            String string2 = this.countLimit <= 0 ? Globals.getBrokerResources().getString("B0012") : String.valueOf(this.countLimit);
            String string3 = this.memoryLimit == null || this.memoryLimit.getBytes() <= 0L ? Globals.getBrokerResources().getString("B0012") : this.memoryLimit.toString();
            Object[] objectArray = new String[]{this.getDestinationUID().toString(), string2, string3};
            string = this.br.getKString("B0054", objectArray);
        } else {
            string = reason == RemoveReason.UNDELIVERABLE ? this.br.getKString("B0055", this.getDestinationUID().toString()) : this.br.getKString("B0056", this.getDestinationUID().toString());
        }
        return string;
    }

    public void primaryInterestChanged(Consumer consumer) {
    }

    private ConnectionUID getConnectionUID(Consumer consumer) {
        return consumer.getConsumerUID().getConnectionUID();
    }

    public Consumer addConsumer(Consumer consumer, boolean bl) throws BrokerException, SelectorFormatException {
        return this.addConsumer(consumer, bl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Consumer addConsumer(Consumer consumer, boolean bl, Connection connection) throws BrokerException, SelectorFormatException {
        Serializable serializable = this.consumers;
        synchronized (serializable) {
            if (this.consumers.get(consumer.getConsumerUID()) != null) {
                throw new ConsumerAlreadyAddedException(this.br.getKString("B1331", consumer.getConsumerUID(), this.toString()));
            }
        }
        if (this.isInternal() && !BrokerMonitor.ENABLED) {
            throw new BrokerException(this.br.getKString("B4181", this.getName()));
        }
        consumer.attachToDestination(this);
        consumer.addRemoveListener(this.destMessages);
        if (!this.loaded && consumer.isActive()) {
            this.load();
        }
        serializable = this.consumers;
        synchronized (serializable) {
            if (this.maxConsumerLimit != -1 && this.maxConsumerLimit <= this.consumers.size()) {
                throw new BrokerException(this.br.getKString("B4182", this.getName(), String.valueOf(this.maxConsumerLimit)), "B4182", null, 409);
            }
            this.consumers.put(consumer.getConsumerUID(), consumer);
            if (this.bm != null && this.consumers.size() == 1) {
                this.bm.start();
            }
            if (this.state == 1 || this.state == 3) {
                consumer.pause("Destination PAUSE2");
            }
        }
        serializable = this;
        synchronized (serializable) {
            if (this.destReaper != null) {
                this.destReaper.cancel();
                this.destReaper = null;
            }
            this.clientReconnect();
        }
        if (this.bm != null) {
            this.bm.updateNewConsumer(consumer);
        }
        return null;
    }

    public void removeConsumer(ConsumerUID consumerUID, boolean bl) throws BrokerException {
        this.removeConsumer(consumerUID, null, false, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConsumer(ConsumerUID consumerUID, Map map, boolean bl, boolean bl2) throws BrokerException {
        Consumer consumer = null;
        SimpleNFLHashMap simpleNFLHashMap = this.consumers;
        synchronized (simpleNFLHashMap) {
            consumer = (Consumer)this.consumers.remove(consumerUID);
            Destination destination = this;
            synchronized (destination) {
                if (this.bm != null && this.consumers.size() == 0) {
                    this.bm.stop();
                }
                if (this.shouldDestroy()) {
                    if (this.destReaper != null) {
                        this.destReaper.cancel();
                        this.destReaper = null;
                    }
                    this.destReaper = new DestReaperTask(this.uid);
                    try {
                        timer.schedule((TimerTask)this.destReaper, AUTOCREATE_EXPIRE);
                    }
                    catch (IllegalStateException illegalStateException) {
                        this.logger.log(4, "Can not reschedule task, timer has been canceled, the broker  is probably shutting down", illegalStateException);
                    }
                }
            }
        }
        if (consumer != null) {
            consumer.removeRemoveListener(this.destMessages);
        }
        if (consumer != null && this.sendClusterUpdate() && bl2) {
            Globals.getClusterBroadcast().destroyConsumer(consumer, map, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyConsumerAdded(Consumer consumer, Connection connection) {
        SimpleNFLHashMap simpleNFLHashMap = this.consumers;
        synchronized (simpleNFLHashMap) {
            BrokerAddress brokerAddress = consumer.getConsumerUID().getBrokerAddress();
            if (brokerAddress == null || brokerAddress == Globals.getMyAddress()) {
                Globals.getConnectionManager().getConsumerInfoNotifyManager().consumerAdded(this, connection);
            } else {
                Globals.getConnectionManager().getConsumerInfoNotifyManager().remoteConsumerAdded(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyConsumerRemoved() {
        SimpleNFLHashMap simpleNFLHashMap = this.consumers;
        synchronized (simpleNFLHashMap) {
            Globals.getConnectionManager().getConsumerInfoNotifyManager().consumerRemoved(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addProducer(Producer producer) throws BrokerException {
        if (this.isInternal()) {
            throw new BrokerException(this.br.getKString("B4184", this.getName()));
        }
        if (this.maxProducerLimit != -1 && this.producers.size() >= this.maxProducerLimit) {
            throw new BrokerException(this.br.getKString("B4183", this.getName(), String.valueOf(this.maxProducerLimit)), "B4183", null, 409);
        }
        Serializable serializable = this;
        synchronized (serializable) {
            if (this.destReaper != null) {
                this.destReaper.cancel();
                this.destReaper = null;
            }
        }
        if (!this.loaded) {
            this.load();
        }
        try {
            serializable = this.producers;
            synchronized (serializable) {
                this.producers.put(producer.getProducerUID(), producer);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new BrokerException(this.br.getKString("B4183", this.getName(), String.valueOf(this.maxProducerLimit)), "B4183", indexOutOfBoundsException, 409);
        }
        this.producerFlow.addProducer(producer);
        boolean bl = this.producerFlow.checkResumeFlow(producer, false);
        this.logger.log(1, "Producer " + producer + " is " + bl);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProducer(ProducerUID producerUID) {
        Producer producer = null;
        Serializable serializable = this.producers;
        synchronized (serializable) {
            producer = (Producer)this.producers.remove(producerUID);
        }
        if (producer == null) {
            return;
        }
        this.producerFlow.removeProducer(producer);
        this.producerFlow.checkResumeFlow(producer, false);
        serializable = this;
        synchronized (serializable) {
            if (this.shouldDestroy()) {
                if (this.destReaper != null) {
                    this.destReaper.cancel();
                    this.destReaper = null;
                }
                this.destReaper = new DestReaperTask(this.uid);
                try {
                    timer.schedule((TimerTask)this.destReaper, AUTOCREATE_EXPIRE);
                }
                catch (IllegalStateException illegalStateException) {
                    this.logger.log(4, "Can not reschedule task, timer has been canceled, the broker is probably shutting down", illegalStateException);
                }
            }
        }
    }

    private void dumpStoredSet(Set set) {
        this.logger.log(8, "DEBUG: Dumping order");
        boolean bl = false;
        for (PacketReference packetReference : set) {
            this.logger.log(8, packetReference.getPriority() + " : " + packetReference.getTime() + " :" + packetReference.getSequence() + "  " + packetReference.getSysMessageID() + " : " + packetReference.getPacket().getTimestamp());
        }
    }

    public abstract void sort(Comparator var1);

    public static void remoteCheckMessageHomeChange(PacketReference packetReference, BrokerAddress brokerAddress) {
        if (packetReference.getAddress() != null && packetReference.getAddress().equals(brokerAddress)) {
            return;
        }
        HashSet hashSet = new HashSet();
        Hashtable hashtable = packetReference.getRemoteConsumerUIDs();
        Consumer consumer = null;
        ConsumerUID consumerUID2 = null;
        for (ConsumerUID consumerUID2 : hashtable.keySet()) {
            consumer = Consumer.getConsumer(consumerUID2);
            if (consumer == null || !consumer.tobeRecreated()) continue;
            hashSet.add(hashtable.get(consumerUID2));
        }
        Destination.destroyConnections(hashSet, 9, GoodbyeReason.toString(9) + "[" + packetReference.getAddress() + ":" + brokerAddress + "]");
    }

    public static void remoteCheckTakeoverMsgs(Map map, String string) throws BrokerException {
        HashSet hashSet = new HashSet();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            SysMessageID sysMessageID = SysMessageID.get((String)iterator.next());
            PacketReference packetReference = Destination.get(sysMessageID);
            if (packetReference == null) continue;
            Iterator iterator2 = packetReference.getRemoteConsumerUIDs().values().iterator();
            while (iterator2.hasNext()) {
                hashSet.add(iterator2.next());
            }
        }
        Destination.destroyConnections(hashSet, 7, GoodbyeReason.toString(7) + ":" + string);
    }

    public static void destroyConnections(Set set, int n, String string) {
        ConnectionManager connectionManager = Globals.getConnectionManager();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            IMQBasicConnection iMQBasicConnection = (IMQBasicConnection)connectionManager.getConnection((ConnectionUID)iterator.next());
            if (iMQBasicConnection == null) continue;
            Globals.getLogger().log(8, "Destroying connection " + iMQBasicConnection + " because " + string);
            if (DEBUG) {
                iMQBasicConnection.dump();
            }
            iMQBasicConnection.destroyConnection(true, n, string);
            iMQBasicConnection.waitForRelease(Globals.getConfig().getLongProperty("imq." + iMQBasicConnection.getService().getName() + ".destroy_timeout", 30L) * 1000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized void loadTakeoverMsgs(Map map, List list, Map map2) throws BrokerException {
        Object[] objectArray;
        Iterator iterator;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Map.Entry entry;
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        Logger logger = Globals.getLogger();
        HashMap hashMap2 = new HashMap();
        if (map2 != null) {
            for (Map.Entry entry2 : map2.entrySet()) {
                TransactionUID transactionUID = (TransactionUID)entry2.getKey();
                entry = (List)entry2.getValue();
                object4 = entry.iterator();
                while (object4.hasNext()) {
                    object3 = (TransactionAcknowledgement)object4.next();
                    object2 = ((TransactionAcknowledgement)object3).getSysMessageID() + ":" + ((TransactionAcknowledgement)object3).getStoredConsumerUID();
                    hashMap2.put(object2, transactionUID);
                }
            }
        }
        HashMap hashMap3 = new HashMap();
        for (Map.Entry entry3 : map.entrySet()) {
            Object object5;
            entry = (String)entry3.getKey();
            object4 = (String)entry3.getValue();
            object3 = new DestinationUID((String)object4);
            object2 = null;
            try {
                object2 = Globals.getStore().getMessage((DestinationUID)object3, (String)((Object)entry));
            }
            catch (BrokerException brokerException) {
                if (brokerException.getStatusCode() == 404 && (object = Destination.getDestination((DestinationUID)object3)) == null) {
                    object5 = new String[]{entry, object4, Globals.getBrokerResources().getString("B3013", object4)};
                    logger.log(32, "B2089", (Object[])object5, (Throwable)brokerException);
                }
                throw brokerException;
            }
            object3 = DestinationUID.getUID(((Packet)object2).getDestination(), ((Packet)object2).getIsQueue());
            iterator = PacketReference.createReference(object2, (DestinationUID)object3, null);
            ((PacketReference)((Object)iterator)).setLoaded();
            logger.log(4, "Loading message " + ((PacketReference)((Object)iterator)).getSysMessageID() + " on " + ((PacketReference)((Object)iterator)).getDestinationUID());
            object = ((PacketReference)((Object)iterator)).getTransactionID();
            if (object != null && list.contains(object)) {
                object5 = Globals.getTransactionList().retrieveState(((PacketReference)((Object)iterator)).getTransactionID());
                if (object5 != null && ((TransactionState)object5).getState() != 7 && ((TransactionState)object5).getState() != 6) {
                    logger.log(4, "Processing open transacted message " + ((PacketReference)((Object)iterator)).getSysMessageID() + " on " + object + "[" + TransactionState.toString(((TransactionState)object5).getState()) + "]");
                    hashMap3.put(((PacketReference)((Object)iterator)).getSysMessageID(), object);
                } else if (object5 != null && ((TransactionState)object5).getState() == 7) {
                    ((PacketReference)((Object)iterator)).destroy();
                    continue;
                }
            }
            Destination.packetlistAdd(((PacketReference)((Object)iterator)).getSysMessageID(), ((PacketReference)((Object)iterator)).getDestinationUID());
            object5 = null;
            object5 = (Set)hashMap.get(object3);
            if (object5 == null) {
                object5 = new TreeSet(new RefCompare());
                hashMap.put(object3, object5);
            }
            object5.add(iterator);
        }
        Iterator iterator2 = hashMap.entrySet().iterator();
        while (true) {
            if (!iterator2.hasNext()) break;
            entry = iterator2.next();
            object4 = (DestinationUID)entry.getKey();
            object3 = (Set)entry.getValue();
            object2 = Destination.getDestination((DestinationUID)object4);
            if (object2 == null) {
                try {
                    object2 = Destination.getDestination(((DestinationUID)object4).getName(), ((DestinationUID)object4).isQueue() ? 1 : 2, true, true);
                }
                catch (IOException iOException) {
                    throw new BrokerException(Globals.getBrokerResources().getKString("B4251", ((Destination)object2).getName()));
                }
            } else {
                iterator = object2;
                synchronized (iterator) {
                    if (((Destination)object2).isLoaded()) {
                        super.initialize();
                    }
                    ((Destination)object2).load((Set)object3);
                }
            }
            logger.log(8, "B1196", (Object)((Destination)object2).getName(), String.valueOf(object3.size()));
            iterator = object3.iterator();
            try {
                while (iterator.hasNext()) {
                    object = (PacketReference)iterator.next();
                    try {
                        boolean bl = ((Destination)object2).destMessages.getEnforceLimits();
                        ((Destination)object2).destMessages.enforceLimits(false);
                        ((PacketReference)object).lock();
                        ((Destination)object2).putMessage((PacketReference)object, AddReason.LOADED, true);
                        ((Destination)object2).destMessages.enforceLimits(bl);
                    }
                    catch (IllegalStateException illegalStateException) {
                        objectArray = new String[]{((PacketReference)object).getSysMessageID().toString(), ((PacketReference)object).getDestinationUID().toString(), illegalStateException.getMessage()};
                        logger.logStack(16, "B2089", objectArray, (Throwable)illegalStateException);
                    }
                    catch (OutOfLimitsException outOfLimitsException) {
                        objectArray = new String[]{((PacketReference)object).getSysMessageID().toString(), ((PacketReference)object).getDestinationUID().toString(), outOfLimitsException.getMessage()};
                        logger.logStack(16, "B2089", objectArray, (Throwable)outOfLimitsException);
                    }
                }
                ((Destination)object2).sort(new RefCompare());
            }
            catch (Exception exception) {}
        }
        Iterator iterator3 = hashMap.entrySet().iterator();
        block24: while (iterator3.hasNext()) {
            entry = iterator3.next();
            object4 = (DestinationUID)entry.getKey();
            object3 = (Set)entry.getValue();
            object2 = Destination.getDestination((DestinationUID)object4);
            iterator = object3.iterator();
            try {
                while (true) {
                    Object object6;
                    Serializable serializable;
                    Serializable serializable2;
                    if (!iterator.hasNext()) continue block24;
                    object = (PacketReference)iterator.next();
                    TransactionUID transactionUID = (TransactionUID)hashMap3.get(((PacketReference)object).getSysMessageID());
                    if (transactionUID != null) {
                        Globals.getTransactionList().addMessage(transactionUID, ((PacketReference)object).getSysMessageID(), true);
                        ((PacketReference)object).unlock();
                        continue;
                    }
                    objectArray = Globals.getStore().getConsumerUIDs((DestinationUID)object4, ((PacketReference)object).getSysMessageID());
                    if (objectArray == null) {
                        objectArray = new ConsumerUID[]{};
                    }
                    if (objectArray.length == 0 && Globals.getStore().hasMessageBeenAcked((DestinationUID)object4, ((PacketReference)object).getSysMessageID())) {
                        logger.log(8, Globals.getBrokerResources().getString("B2196", ((PacketReference)object).getSysMessageID()));
                        super.unputMessage((PacketReference)object, RemoveReason.ACKNOWLEDGED);
                        ((PacketReference)object).destroy();
                        ((PacketReference)object).unlock();
                        continue;
                    }
                    if (objectArray.length > 0) {
                        ((PacketReference)object).setStoredWithInterest(true);
                    } else {
                        ((PacketReference)object).setStoredWithInterest(false);
                    }
                    int[] nArray = null;
                    if (objectArray.length == 0) {
                        try {
                            objectArray = ((Destination)object2).routeLoadedTransactionMessage((PacketReference)object);
                        }
                        catch (Exception exception) {
                            logger.log(8, "Internal Error loading/routing transacted message, throwing out message " + ((PacketReference)object).getSysMessageID(), exception);
                        }
                        nArray = new int[objectArray.length];
                        for (int i = 0; i < nArray.length; ++i) {
                            nArray[i] = 0;
                        }
                        try {
                            Globals.getStore().storeInterestStates(((Destination)object2).getDestinationUID(), ((PacketReference)object).getSysMessageID(), (ConsumerUID[])objectArray, nArray, true, null);
                            ((PacketReference)object).setStoredWithInterest(true);
                        }
                        catch (Exception exception) {
                            serializable2 = new StringBuffer();
                            for (int i = 0; i < objectArray.length; ++i) {
                                if (i > 0) {
                                    ((StringBuffer)serializable2).append(", ");
                                }
                                ((StringBuffer)serializable2).append(objectArray[i]);
                            }
                            logger.log(16, "B2197", ((PacketReference)object).getSysMessageID(), ((StringBuffer)serializable2).toString(), exception);
                        }
                    } else {
                        nArray = new int[objectArray.length];
                        for (int i = 0; i < objectArray.length; ++i) {
                            nArray[i] = Globals.getStore().getInterestState((DestinationUID)object4, ((PacketReference)object).getSysMessageID(), (ConsumerUID)objectArray[i]);
                        }
                    }
                    ((PacketReference)object).update((ConsumerUID[])objectArray, nArray, false);
                    ExpirationInfo expirationInfo = ((PacketReference)object).getExpiration();
                    if (expirationInfo != null && ((Destination)object2).expireReaper != null) {
                        ((Destination)object2).expireReaper.addExpiringMessage(expirationInfo);
                    }
                    serializable2 = new ArrayList<Object>(Arrays.asList(objectArray));
                    Iterator iterator4 = serializable2.iterator();
                    while (iterator4.hasNext()) {
                        logger.log(4, " Message " + ((PacketReference)object).getSysMessageID() + " has " + serializable2.size() + " consumers ");
                        serializable = (ConsumerUID)iterator4.next();
                        object6 = ((PacketReference)object).getSysMessageID() + ":" + serializable;
                        TransactionList transactionList = Globals.getTransactionList();
                        TransactionUID transactionUID2 = (TransactionUID)hashMap2.get(object6);
                        if (DEBUG) {
                            logger.log(8, "loadTakeoverMsgs: lookup " + (String)object6 + " found tid=" + transactionUID2);
                        }
                        if (transactionUID2 == null) continue;
                        boolean bl = false;
                        TransactionState transactionState = transactionList.retrieveState(transactionUID2);
                        if (transactionState == null) {
                            transactionState = transactionList.getRemoteTransactionState(transactionUID2);
                            bl = true;
                        }
                        if (DEBUG) {
                            logger.log(8, "tid=" + transactionUID2 + " has state=" + TransactionState.toString(transactionState.getState()));
                        }
                        if (transactionState != null && transactionState.getState() != 7 && transactionState.getState() != 6) {
                            if (DEBUG) {
                                logger.log(8, "loadTakeoverMsgs: Open transaction ack [" + (String)object6 + "]" + (bl ? "remote" : "") + ", TUID=" + transactionUID2);
                            }
                            if (!bl) {
                                try {
                                    transactionList.addAcknowledgement(transactionUID2, ((PacketReference)object).getSysMessageID(), (ConsumerUID)serializable, (ConsumerUID)serializable, true, false);
                                }
                                catch (TransactionAckExistException transactionAckExistException) {
                                    logger.log(8, Globals.getBrokerResources().getKString("B1330", "[" + ((PacketReference)object).getSysMessageID() + "]" + serializable + ":" + serializable, transactionUID2 + "[" + TransactionState.toString(transactionState.getState()) + "]"));
                                }
                                transactionList.addOrphanAck(transactionUID2, ((PacketReference)object).getSysMessageID(), (ConsumerUID)serializable);
                            }
                            iterator4.remove();
                            logger.log(8, "Processing open ack " + ((PacketReference)object).getSysMessageID() + ":" + serializable + " on " + transactionUID2);
                            continue;
                        }
                        if (transactionState == null || transactionState.getState() != 6) continue;
                        logger.log(8, "Processing committed ack " + ((PacketReference)object).getSysMessageID() + ":" + serializable + " on " + transactionUID2);
                        if (((PacketReference)object).acknowledged((ConsumerUID)serializable, (ConsumerUID)serializable, false, true)) {
                            super.unputMessage((PacketReference)object, RemoveReason.ACKNOWLEDGED);
                            ((PacketReference)object).destroy();
                            continue;
                        }
                        iterator4.remove();
                    }
                    if (DEBUG) {
                        serializable = new StringBuffer();
                        object6 = null;
                        for (int i = 0; i < serializable2.size(); ++i) {
                            object6 = (ConsumerUID)serializable2.get(i);
                            ((StringBuffer)serializable).append(object6);
                            ((StringBuffer)serializable).append(" ");
                        }
                        logger.log(8, "non-transacted: Routing Message " + ((PacketReference)object).getSysMessageID() + " to " + serializable2.size() + " consumers:" + ((StringBuffer)serializable).toString());
                    }
                    ((PacketReference)object).unlock();
                    ((Destination)object2).routeLoadedMessage((PacketReference)object, (List)((Object)serializable2));
                    if (((Destination)object2).destReaper == null) continue;
                    ((Destination)object2).destReaper.cancel();
                    ((Destination)object2).destReaper = null;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
            break;
        }
        return;
    }

    public synchronized void load() throws BrokerException {
        this.load(false, null, null);
    }

    public synchronized void load(boolean bl) throws BrokerException {
        this.load(false, null, null, null, null, bl);
    }

    public synchronized void load(Set set) throws BrokerException {
        this.load(false, null, null, null, set, false);
    }

    protected synchronized Map load(boolean bl, Map map, Map map2) throws BrokerException {
        return this.load(bl, map, map2, null, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized LinkedHashMap load(boolean bl, Map map, Map map2, Map map3, Set set, boolean bl2) throws BrokerException {
        Object object;
        if (this.loaded) {
            return null;
        }
        this.logger.log(8, "B1151", (Object)this.toString(), String.valueOf(this.size));
        LinkedHashMap<SysMessageID, TransactionUID> linkedHashMap = null;
        boolean bl3 = true;
        HashSet<PacketReference> hashSet = new HashSet<PacketReference>();
        int n = this.size;
        int n2 = 0;
        try {
            Object object2;
            Object object3;
            ConsumerUID[] consumerUIDArray;
            Enumeration enumeration;
            bl3 = this.destMessages.getEnforceLimits();
            this.destMessages.enforceLimits(false);
            object = Globals.getStore();
            Object var13_14 = null;
            try {
                enumeration = ((Store)object).messageEnumeration(this);
            }
            catch (DestinationNotFoundException destinationNotFoundException) {
                if (bl2) {
                    this.logger.log(8, this.br.getKString("B1302", this.getName(), destinationNotFoundException.getMessage()));
                    return null;
                }
                throw destinationNotFoundException;
            }
            TreeSet<PacketReference> treeSet = null;
            try {
                HAMonitorService hAMonitorService = Globals.getHAMonitorService();
                boolean bl4 = set == null && Globals.getHAEnabled() && hAMonitorService != null && hAMonitorService.checkTakingoverDestination(this);
                treeSet = new TreeSet<PacketReference>(new RefCompare());
                while (enumeration.hasMoreElements()) {
                    PacketReference packetReference;
                    block60: {
                        consumerUIDArray = (ConsumerUID[])enumeration.nextElement();
                        packetReference = PacketReference.createReference((Packet)consumerUIDArray, this.uid, null);
                        if (set != null && set.contains(packetReference)) {
                            packetReference = null;
                            continue;
                        }
                        if (bl4 && hAMonitorService.checkTakingoverMessage((Packet)consumerUIDArray)) {
                            packetReference = null;
                            continue;
                        }
                        if (bl) {
                            packetReference.overrideExpireTime(0L);
                        }
                        packetReference.setLoaded();
                        if (DEBUG) {
                            this.logger.log(8, "Loaded Message " + consumerUIDArray + " into destination " + this);
                        }
                        try {
                            if (this.isDMQ || Destination.addNewMessage(false, packetReference)) break block60;
                            hashSet.add(packetReference);
                        }
                        catch (Exception exception) {
                            Object[] objectArray = new String[]{packetReference.getSysMessageID().toString(), packetReference.getDestinationUID().toString(), exception.getMessage()};
                            this.logger.logStack(16, "B2089", objectArray, (Throwable)exception);
                            continue;
                        }
                    }
                    treeSet.add(packetReference);
                    Destination.packetlistAdd(packetReference.getSysMessageID(), packetReference.getDestinationUID());
                    if (++n2 <= 0 || n2 % LOAD_COUNT != 0 && (n2 <= LOAD_COUNT || n2 != this.size)) continue;
                    object3 = new String[]{this.toString(), String.valueOf(n2), String.valueOf(n), String.valueOf(n2 * 100 / n)};
                    this.logger.log(8, "B1153", (Object[])object3);
                }
                object2 = null;
                ((Store)object).closeEnumeration(enumeration);
            }
            catch (Throwable throwable) {
                Object var22_39 = null;
                ((Store)object).closeEnumeration(enumeration);
                throw throwable;
            }
            for (PacketReference packetReference : treeSet) {
                consumerUIDArray = ((Store)object).getConsumerUIDs(this.getDestinationUID(), packetReference.getSysMessageID());
                if (consumerUIDArray == null) {
                    consumerUIDArray = new ConsumerUID[]{};
                }
                if (consumerUIDArray.length == 0 && ((Store)object).hasMessageBeenAcked(this.uid, packetReference.getSysMessageID())) {
                    if (DEBUG) {
                        this.logger.log(8, "Message " + packetReference.getSysMessageID() + "[" + this + "] has been acked, destory..");
                    }
                    packetReference.destroy();
                    continue;
                }
                if (consumerUIDArray.length > 0) {
                    packetReference.setStoredWithInterest(true);
                } else {
                    packetReference.setStoredWithInterest(false);
                }
                boolean bl5 = false;
                if (packetReference.getTransactionID() != null) {
                    object3 = map2 == null ? null : map2.get(packetReference.getTransactionID());
                    if (object3 == null) {
                        if (consumerUIDArray.length == 0) {
                            try {
                                consumerUIDArray = this.routeLoadedTransactionMessage(packetReference);
                            }
                            catch (Exception exception) {
                                this.logger.log(8, "Internal Error loading/routing transacted message, throwing out message " + packetReference.getSysMessageID(), exception);
                            }
                            if (consumerUIDArray.length > 0) {
                                int[] nArray = new int[consumerUIDArray.length];
                                for (int i = 0; i < nArray.length; ++i) {
                                    nArray[i] = 0;
                                }
                                try {
                                    Globals.getStore().storeInterestStates(this.getDestinationUID(), packetReference.getSysMessageID(), consumerUIDArray, nArray, true, null);
                                    packetReference.setStoredWithInterest(true);
                                }
                                catch (Exception exception) {}
                            } else {
                                if (DEBUG) {
                                    this.logger.log(8, "Message " + packetReference.getSysMessageID() + " [TUID=" + packetReference.getTransactionID() + ", " + this + "] no interest" + ", destroy...");
                                }
                                packetReference.destroy();
                                continue;
                            }
                        }
                    } else if (object3 == Boolean.TRUE) {
                        if (linkedHashMap == null) {
                            linkedHashMap = new LinkedHashMap<SysMessageID, TransactionUID>();
                        }
                        linkedHashMap.put(packetReference.getSysMessageID(), packetReference.getTransactionID());
                        bl5 = true;
                    } else {
                        if (DEBUG) {
                            this.logger.log(8, "Message " + packetReference.getSysMessageID() + " [TUID=" + packetReference.getTransactionID() + ", " + this + "] to be rolled back" + ", destroy...");
                        }
                        packetReference.destroy();
                        continue;
                    }
                }
                if (consumerUIDArray.length == 0 && !bl5) {
                    this.logger.log(4, "Unrouted packet " + packetReference + ", " + this);
                    object3 = this;
                    synchronized (object3) {
                        --this.size;
                        long l = packetReference.byteSize();
                        this.bytes -= l;
                        if (!(this.isAdmin() || !this.getIsDMQ() && this.isInternal())) {
                            object2 = this.getClass();
                            synchronized (object2) {
                                totalbytes -= l;
                                --totalcnt;
                            }
                        }
                    }
                    packetReference.destroy();
                    continue;
                }
                object3 = new int[consumerUIDArray.length];
                for (int i = 0; i < consumerUIDArray.length; ++i) {
                    object3[i] = ((Store)object).getInterestState(this.getDestinationUID(), packetReference.getSysMessageID(), consumerUIDArray[i]);
                }
                if (consumerUIDArray.length > 0) {
                    packetReference.update(consumerUIDArray, (int[])object3);
                }
                try {
                    this.putMessage(packetReference, AddReason.LOADED);
                }
                catch (IllegalStateException illegalStateException) {
                    Object[] objectArray = new String[]{packetReference.getSysMessageID().toString(), packetReference.getDestinationUID().toString(), illegalStateException.getMessage()};
                    this.logger.logStack(16, "B2089", objectArray, (Throwable)illegalStateException);
                    continue;
                }
                catch (OutOfLimitsException outOfLimitsException) {
                    Object[] objectArray = new String[]{packetReference.getSysMessageID().toString(), packetReference.getDestinationUID().toString(), outOfLimitsException.getMessage()};
                    this.logger.logStack(16, "B2089", objectArray, (Throwable)outOfLimitsException);
                    continue;
                }
                ExpirationInfo expirationInfo = packetReference.getExpiration();
                if (expirationInfo != null && this.expireReaper != null) {
                    this.expireReaper.addExpiringMessage(expirationInfo);
                }
                List<ConsumerUID> list = Arrays.asList(consumerUIDArray);
                object2 = map == null ? null : map.get(packetReference.getSysMessageID());
                if (object2 != null) {
                    list = new ArrayList<ConsumerUID>(list);
                    Iterator<ConsumerUID> iterator = list.iterator();
                    while (iterator.hasNext()) {
                        ConsumerUID consumerUID = iterator.next();
                        TransactionUID transactionUID = (TransactionUID)object2.get(consumerUID);
                        Boolean bl6 = map2 == null ? null : map2.get(transactionUID);
                        if (bl6 == null) {
                            if (packetReference.acknowledged(consumerUID, consumerUID, false, true)) {
                                if (map3 != null && map3.get(transactionUID) != null) {
                                    this.unputMessage(packetReference, RemoveReason.ACKNOWLEDGED);
                                }
                                packetReference.destroy();
                                continue;
                            }
                            iterator.remove();
                            continue;
                        }
                        if (bl6 == Boolean.TRUE) {
                            iterator.remove();
                            continue;
                        }
                        if (bl6 != Boolean.FALSE || !DEBUG) continue;
                        this.logger.log(8, "Redeliver message " + packetReference.getSysMessageID() + " [TUID=" + transactionUID + ", " + this + "]" + " to consumer " + consumerUID);
                    }
                }
                this.loaded = true;
                if (bl5) continue;
                this.routeLoadedMessage(packetReference, list);
            }
        }
        catch (Throwable throwable) {
            this.logger.logStack(32, "B2085", this.getName(), throwable);
            this.unload(true);
        }
        this.destMessages.enforceLimits(bl3);
        this.loaded = true;
        object = hashSet.iterator();
        while (true) {
            if (!object.hasNext()) {
                this.logger.log(8, "B1152", (Object)this.toString(), String.valueOf(this.size));
                return linkedHashMap;
            }
            PacketReference packetReference = (PacketReference)object.next();
            try {
                if (linkedHashMap != null) {
                    linkedHashMap.remove(packetReference.getSysMessageID());
                }
                this.removeMessage(packetReference.getSysMessageID(), RemoveReason.EXPIRED);
            }
            catch (Exception exception) {
                this.logger.logStack(8, "B3100", "Processing " + packetReference + " while loading destination " + this, (Throwable)exception);
                continue;
            }
            break;
        }
    }

    protected void routeLoadedMessage(PacketReference packetReference, List list) throws BrokerException, SelectorFormatException {
        if (list == null || list.size() == 0) {
            return;
        }
        for (ConsumerUID consumerUID : list) {
            Object object;
            if (consumerUID == PacketReference.getQueueUID()) {
                object = this.routeNewMessage(packetReference);
                this.forwardMessage((Set)object, packetReference);
                continue;
            }
            object = (Consumer)this.consumers.get(consumerUID);
            if (object == null) {
                Set set = this.routeNewMessage(packetReference);
                this.forwardMessage(set, packetReference);
                continue;
            }
            ((Consumer)object).routeMessage(packetReference, false);
        }
    }

    protected Consumer getConsumer(ConsumerUID consumerUID) {
        return (Consumer)this.consumers.get(consumerUID);
    }

    public void unload(boolean bl) {
        if (DEBUG) {
            this.logger.log(4, "Unloading " + this);
        }
        if (!this.loaded) {
            return;
        }
        this.bytes = this.destMessages.byteSize();
        this.size = this.destMessages.size();
        Map map = this.destMessages.getAll(this.unloadfilter);
        try {
            if (bl) {
                for (PacketReference packetReference : map.values()) {
                    this.destMessages.remove((Object)packetReference.getSysMessageID(), RemoveReason.UNLOADED);
                    packetReference.clear();
                }
                this.destMessages = new SimpleNFLHashMap();
                this.remoteSize = 0;
                this.remoteBytes = 0L;
                this.loaded = false;
                this.initialize();
            } else {
                for (PacketReference packetReference : this.destMessages.values()) {
                    packetReference.unload();
                }
            }
        }
        catch (Throwable throwable) {
            this.logger.logStack(16, "B3100", "Unloading destination " + this, throwable);
            this.destMessages = new SimpleNFLHashMap();
            this.remoteSize = 0;
            this.remoteBytes = 0L;
            this.loaded = false;
            this.initialize();
        }
    }

    public void sync() throws BrokerException {
        Globals.getStore().syncDestination(this);
    }

    protected void destroy(String string) throws IOException, BrokerException {
        this.destroy(string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroy(String string, boolean bl) throws IOException, BrokerException {
        Object object = destinationList;
        synchronized (object) {
            this.destvalid = false;
        }
        object = this;
        synchronized (object) {
            if (this.destReaper != null) {
                this.destReaper.cancel();
                this.destReaper = null;
            }
            if (this.reconnectReaper != null) {
                this.reconnectReaper.cancel();
                this.reconnectReaper = null;
            }
            if (this.expireReaper != null) {
                this.expireReaper.destroy();
                this.expireReaper = null;
            }
            if (!this.neverStore || this.stored) {
                this.purgeDestination(bl);
                try {
                    Globals.getStore().removeDestination(this, PERSIST_SYNC);
                }
                catch (DestinationNotFoundException destinationNotFoundException) {
                    if (!bl) {
                        throw destinationNotFoundException;
                    }
                    this.logger.log(8, this.br.getKString("B1304", this.getName(), destinationNotFoundException.getMessage()));
                }
                this.stored = false;
            }
        }
    }

    public String toString() {
        return this.uid.getLocalizedName();
    }

    public String getUniqueName() {
        return this.uid.toString();
    }

    public static String getUniqueName(boolean bl, String string) {
        return DestinationUID.getUniqueString(string, bl);
    }

    public void eventOccured(EventType eventType, Reason reason, Object object, Object object2, Object object3, Object object4) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _messageAdded(long l, Reason reason, boolean bl, boolean bl2) {
        if (reason == AddReason.LOADED) {
            if (!bl && bl2) {
                Destination destination = this;
                synchronized (destination) {
                    --this.remoteSize;
                    this.remoteBytes -= l;
                    --this.size;
                    this.bytes -= l;
                    Class<?> clazz = this.getClass();
                    synchronized (clazz) {
                        totalbytes -= l;
                        --totalcnt;
                    }
                }
            }
            return;
        }
        Destination destination = this;
        synchronized (destination) {
            ++this.size;
            this.bytes += l;
            if (bl) {
                ++this.remoteSize;
                this.remoteBytes += l;
            }
            if (!(this.isAdmin() || !this.getIsDMQ() && this.isInternal())) {
                Class<?> clazz = this.getClass();
                synchronized (clazz) {
                    totalbytes += l;
                    ++totalcnt;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void packetlistAdd(SysMessageID sysMessageID, DestinationUID destinationUID) {
        Class<?> clazz = packetlist.getClass();
        synchronized (clazz) {
            Set<DestinationUID> set = (Set<DestinationUID>)packetlist.get(sysMessageID);
            if (set == null) {
                set = Collections.synchronizedSet(new LinkedHashSet());
                packetlist.put(sysMessageID, set);
            }
            set.add(destinationUID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DestinationUID getPacketListFirst(SysMessageID sysMessageID) {
        Set set = null;
        Object object = packetlist.getClass();
        synchronized (object) {
            set = (Set)packetlist.get(sysMessageID);
            if (set == null) {
                return null;
            }
        }
        object = set;
        synchronized (object) {
            Iterator iterator = set.iterator();
            if (iterator.hasNext()) {
                return (DestinationUID)iterator.next();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object removePacketList(SysMessageID sysMessageID, DestinationUID destinationUID) {
        Class<?> clazz = packetlist.getClass();
        synchronized (clazz) {
            Set set = (Set)packetlist.get(sysMessageID);
            if (set == null) {
                return null;
            }
            if (set.contains(destinationUID)) {
                set.remove(destinationUID);
                if (set.isEmpty()) {
                    packetlist.remove(sysMessageID);
                }
                return destinationUID;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _messageRemoved(PacketReference packetReference, long l, Reason reason, boolean bl) {
        if (packetReference == null) {
            return;
        }
        Destination.removePacketList(packetReference.getSysMessageID(), this.getDestinationUID());
        if (!bl) {
            return;
        }
        boolean bl2 = false;
        Destination destination = this;
        synchronized (destination) {
            if (reason == RemoveReason.REMOVED_LOW_PRIORITY || reason == RemoveReason.REMOVED_OLDEST || reason == RemoveReason.REMOVED_OTHER) {
                ++this.discardedCnt;
            } else if (reason == RemoveReason.EXPIRED) {
                ++this.expiredCnt;
            } else if (reason == RemoveReason.PURGED) {
                ++this.purgedCnt;
            } else if (reason == RemoveReason.ROLLBACK) {
                ++this.rollbackCnt;
                bl2 = true;
            } else if (reason == RemoveReason.ACKNOWLEDGED) {
                ++this.ackedCnt;
            } else if (reason == RemoveReason.OVERFLOW) {
                ++this.overflowCnt;
            } else if (reason == RemoveReason.ERROR) {
                ++this.errorCnt;
            }
            this.bytes -= l;
            --this.size;
            if (!packetReference.isLocal()) {
                --this.remoteSize;
                this.remoteBytes -= l;
            }
            if (!(this.isAdmin() || !this.getIsDMQ() && this.isInternal())) {
                Class<?> clazz = this.getClass();
                synchronized (clazz) {
                    totalbytes -= l;
                    --totalcnt;
                    if (!packetReference.isPersistent() && !this.getIsDMQ()) {
                        --totalcntNonPersist;
                    }
                }
            }
        }
        packetReference.remove(bl2);
        this.producerFlow.checkResumeFlow(null, true);
    }

    public boolean shouldDestroy() {
        HAMonitorService hAMonitorService;
        if (Globals.getHAEnabled() && (hAMonitorService = Globals.getHAMonitorService()) != null && hAMonitorService.checkTakingoverDestination(this)) {
            this.logger.log(4, "B4087", (Object)this.getUniqueName(), "destination is being taken over");
            return false;
        }
        return this.size() == 0 && this.isAutoCreated() && !this.isTemporary() && this.producers.isEmpty() && this.consumers.isEmpty();
    }

    public void overridePersistence(boolean bl) {
        this.neverStore = !bl;
        this.overrideP = true;
        this.overridePvalue = bl;
    }

    public void clearOverridePersistence() {
        this.overrideP = false;
    }

    public void overrideTTL(long l) {
        this.overrideTTL = true;
        this.overrideTTLvalue = l;
    }

    public void clearOverrideTTL() {
        this.overrideTTL = false;
    }

    public boolean shouldOverridePersistence() {
        return this.overrideP;
    }

    public boolean getOverridePersistence() {
        return this.overridePvalue;
    }

    public boolean shouldOverrideTTL() {
        return this.overrideTTL;
    }

    public long getOverrideTTL() {
        return this.overrideTTLvalue;
    }

    public boolean isInternal() {
        boolean bl = DestType.isInternal(this.type);
        return bl;
    }

    public boolean isDMQ() {
        boolean bl = DestType.isDMQ(this.type);
        return bl;
    }

    public boolean isAdmin() {
        boolean bl = DestType.isAdmin(this.type);
        return bl;
    }

    public int getConsumerCount() {
        return this.consumers.size();
    }

    public Iterator getConsumers() {
        ArrayList arrayList = new ArrayList(this.consumers.values());
        return arrayList.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAllActiveConsumers() {
        ArrayList<Consumer> arrayList = new ArrayList<Consumer>();
        SimpleNFLHashMap simpleNFLHashMap = this.consumers;
        synchronized (simpleNFLHashMap) {
            Iterator iterator = this.consumers.values().iterator();
            Consumer consumer = null;
            while (iterator.hasNext()) {
                consumer = (Consumer)iterator.next();
                if (consumer instanceof Subscription) {
                    arrayList.addAll(((Subscription)consumer).getChildConsumers());
                    continue;
                }
                arrayList.add(consumer);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getProducers() {
        ArrayList arrayList = null;
        SimpleNFLHashMap simpleNFLHashMap = this.producers;
        synchronized (simpleNFLHashMap) {
            arrayList = new ArrayList(this.producers.values());
        }
        return arrayList.iterator();
    }

    public int getProducerCount() {
        return this.producers.size();
    }

    public int getMaxPrefetch() {
        return this.maxPrefetch;
    }

    public void setMaxPrefetch(int n) {
        Long l = new Long(this.maxPrefetch);
        this.maxPrefetch = n;
        this.notifyAttrUpdated(128, l, new Long(this.maxPrefetch));
    }

    public void setMaxSharedConsumers(int n) {
    }

    public void setSharedFlowLimit(int n) {
    }

    public int getMaxNumSharedConsumers() {
        return -1;
    }

    public int getSharedConsumerFlowLimit() {
        return 5;
    }

    public long getMsgBytesProducerFlow() {
        if (NO_PRODUCER_FLOW) {
            return -1L;
        }
        long l = 0L;
        l = this.msgSizeLimit == null || this.msgSizeLimit.getBytes() <= 0L ? -1L : this.msgSizeLimit.getBytes();
        return l;
    }

    public long getBytesProducerFlow() {
        if (NO_PRODUCER_FLOW) {
            return -1L;
        }
        return this.producerMsgBatchBytes;
    }

    public int getSizeProducerFlow() {
        if (NO_PRODUCER_FLOW) {
            return -1;
        }
        return this.producerMsgBatchSize;
    }

    public void forceResumeFlow(Producer producer) {
        this.producerFlow.pauseProducer(producer);
        this.producerFlow.forceResumeFlow(producer);
    }

    public boolean producerFlow(IMQConnection iMQConnection, Producer producer) {
        this.producerFlow.pauseProducer(producer);
        boolean bl = this.producerFlow.checkResumeFlow(producer, true);
        this.logger.log(1, "producerFlow " + producer + " resumed: " + bl);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List findMatchingIDs(DestinationUID destinationUID) {
        ArrayList<DestinationUID> arrayList = new ArrayList<DestinationUID>();
        if (!destinationUID.isWildcard()) {
            arrayList.add(destinationUID);
            return arrayList;
        }
        Map map = destinationList;
        synchronized (map) {
            for (DestinationUID destinationUID2 : destinationList.keySet()) {
                if (!DestinationUID.match(destinationUID2, destinationUID)) continue;
                arrayList.add(destinationUID2);
            }
        }
        return arrayList;
    }

    public static void clearDestinations() {
        destsLoaded = false;
        destinationList.clear();
        packetlist.clear();
        Queue.clear();
        inited = false;
        BrokerConfig brokerConfig = Globals.getConfig();
        brokerConfig.removeListener(SYSTEM_MAX_SIZE, cl);
        brokerConfig.removeListener(SYSTEM_MAX_COUNT, cl);
        brokerConfig.removeListener(MAX_MESSAGE_SIZE, cl);
        brokerConfig.removeListener(AUTO_QUEUE_STR, cl);
        brokerConfig.removeListener(AUTO_TOPIC_STR, cl);
        brokerConfig.removeListener(DST_REAP_STR, cl);
        brokerConfig.removeListener(MSG_REAP_STR, cl);
        brokerConfig.removeListener(AUTO_MAX_NUM_MSGS, cl);
        brokerConfig.removeListener(AUTO_MAX_TOTAL_BYTES, cl);
        brokerConfig.removeListener(AUTO_MAX_BYTES_MSG, cl);
        brokerConfig.removeListener(AUTO_MAX_NUM_PRODUCERS, cl);
        brokerConfig.removeListener(AUTO_LOCAL_ONLY, cl);
        brokerConfig.removeListener(AUTO_LIMIT_BEHAVIOR, cl);
        brokerConfig.removeListener(USE_DMQ_STR, cl);
        brokerConfig.removeListener(TRUNCATE_BODY_STR, cl);
        brokerConfig.removeListener(LOG_MSGS_STR, cl);
        cl = null;
    }

    public static void addDestination(Destination destination) {
        Destination.addDestination(destination, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDestination(Destination destination, boolean bl) {
        Map map = destinationList;
        synchronized (map) {
            if (destinationList.get(destination.getDestinationUID()) != null) {
                if (bl) {
                    throw new RuntimeException("Destination " + destination + " is also being" + " created by another broker");
                }
                return;
            }
            destinationList.put(destination.getDestinationUID(), destination);
            Agent agent = Globals.getAgent();
            if (agent != null) {
                agent.registerDestination(destination);
                agent.notifyDestinationCreate(destination);
            }
        }
    }

    public static int destinationsSize() {
        return destinationList.size();
    }

    public static LinkedHashMap processTransactions(Map map, Map map2, Map map3) throws BrokerException {
        Destination.loadDestinations();
        Subscription.initSubscriptions();
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        Iterator iterator = Destination.getAllDestinations();
        while (iterator.hasNext()) {
            LinkedHashMap linkedHashMap2;
            Destination destination = (Destination)iterator.next();
            boolean bl = destination.loaded;
            if (bl) {
                destination.unload(true);
            }
            if ((linkedHashMap2 = destination.load(false, map, map2, map3, null, false)) == null) continue;
            linkedHashMap.putAll(linkedHashMap2);
        }
        return linkedHashMap;
    }

    public static void loadDestinations() throws BrokerException {
        Destination destination;
        Object object;
        if (destsLoaded) {
            return;
        }
        Logger logger = Globals.getLogger();
        destsLoaded = true;
        if (defaultIsLocal && !CAN_USE_LOCAL_DEST) {
            Globals.getLogger().log(32, "B3123", Globals.getBrokerResources().getString("B0049"));
            Broker.getBroker().exit(1, Globals.getBrokerResources().getKString("B3123", Globals.getBrokerResources().getString("B0049")), BrokerEvent.Type.FATAL_ERROR);
        }
        if (Destination.canAutoCreate(true)) {
            logger.log(8, "B1013");
        }
        if (!Destination.canAutoCreate(false)) {
            logger.log(8, "B1014");
        }
        logger.log(4, "Loading All Stored Destinations ");
        Destination[] destinationArray = Globals.getStore().getLoadDestinationException();
        if (destinationArray != null) {
            object = destinationArray;
            while (object != null) {
                String string = (String)object.getKey();
                destination = (Destination)object.getValue();
                if (string == null && destination == null) {
                    logger.log(16, "B3044", "both key and value are corrupted");
                    continue;
                }
                if (string == null) {
                    try {
                        Globals.getStore().storeDestination(destination, PERSIST_SYNC);
                    }
                    catch (Exception exception) {
                        logger.log(16, "B2091", (Object)destination.toString(), (Throwable)exception);
                        try {
                            Globals.getStore().removeDestination(destination, true);
                        }
                        catch (Exception exception2) {
                            logger.logStack(4, "Unable to remove dest", exception2);
                        }
                    }
                } else {
                    DestinationUID destinationUID = new DestinationUID(string);
                    String string2 = destinationUID.getName();
                    boolean bl = destinationUID.isQueue();
                    int n = bl ? 1 : 2;
                    try {
                        destination = Destination.createDestination(string2, n);
                        destination.store();
                        logger.log(16, "B2092", destinationUID.getLocalizedName());
                    }
                    catch (Exception exception) {
                        logger.log(16, "B2093", (Object)destinationUID, (Throwable)exception);
                        try {
                            destination = destinationUID.isQueue() ? new Queue(destinationUID) : new Topic(destinationUID);
                            Globals.getStore().removeDestination(destination, true);
                        }
                        catch (Exception exception3) {
                            logger.logStack(4, "Unable to remove dest", exception3);
                        }
                    }
                }
                object = object.getNextException();
            }
        }
        try {
            try {
                object = Globals.getStore().getAllDestinations();
                if (DEBUG) {
                    logger.log(4, "Loaded {0} stored destinations", String.valueOf(((Destination[])object).length));
                }
                for (int i = 0; i < ((Destination[])object).length; ++i) {
                    if (object[i] == null) continue;
                    if (DEBUG) {
                        logger.log(8, "Destination: Loading destination {0}", object[i].toString());
                    }
                    if (!(object[i].isAdmin() || !object[i].getIsDMQ() && object[i].isInternal())) {
                        object[i].initialize();
                    }
                    if (object[i].isAutoCreated() && object[i].size == 0 && object[i].bytes == 0L) {
                        destinationList.remove(object[i].getDestinationUID());
                        try {
                            Globals.getLogger().log(8, "B1159", object[i].getName());
                            object[i].destroy(Globals.getBrokerResources().getString("B0069"));
                            continue;
                        }
                        catch (BrokerException brokerException) {
                            if (brokerException.getStatusCode() == 404) {
                                Object var12_19 = null;
                                return;
                            }
                            throw brokerException;
                        }
                    }
                    Destination.addDestination(object[i], false);
                }
                deadMessageQueue = Destination.createDMQ();
                Iterator iterator = destinationList.values().iterator();
                while (iterator.hasNext()) {
                    destination = (Destination)iterator.next();
                    try {
                        destination.initMonitor();
                    }
                    catch (IOException iOException) {
                        logger.logStack(8, "B1195", destination.toString(), (Throwable)iOException);
                        iterator.remove();
                    }
                }
                Object var12_20 = null;
            }
            catch (BrokerException brokerException) {
                logger.logStack(32, "B3100", "unable to load destinations", (Throwable)brokerException);
                throw brokerException;
            }
            catch (IOException iOException) {
                logger.logStack(32, "B3100", "unable to load destinations", (Throwable)iOException);
                throw new BrokerException("B4031", iOException);
            }
        }
        catch (Throwable throwable) {
            Object var12_21 = null;
            throw throwable;
        }
    }

    public boolean isValid() {
        return valid && this.destvalid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementRefCount() throws BrokerException {
        Map map = destinationList;
        synchronized (map) {
            if (!valid) {
                throw new IllegalStateException("Broker Shutting down");
            }
            if (!this.isValid()) {
                throw new BrokerException("Destination already destroyed");
            }
            ++this.refCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void decrementRefCount() {
        Map map = destinationList;
        synchronized (map) {
            --this.refCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRefCount() {
        Map map = destinationList;
        synchronized (map) {
            return this.refCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Destination getLoadedDestination(DestinationUID destinationUID) {
        Destination destination = null;
        Map map = destinationList;
        synchronized (map) {
            destination = (Destination)destinationList.get(destinationUID);
        }
        if (destination != null && !destination.dest_inited) {
            destination.initialize();
        }
        return destination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Destination getDestination(DestinationUID destinationUID) {
        Destination destination = null;
        Map map = destinationList;
        synchronized (map) {
            destination = (Destination)destinationList.get(destinationUID);
            if (destination == null) {
                try {
                    Store store = Globals.getStore();
                    destination = store.getDestination(destinationUID);
                    if (destination != null) {
                        Destination.addDestination(destination, false);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (destination != null && !destination.dest_inited) {
            destination.initialize();
        }
        return destination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Destination findDestination(DestinationUID destinationUID) {
        Destination destination = null;
        Map map = destinationList;
        synchronized (map) {
            destination = (Destination)destinationList.get(destinationUID);
        }
        return destination;
    }

    public static Destination getDestination(String string, boolean bl) throws BrokerException, IOException {
        DestinationUID destinationUID = new DestinationUID(string, bl);
        return Destination.getDestination(destinationUID);
    }

    public static Destination findDestination(String string, boolean bl) throws BrokerException, IOException {
        DestinationUID destinationUID = new DestinationUID(string, bl);
        return Destination.findDestination(destinationUID);
    }

    public static Destination getLoadedDestination(String string, boolean bl) throws BrokerException, IOException {
        DestinationUID destinationUID = new DestinationUID(string, bl);
        return Destination.getLoadedDestination(destinationUID);
    }

    public static Destination getDestination(String string, int n, boolean bl, boolean bl2) throws BrokerException, IOException {
        DestinationUID destinationUID = new DestinationUID(string, DestType.isQueue(n));
        return Destination.getDestination(destinationUID, n, bl, bl2);
    }

    public static Destination getDestination(DestinationUID destinationUID, int n, boolean bl, boolean bl2) throws BrokerException, IOException {
        Destination destination = (Destination)destinationList.get(destinationUID);
        if (bl && destination == null) {
            try {
                destination = Destination.createDestination(destinationUID.getName(), n, bl2, true, null);
            }
            catch (ConflictException conflictException) {
                destination = (Destination)destinationList.get(destinationUID);
            }
        }
        if (destination != null && !destination.dest_inited) {
            destination.initialize();
        }
        return destination;
    }

    public static Destination createDestination(String string, int n) throws BrokerException, IOException {
        Destination destination = Destination.createDestination(string, n, true, false, null, true, false);
        if (destination != null && !destination.dest_inited) {
            destination.initialize();
        }
        return destination;
    }

    public static Destination createTempDestination(String string, int n, ConnectionUID connectionUID, boolean bl, long l) throws BrokerException, IOException {
        Destination destination = null;
        try {
            destination = Destination.createDestination(string, n, false, false, connectionUID);
            destination.setReconnectInterval(l);
            destination.overridePersistence(bl);
            destination.store();
        }
        catch (ConflictException conflictException) {
            destination = Destination.getDestination(string, n, false, false);
        }
        return destination;
    }

    public static void shutdown() {
        valid = false;
    }

    public static boolean isShutdown() {
        return valid;
    }

    public static Destination createDestination(String string, int n, boolean bl, boolean bl2, Object object) throws BrokerException, IOException {
        ConnectionUID connectionUID = null;
        boolean bl3 = false;
        if (object instanceof ConnectionUID) {
            connectionUID = (ConnectionUID)object;
        }
        if (object instanceof BrokerAddress) {
            bl3 = ((BrokerAddress)object).equals(Globals.getMyAddress());
        }
        return Destination.createDestination(string, n, bl, bl2, connectionUID, !bl3, CAN_USE_LOCAL_DEST && DestType.isLocal(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Destination createDestination(String string, int n, boolean bl, boolean bl2, ConnectionUID connectionUID, boolean bl3, boolean bl4) throws BrokerException, IOException {
        DestinationUID destinationUID;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Store store;
        DestinationUID destinationUID2 = new DestinationUID(string, DestType.isQueue(n));
        if (!valid) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4140"), "B4140", null, 500);
        }
        if (destinationList.get(destinationUID2) != null) {
            throw new ConflictException(Globals.getBrokerResources().getKString("B4063", destinationUID2));
        }
        try {
            store = Globals.getStore();
            object4 = store.getDestination(destinationUID2);
            if (object4 != null) {
                Destination.addDestination((Destination)object4, false);
                return object4;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        store = null;
        object4 = Globals.getClusterBroadcast();
        boolean bl5 = false;
        Destination destination = null;
        try {
            destination = DestType.isQueue(n) ? new Queue(string, n, bl, connectionUID, bl2) : new Topic(string, n, bl, connectionUID, bl2);
            super.setClusterNotifyFlag(bl3);
            try {
                object3 = destinationList;
                synchronized (object3) {
                    object2 = (Destination)destinationList.get(destinationUID2);
                    if (object2 != null) {
                        throw new BrokerException("Destination already exists");
                    }
                    if (!bl2) {
                        destination.setIsLocal(bl4);
                    }
                    if (bl) {
                        destination.store();
                    }
                    destinationList.put(destinationUID2, destination);
                }
            }
            catch (BrokerException brokerException) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B4063", destination.getName()), "B4063", brokerException, 409);
            }
            boolean bl6 = bl5 = !destination.isAutoCreated() && destination.sendClusterUpdate() && bl3;
            if (object4 != null && bl5 && !object4.lockDestination(destinationUID2, connectionUID)) {
                throw new ConflictException("Internal Exception: Destination " + destinationUID2 + " is in the process" + " of being created");
            }
            if (bl5 && object4 != null) {
                object4.createDestination(destination);
            }
            Object var16_18 = null;
            if (object4 != null && bl5) {
                object4.unlockDestination(destinationUID2, connectionUID);
            }
        }
        catch (Throwable throwable) {
            Object var16_19 = null;
            if (object4 != null && bl5) {
                object4.unlockDestination(destinationUID2, connectionUID);
            }
            throw throwable;
        }
        object3 = Consumer.getWildcardConsumers();
        while (object3.hasNext()) {
            object2 = (ConsumerUID)object3.next();
            object = Consumer.getConsumer((ConsumerUID)object2);
            if (object == null) {
                Globals.getLogger().log(8, "Consumer already destroyed");
                continue;
            }
            destinationUID = ((Consumer)object).getDestinationUID();
            if (!DestinationUID.match(destination.getDestinationUID(), destinationUID)) continue;
            try {
                if (((Consumer)object).getSubscription() != null) {
                    destination.addConsumer(((Consumer)object).getSubscription(), false);
                    continue;
                }
                destination.addConsumer((Consumer)object, false);
            }
            catch (SelectorFormatException selectorFormatException) {}
        }
        object3 = Producer.getWildcardProducers();
        while (object3.hasNext()) {
            object2 = (ProducerUID)object3.next();
            object = Producer.getProducer((ProducerUID)object2);
            destinationUID = ((Producer)object).getDestinationUID();
            if (!DestinationUID.match(destination.getDestinationUID(), destinationUID)) continue;
            destination.addProducer((Producer)object);
        }
        object2 = Globals.getAgent();
        if (object2 != null) {
            ((Agent)object2).registerDestination(destination);
            ((Agent)object2).notifyDestinationCreate(destination);
        }
        return destination;
    }

    private void setClusterNotifyFlag(boolean bl) {
        this.clusterNotifyFlag = bl;
    }

    private boolean getClusterNotifyFlag() {
        return this.clusterNotifyFlag;
    }

    public static Destination removeDestination(String string, boolean bl, String string2) throws IOException, BrokerException {
        DestinationUID destinationUID = new DestinationUID(string, bl);
        return Destination.removeDestination(destinationUID, true, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Destination removeDestination(DestinationUID destinationUID, boolean bl, String string) throws IOException, BrokerException {
        boolean bl2;
        Destination destination = null;
        boolean bl3 = bl2 = Globals.getHAEnabled() && !bl;
        if (bl2) {
            destination = Destination.findDestination(destinationUID);
            if (destination != null && !destination.isTemporary()) {
                destination = Destination.getDestination(destinationUID);
            }
        } else {
            destination = Destination.getDestination(destinationUID);
        }
        if (destination != null) {
            if (destination.isDMQ) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B4193"));
            }
            if (bl && destination.sendClusterUpdate() && !destination.isTemporary()) {
                Globals.getClusterBroadcast().recordRemoveDestination(destination);
            }
            int n = DestType.isAdmin(destination.getType()) ? 4 : 8;
            Globals.getLogger().log(n, "B1159", destination.getName());
        }
        try {
            destination = (Destination)destinationList.get(destinationUID);
            DestinationUID.clearUID(destinationUID);
            if (destination != null) {
                Agent agent;
                if (destination.producers.size() > 0) {
                    Object[] objectArray = new String[]{destination.getName(), String.valueOf(destination.producers.size()), string};
                    Globals.getLogger().log(16, "B2081", objectArray);
                }
                if (destination.consumers.size() > 0) {
                    int n = destination.consumers.size();
                    boolean bl4 = false;
                    HashSet hashSet = new HashSet(destination.consumers.values());
                    for (Object[] objectArray : hashSet) {
                        if (!(objectArray instanceof Subscription) || !((Subscription)objectArray).isDurable()) continue;
                        bl4 = true;
                        Subscription subscription = (Subscription)objectArray;
                        if (subscription.isActive()) {
                            n += subscription.getActiveSubscriberCnt();
                        }
                        Subscription.unsubscribeOnDestroy(subscription.getDurableName(), subscription.getClientID(), bl);
                        --n;
                    }
                    if (bl4) {
                        Globals.getLogger().log(8, "B1131", (Object)destination.toString(), string);
                    }
                    if (n > 0) {
                        Object[] objectArray;
                        objectArray = new String[]{destination.getName(), String.valueOf(n), string};
                        Globals.getLogger().log(16, "B2082", objectArray);
                    }
                }
                if (destination.size() > 0) {
                    Globals.getLogger().log(16, "B2181", (Object)String.valueOf(destination.size()), destination.toString());
                }
                destination.destroy(string, bl2);
                if (bl && destination.sendClusterUpdate()) {
                    Globals.getClusterBroadcast().destroyDestination(destination);
                }
                if ((agent = Globals.getAgent()) != null) {
                    agent.notifyDestinationDestroy(destination);
                    agent.unregisterDestination(destination);
                }
            }
            Object var12_14 = null;
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            destination = (Destination)destinationList.remove(destinationUID);
            throw throwable;
        }
        destination = (Destination)destinationList.remove(destinationUID);
        return destination;
    }

    public static boolean removeDestination(Destination destination, String string) throws IOException, BrokerException {
        return Destination.removeDestination(destination.getDestinationUID(), true, string) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Iterator getDestinations(Object object, int n) {
        ArrayList<Destination> arrayList = new ArrayList<Destination>();
        Map map = destinationList;
        synchronized (map) {
            Collection collection = destinationList.values();
            for (Destination destination : collection) {
                if ((destination.getType() & n) != n || object != null && !object.equals(destination.getConnectionUID()) && (!(object instanceof BrokerAddress) || object != Globals.getMyAddress() || !destination.getClusterNotifyFlag() || !destination.sendClusterUpdate())) continue;
                arrayList.add(destination);
            }
        }
        return arrayList.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getLocalTemporaryDestinations() {
        ArrayList<Destination> arrayList = new ArrayList<Destination>();
        Map map = destinationList;
        synchronized (map) {
            Set set = destinationList.keySet();
            for (Destination destination : set) {
                if (!destination.isTemporary() || !destination.getIsLocal()) continue;
                arrayList.add(destination);
            }
        }
        if (DEBUG) {
            Globals.getLogger().log(1, "Matching destinations are: ");
            for (int i = 0; arrayList != null && i < arrayList.size(); ++i) {
                Globals.getLogger().log(1, "\t {0}", arrayList.get(i).toString());
            }
            Globals.getLogger().log(1, "----------------------");
        }
        return arrayList;
    }

    public void updateDestination() throws BrokerException, IOException {
        this.update(true);
    }

    public static Iterator getAllDestinations() {
        return Destination.getAllDestinations(0);
    }

    public static Iterator getAllDestinations(int n) {
        return Destination.getDestinations(null, n);
    }

    public static Iterator getTempDestinations(BrokerAddress brokerAddress) {
        return Destination.getDestinations(brokerAddress, 16);
    }

    public static Iterator getStoredDestinations() {
        return Destination.getDestinations(null, 0);
    }

    public void debug() {
        this.logger.log(8, "Dumping state for destination " + this);
        this.logger.log(8, "Consumer Count " + this.consumers.size());
        this.logger.log(8, "Producer Count " + this.producers.size());
        this.logger.log(8, "Message count " + this.destMessages.size());
        this.logger.log(8, " --------- consumers");
        for (Consumer consumer : this.consumers.values()) {
            consumer.debug("\t");
        }
    }

    public static void init() throws BrokerException {
        if (inited) {
            if (!valid) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B4140"));
            }
            return;
        }
        valid = true;
        inited = true;
        BrokerConfig brokerConfig = Globals.getConfig();
        brokerConfig.addListener(SYSTEM_MAX_SIZE, cl);
        brokerConfig.addListener(SYSTEM_MAX_COUNT, cl);
        brokerConfig.addListener(MAX_MESSAGE_SIZE, cl);
        brokerConfig.addListener(AUTO_QUEUE_STR, cl);
        brokerConfig.addListener(AUTO_TOPIC_STR, cl);
        brokerConfig.addListener(DST_REAP_STR, cl);
        brokerConfig.addListener(MSG_REAP_STR, cl);
        brokerConfig.addListener(AUTO_MAX_NUM_MSGS, cl);
        brokerConfig.addListener(AUTO_MAX_TOTAL_BYTES, cl);
        brokerConfig.addListener(AUTO_MAX_BYTES_MSG, cl);
        brokerConfig.addListener(AUTO_MAX_NUM_PRODUCERS, cl);
        brokerConfig.addListener(AUTO_LOCAL_ONLY, cl);
        brokerConfig.addListener(AUTO_LIMIT_BEHAVIOR, cl);
        brokerConfig.addListener(USE_DMQ_STR, cl);
        brokerConfig.addListener(TRUNCATE_BODY_STR, cl);
        brokerConfig.addListener(LOG_MSGS_STR, cl);
        brokerConfig.addListener(DEBUG_LISTS_PROP, cl);
        Destination.setMaxSize(brokerConfig.getSizeProperty(SYSTEM_MAX_SIZE));
        Destination.setMaxMessages(brokerConfig.getIntProperty(SYSTEM_MAX_COUNT));
        Destination.setIndividualMessageMax(brokerConfig.getSizeProperty(MAX_MESSAGE_SIZE));
        Queue.init();
        Destination.loadDestinations();
    }

    public static void setIndividualMessageMax(SizeString sizeString) {
        if (sizeString == null) {
            sizeString = new SizeString();
        }
        individual_max_size = sizeString;
        long l = sizeString.getBytes();
        if (l <= 0L) {
            l = Long.MAX_VALUE;
        }
        Packet.setMaxPacketSize(l);
        if (Globals.getMemManager() != null) {
            Globals.getMemManager().updateMaxMessageSize(l);
        }
    }

    public static void setMaxMessages(long l) {
        message_max_count = l;
    }

    public static void setMaxSize(SizeString sizeString) {
        if (sizeString == null) {
            sizeString = new SizeString();
        }
        max_size = sizeString;
    }

    public static PacketReference get(SysMessageID sysMessageID) {
        return Destination.get(sysMessageID, true);
    }

    public static PacketReference get(SysMessageID sysMessageID, boolean bl) {
        DestinationUID destinationUID = Destination.getPacketListFirst(sysMessageID);
        if (destinationUID == null) {
            return null;
        }
        Destination destination = (Destination)destinationList.get(destinationUID);
        if (destination == null) {
            return null;
        }
        PacketReference packetReference = (PacketReference)destination.destMessages.get(sysMessageID);
        if (packetReference == null) {
            return null;
        }
        return packetReference.checkLock(bl);
    }

    public PacketReference getMessage(SysMessageID sysMessageID) {
        return (PacketReference)this.destMessages.get(sysMessageID);
    }

    public static boolean isLocked(SysMessageID sysMessageID) {
        DestinationUID destinationUID = Destination.getPacketListFirst(sysMessageID);
        if (destinationUID == null) {
            return false;
        }
        Destination destination = (Destination)destinationList.get(destinationUID);
        if (destination == null) {
            return false;
        }
        PacketReference packetReference = (PacketReference)destination.destMessages.get(sysMessageID);
        if (packetReference == null) {
            return false;
        }
        return packetReference.checkLock(false) == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static boolean addNewMessage(boolean bl, PacketReference packetReference) throws BrokerException {
        if (bl) {
            long l = individual_max_size.getBytes();
            if (l > 0L && packetReference.byteSize() > l) {
                String string = l <= 0L ? Globals.getBrokerResources().getString("B0012") : individual_max_size.toString();
                Object[] objectArray = new String[]{String.valueOf(packetReference.byteSize()), packetReference.getSysMessageID().toString(), string};
                throw new BrokerException(Globals.getBrokerResources().getKString("B4026", objectArray), "B4026", null, 423);
            }
            long l2 = 0L;
            int n = 0;
            Object object = Destination.class;
            // MONITORENTER : com.sun.messaging.jmq.jmsserver.core.Destination.class
            n = totalcnt + 1;
            l2 = totalbytes + packetReference.byteSize();
            // MONITOREXIT : object
            if (message_max_count > 0L && (long)n > message_max_count) {
                object = message_max_count <= 0L ? Globals.getBrokerResources().getString("B0012") : String.valueOf(message_max_count);
                throw new BrokerException(Globals.getBrokerResources().getKString("B4024", object, packetReference.getSysMessageID()), "B4024", null, 414);
            }
            if (max_size.getBytes() > 0L && l2 > max_size.getBytes()) {
                object = max_size.getBytes() <= 0L ? Globals.getBrokerResources().getString("B0012") : max_size.toString();
                throw new BrokerException(Globals.getBrokerResources().getKString("B4025", object, packetReference.getSysMessageID()), "B4025", null, 414);
            }
        }
        Destination.packetlistAdd(packetReference.getSysMessageID(), packetReference.getDestinationUID());
        if (!packetReference.isExpired()) return true;
        return false;
    }

    public static synchronized int totalCount() {
        assert (totalcnt >= 0);
        return totalcnt;
    }

    public static synchronized long totalBytes() {
        assert (totalbytes >= 0L);
        return totalbytes;
    }

    public static synchronized int totalCountNonPersist() {
        assert (totalcntNonPersist >= 0);
        return totalcntNonPersist;
    }

    private static RemoveMessageReturnInfo removeExpiredMessage(DestinationUID destinationUID, SysMessageID sysMessageID) throws BrokerException {
        RemoveMessageReturnInfo removeMessageReturnInfo = null;
        if (destinationUID == null) {
            throw new RuntimeException("expired messages");
        }
        Destination destination = (Destination)destinationList.get(destinationUID);
        if (destination != null) {
            removeMessageReturnInfo = destination._removeMessage(sysMessageID, RemoveReason.EXPIRED, null, null);
            if (removeMessageReturnInfo.removed) {
                Destination.removePacketList(sysMessageID, destination.getDestinationUID());
            }
        }
        if (removeMessageReturnInfo == null) {
            removeMessageReturnInfo = new RemoveMessageReturnInfo();
            removeMessageReturnInfo.removed = false;
            removeMessageReturnInfo.indelivery = false;
        }
        return removeMessageReturnInfo;
    }

    public static boolean canAutoCreate(boolean bl) {
        return bl ? ALLOW_QUEUE_AUTOCREATE : ALLOW_TOPIC_AUTOCREATE;
    }

    public static boolean canAutoCreate(boolean bl, int n) {
        if (DestType.isTemporary(n)) {
            return false;
        }
        return bl ? ALLOW_QUEUE_AUTOCREATE : ALLOW_TOPIC_AUTOCREATE;
    }

    public boolean isProducerActive(ProducerUID producerUID) {
        return this.producerFlow.isProducerActive(producerUID);
    }

    public void notifyAttrUpdated(int n, Object object, Object object2) {
        Agent agent = Globals.getAgent();
        if (agent != null) {
            agent.notifyDestinationAttrUpdated(this, n, object, object2);
        }
    }

    public void setValidateXMLSchemaEnabled(boolean bl) {
        this.validateXMLSchemaEnabled = bl;
    }

    public boolean validateXMLSchemaEnabled() {
        return this.validateXMLSchemaEnabled;
    }

    public void setXMLSchemaUriList(String string) {
        this.XMLSchemaUriList = string;
    }

    public String getXMLSchemaUriList() {
        return this.XMLSchemaUriList;
    }

    public void setReloadXMLSchemaOnFailure(boolean bl) {
        this.reloadXMLSchemaOnFailure = bl;
    }

    public boolean reloadXMLSchemaOnFailure() {
        return this.reloadXMLSchemaOnFailure;
    }

    static {
        if (Globals.getLogger().getLevel() <= 4) {
            DEBUG = true;
        }
        if (DEBUG) {
            Globals.getLogger().log(8, "Syncing message store: " + PERSIST_SYNC);
        }
        if (NO_PRODUCER_FLOW) {
            Globals.getLogger().log(8, "Producer flow control is turned off ");
        }
        try {
            LicenseBase licenseBase = Globals.getCurrentLicense(null);
            CAN_MONITOR_DEST = licenseBase.getBooleanProperty("imq.enable_monitoring", false);
            CAN_USE_LOCAL_DEST = licenseBase.getBooleanProperty("imq.enable_localdest", false);
        }
        catch (BrokerException brokerException) {
            CAN_MONITOR_DEST = false;
            CAN_USE_LOCAL_DEST = false;
        }
        timer = Globals.getTimer();
        defaultMaxMsgCnt = Globals.getConfig().getIntProperty(AUTO_MAX_NUM_MSGS, 100000);
        defaultProducerCnt = Globals.getConfig().getIntProperty(AUTO_MAX_NUM_PRODUCERS, 100);
        defaultMaxMsgBytes = Globals.getConfig().getSizeProperty(AUTO_MAX_TOTAL_BYTES, 0xA00000L);
        defaultMaxBytesPerMsg = Globals.getConfig().getSizeProperty(AUTO_MAX_BYTES_MSG, 10240L);
        defaultIsLocal = Globals.getConfig().getBooleanProperty(AUTO_LOCAL_ONLY, false);
        defaultLimitBehavior = DestLimitBehavior.getStateFromString(Globals.getConfig().getProperty(AUTO_LIMIT_BEHAVIOR, "REJECT_NEWEST"));
        reconnectMultiplier = Globals.getConfig().getIntProperty("imq.reconnect.interval", 5);
        defaultUseDMQ = Globals.getConfig().getBooleanProperty(USE_DMQ_STR, true);
        defaultTruncateBody = Globals.getConfig().getBooleanProperty(TRUNCATE_BODY_STR, false);
        defaultVerbose = Globals.getConfig().getBooleanProperty(LOG_MSGS_STR, false);
        deadMessageQueue = null;
        autocreateUseDMQ = defaultUseDMQ;
        storeBodyWithDMQ = !defaultTruncateBody;
        verbose = defaultVerbose;
        destinationList = Collections.synchronizedMap(new HashMap());
        destsLoaded = false;
        valid = true;
        individual_max_size = null;
        max_size = null;
        message_max_count = 0L;
        totalbytes = 0L;
        totalcnt = 0;
        totalcntNonPersist = 0;
        packetlist = Collections.synchronizedMap(new HashMap());
        cl = new ConfigListener(){

            public void validate(String string, String string2) throws PropertyUpdateException {
            }

            public boolean update(String string, String string2) {
                BrokerConfig brokerConfig = Globals.getConfig();
                if (string.equals(Destination.SYSTEM_MAX_SIZE)) {
                    Destination.setMaxSize(brokerConfig.getSizeProperty(Destination.SYSTEM_MAX_SIZE));
                } else if (string.equals(Destination.SYSTEM_MAX_COUNT)) {
                    Destination.setMaxMessages(brokerConfig.getIntProperty(Destination.SYSTEM_MAX_COUNT));
                } else if (string.equals(Destination.MAX_MESSAGE_SIZE)) {
                    Destination.setIndividualMessageMax(brokerConfig.getSizeProperty(Destination.MAX_MESSAGE_SIZE));
                } else if (string.equals(Destination.AUTO_QUEUE_STR)) {
                    ALLOW_QUEUE_AUTOCREATE = brokerConfig.getBooleanProperty(Destination.AUTO_QUEUE_STR);
                } else if (string.equals(Destination.AUTO_TOPIC_STR)) {
                    ALLOW_TOPIC_AUTOCREATE = brokerConfig.getBooleanProperty(Destination.AUTO_TOPIC_STR);
                } else if (string.equals(Destination.DST_REAP_STR)) {
                    AUTOCREATE_EXPIRE = brokerConfig.getLongProperty(Destination.DST_REAP_STR) * 1000L;
                } else if (string.equals(Destination.MSG_REAP_STR)) {
                    MESSAGE_EXPIRE = brokerConfig.getLongProperty(Destination.MSG_REAP_STR) * 1000L;
                } else if (string.equals(Destination.AUTO_MAX_NUM_MSGS)) {
                    defaultMaxMsgCnt = brokerConfig.getIntProperty(Destination.AUTO_MAX_NUM_MSGS);
                } else if (string.equals(Destination.AUTO_MAX_TOTAL_BYTES)) {
                    defaultMaxMsgBytes = brokerConfig.getSizeProperty(Destination.AUTO_MAX_TOTAL_BYTES);
                } else if (string.equals(Destination.AUTO_MAX_BYTES_MSG)) {
                    defaultMaxBytesPerMsg = brokerConfig.getSizeProperty(Destination.AUTO_MAX_BYTES_MSG);
                } else if (string.equals(Destination.AUTO_MAX_NUM_PRODUCERS)) {
                    defaultProducerCnt = brokerConfig.getIntProperty(Destination.AUTO_MAX_NUM_PRODUCERS);
                } else if (string.equals(Destination.AUTO_LOCAL_ONLY)) {
                    defaultIsLocal = brokerConfig.getBooleanProperty(Destination.AUTO_LOCAL_ONLY);
                } else if (string.equals(Destination.AUTO_LIMIT_BEHAVIOR)) {
                    defaultLimitBehavior = DestLimitBehavior.getStateFromString(Globals.getConfig().getProperty(Destination.AUTO_LIMIT_BEHAVIOR));
                } else if (string.equals(Destination.USE_DMQ_STR)) {
                    autocreateUseDMQ = brokerConfig.getBooleanProperty(Destination.USE_DMQ_STR);
                } else if (string.equals(Destination.TRUNCATE_BODY_STR)) {
                    storeBodyWithDMQ = !brokerConfig.getBooleanProperty(Destination.TRUNCATE_BODY_STR);
                } else if (string.equals(Destination.LOG_MSGS_STR)) {
                    verbose = brokerConfig.getBooleanProperty(Destination.LOG_MSGS_STR);
                } else if (string.equals(DEBUG_LISTS_PROP)) {
                    DEBUG_LISTS = Boolean.valueOf(string2);
                }
                return true;
            }
        };
        inited = false;
    }

    class ProducerFlow {
        transient Map pausedProducerMap = new LinkedHashMap();
        transient Map activeProducerMap = new LinkedHashMap();

        public synchronized int pausedProducerCnt() {
            return this.pausedProducerMap.size();
        }

        public synchronized int activeProducerCnt() {
            return this.activeProducerMap.size();
        }

        public synchronized Vector getDebugPausedProducers() {
            Vector<String> vector = new Vector<String>();
            Iterator iterator = this.pausedProducerMap.values().iterator();
            while (iterator.hasNext()) {
                try {
                    Object v = iterator.next();
                    ProducerUID producerUID = ((Producer)iterator.next()).getProducerUID();
                    vector.add(String.valueOf(producerUID.longValue()));
                }
                catch (Exception exception) {
                    vector.add(exception.toString());
                }
            }
            return vector;
        }

        public synchronized Vector getDebugActiveProducers() {
            Vector<String> vector = new Vector<String>();
            Iterator iterator = this.activeProducerMap.values().iterator();
            while (iterator.hasNext()) {
                try {
                    Object v = iterator.next();
                    ProducerUID producerUID = ((Producer)iterator.next()).getProducerUID();
                    vector.add(String.valueOf(producerUID.longValue()));
                }
                catch (Exception exception) {
                    vector.add(exception.toString());
                }
            }
            return vector;
        }

        private void sendResumeFlow(Producer producer, boolean bl, String string) {
            int n = 0;
            long l = 0L;
            long l2 = 0L;
            if (!bl) {
                n = Destination.this.producerMsgBatchSize;
                l = Destination.this.producerMsgBatchBytes;
                l2 = Destination.this.getMsgBytesProducerFlow();
            }
            producer.sendResumeFlow(Destination.this.getDestinationUID(), n, l, l2, string, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateAllProducers(int n, String string) {
            if (n == 0) {
                ProducerFlow producerFlow = this;
                synchronized (producerFlow) {
                    Iterator iterator = this.activeProducerMap.values().iterator();
                    while (iterator.hasNext()) {
                        Producer producer = (Producer)iterator.next();
                        this.pausedProducerMap.put(producer.getProducerUID(), producer);
                        iterator.remove();
                        producer.pause();
                        this.sendResumeFlow(producer, true, string);
                    }
                }
            }
            if (n == 1) {
                this.checkResumeFlow(null, true, string);
            } else if (n == 2 || n == 3) {
                ProducerFlow producerFlow = this;
                synchronized (producerFlow) {
                    for (Producer producer : this.activeProducerMap.values()) {
                        this.sendResumeFlow(producer, false, string);
                    }
                }
            }
        }

        public synchronized boolean pauseProducer(Producer producer) {
            boolean bl = false;
            if (this.activeProducerMap.remove(producer.getProducerUID()) != null) {
                this.pausedProducerMap.put(producer.getProducerUID(), producer);
                bl = true;
            }
            producer.pause();
            return bl;
        }

        public boolean isProducerActive(ProducerUID producerUID) {
            return this.pausedProducerMap.get(producerUID) == null;
        }

        private synchronized void resumeProducer(Producer producer) {
            if (this.pausedProducerMap.remove(producer.getProducerUID()) != null) {
                this.activeProducerMap.put(producer.getProducerUID(), producer);
            }
            producer.resume();
        }

        public boolean checkResumeFlow(Producer producer, boolean bl) {
            return this.checkResumeFlow(producer, bl, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean checkResumeFlow(Producer producer, boolean bl, String string) {
            ProducerFlow producerFlow = this;
            synchronized (producerFlow) {
                if (Destination.this.state == 2 || Destination.this.state == 3) {
                    if (this.activeProducerMap != null) {
                        Iterator iterator = this.activeProducerMap.values().iterator();
                        while (iterator.hasNext()) {
                            Producer producer2 = (Producer)iterator.next();
                            this.pausedProducerMap.put(producer2.getProducerUID(), producer2);
                            iterator.remove();
                            producer2.pause();
                            boolean bl2 = bl || producer != null && !producer2.getProducerUID().equals(producer.getProducerUID());
                            if (!bl2) continue;
                            this.sendResumeFlow(producer2, true, string);
                        }
                    }
                    return false;
                }
                if (Destination.this.limit != 0) {
                    if (this.pausedProducerMap != null) {
                        Iterator iterator = this.pausedProducerMap.values().iterator();
                        while (iterator.hasNext()) {
                            Producer producer3 = (Producer)iterator.next();
                            this.activeProducerMap.put(producer3.getProducerUID(), producer3);
                            iterator.remove();
                            producer3.resume();
                            boolean bl3 = bl || producer != null && !producer3.getProducerUID().equals(producer.getProducerUID());
                            if (!bl3) continue;
                            this.sendResumeFlow(producer3, false, string);
                        }
                    }
                    return true;
                }
            }
            boolean bl4 = false;
            SimpleNFLHashMap simpleNFLHashMap = Destination.this.destMessages;
            synchronized (simpleNFLHashMap) {
                int n = Destination.this.destMessages.freeSpace();
                long l = Destination.this.destMessages.freeBytes();
                ProducerFlow producerFlow2 = this;
                synchronized (producerFlow2) {
                    Iterator iterator = this.pausedProducerMap.values().iterator();
                    while (iterator.hasNext() && (n == -1 || n > 0 && n > this.activeProducerMap.size() * Destination.this.producerMsgBatchSize) && (l == -1L || l > 0L && l > (long)this.activeProducerMap.size() * Destination.this.producerMsgBatchBytes)) {
                        Producer producer4 = (Producer)iterator.next();
                        if (!producer4.isValid()) continue;
                        if (DEBUG) {
                            Logger cfr_ignored_0 = Destination.this.logger;
                            Destination.this.logger.log(1, "Resuming producer " + producer4 + " The destination has " + n + " more space and " + this.activeProducerMap.size() + " active producers [" + " batch size " + Destination.this.producerMsgBatchSize + "  msg " + Destination.this.destMessages.size());
                        }
                        this.activeProducerMap.put(producer4.getProducerUID(), producer4);
                        iterator.remove();
                        producer4.resume();
                        boolean bl5 = bl || producer != null && !producer4.getProducerUID().equals(producer.getProducerUID());
                        if (!bl5) continue;
                        if (string == null) {
                            string = "Producer " + producer4.getProducerUID() + " has become active";
                        }
                        this.sendResumeFlow(producer4, false, string);
                    }
                    if (producer != null) {
                        bl4 = this.activeProducerMap.containsKey(producer.getProducerUID());
                    }
                }
            }
            return bl4;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void forceResumeFlow(Producer producer) {
            SimpleNFLHashMap simpleNFLHashMap = Destination.this.destMessages;
            synchronized (simpleNFLHashMap) {
                int n = Destination.this.destMessages.freeSpace();
                long l = Destination.this.destMessages.freeBytes();
                ProducerFlow producerFlow = this;
                synchronized (producerFlow) {
                    if (!(n != -1 && n < this.activeProducerMap.size() * Destination.this.producerMsgBatchSize || l != -1L && l < (long)this.activeProducerMap.size() * Destination.this.producerMsgBatchBytes)) {
                        this.activeProducerMap.put(producer.getProducerUID(), producer);
                        this.pausedProducerMap.remove(producer.getProducerUID());
                        producer.resume();
                        this.sendResumeFlow(producer, false, "Producer " + producer.getProducerUID() + " has become active");
                    }
                }
            }
        }

        public synchronized boolean removeProducer(Producer producer) {
            producer.destroy();
            Object v = this.activeProducerMap.remove(producer.getProducerUID());
            this.pausedProducerMap.remove(producer.getProducerUID());
            return v != null;
        }

        public synchronized boolean addProducer(Producer producer) {
            Producer producer2 = this.pausedProducerMap.put(producer.getProducerUID(), producer);
            return producer2 == null;
        }
    }

    class UnloadFilter
    implements Filter {
        UnloadFilter() {
        }

        public boolean matches(Object object) {
            assert (object instanceof PacketReference);
            return ((PacketReference)object).isPersistent();
        }

        public boolean equals(Object object) {
            return super.equals(object);
        }

        public int hashCode() {
            return super.hashCode();
        }
    }

    static class RemoveMessageReturnInfo {
        boolean removed = false;
        boolean indelivery = false;

        RemoveMessageReturnInfo() {
        }
    }

    class DestFilter
    implements Filter {
        DestFilter() {
        }

        public boolean matches(Object object) {
            return Destination.this.uid.equals(((PacketReference)object).getDestinationUID());
        }

        public boolean equals(Object object) {
            return super.equals(object);
        }

        public int hashCode() {
            return super.hashCode();
        }
    }

    class MsgExpirationReaper {
        SortedSet messages = new TreeSet(ExpirationInfo.getComparator());
        TimerTask mytimer = null;

        public synchronized void addExpiringMessage(ExpirationInfo expirationInfo) {
            this.messages.add(expirationInfo);
            if (this.mytimer == null) {
                this.addTimer();
            }
        }

        public synchronized void removeMessage(ExpirationInfo expirationInfo) {
            boolean bl = this.messages.remove(expirationInfo);
            if (bl && this.messages.isEmpty()) {
                this.removeTimer();
            }
        }

        public synchronized void destroy() {
            if (this.mytimer != null) {
                this.removeTimer();
            }
            this.messages.clear();
        }

        void addTimer() {
            assert (Thread.holdsLock(this));
            assert (this.mytimer == null);
            this.mytimer = new MyExpireTimerTask();
            try {
                timer.schedule(this.mytimer, MESSAGE_EXPIRE, MESSAGE_EXPIRE);
            }
            catch (IllegalStateException illegalStateException) {
                Destination.this.logger.log(8, "B3100", (Object)("Canceling message expiration on " + this), (Throwable)illegalStateException);
            }
        }

        void removeTimer() {
            assert (Thread.holdsLock(this));
            try {
                if (this.mytimer != null) {
                    this.mytimer.cancel();
                }
            }
            catch (IllegalStateException illegalStateException) {
                Destination.this.logger.logStack(4, "timer canceled ", illegalStateException);
            }
            this.mytimer = null;
        }

        class MyExpireTimerTask
        extends TimerTask {
            MyExpireTimerTask() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object;
                long l = System.currentTimeMillis();
                int n = 0;
                int n2 = 0;
                LinkedHashSet<ExpirationInfo> linkedHashSet = new LinkedHashSet<ExpirationInfo>();
                DestinationUID destinationUID = Destination.this.uid;
                MsgExpirationReaper msgExpirationReaper = MsgExpirationReaper.this;
                synchronized (msgExpirationReaper) {
                    Iterator object2 = MsgExpirationReaper.this.messages.iterator();
                    while (object2.hasNext() && ((ExpirationInfo)(object = (ExpirationInfo)object2.next())).getExpireTime() <= l) {
                        linkedHashSet.add((ExpirationInfo)object);
                    }
                }
                for (ExpirationInfo expirationInfo : linkedHashSet) {
                    try {
                        expirationInfo.incrementReapCount();
                        object = Destination.removeExpiredMessage(destinationUID, expirationInfo.id);
                        if (((RemoveMessageReturnInfo)object).removed) {
                            MsgExpirationReaper.this.removeMessage(expirationInfo);
                            ++n;
                            continue;
                        }
                        if (((RemoveMessageReturnInfo)object).indelivery) {
                            ++n2;
                            continue;
                        }
                        if (expirationInfo.getReapCount() <= 1) continue;
                        MsgExpirationReaper.this.removeMessage(expirationInfo);
                        ++n;
                    }
                    catch (Exception exception) {
                        Destination.this.logger.logStack(16, exception.getMessage(), exception);
                    }
                }
                if (n > 0) {
                    Destination.this.logger.log(8, "B1140", (Object)String.valueOf(n), destinationUID.getLocalizedName());
                }
                if (n2 > 0) {
                    Destination.this.logger.log(8, "B1389", (Object)String.valueOf(n2), destinationUID.getLocalizedName());
                }
                linkedHashSet.clear();
            }
        }
    }

    static class ReconnectReaperTask
    extends TimerTask {
        DestinationUID uid = null;
        private boolean canceled = false;
        private long time = 0L;

        public ReconnectReaperTask(DestinationUID destinationUID, long l) {
            this.uid = destinationUID;
            this.time = l;
        }

        public synchronized boolean cancel() {
            this.canceled = true;
            return super.cancel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ReconnectReaperTask reconnectReaperTask = this;
            synchronized (reconnectReaperTask) {
                Globals.getLogger().log(4, "Destroying temp destination " + this.uid + " inactive for " + this.time / 1000L + " seconds");
                if (!this.canceled) {
                    try {
                        Destination.removeDestination(this.uid, false, Globals.getBrokerResources().getString("B0070"));
                    }
                    catch (Exception exception) {
                        if (BrokerStateHandler.shuttingDown) {
                            Globals.getLogger().log(8, "B4144", (Object)this.uid.getLocalizedName(), (Throwable)exception);
                        }
                        Globals.getLogger().logStack(16, "B4144", this.uid.getLocalizedName(), (Throwable)exception);
                    }
                }
            }
        }
    }

    static class DestReaperTask
    extends TimerTask {
        DestinationUID uid = null;
        private boolean canceled = false;
        Logger logger = Globals.getLogger();

        public DestReaperTask(DestinationUID destinationUID) {
            this.uid = destinationUID;
        }

        public synchronized boolean cancel() {
            this.canceled = true;
            return super.cancel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = this;
            synchronized (object) {
                if (this.canceled) {
                    return;
                }
                this.canceled = true;
            }
            try {
                object = Destination.getDestination(this.uid);
                if (object == null) {
                    return;
                }
                Object object2 = object;
                synchronized (object2) {
                    if (!((Destination)object).shouldDestroy()) {
                        return;
                    }
                }
                object2 = destinationList;
                synchronized (object2) {
                    if (((Destination)object).getRefCount() > 0) {
                        return;
                    }
                    int n = DestType.isAdmin(((Destination)object).getType()) ? 4 : 8;
                    this.logger.log(n, "B1130", (Object)this.uid.getLocalizedName(), String.valueOf(AUTOCREATE_EXPIRE / 1000L));
                    ((Destination)object).destvalid = false;
                    object = Destination.removeDestination(this.uid, false, Globals.getBrokerResources().getString("B0069"));
                }
            }
            catch (Exception exception) {
                this.logger.logStack(16, "B4144", this.uid.getLocalizedName(), (Throwable)exception);
            }
        }
    }

    class FlowListener
    implements EventListener {
        FlowListener() {
        }

        public void eventOccured(EventType eventType, Reason reason, Object object, Object object2, Object object3, Object object4) {
            if (reason instanceof RemoveReason) {
                return;
            }
            assert (eventType == EventType.FULL);
            if (reason != AddReason.LOADED) {
                assert (object3 instanceof Boolean);
                boolean bl = Destination.this.destMessages.isFull();
                if (bl) {
                    Destination.this.logger.log(4, "Destination " + Destination.this + " is full, " + " all producers should be stopped");
                    Destination.this.producerFlow.updateAllProducers(0, "Destination Full");
                } else {
                    Destination.this.logger.log(4, "Destination " + Destination.this + " is not full, " + " some producers should be stopped");
                    Destination.this.producerFlow.checkResumeFlow(null, true);
                }
            }
        }
    }

    class RemoveBehaviorListener
    implements EventListener {
        Set orderedSet = null;
        Reason r = null;

        public RemoveBehaviorListener(Set set, Reason reason) {
            this.orderedSet = set;
            this.r = reason;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void eventOccured(EventType eventType, Reason reason, Object object, Object object2, Object object3, Object object4) {
            assert (eventType == EventType.SET_CHANGED_REQUEST);
            boolean bl = Destination.this.destMessages.isFull();
            if (!bl || object3 == null) return;
            long l = ((Sized)object3).byteSize();
            while (true) {
                Iterator iterator = null;
                Set set = this.orderedSet;
                synchronized (set) {
                    iterator = new LinkedHashSet(this.orderedSet).iterator();
                }
                if (!iterator.hasNext()) return;
                Object e = iterator.next();
                if (e == null) continue;
                try {
                    Destination.this.removeMessage(((PacketReference)e).getSysMessageID(), this.r);
                }
                catch (Exception exception) {
                    Destination.this.logger.logStack(8, "B3044", exception);
                    iterator.remove();
                    continue;
                }
                if (!(Destination.this.destMessages.capacity() != -1 && Destination.this.destMessages.freeSpace() <= 0 || Destination.this.destMessages.byteCapacity() != -1L && Destination.this.destMessages.freeBytes() <= l)) return;
            }
        }
    }
}

