/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.BasicQueue;
import com.sun.messaging.BasicTopic;
import com.sun.messaging.Destination;
import com.sun.messaging.jmq.io.JMQByteArrayOutputStream;
import com.sun.messaging.jmq.io.ReadWritePacket;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsclient.ExceptionHandler;
import com.sun.messaging.jmq.jmsclient.SessionImpl;
import com.sun.messaging.jmq.jmsclient.TemporaryQueueImpl;
import com.sun.messaging.jmq.jmsclient.TemporaryTopicImpl;
import com.sun.messaging.jmq.jmsclient.Traceable;
import com.sun.messaging.jmq.jmsclient.ValueConvert;
import com.sun.messaging.jmq.jmsclient.zip.Compressor;
import com.sun.messaging.jmq.jmsclient.zip.Decompressor;
import com.sun.messaging.jms.Message;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;

public class MessageImpl
implements javax.jms.Message,
Message,
Traceable {
    public static final String UTF8 = "UTF8";
    protected Hashtable properties = null;
    protected ReadWritePacket pkt = null;
    protected boolean readMode = false;
    protected boolean propReadMode = false;
    protected SessionImpl session = null;
    protected SysMessageID messageID = null;
    protected long interestID = 0L;
    protected boolean isOnAckList = false;
    protected boolean isQBrowserMsg = false;
    protected boolean doAcknowledge = true;
    protected boolean consumerInRA = false;
    protected javax.jms.Destination destination = null;
    protected javax.jms.Destination replyTo = null;
    protected boolean jmsMessageIDSet = false;
    protected String jmsMessageID = null;
    protected boolean shouldCompress = false;
    public static final String JMS_SUN_COMPRESS = "JMS_SUN_COMPRESS";
    public static final String JMS_SUN_UNCOMPRESSED_SIZE = "JMS_SUN_UNCOMPRESSED_SIZE";
    public static final String JMS_SUN_COMPRESSED_SIZE = "JMS_SUN_COMPRESSED_SIZE";

    protected void setSession(SessionImpl sessionImpl) {
        this.session = sessionImpl;
        if (sessionImpl.setJMSXConsumerTXID && sessionImpl.transaction != null) {
            if (this.properties == null) {
                this.properties = new Hashtable();
            }
            this.properties.put("JMSXConsumerTXID", String.valueOf(sessionImpl.transaction.getTransactionID()));
        }
    }

    public SessionImpl _getSession() {
        return this.session;
    }

    protected void setPacket(ReadWritePacket readWritePacket) {
        this.pkt = readWritePacket;
    }

    protected ReadWritePacket getPacket() {
        return this.pkt;
    }

    protected void setMessageBodyToPacket() throws JMSException {
    }

    protected void getMessageBodyFromPacket() throws JMSException {
    }

    protected void setPropertiesToPacket() throws JMSException {
        try {
            this.pkt.setProperties(this.properties);
        }
        catch (Exception exception) {
            ExceptionHandler.handleException(exception, "C4006", true);
        }
    }

    protected void getPropertiesFromPacket() throws JMSException {
        try {
            this.properties = this.pkt.getProperties();
        }
        catch (Exception exception) {
            ExceptionHandler.handleException(exception, "C4005", true);
        }
    }

    protected void setMessageBody(byte[] byArray) {
        this.pkt.setMessageBody(byArray);
    }

    protected InputStream getMessageBodyStream() {
        return this.pkt.getMessageBodyStream();
    }

    protected byte[] getMessageBody() throws JMSException {
        if (this.pkt.getFlag(1024)) {
            this.decompress();
        }
        return this.pkt.getMessageBody();
    }

    protected void compress() throws JMSException {
        try {
            byte[] byArray = this.pkt.getMessageBody();
            int n = this.pkt.getMessageBodyOffset();
            int n2 = this.pkt.getMessageBodyLength();
            if (byArray == null) {
                this.setProperty(JMS_SUN_UNCOMPRESSED_SIZE, new Integer(0));
                this.setProperty(JMS_SUN_COMPRESSED_SIZE, new Integer(0));
                return;
            }
            JMQByteArrayOutputStream jMQByteArrayOutputStream = new JMQByteArrayOutputStream(new byte[32]);
            Compressor compressor = Compressor.getInstance();
            compressor.compress(byArray, n, n2, jMQByteArrayOutputStream);
            jMQByteArrayOutputStream.flush();
            byte[] byArray2 = jMQByteArrayOutputStream.getBuf();
            int n3 = jMQByteArrayOutputStream.getCount();
            jMQByteArrayOutputStream.close();
            this.pkt.setMessageBody(byArray2, 0, n3);
            this.setProperty(JMS_SUN_UNCOMPRESSED_SIZE, new Integer(n2));
            this.setProperty(JMS_SUN_COMPRESSED_SIZE, new Integer(n3));
            this.pkt.setFlag(1024, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JMSException jMSException = new JMSException(exception.toString());
            jMSException.setLinkedException(exception);
            ExceptionHandler.throwJMSException(jMSException);
        }
    }

    protected void decompress() throws JMSException {
        Decompressor decompressor = Decompressor.getInstance();
        byte[] byArray = this.pkt.getMessageBody();
        int n = this.getIntProperty(JMS_SUN_UNCOMPRESSED_SIZE);
        byte[] byArray2 = new byte[n];
        decompressor.decompress(byArray, byArray2);
        this.pkt.setMessageBody(byArray2, 0, n);
        this.pkt.setFlag(1024, false);
        this.shouldCompress = true;
    }

    private void checkValidPropertyName(String string) throws JMSException {
        Object object;
        Object object2;
        if ("NULL".equalsIgnoreCase(string) || "TRUE".equalsIgnoreCase(string) || "FALSE".equalsIgnoreCase(string) || "NOT".equalsIgnoreCase(string) || "AND".equalsIgnoreCase(string) || "OR".equalsIgnoreCase(string) || "BETWEEN".equalsIgnoreCase(string) || "LIKE".equalsIgnoreCase(string) || "IN".equalsIgnoreCase(string) || "IS".equalsIgnoreCase(string)) {
            object2 = AdministeredObject.cr.getKString("C4041", string);
            object = new JMSException((String)object2, "C4041");
            ExceptionHandler.throwJMSException((JMSException)object);
        }
        if (Character.isJavaIdentifierStart((char)(object2 = (Object)string.toCharArray())[0])) {
            for (int i = 1; i < ((Object)object2).length; ++i) {
                if (Character.isJavaIdentifierPart((char)object2[i])) continue;
                String string2 = AdministeredObject.cr.getKString("C4043", String.valueOf((char)object2[i]), string);
                JMSException jMSException = new JMSException(string2, "C4043");
                ExceptionHandler.throwJMSException(jMSException);
            }
        } else {
            object = AdministeredObject.cr.getKString("C4042", String.valueOf((char)object2[0]), string);
            JMSException jMSException = new JMSException((String)object, "C4042");
            ExceptionHandler.throwJMSException(jMSException);
        }
    }

    protected void checkAndSetProperty(String string, Object object) throws JMSException {
        JMSException jMSException;
        String string2;
        if (string == null || "".equals(string)) {
            String string3 = AdministeredObject.cr.getKString("C4072");
            throw new IllegalArgumentException(string3);
        }
        if (this.propReadMode) {
            string2 = AdministeredObject.cr.getKString("C4011");
            jMSException = new MessageNotWriteableException(string2, "C4011");
            ExceptionHandler.throwJMSException(jMSException);
        }
        if (!(object instanceof Boolean || object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double || object instanceof String)) {
            string2 = AdministeredObject.cr.getKString("C4040", string);
            jMSException = new MessageFormatException(string2, "C4040");
            ExceptionHandler.throwJMSException(jMSException);
        }
        this.checkValidPropertyName(string);
        this.setProperty(string, object);
    }

    private void setProperty(String string, Object object) {
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        this.properties.put(string, object);
    }

    protected void checkMessageAccess() throws JMSException {
        if (this.readMode) {
            String string = AdministeredObject.cr.getKString("C4008");
            MessageNotWriteableException messageNotWriteableException = new MessageNotWriteableException(string, "C4008");
            ExceptionHandler.throwJMSException(messageNotWriteableException);
        }
    }

    protected void checkReadAccess() throws JMSException {
        if (!this.readMode) {
            String string = AdministeredObject.cr.getKString("C4009");
            MessageNotReadableException messageNotReadableException = new MessageNotReadableException(string, "C4009");
            ExceptionHandler.throwJMSException(messageNotReadableException);
        }
    }

    protected void setMessageReadMode(boolean bl) {
        this.readMode = bl;
    }

    protected void setPropertiesReadMode(boolean bl) {
        this.propReadMode = bl;
    }

    protected void setIsOnAckList(boolean bl) {
        this.isOnAckList = bl;
    }

    protected boolean getIsOnAckList() {
        return this.isOnAckList;
    }

    protected MessageImpl() throws JMSException {
        this.init();
    }

    protected void setMessageID(SysMessageID sysMessageID) {
        this.messageID = (SysMessageID)sysMessageID.clone();
    }

    protected SysMessageID getMessageID() {
        return this.messageID;
    }

    protected long getInterestID() {
        return this.interestID;
    }

    protected void setInterestID(long l) {
        this.interestID = l;
    }

    protected javax.jms.Destination getJMQDestination(String string) throws JMSException {
        Destination destination = null;
        boolean bl = this.pkt.getIsQueue();
        destination = string.startsWith("temporary_destination://queue/") ? new TemporaryQueueImpl(string) : (string.startsWith("temporary_destination://topic/") ? new TemporaryTopicImpl(string) : (bl ? new BasicQueue(string) : new BasicTopic(string)));
        return destination;
    }

    private void init() throws JMSException {
        this.pkt = new ReadWritePacket();
        this.setJMSDeliveryMode(2);
        this.setJMSPriority(4);
        this.setJMSExpiration(0L);
        this.setPacketType(6);
    }

    protected void setPacketType(int n) {
        this.pkt.setPacketType(n);
    }

    public boolean getSendAcknowledge() {
        return this.pkt.getSendAcknowledge();
    }

    public String getJMSMessageID() throws JMSException {
        if (this.jmsMessageIDSet) {
            return this.jmsMessageID;
        }
        return "ID:" + this.pkt.getMessageID();
    }

    public void setJMSMessageID(String string) throws JMSException {
        this.jmsMessageID = string;
        this.jmsMessageIDSet = true;
    }

    public void resetJMSMessageID() {
        this.jmsMessageIDSet = false;
    }

    public long getJMSTimestamp() throws JMSException {
        return this.pkt.getTimestamp();
    }

    public void setJMSTimestamp(long l) throws JMSException {
        this.pkt.setTimestamp(l);
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        byte[] byArray = null;
        try {
            byArray = this.pkt.getCorrelationID().getBytes(UTF8);
        }
        catch (Exception exception) {
            ExceptionHandler.handleException(exception, "C4038");
        }
        return byArray;
    }

    public void setJMSCorrelationIDAsBytes(byte[] byArray) throws JMSException {
        try {
            String string = new String(byArray, UTF8);
            this.pkt.setCorrelationID(string);
        }
        catch (Exception exception) {
            ExceptionHandler.handleException(exception, "C4038");
        }
    }

    public void setJMSCorrelationID(String string) throws JMSException {
        this.pkt.setCorrelationID(string);
    }

    public String getJMSCorrelationID() throws JMSException {
        return this.pkt.getCorrelationID();
    }

    public javax.jms.Destination getJMSReplyTo() throws JMSException {
        String string = null;
        String string2 = null;
        if (this.replyTo == null && this.messageID != null) {
            if (this.pkt.getReplyTo() == null) {
                return null;
            }
            try {
                string = this.pkt.getReplyTo();
                string2 = this.pkt.getReplyToClass();
                this.replyTo = (Destination)Class.forName(string2).newInstance();
                ((Destination)this.replyTo).setProperty("imqDestinationName", string);
            }
            catch (Exception exception) {
                this.replyTo = this.getJMQDestination(string);
            }
        }
        return this.replyTo;
    }

    public void setJMSReplyTo(javax.jms.Destination destination) throws JMSException {
        this.replyTo = destination;
    }

    public javax.jms.Destination getJMSDestination() throws JMSException {
        String string = null;
        String string2 = null;
        if (this.destination == null && this.messageID != null) {
            try {
                string = this.pkt.getDestination();
                string2 = this.pkt.getDestinationClass();
                this.destination = (Destination)Class.forName(string2).newInstance();
                ((Destination)this.destination).setProperty("imqDestinationName", string);
            }
            catch (Exception exception) {
                this.destination = this.getJMQDestination(string);
            }
        }
        return this.destination;
    }

    public void setJMSDestination(javax.jms.Destination destination) throws JMSException {
        this.destination = destination;
    }

    public int getJMSDeliveryMode() throws JMSException {
        if (this.pkt.getPersistent()) {
            return 2;
        }
        return 1;
    }

    public void setJMSDeliveryMode(int n) throws JMSException {
        if (n != 1 && n != 2) {
            String string = AdministeredObject.cr.getKString("C4051", "DeliveryMode", String.valueOf(n));
            JMSException jMSException = new JMSException(string, "C4051");
            ExceptionHandler.throwJMSException(jMSException);
        }
        if (n == 2) {
            this.pkt.setPersistent(true);
        } else {
            this.pkt.setPersistent(false);
        }
    }

    public boolean getJMSRedelivered() throws JMSException {
        return this.pkt.getRedelivered();
    }

    public void setJMSRedelivered(boolean bl) throws JMSException {
        this.pkt.setRedelivered(bl);
    }

    public String getJMSType() throws JMSException {
        return this.pkt.getMessageType();
    }

    public void setJMSType(String string) throws JMSException {
        this.pkt.setMessageType(string);
    }

    public long getJMSExpiration() throws JMSException {
        return this.pkt.getExpiration();
    }

    public void setJMSExpiration(long l) throws JMSException {
        this.pkt.setExpiration(l);
    }

    public int getJMSPriority() throws JMSException {
        return this.pkt.getPriority();
    }

    public void setJMSPriority(int n) throws JMSException {
        if (n < 0 || n > 9) {
            String string = AdministeredObject.cr.getKString("C4051", "DeliveryPriority", String.valueOf(n));
            JMSException jMSException = new JMSException(string, "C4051");
            ExceptionHandler.throwJMSException(jMSException);
        }
        this.pkt.setPriority(n);
    }

    public void clearProperties() throws JMSException {
        if (this.properties != null) {
            this.properties.clear();
        }
        this.setPropertiesReadMode(false);
        this.shouldCompress = false;
    }

    public boolean propertyExists(String string) throws JMSException {
        if (this.properties == null) {
            return false;
        }
        try {
            return this.properties.containsKey(string);
        }
        catch (Exception exception) {
            ExceptionHandler.handleException(exception, "C4038");
            return false;
        }
    }

    public boolean getBooleanProperty(String string) throws JMSException {
        Object var2_2 = null;
        if (this.properties != null) {
            var2_2 = this.properties.get(string);
        }
        return ValueConvert.toBoolean(var2_2);
    }

    public byte getByteProperty(String string) throws JMSException {
        Object var2_2 = null;
        if (this.properties != null) {
            var2_2 = this.properties.get(string);
        }
        return ValueConvert.toByte(var2_2);
    }

    public short getShortProperty(String string) throws JMSException {
        Object var2_2 = null;
        if (this.properties != null) {
            var2_2 = this.properties.get(string);
        }
        return ValueConvert.toShort(var2_2);
    }

    public int getIntProperty(String string) throws JMSException {
        Object var2_2 = null;
        if (this.properties != null) {
            var2_2 = this.properties.get(string);
        }
        return ValueConvert.toInt(var2_2);
    }

    public long getLongProperty(String string) throws JMSException {
        Object var2_2 = null;
        if (this.properties != null) {
            var2_2 = this.properties.get(string);
        }
        return ValueConvert.toLong(var2_2);
    }

    public float getFloatProperty(String string) throws JMSException {
        Object var2_2 = null;
        if (this.properties != null) {
            var2_2 = this.properties.get(string);
        }
        return ValueConvert.toFloat(var2_2);
    }

    public double getDoubleProperty(String string) throws JMSException {
        Object var2_2 = null;
        if (this.properties != null) {
            var2_2 = this.properties.get(string);
        }
        return ValueConvert.toDouble(var2_2);
    }

    public String getStringProperty(String string) throws JMSException {
        Object v;
        if (this.properties == null || (v = this.properties.get(string)) == null) {
            return null;
        }
        return ValueConvert.toString(v);
    }

    public Object getObjectProperty(String string) throws JMSException {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(string);
    }

    public Enumeration getPropertyNames() throws JMSException {
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        return this.properties.keys();
    }

    public void setBooleanProperty(String string, boolean bl) throws JMSException {
        this.checkAndSetProperty(string, bl);
        if (JMS_SUN_COMPRESS.equals(string)) {
            this.shouldCompress = bl;
        }
    }

    public void setByteProperty(String string, byte by) throws JMSException {
        this.checkAndSetProperty(string, new Byte(by));
    }

    public void setShortProperty(String string, short s) throws JMSException {
        this.checkAndSetProperty(string, new Short(s));
    }

    public void setIntProperty(String string, int n) throws JMSException {
        this.checkAndSetProperty(string, new Integer(n));
    }

    public void setLongProperty(String string, long l) throws JMSException {
        this.checkAndSetProperty(string, new Long(l));
    }

    public void setFloatProperty(String string, float f) throws JMSException {
        this.checkAndSetProperty(string, new Float(f));
    }

    public void setDoubleProperty(String string, double d) throws JMSException {
        this.checkAndSetProperty(string, new Double(d));
    }

    public void setStringProperty(String string, String string2) throws JMSException {
        this.checkAndSetProperty(string, string2);
    }

    public void setObjectProperty(String string, Object object) throws JMSException {
        this.checkAndSetProperty(string, object);
    }

    public void acknowledge() throws JMSException {
        if (this.session != null && this.session.acknowledgeMode == 2 && !this.isQBrowserMsg) {
            this.session.clientAcknowledge(this);
        }
    }

    public void acknowledgeThisMessage() throws JMSException {
        if (this.session != null && this.session.acknowledgeMode == 2 && !this.isQBrowserMsg) {
            this.session.clientAcknowledgeThisMessage(this);
        }
    }

    public void acknowledgeUpThroughThisMessage() throws JMSException {
        if (this.session != null && this.session.acknowledgeMode == 2 && !this.isQBrowserMsg) {
            this.session.clientAcknowledgeUpThroughThisMessage(this);
        }
    }

    public void clearBody() throws JMSException {
    }

    public boolean _getPersistent() {
        return this.pkt.getPersistent();
    }

    public boolean _getSendAcknowledge() {
        return this.pkt.getSendAcknowledge();
    }

    public void _setConsumerInRA() {
        this.consumerInRA = true;
    }

    protected void setIsBrowserMsg(boolean bl) {
        this.isQBrowserMsg = bl;
    }

    protected boolean isBrowserMessage() {
        return this.isQBrowserMsg;
    }

    public void dump(PrintStream printStream) {
        printStream.println("------ MessageImpl dump ------");
        if (this.pkt != null) {
            this.pkt.dump(printStream);
        }
    }

    public String toString() {
        String string = null;
        try {
            string = new StringBuffer().append("\nClass:\t\t\t").append(this.getClass().getName()).append("\ngetJMSMessageID():\t").append(this.getJMSMessageID()).append("\ngetJMSTimestamp():\t").append(Long.toString(this.getJMSTimestamp())).append("\ngetJMSCorrelationID():\t").append(this.getJMSCorrelationID()).append("\nJMSReplyTo:\t\t").append(this.getJMSReplyTo() != null ? ((Destination)this.getJMSReplyTo()).getName() : "null").append("\nJMSDestination:\t\t").append(this.getJMSDestination() != null ? ((Destination)this.getJMSDestination()).getName() : "null").append("\ngetJMSDeliveryMode():\t").append(this.getJMSDeliveryMode() == 2 ? "PERSISTENT" : "NON PERSISTENT").append("\ngetJMSRedelivered():\t").append(Boolean.toString(this.getJMSRedelivered())).append("\ngetJMSType():\t\t").append(this.getJMSType()).append("\ngetJMSExpiration():\t").append(Long.toString(this.getJMSExpiration())).append("\ngetJMSPriority():\t").append(Integer.toString(this.getJMSPriority())).append("\nProperties:\t\t").append(this.properties == null ? "null" : this.properties.toString()).toString();
        }
        catch (JMSException jMSException) {
            jMSException.printStackTrace();
        }
        return string;
    }
}

