/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.Destination;
import com.sun.messaging.jmq.io.PacketType;
import com.sun.messaging.jmq.io.ReadOnlyPacket;
import com.sun.messaging.jmq.io.ReadWritePacket;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsclient.BrowserConsumer;
import com.sun.messaging.jmq.jmsclient.BytesMessageImpl;
import com.sun.messaging.jmq.jmsclient.ConnectionConsumerImpl;
import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.Consumer;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.ExceptionHandler;
import com.sun.messaging.jmq.jmsclient.MapMessageImpl;
import com.sun.messaging.jmq.jmsclient.MessageConsumerImpl;
import com.sun.messaging.jmq.jmsclient.MessageImpl;
import com.sun.messaging.jmq.jmsclient.MessageProducerImpl;
import com.sun.messaging.jmq.jmsclient.ObjectMessageImpl;
import com.sun.messaging.jmq.jmsclient.ProtocolHandler;
import com.sun.messaging.jmq.jmsclient.ReadChannel;
import com.sun.messaging.jmq.jmsclient.ReceiveQueue;
import com.sun.messaging.jmq.jmsclient.RemoteAcknowledgeException;
import com.sun.messaging.jmq.jmsclient.ServerSessionRunner;
import com.sun.messaging.jmq.jmsclient.SessionQueue;
import com.sun.messaging.jmq.jmsclient.SessionReader;
import com.sun.messaging.jmq.jmsclient.StreamMessageImpl;
import com.sun.messaging.jmq.jmsclient.TextMessageImpl;
import com.sun.messaging.jmq.jmsclient.Traceable;
import com.sun.messaging.jmq.jmsclient.Transaction;
import com.sun.messaging.jmq.jmsclient.WriteChannel;
import com.sun.messaging.jmq.jmsclient.XAResourceForRA;
import com.sun.messaging.jms.ra.ManagedConnection;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.BytesMessage;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.ServerSession;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TransactionRolledBackException;

public class SessionImpl
implements Traceable {
    private ServerSessionRunner serverSessionRunner = null;
    private ConnectionConsumerImpl connectionConsumer = null;
    protected ConnectionImpl connection = null;
    protected boolean isTransacted = false;
    protected int acknowledgeMode = 1;
    protected SessionReader sessionReader = null;
    protected SessionQueue sessionQueue = null;
    protected ReadChannel readChannel = null;
    protected Hashtable consumers = new Hashtable();
    protected Vector producers = new Vector();
    protected WriteChannel writeChannel = null;
    protected Long sessionId = null;
    protected ProtocolHandler protocolHandler = null;
    protected Transaction transaction = null;
    protected boolean failoverOccurred = false;
    protected int dupsOkLimit = 10;
    protected boolean isAckLimited = false;
    protected int ackLimit = 100;
    protected int ackCounter = 0;
    protected Vector unAckedMessageQueue = new Vector();
    protected boolean isClosed = false;
    protected boolean isStopped = false;
    protected boolean isXAClosed = false;
    protected boolean isXAInRC = false;
    protected boolean protectMode = false;
    protected Hashtable browserConsumers = new Hashtable();
    ReadWritePacket ackPkt = new ReadWritePacket();
    ByteArrayOutputStream bos = new ByteArrayOutputStream(36);
    DataOutputStream dos = new DataOutputStream(this.bos);
    ReadWritePacket expirePkt = new ReadWritePacket();
    ByteArrayOutputStream expireBos = new ByteArrayOutputStream(36);
    DataOutputStream expireDos = new DataOutputStream(this.expireBos);
    protected boolean setJMSXConsumerTXID = false;
    protected boolean debug = Debug.debug;
    private Object syncObject = new Object();
    private boolean inSyncState = false;
    private int inSyncStateOperation = 0;
    private static final int INSYNCSTATE_NOTSET = 0;
    private static final int INSYNCSTATE_CLOSING = 1;
    private static final int INSYNCSTATE_OTHER = 2;
    private Object sessionSyncObj = new Object();
    protected boolean xaTxnMode = false;
    private Object raEndpointSyncObj = new Object();
    private ManagedConnection mc = null;
    private boolean isDedicatedToServerSession = false;
    private long brokerSessionID = -1L;
    private int TEST_ackCount = 0;
    private int TEST_rxCount = 0;
    protected boolean dupsOkAckOnEmptyQueue = false;
    protected boolean dupsOkAckOnLimit = false;
    protected boolean dupsOkAckOnTimeout = false;
    protected long dupsOkAckTimeout = 0L;
    protected long dupsOkTimestamp = 0L;
    protected Object dupsOkSyncObj = new Object();
    protected boolean allowExtensions = false;
    private volatile boolean inResetState = false;
    public static final String SESSION_LOGGER_NAME = "javax.jms.session";
    protected static final Logger sessionLogger = Logger.getLogger("javax.jms.session", "com.sun.messaging.jmq.jmsclient.resources.ClientResources");
    protected volatile boolean remore_broker_failed = false;
    protected volatile boolean isRollbackOnly = false;
    protected Throwable rollbackCause = null;
    public static boolean autoStartTxn = Boolean.getBoolean("imq.autoStartTxn");
    public static boolean noBlockUntilTxnCompletes = Boolean.getBoolean("imq.noBlockUntilTxnCompletes");
    public static boolean noBlockOnAutoAckNPTopics = Boolean.getBoolean("imq.noBlockOnAutoAckNPTopics");
    private ThreadLocal<Boolean> isMessageListener = new ThreadLocal();

    protected SessionImpl() {
    }

    public SessionImpl(ConnectionImpl connectionImpl) throws JMSException {
        this(connectionImpl, false, 1, false, null);
    }

    public SessionImpl(ConnectionImpl connectionImpl, boolean bl, int n) throws JMSException {
        this(connectionImpl, bl, n, false, null);
    }

    public SessionImpl(ConnectionImpl connectionImpl, boolean bl, int n, ManagedConnection managedConnection) throws JMSException {
        this(connectionImpl, bl, n, false, managedConnection);
    }

    public SessionImpl(ConnectionImpl connectionImpl, int n) throws JMSException {
        this(connectionImpl, false, n, true, null);
    }

    public SessionImpl(ConnectionImpl connectionImpl, boolean bl, int n, boolean bl2, ManagedConnection managedConnection) throws JMSException {
        try {
            this.sessionQueue = new SessionQueue();
            this.sessionQueue.validateQueue();
            this.allowExtensions = bl2;
            this.connection = connectionImpl;
            if (!bl) {
                if (n == 0) {
                    n = 1;
                }
                this.checkAckMode(n);
            }
            this.writeChannel = connectionImpl.getWriteChannel();
            this.readChannel = connectionImpl.getReadChannel();
            this.protocolHandler = connectionImpl.getProtocolHandler();
            this.isTransacted = bl;
            this.acknowledgeMode = n;
            this.sessionId = connectionImpl.getNextSessionId();
            if (managedConnection != null) {
                this.mc = managedConnection;
            }
            this.init();
            this.logLifeCycle("I200");
        }
        catch (JMSException jMSException) {
            ExceptionHandler.throwJMSException(jMSException);
        }
    }

    private void checkAckMode(int n) throws JMSException {
        if (n != 1 && n != 2 && n != 3) {
            if (this.allowExtensions && n == 32768) {
                if (this.connection.getBrokerProtocolLevel() <= 350) {
                    String string = AdministeredObject.cr.getKString("C4092", this.connection.getBrokerVersion());
                    com.sun.messaging.jms.JMSException jMSException = new com.sun.messaging.jms.JMSException(string, "C4092");
                    ExceptionHandler.throwJMSException(jMSException);
                }
                return;
            }
            String string = String.valueOf(n);
            String string2 = AdministeredObject.cr.getKString("C4067", string);
            JMSException jMSException = new JMSException(string2, "C4067");
            ExceptionHandler.throwJMSException(jMSException);
        }
    }

    private void init() throws JMSException {
        this.serverSessionRunner = new ServerSessionRunner(this, null);
        if (this.connection.getBrokerProtocolLevel() >= 350) {
            this.protocolHandler.createSession(this);
        }
        if (this.isTransacted) {
            if (this.mc == null) {
                this.transaction = new Transaction(this, true);
            } else {
                this.transaction = new Transaction(this, false);
                if (this.mc.xaTransactionStarted()) {
                    this.transaction.setTransactionID(this.mc.getTransactionID());
                    this.xaTxnMode = true;
                }
            }
        }
        if (this.connection.getIsStopped()) {
            this.sessionQueue.setIsLocked(true);
        }
        this.connection.addToReadQTable(this.sessionId, this.sessionQueue);
        this.connection.addSession(this);
        this.dupsOkLimit = this.connection.getDupsOkLimit();
        this.isAckLimited = this.connection.getIsAckLimited();
        this.ackLimit = this.connection.getAckLimit();
        this.setJMSXConsumerTXID = this.connection.connectionMetaData.setJMSXConsumerTXID && this.isTransacted;
        this.protectMode = this.connection.getProtectMode();
        this.isDedicatedToServerSession = this.connection.getIsDedicatedToConnectionConsumer();
        this.dupsOkInit();
        this.sessionReader = new SessionReader(this);
        if (this.isDedicatedToServerSession) {
            this.sessionReader.close();
        } else {
            this.sessionReader.start();
        }
    }

    protected void dupsOkInit() {
        if (!this.isTransacted && this.acknowledgeMode == 3) {
            if (this.isDedicatedToServerSession) {
                this.dupsOkAckOnEmptyQueue = true;
            } else {
                this.dupsOkAckOnEmptyQueue = this.connection.dupsOkAckOnEmptyQueue;
                if (!this.dupsOkAckOnEmptyQueue) {
                    this.dupsOkAckTimeout = this.connection.dupsOkAckTimeout;
                    if (this.dupsOkAckTimeout > 0L) {
                        this.dupsOkAckOnTimeout = true;
                    } else {
                        this.dupsOkAckOnLimit = true;
                        this.dupsOkAckTimeout = 0L;
                    }
                }
            }
        }
        if (this.debug) {
            if (this.dupsOkAckOnTimeout || this.dupsOkAckOnEmptyQueue || this.dupsOkAckOnLimit) {
                Debug.println("*** dupsOkAckOnEmptyQueue: " + this.dupsOkAckOnEmptyQueue);
                Debug.println("*** dupsOkAckOnTimeout: " + this.dupsOkAckOnTimeout);
                Debug.println("*** dupsOkAckTimeout: " + this.dupsOkAckTimeout);
                Debug.println("*** dupsOkAckOnLimit: " + this.dupsOkAckOnLimit);
            } else {
                Debug.println("*** Session ackMode:  " + this.acknowledgeMode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void switchOnXATransaction() throws JMSException {
        if (this.xaTxnMode) {
            return;
        }
        if (this.isTransacted) {
            this.setInSyncState();
            try {
                this.receiveRollback();
                this.transaction.rollbackToXA();
                Object var2_1 = null;
                this.releaseInSyncState();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.releaseInSyncState();
                throw throwable;
            }
        }
        if (this.transaction == null) {
            this.transaction = new Transaction(this, false);
            this.isTransacted = true;
            this.setJMSXConsumerTXID = this.connection.connectionMetaData.setJMSXConsumerTXID;
        }
        this.xaTxnMode = true;
    }

    protected void switchOffXATransaction() {
        this.xaTxnMode = false;
        this.isTransacted = false;
        this.transaction = null;
    }

    protected void addMessageConsumer(MessageConsumerImpl messageConsumerImpl) throws JMSException {
        this.consumers.put(messageConsumerImpl.interestId, messageConsumerImpl);
    }

    protected void checkBrowserCreation() throws JMSException {
        if (this.isDedicatedToServerSession) {
            this.checkConsumerCreation();
        }
    }

    protected void checkConsumerCreation() throws JMSException {
        if (this.isDedicatedToServerSession || this.serverSessionRunner.getMessageListener() != null) {
            String string = AdministeredObject.cr.getKString("C4031");
            IllegalStateException illegalStateException = new IllegalStateException(string, "C4031");
            ExceptionHandler.throwJMSException(illegalStateException);
        }
    }

    protected void removeMessageConsumer(MessageConsumerImpl messageConsumerImpl) {
        this.consumers.remove(messageConsumerImpl.interestId);
    }

    protected MessageConsumerImpl getMessageConsumer(Object object) {
        return (MessageConsumerImpl)this.consumers.get(object);
    }

    protected void addBrowserConsumer(BrowserConsumer browserConsumer) {
        browserConsumer.getBrowser().addBrowserConsumer(browserConsumer);
        this.browserConsumers.put(browserConsumer.interestId, browserConsumer);
    }

    protected void removeBrowserConsumer(BrowserConsumer browserConsumer) {
        this.browserConsumers.remove(browserConsumer.interestId);
        browserConsumer.getBrowser().removeBrowserConsumer(browserConsumer);
    }

    protected BrowserConsumer getBrowserConsumer(Object object) {
        return (BrowserConsumer)this.browserConsumers.get(object);
    }

    protected void addMessageProducer(MessageProducerImpl messageProducerImpl) {
        this.producers.add(messageProducerImpl);
    }

    protected void removeMessageProducer(MessageProducerImpl messageProducerImpl) {
        this.producers.remove(messageProducerImpl);
    }

    protected void verifyDestination(javax.jms.Destination destination, String string, boolean bl) throws JMSException {
        this.protocolHandler.verifyDestination(destination, string, bl);
    }

    protected SysMessageID[] getMessageIdSet(Consumer consumer) throws JMSException {
        return this.protocolHandler.browse(consumer);
    }

    protected boolean requestMessages(ByteArrayOutputStream byteArrayOutputStream, BrowserConsumer browserConsumer) throws JMSException {
        return this.protocolHandler.deliver(byteArrayOutputStream, browserConsumer);
    }

    protected ProtocolHandler getProtocolHandler() {
        return this.connection.getProtocolHandler();
    }

    protected Long getSessionId() {
        return this.sessionId;
    }

    protected ConnectionImpl getConnection() {
        return this.connection;
    }

    protected void writeJMSMessage(Message message) throws JMSException {
        if (this.isClosed) {
            String string = AdministeredObject.cr.getKString("C4059");
            IllegalStateException illegalStateException = new IllegalStateException(string, "C4059");
            ExceptionHandler.throwJMSException(illegalStateException);
        }
        if (this.isTransacted) {
            this.checkFailOver();
            this.transaction.send(message);
        } else {
            this.writeChannel.writeJMSMessage(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _stopFromRA() throws JMSException {
        Object object = this.raEndpointSyncObj;
        synchronized (object) {
            this.stop(false);
        }
    }

    protected void stop() throws JMSException {
        this.stop(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stop(boolean bl) throws JMSException {
        if (this.isStopped || this.isClosed) {
            return;
        }
        this.checkPermission();
        Object object = this.sessionSyncObj;
        synchronized (object) {
            this.sessionQueue.stop(bl);
            this.serverSessionRunner.serverSessionStop();
            MessageConsumerImpl[] messageConsumerImplArray = this.consumers.values().toArray(new MessageConsumerImpl[0]);
            for (int i = 0; i < messageConsumerImplArray.length; ++i) {
                if (bl) {
                    messageConsumerImplArray[i].stop();
                    continue;
                }
                messageConsumerImplArray[i].stopNoWait();
            }
            this.isStopped = true;
        }
    }

    protected void setConnectionConsumer(ConnectionConsumerImpl connectionConsumerImpl) {
        this.connectionConsumer = connectionConsumerImpl;
    }

    protected void resetServerSessionRunner() {
        this.resetServerSessionRunner(true);
    }

    protected void resetServerSessionRunner(boolean bl) {
        ServerSessionRunner serverSessionRunner = this.serverSessionRunner;
        if (serverSessionRunner != null) {
            serverSessionRunner.reset(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reset() throws JMSException {
        try {
            this.sessionQueue.clear();
            MessageConsumerImpl messageConsumerImpl = null;
            Enumeration enumeration = this.consumers.elements();
            while (enumeration.hasMoreElements()) {
                messageConsumerImpl = (MessageConsumerImpl)enumeration.nextElement();
                messageConsumerImpl.receiveQueue.clear();
            }
            if (this.unAckedMessageQueue != null) {
                this.unAckedMessageQueue.removeAllElements();
            }
            this.consumers.clear();
            this.remore_broker_failed = false;
            if (this.serverSessionRunner != null) {
                this.serverSessionRunner.reset();
            }
            this.closeBrowserConsumers();
            Object var4_3 = null;
            this.sessionQueue.start();
            this.isStopped = false;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.sessionQueue.start();
            this.isStopped = false;
            throw throwable;
        }
    }

    protected void recreateSession() throws JMSException {
        if (this.connection.getBrokerProtocolLevel() >= 350) {
            this.protocolHandler.createSession(this);
        }
        if (this.isTransacted && !this.connection.isConnectedToHABroker) {
            this.transaction = new Transaction(this, true);
        }
        this.failoverOccurred = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start() throws JMSException {
        Object object = this.sessionSyncObj;
        synchronized (object) {
            this.sessionQueue.start();
            this.serverSessionRunner.serverSessionRun();
            MessageConsumerImpl[] messageConsumerImplArray = this.consumers.values().toArray(new MessageConsumerImpl[0]);
            for (int i = 0; i < messageConsumerImplArray.length; ++i) {
                messageConsumerImplArray[i].start();
            }
            this.isStopped = false;
        }
    }

    protected void checkPermission() throws JMSException {
        if (Thread.currentThread() == this.sessionReader.sessionThread || Thread.currentThread() == this.serverSessionRunner.getCurrentThread()) {
            String string = AdministeredObject.cr.getKString("C4049");
            IllegalStateException illegalStateException = new IllegalStateException(string, "C4049");
            ExceptionHandler.throwJMSException(illegalStateException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledgeUndeliverableFromRAEndpoint(MessageImpl messageImpl, XAResourceForRA xAResourceForRA, boolean bl) throws JMSException {
        Object object = this.raEndpointSyncObj;
        synchronized (object) {
            this.readChannel.flowControl.messageDelivered();
            Consumer consumer = (Consumer)this.consumers.get(new Long(messageImpl.getInterestID()));
            this.readChannel.flowControl.messageDelivered(consumer);
            ++this.TEST_rxCount;
            try {
                this.setInSyncState();
                if (xAResourceForRA != null && xAResourceForRA.started()) {
                    XAResourceForRA xAResourceForRA2 = xAResourceForRA;
                    synchronized (xAResourceForRA2) {
                        this.ackPkt.setTransactionID(xAResourceForRA.getTransactionID());
                    }
                } else {
                    this.ackPkt.setTransactionID(0L);
                }
                this.writeMessageID(messageImpl);
                this.doAcknowledgeUndeliverable(true, bl);
                Object var9_8 = null;
                this.releaseInSyncState();
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                this.releaseInSyncState();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledgeFromRAEndpoint(MessageImpl messageImpl, XAResourceForRA xAResourceForRA) throws JMSException {
        Object object = this.raEndpointSyncObj;
        synchronized (object) {
            if (sessionLogger.isLoggable(Level.FINER)) {
                this.logMessageDelivered(messageImpl);
            }
            this.readChannel.flowControl.messageDelivered();
            Consumer consumer = (Consumer)this.consumers.get(new Long(messageImpl.getInterestID()));
            this.readChannel.flowControl.messageDelivered(consumer);
            ++this.TEST_rxCount;
            boolean bl = true;
            try {
                this.setInSyncState();
                if (xAResourceForRA != null && xAResourceForRA.started()) {
                    XAResourceForRA xAResourceForRA2 = xAResourceForRA;
                    synchronized (xAResourceForRA2) {
                        this.ackPkt.setTransactionID(xAResourceForRA.getTransactionID());
                    }
                    bl = !noBlockUntilTxnCompletes;
                } else {
                    this.ackPkt.setTransactionID(0L);
                }
                this.writeMessageID(messageImpl);
                this.doAcknowledge(bl);
                Object var9_8 = null;
                this.releaseInSyncState();
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                this.releaseInSyncState();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledgeFromRAEndpoint(MessageImpl messageImpl) throws JMSException {
        Object object = this.raEndpointSyncObj;
        synchronized (object) {
            this.acknowledge(messageImpl);
        }
    }

    public void _appTransactedAck(MessageImpl messageImpl) throws JMSException {
        Consumer consumer = (Consumer)this.consumers.get(new Long(messageImpl.getInterestID()));
        if (consumer == null) {
            String string = AdministeredObject.cr.getKString("C4063");
            throw new JMSException(string, "C4063");
        }
        if (!(consumer instanceof MessageConsumerImpl)) {
            throw new JMSException("Operation not supported for consumer type: " + consumer.getClass().getName());
        }
        this.acknowledge(messageImpl);
        ((MessageConsumerImpl)consumer).lastDeliveredID = messageImpl.getMessageID();
    }

    protected void doPrefetch(Consumer consumer) {
        this.readChannel.flowControl.messageDelivered();
        this.readChannel.flowControl.messageDelivered(consumer);
        ++this.TEST_rxCount;
    }

    protected void acknowledge(MessageImpl messageImpl) throws JMSException {
        this.acknowledge(messageImpl, true);
    }

    /*
     * Unable to fully structure code
     */
    protected void acknowledge(MessageImpl var1_1, boolean var2_2) throws JMSException {
        if (SessionImpl.sessionLogger.isLoggable(Level.FINER)) {
            this.logMessageDelivered(var1_1);
        }
        if (var2_2) {
            this.readChannel.flowControl.messageDelivered();
        }
        if ((var3_3 = (Consumer)this.consumers.get(new Long(var1_1.getInterestID()))) == null) {
            var3_3 = this.connection.interestTable.getConsumer(new Long(var1_1.getInterestID()));
        }
        if (var2_2) {
            this.readChannel.flowControl.messageDelivered(var3_3);
            ++this.TEST_rxCount;
        }
        try {
            block17: {
                try {
                    this.setInSyncState();
                    if (this.isTransacted) {
                        this.transactedAcknowledge(var1_1);
                        break block17;
                    }
                    switch (this.acknowledgeMode) {
                        case 1: {
                            this.autoAcknowledge(var1_1);
                            ** break;
                        }
                        case 2: {
                            this.prepareClientAcknowledge(var1_1);
                            ** break;
                        }
                        case 3: {
                            if (this.dupsOkAckOnTimeout) {
                                this.syncedDupsOkAcknowledge(var1_1);
                                ** break;
                            }
                            this.dupsOkAcknowledge(var1_1);
                            ** break;
                        }
                        case 32768: {
                            ** break;
                        }
                        default: {
                            this.autoAcknowledge(var1_1);
                        }
                    }
                }
                catch (JMSException var4_6) {
                    if (!this.isTransacted && (this.acknowledgeMode == 1 || this.acknowledgeMode == 3) && this.isRemoteException(var4_6)) {
                        this.recreateConsumers();
                        ExceptionHandler.throwRemoteAcknowledgeException(var4_6, "C4107");
                    }
                    throw var4_6;
                }
lbl38:
                // 6 sources

            }
            var6_4 = null;
            this.releaseInSyncState();
        }
        catch (Throwable var5_7) {
            var6_5 = null;
            this.releaseInSyncState();
            throw var5_7;
        }
    }

    protected void acknowledgeExpired(MessageImpl messageImpl) throws JMSException {
        this.acknowledgeExpired(messageImpl, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void acknowledgeExpired(MessageImpl messageImpl, boolean bl) throws JMSException {
        Object object = this.raEndpointSyncObj;
        synchronized (object) {
            Consumer consumer;
            if (sessionLogger.isLoggable(Level.FINER)) {
                this.logMessageExpired(messageImpl);
            }
            if (bl) {
                this.readChannel.flowControl.messageDelivered();
            }
            if ((consumer = (Consumer)this.consumers.get(new Long(messageImpl.getInterestID()))) == null) {
                consumer = this.connection.interestTable.getConsumer(new Long(messageImpl.getInterestID()));
            }
            if (bl) {
                this.readChannel.flowControl.messageDelivered(consumer);
                ++this.TEST_rxCount;
            }
            try {
                try {
                    this.expireDos.writeLong(messageImpl.getInterestID());
                    messageImpl.getMessageID().writeID(this.expireDos);
                    this.expireDos.flush();
                    this.expireBos.flush();
                    this.expirePkt.setMessageBody(this.expireBos.toByteArray());
                    this.ackPkt.setSendAcknowledge(false);
                    this.protocolHandler.acknowledgeExpired(this.expirePkt, true);
                }
                catch (Exception exception) {
                    String string = "";
                    try {
                        string = consumer != null ? consumer.getDestName() : messageImpl.getJMSDestination().toString();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    Object[] objectArray = new Object[]{messageImpl.getMessageID(), string, messageImpl.getInterestID(), exception.getMessage()};
                    String string2 = AdministeredObject.cr.getKString("C4304", objectArray);
                    JMSException jMSException = new JMSException(string2, "C4304");
                    jMSException.setLinkedException(exception);
                    throw jMSException;
                }
                Object var11_5 = null;
                this.expireBos.reset();
            }
            catch (Throwable throwable) {
                Object var11_6 = null;
                this.expireBos.reset();
                throw throwable;
            }
        }
    }

    private void logMessageExpired(MessageImpl messageImpl) {
        this.logMessage(messageImpl, "I303");
    }

    private void logMessageDelivered(MessageImpl messageImpl) {
        this.logMessage(messageImpl, "I302");
    }

    private void logMessage(MessageImpl messageImpl, String string) {
        try {
            if (sessionLogger.isLoggable(Level.FINER)) {
                String string2 = this.makeDebugStringForMessage(messageImpl);
                sessionLogger.log(Level.FINER, string, string2);
                if (sessionLogger.isLoggable(Level.FINEST)) {
                    string2 = "MQTrace=MessageConsumer, ConsumerID=" + messageImpl.getInterestID() + ", Message=" + messageImpl.toString();
                    sessionLogger.log(Level.FINEST, string, string2);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String makeDebugStringForMessage(MessageImpl messageImpl) {
        try {
            Destination destination = (Destination)messageImpl.getJMSDestination();
            String string = destination.isQueue() ? "Queue:" : "Topic:";
            String string2 = PacketType.getString(messageImpl.getPacket().getPacketType());
            return "MQTrace=MessageConsumer, ThreadID=" + Thread.currentThread().getId() + ", ClientID=" + this.connection.getClientID() + ", ConnectionID=" + this.connection.getConnectionID() + ", SessionID=" + this.getBrokerSessionID() + ", ConsumerID=" + messageImpl.getInterestID() + ", Destination=" + string + destination.getName() + ", MessageID=" + messageImpl.getJMSMessageID() + ", MessageType=" + string2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "[MessageID=" + messageImpl.getMessageID() + ", ConsumerID=" + messageImpl.getInterestID() + "]";
        }
    }

    protected void autoAcknowledge(MessageImpl messageImpl) throws JMSException {
        this.writeMessageID(messageImpl);
        boolean bl = true;
        if (noBlockOnAutoAckNPTopics) {
            javax.jms.Destination destination = messageImpl.getJMSDestination();
            if (!messageImpl._getPersistent() && destination instanceof Topic) {
                bl = false;
            }
        }
        this.doAcknowledge(bl);
    }

    protected void transactedAcknowledge(MessageImpl messageImpl) throws JMSException {
        try {
            boolean bl = this.prepareTransactedAcknowledge(messageImpl);
            if (bl) {
                this.ackPkt.setTransactionID(this.transaction.getTransactionID());
                this.writeMessageID(messageImpl);
                boolean bl2 = !noBlockUntilTxnCompletes;
                this.doAcknowledge(bl2);
            }
        }
        catch (JMSException jMSException) {
            if (jMSException instanceof RemoteAcknowledgeException) {
                this.remore_broker_failed = true;
            }
            throw jMSException;
        }
    }

    protected void writeMessageID(MessageImpl messageImpl) throws JMSException {
        try {
            this.dos.writeLong(messageImpl.getInterestID());
            messageImpl.getMessageID().writeID(this.dos);
        }
        catch (IOException iOException) {
            ExceptionHandler.handleException((Exception)iOException, "C4038");
        }
    }

    protected void writeMessageID(UnAckedMessage unAckedMessage) throws JMSException {
        try {
            this.dos.writeLong(unAckedMessage.getConsumerID());
            unAckedMessage.getMessageID().writeID(this.dos);
        }
        catch (IOException iOException) {
            ExceptionHandler.handleException((Exception)iOException, "C4038");
        }
    }

    protected void writeMessageID(ReadOnlyPacket readOnlyPacket) throws JMSException {
        try {
            this.dos.writeLong(readOnlyPacket.getConsumerID());
            readOnlyPacket.getSysMessageID().writeID(this.dos);
        }
        catch (IOException iOException) {
            ExceptionHandler.handleException((Exception)iOException, "C4038");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAcknowledgeUndeliverable(boolean bl, boolean bl2) throws JMSException {
        try {
            try {
                this.dos.flush();
                this.bos.flush();
                this.ackPkt.setMessageBody(this.bos.toByteArray());
                this.ackPkt.setSendAcknowledge(bl);
                this.protocolHandler.acknowledgeUndeliverable(this.ackPkt, bl2);
                ++this.TEST_ackCount;
            }
            catch (IOException iOException) {
                ExceptionHandler.handleException((Exception)iOException, "C4016");
                Object var5_4 = null;
                this.bos.reset();
                this.ackCounter = 0;
                this.dupsOkTimestamp = 0L;
            }
            Object var5_3 = null;
            this.bos.reset();
            this.ackCounter = 0;
            this.dupsOkTimestamp = 0L;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.bos.reset();
            this.ackCounter = 0;
            this.dupsOkTimestamp = 0L;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAcknowledge(boolean bl) throws JMSException {
        try {
            try {
                this.dos.flush();
                this.bos.flush();
                this.ackPkt.setMessageBody(this.bos.toByteArray());
                this.ackPkt.setSendAcknowledge(bl);
                this.checkFailOver();
                this.protocolHandler.acknowledge(this.ackPkt);
                ++this.TEST_ackCount;
            }
            catch (IOException iOException) {
                ExceptionHandler.handleException((Exception)iOException, "C4016");
                Object var4_3 = null;
                this.bos.reset();
                this.ackCounter = 0;
                this.dupsOkTimestamp = 0L;
            }
            Object var4_2 = null;
            this.bos.reset();
            this.ackCounter = 0;
            this.dupsOkTimestamp = 0L;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.bos.reset();
            this.ackCounter = 0;
            this.dupsOkTimestamp = 0L;
            throw throwable;
        }
    }

    protected void dupsOkAcknowledge(MessageImpl messageImpl) throws JMSException {
        this.addMessageToAckList(messageImpl);
        if (this.dupsOkShouldAcknowledge()) {
            this.dupsOkCommitAcknowledge();
        }
    }

    protected void dupsOkCommitAcknowledge() throws JMSException {
        if (this.debug) {
            Debug.println("***** dups ok committing ack .... size: " + this.ackCounter);
        }
        this.dequeueUnAckedMessages();
        this.doAcknowledge(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void syncedDupsOkAcknowledge(MessageImpl messageImpl) throws JMSException {
        Object object = this.dupsOkSyncObj;
        synchronized (object) {
            if (this.ackCounter == 0) {
                this.dupsOkTimestamp = System.currentTimeMillis();
            }
            this.dupsOkAcknowledge(messageImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void syncedDupsOkCommitAcknowledge() throws JMSException {
        Object object = this.dupsOkSyncObj;
        synchronized (object) {
            if (this.ackCounter > 0) {
                this.dupsOkCommitAcknowledge();
            }
        }
    }

    protected boolean dupsOkShouldAcknowledge() {
        if (this.dupsOkAckOnTimeout) {
            boolean bl = System.currentTimeMillis() - this.dupsOkTimestamp >= this.dupsOkAckTimeout;
            return this.ackCounter == this.dupsOkLimit || bl;
        }
        if (this.dupsOkAckOnEmptyQueue) {
            return this.ackCounter == this.dupsOkLimit || this.sessionQueue.isEmpty();
        }
        return this.ackCounter == this.dupsOkLimit;
    }

    protected boolean addMessageToAckList(MessageImpl messageImpl) throws JMSException {
        boolean bl = false;
        if (messageImpl != null && !messageImpl.getIsOnAckList()) {
            messageImpl.setIsOnAckList(true);
            UnAckedMessage unAckedMessage = new UnAckedMessage(messageImpl);
            this.unAckedMessageQueue.addElement(unAckedMessage);
            ++this.ackCounter;
            bl = true;
        }
        return bl;
    }

    protected void removeMessageFromAckList(UnAckedMessage unAckedMessage) {
        this.unAckedMessageQueue.removeElement(unAckedMessage);
        --this.ackCounter;
    }

    protected void prepareClientAcknowledge(MessageImpl messageImpl) throws JMSException {
        this.addMessageToAckList(messageImpl);
        if (this.isAckLimited) {
            this.checkClientAckLimit();
        }
    }

    protected void checkClientAckLimit() throws JMSException {
        if (this.ackCounter > this.ackLimit) {
            String string = AdministeredObject.cr.getKString("C4023");
            Debug.println(string);
        }
    }

    protected boolean prepareTransactedAcknowledge(MessageImpl messageImpl) throws JMSException {
        boolean bl = false;
        bl = this.addMessageToAckList(messageImpl);
        if (this.isAckLimited) {
            this.checkTransactedAckLimit();
        }
        return bl;
    }

    protected void checkTransactedAckLimit() throws JMSException {
        if (this.ackCounter > this.ackLimit) {
            String string = AdministeredObject.cr.getKString("C4026");
            Debug.println(string);
        }
    }

    protected void clientAcknowledge(MessageImpl messageImpl) throws JMSException {
        if (this.failoverOccurred) {
            String string = AdministeredObject.cr.getKString("C4075");
            JMSException jMSException = new JMSException(string, "C4075");
            ExceptionHandler.throwJMSException(jMSException);
        }
        this.checkClientAckMessage(messageImpl);
        this.checkSessionState();
        if (!this.isTransacted) {
            this.prepareClientAcknowledge(messageImpl);
            if (this.unAckedMessageQueue.size() > 0) {
                this.dequeueUnAckedMessages();
                this.doClientAcknowledge();
            }
        }
    }

    protected void clientAcknowledgeThisMessage(MessageImpl messageImpl) throws JMSException {
        this.checkClientAckMessage(messageImpl);
        this.checkSessionState();
        if (!this.isTransacted) {
            this.prepareClientAcknowledge(messageImpl);
            UnAckedMessage unAckedMessage = null;
            for (int i = 0; i < this.unAckedMessageQueue.size(); ++i) {
                unAckedMessage = (UnAckedMessage)this.unAckedMessageQueue.elementAt(i);
                if (!messageImpl.messageID.equals(unAckedMessage.getMessageID())) continue;
                this.writeMessageID(unAckedMessage);
                this.unAckedMessageQueue.removeElementAt(i);
                this.doClientAcknowledge();
                return;
            }
        }
    }

    protected void clientAcknowledgeUpThroughThisMessage(MessageImpl messageImpl) throws JMSException {
        Object object;
        if (this.failoverOccurred) {
            object = AdministeredObject.cr.getKString("C4075");
            JMSException jMSException = new JMSException((String)object, "C4075");
            ExceptionHandler.throwJMSException(jMSException);
        }
        this.checkClientAckMessage(messageImpl);
        this.checkSessionState();
        if (!this.isTransacted) {
            this.prepareClientAcknowledge(messageImpl);
            if (this.isMessageInUnAckedQueue(messageImpl)) {
                object = null;
                boolean bl = false;
                while (!bl) {
                    object = (UnAckedMessage)this.unAckedMessageQueue.firstElement();
                    this.writeMessageID((UnAckedMessage)object);
                    this.unAckedMessageQueue.removeElementAt(0);
                    if (!messageImpl.messageID.equals(((UnAckedMessage)object).getMessageID())) continue;
                    bl = true;
                }
                this.doClientAcknowledge();
            }
        }
    }

    private void doClientAcknowledge() throws JMSException {
        if (this.remore_broker_failed) {
            ExceptionHandler.throwRemoteAcknowledgeException(null, "C4108");
        }
        try {
            this.doAcknowledge(true);
        }
        catch (JMSException jMSException) {
            if (this.isRemoteException(jMSException)) {
                this.remore_broker_failed = true;
                ExceptionHandler.throwRemoteAcknowledgeException(jMSException, "C4108");
            }
            throw jMSException;
        }
    }

    protected boolean isMessageInUnAckedQueue(MessageImpl messageImpl) throws JMSException {
        boolean bl = false;
        UnAckedMessage unAckedMessage = null;
        int n = this.unAckedMessageQueue.size();
        for (int i = 0; i < n; ++i) {
            unAckedMessage = (UnAckedMessage)this.unAckedMessageQueue.elementAt(i);
            if (!messageImpl.messageID.equals(unAckedMessage.getMessageID())) continue;
            bl = true;
            i = n;
        }
        return bl;
    }

    protected void checkSessionState() throws JMSException {
        if (this.isClosed) {
            String string = AdministeredObject.cr.getKString("C4059");
            IllegalStateException illegalStateException = new IllegalStateException(string, "C4059");
            ExceptionHandler.throwJMSException(illegalStateException);
        }
    }

    protected void checkFailOver() throws JMSException {
        if (this.isTransacted && this.failoverOccurred) {
            String string = AdministeredObject.cr.getKString("C4103");
            JMSException jMSException = new JMSException(string, "C4103");
            ExceptionHandler.throwJMSException(jMSException);
        }
    }

    public BytesMessage createBytesMessage() throws JMSException {
        this.checkSessionState();
        return new BytesMessageImpl(true);
    }

    public MapMessage createMapMessage() throws JMSException {
        this.checkSessionState();
        return new MapMessageImpl();
    }

    public Message createMessage() throws JMSException {
        this.checkSessionState();
        MessageImpl messageImpl = new MessageImpl();
        return messageImpl;
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        this.checkSessionState();
        return new ObjectMessageImpl();
    }

    public ObjectMessage createObjectMessage(Serializable serializable) throws JMSException {
        this.checkSessionState();
        ObjectMessageImpl objectMessageImpl = new ObjectMessageImpl();
        objectMessageImpl.setObject(serializable);
        return objectMessageImpl;
    }

    public StreamMessage createStreamMessage() throws JMSException {
        this.checkSessionState();
        return new StreamMessageImpl(true);
    }

    public TextMessage createTextMessage() throws JMSException {
        this.checkSessionState();
        return new TextMessageImpl();
    }

    public TextMessage createTextMessage(String string) throws JMSException {
        this.checkSessionState();
        TextMessageImpl textMessageImpl = new TextMessageImpl();
        textMessageImpl.setText(string);
        return textMessageImpl;
    }

    public boolean getTransacted() throws JMSException {
        this.checkSessionState();
        return this.isTransacted;
    }

    public int getAcknowledgeMode() throws JMSException {
        this.checkSessionState();
        if (this.isTransacted) {
            return 0;
        }
        return this.acknowledgeMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws JMSException {
        JMSException jMSException;
        Object object;
        this.checkSessionState();
        if (!this.isTransacted) {
            object = AdministeredObject.cr.getKString("C4024");
            jMSException = new IllegalStateException((String)object, "C4024");
            ExceptionHandler.throwJMSException(jMSException);
        }
        if (this.failoverOccurred) {
            this.rollback();
            object = AdministeredObject.cr.getKString("C4074");
            jMSException = new TransactionRolledBackException((String)object, "C4074");
            ExceptionHandler.throwJMSException(jMSException);
        }
        if (this.isRollbackOnly) {
            if (this.rollbackCause instanceof Exception) {
                ExceptionHandler.handleException((Exception)this.rollbackCause, "C4038");
            } else {
                object = new Exception(this.rollbackCause);
                ExceptionHandler.handleException((Exception)object, "C4038");
            }
        }
        this.setInSyncState();
        try {
            try {
                this.receiveCommit();
                this.transaction.commit();
            }
            catch (JMSException jMSException2) {
                if (!this.isRemoteException(jMSException2)) {
                    throw jMSException2;
                }
                this.doRemoteFailedRollback(jMSException2);
                Object var4_5 = null;
                this.releaseInSyncState();
            }
            Object var4_4 = null;
            this.releaseInSyncState();
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.releaseInSyncState();
            throw throwable;
        }
    }

    protected void doRemoteFailedRollback(JMSException jMSException) throws JMSException {
        this.recreateConsumers();
        String string = AdministeredObject.cr.getKString("C4109");
        com.sun.messaging.jms.TransactionRolledBackException transactionRolledBackException = new com.sun.messaging.jms.TransactionRolledBackException(string, "C4109");
        ((JMSException)transactionRolledBackException).setLinkedException(jMSException);
        ExceptionHandler.throwJMSException(transactionRolledBackException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws JMSException {
        this.checkSessionState();
        if (!this.isTransacted) {
            String string = AdministeredObject.cr.getKString("C4024");
            IllegalStateException illegalStateException = new IllegalStateException(string, "C4024");
            ExceptionHandler.throwJMSException(illegalStateException);
        }
        this.setInSyncState();
        try {
            if (this.remore_broker_failed) {
                this.recreateConsumers();
                this.remore_broker_failed = false;
                Object var4_3 = null;
                this.isRollbackOnly = false;
                this.rollbackCause = null;
                this.failoverOccurred = false;
                this.releaseInSyncState();
                return;
            }
            if (this.connection.isConnectedToHABroker) {
                this.rollbackHATransaction();
            } else {
                this.receiveRollback();
                this.transaction.rollback();
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.isRollbackOnly = false;
            this.rollbackCause = null;
            this.failoverOccurred = false;
            this.releaseInSyncState();
            throw throwable;
        }
        Object var4_4 = null;
        this.isRollbackOnly = false;
        this.rollbackCause = null;
        this.failoverOccurred = false;
        this.releaseInSyncState();
    }

    private void rollbackHATransaction() throws JMSException {
        try {
            this.receiveRollback();
            this.transaction.rollback();
        }
        catch (JMSException jMSException) {
            String string = jMSException.getErrorCode();
            if ("C4001".equals(string) || "C4000".equals(string)) {
                this.rollbackFailed(jMSException);
            }
            throw jMSException;
        }
    }

    private void rollbackFailed(JMSException jMSException) throws JMSException {
        if (!this.connection.imqReconnect) {
            throw jMSException;
        }
        SessionImpl.yield();
        this.connection.checkReconnecting(null);
        if (this.connection.isCloseCalled || this.connection.connectionIsBroken) {
            throw jMSException;
        }
        this.transaction.startNewLocalTransaction();
    }

    public static void yield() {
        try {
            Thread.yield();
            Thread.sleep(3000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void closeConsumers() throws JMSException {
        MessageConsumerImpl[] messageConsumerImplArray = this.consumers.values().toArray(new MessageConsumerImpl[0]);
        for (int i = 0; i < messageConsumerImplArray.length; ++i) {
            messageConsumerImplArray[i].close();
        }
        this.consumers.clear();
    }

    private void closeProducers() throws JMSException {
        MessageProducerImpl[] messageProducerImplArray = this.producers.toArray(new MessageProducerImpl[0]);
        for (int i = 0; i < messageProducerImplArray.length; ++i) {
            messageProducerImplArray[i].close();
        }
        this.producers.clear();
    }

    private void closeBrowserConsumers() throws JMSException {
        BrowserConsumer[] browserConsumerArray = this.browserConsumers.values().toArray(new BrowserConsumer[0]);
        for (int i = 0; i < browserConsumerArray.length; ++i) {
            browserConsumerArray[i].close();
        }
        this.browserConsumers.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws JMSException {
        int n;
        block25: {
            block23: {
                block24: {
                    sessionLogger.log(Level.FINEST, "##### closing session.  consumer table size: " + this.consumers.values().size());
                    n = 0;
                    this.checkPermission();
                    try {
                        this.prepareToClose();
                        Object object = this.sessionSyncObj;
                        synchronized (object) {
                            if (this.isClosed) {
                                // MONITOREXIT @DISABLED, blocks:[0, 3, 22] lbl9 : MonitorExitStatement: MONITOREXIT : var2_2
                                Object var5_3 = null;
                                sessionLogger.log(Level.FINEST, "***** consumer table size: " + this.consumers.values().size());
                                if (this.isClosed) break block23;
                                break block24;
                            }
                            this.sessionQueue.stop(true);
                            n = this.sessionQueue.size();
                            if (this.isTransacted) {
                                if (this.xaTxnMode) {
                                    this.receiveCommit();
                                } else if (!this.connection.isBroken() && !this.connection.recoverInProcess) {
                                    this.transaction.releaseBrokerResource();
                                }
                            }
                            this.closeConsumers();
                            this.closeProducers();
                            this.closeBrowserConsumers();
                            this.sessionReader.close();
                            this.serverSessionRunner.serverSessionClose();
                            this.connection.removeSession(this);
                            this.connection.removeFromReadQTable(this.sessionId);
                            if (this.connection.getBrokerProtocolLevel() >= 350 && !this.connection.isBroken() && !this.connection.recoverInProcess) {
                                this.protocolHandler.deleteSession(this);
                            }
                            this.isClosed = true;
                        }
                        break block25;
                    }
                    catch (Throwable throwable) {
                        Object var5_5 = null;
                        sessionLogger.log(Level.FINEST, "***** consumer table size: " + this.consumers.values().size());
                        if (!this.isClosed) {
                            this.sessionReader.close();
                        }
                        if (this.consumers.values().size() > 0) {
                            this.cleanUpConsumers();
                        }
                        this.isClosed = true;
                        this.serverSessionRunner.reset();
                        if (this.connectionConsumer != null) {
                            this.connectionConsumer.sessionClosed(this);
                        }
                        this.releaseInSyncState();
                        this.resetConnectionFlowControl(n);
                        if (sessionLogger.isLoggable(Level.FINE)) {
                            this.logLifeCycle("I201");
                        }
                        throw throwable;
                    }
                }
                this.sessionReader.close();
            }
            if (this.consumers.values().size() > 0) {
                this.cleanUpConsumers();
            }
            this.isClosed = true;
            this.serverSessionRunner.reset();
            if (this.connectionConsumer != null) {
                this.connectionConsumer.sessionClosed(this);
            }
            this.releaseInSyncState();
            this.resetConnectionFlowControl(n);
            if (sessionLogger.isLoggable(Level.FINE)) {
                this.logLifeCycle("I201");
            }
            return;
        }
        Object var5_4 = null;
        sessionLogger.log(Level.FINEST, "***** consumer table size: " + this.consumers.values().size());
        if (!this.isClosed) {
            this.sessionReader.close();
        }
        if (this.consumers.values().size() > 0) {
            this.cleanUpConsumers();
        }
        this.isClosed = true;
        this.serverSessionRunner.reset();
        if (this.connectionConsumer != null) {
            this.connectionConsumer.sessionClosed(this);
        }
        this.releaseInSyncState();
        this.resetConnectionFlowControl(n);
        if (sessionLogger.isLoggable(Level.FINE)) {
            this.logLifeCycle("I201");
        }
        if (this.debug) {
            Debug.println("session closed ...");
            Debug.println(this);
        }
    }

    protected void cleanUpConsumers() {
        sessionLogger.log(Level.FINEST, "Cleaning up consumers in session.  SessionID: " + this.sessionId);
        MessageConsumerImpl[] messageConsumerImplArray = this.consumers.values().toArray(new MessageConsumerImpl[0]);
        for (int i = 0; i < messageConsumerImplArray.length; ++i) {
            messageConsumerImplArray[i].receiveQueue.close();
            messageConsumerImplArray[i].isClosed = true;
        }
        this.consumers.clear();
    }

    protected void resetConnectionFlowControl(int n) {
        if (this.connection.isCloseCalled) {
            return;
        }
        if (this.connection.protectMode && n > 0) {
            this.readChannel.flowControl.resetFlowControl(this.connection, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeFromRA() {
        Object object = this.raEndpointSyncObj;
        synchronized (object) {
            this.sessionReader.close();
        }
    }

    public void _setRAEndpointSession() {
    }

    public void _startLocalTransaction() throws JMSException {
        if (this.isTransacted) {
            if (this.transaction == null) {
                throw new com.sun.messaging.jms.JMSException("MQRA:S:Can't start local transaction-transacted w/o Transaction Object");
            }
        } else {
            if (this.transaction != null) {
                throw new com.sun.messaging.jms.JMSException("MQRA:S:Can't start local transaction-already transacted");
            }
            this.transaction = new Transaction(this, true);
            this.isTransacted = true;
        }
    }

    protected boolean needToWait() {
        return !this.connection.isBroken();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void recover() throws JMSException {
        this.checkSessionState();
        if (this.isTransacted) {
            var1_1 = AdministeredObject.cr.getKString("C4025");
            var2_3 = new IllegalStateException(var1_1, "C4025");
            ExceptionHandler.throwJMSException(var2_3);
        }
        if (this.acknowledgeMode == 32768) {
            var1_1 = AdministeredObject.cr.getKString("C4091");
            var2_3 = new IllegalStateException(var1_1, "C4091");
            ExceptionHandler.throwJMSException(var2_3);
        }
        if (this.remore_broker_failed) {
            this.recreateConsumers();
            this.remore_broker_failed = false;
            return;
        }
        this.setInSyncState();
        try {
            switch (this.acknowledgeMode) {
                case 1: {
                    if (Thread.currentThread() != this.sessionReader.sessionThread) ** GOTO lbl21
                    this.sessionReader.currentMessage.doAcknowledge = false;
                    ** GOTO lbl23
lbl21:
                    // 1 sources

                    if (Thread.currentThread() == this.serverSessionRunner.getCurrentThread()) {
                        this.serverSessionRunner.currentMessage.doAcknowledge = false;
                    }
                }
lbl23:
                // 5 sources

                case 2: 
                case 3: {
                    if (Thread.currentThread() == this.sessionReader.sessionThread) {
                        this.prepareClientAcknowledge(this.sessionReader.currentMessage);
                        break;
                    }
                    if (Thread.currentThread() != this.serverSessionRunner.getCurrentThread()) break;
                    this.prepareClientAcknowledge(this.serverSessionRunner.currentMessage);
                }
            }
        }
        catch (Exception var1_2) {
            // empty catch block
        }
        try {
            this.stopSession();
            if (Thread.currentThread() != this.sessionReader.sessionThread && Thread.currentThread() != this.serverSessionRunner.getCurrentThread()) {
                this.stop();
            }
            this.redeliverMessagesInQueues(false);
            this.redeliverUnAckedMessages(true);
            this.failoverOccurred = false;
            if (Thread.currentThread() != this.sessionReader.sessionThread && Thread.currentThread() != this.serverSessionRunner.getCurrentThread()) {
                this.start();
            }
            var4_4 = null;
            this.releaseInSyncState();
        }
        catch (Throwable var3_6) {
            var4_5 = null;
            this.releaseInSyncState();
            this.resumeSession();
            throw var3_6;
        }
        this.resumeSession();
    }

    protected void stopSession() throws JMSException {
        if (this.connection.getBrokerProtocolLevel() < 350) {
            this.protocolHandler.incStoppedCount();
            this.protocolHandler.stop();
        } else {
            this.protocolHandler.stopSession(this.brokerSessionID);
        }
    }

    protected void resumeSession() throws JMSException {
        if (this.connection.getBrokerProtocolLevel() < 350) {
            this.protocolHandler.decStoppedCount();
            if (!this.connection.getIsStopped()) {
                this.protocolHandler.start();
            }
        } else {
            this.protocolHandler.resumeSession(this.brokerSessionID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setInSyncState() throws JMSException {
        Object object = this.syncObject;
        synchronized (object) {
            this.checkSessionState();
            if (this.inSyncState) {
                if (this.isIsMessageListenerThread() && this.inSyncStateOperation == 1) {
                    return;
                }
                String string = AdministeredObject.cr.getKString("C4055");
                IllegalStateException illegalStateException = new IllegalStateException(string, "C4055");
                ExceptionHandler.throwJMSException(illegalStateException);
            }
            this.inSyncState = true;
            this.inSyncStateOperation = 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseInSyncState() {
        Object object = this.syncObject;
        synchronized (object) {
            this.inSyncState = false;
            this.inSyncStateOperation = 0;
            this.syncObject.notifyAll();
        }
    }

    protected boolean getInSyncState() {
        return this.inSyncState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prepareToClose() {
        Object object = this.syncObject;
        synchronized (object) {
            while (this.inSyncState) {
                try {
                    this.syncObject.wait();
                }
                catch (InterruptedException interruptedException) {
                    Debug.printStackTrace(interruptedException);
                }
            }
            this.inSyncState = true;
            this.inSyncStateOperation = 1;
        }
    }

    protected void receiveCommit() throws JMSException {
        if (Thread.currentThread() == this.sessionReader.sessionThread) {
            this.transactedAcknowledge(this.sessionReader.currentMessage);
        } else if (Thread.currentThread() == this.serverSessionRunner.getCurrentThread()) {
            this.transactedAcknowledge(this.serverSessionRunner.currentMessage);
        }
    }

    protected void clearUnackedMessageQ() {
        this.unAckedMessageQueue.clear();
    }

    protected void receiveRollback() throws JMSException {
        if (Thread.currentThread() == this.sessionReader.sessionThread) {
            this.prepareTransactedAcknowledge(this.sessionReader.currentMessage);
        } else if (Thread.currentThread() == this.serverSessionRunner.getCurrentThread()) {
            this.prepareTransactedAcknowledge(this.serverSessionRunner.currentMessage);
        }
        this.stopSession();
        if (Thread.currentThread() != this.sessionReader.sessionThread && Thread.currentThread() != this.serverSessionRunner.getCurrentThread()) {
            this.stop();
        }
        this.redeliverMessagesInQueues(false);
        this.redeliverUnAckedMessages(true);
        if (Thread.currentThread() != this.sessionReader.sessionThread && Thread.currentThread() != this.serverSessionRunner.getCurrentThread()) {
            this.start();
        }
        this.resumeSession();
    }

    protected void redeliverUnAckedMessages(boolean bl) throws JMSException {
        this.dequeueUnAckedMessages();
        this.redeliver(bl);
    }

    protected void redeliverMessagesInQueues(boolean bl) throws JMSException {
        this.dequeueMessagesInQueues();
        this.redeliver(bl);
    }

    protected void dequeueMessagesInQueues() throws JMSException {
        MessageConsumerImpl messageConsumerImpl = null;
        Enumeration enumeration = this.consumers.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            messageConsumerImpl = (MessageConsumerImpl)enumeration.nextElement();
            n += messageConsumerImpl.receiveQueue.size();
            this.dequeueReceiveQ(messageConsumerImpl.receiveQueue);
            this.readChannel.flowControl.resetFlowControl(messageConsumerImpl, 0);
        }
        this.dequeueSessionQ(this.sessionQueue);
        this.resetConnectionFlowControl(n += this.sessionQueue.size());
    }

    protected void dequeueReceiveQ(ReceiveQueue receiveQueue) throws JMSException {
        MessageImpl messageImpl = null;
        while (!receiveQueue.isEmpty()) {
            messageImpl = (MessageImpl)receiveQueue.dequeue();
            if (messageImpl == null) continue;
            this.writeMessageID(messageImpl);
        }
    }

    protected void dequeueSessionQ(SessionQueue sessionQueue) throws JMSException {
        ReadOnlyPacket readOnlyPacket = null;
        while (!sessionQueue.isEmpty()) {
            readOnlyPacket = (ReadOnlyPacket)sessionQueue.dequeue();
            if (readOnlyPacket == null) continue;
            this.writeMessageID(readOnlyPacket);
        }
    }

    private void dequeueUnAckedMessages() throws JMSException {
        UnAckedMessage unAckedMessage = null;
        int n = this.unAckedMessageQueue.size();
        for (int i = 0; i < n; ++i) {
            unAckedMessage = (UnAckedMessage)this.unAckedMessageQueue.elementAt(i);
            this.writeMessageID(unAckedMessage);
        }
        this.unAckedMessageQueue.removeAllElements();
        this.ackCounter = 0;
    }

    protected void redeliver(boolean bl) throws JMSException {
        if (this.bos.size() == 0) {
            return;
        }
        ReadWritePacket readWritePacket = new ReadWritePacket();
        try {
            this.dos.flush();
            this.bos.flush();
            readWritePacket.setMessageBody(this.bos.toByteArray());
            if (this.isTransacted) {
                readWritePacket.setTransactionID(this.transaction.getTransactionID());
            }
            this.protocolHandler.redeliver(readWritePacket, bl, this.isTransacted);
            this.bos.reset();
        }
        catch (IOException iOException) {
            ExceptionHandler.handleException((Exception)iOException, "C4018");
        }
    }

    public MessageListener getMessageListener() throws JMSException {
        this.checkSessionState();
        return this.serverSessionRunner.getMessageListener();
    }

    public void setMessageListener(MessageListener messageListener) throws JMSException {
        this.checkSessionState();
        if (messageListener != null && this.consumers.size() > 0) {
            String string = AdministeredObject.cr.getKString("C4031");
            IllegalStateException illegalStateException = new IllegalStateException(string, "C4031");
            ExceptionHandler.throwJMSException(illegalStateException);
        }
        this.serverSessionRunner.setMessageListener(messageListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.serverSessionRunner.run();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            throw throwable;
        }
    }

    protected void loadMessageToServerSession(MessageImpl messageImpl, ServerSession serverSession, boolean bl) {
        this.serverSessionRunner.loadMessage(messageImpl, serverSession, bl);
    }

    protected SessionQueue getSessionQueue() {
        return this.sessionQueue;
    }

    public boolean _getAckSendAcknowledge() {
        return this.ackPkt.getSendAcknowledge();
    }

    public int _getAcknowledgeMode() {
        return this.acknowledgeMode;
    }

    protected boolean _getXaTxnMode() {
        return this.xaTxnMode;
    }

    protected void _setXaTxnMode(boolean bl) {
        this.xaTxnMode = bl;
    }

    public long getBrokerSessionID() {
        return this.brokerSessionID;
    }

    public void setBrokerSessionID(long l) {
        this.brokerSessionID = l;
    }

    public Transaction _getTransaction() {
        return this.transaction;
    }

    public void _initXATransactionForMC(long l) throws JMSException {
        if (this.transaction == null) {
            this.transaction = new Transaction(this, false);
        }
        this.transaction.setTransactionID(l);
        this.xaTxnMode = true;
        this.isTransacted = true;
    }

    public void _finishXATransactionForMC() {
        this.xaTxnMode = false;
        this.isTransacted = false;
        this.transaction = null;
    }

    public void dump(PrintStream printStream) {
        printStream.println("------ SessionImpl dump ------");
        printStream.println("broker session ID: " + this.brokerSessionID);
        printStream.println("session ID: " + this.sessionId);
        if (this.sessionReader != null) {
            this.sessionReader.dump(printStream);
        }
        if (this.sessionQueue != null) {
            this.sessionQueue.dump(printStream);
        }
        if (this.unAckedMessageQueue != null) {
            printStream.println("Number of Unacked messages: " + this.unAckedMessageQueue.size());
        }
        printStream.println("# of message consumers: " + this.consumers.size());
        Enumeration enumeration = this.consumers.elements();
        while (enumeration.hasMoreElements()) {
            MessageConsumerImpl messageConsumerImpl = (MessageConsumerImpl)enumeration.nextElement();
            messageConsumerImpl.dump(printStream);
        }
        this.serverSessionRunner.dump(printStream);
    }

    protected Hashtable getDebugState(boolean bl) {
        ServerSessionRunner serverSessionRunner;
        ConnectionConsumerImpl connectionConsumerImpl;
        MessageProducerImpl[] messageProducerImplArray;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("sessionId", String.valueOf(this.sessionId));
        hashtable.put("brokerSessionID", String.valueOf(this.brokerSessionID));
        hashtable.put("isTransacted", String.valueOf(this.isTransacted));
        hashtable.put("ackMode", String.valueOf(this.acknowledgeMode));
        hashtable.put("dupsOkLimit", String.valueOf(this.dupsOkLimit));
        hashtable.put("isAckLimited", String.valueOf(this.isAckLimited));
        hashtable.put("ackLimit", String.valueOf(this.ackLimit));
        hashtable.put("ackCounter", String.valueOf(this.ackCounter));
        hashtable.put("xaTxnMode", String.valueOf(this.xaTxnMode));
        hashtable.put("rxCount", String.valueOf(this.TEST_rxCount));
        hashtable.put("ackCount", String.valueOf(this.TEST_ackCount));
        hashtable.put("isStopped", String.valueOf(this.isStopped));
        hashtable.put("# Consumers", String.valueOf(this.consumers.size()));
        int n = 0;
        Enumeration enumeration = this.consumers.elements();
        while (enumeration.hasMoreElements()) {
            messageProducerImplArray = (MessageProducerImpl[])enumeration.nextElement();
            hashtable.put("Consumer[" + n + "]", messageProducerImplArray.getDebugState(bl));
            ++n;
        }
        hashtable.put("# Producers", String.valueOf(this.producers.size()));
        messageProducerImplArray = this.producers.toArray(new MessageProducerImpl[0]);
        for (int i = 0; i < messageProducerImplArray.length; ++i) {
            hashtable.put("Producer[" + i + "]", messageProducerImplArray[i].getDebugState(bl));
        }
        if (bl) {
            hashtable.put("unacked", this.unAckedMessageQueue);
        }
        if ((connectionConsumerImpl = this.connectionConsumer) != null) {
            hashtable.put("connectionConsumer", connectionConsumerImpl.getDebugState(bl));
        }
        if ((serverSessionRunner = this.serverSessionRunner) != null) {
            hashtable.put("serverSessionRunner", serverSessionRunner.getDebugState(bl));
        }
        return hashtable;
    }

    private void checkClientAckMessage(MessageImpl messageImpl) throws JMSException {
        Long l;
        if (this.connection.getBrokerProtocolLevel() < 350 && !this.consumers.containsKey(l = new Long(messageImpl.getInterestID()))) {
            String string = AdministeredObject.cr.getKString("C4058");
            IllegalStateException illegalStateException = new IllegalStateException(string, "C4058");
            ExceptionHandler.throwJMSException(illegalStateException);
        }
    }

    protected void removeUnAckedMessages(Long l) throws JMSException {
        int n = this.unAckedMessageQueue.size();
        if (n > 0) {
            int n2;
            Vector<UnAckedMessage> vector = new Vector<UnAckedMessage>();
            long l2 = l;
            for (n2 = 0; n2 < n; ++n2) {
                UnAckedMessage unAckedMessage = (UnAckedMessage)this.unAckedMessageQueue.elementAt(n2);
                if (unAckedMessage.getConsumerID() != l2) continue;
                vector.addElement(unAckedMessage);
            }
            for (n2 = 0; n2 < vector.size(); ++n2) {
                if (this.debug) {
                    Debug.println("removing msg from unackq: " + vector.elementAt(n2));
                }
                this.removeMessageFromAckList((UnAckedMessage)vector.elementAt(n2));
            }
        }
    }

    public void logLifeCycle(String string) {
        if (sessionLogger.isLoggable(Level.FINE)) {
            sessionLogger.log(Level.FINE, string, this);
        }
    }

    public String toString() {
        return "ConnectionID=" + this.connection.getConnectionID() + ", SessionID=" + this.brokerSessionID;
    }

    protected void recreateConsumers() throws JMSException {
        this.recreateConsumers(false);
    }

    protected void recreateConsumers(boolean bl) throws JMSException {
        try {
            try {
                int n;
                sessionLogger.finest("Re-creating consumers for the session: " + this.sessionId);
                Object[] objectArray = this.consumers.values().toArray();
                this.stopSession();
                if (Thread.currentThread() != this.sessionReader.sessionThread && Thread.currentThread() != this.serverSessionRunner.getCurrentThread()) {
                    this.stop(false);
                }
                this.sessionQueue.clear();
                for (n = 0; n < objectArray.length; ++n) {
                    ((MessageConsumerImpl)objectArray[n]).receiveQueue.clear();
                    ((MessageConsumerImpl)objectArray[n]).deregisterInterest();
                    ((MessageConsumerImpl)objectArray[n]).logLifeCycle("I301");
                }
                if (this.unAckedMessageQueue != null) {
                    this.unAckedMessageQueue.removeAllElements();
                }
                this.consumers.clear();
                if (!bl && this.isTransacted) {
                    this.transaction.rollback();
                }
                for (n = 0; n < objectArray.length; ++n) {
                    ((MessageConsumerImpl)objectArray[n]).registerInterest();
                    ((MessageConsumerImpl)objectArray[n]).logLifeCycle("I300");
                }
                this.resumeSession();
                if (Thread.currentThread() != this.sessionReader.sessionThread && Thread.currentThread() != this.serverSessionRunner.getCurrentThread()) {
                    this.start();
                }
                this.remore_broker_failed = false;
                sessionLogger.finest("Consumers recreated for the session: " + this.sessionId);
            }
            catch (JMSException jMSException) {
                sessionLogger.log(Level.SEVERE, jMSException.getMessage(), jMSException);
                throw jMSException;
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            throw throwable;
        }
    }

    public boolean _appCheckRemoteException(JMSException jMSException) {
        if (jMSException instanceof RemoteAcknowledgeException) {
            return this.isRemoteException(jMSException);
        }
        Exception exception = jMSException.getLinkedException();
        if (exception == null || !(exception instanceof RemoteAcknowledgeException)) {
            return false;
        }
        return this.isRemoteException((JMSException)exception);
    }

    protected boolean isRemoteException(JMSException jMSException) {
        boolean bl = false;
        String string = jMSException.getErrorCode();
        if ("C4110".equals(string) || "C4107".equals(string) || "C4108".equals(string) || "C4109".equals(string)) {
            if (SessionImpl.matchConsumerIDs((RemoteAcknowledgeException)jMSException, this.consumers, sessionLogger)) {
                bl = true;
            }
        }
        return bl;
    }

    protected static boolean matchConsumerIDs(RemoteAcknowledgeException remoteAcknowledgeException, Hashtable hashtable, Logger logger) {
        Hashtable hashtable2 = remoteAcknowledgeException.getProperties();
        if (hashtable2 == null) {
            return false;
        }
        String string = (String)hashtable2.get("JMQRemoteConsumerIDs");
        if (string == null) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            Long l = new Long(string2);
            Object v = hashtable.get(l);
            if (v == null) continue;
            logger.finest("SessionImpl.matchConsumerIDs: Consumer ID matches: " + string2);
            return true;
        }
        return false;
    }

    public void setIsMessageListenerThread(boolean bl) {
        this.isMessageListener.set(bl);
    }

    public boolean isIsMessageListenerThread() {
        Boolean bl = this.isMessageListener.get();
        if (bl == null) {
            return false;
        }
        return bl;
    }

    private class UnAckedMessage {
        private SysMessageID mid = null;
        private long cid = -1L;

        private UnAckedMessage(MessageImpl messageImpl) {
            this.mid = messageImpl.getMessageID();
            this.cid = messageImpl.getInterestID();
        }

        public SysMessageID getMessageID() {
            return this.mid;
        }

        public long getConsumerID() {
            return this.cid;
        }

        public String toString() {
            return "mid:[" + (this.mid != null ? this.mid.toString() : "") + "] cid:" + this.cid;
        }
    }
}

