/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.protocol;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.PacketType;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.Producer;
import com.sun.messaging.jmq.jmsserver.core.ProducerUID;
import com.sun.messaging.jmq.jmsserver.core.Session;
import com.sun.messaging.jmq.jmsserver.core.SessionUID;
import com.sun.messaging.jmq.jmsserver.data.AutoRollbackType;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.data.PacketRouter;
import com.sun.messaging.jmq.jmsserver.data.RollbackReason;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.handlers.AckHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.ClientIDHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.ConsumerHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.DataHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.FlowHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.ProducerHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.QBrowseHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.RedeliverHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.SessionHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.TransactionHandler;
import com.sun.messaging.jmq.jmsserver.data.protocol.Protocol;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.JMQXid;
import com.sun.messaging.jmq.util.selector.Selector;
import com.sun.messaging.jmq.util.selector.SelectorFormatException;
import java.io.IOException;
import java.lang.constant.Constable;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class ProtocolImpl
implements Protocol {
    private static boolean DEBUG = false;
    PacketRouter pr = null;

    public ProtocolImpl(PacketRouter packetRouter) {
        this.pr = packetRouter;
    }

    public void hello() {
    }

    public void authenticate(String string, String string2) throws BrokerException {
    }

    public void goodbye() {
    }

    public Hashtable getLicense() {
        return new Hashtable();
    }

    public Hashtable getInfo(boolean bl) {
        return new Hashtable();
    }

    public void ping() {
    }

    public void flowPaused(int n) {
        throw new UnsupportedOperationException("flow paused is not supported by the client");
    }

    public void acknowledge(IMQConnection iMQConnection, TransactionUID transactionUID, boolean bl, int n, Throwable throwable, String string, int n2, SysMessageID[] sysMessageIDArray, ConsumerUID[] consumerUIDArray) throws BrokerException, IOException {
        AckHandler ackHandler;
        List list;
        block10: {
            block7: {
                block9: {
                    block8: {
                        if (DEBUG) {
                            Globals.getLogger().log(8, "ProtocolImpl.ACKNOWLEDGE:TID=" + transactionUID + ", ackType=" + n + ", ids=" + sysMessageIDArray + ", cids=" + consumerUIDArray + ", validate=" + bl + ", deadComment=" + string + ", deliverCnt=" + n2 + ", exception=" + throwable);
                        }
                        list = null;
                        ackHandler = (AckHandler)this.pr.getHandler(24);
                        if (!bl) break block7;
                        if (n == 2) break block8;
                        if (n != 1) break block9;
                    }
                    throw new BrokerException("Can not use JMQValidate with an ackType of " + n, null, 400);
                }
                if (transactionUID == null) {
                    throw new BrokerException("Can not use JMQValidate with no tid", null, 400);
                }
                if (!ackHandler.validateMessages(transactionUID, sysMessageIDArray, consumerUIDArray)) {
                    throw new BrokerException("Acknowledgement could not be found", null, 404);
                }
                break block10;
            }
            list = n == 2 ? ackHandler.handleDeadMsgs(iMQConnection, sysMessageIDArray, consumerUIDArray, 0, throwable, string, n2) : (n == 1 ? ackHandler.handleUndeliverableMsgs(iMQConnection, sysMessageIDArray, consumerUIDArray) : (transactionUID != null ? ackHandler.handleTransaction(iMQConnection, transactionUID, sysMessageIDArray, consumerUIDArray) : ackHandler.handleAcks(iMQConnection, sysMessageIDArray, consumerUIDArray, true)));
        }
        ackHandler.cleanUp(list);
    }

    public void setClientID(IMQConnection iMQConnection, String string, String string2, boolean bl) throws BrokerException {
        ClientIDHandler clientIDHandler = (ClientIDHandler)this.pr.getHandler(50);
        clientIDHandler.setClientID(iMQConnection, string, string2, bl);
    }

    public Producer addProducer(Destination destination, IMQConnection iMQConnection, String string, boolean bl) throws BrokerException {
        if (bl) {
            this.checkAccessPermission(18, destination, iMQConnection);
        }
        ProducerHandler producerHandler = (ProducerHandler)this.pr.getHandler(18);
        return producerHandler.addProducer(destination.getDestinationUID(), iMQConnection, string, false);
    }

    public void removeProducer(ProducerUID producerUID, IMQConnection iMQConnection, String string) throws BrokerException {
        ProducerHandler producerHandler = (ProducerHandler)this.pr.getHandler(18);
        producerHandler.removeProducer(producerUID, false, iMQConnection, string);
    }

    public void resumeFlow(IMQConnection iMQConnection, int n) {
        FlowHandler flowHandler = (FlowHandler)this.pr.getHandler(52);
        flowHandler.connectionFlow(iMQConnection, n);
    }

    public void resumeFlow(Consumer consumer, int n) {
        FlowHandler flowHandler = (FlowHandler)this.pr.getHandler(52);
        flowHandler.consumerFlow(consumer, n);
    }

    public ArrayList deliver(long l, ArrayList arrayList) throws BrokerException, IOException {
        ArrayList<Packet> arrayList2 = new ArrayList<Packet>();
        for (SysMessageID sysMessageID : arrayList) {
            PacketReference packetReference = Destination.get(sysMessageID);
            if (packetReference == null) continue;
            Packet packet = packetReference.getPacket();
            if (packetReference.isInvalid()) continue;
            Packet packet2 = new Packet(false);
            packet2.fill(packet);
            packet2.setConsumerID(l);
            arrayList2.add(packet2);
        }
        return arrayList2;
    }

    public ArrayList redeliver(TransactionUID transactionUID, ConsumerUID[] consumerUIDArray, SysMessageID[] sysMessageIDArray, boolean bl) throws BrokerException {
        return new ArrayList();
    }

    public Session createSession(int n, IMQConnection iMQConnection) throws BrokerException {
        Object object = new Object();
        SessionHandler sessionHandler = (SessionHandler)this.pr.getHandler(68);
        return sessionHandler.createSession(n, object.toString(), iMQConnection, false);
    }

    public void destroySession(SessionUID sessionUID, IMQConnection iMQConnection) throws BrokerException {
        SessionHandler sessionHandler = (SessionHandler)this.pr.getHandler(68);
        sessionHandler.closeSession(sessionUID, iMQConnection, false);
    }

    public void pauseSession(SessionUID sessionUID) throws BrokerException {
        Session session = Session.getSession(sessionUID);
        if (session == null) {
            throw new BrokerException("No session for " + sessionUID);
        }
        session.pause("PROTOCOL");
    }

    public void resumeSession(SessionUID sessionUID) throws BrokerException {
        Session session = Session.getSession(sessionUID);
        if (session == null) {
            throw new BrokerException("No session for " + sessionUID);
        }
        session.resume("PROTOCOL");
    }

    public void pauseConnection(IMQConnection iMQConnection) {
        iMQConnection.stopConnection();
    }

    public void resumeConnection(IMQConnection iMQConnection) {
        iMQConnection.startConnection();
    }

    public ArrayList browseQueue(Destination destination, String string, IMQConnection iMQConnection, boolean bl) throws BrokerException, SelectorFormatException {
        if (bl) {
            this.checkAccessPermission(26, destination, iMQConnection);
        }
        QBrowseHandler qBrowseHandler = (QBrowseHandler)this.pr.getHandler(26);
        return qBrowseHandler.getQBrowseList(destination, string);
    }

    public Consumer createConsumer(Destination destination, IMQConnection iMQConnection, Session session, String string, String string2, String string3, boolean bl, int n, boolean bl2, String string4, boolean bl3, boolean bl4) throws BrokerException, SelectorFormatException, IOException {
        ConsumerHandler consumerHandler;
        Consumer[] consumerArray;
        if (bl3) {
            this.checkAccessPermission(14, destination, iMQConnection);
        }
        if ((consumerArray = (consumerHandler = (ConsumerHandler)this.pr.getHandler(14)).createConsumer(destination.getDestinationUID(), iMQConnection, session, string, string2, string3, bl, n, bl2, string4, false, bl4))[2] != null) {
            consumerArray[2].resume("Resuming from protocol");
        }
        if (consumerArray[1] != null) {
            consumerArray[1].resume("Resuming from protocol");
        }
        return consumerArray[0];
    }

    public void unsubscribe(String string, String string2) throws BrokerException {
        ConsumerHandler consumerHandler = (ConsumerHandler)this.pr.getHandler(14);
        consumerHandler.destroyConsumer(null, null, null, string, string2, null, false, false);
    }

    public void destroyConsumer(ConsumerUID consumerUID, Session session, IMQConnection iMQConnection) throws BrokerException {
        ConsumerHandler consumerHandler = (ConsumerHandler)this.pr.getHandler(14);
        consumerHandler.destroyConsumer(iMQConnection, session, consumerUID, null, null, null, true, false);
    }

    public void endTransaction(TransactionUID transactionUID, JMQXid jMQXid, Integer n) throws BrokerException {
        if (DEBUG) {
            Globals.getLogger().log(8, "ProtocolImpl.END TRANSACTION:TID=" + transactionUID + ", XID=" + jMQXid + ", xaFlags=" + n);
        }
        TransactionHandler transactionHandler = (TransactionHandler)this.pr.getHandler(44);
        TransactionState transactionState = transactionHandler.getTransactionList().retrieveState(transactionUID);
        transactionHandler.doEnd(58, jMQXid, n, transactionState, transactionUID);
    }

    public TransactionUID startTransaction(JMQXid jMQXid, Integer n, AutoRollbackType autoRollbackType, long l, IMQConnection iMQConnection) throws BrokerException {
        Object object;
        if (DEBUG) {
            Globals.getLogger().log(8, "ProtocolImpl.START TRANSACTION:XID=" + jMQXid + ", type=" + autoRollbackType + ", conn=" + iMQConnection);
        }
        List list = iMQConnection.getTransactionListThreadSafe();
        TransactionHandler transactionHandler = (TransactionHandler)this.pr.getHandler(44);
        TransactionUID transactionUID = null;
        if (n == null || TransactionState.isFlagSet(0, n)) {
            transactionUID = new TransactionUID();
        } else if (jMQXid != null) {
            object = transactionHandler.getTransactionList();
            transactionUID = ((TransactionList)object).xidToUID(jMQXid);
        } else {
            throw new BrokerException("Invalid xid");
        }
        object = new Object();
        transactionHandler.doStart(transactionUID, list, iMQConnection, autoRollbackType, jMQXid, jMQXid != null, l, 0L, n, 44, false, object.toString());
        if (DEBUG) {
            Globals.getLogger().log(8, "ProtocolImpl.STARTED TRANSACTION:TID=" + transactionUID + ", XID=" + jMQXid + ", type=" + autoRollbackType + ", con=" + iMQConnection);
        }
        return transactionUID;
    }

    public void commitTransaction(TransactionUID transactionUID, JMQXid jMQXid, Integer n, IMQConnection iMQConnection) throws BrokerException {
        TransactionState transactionState;
        if (DEBUG) {
            Globals.getLogger().log(8, "ProtocolImpl.COMMIT TRANSACTION:TID=" + transactionUID + ", XID=" + jMQXid + ", xaFlags=" + n);
        }
        List list = iMQConnection.getTransactionListThreadSafe();
        TransactionHandler transactionHandler = (TransactionHandler)this.pr.getHandler(44);
        if (0L == transactionUID.longValue()) {
            if (jMQXid == null) {
                throw new BrokerException("Unexpected TransactionUID  " + transactionUID);
            }
            transactionUID = transactionHandler.getTransactionList().xidToUID(jMQXid);
            if (transactionUID == null) {
                throw new BrokerException("Unknown XID " + jMQXid, 404);
            }
        }
        if ((transactionState = transactionHandler.getTransactionList().retrieveState(transactionUID)) == null) {
            throw new BrokerException("Unknown transaction " + transactionUID + (jMQXid == null ? "" : " XID=" + jMQXid), 404);
        }
        if (!(jMQXid == null || transactionState.getXid() != null && jMQXid.equals(transactionState.getXid()))) {
            throw new BrokerException("Transaction XID mismatch " + jMQXid + ", expected " + transactionState.getXid() + " for transaction " + transactionUID);
        }
        transactionHandler.doCommit(transactionUID, jMQXid, n, transactionState, list, false, iMQConnection, null);
    }

    public void prepareTransaction(TransactionUID transactionUID, Integer n) throws BrokerException {
        if (DEBUG) {
            Globals.getLogger().log(8, "ProtocolImpl.PREPARE TRANSACTION:TID=" + transactionUID + ", xaFlags=" + n);
        }
        TransactionHandler transactionHandler = (TransactionHandler)this.pr.getHandler(44);
        TransactionState transactionState = transactionHandler.getTransactionList().retrieveState(transactionUID);
        transactionHandler.doPrepare(transactionUID, n, transactionState, 56);
    }

    public void rollbackTransaction(TransactionUID transactionUID, JMQXid jMQXid, Integer n, IMQConnection iMQConnection, boolean bl, boolean bl2) throws BrokerException {
        TransactionState transactionState;
        if (DEBUG) {
            Globals.getLogger().log(8, "ProtocolImpl.ROLLBACK TRANSACTION:TID=" + transactionUID + ", XID=" + jMQXid + ", xaFlags=" + n + ", redeliver=" + bl + ", setRedeliver=" + bl2);
        }
        List list = iMQConnection.getTransactionListThreadSafe();
        TransactionHandler transactionHandler = (TransactionHandler)this.pr.getHandler(44);
        if (0L == transactionUID.longValue()) {
            if (jMQXid == null) {
                throw new BrokerException("Unexpected TransactionUID  " + transactionUID);
            }
            transactionUID = transactionHandler.getTransactionList().xidToUID(jMQXid);
            if (transactionUID == null) {
                throw new BrokerException("Unknown XID " + jMQXid, 404);
            }
        }
        if ((transactionState = transactionHandler.getTransactionList().retrieveState(transactionUID)) == null) {
            throw new BrokerException("Unknown transaction " + transactionUID + (jMQXid == null ? "" : " XID=" + jMQXid), 404);
        }
        if (!(jMQXid == null || transactionState.getXid() != null && jMQXid.equals(transactionState.getXid()))) {
            throw new BrokerException("Transaction XID mismatch " + jMQXid + ", expected " + transactionState.getXid() + " for transaction " + transactionUID);
        }
        transactionHandler.preRollback(transactionUID, jMQXid, n, transactionState);
        if (bl) {
            transactionHandler.redeliverUnacked(transactionUID, true, bl2);
        }
        transactionHandler.doRollback(transactionUID, jMQXid, n, transactionState, list, iMQConnection, RollbackReason.APPLICATION);
    }

    public JMQXid[] recoverTransaction(TransactionUID transactionUID) {
        JMQXid[] jMQXidArray;
        if (DEBUG) {
            Globals.getLogger().log(8, "ProtocolImpl.RECOVER TRANSACTION:TID=" + transactionUID);
        }
        TransactionHandler transactionHandler = (TransactionHandler)this.pr.getHandler(44);
        TransactionList transactionList = transactionHandler.getTransactionList();
        Vector<TransactionUID> vector = null;
        if (transactionUID == null) {
            vector = transactionList.getTransactions(5);
        } else {
            vector = new Vector<TransactionUID>();
            jMQXidArray = transactionList.retrieveState(transactionUID);
            if (jMQXidArray.getState() == 5) {
                vector.add(transactionUID);
            }
        }
        jMQXidArray = new JMQXid[vector.size()];
        Iterator iterator = vector.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            TransactionUID transactionUID2 = (TransactionUID)iterator.next();
            TransactionState transactionState = transactionList.retrieveState(transactionUID2);
            if (transactionState == null) continue;
            JMQXid jMQXid = transactionState.getXid();
            jMQXidArray[n++] = jMQXid;
        }
        return jMQXidArray;
    }

    public HashMap verifyDestination(String string, int n, String string2) throws BrokerException, IOException {
        Object object;
        HashMap<String, Constable> hashMap = new HashMap<String, Constable>();
        try {
            if (string2 != null) {
                object = Selector.compile(string2);
                object = null;
            }
        }
        catch (SelectorFormatException selectorFormatException) {
            hashMap.put("JMQStatus", new Integer(400));
            return hashMap;
        }
        object = Destination.getDestination(string, DestType.isQueue(n));
        if (object == null) {
            hashMap.put("JMQCanCreate", Boolean.valueOf(Destination.canAutoCreate(DestType.isQueue(n))));
            hashMap.put("JMQStatus", new Integer(404));
        } else {
            hashMap.put("JMQDestType", new Integer(((Destination)object).getType()));
            hashMap.put("JMQStatus", new Integer(200));
        }
        return hashMap;
    }

    public Map verifyTransaction(TransactionUID transactionUID) throws BrokerException {
        TransactionHandler transactionHandler = (TransactionHandler)this.pr.getHandler(44);
        TransactionList transactionList = transactionHandler.getTransactionList();
        TransactionState transactionState = transactionList.retrieveState(transactionUID, true);
        if (transactionState == null) {
            return null;
        }
        int n = transactionState.getState();
        if (n != 5) {
            return null;
        }
        return transactionList.getTransactionMap(transactionUID, true);
    }

    public void redeliver(ConsumerUID[] consumerUIDArray, SysMessageID[] sysMessageIDArray, IMQConnection iMQConnection, TransactionUID transactionUID, boolean bl) throws BrokerException, IOException {
        RedeliverHandler redeliverHandler = (RedeliverHandler)this.pr.getHandler(32);
        redeliverHandler.redeliver(consumerUIDArray, sysMessageIDArray, iMQConnection, transactionUID, bl);
    }

    public void processMessage(IMQConnection iMQConnection, Packet packet) throws BrokerException, SelectorFormatException, IOException {
        DataHandler dataHandler = (DataHandler)this.pr.getHandler(6);
        Destination destination = null;
        PacketReference packetReference = null;
        Set set = null;
        boolean bl = false;
        boolean bl2 = iMQConnection.isAdminConnection();
        try {
            destination = Destination.getDestination(packet.getDestination(), packet.getIsQueue());
            if (destination == null) {
                throw new BrokerException("Unknown Destination:" + packet.getDestination());
            }
            Producer producer = dataHandler.checkFlow(packet, iMQConnection);
            boolean bl3 = packet.getTransactionID() != 0L;
            packetReference = dataHandler.createReference(packet, destination.getDestinationUID(), iMQConnection, bl2);
            bl = dataHandler.queueMessage(destination, packetReference, bl3);
            set = dataHandler.routeMessage(bl3, packetReference, bl, destination);
            dataHandler.pauseProducer(destination, producer, iMQConnection);
        }
        catch (BrokerException brokerException) {
            int n = brokerException.getStatusCode();
            if (n == 500 && packetReference != null && destination != null) {
                dataHandler.cleanupOnError(destination, packetReference);
            }
            throw brokerException;
        }
        if (bl && destination != null && set != null) {
            dataHandler.forwardMessage(destination, packetReference, set);
        }
    }

    public Destination createDestination(String string, int n, IMQConnection iMQConnection, boolean bl) throws BrokerException, IOException {
        if (bl) {
            this.checkAccessPermission(34, string, n, iMQConnection);
        }
        if (DestType.isTemporary(n)) {
            boolean bl2 = iMQConnection.getConnectionUID().getCanReconnect();
            long l = iMQConnection.getReconnectInterval();
            Destination destination = Destination.createTempDestination(string, n, iMQConnection.getConnectionUID(), bl2, l);
            if (iMQConnection.getConnectionUID().equals(destination.getConnectionUID())) {
                iMQConnection.attachTempDestination(destination.getDestinationUID());
            }
            return destination;
        }
        return Destination.getDestination(string, n, true, !iMQConnection.isAdminConnection());
    }

    public void destroyDestination(DestinationUID destinationUID) throws BrokerException, IOException {
        Destination.removeDestination(destinationUID, true, "request from protocol");
    }

    void checkAccessPermission(int n, Destination destination, IMQConnection iMQConnection) throws AccessControlException, BrokerException {
        this.checkAccessPermission(n, destination.getName(), destination.getType(), iMQConnection);
    }

    void checkAccessPermission(int n, String string, int n2, IMQConnection iMQConnection) throws AccessControlException, BrokerException {
        String string2 = PacketType.mapOperation(n);
        if (string2 == null) {
            return;
        }
        PacketHandler.checkPermission(n, string2, string, n2, iMQConnection);
    }
}

