/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util.timer;

import com.sun.messaging.jmq.resources.SharedResources;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;

public class MQTimer
extends Timer {
    private static boolean DEBUG = false;
    private static SharedResources myrb = SharedResources.getResources();
    private static Logger logger = null;
    private Object mqTimerObject = new Object(){

        protected void finalize() throws Throwable {
            if (DEBUG && logger != null) {
                RuntimeException runtimeException = new RuntimeException("MQTimer.mqtimerObject: finalize");
                runtimeException.fillInStackTrace();
                logger.logStack(8, "Internal Error: timer canceled ", (Throwable)runtimeException);
            }
        }
    };

    public static void setLogger(Logger logger) {
        MQTimer.logger = logger;
        if (logger.getLevel() <= 4) {
            DEBUG = true;
        }
    }

    public MQTimer() {
        this(false);
    }

    public MQTimer(boolean bl) {
        super("MQTimer-Thread", bl);
    }

    public void initUncaughtExceptionHandler() {
        block2: {
            TimerTask timerTask = new TimerTask(){

                public void run() {
                    block2: {
                        Thread thread = Thread.currentThread();
                        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = thread.getUncaughtExceptionHandler();
                        try {
                            thread.setUncaughtExceptionHandler(new MQTimerUncaughtExceptionHandler(uncaughtExceptionHandler));
                        }
                        catch (Exception exception) {
                            if (logger == null) break block2;
                            Logger logger = logger;
                            SharedResources sharedResources = myrb;
                            myrb;
                            logger.log(16, sharedResources.getKString("S2005", this.getClass().getName()));
                        }
                    }
                    this.cancel();
                }
            };
            try {
                this.schedule(timerTask, new Date());
            }
            catch (Exception exception) {
                if (logger == null) break block2;
                logger.log(16, myrb.getKString("S2006", exception.getMessage()));
            }
        }
    }

    public void cancel() {
        super.cancel();
        if (logger != null && (DEBUG || logger.getLevel() < 4)) {
            RuntimeException runtimeException = new RuntimeException("MQTimer: cancel");
            runtimeException.fillInStackTrace();
            logger.logStack(8, "Internal Error: timer canceled ", (Throwable)runtimeException);
        }
    }

    class MQTimerUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        Thread.UncaughtExceptionHandler parent = null;

        public MQTimerUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
            this.parent = uncaughtExceptionHandler;
        }

        public void uncaughtException(Thread thread, Throwable throwable) {
            if (logger != null) {
                Logger logger = logger;
                SharedResources sharedResources = myrb;
                myrb;
                logger.logStack(32, sharedResources.getKString("S3019", throwable.getMessage(), thread.getName()), throwable);
            }
            this.parent.uncaughtException(thread, throwable);
        }
    }
}

