/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.Arrays;

public class Password {
    private static boolean DEBUG = Boolean.getBoolean("imq.debug.com.sun.messaging.jmq.util.Password");
    private static boolean useNative = false;
    private static final String library = "imqutil";

    private native String getHiddenPassword();

    public boolean echoPassword() {
        return !this.hasJavaConsole() && !useNative;
    }

    private boolean hasJavaConsole() {
        try {
            Class<?> clazz = Class.forName("java.io.Console");
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private String getPasswordFromJavaConsole() {
        if (DEBUG) {
            System.err.println("use java.io.Console");
        }
        try {
            Class<?> clazz = Class.forName("java.io.Console");
            Method method = System.class.getMethod("console", null);
            Method method2 = clazz.getMethod("readPassword", null);
            Object object = method.invoke(null, (Object[])null);
            if (object == null) {
                throw new Exception("Console not available");
            }
            char[] cArray = (char[])method2.invoke(object, (Object[])null);
            if (cArray == null) {
                return null;
            }
            String string = new String(cArray);
            Arrays.fill(cArray, ' ');
            cArray = null;
            return string;
        }
        catch (Throwable throwable) {
            if (DEBUG) {
                throwable.printStackTrace();
            }
            return null;
        }
    }

    private String getClearTextPassword() {
        String string = null;
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            string = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            System.err.println("Caught exception when reading passwd: " + iOException);
        }
        return string;
    }

    public String getPassword() {
        if (this.hasJavaConsole()) {
            return this.getPasswordFromJavaConsole();
        }
        if (useNative) {
            return this.getHiddenPassword();
        }
        return this.getClearTextPassword();
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        boolean bl2 = false;
        if (stringArray.length > 0) {
            if (stringArray[0].equalsIgnoreCase("-c")) {
                bl = true;
            }
            if (stringArray[0].equalsIgnoreCase("-n")) {
                bl2 = true;
            }
        }
        Password password = new Password();
        System.out.print("Enter password: ");
        String string = bl2 ? password.getPassword() : (bl ? password.getClearTextPassword() : password.getHiddenPassword());
        System.err.println("");
        System.out.println("Password enterd is: " + string);
    }

    static {
        try {
            System.loadLibrary(library);
            useNative = true;
        }
        catch (Throwable throwable) {
            useNative = false;
        }
    }
}

