/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.agent;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.management.agent.Agent;
import com.sun.messaging.jmq.jmsserver.management.agent.MQJMXAuthenticator;
import com.sun.messaging.jmq.jmsserver.management.agent.MQRMIServerSocketFactory;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.management.MQRMIClientSocketFactory;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import javax.management.MBeanServer;
import javax.management.NotificationListener;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import javax.rmi.ssl.SslRMIClientSocketFactory;

public class ConnectorServerInfo {
    private static String CONNECTOR_PROPBASE = "imq.jmx.connector.";
    private static String PROTOCOL_SUFFIX = ".protocol";
    private static String PORT_SUFFIX = ".port";
    private static String URLPATH_SUFFIX = ".urlpath";
    private static String URL_SUFFIX = ".url";
    private static String SSL_SUFFIX = ".useSSL";
    private static String BROKER_HOST_TRUSTED_SUFFIX = ".brokerHostTrusted";
    private static String BACKLOG_SUFFIX = ".backlog";
    Agent agent;
    JMXConnectorServer connectorServer = null;
    JMXServiceURL configuredURL = null;
    String name = null;
    boolean configuredActive = false;
    boolean stopped = false;
    NotificationListener listener;
    private BrokerResources rb = Globals.getBrokerResources();

    public ConnectorServerInfo(Agent agent, String string, boolean bl, NotificationListener notificationListener) throws BrokerException {
        this.name = string;
        this.configuredActive = bl;
        this.listener = notificationListener;
        this.agent = agent;
        this.initURL();
    }

    public JMXServiceURL getConfiguredJMXServiceURL() {
        return this.configuredURL;
    }

    public JMXServiceURL getJMXServiceURL() {
        if (this.isActive()) {
            return this.connectorServer.getAddress();
        }
        return this.configuredURL;
    }

    public String getName() {
        return this.name;
    }

    public boolean isActive() {
        if (!this.configuredActive) {
            return false;
        }
        if (this.connectorServer == null) {
            return false;
        }
        return this.connectorServer.isActive();
    }

    public void start() throws IOException, BrokerException {
        if (!this.configuredActive) {
            throw new BrokerException(this.rb.getString("B2160", this.name));
        }
        this.initConnectorServer();
        this.connectorServer.start();
    }

    public void stop() throws IOException {
        if (!this.isActive()) {
            return;
        }
        this.connectorServer.stop();
        this.stopped = true;
        this.connectorServer = null;
        this.configuredURL = null;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public int getPort() {
        return this.getJMXServiceURL().getPort();
    }

    public String getProtocol() {
        return this.getJMXServiceURL().getProtocol();
    }

    public JMXConnectorServer getConnectorServer() {
        return this.connectorServer;
    }

    private void initURL() throws BrokerException {
        JMXServiceURL jMXServiceURL;
        String string = null;
        String string2 = null;
        String string3 = null;
        int n = 0;
        BrokerConfig brokerConfig = Globals.getConfig();
        String string4 = Globals.getJMXHostname();
        if (this.configuredURL != null) {
            return;
        }
        string3 = brokerConfig.getProperty(CONNECTOR_PROPBASE + this.name + URL_SUFFIX);
        if (string3 == null) {
            string = brokerConfig.getProperty(CONNECTOR_PROPBASE + this.name + PROTOCOL_SUFFIX, "rmi");
            n = brokerConfig.getIntProperty(CONNECTOR_PROPBASE + this.name + PORT_SUFFIX, 0);
            string2 = brokerConfig.getProperty(CONNECTOR_PROPBASE + this.name + URLPATH_SUFFIX);
            if (string2 == null && (this.agent.startRmiRegistry() || this.agent.useRmiRegistry())) {
                string2 = this.agent.getDefaultJMXUrlPathBase() + this.name;
            }
        }
        try {
            jMXServiceURL = string3 != null ? new JMXServiceURL(string3) : (string4 != null && !string4.equals("*") ? new JMXServiceURL(string, string4, n, string2) : new JMXServiceURL(string, null, n, string2));
        }
        catch (MalformedURLException malformedURLException) {
            throw new BrokerException(this.rb.getString("B2161", this.name), malformedURLException);
        }
        this.configuredURL = jMXServiceURL;
    }

    private void initConnectorServer() throws BrokerException {
        JMXConnectorServer jMXConnectorServer;
        BrokerConfig brokerConfig = Globals.getConfig();
        MBeanServer mBeanServer = this.agent.getMBeanServer();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string = Globals.getJMXHostname();
        if (this.connectorServer != null) {
            return;
        }
        if (mBeanServer == null) {
            throw new BrokerException(this.rb.getString("B4258", this.name));
        }
        boolean bl = brokerConfig.getBooleanProperty(CONNECTOR_PROPBASE + this.name + SSL_SUFFIX, false);
        boolean bl2 = brokerConfig.getBooleanProperty(CONNECTOR_PROPBASE + this.name + BROKER_HOST_TRUSTED_SUFFIX, false);
        int n = brokerConfig.getIntProperty(CONNECTOR_PROPBASE + this.name + BACKLOG_SUFFIX, 0);
        try {
            if (this.configuredURL.getProtocol().equals("rmi")) {
                Object object;
                boolean bl3 = true;
                if (bl3) {
                    hashMap.put("jmx.remote.authenticator", new MQJMXAuthenticator(this));
                }
                if (bl || string != null && !string.equals("*")) {
                    object = new MQRMIServerSocketFactory(string, n, bl);
                    hashMap.put("jmx.remote.rmi.server.socket.factory", object);
                }
                if (string != null && !string.equals("*")) {
                    object = new MQRMIClientSocketFactory(string, bl2, bl);
                    hashMap.put("jmx.remote.rmi.client.socket.factory", object);
                } else if (bl) {
                    if (bl2) {
                        object = new MQRMIClientSocketFactory(string, bl2, bl);
                        hashMap.put("jmx.remote.rmi.client.socket.factory", object);
                    } else {
                        hashMap.put("jmx.remote.rmi.client.socket.factory", new SslRMIClientSocketFactory());
                    }
                }
            }
            jMXConnectorServer = JMXConnectorServerFactory.newJMXConnectorServer(this.configuredURL, hashMap, mBeanServer);
        }
        catch (Exception exception) {
            throw new BrokerException(this.rb.getString("B2162", this.name), exception);
        }
        jMXConnectorServer.addNotificationListener(this.listener, null, this);
        this.connectorServer = jMXConnectorServer;
    }
}

