/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.cluster;

import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.BrokerState;
import com.sun.messaging.jmq.jmsserver.cluster.BrokerStatus;
import com.sun.messaging.jmq.jmsserver.cluster.ClusterListener;
import com.sun.messaging.jmq.jmsserver.cluster.ClusterManager;
import com.sun.messaging.jmq.jmsserver.cluster.ClusteredBroker;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.config.ConfigListener;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.core.BrokerMQAddress;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.CacheHashMap;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;

public class ClusterManagerImpl
implements ClusterManager,
ConfigListener {
    static final String DEBUG_ALL_PROP = "imq.cluster.debug.all";
    public static boolean debug_CLUSTER_ALL;
    public static boolean DEBUG_CLUSTER_ALL;
    static final String DEBUG_LOCK_PROP = "imq.cluster.debug.lock";
    public static boolean debug_CLUSTER_LOCK;
    public static boolean DEBUG_CLUSTER_LOCK;
    static final String DEBUG_TXN_PROP = "imq.cluster.debug.txn";
    public static boolean debug_CLUSTER_TXN;
    public static boolean DEBUG_CLUSTER_TXN;
    static final String DEBUG_TAKEOVER_PROP = "imq.cluster.debug.takeover";
    public static boolean debug_CLUSTER_TAKEOVER;
    public static boolean DEBUG_CLUSTER_TAKEOVER;
    static final String DEBUG_MSG_PROP = "imq.cluster.debug.msg";
    public static boolean debug_CLUSTER_MSG;
    public static boolean DEBUG_CLUSTER_MSG;
    static final String DEBUG_CONN_PROP = "imq.cluster.debug.conn";
    public static boolean debug_CLUSTER_CONN;
    public static boolean DEBUG_CLUSTER_CONN;
    static final String DEBUG_PING_PROP = "imq.cluster.debug.ping";
    public static boolean debug_CLUSTER_PING;
    public static boolean DEBUG_CLUSTER_PING;
    static final String DEBUG_PKT_PROP = "imq.cluster.debug.packet";
    public static boolean debug_CLUSTER_PACKET;
    public static boolean DEBUG_CLUSTER_PACKET;
    private static boolean DEBUG;
    protected BrokerConfig config = Globals.getConfig();
    protected Logger logger = Globals.getLogger();
    protected Set listeners = null;
    protected String transport = null;
    protected String clusterhost = null;
    protected int clusterport = 0;
    protected boolean initialized = false;
    protected String localBroker = null;
    protected String masterBroker = null;
    protected Map allBrokers = null;
    public static final String AUTOCONNECT_PROPERTY = "imq.cluster.brokerlist";
    protected static final String MANUAL_AUTOCONNECT_PROPERTY = "imq.cluster.brokerlist.manual";
    protected static final String MAX_OLD_SESSIONS = "imq.cluster.maxTakeoverSessions";
    protected int maxTakeoverSessions = Globals.getConfig().getIntProperty("imq.cluster.maxTakeoverSessions", 10);
    protected CacheHashMap oldSessionMap = new CacheHashMap(this.maxTakeoverSessions);
    private String clusterid = Globals.getClusterID();
    private BrokerResources br = Globals.getBrokerResources();
    private boolean brokerChangedProcessing = false;
    LinkedList brokerChangedEntryList = new LinkedList();
    int brokerindx = 0;

    public ClusterManagerImpl() {
        this.listeners = new LinkedHashSet();
    }

    public String getClusterId() {
        return this.clusterid;
    }

    protected Map getAllBrokers() throws BrokerException {
        return new HashMap();
    }

    public void setMQAddress(MQAddress mQAddress) throws Exception {
        if (!this.initialized) {
            this.initialize(mQAddress);
        } else {
            this.mqAddressChanged(mQAddress);
        }
    }

    public MQAddress getMQAddress() {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        return this.getLocalBroker().getBrokerURL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListener(ClusterListener clusterListener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(clusterListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeEventListener(ClusterListener clusterListener) {
        Set set = this.listeners;
        synchronized (set) {
            return this.listeners.remove(clusterListener);
        }
    }

    public ClusteredBroker getLocalBroker() {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        return this.getBroker(this.localBroker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getKnownBrokerCount() {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        Map map = this.allBrokers;
        synchronized (map) {
            return this.allBrokers.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConfigBrokerCount() {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        int n = 0;
        Map map = this.allBrokers;
        synchronized (map) {
            for (ClusteredBroker clusteredBroker : this.allBrokers.values()) {
                if (!clusteredBroker.isConfigBroker()) continue;
                ++n;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActiveBrokerCount() {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        int n = 0;
        Map map = this.allBrokers;
        synchronized (map) {
            for (ClusteredBroker clusteredBroker : this.allBrokers.values()) {
                if (!BrokerStatus.getBrokerLinkIsUp(clusteredBroker.getStatus())) continue;
                ++n;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getKnownBrokers(boolean bl) {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        HashSet hashSet = null;
        Map map = this.allBrokers;
        synchronized (map) {
            hashSet = new HashSet(this.allBrokers.values());
        }
        return hashSet.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getConfigBrokers() {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        HashSet hashSet = null;
        Map map = this.allBrokers;
        synchronized (map) {
            hashSet = new HashSet(this.allBrokers.values());
            return new ConfigInterator(hashSet.iterator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getActiveBrokers() {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        HashSet hashSet = null;
        Map map = this.allBrokers;
        synchronized (map) {
            hashSet = new HashSet(this.allBrokers.values());
            return new ActiveInterator(hashSet.iterator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusteredBroker getBroker(String string) {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        Map map = this.allBrokers;
        synchronized (map) {
            return (ClusteredBroker)this.allBrokers.get(string);
        }
    }

    public String activateBroker(MQAddress mQAddress, UID uID, String string, Object object) throws NoSuchElementException, BrokerException {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        String string2 = this.lookupBrokerID(mQAddress);
        if (string2 == null) {
            string2 = this.addBroker(mQAddress, false, false, uID);
        }
        return this.activateBroker(string2, uID, string, object);
    }

    public String activateBroker(String string, UID uID, String string2, Object object) throws NoSuchElementException, BrokerException {
        ClusteredBroker clusteredBroker = this.getBroker(string);
        if (clusteredBroker == null) {
            throw new BrokerException("Unknown broker " + string);
        }
        clusteredBroker.setInstanceName(string2);
        if (uID != null) {
            clusteredBroker.setBrokerSessionUID(uID);
        }
        clusteredBroker = this.updateBroker(clusteredBroker);
        clusteredBroker.setStatus(257, object);
        return string;
    }

    protected ClusteredBroker updateBroker(ClusteredBroker clusteredBroker) {
        return clusteredBroker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String addBroker(MQAddress mQAddress, boolean bl, boolean bl2, UID uID) throws NoSuchElementException, BrokerException {
        ClusteredBrokerImpl clusteredBrokerImpl = new ClusteredBrokerImpl(mQAddress, bl, uID);
        clusteredBrokerImpl.setConfigBroker(bl2);
        Map map = this.allBrokers;
        synchronized (map) {
            this.allBrokers.put(clusteredBrokerImpl.getBrokerName(), clusteredBrokerImpl);
        }
        this.brokerChanged(ClusterReason.ADDED, clusteredBrokerImpl.getBrokerName(), null, clusteredBrokerImpl, uID, null);
        return clusteredBrokerImpl.getBrokerName();
    }

    public void deactivateBroker(MQAddress mQAddress, Object object) throws NoSuchElementException {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        String string = this.lookupBrokerID(mQAddress);
        if (string == null) {
            throw new NoSuchElementException("Unknown URL " + string);
        }
        this.deactivateBroker(string, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivateBroker(String string, Object object) throws NoSuchElementException {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        ClusteredBroker clusteredBroker = null;
        boolean bl = false;
        Map map = this.allBrokers;
        synchronized (map) {
            clusteredBroker = (ClusteredBroker)this.allBrokers.get(string);
            if (clusteredBroker == null) {
                throw new NoSuchElementException("Unknown Broker" + string);
            }
            if (!clusteredBroker.isConfigBroker()) {
                this.allBrokers.remove(string);
                bl = true;
            }
            clusteredBroker.setInstanceName(null);
        }
        clusteredBroker.setStatus(BrokerStatus.setBrokerLinkIsDown(clusteredBroker.getStatus()), object);
        if (bl) {
            this.brokerChanged(ClusterReason.REMOVED, clusteredBroker.getBrokerName(), clusteredBroker, null, clusteredBroker.getBrokerSessionUID(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lookupBrokerID(MQAddress mQAddress) {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        Map map = this.allBrokers;
        synchronized (map) {
            for (ClusteredBroker clusteredBroker : this.allBrokers.values()) {
                MQAddress mQAddress2 = clusteredBroker.getBrokerURL();
                if (!mQAddress2.equals(mQAddress)) continue;
                return clusteredBroker.getBrokerName();
            }
        }
        return null;
    }

    public String lookupStoreSessionOwner(UID uID) {
        return null;
    }

    public String getStoreSessionCreator(UID uID) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lookupBrokerSessionUID(UID uID) {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        Map map = this.allBrokers;
        synchronized (map) {
            for (ClusteredBroker clusteredBroker : this.allBrokers.values()) {
                UID uID2 = clusteredBroker.getBrokerSessionUID();
                if (!uID2.equals(uID)) continue;
                return clusteredBroker.getBrokerName();
            }
        }
        return null;
    }

    protected boolean allowMasterBroker() {
        return true;
    }

    public ClusteredBroker getMasterBroker() {
        if (this.masterBroker == null) {
            return null;
        }
        return this.getBroker(this.masterBroker);
    }

    public String getTransport() {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        return this.transport;
    }

    public int getClusterPort() {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        return this.clusterport;
    }

    public String getClusterHost() {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        return this.clusterhost;
    }

    public boolean isHA() {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        return false;
    }

    public void reloadConfig() throws BrokerException {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        String[] stringArray = new String[]{"imq.cluster.url", AUTOCONNECT_PROPERTY};
        this.config.reloadProps(Globals.getConfigName(), stringArray, false);
    }

    public String initialize(MQAddress mQAddress) throws BrokerException {
        Object object;
        Object object22;
        this.initialized = true;
        this.allBrokers = this.getAllBrokers();
        this.config.addListener("imq.cluster.transport", this);
        this.config.addListener("imq.cluster.hostname", this);
        this.config.addListener("imq.cluster.port", this);
        this.config.addListener(AUTOCONNECT_PROPERTY, this);
        this.config.addListener("imq.cluster.masterbroker", this);
        this.config.addListener(DEBUG_ALL_PROP, this);
        this.config.addListener(DEBUG_LOCK_PROP, this);
        this.config.addListener(DEBUG_TXN_PROP, this);
        this.config.addListener(DEBUG_TAKEOVER_PROP, this);
        this.config.addListener(DEBUG_MSG_PROP, this);
        this.config.addListener(DEBUG_CONN_PROP, this);
        this.config.addListener(DEBUG_PING_PROP, this);
        this.config.addListener(DEBUG_PKT_PROP, this);
        this.transport = this.config.getProperty("imq.cluster.transport");
        if (this.transport == null) {
            this.transport = "tcp";
        }
        this.clusterhost = this.config.getProperty("imq.cluster.hostname");
        if (this.clusterhost == null) {
            this.clusterhost = Globals.getHostname();
            if (this.clusterhost != null && this.clusterhost.equals("*")) {
                this.clusterhost = null;
            }
        }
        this.clusterport = this.config.getIntProperty("imq.cluster.port", 0);
        Set set = null;
        try {
            set = this.parseBrokerList();
        }
        catch (Exception exception) {
            this.logger.logStack(32, Globals.getBrokerResources().getKString("B4315", exception.toString()), exception);
            throw new BrokerException(exception.getMessage(), exception);
        }
        this.localBroker = this.addBroker(mQAddress, true, set.remove(mQAddress), new UID());
        this.getLocalBroker().setStatus(257, null);
        for (Object object22 : set) {
            try {
                object = this.getLocalBroker();
                if (((MQAddress)object22).equals(this.getMQAddress())) {
                    if (!(object instanceof ClusteredBrokerImpl)) continue;
                    ((ClusteredBrokerImpl)object).setConfigBroker(true);
                    continue;
                }
                String string = this.addBroker((MQAddress)object22, false, true, null);
            }
            catch (NoSuchElementException noSuchElementException) {
                this.logger.log(8, "B3100", (Object)"bad address in the broker list ", (Throwable)noSuchElementException);
            }
        }
        object22 = this.config.getProperty("imq.cluster.masterbroker");
        if (!this.allowMasterBroker()) {
            if (DEBUG || this.logger.getLevel() <= 4) {
                this.logger.log(8, "This broker does not allow imq.cluster.masterbroker to be configured." + (object22 == null ? "" : " Ignore imq.cluster.masterbroker=" + (String)object22));
            }
            object22 = null;
        } else if (Globals.useSharedConfigRecord()) {
            if (object22 == null) {
                this.logger.log(8, this.br.getKString("B1359"));
            } else {
                this.logger.log(16, this.br.getKString("B1360", "imq.cluster.masterbroker=" + (String)object22));
            }
            object22 = null;
        }
        if (object22 != null) {
            object = null;
            try {
                object = BrokerMQAddress.createAddress((String)object22);
            }
            catch (Exception exception) {
                this.logger.log(32, "B3100", (Object)"bad address while parsing the broker list ", (Throwable)exception);
            }
            this.masterBroker = this.lookupBrokerID((MQAddress)object);
            if (this.masterBroker == null) {
                this.logger.log(16, "B2132", ((MQAddress)object).toString());
                this.masterBroker = this.addBroker((MQAddress)object, false, true, null);
            }
            this.masterBroker = this.lookupBrokerID((MQAddress)object);
        }
        if (DEBUG) {
            this.logger.log(4, "Cluster is:" + this.toString());
        }
        return this.localBroker;
    }

    protected Set parseBrokerList() throws MalformedURLException, UnknownHostException {
        String string = this.config.getProperty(AUTOCONNECT_PROPERTY);
        String string2 = this.config.getProperty(MANUAL_AUTOCONNECT_PROPERTY);
        String string3 = null;
        if (string == null && string2 == null) {
            return new HashSet();
        }
        string3 = string == null ? string2 : (string2 == null ? string : string2 + "," + string);
        return ClusterManagerImpl.parseBrokerList(string3);
    }

    public static Set parseBrokerList(String string) throws MalformedURLException, UnknownHostException {
        HashMap<String, BrokerMQAddress> hashMap = new HashMap<String, BrokerMQAddress>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            BrokerMQAddress brokerMQAddress = BrokerMQAddress.createAddress(string2);
            hashMap.put(((MQAddress)brokerMQAddress).toString(), brokerMQAddress);
        }
        return new HashSet(hashMap.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String string = "ClusterManager: [local=" + this.localBroker + ", master = " + this.masterBroker + "]\n";
        Map map = this.allBrokers;
        synchronized (map) {
            Iterator iterator = this.allBrokers.values().iterator();
            while (iterator.hasNext()) {
                string = string + "\t" + iterator.next() + "\n";
            }
        }
        return string;
    }

    public synchronized UID getStoreSessionUID() {
        return null;
    }

    public synchronized UID getBrokerSessionUID() {
        return this.getLocalBroker().getBrokerSessionUID();
    }

    protected void addSupportedStoreSessionUID(UID uID) {
        this.oldSessionMap.put(uID, uID);
    }

    public Set getSupportedStoreSessionUIDs() {
        HashSet hashSet = new HashSet(this.oldSessionMap.values());
        if (this.getStoreSessionUID() != null) {
            hashSet.add(this.getStoreSessionUID());
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void brokerListChanged() throws BrokerException {
        Iterator<Object> iterator;
        Object object;
        Serializable serializable2;
        HashSet hashSet = null;
        try {
            hashSet = this.parseBrokerList();
            if (DEBUG) {
                this.logger.log(8, "ClusterManagerImpl.parseBrokerList:" + hashSet);
            }
        }
        catch (Exception exception) {
            this.logger.log(32, "B3100", (Object)"bad address in brokerListChanged ", (Throwable)exception);
            hashSet = new HashSet();
        }
        for (Serializable serializable2 : hashSet) {
            if (this.lookupBrokerID((MQAddress)serializable2) != null) continue;
            object = this.addBroker((MQAddress)serializable2, false, true, null);
        }
        serializable2 = new ArrayList();
        object = this.allBrokers;
        synchronized (object) {
            iterator = this.allBrokers.values().iterator();
            while (iterator.hasNext()) {
                ClusteredBroker clusteredBroker = (ClusteredBroker)iterator.next();
                ((ClusteredBrokerImpl)clusteredBroker).setConfigBroker(true);
                MQAddress mQAddress = clusteredBroker.getBrokerURL();
                if (hashSet.contains(mQAddress)) {
                    hashSet.remove(mQAddress);
                    continue;
                }
                if (clusteredBroker.isLocalBroker()) continue;
                serializable2.add(clusteredBroker);
                iterator.remove();
            }
        }
        iterator = serializable2.iterator();
        while (iterator.hasNext()) {
            object = (ClusteredBroker)iterator.next();
            this.brokerChanged(ClusterReason.REMOVED, object.getBrokerName(), object, null, object.getBrokerSessionUID(), null);
            iterator.remove();
        }
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            this.addBroker((MQAddress)iterator.next(), false, true, null);
        }
    }

    protected void masterBrokerChanged(String string) throws BrokerException {
        Object object;
        ClusteredBroker clusteredBroker = this.getMasterBroker();
        this.masterBroker = null;
        if (string != null) {
            object = null;
            try {
                object = BrokerMQAddress.createAddress(string);
            }
            catch (Exception exception) {
                this.logger.log(32, "B2133", (Object)string, (Throwable)exception);
            }
            this.masterBroker = this.lookupBrokerID((MQAddress)object);
            if (object == null) {
                this.masterBroker = this.addBroker((MQAddress)object, false, true, null);
            }
        }
        object = this.getMasterBroker();
        this.brokerChanged(ClusterReason.MASTER_BROKER_CHANGED, null, clusteredBroker, object, null, null);
    }

    protected void mqAddressChanged(MQAddress mQAddress) throws Exception {
        ClusteredBroker clusteredBroker = this.getLocalBroker();
        MQAddress mQAddress2 = clusteredBroker.getBrokerURL();
        clusteredBroker.setBrokerURL(mQAddress);
        this.brokerChanged(ClusterReason.ADDRESS_CHANGED, clusteredBroker.getBrokerName(), mQAddress2, mQAddress, null, null);
    }

    public void validate(String string, String string2) throws PropertyUpdateException {
        if (string.equals("imq.cluster.transport")) {
            throw new PropertyUpdateException(this.br.getString("B4028", string));
        }
        if (string.equals("imq.cluster.hostname")) {
            throw new PropertyUpdateException(this.br.getString("B4028", string));
        }
        if (string.equals("imq.cluster.port")) {
            try {
                Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new PropertyUpdateException(2, "imq.cluster.port should be set to an int not " + string2);
            }
        }
        if (!string.equals(AUTOCONNECT_PROPERTY) && string.equals("imq.cluster.masterbroker")) {
            try {
                BrokerMQAddress.createAddress(string2);
            }
            catch (Exception exception) {
                throw new PropertyUpdateException(this.br.getString("B4028", string2) + ": " + exception.getMessage());
            }
        }
    }

    public boolean update(String string, String string2) {
        if (string.equals("imq.cluster.transport")) {
            this.transport = string2;
            if (this.transport == null || this.transport.length() == 0) {
                this.transport = "tcp";
            }
            this.clusterPropertyChanged(string, string2);
        } else if (string.equals("imq.cluster.hostname")) {
            this.clusterPropertyChanged(string, string2);
        } else if (string.equals("imq.cluster.port")) {
            this.clusterPropertyChanged(string, string2);
        } else if (string.equals(AUTOCONNECT_PROPERTY)) {
            if (DEBUG) {
                this.logger.log(8, "ClusterManagerImpl.update(" + string + "=" + string2 + ")");
            }
            try {
                this.brokerListChanged();
            }
            catch (Exception exception) {
                this.logger.log(8, "INTERNAL ERROR", exception);
            }
        } else if (string.equals("imq.cluster.masterbroker")) {
            try {
                this.masterBrokerChanged(string2);
            }
            catch (Exception exception) {
                this.logger.log(8, "INTERNAL ERROR", exception);
            }
        } else if (string.equals(DEBUG_ALL_PROP)) {
            DEBUG_CLUSTER_ALL = Boolean.valueOf(string2);
            DEBUG_CLUSTER_LOCK = Boolean.valueOf(string2);
            DEBUG_CLUSTER_TXN = Boolean.valueOf(string2);
            DEBUG_CLUSTER_TAKEOVER = Boolean.valueOf(string2);
            DEBUG_CLUSTER_MSG = Boolean.valueOf(string2);
            DEBUG_CLUSTER_CONN = Boolean.valueOf(string2);
            DEBUG_CLUSTER_PING = Boolean.valueOf(string2);
            DEBUG_CLUSTER_PACKET = Boolean.valueOf(string2);
        } else if (string.equals(DEBUG_LOCK_PROP)) {
            DEBUG_CLUSTER_LOCK = Boolean.valueOf(string2);
        } else if (string.equals(DEBUG_TXN_PROP)) {
            DEBUG_CLUSTER_TXN = Boolean.valueOf(string2);
        } else if (string.equals(DEBUG_TAKEOVER_PROP)) {
            DEBUG_CLUSTER_TAKEOVER = Boolean.valueOf(string2);
        } else if (string.equals(DEBUG_MSG_PROP)) {
            DEBUG_CLUSTER_MSG = Boolean.valueOf(string2);
        } else if (string.equals(DEBUG_CONN_PROP)) {
            DEBUG_CLUSTER_CONN = Boolean.valueOf(string2);
        } else if (string.equals(DEBUG_PING_PROP)) {
            DEBUG_CLUSTER_PING = Boolean.valueOf(string2);
        } else if (string.equals(DEBUG_PKT_PROP)) {
            DEBUG_CLUSTER_PACKET = Boolean.valueOf(string2);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clusterPropertyChanged(String string, String string2) {
        Set set = this.listeners;
        synchronized (set) {
            if (this.listeners.size() == 0) {
                return;
            }
            for (ClusterListener clusterListener : this.listeners) {
                clusterListener.clusterPropertyChanged(string, string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void brokerChanged(ClusterReason clusterReason, String string, Object object, Object object2, UID uID, Object object3) {
        LinkedList linkedList;
        Object object4 = this.listeners;
        synchronized (object4) {
            if (this.listeners.size() == 0) {
                return;
            }
        }
        object4 = new BrokerChangedEntry(clusterReason, string, object, object2, uID, object3);
        Object object5 = this.brokerChangedEntryList;
        synchronized (object5) {
            this.brokerChangedEntryList.add(object4);
            if (this.brokerChangedProcessing) {
                return;
            }
            this.brokerChangedProcessing = true;
        }
        try {
            object5 = null;
            block22: while (true) {
                Object object6;
                ClusterListener[] clusterListenerArray = null;
                Set set = this.listeners;
                synchronized (set) {
                    object6 = this.brokerChangedEntryList;
                    synchronized (object6) {
                        if (this.listeners.size() == 0 || this.brokerChangedEntryList.isEmpty()) {
                            this.brokerChangedProcessing = false;
                            break;
                        }
                        object5 = (BrokerChangedEntry)this.brokerChangedEntryList.removeFirst();
                    }
                    clusterListenerArray = new ClusterListener[this.listeners.size()];
                    clusterListenerArray = this.listeners.toArray(new ClusterListener[0]);
                }
                int n = 0;
                while (true) {
                    block41: {
                        if (n >= clusterListenerArray.length) continue block22;
                        object6 = clusterListenerArray[n];
                        Set set2 = this.listeners;
                        synchronized (set2) {
                            if (!this.listeners.contains(object6)) {
                                break block41;
                            }
                        }
                        if (((BrokerChangedEntry)object5).reason == ClusterReason.ADDED) {
                            object6.brokerAdded((ClusteredBroker)((BrokerChangedEntry)object5).newValue, ((BrokerChangedEntry)object5).brokerSession);
                        } else if (((BrokerChangedEntry)object5).reason == ClusterReason.REMOVED) {
                            object6.brokerRemoved((ClusteredBroker)((BrokerChangedEntry)object5).oldValue, ((BrokerChangedEntry)object5).brokerSession);
                        } else if (((BrokerChangedEntry)object5).reason == ClusterReason.STATUS_CHANGED) {
                            object6.brokerStatusChanged(((BrokerChangedEntry)object5).brokerid, (Integer)((BrokerChangedEntry)object5).oldValue, (Integer)((BrokerChangedEntry)object5).newValue, ((BrokerChangedEntry)object5).brokerSession, ((BrokerChangedEntry)object5).userData);
                        } else if (((BrokerChangedEntry)object5).reason == ClusterReason.STATE_CHANGED) {
                            object6.brokerStateChanged(((BrokerChangedEntry)object5).brokerid, (BrokerState)((BrokerChangedEntry)object5).oldValue, (BrokerState)((BrokerChangedEntry)object5).newValue);
                        } else if (((BrokerChangedEntry)object5).reason == ClusterReason.VERSION_CHANGED) {
                            object6.brokerVersionChanged(((BrokerChangedEntry)object5).brokerid, (Integer)((BrokerChangedEntry)object5).oldValue, (Integer)((BrokerChangedEntry)object5).newValue);
                        } else if (((BrokerChangedEntry)object5).reason == ClusterReason.ADDRESS_CHANGED) {
                            object6.brokerURLChanged(((BrokerChangedEntry)object5).brokerid, (MQAddress)((BrokerChangedEntry)object5).oldValue, (MQAddress)((BrokerChangedEntry)object5).newValue);
                        } else if (((BrokerChangedEntry)object5).reason == ClusterReason.MASTER_BROKER_CHANGED) {
                            object6.masterBrokerChanged((ClusteredBroker)((BrokerChangedEntry)object5).oldValue, (ClusteredBroker)((BrokerChangedEntry)object5).newValue);
                        }
                    }
                    ++n;
                }
                break;
            }
            Object var16_19 = null;
            linkedList = this.brokerChangedEntryList;
        }
        catch (Throwable throwable) {
            Object var16_20 = null;
            LinkedList linkedList2 = this.brokerChangedEntryList;
            synchronized (linkedList2) {
                this.brokerChangedProcessing = false;
            }
            throw throwable;
        }
        synchronized (linkedList) {
            this.brokerChangedProcessing = false;
        }
    }

    static {
        DEBUG_CLUSTER_ALL = debug_CLUSTER_ALL = Globals.getConfig().getBooleanProperty(DEBUG_ALL_PROP);
        DEBUG_CLUSTER_LOCK = debug_CLUSTER_LOCK = Globals.getConfig().getBooleanProperty(DEBUG_LOCK_PROP);
        DEBUG_CLUSTER_TXN = debug_CLUSTER_TXN = Globals.getConfig().getBooleanProperty(DEBUG_TXN_PROP);
        DEBUG_CLUSTER_TAKEOVER = debug_CLUSTER_TAKEOVER = Globals.getConfig().getBooleanProperty(DEBUG_TAKEOVER_PROP);
        DEBUG_CLUSTER_MSG = debug_CLUSTER_MSG = Globals.getConfig().getBooleanProperty(DEBUG_MSG_PROP);
        DEBUG_CLUSTER_CONN = debug_CLUSTER_CONN = Globals.getConfig().getBooleanProperty(DEBUG_CONN_PROP);
        DEBUG_CLUSTER_PING = debug_CLUSTER_PING = Globals.getConfig().getBooleanProperty(DEBUG_PING_PROP);
        DEBUG_CLUSTER_PACKET = debug_CLUSTER_PACKET = Globals.getConfig().getBooleanProperty(DEBUG_PKT_PROP);
        DEBUG = false;
    }

    public static class ClusterReason {
        private final String name;
        public static final ClusterReason ADDED = new ClusterReason("ADDED");
        public static final ClusterReason REMOVED = new ClusterReason("REMOVED");
        public static final ClusterReason STATUS_CHANGED = new ClusterReason("STATUS_CHANGED");
        public static final ClusterReason STATE_CHANGED = new ClusterReason("STATE_CHANGED");
        public static final ClusterReason VERSION_CHANGED = new ClusterReason("VERSION_CHANGED");
        public static final ClusterReason ADDRESS_CHANGED = new ClusterReason("ADDRESS_CHANGED");
        public static final ClusterReason MASTER_BROKER_CHANGED = new ClusterReason("MASTER_BROKER_CHANGED");

        private ClusterReason(String string) {
            this.name = string;
        }

        public String toString() {
            return "ClusterReason[" + this.name + "]";
        }
    }

    class ClusteredBrokerImpl
    implements ClusteredBroker {
        String brokerName = null;
        MQAddress address = null;
        transient String instanceName = null;
        boolean local = false;
        boolean configed = false;
        Integer status = new Integer(0);
        BrokerState state = BrokerState.INITIALIZING;
        Integer version = new Integer(0);
        UID brokerSessionUID = null;
        boolean isgen = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ClusteredBrokerImpl(MQAddress mQAddress, boolean bl, UID uID) {
            this.local = bl;
            this.address = mQAddress;
            this.brokerSessionUID = uID;
            ClusteredBrokerImpl clusteredBrokerImpl = this;
            synchronized (clusteredBrokerImpl) {
                if (bl) {
                    this.brokerName = Globals.getBrokerID();
                    this.instanceName = Globals.getConfigName();
                }
                if (this.brokerName == null) {
                    this.isgen = true;
                    ++ClusterManagerImpl.this.brokerindx;
                    this.brokerName = "broker" + ClusterManagerImpl.this.brokerindx;
                }
            }
        }

        private ClusteredBrokerImpl() {
        }

        public boolean equals(Object object) {
            if (!(object instanceof ClusteredBroker)) {
                return false;
            }
            return this.getBrokerName().equals(((ClusteredBroker)object).getBrokerName());
        }

        public int hashCode() {
            return this.getBrokerName().hashCode();
        }

        public String toString() {
            if (!this.local) {
                return this.brokerName + "(" + this.address + ")";
            }
            return this.brokerName + "* (" + this.address + ")";
        }

        public String getBrokerName() {
            return this.brokerName;
        }

        public MQAddress getBrokerURL() {
            return this.address;
        }

        public String getInstanceName() {
            return this.instanceName;
        }

        public void setInstanceName(String string) {
            this.instanceName = string;
        }

        public void setBrokerURL(MQAddress mQAddress) throws Exception {
            MQAddress mQAddress2 = this.address;
            this.address = mQAddress;
            ClusterManagerImpl.this.brokerChanged(ClusterReason.ADDRESS_CHANGED, this.getBrokerName(), mQAddress2, this.address, null, null);
        }

        public boolean isLocalBroker() {
            return this.local;
        }

        public synchronized int getStatus() {
            return this.status;
        }

        public synchronized int getVersion() {
            return this.version == null ? 0 : this.version;
        }

        public synchronized void setVersion(int n) throws Exception {
            Integer n2 = this.version;
            this.version = new Integer(n);
            ClusterManagerImpl.this.brokerChanged(ClusterReason.VERSION_CHANGED, this.getBrokerName(), n2, this.version, null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setStatus(int n, Object object) {
            Integer n2 = null;
            UID uID = null;
            if (BrokerStatus.getBrokerIsDown(n)) {
                n = BrokerStatus.setBrokerLinkIsDown(n);
            } else if (BrokerStatus.getBrokerLinkIsDown(n)) {
                n = BrokerStatus.setBrokerIsDown(n);
            } else if (BrokerStatus.getBrokerLinkIsUp(n)) {
                n = BrokerStatus.setBrokerIsUp(n);
            } else if (BrokerStatus.getBrokerIsUp(n)) {
                n = BrokerStatus.setBrokerLinkIsUp(n);
            }
            ClusteredBrokerImpl clusteredBrokerImpl = this;
            synchronized (clusteredBrokerImpl) {
                if (this.status == n) {
                    return;
                }
                n2 = this.status;
                this.status = new Integer(n);
                uID = this.getBrokerSessionUID();
            }
            ClusterManagerImpl.this.brokerChanged(ClusterReason.STATUS_CHANGED, this.getBrokerName(), n2, this.status, uID, object);
            try {
                if (BrokerStatus.getBrokerIsUp(n)) {
                    this.setState(BrokerState.OPERATING);
                }
                if (BrokerStatus.getBrokerIsDown(n)) {
                    this.setState(BrokerState.SHUTDOWN_COMPLETE);
                }
            }
            catch (Exception exception) {
                ClusterManagerImpl.this.logger.logStack(4, "Error setting state ", exception);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setBrokerIsUp(boolean bl, UID uID, Object object) {
            UID uID2 = uID;
            Integer n = null;
            Integer n2 = null;
            ClusteredBrokerImpl clusteredBrokerImpl = this;
            synchronized (clusteredBrokerImpl) {
                if (!bl && !uID2.equals(this.getBrokerSessionUID())) {
                    Logger cfr_ignored_0 = ClusterManagerImpl.this.logger;
                    ClusterManagerImpl.this.logger.log(8, ClusterManagerImpl.this.br.getKString("B1337", "[BrokerSession:" + uID2 + "]", this.toString()));
                    n = new Integer(16);
                    n2 = BrokerStatus.setBrokerIsDown(n);
                } else {
                    n = this.status;
                    int n3 = 0;
                    n3 = bl ? BrokerStatus.setBrokerIsUp(this.status) : BrokerStatus.setBrokerIsDown(this.status);
                    this.status = new Integer(n3);
                    uID2 = this.getBrokerSessionUID();
                    n2 = this.status;
                }
            }
            ClusterManagerImpl.this.brokerChanged(ClusterReason.STATUS_CHANGED, this.getBrokerName(), n, n2, uID2, object);
            try {
                if (bl) {
                    this.setState(BrokerState.OPERATING);
                } else {
                    this.setState(BrokerState.SHUTDOWN_COMPLETE);
                }
            }
            catch (Exception exception) {
                ClusterManagerImpl.this.logger.logStack(4, "Error setting state ", exception);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setBrokerLinkUp(boolean bl, Object object) {
            Integer n = null;
            UID uID = null;
            ClusteredBrokerImpl clusteredBrokerImpl = this;
            synchronized (clusteredBrokerImpl) {
                n = this.status;
                uID = this.getBrokerSessionUID();
                int n2 = 0;
                n2 = bl ? BrokerStatus.setBrokerLinkIsUp(BrokerStatus.setBrokerIsUp(this.status)) : BrokerStatus.setBrokerLinkIsDown(BrokerStatus.setBrokerIsDown(this.status));
                this.status = new Integer(n2);
            }
            ClusterManagerImpl.this.brokerChanged(ClusterReason.STATUS_CHANGED, this.getBrokerName(), n, this.status, uID, object);
            try {
                if (bl) {
                    this.setState(BrokerState.OPERATING);
                } else {
                    this.setState(BrokerState.SHUTDOWN_COMPLETE);
                }
            }
            catch (Exception exception) {
                ClusterManagerImpl.this.logger.logStack(4, "Error setting state ", exception);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setBrokerInDoubt(boolean bl, Object object) {
            UID uID = (UID)object;
            Integer n = null;
            Integer n2 = null;
            ClusteredBrokerImpl clusteredBrokerImpl = this;
            synchronized (clusteredBrokerImpl) {
                if (bl && !uID.equals(this.getBrokerSessionUID())) {
                    Logger cfr_ignored_0 = ClusterManagerImpl.this.logger;
                    ClusterManagerImpl.this.logger.log(8, ClusterManagerImpl.this.br.getKString("B1336", "[BrokerSession:" + uID + "]", this.toString()));
                    n = new Integer(257);
                    n2 = BrokerStatus.setBrokerInDoubt(n);
                } else {
                    n = this.status;
                    int n3 = 0;
                    uID = this.getBrokerSessionUID();
                    n3 = bl ? BrokerStatus.setBrokerInDoubt(this.status) : BrokerStatus.setBrokerNotInDoubt(this.status);
                    n2 = this.status = new Integer(n3);
                }
            }
            ClusterManagerImpl.this.brokerChanged(ClusterReason.STATUS_CHANGED, this.getBrokerName(), n, n2, uID, object);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy() {
            Object object = this;
            synchronized (object) {
                this.status = new Integer(BrokerStatus.setBrokerIsDown(this.status));
            }
            object = ClusterManagerImpl.this.allBrokers;
            synchronized (object) {
                if (!this.isConfigBroker()) {
                    ClusterManagerImpl.this.allBrokers.remove(this.getBrokerName());
                }
            }
            ClusterManagerImpl.this.brokerChanged(ClusterReason.REMOVED, this.getBrokerName(), this, null, this.getBrokerSessionUID(), null);
        }

        public BrokerState getState() throws BrokerException {
            return this.state;
        }

        public void setState(BrokerState brokerState) throws IllegalAccessException, IllegalStateException, IllegalArgumentException {
            BrokerState brokerState2 = this.state;
            this.state = brokerState;
            ClusterManagerImpl.this.brokerChanged(ClusterReason.STATE_CHANGED, this.getBrokerName(), brokerState2, this.state, null, null);
        }

        public boolean isConfigBroker() {
            return this.configed;
        }

        protected void setConfigBroker(boolean bl) {
            this.configed = bl;
        }

        public synchronized UID getBrokerSessionUID() {
            return this.brokerSessionUID;
        }

        public synchronized void setBrokerSessionUID(UID uID) {
            this.brokerSessionUID = uID;
        }

        public boolean isBrokerIDGenerated() {
            return this.isgen;
        }
    }

    private class BrokerChangedEntry {
        ClusterReason reason = null;
        String brokerid = null;
        Object oldValue = null;
        Object newValue = null;
        Object userData = null;
        UID brokerSession = null;

        public BrokerChangedEntry(ClusterReason clusterReason, String string, Object object, Object object2, UID uID, Object object3) {
            this.reason = clusterReason;
            this.brokerid = string;
            this.oldValue = object;
            this.newValue = object2;
            this.userData = object3;
            this.brokerSession = uID;
        }
    }

    class ActiveInterator
    implements Iterator {
        Object nextObj = null;
        Iterator parent = null;

        public ActiveInterator(Iterator iterator) {
            this.parent = iterator;
        }

        public boolean hasNext() {
            if (this.nextObj != null) {
                return true;
            }
            if (this.nextObj == null && !this.parent.hasNext()) {
                return false;
            }
            while (this.nextObj == null && this.parent.hasNext()) {
                this.nextObj = this.parent.next();
                ClusteredBroker clusteredBroker = (ClusteredBroker)this.nextObj;
                if (!BrokerStatus.getBrokerLinkIsDown(clusteredBroker.getStatus())) continue;
                this.parent.remove();
                this.nextObj = null;
            }
            return this.nextObj != null;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("no more");
            }
            Object object = this.nextObj;
            this.nextObj = null;
            return object;
        }

        public void remove() {
            this.parent.remove();
        }
    }

    class ConfigInterator
    implements Iterator {
        Object nextObj = null;
        Iterator parent = null;

        public ConfigInterator(Iterator iterator) {
            this.parent = iterator;
        }

        public boolean hasNext() {
            if (this.nextObj != null) {
                return true;
            }
            if (this.nextObj == null && !this.parent.hasNext()) {
                return false;
            }
            while (this.nextObj == null && this.parent.hasNext()) {
                this.nextObj = this.parent.next();
                ClusteredBroker clusteredBroker = (ClusteredBroker)this.nextObj;
                if (clusteredBroker.isConfigBroker()) continue;
                this.parent.remove();
                this.nextObj = null;
            }
            return this.nextObj != null;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("no more");
            }
            Object object = this.nextObj;
            this.nextObj = null;
            return object;
        }

        public void remove() {
            this.parent.remove();
        }
    }
}

