/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.io.PacketProperties;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.persist.ChangeRecordInfo;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.UID;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class ClusterDestInfo {
    private Destination d = null;
    private GPacket pkt = null;
    private String destName = null;
    private int destType = -1;
    private ChangeRecordInfo shareccInfo = null;

    private ClusterDestInfo(Destination destination) {
        this.d = destination;
    }

    private ClusterDestInfo(GPacket gPacket) {
        assert (gPacket.getType() == 15 || gPacket.getType() == 13);
        this.pkt = gPacket;
        this.destName = (String)gPacket.getProp("N");
        this.destType = (Integer)gPacket.getProp("DT");
        if (gPacket.getProp("shareccSeq") != null) {
            this.shareccInfo = new ChangeRecordInfo();
            this.shareccInfo.setSeq((Long)gPacket.getProp("shareccSeq"));
            this.shareccInfo.setUUID((String)gPacket.getProp("shareccUUID"));
            this.shareccInfo.setResetUUID((String)gPacket.getProp("shareccResetUUID"));
            this.shareccInfo.setType(gPacket.getType());
        }
    }

    public static ClusterDestInfo newInstance(Destination destination) {
        return new ClusterDestInfo(destination);
    }

    public static ClusterDestInfo newInstance(GPacket gPacket) {
        return new ClusterDestInfo(gPacket);
    }

    public GPacket getGPacket(short s, boolean bl) {
        assert (this.d != null);
        assert (s == 15 || s == 13);
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType(s);
        gPacket.putProp("N", this.d.getDestinationName());
        gPacket.putProp("DT", new Integer(this.d.getType()));
        switch (s) {
            case 15: {
                ChangeRecordInfo changeRecordInfo = this.d.getCurrentChangeRecordInfo(15);
                if (changeRecordInfo == null) break;
                gPacket.putProp("shareccSeq", changeRecordInfo.getSeq());
                gPacket.putProp("shareccUUID", changeRecordInfo.getUUID());
                gPacket.putProp("shareccResetUUID", changeRecordInfo.getResetUUID());
                break;
            }
            case 13: {
                Serializable serializable;
                ChangeRecordInfo changeRecordInfo = this.d.getCurrentChangeRecordInfo(13);
                if (changeRecordInfo != null) {
                    gPacket.putProp("shareccSeq", changeRecordInfo.getSeq());
                    gPacket.putProp("shareccUUID", changeRecordInfo.getUUID());
                    gPacket.putProp("shareccResetUUID", changeRecordInfo.getResetUUID());
                }
                if (DestType.isTemporary(this.d.getType()) && (serializable = this.d.getConnectionUID()) != null) {
                    gPacket.putProp("connectionUID", new Long(((UID)serializable).longValue()));
                }
                if ((serializable = this.d.getDestinationProperties()) == null) {
                    serializable = new HashMap();
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                try {
                    PacketProperties.write((Map)((Object)serializable), byteArrayOutputStream);
                    byteArrayOutputStream.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                byte[] byArray = byteArrayOutputStream.toByteArray();
                gPacket.setPayload(ByteBuffer.wrap(byArray));
            }
        }
        if (bl) {
            gPacket.putProp("M", true);
        }
        return gPacket;
    }

    public DestinationUID getDestUID() throws BrokerException {
        assert (this.destName != null);
        return DestinationUID.getUID(this.destName, DestType.isQueue(this.destType));
    }

    public int getDestType() {
        assert (this.pkt != null);
        return this.destType;
    }

    public String getDestName() {
        assert (this.pkt != null);
        return this.destName;
    }

    public ChangeRecordInfo getShareccInfo() {
        return this.shareccInfo;
    }

    public Hashtable getDestProps() throws IOException, ClassNotFoundException {
        assert (this.pkt != null);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.pkt.getPayload().array());
        return PacketProperties.parseProperties(byteArrayInputStream);
    }
}

