/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util.log;

import com.sun.messaging.jmq.resources.SharedResources;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.util.Properties;
import java.util.StringTokenizer;

public abstract class LogHandler {
    public int levels = 120;
    protected Logger logger = null;
    protected static final SharedResources rb = SharedResources.getResources();
    protected String name = null;
    private boolean allowForceMessage = true;

    public boolean isAllowForceMessage() {
        return this.allowForceMessage;
    }

    protected void setAllowForceMessage(boolean bl) {
        this.allowForceMessage = bl;
    }

    public void acceptAllLevels() {
        this.levels = 127;
    }

    protected void setLevels(String string) throws IllegalArgumentException {
        this.levels = 0;
        this.levels = 64;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|", false);
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("ALL")) {
                this.acceptAllLevels();
                break;
            }
            if (string2.equals("NONE")) {
                this.levels = 0;
                break;
            }
            if (string2.equals("NOFORCE")) {
                this.setAllowForceMessage(false);
                continue;
            }
            this.levels |= Logger.levelStrToInt(string2);
        }
    }

    public void init(Logger logger) {
        this.logger = logger;
        this.acceptAllLevels();
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void flush() {
    }

    public abstract void configure(Properties var1, String var2) throws IllegalArgumentException;

    public abstract void publish(int var1, String var2) throws IOException;

    public abstract void open() throws IOException;

    public abstract void close();
}

