/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.stomp;

import com.sun.grizzly.Context;
import com.sun.messaging.bridge.service.BridgeContext;
import com.sun.messaging.bridge.service.MessageTransformer;
import com.sun.messaging.bridge.service.stomp.NotConnectedException;
import com.sun.messaging.bridge.service.stomp.StompConnection;
import com.sun.messaging.bridge.service.stomp.StompFrameMessage;
import com.sun.messaging.bridge.service.stomp.StompOutputHandler;
import com.sun.messaging.bridge.service.stomp.StompProtocolException;
import com.sun.messaging.bridge.service.stomp.StompSenderSession;
import com.sun.messaging.bridge.service.stomp.StompServer;
import com.sun.messaging.bridge.service.stomp.StompSubscriberSession;
import com.sun.messaging.bridge.service.stomp.StompTransactedSession;
import com.sun.messaging.bridge.service.stomp.UnrecoverableAckFailureException;
import com.sun.messaging.bridge.service.stomp.resources.StompBridgeResources;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;

public class StompProtocolHandler {
    private Logger _logger = null;
    private static final String DEFAULT_SUBID_PREFIX = "/subscription-to/";
    private static final String MQ_TEMP_QUEUE_PREFIX = "temporary_destination://queue/";
    private static final String MQ_TEMP_TOPIC_PREFIX = "temporary_destination://topic/";
    private StompConnection _stompConnection = null;
    private Map<String, TemporaryQueue> _tempQueues = Collections.synchronizedMap(new HashMap());
    private Map<String, TemporaryTopic> _tempTopics = Collections.synchronizedMap(new HashMap());
    private Map<String, TemporaryQueue> _mqtempQueues = Collections.synchronizedMap(new HashMap());
    private Map<String, TemporaryTopic> _mqtempTopics = Collections.synchronizedMap(new HashMap());
    private List<String> _subids = Collections.synchronizedList(new ArrayList());
    private StompBridgeResources _sbr = null;

    public StompProtocolHandler(BridgeContext bridgeContext, Properties properties) {
        this._logger = StompServer.logger();
        this._sbr = StompServer.getStompBridgeResources();
        this._stompConnection = new StompConnection(bridgeContext, properties, this);
    }

    public void close(boolean bl) {
        this._logger.log(Level.INFO, this._sbr.getString("BSS1008", this._stompConnection));
        if (!bl) {
            try {
                this._stompConnection.disconnect(false);
            }
            catch (Throwable throwable) {
                this._logger.log(Level.WARNING, this._sbr.getKString("BSS2003", this._stompConnection.toString(), throwable.getMessage()));
            }
            return;
        }
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    StompProtocolHandler.this._stompConnection.disconnect(false);
                }
                catch (Throwable throwable) {
                    Logger logger = StompProtocolHandler.this._logger;
                    StompBridgeResources stompBridgeResources = StompProtocolHandler.this._sbr;
                    StompProtocolHandler.this._sbr;
                    logger.log(Level.WARNING, stompBridgeResources.getKString("BSS2003", StompProtocolHandler.this._stompConnection.toString(), throwable.getMessage()));
                }
            }
        });
        thread.setName("SpawnedClosingThread");
        thread.setDaemon(true);
        thread.start();
    }

    public void onCONNECT(StompFrameMessage stompFrameMessage, StompOutputHandler stompOutputHandler, Context context) {
        StompFrameMessage stompFrameMessage2 = null;
        try {
            String string = stompFrameMessage.getHeader("login".toString());
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, "on" + (Object)((Object)stompFrameMessage.getCommand()) + ", login=" + string);
            }
            String string2 = stompFrameMessage.getHeader("passcode".toString());
            String string3 = stompFrameMessage.getHeader("client-id".toString());
            String string4 = this._stompConnection.connect(string, string2, string3);
            stompFrameMessage2 = new StompFrameMessage(StompFrameMessage.Command.CONNECTED);
            stompFrameMessage2.addHeader("session".toString(), string4);
            String string5 = stompFrameMessage.getHeader("receipt".toString());
            if (string5 != null) {
                stompFrameMessage2.addHeader("receipt-id".toString(), string5);
            }
            stompOutputHandler.sendToClient(stompFrameMessage2, context, this);
        }
        catch (Exception exception) {
            Object[] objectArray = new String[]{stompFrameMessage.getCommand().toString(), exception.getMessage(), this._stompConnection.toString()};
            this._logger.log(Level.SEVERE, this._sbr.getKString("BSS3002", objectArray), exception);
            try {
                stompFrameMessage2 = StompProtocolHandler.toStompErrorMessage(StompFrameMessage.Command.CONNECT.toString(), exception);
                stompOutputHandler.sendToClient(stompFrameMessage2, context, this);
            }
            catch (Exception exception2) {
                this._logger.log(Level.WARNING, this._sbr.getKString("BSS3001", exception.getMessage(), exception2.getMessage()), exception2);
                return;
            }
        }
    }

    public void onDISCONNECT(StompFrameMessage stompFrameMessage, StompOutputHandler stompOutputHandler, Context context) {
        try {
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, "on" + (Object)((Object)stompFrameMessage.getCommand()));
            }
            this._stompConnection.disconnect(true);
            StompFrameMessage stompFrameMessage2 = StompProtocolHandler.getStompReceiptMessage(stompFrameMessage);
            if (stompFrameMessage2 != null) {
                stompOutputHandler.sendToClient(stompFrameMessage2, context, this);
            }
        }
        catch (Exception exception) {
            Object[] objectArray = new String[]{stompFrameMessage.getCommand().toString(), exception.getMessage(), this._stompConnection.toString()};
            if (exception instanceof NotConnectedException) {
                this._logger.log(Level.SEVERE, this._sbr.getKString("BSS3002", objectArray));
                return;
            }
            this._logger.log(Level.SEVERE, this._sbr.getKString("BSS3002", objectArray), exception);
            try {
                StompFrameMessage stompFrameMessage3 = StompProtocolHandler.toStompErrorMessage(StompFrameMessage.Command.DISCONNECT.toString(), exception);
                stompOutputHandler.sendToClient(stompFrameMessage3, context, this);
            }
            catch (Exception exception2) {
                this._logger.log(Level.WARNING, this._sbr.getKString("BSS3001", exception.getMessage(), exception2.getMessage()), exception2);
                return;
            }
        }
    }

    public void onSEND(StompFrameMessage stompFrameMessage, StompOutputHandler stompOutputHandler, Context context) {
        StompFrameMessage stompFrameMessage2 = null;
        Message message = null;
        StompSenderSession stompSenderSession = null;
        try {
            String string;
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            linkedHashMap.putAll(stompFrameMessage.getHeaders());
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, "on" + (Object)((Object)stompFrameMessage.getCommand()) + ", headers=" + linkedHashMap);
            }
            if ((string = (String)linkedHashMap.remove("transaction".toString())) != null) {
                stompSenderSession = this._stompConnection.getTransactedSession(string);
                this._logger.log(Level.FINE, "Sending message on transacted session: " + stompSenderSession + " for transaction " + string);
            } else {
                stompSenderSession = this._stompConnection.getSenderSession();
            }
            if (stompFrameMessage.getContentLength() != -1) {
                linkedHashMap.remove("content-length".toString());
                message = stompSenderSession.getJMSSession().createBytesMessage();
                ((BytesMessage)message).writeBytes(stompFrameMessage.getBody());
            } else {
                message = stompSenderSession.getJMSSession().createTextMessage();
                message.setText(stompFrameMessage.getBodyText());
            }
            String string2 = (String)linkedHashMap.remove("destination".toString());
            Destination destination = this.toJMSDestination(string2, stompSenderSession.getJMSSession(), false);
            MessageProducer messageProducer = stompSenderSession.getJMSProducer();
            int n = messageProducer.getPriority();
            String string3 = (String)linkedHashMap.remove("priority".toString());
            if (string3 != null) {
                n = Integer.parseInt(string3);
            }
            int n2 = messageProducer.getDeliveryMode();
            string3 = (String)linkedHashMap.remove("persistent".toString());
            if (string3 != null) {
                n2 = Boolean.valueOf(string3) != false ? 2 : 1;
            }
            long l = messageProducer.getTimeToLive();
            string3 = (String)linkedHashMap.remove("expires".toString());
            if (string3 != null) {
                l = Long.parseLong(string3);
            }
            message.setJMSCorrelationID((String)linkedHashMap.remove("correlation-id".toString()));
            string3 = (String)linkedHashMap.remove("type".toString());
            if (string3 != null) {
                message.setJMSType(string3);
            }
            if ((string3 = (String)linkedHashMap.remove("reply-to".toString())) != null) {
                message.setJMSReplyTo(this.toJMSDestination(string3, stompSenderSession.getJMSSession(), false));
            }
            string3 = (String)linkedHashMap.remove("receipt");
            MessageTransformer<Message, Message> messageTransformer = StompServer.getMessageTransformer();
            Properties properties = null;
            if (messageTransformer != null) {
                properties = new Properties();
            }
            String string4 = null;
            String string5 = null;
            String string6 = null;
            Iterator iterator = linkedHashMap.keySet().iterator();
            while (iterator.hasNext()) {
                string4 = (String)iterator.next();
                string5 = (String)linkedHashMap.get(string4);
                string6 = string4 + ":" + string5;
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.log(Level.FINE, "Setting header " + string6 + " as JMS message property");
                }
                try {
                    message.setStringProperty(string4, string5);
                    iterator.remove();
                }
                catch (JMSException jMSException) {
                    if (messageTransformer == null) {
                        throw jMSException;
                    }
                    properties.setProperty(string4, string5);
                    if (this._logger.isLoggable(Level.FINE)) {
                        this._logger.log(Level.WARNING, this._sbr.getKString("BSS2004", string6, jMSException.getMessage()), jMSException);
                    } else {
                        this._logger.log(Level.WARNING, this._sbr.getKString("BSS2004", string6, jMSException.getMessage()));
                    }
                    this._logger.log(Level.INFO, this._sbr.getString("BSS1009", string6, messageTransformer.getClass().getName()));
                }
            }
            if (messageTransformer != null) {
                messageTransformer.init(stompSenderSession.getJMSSession(), "STOMP");
                message = messageTransformer.transform(message, false, "UTF-8", "STOMP", "SUN_MQ", properties);
                if (message == null) {
                    throw new JMSException("null returned from " + messageTransformer.getClass().getName() + " transform() method");
                }
            }
            messageProducer.send(destination, message, n2, n, l);
            this._logger.log(Level.FINE, "Sent message " + message.getJMSMessageID());
            stompFrameMessage2 = StompProtocolHandler.getStompReceiptMessage(stompFrameMessage);
            if (stompFrameMessage2 != null) {
                stompOutputHandler.sendToClient(stompFrameMessage2, context, this);
            }
        }
        catch (Throwable throwable) {
            Object[] objectArray = new String[]{stompFrameMessage.getCommand().toString(), throwable.getMessage(), this._stompConnection.toString()};
            this._logger.log(Level.SEVERE, this._sbr.getKString("BSS3002", objectArray), throwable);
            try {
                stompFrameMessage2 = StompProtocolHandler.toStompErrorMessage(StompFrameMessage.Command.SEND.toString(), throwable);
                stompOutputHandler.sendToClient(stompFrameMessage2, context, this);
            }
            catch (Exception exception) {
                this._logger.log(Level.WARNING, this._sbr.getKString("BSS3001", throwable.getMessage(), exception.getMessage()), exception);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSUBSCRIBE(StompFrameMessage stompFrameMessage, StompOutputHandler stompOutputHandler, Context context, StompOutputHandler stompOutputHandler2) throws Exception {
        StompFrameMessage stompFrameMessage2 = null;
        String string = null;
        String string2 = null;
        boolean bl = false;
        try {
            LinkedHashMap<String, String> linkedHashMap = stompFrameMessage.getHeaders();
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, "on" + (Object)((Object)stompFrameMessage.getCommand()) + ", headers=" + linkedHashMap);
            }
            String string3 = (String)((HashMap)linkedHashMap).get("transaction".toString());
            string = (String)((HashMap)linkedHashMap).get("id".toString());
            String string4 = (String)((HashMap)linkedHashMap).get("ack".toString());
            int n = 1;
            if (string4 != null && string4.equals("client".toString())) {
                n = 2;
            }
            String string5 = (String)((HashMap)linkedHashMap).get("selector".toString());
            String string6 = (String)((HashMap)linkedHashMap).get("destination".toString());
            if (string6 == null) {
                throw new StompProtocolException("SUBSCRIBE without destination header!");
            }
            if (string == null) {
                string = StompProtocolHandler.makeDefaultSubscriberId(string6);
            }
            if (this._subids.contains(string)) {
                throw new StompProtocolException(this._sbr.getKString("BSS4018", string));
            }
            boolean bl2 = false;
            String string7 = (String)((HashMap)linkedHashMap).get("no-local".toString());
            if (string7 != null && string7.equalsIgnoreCase("true")) {
                bl2 = true;
            }
            string2 = (String)((HashMap)linkedHashMap).get("durable-subscriber-name".toString());
            if (string3 == null) {
                StompSubscriberSession stompSubscriberSession = this._stompConnection.createSubscriberSession(string, n);
                bl = true;
                stompSubscriberSession.createSubscriber(this.toJMSDestination(string6, stompSubscriberSession.getJMSSession(), true), string5, string2, bl2, stompOutputHandler2);
            } else {
                StompTransactedSession stompTransactedSession = this._stompConnection.getTransactedSession(string3);
                bl = true;
                stompTransactedSession.createSubscriber(string, this.toJMSDestination(string6, stompTransactedSession.getJMSSession(), true), string5, string2, bl2, stompOutputHandler2);
            }
            this._subids.add(string);
            stompFrameMessage2 = StompProtocolHandler.getStompReceiptMessage(stompFrameMessage);
            if (stompFrameMessage2 != null) {
                stompOutputHandler.sendToClient(stompFrameMessage2, context, this);
            }
        }
        catch (Exception exception) {
            Object[] objectArray = new String[]{stompFrameMessage.getCommand().toString(), exception.getMessage(), this._stompConnection.toString()};
            this._logger.log(Level.SEVERE, this._sbr.getKString("BSS3002", objectArray), exception);
            try {
                if (bl) {
                    this._stompConnection.closeSubscriber(string, null);
                    this._subids.remove(string);
                }
            }
            catch (Exception exception2) {
                this._logger.log(Level.FINEST, (Object)((Object)stompFrameMessage.getCommand()) + ": Unable to close subscriber (subid=" + string + ", duraname=" + string2 + "): " + exception2.getMessage() + " after creation failure: " + exception.getMessage(), exception2);
            }
            finally {
                try {
                    stompFrameMessage2 = StompProtocolHandler.toStompErrorMessage(StompFrameMessage.Command.SUBSCRIBE.toString(), exception);
                    stompOutputHandler.sendToClient(stompFrameMessage2, context, this);
                }
                catch (Exception exception3) {
                    this._logger.log(Level.WARNING, this._sbr.getKString("BSS3001", exception.getMessage(), exception3.getMessage()), exception3);
                }
            }
            return;
        }
    }

    public void onUNSUBSCRIBE(StompFrameMessage stompFrameMessage, StompOutputHandler stompOutputHandler, Context context) throws Exception {
        StompFrameMessage stompFrameMessage2 = null;
        try {
            LinkedHashMap<String, String> linkedHashMap = stompFrameMessage.getHeaders();
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, "on" + (Object)((Object)stompFrameMessage.getCommand()) + ", headers=" + linkedHashMap);
            }
            String string = (String)((HashMap)linkedHashMap).get("id".toString());
            String string2 = (String)((HashMap)linkedHashMap).get("destination".toString());
            String string3 = (String)((HashMap)linkedHashMap).get("durable-subscriber-name".toString());
            if (string == null && string3 == null) {
                if (string2 == null) {
                    throw new StompProtocolException(this._sbr.getKString("BSS4019", "destination", "id"));
                }
                string = StompProtocolHandler.makeDefaultSubscriberId(string2);
            }
            String string4 = this._stompConnection.closeSubscriber(string, string3);
            if (string3 == null) {
                this._subids.remove(string);
            } else if (string4 != null) {
                this._subids.remove(string4);
            }
            stompFrameMessage2 = StompProtocolHandler.getStompReceiptMessage(stompFrameMessage);
            if (stompFrameMessage2 != null) {
                stompOutputHandler.sendToClient(stompFrameMessage2, context, this);
            }
        }
        catch (Exception exception) {
            Object[] objectArray = new String[]{stompFrameMessage.getCommand().toString(), exception.getMessage(), this._stompConnection.toString()};
            this._logger.log(Level.SEVERE, this._sbr.getKString("BSS3002", objectArray), exception);
            try {
                stompFrameMessage2 = StompProtocolHandler.toStompErrorMessage(StompFrameMessage.Command.UNSUBSCRIBE.toString(), exception);
                stompOutputHandler.sendToClient(stompFrameMessage2, context, this);
            }
            catch (Exception exception2) {
                this._logger.log(Level.WARNING, this._sbr.getKString("BSS3001", exception.getMessage(), exception2.getMessage()), exception2);
            }
            return;
        }
    }

    public void onBEGIN(StompFrameMessage stompFrameMessage, StompOutputHandler stompOutputHandler, Context context) throws Exception {
        StompFrameMessage stompFrameMessage2 = null;
        try {
            String string;
            LinkedHashMap<String, String> linkedHashMap = stompFrameMessage.getHeaders();
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, "on" + (Object)((Object)stompFrameMessage.getCommand()) + ", headers=" + linkedHashMap);
            }
            if ((string = (String)((HashMap)linkedHashMap).get("transaction".toString())) == null) {
                throw new StompProtocolException(this._sbr.getKString("BSS4020", "transaction".toString(), StompFrameMessage.Command.BEGIN.toString()));
            }
            this._stompConnection.beginTransactedSession(string);
            stompFrameMessage2 = StompProtocolHandler.getStompReceiptMessage(stompFrameMessage);
            if (stompFrameMessage2 != null) {
                stompOutputHandler.sendToClient(stompFrameMessage2, context, this);
            }
        }
        catch (Exception exception) {
            Object[] objectArray = new String[]{stompFrameMessage.getCommand().toString(), exception.getMessage(), this._stompConnection.toString()};
            this._logger.log(Level.SEVERE, this._sbr.getKString("BSS3002", objectArray), exception);
            try {
                stompFrameMessage2 = StompProtocolHandler.toStompErrorMessage(StompFrameMessage.Command.BEGIN.toString(), exception);
                stompOutputHandler.sendToClient(stompFrameMessage2, context, this);
            }
            catch (Exception exception2) {
                this._logger.log(Level.WARNING, this._sbr.getKString("BSS3001", exception.getMessage(), exception2.getMessage()), exception2);
            }
            return;
        }
    }

    public void onCOMMIT(StompFrameMessage stompFrameMessage, StompOutputHandler stompOutputHandler, Context context) throws Exception {
        StompFrameMessage stompFrameMessage2 = null;
        try {
            String string;
            LinkedHashMap<String, String> linkedHashMap = stompFrameMessage.getHeaders();
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, "on" + (Object)((Object)stompFrameMessage.getCommand()) + ", headers=" + linkedHashMap);
            }
            if ((string = (String)((HashMap)linkedHashMap).get("transaction".toString())) == null) {
                throw new StompProtocolException(this._sbr.getKString("BSS4020", "transaction".toString(), StompFrameMessage.Command.COMMIT.toString()));
            }
            this._stompConnection.commitTransactedSession(string);
            stompFrameMessage2 = StompProtocolHandler.getStompReceiptMessage(stompFrameMessage);
            if (stompFrameMessage2 != null) {
                stompOutputHandler.sendToClient(stompFrameMessage2, context, this);
            }
        }
        catch (Exception exception) {
            Object[] objectArray = new String[]{stompFrameMessage.getCommand().toString(), exception.getMessage(), this._stompConnection.toString()};
            this._logger.log(Level.SEVERE, this._sbr.getKString("BSS3002", objectArray), exception);
            try {
                stompFrameMessage2 = StompProtocolHandler.toStompErrorMessage(StompFrameMessage.Command.COMMIT.toString(), exception);
                stompOutputHandler.sendToClient(stompFrameMessage2, context, this);
            }
            catch (Exception exception2) {
                this._logger.log(Level.WARNING, this._sbr.getKString("BSS3001", exception.getMessage(), exception2.getMessage()), exception2);
            }
            return;
        }
    }

    public void onABORT(StompFrameMessage stompFrameMessage, StompOutputHandler stompOutputHandler, Context context) throws Exception {
        StompFrameMessage stompFrameMessage2 = null;
        try {
            String string;
            LinkedHashMap<String, String> linkedHashMap = stompFrameMessage.getHeaders();
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, "on" + (Object)((Object)stompFrameMessage.getCommand()) + ", headers=" + linkedHashMap);
            }
            if ((string = (String)((HashMap)linkedHashMap).get("transaction".toString())) == null) {
                throw new StompProtocolException(this._sbr.getKString("BSS4020", "transaction".toString(), StompFrameMessage.Command.ABORT.toString()));
            }
            this._stompConnection.abortTransactedSession(string);
            stompFrameMessage2 = StompProtocolHandler.getStompReceiptMessage(stompFrameMessage);
            if (stompFrameMessage2 != null) {
                stompOutputHandler.sendToClient(stompFrameMessage2, context, this);
            }
        }
        catch (Exception exception) {
            Object[] objectArray = new String[]{stompFrameMessage.getCommand().toString(), exception.getMessage(), this._stompConnection.toString()};
            this._logger.log(Level.SEVERE, this._sbr.getKString("BSS3002", objectArray), exception);
            try {
                stompFrameMessage2 = StompProtocolHandler.toStompErrorMessage(StompFrameMessage.Command.ABORT.toString(), exception);
                stompOutputHandler.sendToClient(stompFrameMessage2, context, this);
            }
            catch (Exception exception2) {
                this._logger.log(Level.WARNING, this._sbr.getKString("BSS3001", exception.getMessage(), exception2.getMessage()), exception2);
            }
            return;
        }
    }

    public void onACK(StompFrameMessage stompFrameMessage, StompOutputHandler stompOutputHandler, Context context) throws Exception {
        StompFrameMessage stompFrameMessage2 = null;
        try {
            String string;
            LinkedHashMap<String, String> linkedHashMap = stompFrameMessage.getHeaders();
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, "on" + (Object)((Object)stompFrameMessage.getCommand()) + ", headers=" + linkedHashMap);
            }
            if ((string = (String)((HashMap)linkedHashMap).get("message-id")) == null) {
                throw new StompProtocolException(this._sbr.getKString("BSS4020", "message-id".toString(), StompFrameMessage.Command.ACK.toString()));
            }
            String string2 = (String)((HashMap)linkedHashMap).get("transaction".toString());
            String string3 = (String)((HashMap)linkedHashMap).get("subscription".toString());
            if (string3 != null && !this._subids.contains(string3)) {
                throw new StompProtocolException(this._sbr.getKString("BSS4007", string3));
            }
            if (string2 != null) {
                StompTransactedSession stompTransactedSession = this._stompConnection.getTransactedSession(string2);
                if (string3 != null) {
                    stompTransactedSession.ack(string3, string);
                } else {
                    Object[] objectArray = new String[]{"subscription".toString(), string2, DEFAULT_SUBID_PREFIX, string};
                    this._logger.log(Level.WARNING, this._sbr.getKString("BSS2005", objectArray));
                    stompTransactedSession.ack(DEFAULT_SUBID_PREFIX, string, true);
                }
            } else if (string3 != null) {
                StompSubscriberSession stompSubscriberSession = this._stompConnection.getSubscriberSession(string3);
                if (stompSubscriberSession != null) {
                    stompSubscriberSession.ack(string);
                } else {
                    StompTransactedSession stompTransactedSession = this._stompConnection.getTransactedSession();
                    if (stompTransactedSession == null) {
                        throw new StompProtocolException(this._sbr.getKString("BSS4021", string3));
                    }
                    stompTransactedSession.ack(string3, string);
                }
            } else {
                Object[] objectArray = new String[]{"subscription".toString(), DEFAULT_SUBID_PREFIX, string};
                this._logger.log(Level.WARNING, this._sbr.getKString("BSS2006", objectArray));
                this._stompConnection.ackNonTransacted(DEFAULT_SUBID_PREFIX, string);
            }
            stompFrameMessage2 = StompProtocolHandler.getStompReceiptMessage(stompFrameMessage);
            if (stompFrameMessage2 != null) {
                stompOutputHandler.sendToClient(stompFrameMessage2, context, this);
            }
        }
        catch (Exception exception) {
            Object[] objectArray = new String[]{stompFrameMessage.getCommand().toString(), exception.getMessage(), this._stompConnection.toString()};
            this._logger.log(Level.SEVERE, this._sbr.getKString("BSS3002", objectArray), exception);
            try {
                stompFrameMessage2 = StompProtocolHandler.toStompErrorMessage(StompFrameMessage.Command.ACK.toString(), exception, exception instanceof UnrecoverableAckFailureException);
                stompOutputHandler.sendToClient(stompFrameMessage2, context, this);
            }
            catch (Exception exception2) {
                this._logger.log(Level.WARNING, this._sbr.getKString("BSS3001", exception.getMessage(), exception2.getMessage()), exception2);
            }
            return;
        }
    }

    public static StompFrameMessage getStompReceiptMessage(StompFrameMessage stompFrameMessage) throws Exception {
        StompFrameMessage stompFrameMessage2 = null;
        String string = stompFrameMessage.getHeader("receipt".toString());
        if (string != null) {
            stompFrameMessage2 = new StompFrameMessage(StompFrameMessage.Command.RECEIPT);
            stompFrameMessage2.addHeader("receipt-id".toString(), string);
        }
        return stompFrameMessage2;
    }

    public static StompFrameMessage toStompErrorMessage(String string, Throwable throwable) throws Exception {
        return StompProtocolHandler.toStompErrorMessage(string, throwable, false);
    }

    public static StompFrameMessage toStompErrorMessage(String string, Throwable throwable, boolean bl) throws Exception {
        StompFrameMessage stompFrameMessage = new StompFrameMessage(StompFrameMessage.Command.ERROR);
        stompFrameMessage.addHeader("message".toString(), string + ": " + throwable.getMessage() + (bl ? ", STOMP connection will be closed" : ""));
        stompFrameMessage.writeExceptionToBody(throwable);
        if (bl) {
            stompFrameMessage.setFatalERROR();
        }
        return stompFrameMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Destination toJMSDestination(String string, Session session, boolean bl) throws Exception {
        if (string.startsWith("/queue/")) {
            String string2 = string.substring("/queue/".length(), string.length()).trim();
            return session.createQueue(string2);
        }
        if (string.startsWith("/topic/")) {
            String string3 = string.substring("/topic/".length(), string.length()).trim();
            return session.createTopic(string3);
        }
        if (string.startsWith("/temp-queue/")) {
            String string4 = string.substring("/temp-queue/".length(), string.length()).trim();
            if (string4.startsWith(MQ_TEMP_QUEUE_PREFIX)) {
                if (bl) {
                    throw new JMSException("Can't subscribe " + string);
                }
                Map<String, TemporaryQueue> map = this._mqtempQueues;
                synchronized (map) {
                    Destination destination = this._mqtempQueues.get(string4);
                    if (destination == null) {
                        throw new JMSException("MQ TemporaryQueue not found: " + string);
                    }
                    return destination;
                }
            }
            Map<String, TemporaryQueue> map = this._tempQueues;
            synchronized (map) {
                TemporaryQueue temporaryQueue = this._tempQueues.get(string4);
                if (temporaryQueue != null) {
                    return temporaryQueue;
                }
                temporaryQueue = session.createTemporaryQueue();
                this._tempQueues.put(string4, temporaryQueue);
                return temporaryQueue;
            }
        }
        if (string.startsWith("/temp-topic/")) {
            String string5 = string.substring("/temp-topic/".length(), string.length()).trim();
            if (string5.startsWith(MQ_TEMP_TOPIC_PREFIX)) {
                if (bl) {
                    throw new JMSException("Can't subscribe " + string);
                }
                Map<String, TemporaryTopic> map = this._mqtempTopics;
                synchronized (map) {
                    Destination destination = this._mqtempTopics.get(string5);
                    if (destination == null) {
                        throw new JMSException("MQ TemporaryTopic not found: " + string);
                    }
                    return destination;
                }
            }
            Map<String, TemporaryTopic> map = this._tempTopics;
            synchronized (map) {
                TemporaryTopic temporaryTopic = this._tempTopics.get(string5);
                if (temporaryTopic != null) {
                    return temporaryTopic;
                }
                temporaryTopic = session.createTemporaryTopic();
                this._tempTopics.put(string5, temporaryTopic);
                return temporaryTopic;
            }
        }
        throw new StompProtocolException("Invalid header destination value:" + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toStompDestination(Destination destination, boolean bl) throws Exception {
        if (destination == null) {
            throw new JMSException("JMS destination null !");
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (destination instanceof TemporaryQueue) {
            String string = ((Queue)destination).getQueueName();
            stringBuffer.append("/temp-queue/").append(string);
            if (bl) {
                Map<String, TemporaryQueue> map = this._mqtempQueues;
                synchronized (map) {
                    if (this._mqtempQueues.get(string) == null) {
                        this._mqtempQueues.put(string, (TemporaryQueue)destination);
                    }
                }
            }
            return stringBuffer.toString();
        }
        if (destination instanceof TemporaryTopic) {
            String string = ((Topic)destination).getTopicName();
            stringBuffer.append("/temp-topic/").append(string);
            if (bl) {
                Map<String, TemporaryTopic> map = this._mqtempTopics;
                synchronized (map) {
                    if (this._mqtempTopics.get(string) == null) {
                        this._mqtempTopics.put(string, (TemporaryTopic)destination);
                    }
                }
            }
            return stringBuffer.toString();
        }
        if (destination instanceof Queue) {
            stringBuffer.append("/queue/").append(((Queue)destination).getQueueName());
            return stringBuffer.toString();
        }
        if (destination instanceof Topic) {
            stringBuffer.append("/topic/").append(((Topic)destination).getTopicName());
            return stringBuffer.toString();
        }
        throw new JMSException("Unknow destination type: " + destination);
    }

    private static String makeDefaultSubscriberId(String string) {
        return DEFAULT_SUBID_PREFIX + string;
    }

    protected StompFrameMessage toStompFrameMessage(Message message, String string, Session session) throws Exception {
        MessageTransformer<Message, Message> messageTransformer = StompServer.getMessageTransformer();
        if (messageTransformer != null) {
            messageTransformer.init(session, "STOMP");
            message = messageTransformer.transform(message, true, null, "SUN_MQ", "STOMP", null);
            if (message == null) {
                throw new JMSException("null returned from " + messageTransformer.getClass().getName() + " transform() method for JMS message " + message.toString() + " in subscription " + string);
            }
        }
        StompFrameMessage stompFrameMessage = new StompFrameMessage(StompFrameMessage.Command.MESSAGE);
        LinkedHashMap<String, String> linkedHashMap = stompFrameMessage.getHeaders();
        linkedHashMap.put("subscription", string);
        Destination destination = message.getJMSDestination();
        linkedHashMap.put("destination".toString(), this.toStompDestination(destination, false));
        destination = message.getJMSReplyTo();
        if (destination != null) {
            linkedHashMap.put("reply-to".toString(), this.toStompDestination(destination, true));
        }
        linkedHashMap.put("message-id".toString(), message.getJMSMessageID());
        String string2 = message.getJMSCorrelationID();
        if (string2 != null) {
            linkedHashMap.put("correlation-id".toString(), string2);
        }
        linkedHashMap.put("expires".toString(), String.valueOf(message.getJMSExpiration()));
        linkedHashMap.put("redelivered", String.valueOf(message.getJMSRedelivered()));
        linkedHashMap.put("priority".toString(), String.valueOf(message.getJMSPriority()));
        linkedHashMap.put("timestamp".toString(), String.valueOf(message.getJMSTimestamp()));
        string2 = message.getJMSType();
        if (string2 != null) {
            linkedHashMap.put("type".toString(), string2);
        }
        Enumeration enumeration = message.getPropertyNames();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            String string4 = message.getObjectProperty(string3).toString();
            linkedHashMap.put(string3, string4);
        }
        if (message instanceof TextMessage) {
            String string5 = ((TextMessage)message).getText();
            if (string5 != null) {
                byte[] byArray = string5.getBytes("UTF-8");
                stompFrameMessage.setBody(byArray);
                linkedHashMap.put("content-length", String.valueOf(byArray.length));
            } else {
                linkedHashMap.put("content-length", String.valueOf(0));
            }
        } else if (message instanceof BytesMessage) {
            BytesMessage bytesMessage = (BytesMessage)message;
            byte[] byArray = new byte[(int)bytesMessage.getBodyLength()];
            bytesMessage.readBytes(byArray);
            stompFrameMessage.setBody(byArray);
            linkedHashMap.put("content-length", String.valueOf(byArray.length));
        } else {
            throw new JMSException("Message type is not supported: " + message);
        }
        return stompFrameMessage;
    }
}

