/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.auth.ldap;

import com.sun.messaging.jmq.auth.api.FailedLoginException;
import com.sun.messaging.jmq.auth.api.server.model.UserRepository;
import com.sun.messaging.jmq.auth.jaas.MQGroup;
import com.sun.messaging.jmq.auth.jaas.MQUser;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.util.Password;
import com.sun.messaging.jmq.util.log.Logger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.naming.AuthenticationException;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.security.auth.Refreshable;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;

public class LdapUserRepository
implements UserRepository {
    public static final String TYPE = "ldap";
    private static boolean DEBUG = false;
    private static final transient Logger logger = Globals.getLogger();
    private static final transient BrokerResources br = Globals.getBrokerResources();
    private String authType;
    private Properties authProps = null;
    private static String INITIAL_CONTEXT_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    private static String DEFAULT_SSLFACTORY = "javax.net.ssl.SSLSocketFactory";
    private static String TRUST_SSLFACTORY = "com.sun.messaging.jmq.jmsserver.auth.ldap.TrustSSLSocketFactory";
    private static final int DEFAULT_TIMELIMIT = 180000;
    private static final String DN_USRFORMAT = "dn";
    private static final String PROP_SERVER_SUFFIX = ".server";
    public static final String PROP_BINDDN_SUFFIX = ".principal";
    public static final String PROP_BINDPW_SUFFIX = ".password";
    private static final String PROP_UIDATTR_SUFFIX = ".uidattr";
    private static final String PROP_USRFORMAT_SUFFIX = ".usrformat";
    private static final String PROP_USRFILTER_SUFFIX = ".usrfilter";
    private static final String PROP_BASE_SUFFIX = ".base";
    private static final String PROP_GRPBASE_SUFFIX = ".grpbase";
    private static final String PROP_GIDATTR_SUFFIX = ".gidattr";
    private static final String PROP_MEMATTR_SUFFIX = ".memattr";
    private static final String PROP_GRPFILTER_SUFFIX = ".grpfilter";
    private static final String PROP_GRPSEARCH_SUFFIX = ".grpsearch";
    private static final String PROP_TIMEOUT_SUFFIX = ".timeout";
    private static final String PROP_SSL_SUFFIX = ".ssl.enabled";
    private static final String PROP_SSLFACTORY_SUFFIX = ".ssl.socketfactory";
    private String server = null;
    private String bindDN = null;
    private String bindPW = null;
    private String base = null;
    private LdapName ldapbase = null;
    private String uidattr = null;
    private String usrformat = null;
    private String usrfilter = null;
    private int timelimit = 180000;
    private boolean grpsearch = true;
    private String grpbase = null;
    private String gidattr = null;
    private String memattr = null;
    private String grpfilter = null;
    private String repository = null;
    private boolean sslprotocol = false;
    private String sslfactory = null;

    public String getType() {
        return TYPE;
    }

    public void open(String string, Properties properties, Refreshable refreshable) throws LoginException {
        String string2;
        String string3;
        Object object;
        this.authType = string;
        this.authProps = properties;
        String string4 = this.authProps.getProperty("imq.authentication." + string + ".user_repository");
        if (string4 == null) {
            throw new LoginException(Globals.getBrokerResources().getKString("B4041", string));
        }
        this.repository = string4;
        if (!string4.equals(TYPE)) {
            Object[] objectArray = new String[]{string4, TYPE, this.getClass().getName()};
            throw new LoginException(Globals.getBrokerResources().getKString("B4070", objectArray));
        }
        String string5 = "imq.user_repository." + string4;
        this.server = this.authProps.getProperty(string5 + PROP_SERVER_SUFFIX);
        if (this.server == null || this.server.trim().equals("")) {
            Object[] objectArray = new String[]{string, string4, PROP_SERVER_SUFFIX};
            throw new LoginException(Globals.getBrokerResources().getKString("B4064", objectArray));
        }
        this.server = "ldap://" + this.server;
        this.bindDN = this.authProps.getProperty(string5 + PROP_BINDDN_SUFFIX);
        if (this.bindDN != null && !this.bindDN.trim().equals("")) {
            boolean bl;
            this.bindPW = this.authProps.getProperty(string5 + PROP_BINDPW_SUFFIX);
            object = null;
            boolean bl2 = bl = this.bindPW == null || this.bindPW.equals("");
            for (int i = 0; this.bindPW == null || this.bindPW.trim().equals("") && i < 5; ++i) {
                object = new Password();
                if (((Password)object).echoPassword()) {
                    System.err.println(Globals.getBrokerResources().getString("B2242"));
                }
                System.err.print(Globals.getBrokerResources().getString("B0031", this.bindDN));
                System.err.flush();
                this.bindPW = ((Password)object).getPassword();
            }
            if (this.bindPW == null || this.bindPW.trim().equals("")) {
                logger.log(16, "B2078", this.bindPW);
                this.bindDN = null;
            } else if (bl) {
                this.authProps.put(string5 + PROP_BINDPW_SUFFIX, this.bindPW);
            }
        } else {
            this.bindDN = null;
        }
        this.usrformat = this.authProps.getProperty(string5 + PROP_USRFORMAT_SUFFIX);
        if (this.usrformat != null) {
            this.usrformat = this.usrformat.trim();
            if (this.usrformat.equals("")) {
                this.usrformat = null;
            } else if (!this.usrformat.trim().equals(DN_USRFORMAT)) {
                throw new LoginException(Globals.getBrokerResources().getKString("B4293", "" + string5 + PROP_USRFORMAT_SUFFIX, this.usrformat));
            }
        }
        this.base = this.authProps.getProperty(string5 + PROP_BASE_SUFFIX);
        if (this.base != null && this.base.trim().equals("")) {
            this.base = null;
        }
        if (!(this.base != null || this.usrformat != null && this.usrformat.equals(DN_USRFORMAT))) {
            Object[] objectArray = new String[]{string, string4, PROP_BASE_SUFFIX};
            throw new LoginException(Globals.getBrokerResources().getKString("B4064", objectArray));
        }
        this.ldapbase = null;
        if (this.base != null && this.usrformat != null && this.usrformat.equals(DN_USRFORMAT)) {
            try {
                this.ldapbase = new LdapName(this.base);
            }
            catch (Exception exception) {
                throw new LoginException(exception.toString());
            }
        }
        this.uidattr = this.authProps.getProperty(string5 + PROP_UIDATTR_SUFFIX);
        if (this.uidattr == null || this.uidattr.trim().equals("")) {
            Object[] objectArray = new String[]{string, string4, PROP_UIDATTR_SUFFIX};
            throw new LoginException(Globals.getBrokerResources().getKString("B4064", objectArray));
        }
        this.usrfilter = this.authProps.getProperty(string5 + PROP_USRFILTER_SUFFIX);
        if (this.usrfilter != null && this.usrfilter.trim().equals("")) {
            this.usrfilter = null;
        }
        if ((string3 = this.authProps.getProperty(string5 + PROP_TIMEOUT_SUFFIX)) != null) {
            try {
                this.timelimit = Integer.parseInt(string3) * 1000;
            }
            catch (NumberFormatException numberFormatException) {
                this.timelimit = -1;
            }
        }
        if (this.timelimit < 0) {
            this.timelimit = 180000;
        }
        if ((object = this.authProps.getProperty(string5 + PROP_GRPSEARCH_SUFFIX)) != null && ((String)object).equals("false")) {
            this.grpsearch = false;
        }
        if (this.grpsearch) {
            this.grpbase = this.authProps.getProperty(string5 + PROP_GRPBASE_SUFFIX);
            if (this.grpbase == null || this.grpbase.trim().equals("")) {
                Object[] objectArray = new String[]{string, string4, PROP_GRPBASE_SUFFIX};
                throw new LoginException(Globals.getBrokerResources().getKString("B4064", objectArray));
            }
            this.gidattr = this.authProps.getProperty(string5 + PROP_GIDATTR_SUFFIX);
            if (this.gidattr == null || this.gidattr.trim().equals("")) {
                Object[] objectArray = new String[]{string, string4, PROP_GIDATTR_SUFFIX};
                throw new LoginException(Globals.getBrokerResources().getKString("B4064", objectArray));
            }
            this.memattr = this.authProps.getProperty(string5 + PROP_MEMATTR_SUFFIX);
            if (this.memattr == null || this.memattr.trim().equals("")) {
                Object[] objectArray = new String[]{string, string4, PROP_MEMATTR_SUFFIX};
                throw new LoginException(Globals.getBrokerResources().getKString("B4064", objectArray));
            }
            this.grpfilter = this.authProps.getProperty(string5 + PROP_GRPFILTER_SUFFIX);
            if (this.grpfilter != null && this.grpfilter.trim().equals("")) {
                this.grpfilter = null;
            }
        }
        if ((string2 = this.authProps.getProperty(string5 + PROP_SSL_SUFFIX)) != null && string2.equals("true")) {
            this.sslprotocol = true;
            string2 = this.authProps.getProperty(string5 + PROP_SSLFACTORY_SUFFIX);
            if (string2 != null && !string2.trim().equals("")) {
                this.sslfactory = string2.trim();
            }
        }
    }

    public Subject findMatch(String string, Object object, Object object2, String string2) throws LoginException {
        if (string2 != null && string2.equals("basic")) {
            return this.jmqbasicFindMatch(string, (String)object);
        }
        String string3 = string2 == null ? "null" : string2;
        Object[] objectArray = new String[]{string3, this.authType, this.getType(), "basic"};
        throw new LoginException(Globals.getBrokerResources().getKString("B4079", objectArray));
    }

    private Subject jmqbasicFindMatch(String string, String string2) throws LoginException {
        if (DEBUG) {
            logger.log(8, "Authenticate[basic] " + string + ":" + string2 + (this.usrformat == null ? ":" : ":usrformat=" + this.usrformat));
        }
        if (string2 == null || string2.trim().equals("")) {
            throw new LoginException(Globals.getBrokerResources().getKString("B4066", string));
        }
        if (string == null || string.trim().equals("")) {
            throw new LoginException(Globals.getBrokerResources().getKString("B4067", string));
        }
        String string3 = this.server;
        if (DEBUG) {
            logger.log(8, "LDAP server: " + string3);
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>(11);
        hashtable.put("java.naming.factory.initial", INITIAL_CONTEXT_FACTORY);
        hashtable.put("java.naming.provider.url", string3);
        hashtable.put("java.naming.referral", "follow");
        if (this.sslprotocol) {
            hashtable.put("java.naming.security.protocol", "ssl");
            if (this.sslfactory != null) {
                hashtable.put("java.naming.ldap.factory.socket", this.sslfactory);
            }
        }
        String string4 = null;
        boolean bl = false;
        if (this.usrformat != null && this.usrformat.equals(DN_USRFORMAT)) {
            bl = true;
            string4 = string;
            string = this.handleDNusrformat(string);
        } else {
            string4 = this.searchDN(string, hashtable);
        }
        Context context = null;
        Object var8_8 = null;
        try {
            if (!bl) {
                logger.log(8, br.getKString("B1305", string, string4));
            } else {
                logger.log(8, br.getKString("B1306", string4, string));
            }
            hashtable.put("java.naming.security.authentication", "simple");
            hashtable.put("java.naming.security.principal", string4);
            hashtable.put("java.naming.security.credentials", string2);
            try {
                context = new InitialDirContext(hashtable);
                context.close();
                Subject subject = new Subject();
                subject.getPrincipals().add(new MQUser(string));
                try {
                    this.findGroups(string4, subject);
                }
                catch (NamingException namingException) {
                    String string5 = Globals.getBrokerResources().getKString("B4075", string + " [" + string4 + "]");
                    logger.logStack(32, string5, namingException);
                    throw new LoginException(string5 + ":" + namingException.getMessage());
                }
                Subject subject2 = subject;
                return subject2;
            }
            catch (AuthenticationException authenticationException) {
                try {
                    if (DEBUG) {
                        logger.log(8, authenticationException.getMessage(), authenticationException);
                    }
                    throw new FailedLoginException(authenticationException.getMessage());
                }
                catch (Exception exception) {
                    if (exception instanceof FailedLoginException) {
                        throw (FailedLoginException)exception;
                    }
                    if (exception instanceof LoginException) {
                        throw (LoginException)exception;
                    }
                    String string6 = null;
                    string6 = exception instanceof NamingException ? ((NamingException)exception).toString(true) : exception.toString();
                    logger.logStack(32, string6, exception);
                    throw new LoginException(string6);
                }
            }
        }
        finally {
            try {
                if (context != null) {
                    context.close();
                }
            }
            catch (NamingException namingException) {}
        }
    }

    private String searchDN(String string, Hashtable hashtable) throws LoginException {
        if (this.bindDN != null && this.bindPW != null) {
            hashtable.put("java.naming.security.authentication", "simple");
            hashtable.put("java.naming.security.principal", this.bindDN);
            hashtable.put("java.naming.security.credentials", this.bindPW);
        }
        InitialDirContext initialDirContext = null;
        try {
            SearchResult searchResult;
            initialDirContext = new InitialDirContext(hashtable);
            SearchControls searchControls = new SearchControls();
            searchControls.setReturningAttributes(new String[0]);
            searchControls.setSearchScope(2);
            searchControls.setTimeLimit(this.timelimit);
            String string2 = this.uidattr + "=" + string;
            if (this.usrfilter != null) {
                string2 = "(&(" + this.usrfilter + ")(" + string2 + "))";
            }
            if (DEBUG) {
                logger.log(8, "filter:" + string2 + ":");
            }
            NamingEnumeration<SearchResult> namingEnumeration = initialDirContext.search(this.base, string2, searchControls);
            int n = 0;
            String string3 = null;
            while (namingEnumeration.hasMore()) {
                if (n != 0) {
                    namingEnumeration.close();
                    throw new NamingException(Globals.getBrokerResources().getKString("B4065", string, this.repository));
                }
                searchResult = namingEnumeration.next();
                if (!searchResult.isRelative()) {
                    throw new NamingException(Globals.getBrokerResources().getKString("B4071", searchResult.getName()));
                }
                string3 = searchResult.getName() + ", " + this.base;
                ++n;
            }
            initialDirContext.close();
            if (string3 == null) {
                throw new FailedLoginException(Globals.getBrokerResources().getKString("B4068", string, this.repository));
            }
            if (DEBUG) {
                logger.log(8, "dn=" + string3);
            }
            searchResult = string3;
            return searchResult;
        }
        catch (Exception exception) {
            if (exception instanceof FailedLoginException) {
                throw (FailedLoginException)exception;
            }
            String string4 = null;
            string4 = exception instanceof NamingException ? ((NamingException)exception).toString(true) : exception.toString();
            logger.logStack(32, string4, exception);
            throw new LoginException(string4);
        }
        finally {
            try {
                if (initialDirContext != null) {
                    initialDirContext.close();
                }
            }
            catch (NamingException namingException) {}
        }
    }

    private String handleDNusrformat(String string) throws LoginException {
        String string2 = string;
        try {
            LdapName ldapName = new LdapName(string);
            if (this.ldapbase != null && !ldapName.startsWith(this.ldapbase)) {
                throw new LoginException(br.getKString("B4296", string, this.ldapbase.toString()));
            }
            Iterator<Rdn> iterator = ldapName.getRdns().iterator();
            Attributes attributes = null;
            Attribute attribute = null;
            Object object = null;
            while (iterator.hasNext()) {
                attributes = iterator.next().toAttributes();
                attribute = attributes.get(this.uidattr);
                if (attribute == null) continue;
                object = attribute.get(0);
                if (object == null) break;
                if (!(object instanceof String)) {
                    throw new LoginException(br.getKString("B4295", this.uidattr + "[" + string2 + "]", object.getClass().getName()));
                }
                if (((String)object).trim().equals("")) {
                    object = null;
                    break;
                }
                return (String)object;
            }
            throw new LoginException(br.getKString("B4294", this.uidattr, string2));
        }
        catch (Exception exception) {
            if (exception instanceof LoginException) {
                throw (LoginException)exception;
            }
            String string3 = null;
            string3 = exception instanceof NamingException ? ((NamingException)exception).toString(true) : exception.toString();
            logger.logStack(32, string3, exception);
            throw new LoginException(exception.getMessage());
        }
    }

    private void findGroups(String string, Subject subject) throws NamingException {
        if (!this.grpsearch) {
            return;
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>(11);
        hashtable.put("java.naming.factory.initial", INITIAL_CONTEXT_FACTORY);
        hashtable.put("java.naming.provider.url", this.server);
        hashtable.put("java.naming.referral", "follow");
        if (this.bindDN != null) {
            hashtable.put("java.naming.security.authentication", "simple");
            hashtable.put("java.naming.security.principal", this.bindDN);
            hashtable.put("java.naming.security.credentials", this.bindPW);
        }
        if (this.sslprotocol) {
            hashtable.put("java.naming.security.protocol", "ssl");
            if (this.sslfactory != null) {
                hashtable.put("java.naming.ldap.factory.socket", this.sslfactory);
            }
        }
        InitialDirContext initialDirContext = null;
        Object var5_5 = null;
        try {
            initialDirContext = new InitialDirContext(hashtable);
            SearchControls searchControls = new SearchControls();
            String[] stringArray = new String[]{this.gidattr};
            searchControls.setReturningAttributes(stringArray);
            searchControls.setSearchScope(1);
            searchControls.setTimeLimit(this.timelimit);
            String string2 = this.memattr + "=" + string;
            if (this.grpfilter != null) {
                string2 = "(&(" + this.grpfilter + ")(" + string2 + "))";
            }
            if (DEBUG) {
                logger.log(8, "filter:" + string2 + ":");
            }
            NamingEnumeration<SearchResult> namingEnumeration = initialDirContext.search(this.grpbase, string2, searchControls);
            SearchResult searchResult = null;
            Attributes attributes = null;
            Attribute attribute = null;
            String string3 = null;
            while (namingEnumeration.hasMore()) {
                searchResult = namingEnumeration.next();
                if (!searchResult.isRelative()) {
                    throw new NamingException(Globals.getBrokerResources().getKString("B4071", searchResult.getName()));
                }
                attributes = searchResult.getAttributes();
                if (attributes == null || (attribute = attributes.get(this.gidattr)) == null || (string3 = (String)attribute.get(0)) == null || string3.equals("")) continue;
                if (DEBUG) {
                    logger.log(8, "found group:" + string3 + ":");
                }
                final Subject subject2 = subject;
                final String string4 = string3;
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        subject2.getPrincipals().add(new MQGroup(string4));
                        return null;
                    }
                });
            }
            initialDirContext.close();
            initialDirContext = null;
            return;
        }
        catch (Exception exception) {
            if (exception instanceof NamingException) {
                throw (NamingException)exception;
            }
            NamingException namingException = new NamingException(exception.toString());
            namingException.initCause(exception);
            throw namingException;
        }
        finally {
            if (initialDirContext != null) {
                initialDirContext.close();
            }
        }
    }

    public Refreshable getCacheData() {
        return null;
    }

    public void close() throws LoginException {
    }
}

