/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.mbeans;

import com.sun.messaging.jmq.Version;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.config.ConfigListener;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.management.mbeans.MQMBeanReadWrite;
import com.sun.messaging.jmq.jmsserver.management.util.DestinationUtil;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.SizeString;
import com.sun.messaging.jmq.util.admin.DestinationInfo;
import com.sun.messaging.jms.management.server.DestinationType;
import com.sun.messaging.jms.management.server.MQObjectName;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectName;

public class DestinationManagerConfig
extends MQMBeanReadWrite
implements ConfigListener {
    private Properties brokerProps = null;
    private static MBeanAttributeInfo[] attrs;
    private static MBeanParameterInfo[] createSignature1;
    private static MBeanParameterInfo[] createSignature2;
    private static MBeanParameterInfo[] destroySignature;
    private static MBeanParameterInfo[] pauseSignature;
    private static MBeanOperationInfo[] ops;
    private static String[] attrChangeTypes;
    private static MBeanNotificationInfo[] notifs;

    public DestinationManagerConfig() {
        this.initProps();
        BrokerConfig brokerConfig = Globals.getConfig();
        brokerConfig.addListener("imq.autocreate.queue", this);
        brokerConfig.addListener("imq.autocreate.queue.maxNumActiveConsumers", this);
        brokerConfig.addListener("imq.autocreate.queue.maxNumBackupConsumers", this);
        brokerConfig.addListener("imq.autocreate.topic", this);
        brokerConfig.addListener("imq.destination.DMQ.truncateBody", this);
        brokerConfig.addListener("imq.destination.logDeadMsgs", this);
        brokerConfig.addListener("imq.message.max_size", this);
        brokerConfig.addListener("imq.system.max_count", this);
        brokerConfig.addListener("imq.system.max_size", this);
    }

    public void setAutoCreateQueues(Boolean bl) throws MBeanException {
        Properties properties = new Properties();
        properties.setProperty("imq.autocreate.queue", bl.toString());
        try {
            BrokerConfig brokerConfig = Globals.getConfig();
            brokerConfig.updateProperties(properties, true);
        }
        catch (Exception exception) {
            this.handleSetterException("AutoCreateQueues", exception);
        }
    }

    public Boolean getAutoCreateQueues() throws MBeanException {
        String string = this.brokerProps.getProperty("imq.autocreate.queue");
        Boolean bl = null;
        try {
            bl = Boolean.valueOf(string);
        }
        catch (Exception exception) {
            this.handleGetterException("AutoCreateQueues", exception);
        }
        return bl;
    }

    public void setAutoCreateQueueMaxNumActiveConsumers(Integer n) throws MBeanException {
        Properties properties = new Properties();
        properties.setProperty("imq.autocreate.queue.maxNumActiveConsumers", n.toString());
        try {
            BrokerConfig brokerConfig = Globals.getConfig();
            brokerConfig.updateProperties(properties, true);
        }
        catch (Exception exception) {
            this.handleSetterException("AutoCreateQueueMaxNumActiveConsumers", exception);
        }
    }

    public Integer getAutoCreateQueueMaxNumActiveConsumers() throws MBeanException {
        String string = this.brokerProps.getProperty("imq.autocreate.queue.maxNumActiveConsumers");
        Integer n = null;
        try {
            n = new Integer(string);
        }
        catch (Exception exception) {
            this.handleGetterException("AutoCreateQueues", exception);
        }
        return n;
    }

    public void setAutoCreateQueueMaxNumBackupConsumers(Integer n) throws MBeanException {
        Properties properties = new Properties();
        properties.setProperty("imq.autocreate.queue.maxNumBackupConsumers", n.toString());
        try {
            BrokerConfig brokerConfig = Globals.getConfig();
            brokerConfig.updateProperties(properties, true);
        }
        catch (Exception exception) {
            this.handleSetterException("AutoCreateQueueMaxNumBackupConsumers", exception);
        }
    }

    public Integer getAutoCreateQueueMaxNumBackupConsumers() throws MBeanException {
        String string = this.brokerProps.getProperty("imq.autocreate.queue.maxNumBackupConsumers");
        Integer n = null;
        try {
            n = new Integer(string);
        }
        catch (Exception exception) {
            this.handleGetterException("AutoCreateQueueMaxNumBackupConsumers", exception);
        }
        return n;
    }

    public void setAutoCreateTopics(Boolean bl) throws MBeanException {
        Properties properties = new Properties();
        properties.setProperty("imq.autocreate.topic", bl.toString());
        try {
            BrokerConfig brokerConfig = Globals.getConfig();
            brokerConfig.updateProperties(properties, true);
        }
        catch (Exception exception) {
            this.handleSetterException("AutoCreateTopics", exception);
        }
    }

    public Boolean getAutoCreateTopics() throws MBeanException {
        String string = this.brokerProps.getProperty("imq.autocreate.topic");
        Boolean bl = null;
        try {
            bl = Boolean.valueOf(string);
        }
        catch (Exception exception) {
            this.handleGetterException("AutoCreateTopics", exception);
        }
        return bl;
    }

    public void setDMQTruncateBody(Boolean bl) throws MBeanException {
        Properties properties = new Properties();
        properties.setProperty("imq.destination.DMQ.truncateBody", bl.toString());
        try {
            BrokerConfig brokerConfig = Globals.getConfig();
            brokerConfig.updateProperties(properties, true);
        }
        catch (Exception exception) {
            this.handleSetterException("DMQTruncateBody", exception);
        }
    }

    public Boolean getDMQTruncateBody() throws MBeanException {
        String string = this.brokerProps.getProperty("imq.destination.DMQ.truncateBody");
        Boolean bl = null;
        try {
            bl = Boolean.valueOf(string);
        }
        catch (Exception exception) {
            this.handleGetterException("DMQTruncateBody", exception);
        }
        return bl;
    }

    public void setLogDeadMsgs(Boolean bl) throws MBeanException {
        Properties properties = new Properties();
        properties.setProperty("imq.destination.logDeadMsgs", bl.toString());
        try {
            BrokerConfig brokerConfig = Globals.getConfig();
            brokerConfig.updateProperties(properties, true);
        }
        catch (Exception exception) {
            this.handleSetterException("LogDeadMsgs", exception);
        }
    }

    public Boolean getLogDeadMsgs() throws MBeanException {
        String string = this.brokerProps.getProperty("imq.destination.logDeadMsgs");
        Boolean bl = null;
        try {
            bl = Boolean.valueOf(string);
        }
        catch (Exception exception) {
            this.handleGetterException("LogDeadMsgs", exception);
        }
        return bl;
    }

    public void setMaxBytesPerMsg(Long l) throws MBeanException {
        Properties properties = new Properties();
        properties.setProperty("imq.message.max_size", l.toString());
        try {
            BrokerConfig brokerConfig = Globals.getConfig();
            brokerConfig.updateProperties(properties, true);
        }
        catch (Exception exception) {
            this.handleSetterException("MaxBytesPerMsg", exception);
        }
    }

    public Long getMaxBytesPerMsg() throws MBeanException {
        String string = this.brokerProps.getProperty("imq.message.max_size");
        Long l = null;
        try {
            SizeString sizeString = new SizeString(string);
            l = new Long(sizeString.getBytes());
        }
        catch (Exception exception) {
            this.handleGetterException("MaxBytesPerMsg", exception);
        }
        return l;
    }

    public void setMaxNumMsgs(Long l) throws MBeanException {
        Properties properties = new Properties();
        properties.setProperty("imq.system.max_count", l.toString());
        try {
            BrokerConfig brokerConfig = Globals.getConfig();
            brokerConfig.updateProperties(properties, true);
        }
        catch (Exception exception) {
            this.handleSetterException("MaxNumMsgs", exception);
        }
    }

    public Long getMaxNumMsgs() throws MBeanException {
        String string = this.brokerProps.getProperty("imq.system.max_count");
        Long l = null;
        try {
            l = new Long(string);
        }
        catch (Exception exception) {
            this.handleGetterException("MaxNumMsgs", exception);
        }
        return l;
    }

    public void setMaxTotalMsgBytes(Long l) throws MBeanException {
        Properties properties = new Properties();
        properties.setProperty("imq.system.max_size", l.toString());
        try {
            BrokerConfig brokerConfig = Globals.getConfig();
            brokerConfig.updateProperties(properties, true);
        }
        catch (Exception exception) {
            this.handleSetterException("MaxTotalMsgBytes", exception);
        }
    }

    public Long getMaxTotalMsgBytes() throws MBeanException {
        String string = this.brokerProps.getProperty("imq.system.max_size");
        Long l = null;
        try {
            l = new Long(string);
        }
        catch (Exception exception) {
            this.handleGetterException("MaxTotalMsgBytes", exception);
        }
        return l;
    }

    public Integer getNumDestinations() {
        List list = DestinationUtil.getVisibleDestinations();
        return new Integer(list.size());
    }

    public void create(String string, String string2) throws MBeanException {
        this.create(string, string2, null);
    }

    public void create(String string, String string2, AttributeList attributeList) throws MBeanException {
        DestinationInfo destinationInfo = DestinationUtil.getDestinationInfoFromAttrs(string, string2, attributeList);
        try {
            DestinationUtil.checkCreateDestinationAttrs(string, attributeList);
            DestinationUtil.createDestination(destinationInfo);
        }
        catch (BrokerException brokerException) {
            this.handleOperationException("create", brokerException);
        }
    }

    public void compact() throws MBeanException {
        try {
            DestinationUtil.compactAllDestinations();
        }
        catch (BrokerException brokerException) {
            this.handleOperationException("compact", brokerException);
        }
    }

    public void destroy(String string, String string2) throws MBeanException {
        try {
            DestinationUtil.checkDestType(string);
            Destination destination = Destination.removeDestination(string2, string.equals("q"), "JMX API");
            if (destination == null) {
                String string3 = rb.getString("B3128", DestinationType.toStringLabel(string), string2);
                String string4 = rb.getString("B4087", string2, string3);
                throw new BrokerException(string4);
            }
        }
        catch (Exception exception) {
            this.handleOperationException("destroy", exception);
        }
    }

    public ObjectName[] getDestinations() throws MBeanException {
        List list = DestinationUtil.getVisibleDestinations();
        if (list.size() == 0) {
            return null;
        }
        ObjectName[] objectNameArray = new ObjectName[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Destination destination = (Destination)list.get(i);
            try {
                ObjectName objectName;
                objectNameArray[i] = objectName = MQObjectName.createDestinationConfig(destination.isQueue() ? "q" : "t", destination.getDestinationName());
                continue;
            }
            catch (Exception exception) {
                this.handleOperationException("getDestinations", exception);
            }
        }
        return objectNameArray;
    }

    public void pause() throws MBeanException {
        this.pause("ALL");
    }

    public void pause(String string) throws MBeanException {
        try {
            DestinationUtil.checkPauseType(string);
            this.logger.log(8, "B1250", string);
            DestinationUtil.pauseAllDestinations(DestinationUtil.toInternalPauseType(string));
        }
        catch (Exception exception) {
            this.handleOperationException("pause", exception);
        }
    }

    public void resume() {
        this.logger.log(8, "Resuming all destinations");
        DestinationUtil.resumeAllDestinations();
    }

    public String getMBeanName() {
        return "DestinationManagerConfig";
    }

    public String getMBeanDescription() {
        return mbr.getString("MB1165");
    }

    public MBeanAttributeInfo[] getMBeanAttributeInfo() {
        return attrs;
    }

    public MBeanOperationInfo[] getMBeanOperationInfo() {
        return ops;
    }

    public MBeanNotificationInfo[] getMBeanNotificationInfo() {
        return notifs;
    }

    public void validate(String string, String string2) throws PropertyUpdateException {
    }

    public boolean update(String string, String string2) {
        if (string.equals("imq.autocreate.queue")) {
            Boolean bl;
            Boolean bl2 = Boolean.valueOf(string2);
            try {
                bl = this.getAutoCreateQueues();
            }
            catch (MBeanException mBeanException) {
                this.logProblemGettingOldVal("AutoCreateQueues", mBeanException);
                bl = null;
            }
            this.notifyAttrChange("AutoCreateQueues", bl2, bl);
        } else if (string.equals("imq.autocreate.queue.maxNumActiveConsumers")) {
            Integer n;
            Integer n2;
            try {
                n2 = Integer.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.logger.log(32, this.getMBeanName() + ": cannot parse internal value of " + "AutoCreateQueueMaxNumActiveConsumers" + ": " + numberFormatException);
                n2 = null;
            }
            try {
                n = this.getAutoCreateQueueMaxNumActiveConsumers();
            }
            catch (MBeanException mBeanException) {
                this.logProblemGettingOldVal("AutoCreateQueueMaxNumActiveConsumers", mBeanException);
                n = null;
            }
            this.notifyAttrChange("AutoCreateQueueMaxNumActiveConsumers", n2, n);
        } else if (string.equals("imq.autocreate.queue.maxNumBackupConsumers")) {
            Integer n;
            Integer n3;
            try {
                n3 = Integer.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.logger.log(32, this.getMBeanName() + ": cannot parse internal value of " + "AutoCreateQueueMaxNumBackupConsumers" + ": " + numberFormatException);
                n3 = null;
            }
            try {
                n = this.getAutoCreateQueueMaxNumBackupConsumers();
            }
            catch (MBeanException mBeanException) {
                this.logProblemGettingOldVal("AutoCreateQueueMaxNumBackupConsumers", mBeanException);
                n = null;
            }
            this.notifyAttrChange("AutoCreateQueueMaxNumBackupConsumers", n3, n);
        } else if (string.equals("imq.autocreate.topic")) {
            Boolean bl;
            Boolean bl3 = Boolean.valueOf(string2);
            try {
                bl = this.getAutoCreateTopics();
            }
            catch (MBeanException mBeanException) {
                this.logProblemGettingOldVal("AutoCreateTopics", mBeanException);
                bl = null;
            }
            this.notifyAttrChange("AutoCreateTopics", bl3, bl);
        } else if (string.equals("imq.destination.DMQ.truncateBody")) {
            Boolean bl;
            Boolean bl4 = Boolean.valueOf(string2);
            try {
                bl = this.getDMQTruncateBody();
            }
            catch (MBeanException mBeanException) {
                this.logProblemGettingOldVal("DMQTruncateBody", mBeanException);
                bl = null;
            }
            this.notifyAttrChange("DMQTruncateBody", bl4, bl);
        } else if (string.equals("imq.destination.logDeadMsgs")) {
            Boolean bl;
            Boolean bl5 = Boolean.valueOf(string2);
            try {
                bl = this.getLogDeadMsgs();
            }
            catch (MBeanException mBeanException) {
                this.logProblemGettingOldVal("LogDeadMsgs", mBeanException);
                bl = null;
            }
            this.notifyAttrChange("LogDeadMsgs", bl5, bl);
        } else if (string.equals("imq.message.max_size")) {
            Long l;
            Long l2;
            try {
                SizeString sizeString = new SizeString(string2);
                l2 = new Long(sizeString.getBytes());
            }
            catch (NumberFormatException numberFormatException) {
                this.logger.log(32, this.getMBeanName() + ": cannot parse internal value of " + "MaxBytesPerMsg" + ": " + numberFormatException);
                l2 = null;
            }
            try {
                l = this.getMaxBytesPerMsg();
            }
            catch (MBeanException mBeanException) {
                this.logProblemGettingOldVal("MaxBytesPerMsg", mBeanException);
                l = null;
            }
            this.notifyAttrChange("MaxBytesPerMsg", l2, l);
        } else if (string.equals("imq.system.max_count")) {
            Long l;
            Long l3;
            try {
                l3 = Long.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.logger.log(32, this.getMBeanName() + ": cannot parse internal value of " + "MaxNumMsgs" + ": " + numberFormatException);
                l3 = null;
            }
            try {
                l = this.getMaxNumMsgs();
            }
            catch (MBeanException mBeanException) {
                this.logProblemGettingOldVal("MaxNumMsgs", mBeanException);
                l = null;
            }
            this.notifyAttrChange("MaxNumMsgs", l3, l);
        } else if (string.equals("imq.system.max_size")) {
            Long l;
            Long l4;
            try {
                l4 = Long.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.logger.log(32, this.getMBeanName() + ": cannot parse internal value of " + "MaxTotalMsgBytes" + ": " + numberFormatException);
                l4 = null;
            }
            try {
                l = this.getMaxTotalMsgBytes();
            }
            catch (MBeanException mBeanException) {
                this.logProblemGettingOldVal("MaxTotalMsgBytes", mBeanException);
                l = null;
            }
            this.notifyAttrChange("MaxTotalMsgBytes", l4, l);
        }
        this.initProps();
        return true;
    }

    public void notifyAttrChange(String string, Object object, Object object2) {
        this.sendNotification(new AttributeChangeNotification(this, this.sequenceNumber++, new Date().getTime(), "Attribute change", string, object == null ? "" : object.getClass().getName(), object2, object));
    }

    private void initProps() {
        this.brokerProps = Globals.getConfig().toProperties();
        Version version = Globals.getVersion();
        this.brokerProps.putAll((Map<?, ?>)version.getProps());
    }

    static {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[10];
        mBeanAttributeInfoArray[0] = new MBeanAttributeInfo("AutoCreateQueues", Boolean.class.getName(), mbr.getString("MB1166"), true, true, false);
        mBeanAttributeInfoArray[1] = new MBeanAttributeInfo("AutoCreateQueueMaxNumActiveConsumers", Integer.class.getName(), mbr.getString("MB1167"), true, true, false);
        mBeanAttributeInfoArray[2] = new MBeanAttributeInfo("AutoCreateQueueMaxNumBackupConsumers", Integer.class.getName(), mbr.getString("MB1168"), true, true, false);
        mBeanAttributeInfoArray[3] = new MBeanAttributeInfo("AutoCreateTopics", Boolean.class.getName(), mbr.getString("MB1169"), true, true, false);
        mBeanAttributeInfoArray[4] = new MBeanAttributeInfo("DMQTruncateBody", Boolean.class.getName(), mbr.getString("MB1170"), true, true, false);
        mBeanAttributeInfoArray[5] = new MBeanAttributeInfo("LogDeadMsgs", Boolean.class.getName(), mbr.getString("MB1171"), true, true, false);
        mBeanAttributeInfoArray[6] = new MBeanAttributeInfo("MaxBytesPerMsg", Long.class.getName(), mbr.getString("MB1172"), true, true, false);
        mBeanAttributeInfoArray[7] = new MBeanAttributeInfo("MaxNumMsgs", Long.class.getName(), mbr.getString("MB1173"), true, true, false);
        mBeanAttributeInfoArray[8] = new MBeanAttributeInfo("MaxTotalMsgBytes", Long.class.getName(), mbr.getString("MB1174"), true, true, false);
        mBeanAttributeInfoArray[9] = new MBeanAttributeInfo("NumDestinations", Integer.class.getName(), mbr.getString("MB1175"), true, false, false);
        attrs = mBeanAttributeInfoArray;
        MBeanParameterInfo[] mBeanParameterInfoArray = new MBeanParameterInfo[2];
        mBeanParameterInfoArray[0] = new MBeanParameterInfo("destinationType", String.class.getName(), mbr.getString("MB1187"));
        mBeanParameterInfoArray[1] = new MBeanParameterInfo("destinationName", String.class.getName(), mbr.getString("MB1188"));
        createSignature1 = mBeanParameterInfoArray;
        MBeanParameterInfo[] mBeanParameterInfoArray2 = new MBeanParameterInfo[3];
        mBeanParameterInfoArray2[0] = new MBeanParameterInfo("destinationType", String.class.getName(), mbr.getString("MB1187"));
        mBeanParameterInfoArray2[1] = new MBeanParameterInfo("destinationName", String.class.getName(), mbr.getString("MB1188"));
        mBeanParameterInfoArray2[2] = new MBeanParameterInfo("destinationAttrs", AttributeList.class.getName(), mbr.getString("MB1189"));
        createSignature2 = mBeanParameterInfoArray2;
        MBeanParameterInfo[] mBeanParameterInfoArray3 = new MBeanParameterInfo[2];
        mBeanParameterInfoArray3[0] = new MBeanParameterInfo("destinationType", String.class.getName(), mbr.getString("MB1187"));
        mBeanParameterInfoArray3[1] = new MBeanParameterInfo("destinationName", String.class.getName(), mbr.getString("MB1188"));
        destroySignature = mBeanParameterInfoArray3;
        MBeanParameterInfo[] mBeanParameterInfoArray4 = new MBeanParameterInfo[1];
        mBeanParameterInfoArray4[0] = new MBeanParameterInfo("pauseType", String.class.getName(), mbr.getString("MB1125"));
        pauseSignature = mBeanParameterInfoArray4;
        MBeanOperationInfo[] mBeanOperationInfoArray = new MBeanOperationInfo[8];
        mBeanOperationInfoArray[0] = new MBeanOperationInfo("create", mbr.getString("MB1180"), createSignature1, Void.TYPE.getName(), 1);
        mBeanOperationInfoArray[1] = new MBeanOperationInfo("create", mbr.getString("MB1180"), createSignature2, Void.TYPE.getName(), 1);
        mBeanOperationInfoArray[2] = new MBeanOperationInfo("compact", mbr.getString("MB1181"), null, Void.TYPE.getName(), 1);
        mBeanOperationInfoArray[3] = new MBeanOperationInfo("destroy", mbr.getString("MB1182"), destroySignature, Void.TYPE.getName(), 1);
        mBeanOperationInfoArray[4] = new MBeanOperationInfo("getDestinations", mbr.getString("MB1183"), null, ObjectName[].class.getName(), 0);
        mBeanOperationInfoArray[5] = new MBeanOperationInfo("pause", mbr.getString("MB1184"), null, Void.TYPE.getName(), 1);
        mBeanOperationInfoArray[6] = new MBeanOperationInfo("pause", mbr.getString("MB1185"), pauseSignature, Void.TYPE.getName(), 1);
        mBeanOperationInfoArray[7] = new MBeanOperationInfo("resume", mbr.getString("MB1186"), null, Void.TYPE.getName(), 1);
        ops = mBeanOperationInfoArray;
        attrChangeTypes = new String[]{"jmx.attribute.change"};
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[1];
        mBeanNotificationInfoArray[0] = new MBeanNotificationInfo(attrChangeTypes, AttributeChangeNotification.class.getName(), mbr.getString("MB1025"));
        notifs = mBeanNotificationInfoArray;
    }
}

