/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.BrokerMQAddress;
import com.sun.messaging.jmq.jmsserver.core.ClusterBroadcast;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.multibroker.ChangeRecord;
import com.sun.messaging.jmq.jmsserver.multibroker.ChangeRecordCallback;
import com.sun.messaging.jmq.jmsserver.multibroker.Cluster;
import com.sun.messaging.jmq.jmsserver.multibroker.ClusterGlobals;
import com.sun.messaging.jmq.jmsserver.multibroker.CommonProtocol;
import com.sun.messaging.jmq.jmsserver.multibroker.MessageBusCallback;
import com.sun.messaging.jmq.jmsserver.multibroker.Protocol;
import com.sun.messaging.jmq.jmsserver.multibroker.standalone.ClusterImpl;
import com.sun.messaging.jmq.jmsserver.persist.ChangeRecordInfo;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.service.ServiceManager;
import com.sun.messaging.jmq.jmsserver.service.ServiceRestriction;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;

public class ClusterBroadcaster
implements ClusterBroadcast,
MessageBusCallback,
ChangeRecordCallback {
    private static boolean DEBUG_CLUSTER_TXN = Globals.getConfig().getBooleanProperty("imq.cluster.debug.txn");
    private static boolean DEBUG = false;
    Logger logger = Globals.getLogger();
    BrokerConfig config = Globals.getConfig();
    BrokerResources br = Globals.getBrokerResources();
    private int version = 0;
    private BrokerAddress selfAddress = null;
    private String driver = null;
    private Cluster c = null;
    private int connLimit = 0;
    private Protocol protocol = null;
    private ChangeRecordInfo lastSyncedChangeRecord = null;
    private ChangeRecordInfo lastStoredChangeRecord = null;
    private transient Map<BrokerAddress, ChangeRecordInfo> lastReceivedChangeRecord = Collections.synchronizedMap(new HashMap());
    private boolean globalBlockModeOn = false;

    public ClusterBroadcaster(Integer n, Integer n2) throws BrokerException {
        this((int)n, (int)n2);
    }

    public ClusterBroadcaster(int n, int n2) throws BrokerException {
        this.connLimit = n;
        this.driver = this.config.getProperty("imq.topology");
        if (this.driver == null) {
            this.driver = "fullyconnected";
        }
        if (this.driver.equals("fullyconnected")) {
            this.c = new com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.ClusterImpl(this.connLimit);
            this.logger.log(8, "B1041");
        } else {
            this.driver = "standalone";
        }
        if (this.driver.equals("standalone")) {
            this.c = new ClusterImpl();
            this.logger.log(8, "B1042");
        }
        this.selfAddress = this.c.getSelfAddress();
        this.protocol = new CommonProtocol(this, this.c, this.selfAddress);
        if (n2 != this.protocol.getHighestSupportedVersion()) {
            throw new BrokerException("The version " + n2 + " is not supported by the ClusterBroadcaster");
        }
        this.version = n2;
        this.c.setCallback(this.protocol);
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public int getClusterVersion() throws BrokerException {
        return this.protocol.getClusterVersion();
    }

    public void startClusterIO() {
        this.protocol.startClusterIO();
    }

    public void stopClusterIO(boolean bl) {
        this.protocol.stopClusterIO(bl);
        Globals.getClusterRouter().shutdown();
    }

    public Hashtable getAllDebugState() {
        Hashtable<String, Hashtable> hashtable = new Hashtable<String, Hashtable>();
        if (this.c != null) {
            hashtable.put("CLUSTER", this.c.getDebugState());
        }
        if (this.protocol != null) {
            hashtable.put("PROTOCOL", this.protocol.getDebugState());
        }
        hashtable.put("CLUSTER_ROUTER", Globals.getClusterRouter().getDebugState());
        return hashtable;
    }

    public void reloadCluster() {
        this.protocol.reloadCluster();
    }

    public void pauseMessageFlow() throws IOException {
        this.protocol.stopMessageFlow();
    }

    public void resumeMessageFlow() throws IOException {
        this.protocol.resumeMessageFlow();
    }

    public void setMatchProps(Properties properties) {
        this.protocol.setMatchProps(properties);
    }

    public boolean waitForConfigSync() {
        return this.protocol.waitForConfigSync();
    }

    public BrokerAddress getMyAddress() {
        return this.selfAddress;
    }

    public boolean lockSharedResource(String string, Object object) {
        if (DEBUG) {
            this.logger.log(8, "lockSharedResource : " + string);
        }
        return this.protocol.lockSharedResource(string, (ConnectionUID)object) == 0;
    }

    public boolean lockDestination(DestinationUID destinationUID, Object object) {
        if (DEBUG) {
            this.logger.log(8, "lockDestination " + destinationUID);
        }
        return this.protocol.lockResource("destCreate:" + destinationUID.toString(), 0L, (ConnectionUID)object) == 0;
    }

    public void unlockDestination(DestinationUID destinationUID, Object object) {
        if (DEBUG) {
            this.logger.log(8, "unlockDestination " + destinationUID);
        }
        this.protocol.unlockResource("destCreate:" + destinationUID.toString());
    }

    public boolean lockClientID(String string, Object object, boolean bl) {
        if (DEBUG) {
            this.logger.log(8, "lockClientID " + string);
        }
        if (bl) {
            return this.protocol.lockSharedResource("clientid:" + string, (ConnectionUID)object) == 0;
        }
        return this.protocol.lockResource("clientid:" + string, 0L, (ConnectionUID)object) == 0;
    }

    public void unlockClientID(String string, Object object) {
        if (DEBUG) {
            this.logger.log(8, "unlockClientID " + string);
        }
        this.protocol.unlockResource("clientid:" + string);
    }

    public boolean getConsumerLock(ConsumerUID consumerUID, DestinationUID destinationUID, int n, int n2, Object object) throws BrokerException {
        if (DEBUG) {
            this.logger.log(8, "getConsumerLock " + consumerUID);
        }
        if (n2 > 1 && (this.c.getConfigServer() == null || this.c.getConfigServer() != null && !Globals.nowaitForMasterBroker()) && this.protocol.getClusterVersion() < 350) {
            throw new BrokerException("Feature not support in this cluster protocol");
        }
        return this.protocol.lockResource("queue:" + destinationUID.getName() + "_" + n, 0L, (ConnectionUID)object) == 0;
    }

    public void unlockConsumer(ConsumerUID consumerUID, DestinationUID destinationUID, int n) {
        if (DEBUG) {
            this.logger.log(8, "unlockConsumer " + consumerUID);
        }
        this.protocol.unlockResource("queue:" + destinationUID.getName() + "_" + n);
    }

    private int convertToClusterType(int n) {
        switch (n) {
            case 0: {
                return 2;
            }
            case 1: {
                return 3;
            }
            case 5: {
                return 1;
            }
            case 6: {
                return 4;
            }
            case 7: {
                return 5;
            }
            case 8: {
                return 9;
            }
            case 9: {
                return 10;
            }
            case 2: {
                return 6;
            }
            case 3: {
                return 7;
            }
            case 4: {
                return 8;
            }
        }
        return 0;
    }

    private int convertToLocalType(int n) {
        switch (n) {
            case 2: {
                return 0;
            }
            case 3: {
                return 1;
            }
            case 1: {
                return 5;
            }
            case 4: {
                return 6;
            }
            case 5: {
                return 7;
            }
            case 9: {
                return 8;
            }
            case 10: {
                return 9;
            }
            case 6: {
                return 2;
            }
            case 7: {
                return 3;
            }
            case 8: {
                return 4;
            }
        }
        return -1;
    }

    public void acknowledgeMessage(BrokerAddress brokerAddress, SysMessageID sysMessageID, ConsumerUID consumerUID, int n, Map map, boolean bl) throws BrokerException {
        if (brokerAddress == null || brokerAddress == this.selfAddress) {
            this.logger.log(32, "B3100", "Invalid broker address " + brokerAddress + " in acknowledge message " + sysMessageID + " [CID=" + consumerUID + ", ackType=" + ClusterGlobals.getAckTypeString(this.convertToClusterType(n)) + "]");
            return;
        }
        this.protocol.sendMessageAck(brokerAddress, sysMessageID, consumerUID, this.convertToClusterType(n), map, bl);
    }

    public void acknowledgeMessage2P(BrokerAddress brokerAddress, SysMessageID[] sysMessageIDArray, ConsumerUID[] consumerUIDArray, int n, Map map, Long l, boolean bl, boolean bl2) throws BrokerException {
        if (brokerAddress == null || brokerAddress == this.selfAddress && (!Globals.getHAEnabled() || l == null)) {
            this.logger.log(32, "B3100", "Invalid broker address " + brokerAddress + " in acknowledge message " + sysMessageIDArray + " [CID=" + consumerUIDArray + ", ackType=" + ClusterGlobals.getAckTypeString(this.convertToClusterType(n)) + ", TID=" + l + "]");
            throw new BrokerException(Globals.getBrokerResources().getKString("B3100", "Invalid broker address " + brokerAddress), 500);
        }
        if (Globals.getHAEnabled() && brokerAddress == this.selfAddress && DEBUG_CLUSTER_TXN) {
            this.logger.log(8, "Acknowledge (" + ClusterGlobals.getAckTypeString(this.convertToClusterType(n)) + ") to my address for transaction " + l);
        }
        this.protocol.sendMessageAck2P(brokerAddress, sysMessageIDArray, consumerUIDArray, this.convertToClusterType(n), map, l, bl, bl2);
    }

    public void recordUpdateDestination(Destination destination) throws BrokerException {
        if (DEBUG) {
            this.logger.log(8, "recordUpdateDestination : " + destination);
        }
        if (Globals.useSharedConfigRecord()) {
            ChangeRecord.recordUpdateDestination(destination, this);
            return;
        }
        this.protocol.recordUpdateDestination(destination);
    }

    public void recordRemoveDestination(Destination destination) throws BrokerException {
        if (DEBUG) {
            this.logger.log(8, "recordRemoveDestination : " + destination);
        }
        if (Globals.useSharedConfigRecord()) {
            ChangeRecord.recordRemoveDestination(destination, this);
            return;
        }
        this.protocol.recordRemoveDestination(destination);
    }

    public void createDestination(Destination destination) throws BrokerException {
        if (DEBUG) {
            this.logger.log(8, "createDestination " + destination);
        }
        this.protocol.sendNewDestination(destination);
    }

    public void recordCreateSubscription(Subscription subscription) throws BrokerException {
        if (DEBUG) {
            this.logger.log(8, "recordCreateSubscription " + subscription);
        }
        if (Globals.useSharedConfigRecord()) {
            ChangeRecord.recordCreateSubscription(subscription, this);
            return;
        }
        this.protocol.recordCreateSubscription(subscription);
    }

    public void recordUnsubscribe(Subscription subscription) throws BrokerException {
        if (DEBUG) {
            this.logger.log(8, "recordUnsubscribe " + subscription);
        }
        if (Globals.useSharedConfigRecord()) {
            ChangeRecord.recordUnsubscribe(subscription, this);
            return;
        }
        this.protocol.recordUnsubscribe(subscription);
    }

    public void createSubscription(Subscription subscription, Consumer consumer) throws BrokerException {
        if (DEBUG) {
            this.logger.log(8, "createSubscription " + subscription);
        }
        this.protocol.sendNewSubscription(subscription, consumer, false);
    }

    public void createConsumer(Consumer consumer) throws BrokerException {
        if (DEBUG) {
            this.logger.log(8, "createConsumer " + consumer);
        }
        this.protocol.sendNewConsumer(consumer, true);
    }

    public void updateDestination(Destination destination) throws BrokerException {
        if (DEBUG) {
            this.logger.log(8, "updateDestination " + destination);
        }
        this.protocol.sendUpdateDestination(destination);
    }

    public void updateSubscription(Subscription subscription) throws BrokerException {
    }

    public void updateConsumer(Consumer consumer) throws BrokerException {
    }

    public void destroyDestination(Destination destination) throws BrokerException {
        if (DEBUG) {
            this.logger.log(8, "destroyDestination " + destination);
        }
        this.protocol.sendRemovedDestination(destination);
    }

    public void destroyConsumer(Consumer consumer, Map map, boolean bl) throws BrokerException {
        if (DEBUG) {
            this.logger.log(8, "destroyConsumer " + consumer + ", pendingMsgs=" + map + ", cleanup=" + bl);
        }
        this.protocol.sendRemovedConsumer(consumer, map, bl);
    }

    public void connectionClosed(ConnectionUID connectionUID, boolean bl) {
        if (DEBUG) {
            this.logger.log(8, "connectionClosed " + connectionUID);
        }
        if (!bl) {
            this.protocol.clientClosed(connectionUID, true);
        }
    }

    public void messageDelivered(SysMessageID sysMessageID, ConsumerUID consumerUID, BrokerAddress brokerAddress) {
        if (DEBUG) {
            this.logger.log(8, "messageDelivered - XXX not implemented");
        }
    }

    public void forwardMessage(PacketReference packetReference, Collection collection) {
        Globals.getClusterRouter().forwardMessage(packetReference, collection);
    }

    public boolean lockUIDPrefix(short s) {
        if (DEBUG) {
            this.logger.log(8, "lockUIDPrefix " + s);
        }
        return this.protocol.lockResource("uidprefix:" + Short.toString(s), 0L, new ConnectionUID(0L)) == 0;
    }

    public void preTakeover(String string, UID uID, String string2, UID uID2) throws BrokerException {
        this.protocol.preTakeover(string, uID, string2, uID2);
    }

    public void postTakeover(String string, UID uID, boolean bl) {
        this.protocol.postTakeover(string, uID, bl);
    }

    public void configSyncComplete() {
        Random random = new Random();
        boolean bl = false;
        for (int i = 0; i < 5; ++i) {
            short s = (short)random.nextInt(Short.MAX_VALUE);
            if (!this.lockUIDPrefix(s)) continue;
            UID.setPrefix(s);
            bl = true;
            break;
        }
        if (!bl) {
            this.logger.log(16, Globals.getBrokerResources().getKString("B2220"));
        }
        ServiceManager serviceManager = Globals.getServiceManager();
        try {
            if (Globals.nowaitForMasterBroker()) {
                this.logger.log(8, Globals.getBrokerResources().getKString("B1263"));
                serviceManager.removeServiceRestriction(0, ServiceRestriction.NO_SYNC_WITH_MASTERBROKER);
            } else {
                serviceManager.resumeAllActiveServices(0);
            }
        }
        catch (Exception exception) {
            this.logger.logStack(32, "B3100", "during broker initialization", (Throwable)exception);
        }
    }

    public void interestCreated(Consumer consumer) {
        try {
            Globals.getClusterRouter().addConsumer(consumer);
        }
        catch (Exception exception) {
            this.logger.log(8, this.br.getKString("B2232", "" + exception, "" + consumer));
        }
    }

    public void unsubscribe(Subscription subscription) {
        if (DEBUG) {
            this.logger.log(4, "callback unsubscribe : " + subscription);
        }
        assert (subscription != null);
        try {
            Subscription.remoteUnsubscribe(subscription.getDurableName(), subscription.getClientID());
        }
        catch (Exception exception) {
            int n = 32;
            if (exception instanceof BrokerException && (((BrokerException)exception).getStatusCode() == 412 || ((BrokerException)exception).getStatusCode() == 404)) {
                n = 16;
            }
            if (n == 32 || DEBUG) {
                Object[] objectArray = new String[]{subscription.getDurableName(), subscription.getClientID(), exception.getMessage()};
                this.logger.logStack(n, "B3165", objectArray, (Throwable)exception);
            }
            this.logger.log(n, exception.getMessage());
        }
    }

    public void interestRemoved(Consumer consumer, Set set, boolean bl) {
        if (DEBUG) {
            this.logger.log(8, "callback interestRemoved " + consumer + ", pendingMsgs=" + set + ", cleanup=" + bl);
        }
        try {
            Globals.getClusterRouter().removeConsumer(consumer.getConsumerUID(), set, bl);
        }
        catch (Exception exception) {
            this.logger.logStack(32, "Unable to remove remote consumer " + consumer, exception);
        }
    }

    public void activeStateChanged(Consumer consumer) {
        if (DEBUG) {
            this.logger.log(8, "callback activeStateChanged " + consumer);
        }
    }

    public void clientDown(ConnectionUID connectionUID) {
        if (DEBUG) {
            this.logger.log(8, "clientDown " + connectionUID);
        }
        try {
            Globals.getClusterRouter().removeConsumers(connectionUID);
        }
        catch (Exception exception) {
            this.logger.logStack(8, "Internal Error: unable to remove remote consumers " + connectionUID, exception);
        }
    }

    public void brokerDown(BrokerAddress brokerAddress) {
        if (DEBUG) {
            this.logger.log(8, "brokerDown " + brokerAddress);
        }
        try {
            Globals.getClusterRouter().brokerDown(brokerAddress);
        }
        catch (Exception exception) {
            this.logger.logStack(8, "Internal Error: unable to remove remote consumers " + brokerAddress, exception);
        }
    }

    public void notifyCreateDestination(Destination destination) {
        try {
            Destination.addDestination(destination);
            destination.store();
        }
        catch (Exception exception) {
            this.logger.log(4, "Received exception adding new destination is caused because the destination " + destination + " is being autocreated on both sides", exception);
        }
    }

    public void notifyDestroyDestination(DestinationUID destinationUID) {
        try {
            Destination.removeDestination(destinationUID, false, Globals.getBrokerResources().getString("B0071"));
        }
        catch (Exception exception) {
            this.logger.log(4, "Internal Error: unable to remove stored destination " + destinationUID, exception);
        }
    }

    public void notifyUpdateDestination(DestinationUID destinationUID, Map map) {
        Destination destination = Destination.getDestination(destinationUID);
        if (destination != null) {
            try {
                destination.setDestinationProperties(map);
            }
            catch (Exception exception) {
                this.logger.log(8, "Internal Error, unable to update destination " + destinationUID.toString(), exception);
            }
        }
    }

    public void processRemoteMessage(Packet packet, List list, BrokerAddress brokerAddress, boolean bl) throws BrokerException {
        Globals.getClusterRouter().handleJMSMsg(packet, list, brokerAddress, bl);
    }

    public void processRemoteAck(SysMessageID sysMessageID, ConsumerUID consumerUID, int n, Map map) throws BrokerException {
        if (DEBUG) {
            this.logger.log(8, "processRemoteAck: " + sysMessageID + ":" + consumerUID + ", ackType=" + ClusterGlobals.getAckTypeString(n));
        }
        Globals.getClusterRouter().handleAck(this.convertToLocalType(n), sysMessageID, consumerUID, map);
    }

    public void processRemoteAck2P(SysMessageID[] sysMessageIDArray, ConsumerUID[] consumerUIDArray, int n, Map map, Long l, BrokerAddress brokerAddress) throws BrokerException {
        if (DEBUG) {
            this.logger.log(8, "processRemoteAck2P: " + sysMessageIDArray[0] + ":" + consumerUIDArray[0] + ", ackType=" + ClusterGlobals.getAckTypeString(n) + ",from " + brokerAddress);
        }
        Globals.getClusterRouter().handleAck2P(this.convertToLocalType(n), sysMessageIDArray, consumerUIDArray, map, l, brokerAddress);
    }

    public void goHAActive() {
    }

    public void sendClusterTransactionInfo(long l, BrokerAddress brokerAddress) {
        this.protocol.sendClusterTransactionInfo(l, brokerAddress);
    }

    public BrokerAddress lookupBrokerAddress(String string) {
        return this.protocol.lookupBrokerAddress(string);
    }

    public void syncChangeRecordOnStartup() throws BrokerException {
        ChangeRecord.storeResetRecordIfNecessary(this);
        ChangeRecord.syncChangeRecord(this, this, ((CommonProtocol)this.protocol).getRealProtocol(), true);
    }

    public void syncChangeRecordOnJoin(BrokerAddress brokerAddress, ChangeRecordInfo changeRecordInfo) throws BrokerException {
        String string = null;
        if (this.lastSyncedChangeRecord != null) {
            string = this.lastSyncedChangeRecord.getResetUUID();
        }
        if (string == null) {
            String string2 = string = this.lastStoredChangeRecord == null ? null : this.lastStoredChangeRecord.getResetUUID();
        }
        if (string != null && !string.equals(changeRecordInfo.getResetUUID())) {
            throw new BrokerException(this.br.getKString("B4322", "[" + string + ", " + changeRecordInfo.getResetUUID() + "]", brokerAddress.toString()), 412);
        }
        ChangeRecordInfo changeRecordInfo2 = this.lastReceivedChangeRecord.get(brokerAddress);
        if (!(changeRecordInfo2 != null && changeRecordInfo2.getSeq() >= changeRecordInfo.getSeq() && changeRecordInfo2.getResetUUID().equals(changeRecordInfo.getResetUUID()) || this.lastSyncedChangeRecord != null && (this.lastSyncedChangeRecord == null || this.lastSyncedChangeRecord.getSeq() >= changeRecordInfo.getSeq()))) {
            this.logger.log(8, this.br.getKString("B1367", brokerAddress + "[" + changeRecordInfo + "]"));
            ChangeRecord.syncChangeRecord(this, this, ((CommonProtocol)this.protocol).getRealProtocol(), false);
        }
    }

    public void setLastSyncedChangeRecord(ChangeRecordInfo changeRecordInfo) {
        this.lastSyncedChangeRecord = changeRecordInfo;
    }

    public ChangeRecordInfo getLastSyncedChangeRecord() {
        return this.lastSyncedChangeRecord;
    }

    public ChangeRecordInfo getLastStoredChangeRecord() {
        return this.lastStoredChangeRecord;
    }

    public void setLastStoredChangeRecord(ChangeRecordInfo changeRecordInfo) {
        this.lastStoredChangeRecord = changeRecordInfo;
    }

    public void setLastReceivedChangeRecord(BrokerAddress brokerAddress, ChangeRecordInfo changeRecordInfo) {
        this.lastReceivedChangeRecord.put(brokerAddress, changeRecordInfo);
    }

    public void changeMasterBroker(BrokerMQAddress brokerMQAddress, BrokerMQAddress brokerMQAddress2) throws BrokerException {
        if (DEBUG) {
            this.logger.log(8, "changeMasterBroker from " + brokerMQAddress2 + " to " + brokerMQAddress);
        }
        this.protocol.changeMasterBroker(brokerMQAddress, brokerMQAddress2);
    }
}

