/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.inmemory;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.inmemory.InMemoryStore;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.concurrent.ConcurrentHashMap;

class DestinationStore {
    Logger logger = Globals.getLogger();
    BrokerResources br = Globals.getBrokerResources();
    private ConcurrentHashMap dstMap = null;
    private InMemoryStore parent = null;

    DestinationStore(InMemoryStore inMemoryStore) {
        this.parent = inMemoryStore;
        this.dstMap = new ConcurrentHashMap(64);
    }

    void storeDestination(Destination destination) throws IOException, BrokerException {
        DestinationUID destinationUID = destination.getDestinationUID();
        try {
            Destination destination2 = this.dstMap.putIfAbsent(destinationUID, destination);
            if (destination2 != null) {
                this.logger.log(32, "B3012", destination.getName());
                throw new BrokerException(this.br.getString("B3012", destination.getName()));
            }
        }
        catch (RuntimeException runtimeException) {
            this.logger.log(32, "B4014", destination.getName());
            throw new BrokerException(this.br.getString("B4014", destination.getName()), runtimeException);
        }
    }

    void updateDestination(Destination destination) throws BrokerException {
        DestinationUID destinationUID = destination.getDestinationUID();
        try {
            Destination destination2 = this.dstMap.replace(destinationUID, destination);
            if (destination2 == null) {
                this.logger.log(32, "B3013", destination.getName());
                throw new BrokerException(this.br.getString("B3013", destination.getName()));
            }
        }
        catch (RuntimeException runtimeException) {
            this.logger.log(32, "B4014", destination.getName());
            throw new BrokerException(this.br.getString("B4014", destination.getName()), runtimeException);
        }
    }

    void removeDestination(Destination destination) throws BrokerException {
        DestinationUID destinationUID = destination.getDestinationUID();
        try {
            Object v = this.dstMap.remove(destinationUID);
            if (v == null) {
                this.logger.log(32, "B3013", destination.getName());
                throw new BrokerException(this.br.getString("B3013", destination.getName()));
            }
            this.parent.getMsgStore().releaseMessageDir(destinationUID);
        }
        catch (RuntimeException runtimeException) {
            this.logger.log(32, "B4144", (Object)destination.getName(), (Throwable)runtimeException);
            throw new BrokerException(this.br.getString("B4144", destination.getName()), runtimeException);
        }
    }

    Destination getDestination(DestinationUID destinationUID) throws IOException {
        return (Destination)this.dstMap.get(destinationUID);
    }

    Destination[] getAllDestinations() throws IOException {
        return this.dstMap.values().toArray(new Destination[0]);
    }

    Collection getDestinations() {
        return this.dstMap.values();
    }

    void clearAll(boolean bl) {
        if (Store.getDEBUG()) {
            this.logger.log(1, "DestinationStore.clearAll(" + bl + ") called");
        }
        if (bl) {
            for (Destination destination : this.dstMap.values()) {
                DestinationUID destinationUID = destination.getDestinationUID();
                this.parent.getMsgStore().releaseMessageDir(destinationUID);
            }
        }
        this.dstMap.clear();
    }

    Hashtable getDebugState() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("Destinations", String.valueOf(this.dstMap.size()));
        return hashtable;
    }

    void close(boolean bl) {
        if (Store.getDEBUG()) {
            this.logger.log(1, "DestinationStore: closing, " + this.dstMap.size() + " in-memory destinations");
        }
    }

    void checkDestination(DestinationUID destinationUID) throws BrokerException {
        if (!this.dstMap.containsKey(destinationUID)) {
            this.logger.log(32, "B3013", destinationUID.toString());
            throw new BrokerException(this.br.getString("B3013", destinationUID.toString()));
        }
    }
}

