/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BaseDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DestinationDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.DestinationNotFoundException;
import com.sun.messaging.jmq.util.DestType;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

class DestinationDAOImpl
extends BaseDAOImpl
implements DestinationDAO {
    protected String tableName;
    protected String insertSQL;
    protected String updateSQL;
    protected String updateConnectedTimeSQL;
    protected String deleteSQL;
    protected String deleteSharedDstSQL;
    protected String selectSQL;
    protected String selectConnectedTimeSQL;
    protected String selectDstsByBrokerSQL;
    protected String selectLocalDstsByBrokerSQL;
    protected String selectExistSQL;

    DestinationDAOImpl() throws BrokerException {
        DBManager dBManager = DBManager.getDBManager();
        this.tableName = dBManager.getTableName("MQDST41");
        this.insertSQL = new StringBuffer(128).append("INSERT INTO ").append(this.tableName).append(" ( ").append("ID").append(", ").append("DESTINATION").append(", ").append("IS_LOCAL").append(", ").append("CONNECTION_ID").append(", ").append("CONNECTED_TS").append(", ").append("STORE_SESSION_ID").append(", ").append("CREATED_TS").append(") VALUES ( ?, ?, ?, ?, ?, ?, ? )").toString();
        this.updateSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("DESTINATION").append(" = ?, ").append("IS_LOCAL").append(" = ?, ").append("CONNECTION_ID").append(" = ?").append(" WHERE ").append("ID").append(" = ?").toString();
        this.updateConnectedTimeSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("CONNECTED_TS").append(" = ?").append(" WHERE ").append("ID").append(" = ?").toString();
        this.deleteSQL = new StringBuffer(128).append("DELETE FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.deleteSharedDstSQL = new StringBuffer(128).append(this.deleteSQL).append(" AND NOT EXISTS (SELECT * FROM ").append(dBManager.getTableName("MQMSG41")).append(" WHERE ").append("DESTINATION_ID").append(" = ?)").append(" AND NOT EXISTS (SELECT * FROM ").append(dBManager.getTableName("MQBKR41")).append(" WHERE ").append("ID").append(" <> ? ").append(" AND ").append("STATE").append(" = ").append(1).append(")").toString();
        this.selectSQL = new StringBuffer(128).append("SELECT ").append("DESTINATION").append(" FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.selectConnectedTimeSQL = new StringBuffer(128).append("SELECT ").append("CONNECTED_TS").append(" FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.selectDstsByBrokerSQL = new StringBuffer(128).append("SELECT ").append("DESTINATION").append(" FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" IN (SELECT ").append("ID").append(" FROM ").append(this.tableName).append(" WHERE ").append("IS_LOCAL").append(" = 0").append(" UNION SELECT dstTbl.").append("ID").append(" FROM ").append(this.tableName).append(" dstTbl, ").append(dBManager.getTableName("MQSES41")).append(" sesTbl WHERE sesTbl.").append("BROKER_ID").append(" = ?").append(" AND sesTbl.").append("ID").append(" = dstTbl.").append("STORE_SESSION_ID").append(")").toString();
        this.selectLocalDstsByBrokerSQL = new StringBuffer(128).append("SELECT ").append("DESTINATION").append(" FROM ").append(this.tableName).append(" dstTbl, ").append(dBManager.getTableName("MQSES41")).append(" sesTbl WHERE ").append(" sesTbl.").append("BROKER_ID").append(" = ?").append(" AND ").append(" sesTbl.").append("ID").append(" = dstTbl.").append("STORE_SESSION_ID").toString();
        this.selectExistSQL = new StringBuffer(128).append("SELECT ").append("ID").append(" FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
    }

    public final String getTableNamePrefix() {
        return "MQDST41";
    }

    public final String getTableName() {
        return this.tableName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void insert(Connection connection, Destination destination, long l, long l2, long l3) throws BrokerException {
        Exception exception;
        PreparedStatement preparedStatement;
        block19: {
            String string = destination.getUniqueName();
            boolean bl = false;
            preparedStatement = null;
            exception = null;
            try {
                try {
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(true);
                        bl = true;
                    }
                    if (this.hasDestination(connection, string)) {
                        throw new BrokerException(this.br.getKString("B3012", string));
                    }
                    try {
                        ConnectionUID connectionUID;
                        int n;
                        int n2 = n = destination.getIsLocal() ? 1 : 0;
                        if (n == 0) {
                            l = 0L;
                        }
                        long l4 = -1L;
                        if (destination.isTemporary() && (connectionUID = destination.getConnectionUID()) != null) {
                            l4 = connectionUID.longValue();
                            if (l2 <= 0L) {
                                l2 = System.currentTimeMillis();
                            }
                        }
                        preparedStatement = connection.prepareStatement(this.insertSQL);
                        preparedStatement.setString(1, string);
                        Util.setObject(preparedStatement, 2, destination);
                        preparedStatement.setInt(3, n);
                        Util.setLong(preparedStatement, 4, l4);
                        Util.setLong(preparedStatement, 5, l2);
                        Util.setLong(preparedStatement, 6, l);
                        preparedStatement.setLong(7, l3);
                        preparedStatement.executeUpdate();
                    }
                    catch (Exception exception2) {
                        Exception exception3;
                        exception = exception2;
                        try {
                            if (connection != null && !connection.getAutoCommit()) {
                                connection.rollback();
                            }
                        }
                        catch (SQLException sQLException) {
                            this.logger.log(32, "B4080", sQLException);
                        }
                        if (exception2 instanceof BrokerException) {
                            throw (BrokerException)exception2;
                        }
                        if (exception2 instanceof IOException) {
                            exception3 = DBManager.wrapIOException("[" + this.insertSQL + "]", (IOException)exception2);
                            throw new BrokerException(this.br.getKString("B4014", string), exception3);
                        }
                        if (exception2 instanceof SQLException) {
                            exception3 = DBManager.wrapSQLException("[" + this.insertSQL + "]", (SQLException)exception2);
                            throw new BrokerException(this.br.getKString("B4014", string), exception3);
                        }
                        exception3 = exception2;
                        throw new BrokerException(this.br.getKString("B4014", string), exception3);
                    }
                    Object var19_18 = null;
                    if (!bl) break block19;
                }
                catch (BrokerException brokerException) {
                    exception = brokerException;
                    throw brokerException;
                }
            }
            catch (Throwable throwable) {
                Object var19_19 = null;
                if (bl) {
                    Util.close(null, preparedStatement, connection, exception);
                    throw throwable;
                }
                Util.close(null, preparedStatement, null, exception);
                throw throwable;
            }
            Util.close(null, preparedStatement, connection, exception);
            return;
        }
        Util.close(null, preparedStatement, null, exception);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void update(Connection connection, Destination destination) throws BrokerException {
        Exception exception;
        PreparedStatement preparedStatement;
        block15: {
            String string = destination.getUniqueName();
            boolean bl = false;
            preparedStatement = null;
            exception = null;
            try {
                try {
                    ConnectionUID connectionUID;
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(true);
                        bl = true;
                    }
                    int n = destination.getIsLocal() ? 1 : 0;
                    long l = -1L;
                    if (n > 0 && (connectionUID = destination.getConnectionUID()) != null) {
                        l = connectionUID.longValue();
                    }
                    preparedStatement = connection.prepareStatement(this.updateSQL);
                    Util.setObject(preparedStatement, 1, destination);
                    preparedStatement.setInt(2, n);
                    Util.setLong(preparedStatement, 3, l);
                    preparedStatement.setString(4, string);
                    if (preparedStatement.executeUpdate() == 0) {
                        throw new DestinationNotFoundException(this.br.getKString("B3013", string), 404);
                    }
                    Object var13_14 = null;
                    if (!bl) break block15;
                }
                catch (Exception exception2) {
                    Exception exception3;
                    exception = exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080", sQLException);
                    }
                    if (exception2 instanceof BrokerException) {
                        throw (BrokerException)exception2;
                    }
                    if (exception2 instanceof IOException) {
                        exception3 = DBManager.wrapIOException("[" + this.updateSQL + "]", (IOException)exception2);
                        throw new BrokerException(this.br.getKString("B4014", string), exception3);
                    }
                    if (exception2 instanceof SQLException) {
                        exception3 = DBManager.wrapSQLException("[" + this.updateSQL + "]", (SQLException)exception2);
                        throw new BrokerException(this.br.getKString("B4014", string), exception3);
                    }
                    exception3 = exception2;
                    throw new BrokerException(this.br.getKString("B4014", string), exception3);
                }
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                if (bl) {
                    Util.close(null, preparedStatement, connection, exception);
                    throw throwable;
                }
                Util.close(null, preparedStatement, null, exception);
                throw throwable;
            }
            Util.close(null, preparedStatement, connection, exception);
            return;
        }
        Util.close(null, preparedStatement, null, exception);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateConnectedTime(Connection connection, Destination destination, long l) throws BrokerException {
        Exception exception;
        PreparedStatement preparedStatement;
        block14: {
            String string = destination.getUniqueName();
            if (!destination.getIsLocal()) {
                throw new BrokerException(this.br.getKString("B3181", string));
            }
            boolean bl = false;
            preparedStatement = null;
            exception = null;
            try {
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.updateConnectedTimeSQL);
                    preparedStatement.setLong(1, l);
                    preparedStatement.setString(2, string);
                    if (preparedStatement.executeUpdate() == 0) {
                        throw new DestinationNotFoundException(this.br.getKString("B3013", string), 404);
                    }
                    Object var12_8 = null;
                    if (!bl) break block14;
                }
                catch (Exception exception2) {
                    Exception exception3;
                    exception = exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080", sQLException);
                    }
                    if (exception2 instanceof BrokerException) {
                        throw (BrokerException)exception2;
                    }
                    if (exception2 instanceof SQLException) {
                        exception3 = DBManager.wrapSQLException("[" + this.updateConnectedTimeSQL + "]", (SQLException)exception2);
                        throw new BrokerException(this.br.getKString("B4014", string), exception3);
                    }
                    exception3 = exception2;
                    throw new BrokerException(this.br.getKString("B4014", string), exception3);
                }
            }
            catch (Throwable throwable) {
                Object var12_9 = null;
                if (bl) {
                    Util.close(null, preparedStatement, connection, exception);
                    throw throwable;
                }
                Util.close(null, preparedStatement, null, exception);
                throw throwable;
            }
            Util.close(null, preparedStatement, connection, exception);
            return;
        }
        Util.close(null, preparedStatement, null, exception);
    }

    public boolean delete(Connection connection, Destination destination) throws BrokerException {
        return this.delete(connection, destination.getDestinationUID(), destination.getType());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean delete(Connection connection, DestinationUID destinationUID, int n) throws BrokerException {
        Exception exception;
        PreparedStatement preparedStatement;
        boolean bl;
        block16: {
            bl = false;
            String string = destinationUID.toString();
            boolean bl2 = false;
            String string2 = null;
            preparedStatement = null;
            exception = null;
            try {
                try {
                    int n2;
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(false);
                        bl2 = true;
                    }
                    if ((n2 = dBManager.getDAOFactory().getMessageDAO().deleteByDestination(connection, destinationUID)) > 0) {
                        this.logger.log(16, "B2181", (Object)String.valueOf(n2), destinationUID);
                    }
                    if (Globals.getHAEnabled() && DestType.isAutoCreated(n) && !DestType.isTemporary(n)) {
                        string2 = this.deleteSharedDstSQL;
                        preparedStatement = connection.prepareStatement(string2);
                        preparedStatement.setString(1, string);
                        preparedStatement.setString(2, string);
                        preparedStatement.setString(3, dBManager.getBrokerID());
                    } else {
                        string2 = this.deleteSQL;
                        preparedStatement = connection.prepareStatement(string2);
                        preparedStatement.setString(1, string);
                    }
                    int n3 = preparedStatement.executeUpdate();
                    if (bl2) {
                        connection.commit();
                    }
                    bl = n3 > 0;
                }
                catch (Exception exception2) {
                    Exception exception3;
                    exception = exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080", sQLException);
                    }
                    if (exception2 instanceof BrokerException) {
                        throw (BrokerException)exception2;
                    }
                    if (exception2 instanceof SQLException) {
                        exception3 = DBManager.wrapSQLException("[" + string2 + "]", (SQLException)exception2);
                        throw new BrokerException(this.br.getKString("B4144", string), exception3);
                    }
                    exception3 = exception2;
                    throw new BrokerException(this.br.getKString("B4144", string), exception3);
                }
                Object var14_16 = null;
                if (!bl2) break block16;
            }
            catch (Throwable throwable) {
                Object var14_17 = null;
                if (bl2) {
                    Util.close(null, preparedStatement, connection, exception);
                    throw throwable;
                }
                Util.close(null, preparedStatement, null, exception);
                throw throwable;
            }
            Util.close(null, preparedStatement, connection, exception);
            return bl;
        }
        Util.close(null, preparedStatement, null, exception);
        return bl;
    }

    public void deleteAll(Connection connection) throws BrokerException {
        String string = null;
        if (Globals.getHAEnabled()) {
            DBManager dBManager = DBManager.getDBManager();
            string = new StringBuffer(128).append("EXISTS (SELECT ").append("ID").append(" FROM ").append(dBManager.getTableName("MQSES41")).append(" WHERE ").append("ID").append(" = ").append(this.tableName).append(".").append("STORE_SESSION_ID").append(" AND ").append("BROKER_ID").append(" = '").append(dBManager.getBrokerID()).append("')").toString();
        }
        this.deleteAll(connection, string, null, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Destination getDestination(Connection connection, String string) throws BrokerException {
        Exception exception;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Destination destination;
        block12: {
            destination = null;
            boolean bl = false;
            preparedStatement = null;
            resultSet = null;
            exception = null;
            try {
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectSQL);
                    preparedStatement.setString(1, string);
                    resultSet = preparedStatement.executeQuery();
                    destination = (Destination)this.loadData(resultSet, true);
                }
                catch (Exception exception2) {
                    Exception exception3;
                    exception = exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080", sQLException);
                    }
                    if (exception2 instanceof BrokerException) {
                        throw (BrokerException)exception2;
                    }
                    if (exception2 instanceof SQLException) {
                        exception3 = DBManager.wrapSQLException("[" + this.selectSQL + "]", (SQLException)exception2);
                        throw new BrokerException(this.br.getKString("B4224", string), exception3);
                    }
                    exception3 = exception2;
                    throw new BrokerException(this.br.getKString("B4224", string), exception3);
                }
                Object var11_8 = null;
                if (!bl) break block12;
            }
            catch (Throwable throwable) {
                Object var11_9 = null;
                if (bl) {
                    Util.close(resultSet, preparedStatement, connection, exception);
                    throw throwable;
                }
                Util.close(resultSet, preparedStatement, null, exception);
                throw throwable;
            }
            Util.close(resultSet, preparedStatement, connection, exception);
            return destination;
        }
        Util.close(resultSet, preparedStatement, null, exception);
        return destination;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getDestinationConnectedTime(Connection connection, String string) throws BrokerException {
        Exception exception;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        long l;
        block12: {
            l = -1L;
            boolean bl = false;
            preparedStatement = null;
            resultSet = null;
            exception = null;
            try {
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectConnectedTimeSQL);
                    preparedStatement.setString(1, string);
                    resultSet = preparedStatement.executeQuery();
                    if (!resultSet.next()) throw new DestinationNotFoundException(this.br.getKString("B3013", string), 404);
                    l = resultSet.getLong(1);
                    Object var12_8 = null;
                    if (!bl) break block12;
                }
                catch (Exception exception2) {
                    Exception exception3;
                    exception = exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080", sQLException);
                    }
                    if (exception2 instanceof BrokerException) {
                        throw (BrokerException)exception2;
                    }
                    if (exception2 instanceof SQLException) {
                        exception3 = DBManager.wrapSQLException("[" + this.selectConnectedTimeSQL + "]", (SQLException)exception2);
                        throw new BrokerException(this.br.getKString("B4224", string), exception3);
                    }
                    exception3 = exception2;
                    throw new BrokerException(this.br.getKString("B4224", string), exception3);
                }
            }
            catch (Throwable throwable) {
                Object var12_9 = null;
                if (bl) {
                    Util.close(resultSet, preparedStatement, connection, exception);
                    throw throwable;
                }
                Util.close(resultSet, preparedStatement, null, exception);
                throw throwable;
            }
            Util.close(resultSet, preparedStatement, connection, exception);
            return l;
        }
        Util.close(resultSet, preparedStatement, null, exception);
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List getAllDestinations(Connection connection, String string) throws BrokerException {
        Exception exception;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        List list;
        block13: {
            list = Collections.EMPTY_LIST;
            boolean bl = false;
            preparedStatement = null;
            resultSet = null;
            exception = null;
            try {
                try {
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(true);
                        bl = true;
                    }
                    if (string == null) {
                        string = dBManager.getBrokerID();
                    }
                    preparedStatement = connection.prepareStatement(this.selectDstsByBrokerSQL);
                    preparedStatement.setString(1, string);
                    resultSet = preparedStatement.executeQuery();
                    list = (List)this.loadData(resultSet, false);
                }
                catch (Exception exception2) {
                    Exception exception3;
                    exception = exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080", sQLException);
                    }
                    if (exception2 instanceof BrokerException) {
                        throw (BrokerException)exception2;
                    }
                    if (exception2 instanceof SQLException) {
                        exception3 = DBManager.wrapSQLException("[" + this.selectDstsByBrokerSQL + "]", (SQLException)exception2);
                        throw new BrokerException(this.br.getKString("B4031"), exception3);
                    }
                    exception3 = exception2;
                    throw new BrokerException(this.br.getKString("B4031"), exception3);
                }
                Object var11_10 = null;
                if (!bl) break block13;
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                if (bl) {
                    Util.close(resultSet, preparedStatement, connection, exception);
                    throw throwable;
                }
                Util.close(resultSet, preparedStatement, null, exception);
                throw throwable;
            }
            Util.close(resultSet, preparedStatement, connection, exception);
            return list;
        }
        Util.close(resultSet, preparedStatement, null, exception);
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List getAllLocalDestinations(Connection connection, String string) throws BrokerException {
        Exception exception;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        List list;
        block13: {
            list = Collections.EMPTY_LIST;
            boolean bl = false;
            preparedStatement = null;
            resultSet = null;
            exception = null;
            try {
                try {
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(true);
                        bl = true;
                    }
                    if (string == null) {
                        string = dBManager.getBrokerID();
                    }
                    preparedStatement = connection.prepareStatement(this.selectLocalDstsByBrokerSQL);
                    preparedStatement.setString(1, string);
                    resultSet = preparedStatement.executeQuery();
                    list = (List)this.loadData(resultSet, false);
                }
                catch (Exception exception2) {
                    Exception exception3;
                    exception = exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080", sQLException);
                    }
                    if (exception2 instanceof BrokerException) {
                        throw (BrokerException)exception2;
                    }
                    if (exception2 instanceof SQLException) {
                        exception3 = DBManager.wrapSQLException("[" + this.selectLocalDstsByBrokerSQL + "]", (SQLException)exception2);
                        throw new BrokerException(this.br.getKString("B3175", string), exception3);
                    }
                    exception3 = exception2;
                    throw new BrokerException(this.br.getKString("B3175", string), exception3);
                }
                Object var11_10 = null;
                if (!bl) break block13;
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                if (bl) {
                    Util.close(resultSet, preparedStatement, connection, exception);
                    throw throwable;
                }
                Util.close(resultSet, preparedStatement, null, exception);
                throw throwable;
            }
            Util.close(resultSet, preparedStatement, connection, exception);
            return list;
        }
        Util.close(resultSet, preparedStatement, null, exception);
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasDestination(Connection connection, String string) throws BrokerException {
        Exception exception;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        boolean bl;
        block13: {
            bl = false;
            boolean bl2 = false;
            preparedStatement = null;
            resultSet = null;
            exception = null;
            try {
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl2 = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectExistSQL);
                    preparedStatement.setString(1, string);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        bl = true;
                    }
                }
                catch (Exception exception2) {
                    Exception exception3;
                    exception = exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080", sQLException);
                    }
                    if (exception2 instanceof BrokerException) {
                        throw (BrokerException)exception2;
                    }
                    if (exception2 instanceof SQLException) {
                        exception3 = DBManager.wrapSQLException("[" + this.selectExistSQL + "]", (SQLException)exception2);
                        throw new BrokerException(this.br.getKString("B4166", this.selectExistSQL), exception3);
                    }
                    exception3 = exception2;
                    throw new BrokerException(this.br.getKString("B4166", this.selectExistSQL), exception3);
                }
                Object var11_8 = null;
                if (!bl2) break block13;
            }
            catch (Throwable throwable) {
                Object var11_9 = null;
                if (bl2) {
                    Util.close(resultSet, preparedStatement, connection, exception);
                    throw throwable;
                }
                Util.close(resultSet, preparedStatement, null, exception);
                throw throwable;
            }
            Util.close(resultSet, preparedStatement, connection, exception);
            return bl;
        }
        Util.close(resultSet, preparedStatement, null, exception);
        return bl;
    }

    public void checkDestination(Connection connection, String string) throws BrokerException {
        if (!this.hasDestination(connection, string)) {
            try {
                if (connection != null && !connection.getAutoCommit()) {
                    connection.rollback();
                }
            }
            catch (SQLException sQLException) {
                this.logger.log(32, "B4080[checkDestination:" + string + "]", sQLException);
            }
            throw new DestinationNotFoundException(this.br.getKString("B3013", string), 404);
        }
    }

    public HashMap getDebugInfo(Connection connection) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = -1;
        try {
            n = this.getRowCount(null, null);
        }
        catch (Exception exception) {
            this.logger.log(32, exception.getMessage(), exception.getCause());
        }
        hashMap.put("Destinations(" + this.tableName + ")", String.valueOf(n));
        return hashMap;
    }

    protected Object loadData(ResultSet resultSet, boolean bl) throws SQLException {
        ArrayList<Destination> arrayList = null;
        if (!bl) {
            arrayList = new ArrayList<Destination>(100);
        }
        while (resultSet.next()) {
            try {
                Destination destination = (Destination)Util.readObject(resultSet, 1);
                if (bl) {
                    return destination;
                }
                arrayList.add(destination);
            }
            catch (Exception exception) {
                this.logger.logStack(32, "B4124", exception);
            }
        }
        return arrayList;
    }
}

