/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.stomp;

import com.sun.grizzly.BaseSelectionKeyHandler;
import com.sun.grizzly.Controller;
import com.sun.grizzly.ControllerStateListener;
import com.sun.grizzly.ControllerStateListenerAdapter;
import com.sun.grizzly.DefaultProtocolChain;
import com.sun.grizzly.ProtocolChain;
import com.sun.grizzly.ProtocolChainInstanceHandler;
import com.sun.grizzly.ProtocolFilter;
import com.sun.grizzly.ProtocolParser;
import com.sun.grizzly.SSLConfig;
import com.sun.grizzly.SSLSelectorHandler;
import com.sun.grizzly.SelectionKeyHandler;
import com.sun.grizzly.SelectorHandler;
import com.sun.grizzly.TCPSelectorHandler;
import com.sun.grizzly.filter.ParserProtocolFilter;
import com.sun.grizzly.util.AttributeHolder;
import com.sun.grizzly.util.ConnectionCloseHandler;
import com.sun.grizzly.util.Grizzly;
import com.sun.messaging.bridge.service.BridgeContext;
import com.sun.messaging.bridge.service.LogSimpleFormatter;
import com.sun.messaging.bridge.service.MessageTransformer;
import com.sun.messaging.bridge.service.stomp.StompProtocolFilter;
import com.sun.messaging.bridge.service.stomp.StompProtocolHandler;
import com.sun.messaging.bridge.service.stomp.StompProtocolParser;
import com.sun.messaging.bridge.service.stomp.resources.StompBridgeResources;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.nio.channels.SelectionKey;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StompServer
implements ConnectionCloseHandler {
    private static final String PROP_HOSTNAME_SUFFIX = ".hostname";
    private static final String PROP_TCPENABLED_SUFFIX = ".tcp.enabled";
    private static final String PROP_SSLENABLED_SUFFIX = ".tls.enabled";
    private static final String PROP_TCPPORT_SUFFIX = ".tcp.port";
    private static final String PROP_SSLPORT_SUFFIX = ".tls.port";
    private static final String PROP_SSL_REQUIRE_CLIENTAUTH_SUFFIX = ".tls.requireClientAuth";
    private static final String PROP_FLOWLIMIT_SUFFIX = ".consumerFlowLimit";
    private static final String PROP_MSGTRANSFORM_SUFFIX = ".messageTransformer";
    private static final String PROP_LOGFILE_LIMIT_SUFFIX = ".logfile.limit";
    private static final String PROP_LOGFILE_COUNT_SUFFIX = ".logfile.count";
    public static final int DEFAULT_TCPPORT = 7672;
    public static final int DEFAULT_SSLPORT = 7673;
    private static StompBridgeResources _sbr = StompServer.getStompBridgeResources();
    private static Logger _logger = null;
    private int TCPPORT = 7672;
    private int SSLPORT = 7673;
    private InetAddress HOST = null;
    private String TCPHOSTNAMEPORT = null;
    private String SSLHOSTNAMEPORT = null;
    private Controller controller = null;
    private static MessageTransformer<Message, Message> _msgTransformer = null;
    private BridgeContext _bc = null;
    private boolean _tcpEnabled = false;
    private boolean _sslEnabled = false;
    private boolean _inited = false;

    public synchronized void init(BridgeContext bridgeContext) throws Exception {
        Object object;
        BaseSelectionKeyHandler baseSelectionKeyHandler;
        TCPSelectorHandler tCPSelectorHandler;
        String string;
        String string2;
        String string3;
        String string4;
        File file;
        String string5;
        this._bc = bridgeContext;
        Properties properties = bridgeContext.getConfig();
        String string6 = properties.getProperty((string5 = properties.getProperty("BRIDGE_PROP_PREFIX")) + PROP_MSGTRANSFORM_SUFFIX);
        if (string6 != null) {
            _msgTransformer = (MessageTransformer)Class.forName(string6).newInstance();
        }
        Properties properties2 = new Properties();
        String string7 = properties.getProperty(string5 + PROP_FLOWLIMIT_SUFFIX);
        if (string7 != null) {
            properties2.setProperty("imqConsumerFlowLimit", String.valueOf(Integer.parseInt(string7)));
        }
        _logger = Logger.getLogger(string5);
        if (bridgeContext.isSilentMode()) {
            _logger.setUseParentHandlers(false);
        }
        if (!(file = new File(string4 = bridgeContext.getRootDir())).exists()) {
            file.mkdirs();
        }
        String string8 = string4 + File.separator + "stomp%g.log";
        int n = 0;
        int n2 = 1;
        String string9 = properties.getProperty(string5 + PROP_LOGFILE_LIMIT_SUFFIX);
        if (string9 != null) {
            n = Integer.parseInt(string9);
        }
        if ((string3 = properties.getProperty(string5 + PROP_LOGFILE_COUNT_SUFFIX)) != null) {
            n2 = Integer.parseInt(string3);
        }
        FileHandler fileHandler = new FileHandler(string8, n, n2, true);
        fileHandler.setFormatter(new LogSimpleFormatter(_logger));
        _logger.addHandler(fileHandler);
        _logger.log(Level.INFO, StompServer.getStompBridgeResources().getString("BSS1010", string5));
        _logger.log(Level.INFO, StompServer.getStompBridgeResources().getString("BSS1011", string8) + "[" + n + "," + n2 + "]");
        if (!bridgeContext.isEmbededBroker()) {
            Controller.setLogger((Logger)_logger);
        }
        if ((string2 = properties.getProperty(string5 + PROP_TCPENABLED_SUFFIX, "true")) != null && Boolean.valueOf(string2).booleanValue()) {
            string = properties.getProperty(string5 + PROP_TCPPORT_SUFFIX, String.valueOf(7672));
            this.TCPPORT = Integer.parseInt(string);
            this._tcpEnabled = true;
        }
        if ((string2 = properties.getProperty(string5 + PROP_SSLENABLED_SUFFIX, "false")) != null && Boolean.valueOf(string2).booleanValue()) {
            string = properties.getProperty(string5 + PROP_SSLPORT_SUFFIX, String.valueOf(7673));
            this.SSLPORT = Integer.parseInt(string);
            this._sslEnabled = true;
        }
        if (!this._tcpEnabled && !this._sslEnabled) {
            throw new IllegalArgumentException(StompServer.getStompBridgeResources().getKString("BSS4024"));
        }
        string2 = properties.getProperty(string5 + PROP_HOSTNAME_SUFFIX);
        if (string2 == null || string2.length() == 0) {
            string2 = bridgeContext.getBrokerHostName();
        }
        string = null;
        if (string2 != null && string2.length() > 0) {
            string = string2;
            this.HOST = InetAddress.getByName(string2);
        } else {
            string = InetAddress.getLocalHost().getCanonicalHostName();
        }
        URL uRL = new URL("http", string, this.TCPPORT, "");
        this.TCPHOSTNAMEPORT = uRL.getHost() + ":" + this.TCPPORT;
        uRL = new URL("http", string, this.SSLPORT, "");
        this.SSLHOSTNAMEPORT = uRL.getHost() + ":" + this.SSLPORT;
        int n3 = Grizzly.getMajorVersion();
        int n4 = Grizzly.getMinorVersion();
        if (n3 != 1) {
            Object[] objectArray = new String[]{String.valueOf(n3), Grizzly.getDotedVersion(), String.valueOf(1)};
            String string10 = StompServer.getStompBridgeResources().getKString("BSS4036", objectArray);
            _logger.log(Level.SEVERE, string10);
            throw new UnsupportedOperationException(string10);
        }
        if (n4 < 9) {
            Object[] objectArray = new String[]{String.valueOf(n4), Grizzly.getDotedVersion(), String.valueOf(9)};
            String string11 = StompServer.getStompBridgeResources().getKString("BSS4037", objectArray);
            _logger.log(Level.SEVERE, string11);
            throw new UnsupportedOperationException(string11);
        }
        _logger.log(Level.INFO, StompServer.getStompBridgeResources().getString("BSS1024", Grizzly.getDotedVersion()));
        this.controller = new Controller();
        if (this._tcpEnabled) {
            tCPSelectorHandler = new TCPSelectorHandler();
            baseSelectionKeyHandler = new BaseSelectionKeyHandler();
            baseSelectionKeyHandler.setConnectionCloseHandler((ConnectionCloseHandler)this);
            tCPSelectorHandler.setSelectionKeyHandler((SelectionKeyHandler)baseSelectionKeyHandler);
            tCPSelectorHandler.setPort(this.TCPPORT);
            if (this.HOST != null) {
                tCPSelectorHandler.setInet(this.HOST);
            }
            this.controller.addSelectorHandler((SelectorHandler)tCPSelectorHandler);
            object = new DefaultProtocolChain();
            object.setContinuousExecution(true);
            this.setProtocolChain((SelectorHandler)tCPSelectorHandler, (ProtocolChain)object, null, properties2);
        }
        if (this._sslEnabled) {
            _logger.log(Level.INFO, StompServer.getStompBridgeResources().getString("BSS1012"));
            tCPSelectorHandler = new SSLSelectorHandler();
            baseSelectionKeyHandler = new BaseSelectionKeyHandler();
            baseSelectionKeyHandler.setConnectionCloseHandler((ConnectionCloseHandler)this);
            tCPSelectorHandler.setSelectionKeyHandler((SelectionKeyHandler)baseSelectionKeyHandler);
            tCPSelectorHandler.setPort(this.SSLPORT);
            if (this.HOST != null) {
                tCPSelectorHandler.setInet(this.HOST);
            }
            this.controller.addSelectorHandler((SelectorHandler)tCPSelectorHandler);
            object = this._bc.getDefaultSSLContextConfig();
            SSLConfig sSLConfig = new SSLConfig(false);
            sSLConfig.setKeyStoreFile(((Properties)object).getProperty("javax.net.ssl.keyStore"));
            sSLConfig.setKeyStorePass(((Properties)object).getProperty("javax.net.ssl.trustStorePassword"));
            sSLConfig.setKeyStoreType(((Properties)object).getProperty("javax.net.ssl.keyStoreType"));
            sSLConfig.setKeyManagerFactoryAlgorithm(((Properties)object).getProperty("ssl.KeyManagerFactory.algorithm"));
            sSLConfig.setTrustStoreFile(((Properties)object).getProperty("javax.net.ssl.trustStore"));
            sSLConfig.setTrustStorePass(((Properties)object).getProperty("javax.net.ssl.trustStorePassword"));
            sSLConfig.setTrustStoreType(((Properties)object).getProperty("javax.net.ssl.trustStoreType"));
            sSLConfig.setTrustManagerFactoryAlgorithm(((Properties)object).getProperty("ssl.TrustManagerFactory.algorithm"));
            sSLConfig.setSecurityProtocol(((Properties)object).getProperty("securesocket.protocol"));
            string2 = properties.getProperty(string5 + PROP_SSL_REQUIRE_CLIENTAUTH_SUFFIX, "false");
            if (string2 != null && Boolean.valueOf(string2).booleanValue()) {
                sSLConfig.setNeedClientAuth(true);
            }
            DefaultProtocolChain defaultProtocolChain = new DefaultProtocolChain();
            defaultProtocolChain.setContinuousExecution(true);
            this.setProtocolChain((SelectorHandler)tCPSelectorHandler, (ProtocolChain)defaultProtocolChain, sSLConfig, properties2);
        }
        if (this._tcpEnabled) {
            this._bc.registerService("stomp[TCP]", "stomp", this.TCPPORT, null);
        }
        if (this._sslEnabled) {
            this._bc.registerService("stomp[SSL/TLS]", "stomp", this.SSLPORT, null);
        }
        this._inited = true;
    }

    private void setProtocolChain(SelectorHandler selectorHandler, final ProtocolChain protocolChain, SSLConfig sSLConfig, Properties properties) throws Exception {
        ParserProtocolFilter parserProtocolFilter = new ParserProtocolFilter(){

            public ProtocolParser newProtocolParser() {
                StompProtocolParser stompProtocolParser = new StompProtocolParser(StompServer.this._bc);
                return stompProtocolParser;
            }
        };
        if (sSLConfig != null) {
            parserProtocolFilter.setSSLConfig(sSLConfig);
        }
        protocolChain.addFilter((ProtocolFilter)parserProtocolFilter);
        protocolChain.addFilter((ProtocolFilter)new StompProtocolFilter(this._bc, properties));
        selectorHandler.setProtocolChainInstanceHandler(new ProtocolChainInstanceHandler(){

            public ProtocolChain poll() {
                return protocolChain;
            }

            public boolean offer(ProtocolChain protocolChain2) {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINEST, "ProtocolChain.offer(): return false");
                }
                return false;
            }
        });
    }

    protected static Logger logger() {
        return _logger;
    }

    public synchronized void start() {
        if (!this._inited) {
            String string = StompServer.getStompBridgeResources().getKString("BSS4025");
            _logger.log(Level.SEVERE, string);
            throw new IllegalStateException(string);
        }
        if (this._tcpEnabled) {
            _logger.log(Level.INFO, StompServer.getStompBridgeResources().getString("BSS1013", "TCP", this.TCPHOSTNAMEPORT));
        }
        if (this._sslEnabled) {
            _logger.log(Level.INFO, StompServer.getStompBridgeResources().getString("BSS1013", "SSL/TLS", this.SSLHOSTNAMEPORT));
        }
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        this.controller.addStateListener((ControllerStateListener)new ControllerStateListenerAdapter(){

            public void onReady() {
                countDownLatch.countDown();
            }

            public void onException(Throwable throwable) {
                if (countDownLatch.getCount() > 0L) {
                    _logger.log(Level.SEVERE, StompServer.getStompBridgeResources().getKString("BSS3005", throwable.getMessage()), throwable);
                    countDownLatch.countDown();
                } else {
                    _logger.log(Level.SEVERE, StompServer.getStompBridgeResources().getKString("BSS3006", throwable.getMessage()), throwable);
                }
            }
        });
        new Thread((Runnable)this.controller).start();
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            _logger.log(Level.WARNING, StompServer.getStompBridgeResources().getKString("BSS2007", interruptedException.getMessage()));
        }
        if (!this.controller.isStarted()) {
            throw new IllegalStateException(StompServer.getStompBridgeResources().getKString("BSS4026"));
        }
        _logger.log(Level.INFO, StompServer.getStompBridgeResources().getString("BSS1014", String.valueOf(this.controller.getReadThreadsCount())));
    }

    public synchronized void stop() {
        if (!this._inited) {
            String string = StompServer.getStompBridgeResources().getKString("BSS4025");
            _logger.log(Level.SEVERE, string);
            throw new IllegalStateException(string);
        }
        _logger.log(Level.INFO, StompServer.getStompBridgeResources().getString("BSS1015"));
        try {
            this.controller.stop();
        }
        catch (IOException iOException) {
            _logger.log(Level.WARNING, StompServer.getStompBridgeResources().getKString("BSS2008", iOException.getMessage()));
            iOException.printStackTrace();
        }
        _logger.log(Level.INFO, StompServer.getStompBridgeResources().getString("BSS1016"));
    }

    protected static Logger getLogger() {
        return _logger;
    }

    protected static MessageTransformer<Message, Message> getMessageTransformer() {
        return _msgTransformer;
    }

    public void locallyClosed(SelectionKey selectionKey) {
        AttributeHolder attributeHolder;
        StompProtocolHandler stompProtocolHandler;
        _logger.log(Level.INFO, StompServer.getStompBridgeResources().getString("BSS1017", selectionKey == null ? "" : selectionKey.toString()));
        if (selectionKey == null) {
            return;
        }
        Object object = selectionKey.attachment();
        if (object instanceof AttributeHolder && (stompProtocolHandler = (StompProtocolHandler)(attributeHolder = (AttributeHolder)object).getAttribute("stomp-protocol-handler")) != null) {
            _logger.log(Level.INFO, StompServer.getStompBridgeResources().getString("BSS1019", stompProtocolHandler == null ? "" : stompProtocolHandler.toString(), selectionKey == null ? "" : selectionKey.toString()));
            stompProtocolHandler.close(true);
        }
    }

    public void remotlyClosed(SelectionKey selectionKey) {
        AttributeHolder attributeHolder;
        StompProtocolHandler stompProtocolHandler;
        _logger.log(Level.INFO, StompServer.getStompBridgeResources().getString("BSS1018", selectionKey == null ? "" : selectionKey.toString()));
        if (selectionKey == null) {
            return;
        }
        Object object = selectionKey.attachment();
        if (object instanceof AttributeHolder && (stompProtocolHandler = (StompProtocolHandler)(attributeHolder = (AttributeHolder)object).getAttribute("stomp-protocol-handler")) != null) {
            _logger.log(Level.INFO, StompServer.getStompBridgeResources().getString("BSS1019", stompProtocolHandler == null ? "" : stompProtocolHandler.toString(), selectionKey == null ? "" : selectionKey.toString()));
            stompProtocolHandler.close(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StompBridgeResources getStompBridgeResources() {
        if (_sbr != null) return _sbr;
        Class<StompServer> clazz = StompServer.class;
        synchronized (StompServer.class) {
            if (_sbr != null) return _sbr;
            _sbr = StompBridgeResources.getResources(Locale.getDefault());
            // ** MonitorExit[var0] (shouldn't be in output)
            return _sbr;
        }
    }
}

