/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util.timer;

import com.sun.messaging.jmq.util.timer.TimerEventHandler;

public class WakeupableTimer
implements Runnable {
    private static boolean DEBUG = false;
    private String name = null;
    private long nexttime = 0L;
    private long repeatinterval = 0L;
    private Thread thr = null;
    private Runnable runner = null;
    private boolean valid = true;
    private boolean wakeup = false;
    private String startString = null;
    private String exitString = null;
    private TimerEventHandler handler = null;

    public WakeupableTimer(String string, Runnable runnable, long l, long l2, String string2, String string3, TimerEventHandler timerEventHandler) {
        this.name = string;
        this.nexttime = l + System.currentTimeMillis();
        this.repeatinterval = l2;
        this.runner = runnable;
        this.startString = string2;
        this.exitString = string3;
        this.handler = timerEventHandler;
        this.thr = new Thread((Runnable)this, string);
        this.thr.start();
    }

    public synchronized void wakeup() {
        this.wakeup = true;
        this.notify();
    }

    public void cancel() {
        this.valid = false;
        this.wakeup();
        this.thr.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.handler.handleLogInfo(this.startString);
            long l = System.currentTimeMillis();
            while (this.valid) {
                try {
                    WakeupableTimer wakeupableTimer = this;
                    synchronized (wakeupableTimer) {
                        while (!this.wakeup && l < this.nexttime) {
                            try {
                                this.wait(this.nexttime - l);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            l = System.currentTimeMillis();
                        }
                        if (!this.valid) {
                            break;
                        }
                        this.wakeup = false;
                    }
                    if (DEBUG) {
                        this.handler.handleLogInfo(this.name + " run " + this.runner.getClass().getName());
                    }
                    this.runner.run();
                    if (DEBUG) {
                        this.handler.handleLogInfo(this.name + " completed run " + this.runner.getClass().getName());
                    }
                    if (!this.wakeup && this.repeatinterval == 0L) break;
                    l = System.currentTimeMillis();
                    this.nexttime = l + this.repeatinterval;
                }
                catch (Throwable throwable) {
                    this.handler.handleLogWarn(throwable.getMessage(), throwable);
                    if (!(throwable instanceof OutOfMemoryError)) continue;
                    this.handler.handleOOMError(throwable);
                }
            }
            this.handler.handleLogInfo(this.exitString);
        }
        catch (Throwable throwable) {
            this.handler.handleLogError(this.exitString, throwable);
            this.handler.handleTimerExit(throwable);
        }
    }
}

