/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.TransactionAckExistException;
import com.sun.messaging.jmq.util.UID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.locks.ReentrantLock;

class TransactionInformation {
    int type = 0;
    ArrayList published;
    LinkedHashMap consumed;
    LinkedHashMap removedConsumed;
    TransactionState state;
    HashMap cuidToStored;
    HashMap sysidToAddr;
    LinkedHashMap orphanedMessages;
    TransactionUID tid = null;
    boolean persisted = false;
    boolean inROLLBACK = false;
    TransactionBroker[] brokers = null;
    boolean cluster = false;
    boolean processed = false;
    private ReentrantLock takeoverLock = new ReentrantLock();

    public TransactionInformation(TransactionUID transactionUID, TransactionState transactionState, boolean bl) {
        this.published = new ArrayList();
        this.consumed = new LinkedHashMap();
        this.removedConsumed = new LinkedHashMap();
        this.cuidToStored = new HashMap();
        this.sysidToAddr = new HashMap();
        this.orphanedMessages = new LinkedHashMap();
        this.state = transactionState;
        this.tid = transactionUID;
        this.persisted = bl;
        this.type = 1;
    }

    public void getTakeoverLock() {
        this.takeoverLock.lock();
    }

    public void releaseTakeoverLock() {
        this.takeoverLock.unlock();
    }

    public boolean isTakeoverLocked() {
        boolean bl = this.takeoverLock.isLocked();
        if (bl && this.takeoverLock.isHeldByCurrentThread()) {
            return false;
        }
        return bl;
    }

    public synchronized int getType() {
        return this.type;
    }

    public synchronized boolean processed() {
        if (this.processed) {
            return true;
        }
        this.processed = true;
        return false;
    }

    public synchronized boolean isProcessed() {
        return this.processed;
    }

    public synchronized String toString() {
        if (this.type == 2) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("TransactionInfo[" + this.tid + "]cluster - ");
            for (int i = 0; i < this.brokers.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.brokers[i].toString());
            }
            return stringBuffer.toString();
        }
        return "TransactionInfo[" + this.tid + "]local";
    }

    public synchronized void addOrphanAck(SysMessageID sysMessageID, ConsumerUID consumerUID) {
        this.addOrphanAck(sysMessageID, consumerUID, null);
    }

    public synchronized void addOrphanAck(SysMessageID sysMessageID, ConsumerUID consumerUID, ConsumerUID consumerUID2) {
        ArrayList<ConsumerUID> arrayList;
        LinkedHashMap<ConsumerUID, ArrayList<ConsumerUID>> linkedHashMap = (LinkedHashMap<ConsumerUID, ArrayList<ConsumerUID>>)this.orphanedMessages.get(sysMessageID);
        if (linkedHashMap == null) {
            linkedHashMap = new LinkedHashMap<ConsumerUID, ArrayList<ConsumerUID>>();
            this.orphanedMessages.put(sysMessageID, linkedHashMap);
        }
        if ((arrayList = (ArrayList<ConsumerUID>)linkedHashMap.get(consumerUID)) == null) {
            arrayList = new ArrayList<ConsumerUID>();
            linkedHashMap.put(consumerUID, arrayList);
        }
        if (consumerUID2 != null) {
            arrayList.add(consumerUID2);
        }
    }

    public synchronized void removeOrphanAck(SysMessageID sysMessageID, ConsumerUID consumerUID, ConsumerUID consumerUID2) {
        Map map = (Map)this.orphanedMessages.get(sysMessageID);
        if (map == null) {
            return;
        }
        if (consumerUID2 == null) {
            map.remove(consumerUID);
            if (map.size() == 0) {
                this.orphanedMessages.remove(sysMessageID);
            }
            return;
        }
        List list = (List)map.get(consumerUID);
        if (list == null) {
            return;
        }
        list.remove(consumerUID2);
    }

    public synchronized Map getOrphanAck() {
        return this.orphanedMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getDebugState() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        TransactionInformation transactionInformation = this;
        synchronized (transactionInformation) {
            int n;
            Vector<String> vector;
            ArrayList arrayList;
            String string;
            Cloneable cloneable;
            hashtable.put("state", this.state.getDebugState());
            hashtable.put("inROLLBACK", this.inROLLBACK);
            hashtable.put("processed", String.valueOf(this.processed));
            hashtable.put("consumed#", new Integer(this.consumed.size()));
            hashtable.put("removedConsumed#", new Integer(this.removedConsumed.size()));
            hashtable.put("published#", new Integer(this.published.size()));
            hashtable.put("cuidToStored#", new Integer(this.cuidToStored.size()));
            if (this.cuidToStored.size() > 0) {
                cloneable = new Hashtable<String, String>();
                for (Map.Entry entry : hashtable.entrySet()) {
                    ((Hashtable)cloneable).put(entry.getKey().toString(), entry.getValue().toString());
                }
                hashtable.put("cuidToStored", cloneable);
            }
            if (this.consumed.size() > 0) {
                cloneable = new Hashtable();
                for (Map.Entry entry : this.consumed.entrySet()) {
                    string = entry.getKey().toString();
                    arrayList = (ArrayList)entry.getValue();
                    if (arrayList.size() == 0) continue;
                    if (arrayList.size() == 1) {
                        ((Hashtable)cloneable).put(string, arrayList.get(0).toString());
                        continue;
                    }
                    vector = new Vector<String>();
                    for (n = 0; n < arrayList.size(); ++n) {
                        vector.add(arrayList.get(n).toString());
                    }
                    ((Hashtable)cloneable).put(string, vector);
                }
                if (((Hashtable)cloneable).size() > 0) {
                    hashtable.put("consumed", cloneable);
                }
            }
            if (this.removedConsumed.size() > 0) {
                cloneable = new Hashtable();
                for (Map.Entry entry : this.removedConsumed.entrySet()) {
                    string = entry.getKey().toString();
                    arrayList = (ArrayList)entry.getValue();
                    if (arrayList.size() == 0) continue;
                    if (arrayList.size() == 1) {
                        ((Hashtable)cloneable).put(string, arrayList.get(0).toString());
                        continue;
                    }
                    vector = new Vector();
                    for (n = 0; n < arrayList.size(); ++n) {
                        vector.add(arrayList.get(n).toString());
                    }
                    ((Hashtable)cloneable).put(string, vector);
                }
                if (((Hashtable)cloneable).size() > 0) {
                    hashtable.put("removedConsumed", cloneable);
                }
            }
            if (this.published.size() > 0) {
                cloneable = new Vector();
                for (int i = 0; i < this.published.size(); ++i) {
                    ((Vector)cloneable).add(this.published.get(i).toString());
                }
                hashtable.put("published", cloneable);
            }
            if (this.type == 2) {
                cloneable = new Vector();
                for (int i = 0; i < this.brokers.length; ++i) {
                    ((Vector)cloneable).add(this.brokers[i].toString());
                }
                hashtable.put("brokers", cloneable);
            }
        }
        return hashtable;
    }

    public synchronized List getPublishedMessages() {
        return this.published;
    }

    public synchronized int getNPublishedMessages() {
        if (this.published != null) {
            return this.published.size();
        }
        return 0;
    }

    public synchronized LinkedHashMap getConsumedMessages(boolean bl) {
        this.inROLLBACK = bl;
        return this.consumed;
    }

    public synchronized HashMap getStoredConsumerUIDs() {
        return this.cuidToStored;
    }

    public synchronized int getNConsumedMessages() {
        if (this.consumed != null) {
            return this.consumed.size();
        }
        return 0;
    }

    public synchronized TransactionState getState() {
        return this.state;
    }

    public synchronized void addPublishedMessage(SysMessageID sysMessageID) throws BrokerException {
        if (this.published.size() >= TransactionList.defaultProducerMaxMsgCnt) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4303", TransactionList.defaultProducerMaxMsgCnt, this.tid), "B4303", null, 414);
        }
        this.published.add(sysMessageID);
    }

    public synchronized boolean checkConsumedMessage(SysMessageID sysMessageID, ConsumerUID consumerUID) {
        List list = (List)this.consumed.get(sysMessageID);
        if (list == null) {
            return false;
        }
        return list.contains(consumerUID);
    }

    public synchronized boolean isConsumedMessage(SysMessageID sysMessageID, ConsumerUID consumerUID) {
        if (this.state == null) {
            return false;
        }
        if (this.state.getState() == 7) {
            return false;
        }
        if (this.inROLLBACK) {
            return false;
        }
        List list = (List)this.consumed.get(sysMessageID);
        if (list == null) {
            return false;
        }
        return list.contains(consumerUID);
    }

    public synchronized void addConsumedMessage(SysMessageID sysMessageID, ConsumerUID consumerUID, ConsumerUID consumerUID2) throws BrokerException {
        ArrayList<ConsumerUID> arrayList;
        if (this.consumed.size() < TransactionList.defaultConsumerMaxMsgCnt) {
            arrayList = (ArrayList<ConsumerUID>)this.consumed.get(sysMessageID);
            if (arrayList == null) {
                arrayList = new ArrayList<ConsumerUID>();
                this.consumed.put(sysMessageID, arrayList);
            } else if (arrayList.contains(consumerUID)) {
                BrokerResources brokerResources = Globals.getBrokerResources();
                Globals.getBrokerResources();
                throw new TransactionAckExistException(brokerResources.getKString("B4273", "[" + sysMessageID + ":" + consumerUID + "," + consumerUID2 + "]", this.tid), 409);
            }
        } else {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4304", TransactionList.defaultConsumerMaxMsgCnt, this.tid), "B4304", null, 414);
        }
        arrayList.add(consumerUID);
        this.cuidToStored.put(consumerUID, consumerUID2);
    }

    public synchronized void setAckBrokerAddress(SysMessageID sysMessageID, ConsumerUID consumerUID, BrokerAddress brokerAddress) throws BrokerException {
        BrokerAddress brokerAddress2 = (BrokerAddress)this.sysidToAddr.get(sysMessageID);
        if (!(brokerAddress2 == null || brokerAddress2.equals(brokerAddress) && brokerAddress2.getBrokerSessionUID().equals(brokerAddress.getBrokerSessionUID()))) {
            BrokerException brokerException = new BrokerException("Message requeued:" + sysMessageID, 410);
            brokerException.setRemoteConsumerUIDs(String.valueOf(consumerUID.longValue()));
            brokerException.setRemote(true);
            throw brokerException;
        }
        this.sysidToAddr.put(sysMessageID, brokerAddress);
    }

    public synchronized BrokerAddress getAckBrokerAddress(SysMessageID sysMessageID, ConsumerUID consumerUID) {
        return (BrokerAddress)this.sysidToAddr.get(sysMessageID);
    }

    public synchronized HashMap getAckBrokerAddresses() {
        return this.sysidToAddr;
    }

    public TransactionUID getTID() {
        return this.tid;
    }

    public synchronized ConsumerUID removeConsumedMessage(SysMessageID sysMessageID, ConsumerUID consumerUID) throws BrokerException {
        ArrayList<ConsumerUID> arrayList = (ArrayList<ConsumerUID>)this.consumed.get(sysMessageID);
        if (arrayList == null) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4302", "[" + sysMessageID + "," + consumerUID + "]", this.tid.toString()));
        }
        arrayList.remove(consumerUID);
        if (arrayList.size() == 0) {
            this.consumed.remove(sysMessageID);
        }
        if ((arrayList = (List)this.removedConsumed.get(sysMessageID)) == null) {
            arrayList = new ArrayList<ConsumerUID>();
            this.removedConsumed.put(sysMessageID, arrayList);
        }
        arrayList.add(consumerUID);
        return (ConsumerUID)this.cuidToStored.get(consumerUID);
    }

    public synchronized LinkedHashMap getRemovedConsumedMessages() {
        return this.removedConsumed;
    }

    public synchronized void setClusterTransactionBrokers(TransactionBroker[] transactionBrokerArray) {
        this.brokers = transactionBrokerArray;
        this.type = 2;
    }

    public synchronized TransactionBroker[] getClusterTransactionBrokers() {
        return this.brokers;
    }

    public synchronized boolean isClusterTransactionBrokersCompleted() {
        boolean bl = true;
        for (int i = 0; i < this.brokers.length; ++i) {
            if (this.brokers[i].isCompleted()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public synchronized TransactionBroker getClusterTransactionBroker(BrokerAddress brokerAddress) {
        if (this.brokers == null) {
            return null;
        }
        BrokerAddress brokerAddress2 = null;
        for (int i = 0; i < this.brokers.length; ++i) {
            brokerAddress2 = this.brokers[i].getCurrentBrokerAddress();
            if (brokerAddress2 == null || !brokerAddress2.equals(brokerAddress)) continue;
            return this.brokers[i];
        }
        return null;
    }

    public synchronized boolean isClusterTransactionBroker(UID uID) {
        if (this.brokers == null) {
            return false;
        }
        for (int i = 0; i < this.brokers.length; ++i) {
            if (!this.brokers[i].isSame(uID)) continue;
            return true;
        }
        return false;
    }
}

