/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util.txnlog.file;

import com.sun.messaging.jmq.util.txnlog.file.FileTransactionLogRecord;
import com.sun.messaging.jmq.util.txnlog.file.FileTransactionLogWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class FileLogRecordIterator
implements Iterator {
    private FileTransactionLogWriter lwriter = null;
    private RandomAccessFile raf = null;
    private long cpPosition = -1L;
    private long cpSequence = -1L;
    private FileTransactionLogRecord entry = null;
    private FileTransactionLogRecord[] compoundEntries = null;
    private int compoundEntryIndex = 0;
    private boolean eof = false;
    private long ct = 0L;
    private long entrySequence = 0L;
    private boolean debug = Boolean.getBoolean("imq.txnlog.debug");

    public FileLogRecordIterator(FileTransactionLogWriter fileTransactionLogWriter) throws IOException {
        this.lwriter = fileTransactionLogWriter;
        this.raf = this.lwriter.getRAF();
        this.cpPosition = this.lwriter.getCPPosition();
        this.cpSequence = this.lwriter.getCPSequence();
        this.raf.seek(this.cpPosition);
        this.readNextRecord();
    }

    public synchronized boolean hasNext() {
        return this.entry != null;
    }

    public synchronized Object next() {
        if (this.eof) {
            throw new NoSuchElementException();
        }
        if (this.entry != null) {
            FileTransactionLogRecord fileTransactionLogRecord = this.entry;
            if (this.compoundEntries != null) {
                if (this.compoundEntryIndex < this.compoundEntries.length - 1) {
                    ++this.compoundEntryIndex;
                    this.entry = this.compoundEntries[this.compoundEntryIndex];
                    if (this.debug) {
                        this.log("setting next entry to a compound sub record");
                    }
                    return fileTransactionLogRecord;
                }
                if (this.debug) {
                    this.log("This is the last compound sub record");
                }
                this.compoundEntries = null;
                this.compoundEntryIndex = 0;
            }
            this.entry = null;
            this.readNextRecord();
            return fileTransactionLogRecord;
        }
        throw new NoSuchElementException();
    }

    public void remove() {
        throw new UnsupportedOperationException("Unsupported Operation.");
    }

    private synchronized void readNextRecord() {
        if (this.debug) {
            this.log("readNextRecord");
        }
        if (this.eof) {
            return;
        }
        try {
            long l;
            byte[] byArray = new byte[48];
            int n = this.raf.read(byArray);
            if (n < 48) {
                this.log("Reached end of file., records read: " + this.ct);
                this.eof = true;
                return;
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            int n2 = byteBuffer.getInt();
            int n3 = byteBuffer.getInt();
            int n4 = byteBuffer.getInt();
            long l2 = byteBuffer.getLong();
            if (n2 != -1431677611) {
                this.log("Reached end of file. No Magic number., records read: " + this.ct);
                this.eof = true;
                return;
            }
            long l3 = byteBuffer.getLong();
            long l4 = byteBuffer.getLong();
            byte[] byArray2 = new byte[n4];
            int n5 = this.raf.read(byArray2);
            if (n5 < n4) {
                this.log("Reached end of file. Body read reached EOF. records read: " + this.ct);
                this.eof = true;
                return;
            }
            long l5 = byteBuffer.getLong();
            if (l5 != (l = this.lwriter.calculateCheckSum(byArray2))) {
                this.log("Reached end of file.  Check sum not validate., records read: " + this.ct);
                this.eof = true;
                return;
            }
            if (l4 != this.cpSequence) {
                this.log("Reached end of check point.  records read: " + this.ct);
                this.eof = true;
                return;
            }
            if (l3 != this.entrySequence) {
                this.log("Entry sequence is not valid. Expected: " + this.entrySequence + ", but read: " + l3 + ", total records read: " + this.ct);
                this.eof = true;
                return;
            }
            ++this.entrySequence;
            this.entry = new FileTransactionLogRecord(l2, n3, l3);
            this.entry.setCheckPointSequence(l4);
            this.entry.setBody(byArray2);
            if (this.entry.getType() == 8) {
                this.processCompoundTransactionLogRecord();
            }
            ++this.ct;
        }
        catch (Exception exception) {
            this.eof = true;
        }
    }

    private void processCompoundTransactionLogRecord() {
        FileTransactionLogRecord fileTransactionLogRecord = this.entry;
        byte[] byArray = fileTransactionLogRecord.getBody();
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        int n = byteBuffer.getInt();
        if (this.debug) {
            this.log("processCompoundTransactionLogRecord numEntries=" + n);
        }
        this.compoundEntries = new FileTransactionLogRecord[n];
        this.compoundEntryIndex = 0;
        for (int i = 0; i < n; ++i) {
            FileTransactionLogRecord fileTransactionLogRecord2 = new FileTransactionLogRecord(this.entry.getTimestamp(), this.entry.getType(), this.entry.getSequence());
            fileTransactionLogRecord2.setCheckPointSequence(this.entry.getCheckPointSequence());
            this.compoundEntries[i] = fileTransactionLogRecord2;
            int n2 = byteBuffer.getInt();
            fileTransactionLogRecord2.setType(n2);
            int n3 = byteBuffer.getInt();
            byte[] byArray2 = new byte[n3];
            byteBuffer.get(byArray2);
            fileTransactionLogRecord2.setBody(byArray2);
        }
        this.entry = this.compoundEntries[0];
    }

    private void log(String string) {
        if (this.debug) {
            System.out.println(new Date() + ": " + string);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        String string = "MQTxn.log";
        if (stringArray.length > 0) {
            string = stringArray[0];
        }
        int n = 0;
        FileTransactionLogWriter fileTransactionLogWriter = new FileTransactionLogWriter(string);
        if (fileTransactionLogWriter.playBackRequired()) {
            Iterator iterator = fileTransactionLogWriter.iterator();
            n = 0;
            while (iterator.hasNext()) {
                Object e = iterator.next();
                System.out.println(e.toString());
                ++n;
            }
        } else {
            System.out.println("*** No playback is required.");
        }
        System.out.println("*** Read Txn log file: " + string + ", nrec: " + n);
    }
}

