/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging;

import com.sun.messaging.InvalidPropertyException;
import com.sun.messaging.InvalidPropertyValueException;
import com.sun.messaging.PropertyOwner;
import com.sun.messaging.ReadOnlyPropertyException;
import com.sun.messaging.jmq.jmsclient.resources.ClientResources;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import javax.jms.JMSException;

public abstract class AdministeredObject
implements Serializable {
    public static final String VERSION = "3.0";
    public static final String AO_PROPERTY_TYPE_STRING = "java.lang.String";
    public static final String AO_PROPERTY_TYPE_INTEGER = "java.lang.Integer";
    public static final String AO_PROPERTY_TYPE_LONG = "java.lang.Long";
    public static final String AO_PROPERTY_TYPE_BOOLEAN = "java.lang.Boolean";
    public static final String AO_PROPERTY_TYPE_PROPERTYOWNER = "com.sun.messaging.PropertyOwner";
    public static final String AO_PROPERTY_TYPE_LIST = "List";
    private boolean readOnly;
    public String storedVersion;
    protected Properties configuration;
    protected Properties configurationTypes;
    protected Properties configurationLabels;
    private static final String AO_TYPES = "_types";
    private static final String AO_LABELS = "_labels";
    private static final String AO_DEFAULTS = "_defaults";
    private static final String AO_PROP_EXT = ".properties";
    private static final String AO_PROPERTY_LIST_PROPERTY = ".property";
    private static final String AO_PROPERTY_LIST_SEPARATOR = "|";
    private static final String AO_PROPERTY_LIST_VALUES = ".List";
    private static final String AO_PROPERTY_LIST_OTHER_NAME = ".....property";
    private static final String AO_PROPERTY_ADMIN_GROUPLIST = "GroupList";
    private static final String AO_PROPERTY_ADMIN_GROUP = "Group.";
    private static final String AO_PROPERTY_ADMIN_GROUPLABEL = ".Label";
    public static final transient ClientResources cr = ClientResources.getResources();
    private static transient Hashtable deprecatedSysProperties = new Hashtable(6);
    private static transient Hashtable deprecatedProperties = new Hashtable(6);
    protected static final Map<String, Properties[]> cachedConfigurationMap;

    private AdministeredObject() {
    }

    public AdministeredObject(String string) {
        this.initialiseConfiguration(string);
        this.readOnly = false;
        this.storedVersion = VERSION;
        this.initOwnedProperties();
    }

    private void initialiseConfiguration(String string) {
        Properties[] propertiesArray = cachedConfigurationMap.get(string);
        if (propertiesArray == null) {
            try {
                InputStream inputStream = this.getClass().getResourceAsStream(string + AO_DEFAULTS + AO_PROP_EXT);
                InputStream inputStream2 = this.getClass().getResourceAsStream(string + AO_TYPES + AO_PROP_EXT);
                InputStream inputStream3 = this.getClass().getResourceAsStream(string + AO_LABELS + AO_PROP_EXT);
                if (inputStream != null && inputStream2 != null && inputStream3 != null) {
                    this.configuration = new Properties();
                    this.configuration.load(inputStream);
                    inputStream.close();
                    this.configurationTypes = new Properties();
                    this.configurationTypes.load(inputStream2);
                    inputStream2.close();
                    this.configurationLabels = new Properties();
                    this.configurationLabels.load(inputStream3);
                } else {
                    this.setDefaultConfiguration();
                }
            }
            catch (Exception exception) {
                this.setDefaultConfiguration();
            }
            propertiesArray = new Properties[]{(Properties)this.configuration.clone(), (Properties)this.configurationTypes.clone(), (Properties)this.configurationLabels.clone()};
            cachedConfigurationMap.put(string, propertiesArray);
        } else {
            this.configuration = (Properties)propertiesArray[0].clone();
            this.configurationTypes = (Properties)propertiesArray[1].clone();
            this.configurationLabels = (Properties)propertiesArray[2].clone();
        }
    }

    public abstract void setDefaultConfiguration();

    public final boolean isReadOnly() {
        return this.readOnly;
    }

    public final String getStoredVersion() {
        return this.storedVersion;
    }

    public final boolean isStoredVersionCompatible() {
        return VERSION.equals(this.storedVersion);
    }

    public final void setReadOnly() {
        this.readOnly = true;
    }

    public Properties getConfiguration() {
        return this.configuration;
    }

    public String getPropertyGroups() {
        return (String)this.configurationTypes.get(AO_PROPERTY_ADMIN_GROUPLIST);
    }

    public String getPropertiesForGroup(String string) {
        return (String)this.configurationTypes.get(AO_PROPERTY_ADMIN_GROUP + string);
    }

    public String getLabelForGroup(String string) {
        String string2 = "";
        try {
            string2 = (String)this.configurationTypes.get(AO_PROPERTY_ADMIN_GROUP + string + AO_PROPERTY_ADMIN_GROUPLABEL);
            string2 = cr.getString(string2);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return string2;
    }

    public String getPropertyListValues(String string) {
        return (String)this.configurationTypes.get(string + AO_PROPERTY_LIST_VALUES);
    }

    public String getPropertyForListValue(String string, String string2) {
        return (String)this.configurationTypes.get(string + "." + string2 + AO_PROPERTY_LIST_PROPERTY);
    }

    public String getPropertyValueForListValue(String string, String string2, String string3) {
        return (String)this.configurationTypes.get(string + "." + string2 + "." + string3);
    }

    public String getPropertyListOtherName(String string) {
        return (String)this.configurationTypes.get(string + AO_PROPERTY_LIST_OTHER_NAME);
    }

    public Enumeration enumeratePropertyNames() {
        return this.configuration.keys();
    }

    public String setProperty(String string, String string2) throws JMSException {
        if (!this.readOnly) {
            if (string == null) {
                throw new InvalidPropertyException(string);
            }
            if (string.length() > 3 && string.startsWith("JMQ")) {
                string = "imq" + string.substring(3);
            }
            if (deprecatedProperties.containsKey(string)) {
                string = (String)deprecatedProperties.get(string);
            }
            if (!this.configuration.containsKey(string)) {
                throw new InvalidPropertyException(string);
            }
            if ("imqConnectionType".equals(string) && "SSL".equals(string2)) {
                string2 = "TLS";
            }
            if ("imqJMSDeliveryMode".equals(string)) {
                if ("1".equals(string2)) {
                    string2 = "NON_PERSISTENT";
                }
                if ("2".equals(string2)) {
                    string2 = "PERSISTENT";
                }
            }
            if (this.isPropertyValid(string, string2, this.configurationTypes)) {
                String string3 = (String)this.configuration.put(string, string2);
                String string4 = this.getPropertyType(string);
                if (AO_PROPERTY_TYPE_LIST.equals(string4)) {
                    String string5 = this.getPropertyForListValue(string, string2);
                    String string6 = this.getPropertyType(string5);
                    String string7 = this.getPropertyValueForListValue(string, string2, string5);
                    this.configuration.put(string5, string7);
                    if (AO_PROPERTY_TYPE_PROPERTYOWNER.equals(string6)) {
                        this.addOwnedProperties(string7);
                    }
                } else if (AO_PROPERTY_TYPE_PROPERTYOWNER.equals(string4)) {
                    this.addOwnedProperties(string2);
                }
                return string3;
            }
            throw new InvalidPropertyValueException(string, string2);
        }
        throw new ReadOnlyPropertyException(string);
    }

    public String getProperty(String string) throws JMSException {
        String string2;
        if (string == null) {
            throw new InvalidPropertyException(string);
        }
        if (string.length() > 3 && string.startsWith("JMQ")) {
            string = "imq" + string.substring(3);
        }
        if (deprecatedProperties.containsKey(string)) {
            string = (String)deprecatedProperties.get(string);
        }
        if ((string2 = (String)this.configuration.get(string)) == null) {
            throw new InvalidPropertyException(string);
        }
        return string2;
    }

    public String getPropertyType(String string) throws JMSException {
        if (string != null && string.length() > 3 && string.startsWith("JMQ")) {
            string = "imq" + string.substring(3);
        }
        if (!this.configuration.containsKey(string)) {
            throw new InvalidPropertyException(string);
        }
        return (String)this.configurationTypes.get(string);
    }

    public String getPropertyLabel(String string) throws JMSException {
        if (string != null && string.length() > 3 && string.startsWith("JMQ")) {
            string = "imq" + string.substring(3);
        }
        if (!this.configuration.containsKey(string)) {
            throw new InvalidPropertyException(string);
        }
        String string2 = "";
        try {
            string2 = (String)this.configurationLabels.get(string);
            string2 = cr.getString(string2);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return string2;
    }

    public boolean isPropertyHidden(String string) throws JMSException {
        if (string != null && string.length() > 3 && string.startsWith("JMQ")) {
            string = "imq" + string.substring(3);
        }
        if (!this.configuration.containsKey(string)) {
            throw new InvalidPropertyException(string);
        }
        return this.configurationTypes.containsKey(string + ".hidden");
    }

    public boolean isPropertyDeprecated(String string) throws JMSException {
        if (string != null && string.length() > 3 && string.startsWith("JMQ")) {
            string = "imq" + string.substring(3);
        }
        if (!this.configuration.containsKey(string)) {
            throw new InvalidPropertyException(string);
        }
        return this.configurationTypes.containsKey(string + ".deprecated");
    }

    public String toString() {
        return "\nClass:\t\t\t" + this.getClass().getName() + "\ngetVERSION():\t\t" + VERSION + "\nisReadonly():\t\t" + this.readOnly + "\ngetProperties():\t" + this.configuration.toString();
    }

    public String dump() {
        return this.toString() + "\n\ngetLabels():\t" + this.configurationLabels.toString() + "\n\ngetTypes():\t" + this.configurationTypes.toString();
    }

    public static final String getVERSION() {
        return VERSION;
    }

    public Properties getCurrentConfiguration() {
        Properties properties = null;
        boolean bl = false;
        if (this.readOnly) {
            return this.configuration;
        }
        Enumeration<Object> enumeration = this.configuration.keys();
        while (enumeration.hasMoreElements()) {
            String string;
            Object object;
            Object object2;
            Object object3;
            Object object4 = (String)enumeration.nextElement();
            Object object5 = this._sysPropVal((String)object4);
            if (object5 == null) continue;
            if (!bl) {
                try {
                    properties = (Properties)this.configuration.clone();
                    bl = true;
                }
                catch (Exception exception) {
                    return this.configuration;
                }
            }
            if (AO_PROPERTY_TYPE_LIST.equals((String)this.configurationTypes.get(object4)) && this.isListPropertyValid((String)object4, (String)object5, this.configurationTypes)) {
                properties.put(object4, object5);
                object3 = (String)this.configurationTypes.get((String)object4 + "." + (String)object5 + AO_PROPERTY_LIST_PROPERTY);
                object2 = (String)this.configurationTypes.get((String)object4 + "." + (String)object5 + "." + (String)object3);
                object = System.getProperty((String)object3);
                string = (String)this.configurationTypes.get(object3);
                object4 = object3;
                Object object6 = object5 = object != null ? object : object2;
            }
            if (!this.isPropertyValid((String)object4, (String)object5, this.configurationTypes)) continue;
            properties.put(object4, object5);
            if (!AO_PROPERTY_TYPE_PROPERTYOWNER.equals((String)this.configurationTypes.get(object4))) continue;
            try {
                object3 = (PropertyOwner)Class.forName((String)object5).newInstance();
                object2 = object3.getPropertyNames();
                for (int i = 0; i < ((String[])object2).length; ++i) {
                    String string2;
                    object = object2[i];
                    string = object3.getPropertyDefault((String)object);
                    String string3 = object3.getPropertyType((String)object);
                    String string4 = object3.getPropertyLabel((String)object);
                    if (object == null || string == null || string3 == null || string4 == null) continue;
                    if (!this.configurationTypes.containsKey(object)) {
                        this.configurationTypes.put(object, string3);
                    }
                    if (!this.configurationLabels.containsKey(object)) {
                        this.configurationLabels.put(object, string4);
                    }
                    if ((string2 = System.getProperty((String)object)) != null && this.isPropertyValid((String)object, string2, this.configurationTypes)) {
                        properties.put(object, string2);
                    }
                    if (this.configuration.containsKey(object)) continue;
                    this.configuration.put(object, string);
                }
            }
            catch (Exception exception) {
                properties = null;
            }
        }
        return properties == null ? this.configuration : properties;
    }

    private String _sysPropVal(String string) {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (string != null) {
            string3 = (String)deprecatedSysProperties.get(string);
            if (string3 != null && !string3.equals("")) {
                string2 = System.getProperty(string3);
            }
            if ((string4 = System.getProperty(string)) != null && !string4.equals("")) {
                string2 = string4;
            }
        }
        return string2;
    }

    private void initOwnedProperties() {
        Enumeration<Object> enumeration = this.configuration.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            try {
                String string2 = this.getPropertyType(string);
                if (!AO_PROPERTY_TYPE_PROPERTYOWNER.equals(string2)) continue;
                PropertyOwner propertyOwner = (PropertyOwner)Class.forName(this.getProperty(string)).newInstance();
                String[] stringArray = propertyOwner.getPropertyNames();
                for (int i = 0; i < stringArray.length; ++i) {
                    String string3 = stringArray[i];
                    String string4 = propertyOwner.getPropertyDefault(string3);
                    String string5 = propertyOwner.getPropertyType(string3);
                    String string6 = propertyOwner.getPropertyLabel(string3);
                    if (string3 == null || string4 == null || string5 == null || string6 == null) continue;
                    this.configuration.put(string3, string4);
                    this.configurationTypes.put(string3, string5);
                    this.configurationLabels.put(string3, string6);
                }
            }
            catch (Exception exception) {
            }
        }
    }

    private boolean isPropertyValid(String string, String string2, Properties properties) {
        block13: {
            String string3 = (String)properties.get(string);
            if (AO_PROPERTY_TYPE_LIST.equals(string3)) {
                return this.isListPropertyValid(string, string2, properties);
            }
            try {
                if (AO_PROPERTY_TYPE_PROPERTYOWNER.equals(string3)) {
                    Class<?> clazz = Class.forName(string2);
                    Class<?>[] classArray = clazz.getInterfaces();
                    for (int i = 0; i < classArray.length; ++i) {
                        if (classArray[i] != PropertyOwner.class) continue;
                        return true;
                    }
                    break block13;
                }
                if (AO_PROPERTY_TYPE_INTEGER.equals(string3)) {
                    Integer n = new Integer(string2);
                    return true;
                }
                if (AO_PROPERTY_TYPE_LONG.equals(string3)) {
                    Long l = new Long(string2);
                    return true;
                }
                if (AO_PROPERTY_TYPE_BOOLEAN.equals(string3)) {
                    Boolean bl = Boolean.valueOf(string2);
                    return true;
                }
                if (!AO_PROPERTY_TYPE_STRING.equals(string3)) break block13;
                try {
                    Method method = this.getClass().getMethod("validate_" + string, Class.forName(string3));
                    return (Boolean)method.invoke((Object)this, string2) != false;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return false;
                }
                catch (InvocationTargetException invocationTargetException) {
                    return false;
                }
                catch (NullPointerException nullPointerException) {
                    return false;
                }
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean isListPropertyValid(String string, String string2, Properties properties) {
        if (string2.indexOf(AO_PROPERTY_LIST_SEPARATOR) != -1) {
            return false;
        }
        String string3 = (String)properties.get(string + AO_PROPERTY_LIST_VALUES);
        return string3 != null && string3.indexOf(string2, 0) != -1;
    }

    private void addOwnedProperties(String string) {
        try {
            PropertyOwner propertyOwner = (PropertyOwner)Class.forName(string).newInstance();
            String[] stringArray = propertyOwner.getPropertyNames();
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                String string3 = propertyOwner.getPropertyDefault(string2);
                String string4 = propertyOwner.getPropertyType(string2);
                String string5 = propertyOwner.getPropertyLabel(string2);
                if (string2 == null || string3 == null || string4 == null || string5 == null) continue;
                this.configurationTypes.put(string2, string4);
                this.configurationLabels.put(string2, string5);
                if (this.configuration.containsKey(string2)) continue;
                this.configuration.put(string2, string3);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        deprecatedSysProperties.put("imqReconnectEnabled", "imqReconnect");
        deprecatedSysProperties.put("imqReconnectAttempts", "imqReconnectRetries");
        deprecatedSysProperties.put("imqReconnectInterval", "imqReconnectDelay");
        deprecatedSysProperties.put("imqConnectionFlowCount", "imqFlowControlCount");
        deprecatedSysProperties.put("imqConnectionFlowLimitEnabled", "imqFlowControlIsLimited");
        deprecatedSysProperties.put("imqConnectionFlowLimit", "imqFlowControlLimit");
        deprecatedProperties.put("imqReconnect", "imqReconnectEnabled");
        deprecatedProperties.put("imqReconnectRetries", "imqReconnectAttempts");
        deprecatedProperties.put("imqReconnectDelay", "imqReconnectInterval");
        deprecatedProperties.put("imqFlowControlCount", "imqConnectionFlowCount");
        deprecatedProperties.put("imqFlowControlIsLimited", "imqConnectionFlowLimitEnabled");
        deprecatedProperties.put("imqFlowControlLimit", "imqConnectionFlowLimit");
        cachedConfigurationMap = Collections.synchronizedMap(new HashMap());
    }
}

