/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.auth;

import com.sun.messaging.jmq.auth.api.FailedLoginException;
import com.sun.messaging.jmq.auth.api.server.AccessControlContext;
import com.sun.messaging.jmq.auth.api.server.AuthenticationProtocolHandler;
import com.sun.messaging.jmq.auth.api.server.model.UserRepository;
import com.sun.messaging.jmq.auth.jaas.MQUser;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.auth.JMQAccessControlContext;
import com.sun.messaging.jmq.util.MD5;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import javax.security.auth.Refreshable;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;

public class JMQDigestAuthenticationHandler
implements AuthenticationProtocolHandler {
    private String nonce = null;
    private AccessControlContext acc = null;
    private Properties authProps;
    private Refreshable cacheData = null;
    private boolean cacheDataMaystaled;

    public String getType() {
        return "digest";
    }

    public byte[] init(int n, Properties properties, Refreshable refreshable) throws LoginException {
        this.authProps = properties;
        String string = this.authProps.getProperty("imq.clientIP");
        long l = System.currentTimeMillis();
        String string2 = this.authProps.getProperty("imq.connectionID");
        this.nonce = MD5.getHashString(string + ":" + l + string2);
        try {
            return this.nonce.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new LoginException(unsupportedEncodingException.getMessage());
        }
    }

    public byte[] handleResponse(byte[] byArray, int n) throws LoginException {
        Subject subject = null;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            String string = dataInputStream.readUTF();
            String string2 = dataInputStream.readUTF();
            dataInputStream.close();
            String string3 = this.authProps.getProperty("imq.authentication." + this.getType() + ".user_repository");
            if (string3 == null || string3.trim().equals("")) {
                throw new LoginException(Globals.getBrokerResources().getKString("B4041", this.getType()));
            }
            String string4 = this.authProps.getProperty("imq.user_repository." + string3 + ".class");
            if (string4 == null) {
                throw new LoginException(Globals.getBrokerResources().getKString("B4042", string3, this.getType()));
            }
            UserRepository userRepository = (UserRepository)Class.forName(string4).newInstance();
            userRepository.open(this.getType(), this.authProps, this.cacheData);
            subject = userRepository.findMatch(string, string2, this.nonce, this.getMatchType());
            this.cacheData = userRepository.getCacheData();
            userRepository.close();
            userRepository = null;
            if (subject == null) {
                FailedLoginException failedLoginException = new FailedLoginException(Globals.getBrokerResources().getKString("B4051", string));
                failedLoginException.setUser(string);
                throw failedLoginException;
            }
            this.acc = new JMQAccessControlContext(new MQUser(string), subject, this.authProps);
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new LoginException(Globals.getBrokerResources().getString("B4117", "ClassNotFoundException: " + classNotFoundException.getMessage()));
        }
        catch (IOException iOException) {
            throw new LoginException(Globals.getBrokerResources().getString("B4117", "IOException: " + iOException.getMessage()));
        }
        catch (InstantiationException instantiationException) {
            throw new LoginException(Globals.getBrokerResources().getString("B4117", "InstantiationException: " + instantiationException.getMessage()));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new LoginException(Globals.getBrokerResources().getString("B4117", "IllegalAccessException: " + illegalAccessException.getMessage()));
        }
        catch (ClassCastException classCastException) {
            throw new LoginException(Globals.getBrokerResources().getString("B4117", "cLassCastException: " + classCastException.getMessage()));
        }
    }

    public void logout() {
    }

    public AccessControlContext getAccessControlContext() {
        return this.acc;
    }

    public Refreshable getCacheData() {
        return this.cacheData;
    }

    public String getMatchType() {
        return this.getType();
    }
}

