/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.cluster.ha;

import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.ClusterManager;
import com.sun.messaging.jmq.jmsserver.cluster.ClusterManagerImpl;
import com.sun.messaging.jmq.jmsserver.cluster.ClusteredBroker;
import com.sun.messaging.jmq.jmsserver.cluster.ha.RepHAClusteredBrokerImpl;
import com.sun.messaging.jmq.jmsserver.multibroker.BrokerInfo;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.StoreManager;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.UID;
import java.util.Map;

public class RepHAClusterManagerImpl
extends ClusterManagerImpl
implements ClusterManager {
    private String localBrokerId = null;
    private UID localStoreSessionUID = null;

    public boolean isHA() {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        return false;
    }

    public void reloadConfig() throws BrokerException {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        String[] stringArray = new String[]{"imq.cluster.url"};
        this.config.reloadProps(Globals.getConfigName(), stringArray, false);
    }

    public String initialize(MQAddress mQAddress) throws BrokerException {
        this.logger.log(4, "initializingCluster at " + mQAddress);
        String string = this.config.getProperty("imq.cluster.masterbroker");
        if (string != null) {
            this.logger.log(16, Globals.getBrokerResources().getKString("B2194", "imq.cluster.masterbroker=" + string));
        }
        if (!StoreManager.isConfiguredBDBStore()) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B3221", "bdb"));
        }
        return super.initialize(mQAddress);
    }

    protected ClusteredBroker newClusteredBroker(MQAddress mQAddress, boolean bl, UID uID) throws BrokerException {
        RepHAClusteredBrokerImpl repHAClusteredBrokerImpl = new RepHAClusteredBrokerImpl(this, mQAddress, bl, uID);
        return repHAClusteredBrokerImpl;
    }

    public String getStoreSessionCreator(UID uID) {
        return null;
    }

    protected ClusteredBroker updateBrokerOnActivation(ClusteredBroker clusteredBroker, Object object) {
        ((RepHAClusteredBrokerImpl)clusteredBroker).setStoreSessionUID(((BrokerInfo)object).getBrokerAddr().getStoreSessionUID());
        return clusteredBroker;
    }

    protected ClusteredBroker updateBrokerOnDeactivation(ClusteredBroker clusteredBroker, Object object) {
        return clusteredBroker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusteredBroker getBrokerByNodeName(String string) throws BrokerException {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        RepHAClusteredBrokerImpl repHAClusteredBrokerImpl2 = null;
        Map map = this.allBrokers;
        synchronized (map) {
            for (RepHAClusteredBrokerImpl repHAClusteredBrokerImpl2 : this.allBrokers.values()) {
                String string2 = repHAClusteredBrokerImpl2.getInstanceName();
                UID uID = repHAClusteredBrokerImpl2.getStoreSessionUID();
                if (string2 == null || uID == null || !Store.makeReplicationNodeName(string2, uID).equals(string)) continue;
                return repHAClusteredBrokerImpl2;
            }
        }
        return null;
    }

    public UID getStoreSessionUID() {
        if (this.localStoreSessionUID == null) {
            this.localStoreSessionUID = ((RepHAClusteredBrokerImpl)this.getLocalBroker()).getStoreSessionUID();
        }
        return this.localStoreSessionUID;
    }
}

