/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.bdb;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.serial.ClassCatalog;
import com.sleepycat.bind.serial.SerialBinding;
import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.bdb.BDBStore;
import com.sun.messaging.jmq.jmsserver.persist.bdb.ConsumerUIDTupleBinding;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.DestinationNotFoundException;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.ArrayList;
import java.util.Hashtable;

class InterestStore {
    Logger logger = Globals.getLogger();
    BrokerResources br = Globals.getBrokerResources();
    private BDBStore parent = null;
    private Database db = null;
    private TupleBinding keyBinding = null;
    private EntryBinding dataBinding = null;

    protected InterestStore(BDBStore bDBStore) {
        this.parent = bDBStore;
        this.db = bDBStore.getIntDatabase();
        this.keyBinding = new ConsumerUIDTupleBinding();
        this.dataBinding = new SerialBinding((ClassCatalog)bDBStore.getClassCatalog(), Consumer.class);
    }

    protected Hashtable getDebugState() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("dbCount", String.valueOf(this.db.count()));
        hashtable.put("dbConfig", String.valueOf(this.db.getConfig()));
        return hashtable;
    }

    protected void storeInterest(Transaction transaction, Consumer consumer) throws BrokerException {
        ConsumerUID consumerUID = consumer.getConsumerUID();
        try {
            DatabaseEntry databaseEntry = new DatabaseEntry();
            this.keyBinding.objectToEntry((Object)consumerUID, databaseEntry);
            DatabaseEntry databaseEntry2 = new DatabaseEntry();
            this.dataBinding.objectToEntry((Object)consumer, databaseEntry2);
            OperationStatus operationStatus = this.db.putNoOverwrite(transaction, databaseEntry, databaseEntry2);
            if (operationStatus == OperationStatus.KEYEXIST) {
                String string = this.br.getKString("B3010", consumerUID, consumer.getDestinationUID().getLongString());
                this.logger.log(32, string);
                throw new BrokerException(string);
            }
        }
        catch (Exception exception) {
            String string = this.br.getKString("B4012", consumerUID);
            this.logger.log(32, string);
            throw new BrokerException(string, exception);
        }
    }

    protected void removeInterest(Transaction transaction, Consumer consumer) throws BrokerException {
        ConsumerUID consumerUID = consumer.getConsumerUID();
        boolean bl = false;
        try {
            DatabaseEntry databaseEntry = new DatabaseEntry();
            this.keyBinding.objectToEntry((Object)consumerUID, databaseEntry);
            OperationStatus operationStatus = this.db.delete(transaction, databaseEntry);
            if (operationStatus == OperationStatus.NOTFOUND) {
                String string = this.br.getKString("B3011", consumerUID, consumer.getDestinationUID().getLongString());
                this.logger.log(32, string);
                bl = true;
                throw new DestinationNotFoundException(string);
            }
        }
        catch (Exception exception) {
            if (exception instanceof DestinationNotFoundException && bl) {
                throw (DestinationNotFoundException)exception;
            }
            String string = this.br.getKString("B4034", consumerUID);
            this.logger.log(32, string);
            throw new BrokerException(string, exception);
        }
    }

    protected Consumer[] getAllInterests(Transaction transaction) throws BrokerException {
        ArrayList<Consumer> arrayList = new ArrayList<Consumer>();
        Cursor cursor = null;
        try {
            DatabaseEntry databaseEntry = new DatabaseEntry();
            DatabaseEntry databaseEntry2 = new DatabaseEntry();
            ConsumerUID consumerUID = null;
            cursor = this.db.openCursor(transaction, null);
            while (cursor.getNext(databaseEntry, databaseEntry2, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                consumerUID = (ConsumerUID)this.keyBinding.entryToObject(databaseEntry);
                arrayList.add((Consumer)this.dataBinding.entryToObject(databaseEntry2));
            }
            cursor.close();
            Consumer[] consumerArray = arrayList.toArray(new Consumer[0]);
            return consumerArray;
        }
        catch (Exception exception) {
            String string = this.br.getKString("B4035");
            this.logger.log(32, string);
            throw new BrokerException(string, exception);
        }
        finally {
            if (cursor != null) {
                try {
                    cursor.close();
                }
                catch (Exception exception) {
                    this.logger.log(16, "Failed to close cursor in getting all interests from database: " + exception.getMessage());
                }
            }
        }
    }

    protected void clearAll(Transaction transaction) throws BrokerException {
        Cursor cursor = null;
        try {
            DatabaseEntry databaseEntry = new DatabaseEntry();
            DatabaseEntry databaseEntry2 = new DatabaseEntry();
            cursor = this.db.openCursor(transaction, null);
            while (cursor.getNext(databaseEntry, databaseEntry2, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                cursor.delete();
            }
            cursor.close();
        }
        catch (Exception exception) {
            String string = "Failed to clear all interests in store";
            this.logger.logStack(32, string, exception);
            throw new BrokerException(string, exception);
        }
        finally {
            if (cursor != null) {
                try {
                    cursor.close();
                }
                catch (Exception exception) {
                    this.logger.log(16, "Failed to close cursor in clearing all interests from store: " + exception.getMessage());
                }
            }
        }
    }

    protected void close() {
        if (Store.getDEBUG()) {
            this.logger.log(8, "InterestStore: closing with " + this.db.count() + " interests");
        }
    }
}

