/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.bdb;

import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.Transaction;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;

public class Util {

    public static class RetryStrategy {
        private Logger logger = null;
        private BrokerException originalEx = null;
        private int retryMax = 0;
        private long delayTime = 0L;
        private int retryCount = 0;
        private Transaction txn = null;
        private Transaction reptxn = null;
        private String op = null;
        private Store store = null;

        public RetryStrategy(Transaction transaction, int n, Logger logger, String string, Store store) throws BrokerException {
            this(transaction, null, n, logger, string, store);
        }

        public RetryStrategy(Transaction transaction, Transaction transaction2, int n, Logger logger, String string, Store store) throws BrokerException {
            this.txn = transaction;
            this.reptxn = transaction2;
            this.retryMax = n;
            this.logger = logger;
            this.op = string;
            this.store = store;
        }

        public void assertShouldRetry(Throwable throwable) throws BrokerException {
            if (!(throwable instanceof BrokerException)) {
                throw new BrokerException(throwable.toString(), throwable);
            }
            if (this.originalEx == null) {
                this.originalEx = (BrokerException)throwable;
            }
            Throwable throwable2 = throwable.getCause();
            boolean bl = false;
            if (throwable2 instanceof LockConflictException) {
                if (this.txn != null) {
                    try {
                        this.txn.abort();
                    }
                    catch (Exception exception) {
                        this.logger.log(16, "XXX Failed to abort transaction " + this.txn + " after " + throwable + ": " + exception.getMessage());
                        throw this.originalEx;
                    }
                }
                if (this.reptxn != null) {
                    try {
                        this.reptxn.abort();
                    }
                    catch (Exception exception) {
                        this.logger.log(16, "XXX Failed to abort replica transaction " + this.reptxn + " after " + throwable + ": " + exception.getMessage());
                        throw this.originalEx;
                    }
                }
                ++this.retryCount;
                if (this.retryCount >= this.retryMax) {
                    this.logger.log(16, "XXX Maximum retries (" + this.retryMax + ") reached after " + this.originalEx);
                    throw this.originalEx;
                }
                if (this.store.closed()) {
                    throw this.originalEx;
                }
                if (Store.getDEBUG()) {
                    this.logger.log(8, "Retry (" + this.retryCount + ", " + this.retryMax + ") " + this.op + " after " + this.originalEx);
                }
                return;
            }
            if (this.txn != null) {
                try {
                    this.txn.abort();
                }
                catch (Exception exception) {
                    this.logger.log(16, "XXX Failed to abort transaction " + this.txn + " after " + throwable + ": " + exception.getMessage());
                    throw this.originalEx;
                }
            }
            if (this.reptxn != null) {
                try {
                    this.reptxn.abort();
                }
                catch (Exception exception) {
                    this.logger.log(16, "XXX Failed to abort replica transaction " + this.reptxn + " after " + throwable + ": " + exception.getMessage());
                    throw this.originalEx;
                }
            }
            throw this.originalEx;
        }
    }
}

