/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterTakeoverMEInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterTakeoverMEPrepareInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.GPacketHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ProtocolGlobals;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.RaptorProtocol;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;

public class TakeoverMEHandler
extends GPacketHandler {
    private static boolean DEBUG = false;

    public TakeoverMEHandler(RaptorProtocol raptorProtocol) {
        super(raptorProtocol);
    }

    public void handle(BrokerAddress brokerAddress, GPacket gPacket) {
        if (DEBUG) {
            this.logger.log(4, "TakeoverMEHandler");
        }
        if (gPacket.getType() == 57) {
            this.handleTakeoverMEPrepare(brokerAddress, gPacket);
        } else if (gPacket.getType() == 58) {
            this.handleTakeoverMEPrepareReply(brokerAddress, gPacket);
        } else if (gPacket.getType() == 59) {
            this.handleTakeoverME(brokerAddress, gPacket);
        } else if (gPacket.getType() == 60) {
            this.handleTakeoverMEReply(brokerAddress, gPacket);
        } else {
            this.logger.log(16, "TakeoverMEHandler Internal error : Cannot handle this packet :" + gPacket.toLongString());
        }
    }

    private void handleTakeoverMEPrepare(BrokerAddress brokerAddress, GPacket gPacket) {
        ClusterTakeoverMEPrepareInfo clusterTakeoverMEPrepareInfo = ClusterTakeoverMEPrepareInfo.newInstance(gPacket, this.c);
        try {
            this.p.receivedTakeoverMEPrepare(brokerAddress, gPacket, clusterTakeoverMEPrepareInfo);
        }
        catch (Exception exception) {
            int n = 500;
            String string = exception.getMessage();
            if (!(exception instanceof BrokerException)) {
                Object[] objectArray = new String[]{ProtocolGlobals.getPacketTypeDisplayString(gPacket.getType()), brokerAddress.toString(), exception.toString()};
                string = this.br.getKString("B3269", objectArray);
                this.logger.log(32, string);
            }
            clusterTakeoverMEPrepareInfo.sendReply(brokerAddress, n, string, null);
        }
    }

    private void handleTakeoverME(BrokerAddress brokerAddress, GPacket gPacket) {
        ClusterTakeoverMEInfo clusterTakeoverMEInfo = ClusterTakeoverMEInfo.newInstance(gPacket, this.c);
        try {
            this.p.receivedTakeoverME(brokerAddress, gPacket, clusterTakeoverMEInfo);
        }
        catch (Exception exception) {
            int n = 500;
            String string = exception.getMessage();
            if (!(exception instanceof BrokerException)) {
                Object[] objectArray = new String[]{ProtocolGlobals.getPacketTypeDisplayString(gPacket.getType()), brokerAddress.toString(), exception.toString()};
                string = this.br.getKString("B3269", objectArray);
                this.logger.log(32, string);
            }
            clusterTakeoverMEInfo.sendReply(brokerAddress, n, string, null);
        }
    }

    private void handleTakeoverMEPrepareReply(BrokerAddress brokerAddress, GPacket gPacket) {
        this.p.receivedTakeoverMEPrepareReply(brokerAddress, gPacket);
    }

    private void handleTakeoverMEReply(BrokerAddress brokerAddress, GPacket gPacket) {
        this.p.receivedTakeoverMEReply(brokerAddress, gPacket);
    }
}

