/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.bdb;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import com.sun.messaging.jmq.io.MQObjectInputStream;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.bdb.BDBStore;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;

class PropertiesStore {
    Logger logger = Globals.getLogger();
    BrokerResources br = Globals.getBrokerResources();
    private BDBStore parent = null;
    private Database db = null;

    protected PropertiesStore(BDBStore bDBStore) {
        this.parent = bDBStore;
        this.db = bDBStore.getPropDatabase();
    }

    protected void updateProperty(Transaction transaction, String string, Object object) throws BrokerException {
        try {
            DatabaseEntry databaseEntry = new DatabaseEntry(string.getBytes("UTF-8"));
            if (object == null) {
                OperationStatus operationStatus = this.db.delete(transaction, databaseEntry);
                if (operationStatus == OperationStatus.NOTFOUND) {
                    String string2 = "XXX property " + string + " not found in store";
                    this.logger.log(16, string2);
                }
                return;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            DatabaseEntry databaseEntry2 = new DatabaseEntry(byArray);
            this.db.put(transaction, databaseEntry, databaseEntry2);
        }
        catch (Exception exception) {
            String string3 = this.br.getKString("B4112", string);
            this.logger.logStack(32, string3, exception);
            throw new BrokerException(string3, exception);
        }
    }

    protected Object getProperty(Transaction transaction, String string) throws BrokerException {
        try {
            DatabaseEntry databaseEntry = new DatabaseEntry(string.getBytes("UTF-8"));
            DatabaseEntry databaseEntry2 = new DatabaseEntry();
            OperationStatus operationStatus = this.db.get(transaction, databaseEntry, databaseEntry2, null);
            if (operationStatus == OperationStatus.NOTFOUND) {
                return null;
            }
            byte[] byArray = databaseEntry2.getData();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(databaseEntry2.getData());
            MQObjectInputStream mQObjectInputStream = new MQObjectInputStream(byteArrayInputStream);
            Object object = mQObjectInputStream.readObject();
            mQObjectInputStream.close();
            byteArrayInputStream.close();
            return object;
        }
        catch (Exception exception) {
            String string2 = this.br.getKString("B4231", string);
            this.logger.logStack(32, string2, exception);
            throw new BrokerException(string2, exception);
        }
    }

    protected String[] getPropertyNames(Transaction transaction) throws BrokerException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Cursor cursor = null;
        try {
            DatabaseEntry databaseEntry = new DatabaseEntry();
            DatabaseEntry databaseEntry2 = new DatabaseEntry();
            databaseEntry2.setPartial(0, 0, true);
            String string = null;
            cursor = this.db.openCursor(transaction, null);
            while (cursor.getNext(databaseEntry, databaseEntry2, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                string = new String(databaseEntry.getData(), "UTF-8");
                arrayList.add(string);
            }
            cursor.close();
            String[] stringArray = arrayList.toArray(new String[0]);
            return stringArray;
        }
        catch (Exception exception) {
            String string = this.br.getKString("B4113");
            this.logger.log(32, string);
            throw new BrokerException(string, exception);
        }
        finally {
            if (cursor != null) {
                try {
                    cursor.close();
                }
                catch (Exception exception) {
                    this.logger.log(16, "Failed to close cursor in getting all property names from store: " + exception.getMessage());
                }
            }
        }
    }

    protected Properties getProperties(Transaction transaction) throws BrokerException {
        Properties properties = new Properties();
        Cursor cursor = null;
        try {
            Object object;
            DatabaseEntry databaseEntry = new DatabaseEntry();
            DatabaseEntry databaseEntry2 = new DatabaseEntry();
            String string = null;
            Object object2 = null;
            cursor = this.db.openCursor(transaction, null);
            while (cursor.getNext(databaseEntry, databaseEntry2, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                string = new String(databaseEntry.getData(), "UTF-8");
                object = new ByteArrayInputStream(databaseEntry2.getData());
                MQObjectInputStream mQObjectInputStream = new MQObjectInputStream((InputStream)object);
                object2 = mQObjectInputStream.readObject();
                mQObjectInputStream.close();
                ((ByteArrayInputStream)object).close();
                properties.put(string, object2);
            }
            cursor.close();
            object = properties;
            return object;
        }
        catch (Exception exception) {
            String string = this.br.getKString("B4113");
            this.logger.log(32, string);
            throw new BrokerException(string, exception);
        }
        finally {
            if (cursor != null) {
                try {
                    cursor.close();
                }
                catch (Exception exception) {
                    this.logger.log(16, "Failed to close cursor in getting all properties from store: " + exception.getMessage());
                }
            }
        }
    }

    protected void clearAll(Transaction transaction) throws BrokerException {
        Cursor cursor = null;
        try {
            DatabaseEntry databaseEntry = new DatabaseEntry();
            DatabaseEntry databaseEntry2 = new DatabaseEntry();
            databaseEntry2.setPartial(0, 0, true);
            cursor = this.db.openCursor(transaction, null);
            while (cursor.getNext(databaseEntry, databaseEntry2, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                cursor.delete();
            }
            cursor.close();
        }
        catch (Exception exception) {
            String string = "Failed to clear all properties from store";
            this.logger.logStack(32, string, exception);
            throw new BrokerException(string, exception);
        }
        finally {
            if (cursor != null) {
                try {
                    cursor.close();
                }
                catch (Exception exception) {
                    this.logger.log(16, "Failed to close cursor in clearing all propertiers from store: " + exception.getMessage());
                }
            }
        }
    }

    protected void close() {
        if (Store.getDEBUG()) {
            this.logger.log(8, "PropertiesStore: closing " + this.db.count() + " with properties");
        }
    }

    protected Hashtable getDebugState() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("dbCount", String.valueOf(this.db.count()));
        hashtable.put("dbConfig", this.db.getConfig().toString());
        return hashtable;
    }
}

